/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.compiler.Version;
import com.iscobol.interfaces.compiler.ICall;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Call
extends Verb
implements CobolToken,
ErrorsNumbers,
ICall {
    private static final String prefix = "call$";
    private static final String startStubSignature = "// Veryant Stub Signature:";
    private Token nameToken;
    private VariableName nameVar;
    private VerbList usings = new VerbList();
    private VariableName returning;
    private BlockException onException;
    private Block notOnException;
    private boolean thread;
    private boolean run;
    private VariableName threadHandle;
    private boolean client;
    private boolean program;
    private boolean not;
    private boolean forceDynamic;
    private boolean debug;

    public Call(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.forceDynamic = tokenManager.getOptionList().getOption("-sc") == null;
        this.debug = tokenManager.getOptionList().getOption("-d") != null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 328) {
            this.client = true;
            token2 = this.tm.getToken();
        } else if (token2.getToknum() == 653) {
            this.program = true;
            token2 = this.tm.getToken();
        }
        if (!this.program) {
            if (token2.getToknum() == 526 || token2.getToknum() == 763) {
                if (token2.getToknum() == 526 && (token2 = this.tm.getToken()).getToknum() != 763) {
                    throw new ExpectedFoundException(token2, this.error, "'THREAD'");
                }
                this.thread = true;
                token2 = this.tm.getToken();
            } else if (token2.getToknum() == 703) {
                this.run = true;
                token2 = this.tm.getToken();
            }
        }
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.nameVar = VariableName.get(this.tm, this.error, this.pc);
        } else if (token2.getToknum() == 10001) {
            this.nameToken = token2;
            if (!this.forceDynamic && !this.client) {
                this.pc.setCall(this.nameToken);
            }
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
        if (this.thread) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 510) {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 526) {
                    this.tm.ungetToken();
                }
                this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
                if (this.threadHandle == null) {
                    token2 = this.tm.getToken();
                    throw new UnexpectedTokenException(token2, this.error);
                }
                if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
                    throw new ClauseClashException(token2, this.error, this.threadHandle.getName());
                }
            } else {
                this.tm.ungetToken();
            }
        }
        if ((token2 = this.tm.getToken()).getToknum() == 802) {
            token2 = Call.getUsing(token, block, pcc, tokenManager, errors, this.usings);
        }
        if (token2.getToknum() == 694 || token2.getToknum() == 505) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 542) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1, true));
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 802) {
            if (this.usings.getItemNum() > 0) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = Call.getUsing(token, block, pcc, tokenManager, errors, this.usings);
        }
        if (token2.getToknum() == 598 || token2.getToknum() == 613 || token2.getToknum() == 472 || token2.getToknum() == 624) {
            Token token3;
            boolean bl = false;
            if (token2.getToknum() == 598) {
                this.not = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 613) {
                bl = true;
                token2 = this.tm.getToken();
            }
            if ((token3 = token2).getToknum() == 472 || token3.getToknum() == 624) {
                if (this.not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(CallOverflowException.class));
                }
                TokenManager.Marker marker = this.tm.getMarker();
                this.tm.setMarker(marker);
                token2 = this.tm.getToken();
                if (!this.not && token2.getToknum() == 598) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 613) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != token3.getToknum()) {
                        this.tm.rewindToMarker(marker);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (bl) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 425) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    static Token getUsing(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, VerbList verbList) throws GeneralErrorException, EndOfProgramException {
        Token token2;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        while ((token2 = tokenManager.getToken()).getToknum() == 312 || token2.getToknum() == 371 || token2.getToknum() == 803 || token2.getToknum() == 676 || token2.getToknum() == 10009 || token2.getToknum() == 10001 || token2.getToknum() == 10002 || token2.getToknum() == 10017 || token2.getToknum() == 612) {
            tokenManager.ungetToken();
            verbList.addItem(new Using(token, block, pcc, tokenManager, errors, blArray, blArray2));
        }
        return token2;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.program && this.notOnException != null) {
            throw new ClauseClashException(this.keyWord, this.error, "NOT ON EXCEPTION");
        }
    }

    public static String getObjName(Token token) {
        if (token != null) {
            return prefix + token.getCode().trim().toUpperCase();
        }
        return "null";
    }

    public static String getClassName(Token token) {
        if (token != null) {
            return token.getCode().trim().toUpperCase();
        }
        return "Object";
    }

    @Override
    protected void getCodeDebug(StringBuffer stringBuffer) {
        super.getCodeDebug(stringBuffer);
        if (this.debug) {
            stringBuffer.append("Debugger.isIscobolDebugger(");
            if (this.nameToken != null) {
                stringBuffer.append("\"" + this.nameToken.getCode().toUpperCase() + "\"");
            } else {
                stringBuffer.append(this.nameVar.getCode() + ".toString().trim()");
            }
            stringBuffer.append(");" + eol + this.parent.getIndent());
        }
    }

    @Override
    public String getCode() {
        Object object;
        Object object2;
        boolean bl = this.tm.getOptionList().getOption("-ssnl") != null;
        boolean bl2 = this.tm.getOptionList().getOption("-ssnu") != null;
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.onException != null || this.notOnException != null || !this.tm.isPropagate()) {
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            string = string + "   ";
        }
        if (this.program && !this.pc.isFactory()) {
            stringBuffer.append(string);
            if (this.pc.getSplitFlag()) {
                stringBuffer.append(this.pc.getClassName() + ".this.");
            } else {
                object2 = this.pc.getRoot();
                if (object2 != this.pc) {
                    if (this.pc.isDefault()) {
                        stringBuffer.append("$This$.");
                    } else {
                        stringBuffer.append(((Pcc)object2).getFullClassName() + ".this.");
                    }
                }
            }
            stringBuffer.append("finalize();");
            stringBuffer.append(eol);
        }
        object2 = null;
        if (this.returning == null) {
            if (this.thread || this.run) {
                object2 = this.getReturnCode();
            } else {
                stringBuffer.append(this.getReturnCode());
                stringBuffer.append(".set(");
            }
        }
        if (this.returning != null) {
            if (this.returning.getVarDecl().isObjectReference()) {
                stringBuffer.append(this.returning.getCode());
                stringBuffer.append("=(");
                stringBuffer.append(this.returning.getVarDecl().getTypeName());
                stringBuffer.append(")");
            } else if (this.thread || this.run) {
                object2 = this.returning.getCode();
            } else {
                stringBuffer.append("((CobolVar)");
            }
        }
        if (this.program) {
            stringBuffer.append("Factory.callProgram (");
        } else if (this.thread) {
            if (this.client) {
                if (this.debug) {
                    stringBuffer.append("Debugger.clientCallThread (");
                } else {
                    stringBuffer.append("Factory.clientCallThread (");
                }
            } else if (this.debug) {
                stringBuffer.append("Debugger.callThread (");
            } else {
                stringBuffer.append("Factory.callThread (");
            }
            if (this.threadHandle == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.threadHandle.getCode());
            }
            stringBuffer.append(", ");
        } else if (this.run) {
            if (this.client) {
                if (this.debug) {
                    stringBuffer.append("Debugger.clientCallRun (");
                } else {
                    stringBuffer.append("Factory.clientCallRun (");
                }
            } else if (this.debug) {
                stringBuffer.append("Debugger.callRun (");
            } else {
                stringBuffer.append("Factory.callRun (");
            }
        } else if (this.client) {
            stringBuffer.append("Factory.clientCall (");
        } else {
            stringBuffer.append("Factory.call (");
        }
        if (this.nameToken != null) {
            stringBuffer.append("\"");
            object = this.nameToken.getCode().trim();
            if (bl) {
                stringBuffer.append(((String)object).toLowerCase());
            } else if (bl2) {
                stringBuffer.append(((String)object).toUpperCase());
            } else {
                stringBuffer.append((String)object);
            }
            stringBuffer.append("\", ");
            if (!this.client) {
                if (this.forceDynamic) {
                    stringBuffer.append("null,");
                } else {
                    stringBuffer.append(Call.getObjName(this.nameToken));
                    stringBuffer.append(",");
                }
            }
        } else {
            stringBuffer.append(this.nameVar.getCode());
            if (bl) {
                stringBuffer.append(".toString().trim().toLowerCase(), ");
            } else if (bl2) {
                stringBuffer.append(".toString().trim().toUpperCase(), ");
            } else {
                stringBuffer.append(".toString().trim(), ");
            }
            if (!this.client) {
                stringBuffer.append("null, ");
            }
        }
        if (this.usings.getItemNum() > 0) {
            boolean bl3 = false;
            object = (Using)this.usings.getFirst();
            while (object != null && !(bl3 = !((Using)object).isCobolVar())) {
                object = (Using)this.usings.getNext();
            }
            if (bl3) {
                stringBuffer.append("new Object[] {");
            } else {
                stringBuffer.append("new CobolVar[] {");
            }
            object = (Using)this.usings.getFirst();
            while (true) {
                stringBuffer.append(((Using)object).getCode());
                object = (Using)this.usings.getNext();
                if (object == null) break;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null");
        }
        if (object2 != null) {
            stringBuffer.append(", " + (String)object2);
        }
        if (this.debug && (this.thread || this.run)) {
            stringBuffer.append(", debugger$helper");
        }
        stringBuffer.append(")");
        if (!(this.returning == null || this.returning.getVarDecl().isObjectReference() || this.thread || this.run)) {
            stringBuffer.append(").moveTo(");
            if (!this.returning.hasSubValue() && this.returning.getVarDecl().isVariableLengthGroup()) {
                stringBuffer.append("(CobolVar)");
            }
            stringBuffer.append(this.returning.getCode());
            stringBuffer.append(")");
        }
        if (this.returning == null && !this.thread && !this.run) {
            stringBuffer.append(");");
        } else {
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null || !this.tm.isPropagate()) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} catch (CallOverflowException ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            if (this.onException != null) {
                stringBuffer.append(this.onException.getCode());
            } else if (this.notOnException == null && !this.tm.isPropagate()) {
                stringBuffer.append("{ throw new WrapperException (");
                stringBuffer.append(this.parent.getExceptName());
                stringBuffer.append("); }");
            } else {
                stringBuffer.append("{ }");
            }
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        if (this.pc.isEasyCallStub()) {
            this.pc.setCallEasyStub(this);
        }
        return stringBuffer.toString();
    }

    @Override
    public Token getNameToken() {
        return this.nameToken;
    }

    @Override
    public VariableName getNameVar() {
        return this.nameVar;
    }

    @Override
    public VerbList getUsings() {
        return this.usings;
    }

    @Override
    public VariableName getReturning() {
        return this.returning;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    public String getName() {
        return (this.nameToken != null ? this.nameToken.getWord() : this.nameVar.getName()).toUpperCase().replace("-", "_").replace("\"", "").replace("'", "");
    }

    @Override
    public boolean isPropagate() {
        return this.tm.isPropagate();
    }

    public HashMap<String, String> getCallStubCode(boolean bl) {
        String string;
        File file;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getName();
        VariableDeclaration variableDeclaration = null;
        HashSet<String> hashSet = new HashSet<String>();
        Using using = null;
        boolean bl2 = false;
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Object var11_11 = null;
        boolean bl3 = bl;
        try {
            String string3;
            BufferedReader bufferedReader;
            if (bl) {
                string2 = string2 + "_" + this.usings.getItemNum();
                String string4 = Pcc.getEasyLinkageFileName(this.getName() + ".java", false, this.tm);
                file = new File(string4);
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new FileReader(string4));
                    string3 = bufferedReader.readLine();
                    if (string3 != null && !string3.contains("filling Stub")) {
                        hashMap.put(this.copyMainStub(bufferedReader, string3, file), string3);
                        string2 = string2 + "_0";
                    }
                    bufferedReader.close();
                }
            }
            string = Pcc.getEasyLinkageFileName(string2 + ".java", false, this.tm);
            file = new File(string);
            boolean bl4 = false;
            int n3 = 0;
            String string5 = string2;
            while (file.exists() && !bl4) {
                bufferedReader = new BufferedReader(new FileReader(string));
                string3 = bufferedReader.readLine();
                if (string3.equals(this.getStubSignature())) {
                    bl4 = true;
                } else if (string2.equals(this.getName()) && !string3.contains("filling Stub")) {
                    hashMap.put(this.copyMainStub(bufferedReader, string3, file), string3);
                    string2 = string2 + "_" + this.usings.getItemNum();
                } else {
                    if (bl3) {
                        string2 = string5 + "_" + n3++;
                    } else {
                        bl3 = true;
                        string5 = string2 = string5 + "_" + this.usings.getItemNum();
                    }
                    string = Pcc.getEasyLinkageFileName(string2 + ".java", false, this.tm);
                    file = new File(string);
                }
                hashMap.put(string2, string3);
            }
            if (bl4) {
                System.out.println(string + " already exists");
                return hashMap;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.pc.callStubs.contains(string2)) {
            return hashMap;
        }
        this.pc.callStubs.add(string2);
        stringBuffer.append(this.getStubSignature());
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("/**" + eol);
        stringBuffer.append(" * Class generated by isCobol compiler for EasyLinkage feature callStub" + eol);
        stringBuffer.append(" * " + Version.getRelease() + eol);
        stringBuffer.append(" * " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append(" * compiler options: " + this.pc.getOptions().getAll().replace('\\', '/') + eol);
        stringBuffer.append(" */");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        string = Config.a(".compiler.easylinkage.package", null);
        if (string != null) {
            stringBuffer.append("package " + string + ";" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("import com.iscobol.java.IsCobol;" + eol);
        stringBuffer.append("import com.iscobol.java.StopRunAsException;" + eol);
        stringBuffer.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (this.pc.getOptions().getOption("-xms") == null && this.pc.getOptions().getOption("-cp") == null) {
            stringBuffer.append("import com.iscobol.rts.Factory;" + eol);
            stringBuffer.append("import com.iscobol.rts.IscobolCall;" + eol);
            stringBuffer.append("import com.iscobol.types.*;" + eol);
        } else {
            stringBuffer.append("import com.iscobol.rts_n.Factory;" + eol);
            stringBuffer.append("import com.iscobol.rts.Memory;" + eol);
            stringBuffer.append("import com.iscobol.rts.IscobolCall;" + eol);
            stringBuffer.append("import com.iscobol.types_n.*;" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("public class " + string2 + " implements IscobolCall {" + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("   // Linkage variable declarations" + eol);
        stringBuffer.append(eol);
        String string6 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        if (this.returning != null) {
            variableDeclaration = this.returning.getVarDecl();
            hashSet.add(variableDeclaration.getName());
            stringBuffer.append("   //  returnig variable declaration " + variableDeclaration.getName() + eol);
            stringBuffer3.append("    {" + eol + "      ");
            stringBuffer.append(variableDeclaration.getCode(string6, stringBuffer3, true));
            stringBuffer3.append("    }" + eol);
        } else {
            variableDeclaration = this.pc.fixedVars.getFirst();
            while (variableDeclaration != null) {
                if (!hashSet.contains(variableDeclaration.getName())) {
                    stringBuffer3.append("    {" + eol + "      ");
                    stringBuffer.append(variableDeclaration.getCode(string6, stringBuffer3, true));
                    stringBuffer3.append("    }" + eol);
                    hashSet.add(variableDeclaration.getName());
                }
                variableDeclaration = this.pc.fixedVars.getNext();
            }
        }
        stringBuffer.append(eol);
        if (this.usings.getItemNum() > 0) {
            n2 = 0;
            using = (Using)this.usings.getFirst();
            while (using != null) {
                ++n2;
                stringBuffer.append("   //  variable declaration " + using.getNameObj() + eol);
                if (using.getNameObj() != null && using.getNameObj() instanceof VariableName) {
                    variableDeclaration = ((VariableName)using.getNameObj()).getVarDecl();
                    while (variableDeclaration.getParent() != null) {
                        variableDeclaration = variableDeclaration.getParent();
                    }
                    if (variableDeclaration.getRedefinesVar() != null && !hashSet.contains(variableDeclaration.getRedefinesVar().getName())) {
                        stringBuffer3.append("    {" + eol + "      ");
                        stringBuffer.append(variableDeclaration.getRedefinesVar().getCode(string6, stringBuffer3, true));
                        stringBuffer3.append("    }" + eol);
                        hashSet.add(variableDeclaration.getRedefinesVar().getName());
                    }
                    if (!hashSet.contains(variableDeclaration.getName())) {
                        stringBuffer3.append("    {" + eol + "      ");
                        stringBuffer.append(variableDeclaration.getCode(string6, stringBuffer3, true));
                        stringBuffer3.append("    }" + eol);
                        hashSet.add(variableDeclaration.getName());
                    } else {
                        stringBuffer.append("   //        declaration not needed for " + using.getNameObj() + eol);
                    }
                } else if (using.getNameToken().getToknum() == 10001) {
                    stringBuffer.append("   String par" + n2 + " = \"\";" + eol);
                } else if (using.getNameToken().getToknum() == 10002) {
                    stringBuffer.append("   long par" + n2 + " = 0;" + eol);
                } else if (using.getNameToken().getToknum() == 10017) {
                    stringBuffer.append("   float par" + n2 + " = \"\";" + eol);
                }
                using = (Using)this.usings.getNext();
            }
        }
        stringBuffer.append(eol);
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        stringBuffer.append("   public void perform(int arg0, int arg1) {" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   public Object call(Object[] argv) {" + eol);
        stringBuffer.append("      final int argl=(argv==null)?0:argv.length;");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("      switch (argl) {");
        stringBuffer.append(eol);
        stringBuffer.append("      default:" + eol);
        stringBuffer2.append(" *   try {" + eol);
        stringBuffer2.append(" *      ");
        if (this.returning != null) {
            stringBuffer2.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            stringBuffer2.append("returnCode");
        }
        stringBuffer2.append(".set(Factory.call(\"_new_" + string2 + "\", null," + eol);
        using = (Using)this.usings.getFirst();
        while (using != null && !(bl2 = !using.isCobolVar())) {
            using = (Using)this.usings.getNext();
        }
        if (bl2) {
            stringBuffer2.append(" *                                  new Object[]   {");
        } else {
            stringBuffer2.append(" *                                  new CobolVar[] {");
        }
        n2 = 0;
        for (int i2 = this.usings.getItemNum(); i2 > 0; --i2) {
            ++n2;
            stringBuffer.append("      case ");
            stringBuffer.append(i2);
            stringBuffer.append(": ");
            using = (Using)this.usings.getAt(i2 - 1);
            if (n2 > 1) {
                stringBuffer2.append("," + eol + " *                                               ");
            }
            if (using.getNameObj() != null && using.getNameObj() instanceof VariableName) {
                variableDeclaration = ((VariableName)using.getNameObj()).getVarDecl();
                stringBuffer.append(variableDeclaration.getDeclUnivoqueName(true, true));
                stringBuffer2.append(variableDeclaration.getDeclUnivoqueName(true, true));
                if (variableDeclaration.isObjectReference()) {
                    stringBuffer.append("=(");
                    stringBuffer.append(variableDeclaration.getTypeName());
                    stringBuffer.append(")argv[");
                    stringBuffer.append(i2 - 1);
                    stringBuffer.append("];");
                } else {
                    stringBuffer.append(".link((CobolVar)argv[");
                    stringBuffer.append(i2 - 1);
                    stringBuffer.append("]);");
                }
                stringBuffer.append(eol);
                if (using.byValue) {
                    stringBuffer2.append(".byVal()");
                    continue;
                }
                stringBuffer2.append(".byRef()");
                continue;
            }
            if (using.getNameToken().getToknum() == 10001) {
                stringBuffer.append("    par" + i2 + " = ((PicX)argv[" + (i2 - 1) + "]).toString();" + eol);
            } else if (using.getNameToken().getToknum() == 10002) {
                stringBuffer.append("    par" + i2 + " = ((NumericVar)argv[" + (i2 - 1) + "]).tolong();" + eol);
            } else if (using.getNameToken().getToknum() == 10017) {
                stringBuffer.append("    par" + i2 + " = ((NumericVar)argv[" + (i2 - 1) + "]).tofloat();" + eol);
            }
            stringBuffer2.append("par" + n2);
        }
        stringBuffer2.append("}));" + eol);
        stringBuffer2.append(" *   }" + eol);
        stringBuffer2.append(" *   catch (CallOverflowException ex) {" + eol);
        stringBuffer2.append(" *      throw new WrapperException(ex);" + eol);
        stringBuffer2.append(" *   }" + eol);
        stringBuffer2.append(" *      ");
        stringBuffer.append("      case 0: break;");
        stringBuffer.append(eol);
        stringBuffer.append("      }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("/*  Write here the routine logic" + eol);
        stringBuffer.append(" *        This is the call prototype:" + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(stringBuffer2.toString() + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append("*/" + eol);
        stringBuffer.append("      return ");
        if (this.returning != null) {
            stringBuffer.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            stringBuffer.append("returnCode");
        }
        stringBuffer.append(";" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        Pcc.declareFinalize(stringBuffer, "   ");
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("}" + eol);
        hashMap.put(string2, this.getStubSignature());
        try {
            String string7 = Pcc.getEasyLinkageFileName(string2 + ".java", false, this.tm);
            file = new File(string7);
            if (file.exists()) {
                System.out.println(string7 + " already exists");
            } else {
                PrintWriter printWriter = PreProcessor.newPrintWriter(string7);
                printWriter.print(stringBuffer.toString());
                printWriter.close();
                System.out.println("Generated '" + string7 + "'");
            }
            return hashMap;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return hashMap;
        }
    }

    public String getStubSignature() {
        String string = startStubSignature;
        VariableDeclaration variableDeclaration = null;
        Using using = null;
        string = string + " parameters number=" + this.usings.getItemNum() + " parameters lengths=";
        for (int i2 = 0; i2 < this.usings.getItemNum(); ++i2) {
            using = (Using)this.usings.getAt(i2);
            if (i2 > 0) {
                string = string + ",";
            }
            if (using.getNameObj() == null || !(using.getNameObj() instanceof VariableName)) continue;
            variableDeclaration = ((VariableName)using.getNameObj()).getVarDecl();
            string = string + variableDeclaration.getPhisicLen();
        }
        return string;
    }

    public void getCallFillingStubCode(Map<String, String> map) {
        VariableDeclaration variableDeclaration;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Map<String, String> map2 = map;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = Pcc.getEasyLinkageFileName(this.getName() + ".java", false, this.tm);
        File file = new File(string2);
        String string3 = file.getAbsolutePath();
        string3 = string3.substring(0, string3.lastIndexOf(File.separator));
        File file2 = new File(string3);
        File[] fileArray = file2.listFiles();
        try {
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    if (!fileArray[i2].getName().startsWith(this.getName())) continue;
                    String string4 = Pcc.getEasyLinkageFileName(fileArray[i2].getName(), false, this.tm);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i2]));
                    String string5 = bufferedReader.readLine();
                    if (string5 != null && string5.startsWith(startStubSignature) && !string5.contains("filling")) {
                        map2.put(fileArray[i2].getName().replace(".java", ""), string5);
                    }
                    bufferedReader.close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.pc.callStubs.add(this.getName());
        stringBuffer.append("// Veryant Stub Signature: filling Stub " + this.getName());
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("/**" + eol);
        stringBuffer.append(" * Class generated by isCobol compiler for EasyLinkage feature callStub" + eol);
        stringBuffer.append(" * " + Version.getRelease() + eol);
        stringBuffer.append(" * " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append(" * compiler options: " + this.pc.getOptions().getAll().replace('\\', '/') + eol);
        stringBuffer.append(" */");
        stringBuffer.append(eol);
        String string6 = Config.a(".compiler.easylinkage.package", null);
        if (string6 != null) {
            stringBuffer.append("package " + string6 + ";" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("import com.iscobol.java.IsCobol;" + eol);
        stringBuffer.append("import com.iscobol.java.StopRunAsException;" + eol);
        stringBuffer.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (this.pc.getOptions().getOption("-xms") == null && this.pc.getOptions().getOption("-cp") == null) {
            stringBuffer.append("import com.iscobol.rts.Factory;" + eol);
            stringBuffer.append("import com.iscobol.rts.IscobolCall;" + eol);
            stringBuffer.append("import com.iscobol.types.*;" + eol);
        } else {
            stringBuffer.append("import com.iscobol.rts_n.Factory;" + eol);
            stringBuffer.append("import com.iscobol.rts.Memory;" + eol);
            stringBuffer.append("import com.iscobol.rts.IscobolCall;" + eol);
            stringBuffer.append("import com.iscobol.types_n.*;" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("public class " + this.getName() + " implements IscobolCall {" + eol);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.returning != null) {
            variableDeclaration = this.returning.getVarDecl();
            stringBuffer.append("   //  returnig variable declaration " + variableDeclaration.getName() + eol);
            stringBuffer2.append("    {" + eol + "      ");
            stringBuffer.append(variableDeclaration.getCode(string, stringBuffer2, true));
            stringBuffer2.append("    }" + eol);
        } else {
            variableDeclaration = this.pc.fixedVars.getFirst();
            while (variableDeclaration != null) {
                if (!hashSet.contains(variableDeclaration.getName())) {
                    stringBuffer2.append("    {" + eol + "      ");
                    stringBuffer.append(variableDeclaration.getCode(string, stringBuffer2, true));
                    stringBuffer2.append("    }" + eol);
                    hashSet.add(variableDeclaration.getName());
                }
                variableDeclaration = this.pc.fixedVars.getNext();
            }
        }
        stringBuffer.append(eol);
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        stringBuffer.append("   public void perform(int arg0, int arg1) {" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   public Object call(Object[] argv) {" + eol);
        stringBuffer.append("      final int argl=(argv==null)?0:argv.length;");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
        int n2 = 0;
        String string7 = "";
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string8 = entry.getValue();
            if (!entry.getKey().startsWith(this.getName()) || entry.getKey().length() <= this.getName().length() || entry.getKey().charAt(this.getName().length()) != '_') continue;
            if (string7.length() == 0) {
                stringBuffer.append("      ");
            } else {
                stringBuffer.append("      else ");
            }
            string7 = string8.substring(string8.indexOf("=") + 1);
            n2 = Integer.parseInt(string7.substring(0, string7.indexOf(" ")));
            string7 = string8.substring(string8.lastIndexOf("=") + 1);
            stringBuffer.append("if (argl == " + n2);
            int n3 = 0;
            for (String string9 : string7.split(",")) {
                if (string9.length() > 0) {
                    stringBuffer.append(" && ((CobolVar)argv[" + n3 + "]).getMaxLength() == " + string9);
                }
                ++n3;
            }
            stringBuffer.append(")");
            stringBuffer.append(eol);
            stringBuffer.append("        ");
            if (this.returning != null) {
                stringBuffer.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
            } else {
                stringBuffer.append("returnCode");
            }
            stringBuffer.append(".set(Factory.call(\"" + entry.getKey() + "\", null, argv));");
            stringBuffer.append(eol);
        }
        stringBuffer.append("      return ");
        if (this.returning != null) {
            stringBuffer.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            stringBuffer.append("returnCode");
        }
        stringBuffer.append(";" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   @Override" + eol);
        Pcc.declareFinalize(stringBuffer, "   ");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("}" + eol);
        try {
            String[] stringArray = PreProcessor.newPrintWriter(string2);
            stringArray.print(stringBuffer.toString());
            stringArray.close();
            System.out.println("Generated fillingStub '" + string2 + "'");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String copyMainStub(BufferedReader bufferedReader, String string, File file) {
        String string2 = string.substring(string.indexOf("=") + 1);
        int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
        String string3 = this.getName() + "_" + n2;
        try {
            String string4 = Pcc.getEasyLinkageFileName(string3 + ".java", false, this.tm);
            File file2 = new File(string4);
            if (file2.exists()) {
                System.out.println("Unexpected " + string4 + " already exists without filling Stub");
            } else {
                PrintWriter printWriter = PreProcessor.newPrintWriter(string4);
                while (string != null) {
                    string2 = string.replace(this.getName(), string3) + eol;
                    printWriter.print(string2);
                    string = bufferedReader.readLine();
                }
                printWriter.close();
                bufferedReader.close();
                file.delete();
                System.out.println("Generated copying '" + string4 + "'");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string3;
    }
}

