/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Cancel
extends Verb
implements CobolToken,
ErrorsNumbers {
    private TokenList nameToken = new TokenList();
    private VariableNameList nameVar = new VariableNameList();
    private boolean forceDynamic;
    private boolean all;
    private boolean client;

    public Cancel(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.forceDynamic = tokenManager.getOptionList().getOption("-sc") == null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 328) {
            this.client = true;
        } else {
            this.tm.ungetToken();
        }
        while (true) {
            if ((token2 = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                this.nameVar.addItem(VariableName.get(this.tm, this.error, this.pc));
                continue;
            }
            if (token2.getToknum() == 10001) {
                this.nameToken.addItem(token2);
                if (this.forceDynamic || this.client) continue;
                this.pc.setCall(token2);
                continue;
            }
            if (token2.getToknum() != 262) break;
            this.all = true;
        }
        this.tm.ungetToken();
        if (this.nameVar.getItemNum() == 0 && this.nameToken.getItemNum() == 0 && !this.all) {
            throw new UnexpectedTokenException(token2, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.all) {
            if (this.client) {
                stringBuffer.append("Factory.clientCancelAll ();");
            } else {
                stringBuffer.append("Factory.cancelAll ();");
            }
        } else {
            Token token = this.nameToken.getFirst();
            while (token != null) {
                if (this.client) {
                    stringBuffer.append("Factory.clientCancel (");
                } else {
                    stringBuffer.append("Factory.cancel (");
                }
                stringBuffer.append("\"");
                stringBuffer.append(token.getCode().trim());
                stringBuffer.append("\");");
                if (!this.forceDynamic && !this.client) {
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(Call.getObjName(token));
                    stringBuffer.append(" = new ");
                    stringBuffer.append(Call.getClassName(token));
                    stringBuffer.append("();");
                }
                stringBuffer.append(eol);
                token = this.nameToken.getNext();
            }
            VariableName variableName = this.nameVar.getFirst();
            while (variableName != null) {
                if (this.client) {
                    stringBuffer.append("Factory.clientCancel (");
                } else {
                    stringBuffer.append("Factory.cancel (");
                }
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".toString().trim());");
                stringBuffer.append(eol);
                variableName = this.nameVar.getNext();
            }
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public TokenList getNameTokens() {
        return this.nameToken;
    }

    public VariableNameList getNameVars() {
        return this.nameVar;
    }

    public boolean isAll() {
        return this.all;
    }
}

