/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.rts.CallOverflowException;

public class Chain
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token nameToken;
    private VariableName nameVar;
    private VerbList usings = new VerbList();
    private BlockException onException;
    private boolean debug;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chain(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.debug = tokenManager.getOptionList().getOption("-d") != null;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.nameVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            if (token2.getToknum() != 10001) throw new UnexpectedTokenException(token2, this.error);
            this.nameToken = token2;
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 802) {
            token2 = Chain.getUsing(token, block, pcc, tokenManager, errors, this.usings);
        }
        if (token2.getToknum() == 613 || token2.getToknum() == 472 || token2.getToknum() == 624) {
            Token token3;
            if (token2.getToknum() == 613) {
                token2 = this.tm.getToken();
            }
            if ((token3 = token2).getToknum() != 472 && token3.getToknum() != 624) throw new ExpectedFoundException(token2, this.error, "EXCEPTION");
            this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(CallOverflowException.class));
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 426) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    static Token getUsing(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, VerbList verbList) throws GeneralErrorException, EndOfProgramException {
        Token token2;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        while ((token2 = tokenManager.getToken()).getToknum() == 10009 || token2.getToknum() == 10001 || token2.getToknum() == 10002 || token2.getToknum() == 10017 || token2.getToknum() == 612) {
            tokenManager.ungetToken();
            verbList.addItem(new Using(token, block, pcc, tokenManager, errors, blArray, blArray2));
        }
        return token2;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    protected void getCodeDebug(StringBuffer stringBuffer) {
        super.getCodeDebug(stringBuffer);
        if (this.debug) {
            stringBuffer.append("Debugger.isIscobolDebugger(");
            if (this.nameToken != null) {
                stringBuffer.append("\"" + this.nameToken.getCode().toUpperCase() + "\"");
            } else {
                stringBuffer.append(this.nameVar.getCode() + ".toString().trim()");
            }
            stringBuffer.append(");" + eol + this.parent.getIndent());
        }
    }

    @Override
    public String getCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.onException != null || !this.tm.isPropagate()) {
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            string = string + "   ";
        }
        stringBuffer.append("Factory.chainProgram (");
        if (this.nameToken != null) {
            stringBuffer.append("\"");
            stringBuffer.append(this.nameToken.getCode());
            stringBuffer.append("\", ");
        } else {
            stringBuffer.append(this.nameVar.getCode());
            stringBuffer.append(".toString().trim(), ");
        }
        if (this.usings.getItemNum() > 0) {
            boolean bl = false;
            Using using = (Using)this.usings.getFirst();
            while (using != null && !(bl = !using.isCobolVar())) {
                using = (Using)this.usings.getNext();
            }
            if (bl) {
                stringBuffer.append("new Object[] {");
            } else {
                stringBuffer.append("new CobolVar[] {");
            }
            using = (Using)this.usings.getFirst();
            while (true) {
                stringBuffer.append(using.getCode());
                using = (Using)this.usings.getNext();
                if (using == null) break;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        if (this.onException != null || !this.tm.isPropagate()) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} catch (CallOverflowException ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            if (this.onException != null) {
                stringBuffer.append(this.onException.getCode());
            } else {
                stringBuffer.append("{ }");
            }
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

