/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.ArrayList;
import java.util.List;

public class Close
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int HND_NO_HANDLE = 0;
    private final List filesToClose;
    boolean closeWindow = false;
    boolean withNoDisplay = false;
    VariableName varName = null;
    boolean ishandle;
    boolean closePopup;
    private boolean httpUnsupportedLog = this.pc.getOption("-whttp") != null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Close(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.filesToClose = new ArrayList();
        boolean bl = false;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 812) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, token2, "CLOSE");
            }
            this.closeWindow = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) return;
            this.tm.ungetToken();
            this.varName = VariableName.get(this.tm, this.error, this.pc);
            this.ishandle = this.isHandle(this.varName);
            if (!this.ishandle) {
                throw new GeneralErrorException(96, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
                bl = true;
            }
            if (token2.getToknum() == 596) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 408) {
                    this.withNoDisplay = true;
                    return;
                } else {
                    if (bl) {
                        this.tm.ungetToken();
                    }
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                }
                return;
            } else {
                if (bl) {
                    this.tm.ungetToken();
                }
                this.tm.ungetToken();
            }
            return;
        } else if (token2.getToknum() == 639) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, token, token.getWord());
            }
            this.closePopup = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) return;
            this.tm.ungetToken();
            this.varName = VariableName.get(this.tm, this.error, this.pc);
            if (this.varName == null) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 813) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 373) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 10001) return;
                if (token2.getToknum() != 10009) throw new UnexpectedTokenException(token2, this.error);
                this.tm.ungetToken();
                VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        } else {
            while (token2.getToknum() == 10009) {
                Select select = this.pc.getSelect(token2.getWord());
                if (select == null) {
                    throw new GeneralErrorException(53, 4, token2, token2.getWord(), this.error);
                }
                if (select.isSort()) {
                    throw new GeneralErrorException(103, 4, token2, token2.getWord(), this.error);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 813 || token2.getToknum() == 675 || token2.getToknum() == 785 || token2.getToknum() == 596 || token2.getToknum() == 570) {
                    if (token2.getToknum() == 813) {
                        token2 = this.tm.getToken();
                    }
                    switch (token2.getToknum()) {
                        case 675: 
                        case 785: {
                            token2 = this.tm.getToken();
                            bl2 = true;
                            break;
                        }
                        case 570: {
                            token2 = this.tm.getToken();
                            bl3 = true;
                            break;
                        }
                        case 596: {
                            token2 = this.tm.getToken();
                            if (token2.getToknum() != 698) {
                                throw new ExpectedFoundException(token2, this.error, "REWIND");
                            }
                            token2 = this.tm.getToken();
                            bl4 = true;
                        }
                    }
                }
                this.filesToClose.add(new FileToClose(select, bl2, bl3, bl4));
            }
            this.tm.ungetToken();
            if (!this.filesToClose.isEmpty()) return;
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.closeWindow) {
            stringBuffer.append(this.parent.getIndent());
            this.getCodeDebug(stringBuffer);
            stringBuffer.append("ScrFactory.getGUIEnviroment().close(");
            if (this.varName != null) {
                stringBuffer.append(this.varName.getCode());
                if (this.withNoDisplay) {
                    stringBuffer.append(", true");
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(";" + eol);
        } else if (this.closePopup) {
            stringBuffer.append(this.parent.getIndent());
            this.getCodeDebug(stringBuffer);
            stringBuffer.append("ScrFactory.getGUIEnviroment().closePopup(");
            stringBuffer.append(this.varName.getCode());
            stringBuffer.append(")");
            stringBuffer.append(";" + eol);
        } else {
            boolean bl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
            this.getCodeDebug(stringBuffer);
            for (FileToClose fileToClose : this.filesToClose) {
                CharSequence charSequence;
                Select select = fileToClose.getSel();
                boolean bl2 = this.pc.getDeclarative(select) != null || bl;
                stringBuffer.append(this.parent.getIndent());
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("try {");
                stringBuffer2.append(eol);
                stringBuffer2.append(this.parent.getIndent());
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append(select.getName());
                if (fileToClose.isReel()) {
                    stringBuffer3.append(".closeReel();");
                } else {
                    stringBuffer3.append(".close(");
                    charSequence = "";
                    if (fileToClose.isNoRewind()) {
                        stringBuffer3.append((String)charSequence);
                        stringBuffer3.append("CobolFile.CLOSE_NO_REWIND");
                        charSequence = "|";
                    }
                    stringBuffer3.append(");");
                }
                stringBuffer3.append(eol);
                if (fileToClose.isLock()) {
                    stringBuffer3.append(this.parent.getIndent());
                    stringBuffer3.append(select.getName());
                    stringBuffer3.append(".setCloseLock();");
                    stringBuffer3.append(eol);
                }
                charSequence = new StringBuffer();
                Use.putFileStatus((StringBuffer)charSequence, select, this.parent.getIndent());
                Use.putDeclaratives((StringBuffer)charSequence, this.pc, select, this.parent.getIndent(), bl2);
                if (select.isPrinter()) {
                    boolean bl3 = this.pc.getOption("-sqlj") != null;
                    stringBuffer.append("if(" + select.getName() + " instanceof com.iscobol.io.DeviceFile == false || !((com.iscobol.io.DeviceFile) ");
                    stringBuffer.append(select.getName());
                    stringBuffer.append(").closeDeferred(");
                    if (bl3) {
                        stringBuffer.append("new Runnable() { public void run() {");
                    } else {
                        stringBuffer.append("() -> {");
                    }
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("try {");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append("((com.iscobol.io.DeviceFile) ");
                    stringBuffer.append(select.getName());
                    stringBuffer.append(").print(");
                    if (fileToClose.isNoRewind()) {
                        stringBuffer.append("CobolFile.CLOSE_NO_REWIND");
                    }
                    stringBuffer.append(");");
                    stringBuffer.append(eol);
                    stringBuffer.append((StringBuffer)charSequence);
                    stringBuffer.append(this.parent.getIndent());
                    String string = this.pc.getOption("-xms") != null || this.pc.getOption("-cp") != null ? "com.iscobol.rts_n." : "";
                    stringBuffer.append("} catch(Throwable t) { " + string + "ErrorBox.show(t); }");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    if (bl3) {
                        stringBuffer.append("}");
                    }
                    stringBuffer.append("})) {");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(stringBuffer3);
                    stringBuffer.append((StringBuffer)charSequence);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("}");
                    stringBuffer.append(eol);
                    continue;
                }
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(stringBuffer3);
                stringBuffer.append((StringBuffer)charSequence);
            }
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    boolean isWHandle(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        if (variableName == null) {
            return false;
        }
        variableDeclaration = this.pc.getVar(variableName);
        return variableDeclaration != null && (variableDeclaration.isWindowHandle() || variableDeclaration.isGenericHandle());
    }

    boolean isHandle(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        if (variableName == null) {
            return false;
        }
        variableDeclaration = this.pc.getVar(variableName);
        return variableDeclaration != null && (variableDeclaration.isWindowHandle() || variableDeclaration.isSubWindowHandle());
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public List getFilesToClose() {
        return this.filesToClose;
    }

    public static class FileToClose {
        private final Select sel;
        private final boolean reel;
        private final boolean lock;
        private final boolean noRewind;

        public FileToClose(Select select, boolean bl, boolean bl2, boolean bl3) {
            this.sel = select;
            this.reel = bl;
            this.lock = bl2;
            this.noRewind = bl3;
        }

        public boolean isReel() {
            return this.reel;
        }

        public boolean isLock() {
            return this.lock;
        }

        public boolean isNoRewind() {
            return this.noRewind;
        }

        public Select getSel() {
            return this.sel;
        }
    }
}

