/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Call;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolMethodList;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.interfaces.compiler.ICobolClass;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;

public class CobolClass
extends Pcc
implements ICobolClass {
    private EnvironmentDivision environment;
    private CobolClass factory;
    private boolean isFactory;
    private CobolMethodList allMethods = new CobolMethodList();
    private StringBuffer declDynPart;
    private StringBuffer declFixedVarPart;
    private String declData;
    private Token firstToken;
    private Token lastToken;
    private StringWriter unnamedMethods;

    public CobolClass(Pcc pcc, CobolClass cobolClass) {
        super(pcc);
        this.parent = pcc;
        this.parent.optionMS = false;
        this.parent.capitalizeNames = false;
        this.parent.tm.optionMs = false;
        if (cobolClass != null) {
            this.factory = cobolClass;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean start() {
        boolean bl = true;
        try {
            Token token;
            switch (this.idDivision()) {
                case -1: {
                    return true;
                }
                case -2: {
                    bl = false;
                    try {
                        this.tm.skipTill(new int[]{458, 388, 705, 651});
                        break;
                    }
                    catch (EndOfProgramException endOfProgramException) {
                        return true;
                    }
                }
            }
            try {
                token = this.tm.getToken();
                if (token.getToknum() == 458) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 410) throw new UnexpectedTokenException(token, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.environment = new EnvironmentDivision(this, this.tm, this.error, token);
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
                this.tm.skipTill(new int[]{388, 705, 651});
            }
            try {
                token = this.tm.getToken();
                if (token.getToknum() == 388) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 410) throw new UnexpectedTokenException(token, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, token);
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
                this.tm.skipTill(new int[]{705, 651});
            }
            try {
                this.parent.checkPost();
                if (this.gEnvironment != null) {
                    this.gEnvironment.check(this);
                }
                if (this.environment != null) {
                    this.environment.check(this);
                }
                if (this.data != null) {
                    this.data.check();
                }
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
            }
            token = this.tm.getToken();
            if (token.getToknum() == 705) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(token);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException generalErrorException) {
                        bl = false;
                        this.tm.skipTill(new int[]{651});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if ((token = this.tm.getToken()).getToknum() == 651) {
                token = this.tm.getToken();
                if (token.getToknum() == 410) {
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                    while ((token = this.tm.getToken()).getToknum() == 522 || token.getToknum() == 521) {
                        this.tm.ungetToken();
                        CobolMethod cobolMethod = new CobolMethod(this);
                        if (bl) {
                            bl = cobolMethod.start();
                        } else {
                            cobolMethod.start();
                        }
                        this.allMethods.addItem(cobolMethod);
                    }
                    this.tm.ungetToken();
                } else {
                    this.error.print(15, 4, token, token.getWord());
                }
            } else {
                this.tm.ungetToken();
            }
            this.parent.checkUsed();
            token = this.tm.getToken();
            if (token.getToknum() == 422) {
                token = this.tm.getToken();
                if (this.isFactory && token.getToknum() != 479) {
                    this.error.print(31, 4, token, "FACTORY/" + token.getWord());
                    bl = false;
                } else if (!this.isFactory && token.getToknum() != 606) {
                    this.error.print(31, 4, token, "OBJECT/" + token.getWord());
                    bl = false;
                } else {
                    Token token2 = this.tm.getToken();
                    if (token2.getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    } else {
                        token = token2;
                    }
                }
                this.lastToken = token;
                return bl;
            } else {
                bl = false;
                if (this.isFactory) {
                    this.error.print(31, 4, token, "END FACTORY/" + token.getWord());
                    return bl;
                } else {
                    this.error.print(31, 4, token, "END OBJECT/" + token.getWord());
                }
            }
            return bl;
        }
        catch (EndOfProgramException endOfProgramException) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            return false;
        }
        catch (GeneralErrorException generalErrorException) {
            this.error.print(11, 4, this.tm.getLineNumber(), 0, generalErrorException.toString(), null, this.tm.getFileName());
            return false;
        }
    }

    private int idDivision() throws GeneralErrorException, EndOfProgramException {
        Token token;
        try {
            token = this.tm.getToken();
        }
        catch (EndOfProgramException endOfProgramException) {
            return -1;
        }
        this.firstToken = token;
        if ((this.firstToken.getToknum() == 522 || token.getToknum() == 521) && (token = this.tm.getToken()).getToknum() == 410) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token, "'.'");
                this.tm.ungetToken();
            }
            if ((token = this.tm.getToken()).getToknum() == 479) {
                this.isFactory = true;
            } else if (token.getToknum() == 606) {
                this.isFactory = false;
            } else {
                throw new UnexpectedTokenException(token, this.error);
            }
            token = this.tm.getToken();
            if (token.getToknum() != 10006) {
                throw new ExpectedFoundException(token, this.error, ".");
            }
            return 0;
        }
        return -2;
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration variableDeclaration = this.data.screenSec.vars.getFirst();
            while (variableDeclaration != null) {
                this.parent.loadVariable(variableDeclaration);
                variableDeclaration.calcOffset(this, 0);
                variableDeclaration = this.data.screenSec.vars.getNext();
            }
        }
    }

    @Override
    public void loadVariable(VariableDeclaration variableDeclaration) {
        this.parent.loadVariable(variableDeclaration);
    }

    @Override
    public boolean addSqlCursor(SqlDeclareCursor sqlDeclareCursor) {
        if (this.isFactory()) {
            return this.parent.addSqlCursor(sqlDeclareCursor);
        }
        return super.addSqlCursor(sqlDeclareCursor);
    }

    protected void doCheck() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        Enumeration enumeration = this.allMethods.elements();
        while (enumeration.hasMoreElements()) {
            CobolMethod cobolMethod;
            CobolMethod cobolMethod2 = (CobolMethod)enumeration.nextElement();
            cobolMethod2.doCheck();
            Enumeration enumeration2 = this.allMethods.elements();
            while (enumeration2.hasMoreElements() && cobolMethod2 != (cobolMethod = (CobolMethod)enumeration2.nextElement())) {
            }
            while (enumeration2.hasMoreElements()) {
                cobolMethod = (CobolMethod)enumeration2.nextElement();
                if (!cobolMethod2.hasSameSignature(cobolMethod)) continue;
                throw new GeneralErrorException(145, 4, 0, 0, cobolMethod2.getMethodName(), this.tm.getFileName(), null, this.error);
            }
        }
    }

    @Override
    boolean getSplitFlag() {
        return this.parent.getSplitFlag();
    }

    protected void doCode(PrintWriter printWriter) throws GeneralErrorException {
        PrintWriter printWriter2 = null;
        this.writeData(printWriter);
        CobolMethod cobolMethod = this.allMethods.getFirst();
        while (cobolMethod != null) {
            if (cobolMethod.isUnnamed()) {
                if (this.unnamedMethods == null) {
                    this.unnamedMethods = new StringWriter();
                    printWriter2 = new PrintWriter(this.unnamedMethods);
                }
                cobolMethod.doCode(printWriter2);
            } else {
                cobolMethod.doCode(printWriter);
            }
            cobolMethod = this.allMethods.getNext();
        }
    }

    protected void doCodeUnnamed(PrintWriter printWriter) {
        if (this.unnamedMethods != null) {
            printWriter.print(this.unnamedMethods);
        }
    }

    private void writeData(PrintWriter printWriter) throws GeneralErrorException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data != null) {
            if (this.isFactory()) {
                this.declData = this.data.getCode(stringBuffer, null);
            } else {
                printWriter.println(this.data.getCode(stringBuffer, null));
            }
        }
        if (this.environment != null) {
            if (this.isFactory()) {
                this.declData = this.declData + this.environment.getCode(stringBuffer);
            } else {
                printWriter.println(this.environment.getCode(stringBuffer));
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        CobolToken cobolToken = this.fixedVars.getFirst();
        while (cobolToken != null) {
            printWriter.println(cobolToken.getCode(stringBuffer2));
            cobolToken = this.fixedVars.getNext();
        }
        if (this.isFactory()) {
            this.declDynPart = stringBuffer;
            this.declFixedVarPart = stringBuffer2;
        } else {
            int n2 = -1;
            object = null;
            if (this.getSplitFlag()) {
                n2 = 0;
                object = "oinner_";
            }
            n2 = this.writeDeclaration(printWriter, stringBuffer, stringBuffer2, false, n2, (String)object, false, false);
            if (this.getSplitFlag()) {
                printWriter.println("   { new " + (String)object + (n2 - 1) + "(); }");
            }
        }
        if (this.calls.size() > 0) {
            object = this.calls.elements();
            while (object.hasMoreElements()) {
                cobolToken = (Token)object.nextElement();
                printWriter.println("public   " + Call.getClassName((Token)cobolToken) + " " + Call.getObjName((Token)cobolToken) + " = new " + Call.getClassName((Token)cobolToken) + "();");
            }
        }
    }

    @Override
    protected int writeLiterals(PrintWriter printWriter, boolean bl) {
        if (this.isFactory()) {
            printWriter.println(this.declData);
            int n2 = -1;
            String string = null;
            if (this.getSplitFlag()) {
                n2 = 0;
                string = "finner_";
            }
            n2 = this.writeDeclaration(printWriter, this.declDynPart, this.declFixedVarPart, true, n2, string, false, false);
            if (this.getSplitFlag()) {
                printWriter.println("   static { new " + string + (n2 - 1) + "(); }");
            }
        }
        return 0;
    }

    @Override
    protected boolean isFactory() {
        return this.isFactory;
    }

    @Override
    public String getClassName() {
        return this.parent.getClassName();
    }

    @Override
    public String getFullClassName() {
        return this.parent.getFullClassName();
    }

    @Override
    public String getInheritsClass() {
        return this.parent.getInheritsClass();
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String string) {
        return this.parent.isThisClass(string);
    }

    public CobolMethod[] getAllMethods() {
        return this.allMethods.toArray();
    }

    protected CobolMethod getMethod(String string) {
        CobolMethod[] cobolMethodArray = this.getAllMethods();
        CobolMethod cobolMethod = null;
        for (int i2 = 0; i2 < cobolMethodArray.length; ++i2) {
            if (!cobolMethodArray[i2].getMethodName().equals(string)) continue;
            cobolMethod = cobolMethodArray[i2];
            break;
        }
        return cobolMethod;
    }

    @Override
    public MyClass existsClass(String string) throws ClassNotFoundException {
        return this.parent.existsClass(string);
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String string) {
        SpecialNamesClass specialNamesClass = super.getSpecialNamesClass(string);
        if (specialNamesClass == null) {
            specialNamesClass = this.parent.getSpecialNamesClass(string);
        }
        return specialNamesClass;
    }

    @Override
    public SelectList getSelectList() {
        SelectList selectList = this.factory != null && this.factory.environment != null ? this.factory.environment.getSelects() : null;
        return selectList;
    }

    @Override
    public Select getSelect(String string) {
        SelectList selectList;
        Select select;
        if (this.factory != null) {
            select = this.factory.getSelect(string);
            if (select != null) {
                return select;
            }
        } else {
            select = null;
        }
        if (this.environment != null && (selectList = this.environment.getSelects()) != null) {
            select = selectList.getFirst();
            while (select != null && !string.equals(select.fileName.getWord())) {
                select = selectList.getNext();
            }
        }
        return select;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    @Override
    VariableDeclaration getTypedefVar(String string) {
        CobolClass cobolClass;
        VariableDeclaration variableDeclaration = super.getTypedefVar(string);
        if (variableDeclaration == null && !this.isFactory() && (cobolClass = this.parent.getFactoryPart()) != null) {
            variableDeclaration = cobolClass.getTypedefVar(string);
        }
        return variableDeclaration;
    }
}

