/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MethodProcedure;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.interfaces.compiler.ICobolMethod;
import com.iscobol.interfaces.compiler.IDataSection;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class CobolMethod
extends Pcc
implements ICobolMethod {
    static final String localDataPrefix = "data$";
    static final String localClassPrefix = "class$";
    static final String $This$ = "$This$";
    private int progMethod;
    private EnvironmentDivision environment;
    private Token methodId;
    private String externName;
    private boolean override;
    private Invoke superInvoke;
    private int visibility = 1;
    private Token firstToken;
    private Token lastToken;
    private String doc;
    private boolean isFinalize;
    private boolean isSet;
    private boolean isGet;
    private boolean isDefault;
    private boolean isStatic;
    private final HashSet finallyCode = new HashSet(){

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            return stringBuffer.toString();
        }
    };

    public CobolMethod(Pcc pcc) {
        super(pcc);
        this.parent = pcc;
        this.createFixedVars(false, this);
        VariableDeclaration variableDeclaration = this.fixedVars.getFirst();
        while (variableDeclaration != null) {
            this.loadVariable(variableDeclaration);
            variableDeclaration = this.fixedVars.getNext();
        }
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    boolean getSplitFlag() {
        return this.parent.getSplitFlag();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean start() {
        boolean bl = true;
        try {
            Token token;
            try {
                this.methodId();
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
                this.tm.skipTill(new int[]{458, 388, 705, 651, 422});
            }
            try {
                token = this.tm.getToken();
                if (token.getToknum() == 458) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 410) throw new UnexpectedTokenException(token, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.environment = new EnvironmentDivision(this, this.tm, this.error, token);
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
                this.tm.skipTill(new int[]{388, 705, 651, 422});
            }
            try {
                token = this.tm.getToken();
                if (token.getToknum() == 388) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 410) throw new UnexpectedTokenException(token, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, token);
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
                this.tm.skipTill(new int[]{705, 651, 422});
            }
            try {
                this.checkPost();
                if (this.gEnvironment != null) {
                    this.gEnvironment.check(this);
                }
                if (this.environment != null) {
                    this.environment.check(this);
                }
                if (this.data != null) {
                    this.data.check();
                }
            }
            catch (GeneralErrorException generalErrorException) {
                bl = false;
            }
            token = this.tm.getToken();
            if (token.getToknum() == 705) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(token);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException generalErrorException) {
                        bl = false;
                        this.tm.skipTill(new int[]{651, 422});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if ((token = this.tm.getToken()).getToknum() == 651) {
                try {
                    this.procedure = new MethodProcedure(this, this.tm, this.error, this.getVisDescr(), token);
                    if (this.data != null && this.data.linkSec != null) {
                        this.data.linkSec.checkVarargsItems();
                    }
                }
                catch (GeneralErrorException generalErrorException) {
                    bl = false;
                }
            } else {
                this.tm.ungetToken();
            }
            this.checkUsed();
            token = this.tm.getToken();
            if (token.getToknum() == 422 && (token = this.tm.getToken()).getToknum() == 584) {
                Token token2 = this.tm.getToken();
                if (token2.getToknum() == 10009) {
                    if (this.methodId == null || !this.methodId.getWord().equals(token2.getWord())) {
                        this.error.print(83, 3, token2, token2.getWord());
                    }
                } else if (token2.getToknum() == 10001) {
                    if (this.externName == null || !this.externName.equals(token2.getCode())) {
                        this.error.print(83, 3, token2, token2.getWord());
                    }
                } else {
                    this.tm.ungetToken();
                }
                if ((token2 = this.tm.getToken()).getToknum() != 10006) {
                    this.error.print(188, 3, token, "'.'");
                    this.tm.ungetToken();
                } else {
                    token = token2;
                }
                this.lastToken = token;
            } else {
                bl = false;
                this.error.print(31, 4, token, "END METHOD./" + token.getWord());
            }
            boolean bl2 = this.isFinalize = "finalize".equals(this.getMethodName()) && this.procedure != null && this.procedure.using.getItemNum() == 0;
            if (!this.isFinalize) return bl;
            this.setUserDefinedFinalize(true);
            return bl;
        }
        catch (EndOfProgramException endOfProgramException) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            return false;
        }
        catch (GeneralErrorException generalErrorException) {
            this.error.print(11, 4, this.tm.getLineNumber(), 0, generalErrorException.toString(), null, this.tm.getFileName());
            return false;
        }
    }

    private void methodId() throws GeneralErrorException, EndOfProgramException {
        Token token;
        Token token2;
        this.firstToken = token2 = this.tm.getToken();
        boolean bl = this.getRoot().isInterface();
        if (token2.getToknum() == 522 || token2.getToknum() == 521) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 410) {
                if (this.tm.getToken().getToknum() != 10006) {
                    this.error.print(188, 3, token2, "'.'");
                    this.tm.ungetToken();
                }
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token = this.tm.getToken();
        } else {
            token = this.firstToken;
        }
        if (token.getToknum() == 585) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token2, "'.'");
                this.tm.ungetToken();
            }
            this.doc = token.doc;
            token2 = this.tm.getToken();
            boolean bl2 = this.isSet = token2.getToknum() == 719;
            if (this.isSet || (this.isGet = token2.getWord().equals("GET"))) {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 657) {
                    throw new ExpectedFoundException(token2, this.error, "PROPERTY");
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                token2.setWord((this.isSet ? "set" : "get") + token2.getWord());
                this.externName = Pcc.isValidMethodName(token2.getCode());
                if (this.externName == null) {
                    throw new GeneralErrorException(83, 4, token2, token2.getCode(), this.error);
                }
                this.methodId = token2;
                this.visibility = 1;
                token2 = this.tm.getToken();
            } else {
                if (token2.getToknum() == 10009) {
                    this.methodId = token2;
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 280) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 10001) {
                    if (this.methodId == null) {
                        this.methodId = new Token(token2);
                    }
                    this.externName = Pcc.isValidMethodName(token2.getCode());
                    if (this.externName == null) {
                        throw new GeneralErrorException(83, 4, token2, token2.getCode(), this.error);
                    }
                } else if (this.methodId != null) {
                    this.externName = Pcc.isValidMethodName(this.methodId.getCode());
                    if (this.externName == null) {
                        throw new GeneralErrorException(83, 4, this.methodId, this.methodId.getCode(), this.error);
                    }
                    this.tm.ungetToken();
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                if ((token2 = this.tm.getToken()).getToknum() == 545) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 649) {
                    if (bl) {
                        throw new GeneralErrorException(246, 4, token2, token2.getWord(), this.error);
                    }
                    this.visibility = 2;
                    token2 = this.tm.getToken();
                } else if (token2.getToknum() == 658) {
                    if (bl) {
                        throw new GeneralErrorException(246, 4, token2, token2.getWord(), this.error);
                    }
                    this.visibility = 4;
                    token2 = this.tm.getToken();
                } else if (token2.getToknum() == 659) {
                    this.visibility = 1;
                    token2 = this.tm.getToken();
                }
            }
            if (bl && (this.isUnnamed() || this.isConstructor())) {
                throw new GeneralErrorException(83, 4, this.methodId, this.methodId.getCode(), this.error);
            }
            if (token2.getToknum() == 396) {
                if (!bl || this.parent.isFactory()) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.isDefault = true;
                token2 = this.tm.getToken();
            } else if (token2.getWord().equals("STATIC")) {
                if (!bl || !this.parent.isFactory()) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
                this.isStatic = true;
            }
            if (token2.getToknum() == 626) {
                this.override = true;
            } else {
                this.tm.ungetToken();
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10006) {
                this.error.print(188, 3, token2, "'.'");
                this.tm.ungetToken();
            }
            if (this.parent.isFactory() && bl && !this.isStatic) {
                throw new GeneralErrorException(247, 4, this.methodId, null, this.error);
            }
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
    }

    @Override
    public boolean isConstructor() {
        return "new".equals(this.externName);
    }

    @Override
    public String getMethodName() {
        if ("new".equals(this.externName)) {
            return this.parent.getClassName();
        }
        return this.externName;
    }

    @Override
    public void loadProgVariable(VariableDeclaration variableDeclaration) {
        this.loadVariable(variableDeclaration);
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration variableDeclaration = this.data.screenSec.vars.getFirst();
            while (variableDeclaration != null) {
                this.loadVariable(variableDeclaration);
                variableDeclaration.calcOffset(this, 0);
                variableDeclaration = this.data.screenSec.vars.getNext();
            }
        }
    }

    public boolean isVarArgs() {
        return this.procedure != null && this.procedure.usingVarargs != null;
    }

    protected void doCheck() throws GeneralErrorException {
        Object object = this.allBlocks.getFirst();
        while (object != null) {
            ((Block)object).check();
            object = this.allBlocks.getNext();
        }
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        if (this.procedure == null) {
            throw new GeneralErrorException(73, 4, 0, 0, this.methodId.getWord(), this.tm.getFileName(), null, this.error);
        }
        if (this.isConstructor() && this.procedure.returning != null) {
            throw new GeneralErrorException(79, 4, 0, 0, this.methodId.getWord(), this.tm.getFileName(), null, this.error);
        }
        object = new ArrayList();
        if (this.parent.getInheritsClass() != null) {
            try {
                ((ArrayList)object).add(MyClass.getInstance(this.parent.getInheritsClass(), this));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((ArrayList)object).add(MyClass.getInstance(Object.class));
            }
        } else {
            ((ArrayList)object).add(MyClass.getInstance(Object.class));
        }
        if (this.parent.getImplementsClass() != null) {
            for (String string : this.parent.getImplementsClass()) {
                try {
                    MyClass myClass = MyClass.getInstance(string, this);
                    ((ArrayList)object).add(myClass);
                    this.getInterfaces(myClass, (ArrayList<MyClass>)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException);
                }
            }
        }
        if ("".equals(this.externName)) {
            if (this.procedure.using != null && !this.procedure.using.isEmpty()) {
                throw new GeneralErrorException(206, 4, this.methodId, "USING", this.error);
            }
            if (this.procedure.returning != null) {
                throw new GeneralErrorException(206, 4, this.methodId, "RETURNING", this.error);
            }
            if (this.procedure.raising != null) {
                throw new GeneralErrorException(206, 4, this.methodId, "RAISING", this.error);
            }
        } else if (!"new".equals(this.externName)) {
            boolean bl;
            if (this.isSet) {
                if (this.getProcedureDivision().getUsing().getItemNum() != 1) {
                    throw new GeneralErrorException(237, 4, this.methodId, "", this.error);
                }
                if (this.getProcedureDivision().getReturning() != null) {
                    throw new GeneralErrorException(238, 4, this.methodId, "", this.error);
                }
                VariableDeclaration variableDeclaration = this.getProcedureDivision().getUsing().getFirst().getVarDecl().cloneVarDecl("tmp" + this.externName, this.parent, 1);
                this.parent.getDataDivision().getWorkingStorageSection().getVariableDeclarationList().addItem(variableDeclaration);
            } else if (this.isGet) {
                if (this.getProcedureDivision().getUsing().getItemNum() > 0) {
                    throw new GeneralErrorException(239, 4, this.methodId, "", this.error);
                }
                if (this.getProcedureDivision().getReturning() == null) {
                    throw new GeneralErrorException(240, 4, this.methodId, "", this.error);
                }
                VariableDeclaration variableDeclaration = this.getProcedureDivision().getReturning().getVarDecl().cloneVarDecl("tmp" + this.externName, this.parent, 1);
                this.parent.getDataDivision().getWorkingStorageSection().getVariableDeclarationList().addItem(variableDeclaration);
            }
            boolean bl2 = false;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                int n2;
                MyClass myClass = (MyClass)iterator.next();
                MyMethod[] myMethodArray = myClass.getMethods(true);
                for (n2 = myMethodArray.length - 1; n2 >= 0; --n2) {
                    int n3;
                    MyClass[] myClassArray;
                    MyClass[] myClassArray2;
                    if (!this.externName.equals(myMethodArray[n2].getName()) || Modifier.isStatic(myMethodArray[n2].getModifiers()) != this.isFactory() || (myClassArray2 = myMethodArray[n2].getParameterTypes()).length != (myClassArray = this.getParameterTypes()).length) continue;
                    for (n3 = myClassArray2.length - 1; n3 >= 0 && myClassArray2[n3].equals(myClassArray[n3]); --n3) {
                    }
                    if (n3 < 0) break;
                }
                if (n2 < 0) continue;
                bl = true;
                if (myMethodArray[n2].getReturnType().isAssignableFrom(this.getReturnType())) {
                    if (this.override) continue;
                    this.error.print(161, 2, this.methodId, "without OVERRIDE: " + this.externName);
                    continue;
                }
                throw new GeneralErrorException(162, 4, this.methodId, this.externName, this.error);
            }
            if (!bl && this.override) {
                throw new GeneralErrorException(161, 4, this.methodId, "that doesn't exist: " + this.externName, this.error);
            }
        }
    }

    private void getInterfaces(MyClass myClass, ArrayList<MyClass> arrayList) {
        for (MyClass myClass2 : myClass.getInterfaces()) {
            arrayList.add(myClass2);
            this.getInterfaces(myClass2, arrayList);
        }
    }

    protected void doCode(PrintWriter printWriter) throws GeneralErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.writeData(stringBuffer);
        printWriter.print(((MethodProcedure)this.procedure).getCode(this, stringBuffer.toString(), this.getUniqueId(), this.doc, n2));
    }

    @Override
    public MyClass getReturnType() {
        return this.procedure != null ? ((MethodProcedure)this.procedure).getReturnType() : null;
    }

    public MyClass[] getParameterTypes() {
        return this.procedure != null ? ((MethodProcedure)this.procedure).getParameterTypes() : null;
    }

    private int writeData(StringBuffer stringBuffer) throws GeneralErrorException {
        Appendable appendable;
        int n2 = -1;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        boolean bl = this.parent.getOption("-d") != null;
        boolean bl2 = this.parent.getOption("-dx") != null;
        boolean bl3 = this.getSplitFlag();
        String string = this.getLocalDataClass();
        if (bl3) {
            n2 = 0;
            stringBuffer.append(eol + "   public class " + string + "inner_" + n2);
            if (bl) {
                stringBuffer.append(" implements IscobolDebugger");
            }
            if (bl2) {
                stringBuffer.append(", IscobolDebuggerExtension");
            }
            stringBuffer.append(" {" + eol);
            stringBuffer.append("   public " + string + "inner_" + n2 + "() {}" + eol);
            ++n2;
        }
        Object object = this.fixedVars.getFirst();
        while (object != null) {
            stringBuffer.append(((VariableDeclaration)object).getCode(stringBuffer3));
            object = this.fixedVars.getNext();
        }
        if (this.data != null) {
            if (bl3) {
                int n3 = 0;
                appendable = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                ((StringBuffer)appendable).append(this.data.getCode(stringBuffer2, stringBuffer4, null));
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(((StringBuffer)appendable).toString()));
                String string2 = null;
                try {
                    string2 = lineNumberReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (string2 != null) {
                    if (n3 > 0 && n3 % 30000 == 0) {
                        stringBuffer.append("   }" + eol);
                        stringBuffer.append("   public class " + string + "inner_" + n2);
                        stringBuffer.append(" extends " + string + "inner_" + (n2 - 1));
                        if (bl) {
                            stringBuffer.append(" implements IscobolDebugger");
                        }
                        if (bl2) {
                            stringBuffer.append(", IscobolDebuggerExtension");
                        }
                        stringBuffer.append(" {" + eol);
                        stringBuffer.append("   public " + string + "inner_" + n2 + "() {}" + eol);
                        ++n2;
                    }
                    stringBuffer.append(string2 + eol);
                    try {
                        string2 = lineNumberReader.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++n3;
                }
                stringBuffer.append(stringBuffer4.toString());
                stringBuffer.append("   }" + eol);
            } else {
                stringBuffer.append(this.data.getCode(stringBuffer2, null));
            }
        }
        if (this.environment != null) {
            stringBuffer.append(this.environment.getCode(stringBuffer2));
        }
        object = new StringWriter();
        appendable = new PrintWriter((Writer)object);
        if (bl3) {
            n2 = this.writeDeclaration((PrintWriter)appendable, stringBuffer2, stringBuffer3, false, n2, string + "inner_", bl, bl2);
        } else {
            this.writeDeclaration((PrintWriter)appendable, stringBuffer2, stringBuffer3, false, -1, null, bl, bl2);
        }
        stringBuffer.append(((StringWriter)object).toString());
        return n2;
    }

    protected void setSuperInvoke(Invoke invoke) {
        this.superInvoke = invoke;
    }

    protected Invoke getSuperInvoke() {
        return this.superInvoke;
    }

    String getUniqueId() {
        if (this.progMethod == 0) {
            this.progMethod = this.parent.getNewProgClass();
        }
        return this.externName + '$' + this.progMethod;
    }

    @Override
    protected String getParaPrefix() {
        return this.getUniqueId() + "$$";
    }

    protected String getLocalDataClass() {
        return localClassPrefix + this.getUniqueId();
    }

    protected String getLocalDataName() {
        return localDataPrefix + this.getUniqueId();
    }

    @Override
    protected String getVarPrefix() {
        return this.getLocalDataName() + ".";
    }

    @Override
    protected boolean isFactory() {
        return this.parent.isFactory();
    }

    @Override
    public String getClassName() {
        return this.parent.getClassName();
    }

    @Override
    public String getFullClassName() {
        return this.parent.getFullClassName();
    }

    @Override
    public String getInheritsClass() {
        return this.parent.getInheritsClass();
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String string) {
        return this.parent.isThisClass(string);
    }

    @Override
    public MyClass existsClass(String string) throws ClassNotFoundException {
        return this.parent.existsClass(string);
    }

    @Override
    public int getModifiers() {
        int n2 = this.visibility;
        if (this.isFactory()) {
            n2 |= 8;
        }
        return n2;
    }

    public String toString() {
        return this.getMethodName();
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String string) {
        SpecialNamesClass specialNamesClass = super.getSpecialNamesClass(string);
        if (specialNamesClass == null) {
            specialNamesClass = this.parent.getSpecialNamesClass(string);
        }
        return specialNamesClass;
    }

    @Override
    public SelectList getSelectList() {
        SelectList selectList;
        SelectList selectList2 = null;
        if (this.environment != null && (selectList = this.environment.getSelects()) != null) {
            selectList2 = new SelectList();
            selectList2.addList(selectList);
        }
        if ((selectList = this.parent.getSelectList()) != null) {
            if (selectList2 == null) {
                selectList2 = new SelectList();
            }
            selectList2.addList(selectList);
        }
        return selectList2;
    }

    @Override
    public Select getSelect(String string) {
        SelectList selectList;
        if (this.environment != null && (selectList = this.environment.getSelects()) != null) {
            Select select = selectList.getFirst();
            while (select != null) {
                if (string.equals(select.fileName.getWord())) {
                    return select;
                }
                select = selectList.getNext();
            }
        }
        return this.parent.getSelect(string);
    }

    @Override
    public FileDescriptor getFdByRecord(VariableDeclaration variableDeclaration) {
        FileDescriptor fileDescriptor = super.getFdByRecord(variableDeclaration);
        return fileDescriptor == null ? this.parent.getFdByRecord(variableDeclaration) : fileDescriptor;
    }

    public boolean hasSameSignature(CobolMethod cobolMethod) {
        MyClass[] myClassArray;
        MyClass[] myClassArray2;
        if (this.getMethodName().equals(cobolMethod.getMethodName()) && (myClassArray2 = this.getParameterTypes()).length == (myClassArray = cobolMethod.getParameterTypes()).length) {
            for (int i2 = 0; i2 < myClassArray.length; ++i2) {
                if (myClassArray2[i2].equals(myClassArray[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isUnnamed() {
        return "".equals(this.externName);
    }

    public String getMethodDesc() {
        VariableDeclarationList variableDeclarationList;
        LinkageSection linkageSection;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.externName);
        DataDivision dataDivision = this.getDataDivision();
        if (dataDivision != null && (linkageSection = dataDivision.getLinkageSection()) != null && (variableDeclarationList = linkageSection.getVariableDeclarationList()).getItemNum() > 0) {
            stringBuffer.append("(");
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            stringBuffer.append(variableDeclaration.getTypeName());
            variableDeclaration = variableDeclarationList.getNext();
            while (variableDeclaration != null) {
                stringBuffer.append(",");
                stringBuffer.append(variableDeclaration.getTypeName());
                variableDeclaration = variableDeclarationList.getNext();
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isFinalize() {
        return this.isFinalize;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isGet() {
        return this.isGet;
    }

    private String getVisDescr() {
        switch (this.visibility) {
            case 2: {
                return "private";
            }
            case 4: {
                return "protected";
            }
        }
        return "public";
    }

    boolean hasFinallyCode() {
        return this.finallyCode.size() > 0;
    }

    void addFinallyCode(String string) {
        this.finallyCode.add(string);
    }

    String getFinallyCode() {
        return this.finallyCode.toString();
    }

    void printConstants(PrintWriter printWriter, int[] nArray) {
        DataDivision dataDivision = this.getDataDivision();
        if (dataDivision != null) {
            for (IDataSection iDataSection : new IDataSection[]{dataDivision.getWorkingStorageSection(), dataDivision.getLocalStorageSection(), dataDivision.getThreadLocalStorageSection(), dataDivision.getLinkageSection()}) {
                if (iDataSection == null) continue;
                VariableDeclarationList variableDeclarationList = (VariableDeclarationList)iDataSection.getVariableDeclarationList();
                VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
                while (variableDeclaration != null) {
                    CobolMethod.printConstants(variableDeclaration, printWriter, nArray);
                    variableDeclaration = variableDeclarationList.getNext();
                }
            }
        }
    }

    static void printConstants(VariableDeclaration variableDeclaration, PrintWriter printWriter, int[] nArray) {
        if (variableDeclaration.getLevel() == 78) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(variableDeclaration.getName());
            stringBuffer.append(",");
            String string = variableDeclaration.getValue(false);
            if (variableDeclaration.getValueToken().getToknum() == 10001) {
                string = string.substring(1, string.length() - 1);
            }
            char[] cArray = string.toCharArray();
            for (n2 = 0; n2 < cArray.length; ++n2) {
                String string2 = Integer.toHexString(cArray[n2]);
                if (string2.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append(";");
            n2 = nArray[0] + stringBuffer.length() - 65000;
            if (n2 > 0) {
                printWriter.print(stringBuffer.substring(0, stringBuffer.length() - n2));
                printWriter.print("\").append(\"");
                printWriter.print(stringBuffer.substring(stringBuffer.length() - n2));
                nArray[0] = n2;
            } else {
                printWriter.print(stringBuffer);
                nArray[0] = nArray[0] + stringBuffer.length();
            }
        } else {
            VariableDeclarationList variableDeclarationList = variableDeclaration.getChildren();
            VariableDeclaration variableDeclaration2 = variableDeclarationList.getFirst();
            while (variableDeclaration2 != null) {
                CobolMethod.printConstants(variableDeclaration2, printWriter, nArray);
                variableDeclaration2 = variableDeclarationList.getNext();
            }
        }
    }

    @Override
    VariableDeclaration getTypedefVar(String string) {
        CobolClass cobolClass;
        VariableDeclaration variableDeclaration = super.getTypedefVar(string);
        if (variableDeclaration == null && (variableDeclaration = this.parent.getTypedefVar(string)) == null && !this.isFactory() && (cobolClass = this.parent.parent.getFactoryPart()) != null) {
            variableDeclaration = cobolClass.getTypedefVar(string);
        }
        return variableDeclaration;
    }
}

