/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.IdentificationDivision;
import com.iscobol.compiler.InputOutputSection;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MSVariableGenerator;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.SQLCA;
import com.iscobol.compiler.ScreenSection;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.StandardPhases;
import com.iscobol.compiler.StorageSection;
import com.iscobol.compiler.Switch;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class CobolProgram
extends Pcc {
    IdentificationDivision identification;
    EnvironmentDivision environment;
    PrintWriter progFile;
    private Use atProgramStart;
    private Use atProgramEnd;
    int onCount;
    public static final String PROGRAM_FIELD_NAME = "$$theProgram$$";

    public CobolProgram(Pcc pcc, IdentificationDivision identificationDivision, EnvironmentDivision environmentDivision) {
        super(pcc);
        this.optionMS = pcc.getOption("-jjms") != null;
        pcc.capitalizeNames = this.capitalizeNames = this.optionMS && Config.b("iscobol.compiler.jjms.capitalize_names", true);
        pcc.optionMS = this.optionMS;
        this.parent = pcc;
        this.identification = identificationDivision;
        this.environment = environmentDivision;
        this.createFixedVars(true, this.parent);
        VariableDeclaration variableDeclaration = this.fixedVars.getFirst();
        while (variableDeclaration != null) {
            this.parent.loadVariable(variableDeclaration);
            variableDeclaration = this.fixedVars.getNext();
        }
    }

    int addOnStatement() {
        return ++this.onCount;
    }

    @Override
    boolean getSplitFlag() {
        return this.parent.getSplitFlag();
    }

    @Override
    boolean start() {
        return this.start(true);
    }

    protected void checkPostImpl() throws GeneralErrorException {
        super.checkPost();
    }

    @Override
    protected void checkPost() throws GeneralErrorException {
        this.parent.checkPost();
    }

    VariableDeclaration getAny(VariableName variableName, boolean bl, boolean bl2, VariableDeclaration variableDeclaration, boolean bl3) throws GeneralErrorException {
        return super.getAny(variableName, bl, bl2, variableDeclaration, bl3, GetVarOpts.NO_OPTS);
    }

    VariableDeclaration getAnyImpl(VariableName variableName, boolean bl, boolean bl2, VariableDeclaration variableDeclaration, boolean bl3) throws GeneralErrorException {
        return super.getAny(variableName, bl, bl2, variableDeclaration, bl3, GetVarOpts.NO_OPTS);
    }

    protected void checkUsedImpl() {
        super.checkUsed();
    }

    @Override
    protected void checkUsed() {
        this.parent.checkUsed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean start(boolean bl) {
        boolean bl2 = true;
        try {
            Token token;
            try {
                token = this.tm.getToken();
                if (token.getToknum() == 388) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 410) throw new UnexpectedTokenException(token, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, token, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, token);
            }
            catch (GeneralErrorException generalErrorException) {
                bl2 = false;
                this.tm.skipTill(new int[]{651, 705});
            }
            this.checkPost();
            if (this.environment != null) {
                this.environment.check(this);
            }
            if (this.data != null) {
                this.data.check();
            }
            if ((token = this.tm.getToken()).getToknum() == 705) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(token);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException generalErrorException) {
                        bl2 = false;
                        this.tm.skipTill(new int[]{651});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if (this.optionMS) {
                this.tm.pp.disableConstVars();
            }
            try {
                token = this.tm.getToken();
                if (token.getToknum() != 651) {
                    throw new ExpectedFoundException(token, this.error, "PROCEDURE");
                }
            }
            catch (GeneralErrorException generalErrorException) {
                bl2 = false;
                this.tm.skipTill(new int[]{651});
                token = this.tm.getToken();
            }
            try {
                if (this.error.getErrorCount(4) > 0) {
                    this.error.ignoreFurtherErrors();
                }
                this.procedure = new ProcedureDivision(this, this.tm, this.error, token);
                if (this.data != null && this.data.linkSec != null) {
                    this.data.linkSec.checkVarargsItems();
                }
            }
            catch (GeneralErrorException generalErrorException) {
                bl2 = false;
            }
            this.checkUsed();
        }
        catch (EndOfProgramException endOfProgramException) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            this.error.printEndMessage();
            return false;
        }
        catch (GeneralErrorException generalErrorException) {
            return false;
        }
        try {
            this.serviceBridgeActivated = this.isServiceBridgeActivated();
            this.easydbActivated = this.isEasyDBActivated();
            if (this.procedure != null) {
                this.doCheck();
            }
        }
        catch (GeneralErrorException generalErrorException) {
            bl2 = false;
        }
        if (!bl) return bl2;
        try {
            this.setClassName(this.outName);
            String string = this.getClassName().replace('-', '_').toUpperCase(Locale.US);
            if (this.identification != null && this.identification.getProgramId() != null && !string.equalsIgnoreCase(this.identification.getProgramName())) {
                this.error.print(42, 2, this.identification.getProgramId(), this.identification.getProgramName());
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                string = '$' + string;
            }
            this.setClassName(string);
            this.checkClassName(string);
            this.setClassName(string);
        }
        catch (GeneralErrorException generalErrorException) {
            bl2 = false;
        }
        if (this.error.printEndMessage()) return false;
        try {
            this.getPhases().generateSourceCode(this);
            return bl2;
        }
        catch (GeneralErrorException generalErrorException) {
            return false;
        }
    }

    protected String getCobolProgramName() {
        String string = this.outName.replace('-', '_').toUpperCase(Locale.US);
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            string = '$' + string;
        }
        return string;
    }

    protected final void loadVariableImpl(VariableDeclaration variableDeclaration) {
        super.loadVariable(variableDeclaration);
    }

    @Override
    public void loadVariable(VariableDeclaration variableDeclaration) {
        this.parent.loadVariable(variableDeclaration);
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration variableDeclaration = this.data.screenSec.vars.getFirst();
            while (variableDeclaration != null) {
                this.parent.loadVariable(variableDeclaration);
                variableDeclaration.calcOffset(this, 0);
                variableDeclaration = this.data.screenSec.vars.getNext();
            }
        }
    }

    @Override
    public SelectList getSelectList() {
        SelectList selectList = this.environment != null ? this.environment.getSelects() : null;
        return selectList;
    }

    @Override
    public Select getSelect(String string) {
        SelectList selectList;
        Select select = null;
        if (this.environment != null && (selectList = this.environment.getSelects()) != null) {
            select = selectList.getFirst();
            while (select != null && !string.equals(select.fileName.getWord())) {
                select = selectList.getNext();
            }
        }
        return select;
    }

    @Override
    public Select getLinageSelect(Token token, Errors errors) throws GeneralErrorException {
        SelectList selectList;
        Select select = null;
        Select select2 = null;
        if (this.environment != null && (selectList = this.environment.getSelects()) != null) {
            select = selectList.getFirst();
            while (select != null) {
                if (select.hasLinage()) {
                    if (select2 != null) {
                        throw new GeneralErrorException(36, 4, token, token.getWord(), errors);
                    }
                    select2 = select;
                }
                select = selectList.getNext();
            }
        }
        return select2;
    }

    @Override
    public Alphabet[] getAlphabets() {
        SpecialNames specialNames;
        ConfigurationSection configurationSection;
        EnvironmentDivision environmentDivision = this.getEnvironmentDivision();
        if (environmentDivision != null && (configurationSection = environmentDivision.getConfigurationSection()) != null && (specialNames = configurationSection.getSpecialNames()) != null) {
            return specialNames.getAlphabets();
        }
        return null;
    }

    @Override
    public Alphabet getAlphabet(Token token) {
        SpecialNames specialNames;
        ConfigurationSection configurationSection;
        EnvironmentDivision environmentDivision = this.getEnvironmentDivision();
        if (environmentDivision != null && (configurationSection = environmentDivision.getConfigurationSection()) != null && (specialNames = configurationSection.getSpecialNames()) != null) {
            return specialNames.getAlphabet(token);
        }
        return null;
    }

    @Override
    public Alphabet getProgramCollatingSeq() {
        SpecialNames specialNames;
        Token token;
        ConfigurationSection configurationSection;
        EnvironmentDivision environmentDivision = this.getEnvironmentDivision();
        if (environmentDivision != null && (configurationSection = environmentDivision.getConfigurationSection()) != null && (token = configurationSection.getProgramCollatingSeq()) != null && (specialNames = configurationSection.getSpecialNames()) != null) {
            return specialNames.getAlphabet(token);
        }
        return null;
    }

    public VariableDeclaration getObjectReference(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = this.getAny(variableName, true);
        if (variableDeclaration != null && !variableDeclaration.isObjectReference()) {
            throw new GeneralErrorException(75, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
        }
        return variableDeclaration;
    }

    protected void doCheck() throws GeneralErrorException {
        this.getOutddProperty(true);
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        Block block = this.allBlocks.getFirst();
        while (block != null) {
            block.check();
            block = this.allBlocks.getNext();
        }
        if (this.procedure == null) {
            throw new GeneralErrorException(73, 4, 0, 0, this.getClassName(), this.tm.getFileName(), null, this.error);
        }
    }

    public final void doCode() throws GeneralErrorException {
        CharSequence charSequence;
        Serializable serializable;
        if (this.optionMS) {
            boolean bl = false;
            serializable = this.getTokenManager().getAllPreProcessors();
            for (PreProcessor preProcessor : serializable) {
                if (!new File(preProcessor.getFileName()).getName().equalsIgnoreCase("SQLCA")) continue;
                bl = true;
                break;
            }
            this.sqlca = new SQLCA(true, bl, this.capitalizeNames);
        } else {
            this.sqlca = this.parent.sqlca;
        }
        String string = this.outDir;
        try {
            Config.a(5);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.writeClassEEA();
            Config.a(1);
        }
        try {
            if (this.getOption("-sqlj") != null) {
                this.setProgName(string + this.getClassName() + ".sqlj");
            } else {
                this.setProgName(string + this.getClassName() + ".java");
            }
            this.progFile = PreProcessor.newPrintWriter(this.getProgName());
        }
        catch (IOException iOException) {
            throw new GeneralErrorException(39, 4, 0, 0, this.getClassName(), this.tm.getFileName(), iOException, this.error);
        }
        this.writeHeader();
        serializable = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = this.getOption("-d") != null;
        boolean bl2 = this.getOption("-dx") != null;
        boolean bl3 = this.tm.declareAllLit;
        this.tm.declareAllLit = true;
        if (this.data != null && !this.optionMS) {
            StringBuffer stringBuffer2;
            if (this.data.lsSec != null) {
                this.progFile.println("   private static class _my_loc_stg_ {");
                charSequence = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                this.progFile.print(this.data.getCode((StringBuffer)charSequence, stringBuffer2, "LS"));
                this.progFile.println("      _my_loc_stg_() {");
                this.progFile.print(charSequence);
                this.progFile.println("      }");
                this.progFile.print(stringBuffer2);
                this.progFile.println("   }");
                this.progFile.println("   public static Object s_newLocalStorage() { return new _my_loc_stg_(); }");
                this.progFile.println("   public Object newLocalStorage() { return s_newLocalStorage(); }");
            }
            if (this.data.tlsSec != null) {
                this.progFile.println("   private static class _my_thloc_stg_ {");
                charSequence = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                this.progFile.print(this.data.getCode((StringBuffer)charSequence, stringBuffer2, "TLS"));
                this.progFile.println("      _my_thloc_stg_() {");
                this.progFile.print(charSequence);
                this.progFile.println("      }");
                this.progFile.print(stringBuffer2);
                if (this.data.fileSec != null && this.data.fileSec.hasThreadLocal()) {
                    this.progFile.print(Pcc.declareFinalize("      "));
                    FileDescriptorList fileDescriptorList = this.data.fileSec.getFileDescriptorList();
                    FileDescriptor fileDescriptor = fileDescriptorList.getFirst();
                    while (fileDescriptor != null) {
                        if (fileDescriptor.threadLocal && fileDescriptor.getSelect() != null) {
                            this.progFile.println("         " + fileDescriptor.getSelect().getBaseName() + ".finalize();");
                        }
                        fileDescriptor = fileDescriptorList.getNext();
                    }
                    this.progFile.println("      }");
                }
                this.progFile.println("   }");
                this.progFile.println("   public static String s_threadLocalStorageName() { return " + this.getClassName() + ".class.getName(); }");
                this.progFile.println("   public Object newThreadLocalStorage() { return new _my_thloc_stg_(); }");
                this.progFile.print("   public static Object s_newThreadLocalStorage() { return new ");
                if (this.data != null && this.data.fileSec != null && this.data.fileSec.hasThreadLocal()) {
                    this.progFile.print(this.getClassName() + "().newThreadLocalStorage()");
                } else {
                    this.progFile.print("_my_thloc_stg_()");
                }
                this.progFile.println("; }");
                this.progFile.println("   public String threadLocalStorageName() { return s_threadLocalStorageName(); }");
            }
        }
        this.tm.declareAllLit = bl3;
        if (this.getSplitFlag()) {
            this.progFile.print("   public class inner_" + n2);
            if (bl) {
                this.progFile.print(" implements IscobolDebugger");
            }
            if (bl2) {
                this.progFile.print(", IscobolDebuggerExtension");
            }
            this.progFile.println(" {");
            this.progFile.println("   public inner_" + n2 + "() {}");
            ++n2;
        }
        if (this.optionMS) {
            this.writeResources(this.progFile, false);
        }
        n2 = this.writeData((StringBuffer)serializable, stringBuffer, n2, bl, bl2);
        if (!this.optionMS) {
            this.writeResources(this.progFile, false);
        }
        if (((String)(charSequence = this.tm.declareAllLiterals(false))).length() > 0) {
            this.progFile.println((String)charSequence);
        }
        this.writeEnvironment((StringBuffer)serializable, null);
        if (this.getSplitFlag()) {
            if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
                this.writeBeanCode(this.progFile);
            }
            this.progFile.println("   }");
        }
        this.writeAlterTargets(this.progFile);
        n2 = this.writeDeclaration(this.progFile, (StringBuffer)serializable, stringBuffer, this.isFactory(), this.getSplitFlag() ? n2 : -1, this.getSplitFlag() ? "inner_" : null, bl, bl2);
        n2 = this.writeProcedure(this.getSplitFlag() ? n2 : -1);
        if (n2 > 0) {
            boolean bl4;
            this.progFile.println("   private inner_" + (n2 - 1) + " " + PROGRAM_FIELD_NAME + " = new " + "inner_" + (n2 - 1) + "();");
            this.progFile.println("   public Object call (Object[] arg) {");
            this.progFile.println("      return $$theProgram$$.call(arg);");
            this.progFile.println("   }");
            this.progFile.println("   public void perform (int begin, int end) {");
            this.progFile.println("      $$theProgram$$.perform(begin, end);");
            this.progFile.println("   }");
            if (this.procedure.dList.getItemNum() > 0) {
                this.progFile.println("   public void declaratives (int begin, int end) throws GotoException {");
                this.progFile.println("      $$theProgram$$.declaratives(begin, end);");
                this.progFile.println("   }");
            }
            if (this.entryPoints.size() > 0) {
                this.progFile.println("   public Object call (int entrypoint, Object[] arg) {");
                this.progFile.println("      return $$theProgram$$.call(entrypoint, arg);");
                this.progFile.println("   }");
                this.progFile.println("   public String[] getEntryPoints() {");
                this.progFile.println("      return $$theProgram$$.getEntryPoints();");
                this.progFile.println("   }");
            }
            if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
                this.progFile.println("   public void setEventObject(EventObject eo) {");
                this.progFile.println("      $$theProgram$$.setEventObject(eo);");
                this.progFile.println("   }");
                this.progFile.println("   public EventObject getEventObject() {");
                this.progFile.println("      return $$theProgram$$.getEventObject();");
                this.progFile.println("   }");
                this.progFile.println("   public void setEventSource(CobolGUIJavaBean jb) {");
                this.progFile.println("      $$theProgram$$.setEventSource(jb);");
                this.progFile.println("   }");
                this.progFile.println("   public CobolGUIJavaBean getEventSource() {");
                this.progFile.println("      return $$theProgram$$.getEventSource();");
                this.progFile.println("   }");
            }
            boolean bl5 = bl4 = this.getOption("-pt2") != null;
            if (this.getOption("-pt0") != null || bl4) {
                this.progFile.println("   void perform (int begin,int end,int id) {");
                this.progFile.println("      $$theProgram$$.perform(begin,end,id);");
                this.progFile.println("   }");
                this.progFile.println("   void exit (int id) {");
                this.progFile.println("      $$theProgram$$.exit(id);");
                this.progFile.println("   }");
                if (this.procedure.dList.getItemNum() > 0) {
                    this.progFile.println("   void declaratives (int begin,int end,int id) throws GotoException {");
                    this.progFile.println("      $$theProgram$$.declaratives(begin,end,id);");
                    this.progFile.println("   }");
                    this.progFile.println("   void dexit (int id) {");
                    this.progFile.println("      $$theProgram$$.dexit(id);");
                    this.progFile.println("   }");
                }
            }
            this.writeTrailer(this.progFile);
            this.progFile.print("class " + this.getClassName() + "_CONST" + " extends " + this.getClassName() + "_CONST" + "_0");
            if (bl) {
                this.progFile.print(" implements IscobolDebugger");
            }
            if (bl2) {
                this.progFile.print(", IscobolDebuggerExtension");
            }
            this.progFile.println(" {");
            int n3 = this.writeLiterals(this.progFile, false);
            this.progFile.println("}");
            this.progFile.println("class " + this.getClassName() + "_CONST" + "_" + n3 + "{");
            if (this.options.getOption("-sddp") != null) {
                this.progFile.println("   public static final boolean $isDPC$ = Factory.isDPC();");
            }
            if (this.options.getOption("-sdcs") != null) {
                this.progFile.println("   public static final char $CurrencySign$ = Factory.getCS();");
            }
            this.progFile.println("}");
        } else {
            this.writeLiterals(this.progFile, false);
            this.writeTrailer(this.progFile);
        }
        this.progFile.close();
        if (this.getOption("-sqlj") != null) {
            this.doSqljCompilation();
            if (!this.isSqljJJ()) {
                new File(this.getProgName()).delete();
                new File(this.getProgName().replace(".sqlj", ".java")).delete();
            }
        }
    }

    @Override
    protected int writeLiterals(PrintWriter printWriter, boolean bl) {
        Alphabet[] alphabetArray = this.getAlphabets();
        if (alphabetArray != null) {
            for (int i2 = 0; i2 < alphabetArray.length; ++i2) {
                printWriter.print(this.tm.getCommentCode(alphabetArray[i2].getName(), "   "));
                printWriter.print("   static int[] ");
                printWriter.print(alphabetArray[i2].getDeclUnivoqueName());
                printWriter.print(" = ");
                printWriter.print(alphabetArray[i2].getCode());
                printWriter.print(";" + eol);
                printWriter.print("   static byte[] ");
                printWriter.print(alphabetArray[i2].getDeclUnivoqueNameBytes());
                printWriter.print(" = ");
                printWriter.print(alphabetArray[i2].getCodeBytes());
                printWriter.println(";");
            }
        }
        return super.writeLiterals(printWriter, bl);
    }

    public IdentificationDivision getProgramIdentificationDivision() {
        return this.identification;
    }

    private void writeHeader() {
        boolean bl;
        boolean bl2;
        boolean bl3 = this.getOption("-d") != null;
        this.commonHeader(this.progFile);
        this.progFile.println(this.identification.getDoc());
        this.progFile.print(this.tm.getCommentCode(this.identification.getProgramId(), ""));
        this.progFile.println("public class " + this.getClassName());
        if (this.getSplitFlag()) {
            this.progFile.print(" extends " + this.getClassName() + "_CONST");
        }
        this.progFile.println();
        boolean bl4 = bl2 = !this.optionMS || Config.b("iscobol.compiler.jjms.gen_isclass_methods", false);
        if (bl2) {
            this.progFile.println(" implements com.iscobol.rts.IscobolClass");
        } else {
            this.progFile.println(" implements com.iscobol.rts.IscobolClassJJMS");
        }
        if (this.entryPoints.size() == 0) {
            this.progFile.println("           ,com.iscobol.rts.IscobolCall");
        } else {
            this.progFile.println("           ,com.iscobol.rts.WithEntryPoints");
        }
        if (this.identification.getProgramType() == 690) {
            this.progFile.println("           ,com.iscobol.rts.IsResident");
        } else if (this.identification.getProgramType() == 531 || this.getOption("-zi") != null) {
            this.progFile.println("           ,com.iscobol.rts.IsInitial");
        }
        if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
            this.progFile.println("            ,BeanContainer");
        }
        if (this.data != null) {
            if (this.data.lsSec != null) {
                this.progFile.println("           ,com.iscobol.rts.LocalStorageProvider");
            }
            if (this.data.tlsSec != null) {
                this.progFile.println("           ,com.iscobol.rts.ThreadLocalStorageProvider");
            }
        }
        if (bl3) {
            this.progFile.println("           , IscobolDebugger");
        }
        if (this.parent.getOption("-dx") != null) {
            this.progFile.println("           , IscobolDebuggerExtension");
        }
        this.progFile.println("{");
        boolean bl5 = bl = !this.optionMS || Config.b("iscobol.compiler.jjms.gen_cmdline_code", false);
        if (bl) {
            this.progFile.println("   String[] gArgs;");
        }
        if (this.getOption("-sqlj") != null && this.hasSqlj()) {
            this.progFile.println("   DefaultContext ctx" + this.getClassName() + "  = null;");
            this.progFile.println("   Object obj;");
            this.progFile.println("   RuntimeImpl ri = new RuntimeImpl();");
            this.progFile.println("   boolean warnings = ri.getProperty(\".esql.warnings\", false);");
            this.progFile.println("   boolean automaticConnection = ri.getProperty(\".jdbc.auto_connect\", false);");
            this.progFile.println("   int errorFact = ri.getProperty(\".esql.error.negative\", false) ? -1 : 1;");
        }
        if (this.getOption("-sqlj") != null && this.getOption("-csdb2") != null && this.hasSqlj()) {
            this.progFile.println("   DB2ResultSet rs = null;");
            this.progFile.println(this.getSqljResultSetDeclaration());
            if (this.getOption("-xsqljdb2") != null && this.hasSqlj()) {
                this.progFile.println("   byte[] rowData;");
                this.progFile.println("   int[] rowInfo;");
                this.progFile.println("   int rowOffs[];");
                this.progFile.println("   byte[] num = new byte[2];");
                this.progFile.println("   int len, offs, colSqlType;");
                this.progFile.println("   byte[] bytearr;");
            }
        } else if (this.getOption("-sqlj") != null && this.hasSqlj()) {
            this.progFile.println("   ResultSet rs = null;");
            this.progFile.println(this.getSqljResultSetDeclaration());
        }
        if (this.generateObjectIds) {
            this.progFile.println("   private final java.util.Vector<CobolVar> $objectIds$ = new java.util.Vector<CobolVar>();");
        }
        if (this.onCount > 0) {
            this.progFile.println("   int[] $onCounters$ = new int[" + this.onCount + "];");
        }
        if (this.procedure != null) {
            boolean bl6;
            EnvironmentDivision environmentDivision;
            Object object;
            if (bl) {
                this.progFile.println("   public Object[] _setCommandLineArgs (String args[]) {");
                this.progFile.println("      Factory.get().gArgs = this.gArgs = args;");
                boolean bl7 = Config.b(".compiler.command_line_linkage", false);
                if (bl7) {
                    object = this.getOption("-xms") != null && this.getOption("-xmsn") != null ? "getNotOptmzdMem" : "getMem";
                    this.progFile.println("      PicX grp = Factory.getVarAlphanum(Factory." + (String)object + "(2050),0,2050,false,null, null,null,null,false,false);");
                    this.progFile.println("      NumericVar cmdLineLen = Factory.getVarBinary(grp,0,2,false,null, null,null,null,false,4,0,false,false,false,false);");
                    this.progFile.println("      PicX cmdLine = Factory.getVarAlphanum(grp,2,2048,false,null, null,null,null,false,false);");
                    this.progFile.println("      String result = \"\";");
                    this.progFile.println("      if (args != null && args.length > 0)");
                    this.progFile.println("         for (int i = 0; ; ) {");
                    this.progFile.println("            result += args[i];");
                    this.progFile.println("            if (++i < args.length)");
                    this.progFile.println("               result += \" \";");
                    this.progFile.println("            else");
                    this.progFile.println("               break;");
                    this.progFile.println("         }");
                    this.progFile.println("      cmdLineLen.set(Math.min(2048, result.length()));");
                    this.progFile.println("      cmdLine.set(result);");
                    this.progFile.println("      return new Object[] { grp };");
                } else {
                    boolean bl8 = this.getProcedureDivision().getChaining().getItemNum() > 0;
                    this.progFile.println("      return " + (bl8 ? "args" : "null") + ";");
                }
                this.progFile.println("   }");
            }
            if (this.getOption("-ccmf") != null) {
                this.progFile.print(CobolProgram.getCallBridgeMethodsCode());
            }
            if (this.optionMS && (environmentDivision = this.getEnvironmentDivision()) != null) {
                InputOutputSection inputOutputSection;
                this.progFile.print(this.tm.getCommentCode(environmentDivision.getFirstToken(), ""));
                object = environmentDivision.getConfigurationSection();
                if (object != null) {
                    this.progFile.print(this.tm.getCommentCode(((ConfigurationSection)object).getFirstToken(), ""));
                }
                if ((inputOutputSection = environmentDivision.getInputOutputSection()) != null) {
                    this.progFile.print(this.tm.getCommentCode(inputOutputSection.getFirstToken(), ""));
                }
            }
            this.progFile.println("   public static void main (String args[]) {");
            this.progFile.println("      Object argv[] = args;");
            this.progFile.println("      int exitCode = 0;");
            this.progFile.println("      com.iscobol.gui.ScreenUtility.getGuiFactory();");
            this.progFile.println("      com.iscobol.rts.IscobolCall theProgram = new " + this.getClassName() + "();");
            if (bl) {
                this.progFile.println("      Object[] linkage = ((" + this.getClassName() + ") theProgram)._setCommandLineArgs (args);");
            } else {
                this.progFile.println("      Factory.get().gArgs = args;");
                this.progFile.println("      Object[] linkage = null;");
            }
            boolean bl9 = bl6 = !this.optionMS || Config.b("iscobol.compiler.jjms.gen_log_code", false);
            if (bl6) {
                this.progFile.println("   com.iscobol.logger.Logger traceLog = com.iscobol.logger.LoggerFactory.get(com.iscobol.logger.LoggerFactory.TR_C_STACK);");
            }
            this.progFile.println("   for ( ; ; ) {");
            this.progFile.println("      try {");
            this.progFile.println("         theProgram=Factory.activeCallsPush(theProgram, argv);");
            if (bl6) {
                this.progFile.println("         if(traceLog != null)");
                this.progFile.println("            traceLog.info(\"ENTER PROGRAM '" + this.getClassName() + "' {\");");
            }
            this.progFile.println("         exitCode = ((CobolVar) theProgram.call(linkage)).toint();");
            this.progFile.println("      } catch(NewRunUnitException sre) { ");
            this.progFile.println("         Factory.activeCallsPop();");
            this.progFile.println("         theProgram = sre.call;");
            this.progFile.println("         linkage = argv = sre.argv;");
            this.progFile.println("         continue;");
            this.progFile.println("      } catch(StopRunException sre) { ");
            this.progFile.println("         exitCode = sre.getExitCode();");
            this.progFile.println("      } catch(Throwable ex) { ");
            if (bl6) {
                this.progFile.println("         com.iscobol.logger.Logger $errLog = com.iscobol.logger.LoggerFactory.getCurrLog();");
                this.progFile.println("         if($errLog != null) {");
                this.progFile.println("            java.io.StringWriter $sw = new java.io.StringWriter();");
                this.progFile.println("            java.io.PrintWriter $pw = new java.io.PrintWriter($sw);");
                this.progFile.println("            ex.printStackTrace($pw);");
                this.progFile.println("            $errLog.info($sw.toString());");
                this.progFile.println("         }");
            }
            if (bl3) {
                this.progFile.println("         Debugger.unexpectedException(ex);");
            }
            this.progFile.println("         ErrorBox.show(ex);");
            this.progFile.println("         exitCode = 255;");
            if (bl6) {
                this.progFile.println("      } finally {");
                this.progFile.println("         if(traceLog != null)");
                this.progFile.println("            traceLog.info(\"EXIT PROGRAM '" + this.getClassName() + "' }\");");
            }
            this.progFile.println("      }");
            this.progFile.println("      Factory.stopRun(exitCode);");
            if (bl3) {
                this.progFile.println("      Debugger.exit(exitCode);");
            } else {
                this.progFile.println("      System.exit(exitCode);");
            }
            this.progFile.println("      }");
            this.progFile.println("   }");
            if (bl2) {
                String[] stringArray = CobolProgram.getVersionCode(bl3);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.progFile.println(stringArray[i2]);
                }
            }
            this.compFlagsCheck(this.progFile);
            if (!this.optionMS || Config.b("iscobol.compiler.jjms.gen_class_uid", false)) {
                this.writeClassUID(this.progFile);
            }
            if (this.getHasSort() && this.getOption("-cv") != null) {
                this.progFile.println("/** Added by isCOBOL compiler. */");
                this.progFile.println("   private static class SortAbort extends RuntimeException {}");
            }
            if (this.atProgramStart != null) {
                this.progFile.println("/** Added by isCOBOL compiler. */");
                this.progFile.println("   public " + this.getClassName() + "() {");
                this.progFile.println("      try {");
                if (bl3) {
                    this.progFile.println(ProcedureDivision.getDebugEnterCode(this, this.tm.getFileName()));
                }
                this.progFile.println("         declaratives(" + this.atProgramStart.parag.getIdNumber() + "," + this.atProgramStart.parag.getLastParagraphInSameSection().getIdNumber() + ");");
                this.progFile.println("      } catch (GotoException e) {");
                this.progFile.println("         perform (e.parNum, " + this.procedure.getParCount() + ");");
                this.progFile.print("      }");
                if (bl3) {
                    this.progFile.println(" finally {");
                    this.progFile.println("      " + ProcedureDivision.getDebugExitCode());
                    this.progFile.println("      }");
                } else {
                    this.progFile.println();
                }
                this.progFile.println("   }");
            }
            this.progFile.println("/** Added by isCOBOL compiler. */");
            if (this.atProgramEnd != null) {
                this.progFile.println("   private boolean finalize;");
            }
            CobolProgram.declareFinalize(this.progFile, "   ");
            if (this.atProgramEnd != null) {
                this.progFile.println("      if (!finalize) try {");
                this.progFile.println("         finalize = true;");
                if (bl3) {
                    this.progFile.println(ProcedureDivision.getDebugEnterCode(this, this.tm.getFileName()));
                }
                this.progFile.println("         declaratives(" + this.atProgramEnd.parag.getIdNumber() + "," + this.atProgramEnd.parag.getLastParagraphInSameSection().getIdNumber() + ");");
                this.progFile.println("      } catch (GotoException e) {");
                this.progFile.println("         perform (e.parNum, " + this.procedure.getParCount() + ");");
                this.progFile.println("      } finally {");
            }
            if (this.getSplitFlag()) {
                this.progFile.println("$$theProgram$$.finalize();");
            } else {
                this.progFile.println(this.getFinalizeCode());
            }
            if (this.atProgramEnd != null) {
                if (bl3) {
                    this.progFile.println("      " + ProcedureDivision.getDebugExitCode());
                }
                this.progFile.println("      }");
            }
            this.progFile.println("   }");
        }
    }

    private void writeEnvironment(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws GeneralErrorException {
        if (this.environment != null) {
            if (stringBuffer2 != null) {
                stringBuffer2.append(this.environment.getCode(stringBuffer) + eol);
            } else {
                this.progFile.println(this.environment.getCode(stringBuffer));
            }
        }
    }

    private int writeData(StringBuffer stringBuffer, StringBuffer stringBuffer2, int n2, boolean bl, boolean bl2) throws GeneralErrorException {
        Object object;
        if (this.optionMS) {
            Switch[] switchArray;
            SpecialNames specialNames;
            ConfigurationSection configurationSection;
            MSVariableGenerator mSVariableGenerator = new MSVariableGenerator(this.parent);
            HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> hashMap = new HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>>();
            Vector<MSVariableGenerator.Vd> vector = new Vector<MSVariableGenerator.Vd>();
            hashMap.put(null, vector);
            CobolToken cobolToken = this.fixedVars.getFirst();
            while (cobolToken != null) {
                this.addVar(hashMap, vector, (VariableDeclaration)cobolToken);
                cobolToken = this.fixedVars.getNext();
            }
            cobolToken = this.parent.getEnvironmentDivision();
            if (cobolToken != null && (configurationSection = ((EnvironmentDivision)cobolToken).getConfigurationSection()) != null && (specialNames = configurationSection.getSpecialNames()) != null && specialNames.hasSwitches()) {
                switchArray = specialNames.getSwitches();
                for (int i2 = 0; i2 <= 26; ++i2) {
                    if (switchArray[i2] == null) continue;
                    this.addVar(hashMap, vector, switchArray[i2].var);
                }
            }
            if (this.data != null) {
                VariableDeclaration variableDeclaration;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                WorkingStorageSection workingStorageSection;
                Object object6;
                switchArray = this.data.getFileSection();
                if (switchArray != null) {
                    FileDescriptorList fileDescriptorList = switchArray.getFileDescriptorList();
                    object6 = fileDescriptorList.getFirst();
                    while (object6 != null) {
                        if (!((FileDescriptor)object6).threadLocal) {
                            this.addVar(hashMap, vector, ((FileDescriptor)object6).getVirtualParent());
                        }
                        object6 = fileDescriptorList.getNext();
                    }
                }
                if ((workingStorageSection = this.data.getWorkingStorageSection()) != null) {
                    object6 = workingStorageSection.getVariableDeclarationList();
                    object5 = ((VariableDeclarationList)object6).getFirst();
                    while (object5 != null) {
                        this.addVar(hashMap, vector, (VariableDeclaration)object5);
                        object5 = ((VariableDeclarationList)object6).getNext();
                    }
                }
                this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.WORKING_STORAGE_SECTION, vector));
                object6 = this.data.getLinkageSection();
                if (object6 != null) {
                    vector = new Vector();
                    hashMap.put(null, vector);
                    object5 = ((LinkageSection)object6).getVariableDeclarationList();
                    object4 = ((VariableDeclarationList)object5).getFirst();
                    while (object4 != null) {
                        this.addVar(hashMap, vector, (VariableDeclaration)object4);
                        object4 = ((VariableDeclarationList)object5).getNext();
                    }
                    this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.LINKAGE_SECTION, vector));
                }
                if ((object5 = this.data.getLocalStorageSection()) != null) {
                    vector = new Vector();
                    hashMap.put(null, vector);
                    object4 = ((StorageSection)object5).getVariableDeclarationList();
                    object3 = ((VariableDeclarationList)object4).getFirst();
                    while (object3 != null) {
                        this.addVar(hashMap, vector, (VariableDeclaration)object3);
                        object3 = ((VariableDeclarationList)object4).getNext();
                    }
                    this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.LOCAL_STORAGE_SECTION, vector));
                }
                if ((object4 = this.data.getThreadLocalStorageSection()) != null) {
                    vector = new Vector();
                    hashMap.put(null, vector);
                    if (switchArray != null) {
                        object3 = switchArray.getFileDescriptorList();
                        object2 = ((FileDescriptorList)object3).getFirst();
                        while (object2 != null) {
                            if (((FileDescriptor)object2).threadLocal) {
                                this.addVar(hashMap, vector, ((FileDescriptor)object2).getVirtualParent());
                            }
                            object2 = ((FileDescriptorList)object3).getNext();
                        }
                        object2 = ((StorageSection)object4).getVariableDeclarationList();
                        variableDeclaration = ((VariableDeclarationList)object2).getFirst();
                        while (variableDeclaration != null) {
                            this.addVar(hashMap, vector, variableDeclaration);
                            variableDeclaration = ((VariableDeclarationList)object2).getNext();
                        }
                    } else {
                        object3 = ((StorageSection)object4).getVariableDeclarationList();
                        object2 = ((VariableDeclarationList)object3).getFirst();
                        while (object2 != null) {
                            this.addVar(hashMap, vector, (VariableDeclaration)object2);
                            object2 = ((VariableDeclarationList)object3).getNext();
                        }
                    }
                    this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.THREAD_LOCAL_STORAGE_SECTION, vector));
                }
                if ((object3 = this.data.getScreenSection()) != null && ((ScreenSection)object3).vars.getItemNum() > 0 || this.useScreen) {
                    vector = new Vector();
                    hashMap.put(null, vector);
                    if (object3 != null) {
                        object2 = ((ScreenSection)object3).getVariableDeclarationList();
                        variableDeclaration = ((VariableDeclarationList)object2).getFirst();
                        while (variableDeclaration != null) {
                            this.addVar(hashMap, vector, variableDeclaration);
                            variableDeclaration = ((VariableDeclarationList)object2).getNext();
                        }
                    }
                    this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.SCREEN_SECTION, vector));
                }
                if ((object2 = this.data.getReportSection()) != null) {
                    this.progFile.print(((ReportSection)object2).getCode(stringBuffer));
                }
                if (object5 != null) {
                    this.progFile.println("   public static Object s_newLocalStorage() {");
                    this.progFile.println("      return new LocalStorageSection(CobolVarHelper.getSectionHelper(\"" + (Object)((Object)MSVariableGenerator.Type.LOCAL_STORAGE_SECTION) + "\", " + mSVariableGenerator.getOptions() + "));");
                    this.progFile.println("   }");
                    this.progFile.println("   public Object newLocalStorage() {");
                    this.progFile.println("      return s_newLocalStorage();");
                    this.progFile.println("   }");
                }
                if (object4 != null) {
                    this.progFile.println("   public static String s_threadLocalStorageName() {");
                    this.progFile.println("      return " + this.getClassName() + ".class.getName();");
                    this.progFile.println("   }");
                    this.progFile.println("   public Object newThreadLocalStorage() {");
                    this.progFile.println("      return new ThreadLocalStorageSection(CobolVarHelper.getSectionHelper(\"" + (Object)((Object)MSVariableGenerator.Type.THREAD_LOCAL_STORAGE_SECTION) + "\", " + mSVariableGenerator.getOptions() + "));");
                    this.progFile.println("   }");
                    this.progFile.println("   public static Object s_newThreadLocalStorage() {");
                    this.progFile.print("      return new ");
                    if (switchArray != null && switchArray.hasThreadLocal()) {
                        this.progFile.print(this.getClassName() + "().newThreadLocalStorage()");
                    } else {
                        this.progFile.print("ThreadLocalStorageSection(null)");
                    }
                    this.progFile.println(";");
                    this.progFile.println("   }");
                    this.progFile.println("   public String threadLocalStorageName() {");
                    this.progFile.println("      return s_threadLocalStorageName();");
                    this.progFile.println("   }");
                }
            } else {
                this.progFile.println(mSVariableGenerator.generateVars(MSVariableGenerator.Type.WORKING_STORAGE_SECTION, vector));
            }
            switchArray = (String[][])mSVariableGenerator.getClassToBeRemoved().toArray((T[])new String[mSVariableGenerator.getClassToBeRemoved().size()][]);
            ((StandardPhases)this.parent.getPhases()).getClassToBeRemoved().add((String[][])switchArray);
            return n2;
        }
        Object object7 = this.fixedVars.getFirst();
        while (object7 != null) {
            this.progFile.println(((VariableDeclaration)object7).getCode(stringBuffer2));
            object7 = this.fixedVars.getNext();
        }
        if (this.data != null) {
            if (this.getSplitFlag()) {
                object7 = new StringBuffer();
                object = new StringBuffer();
                ((StringBuffer)object7).append(this.data.getCode(stringBuffer, (StringBuffer)object, null));
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(((StringBuffer)object7).toString()));
                String string = null;
                try {
                    string = lineNumberReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int n3 = 0;
                while (string != null) {
                    if (n3 > 0 && n3 % 30000 == 0) {
                        this.progFile.println("   }");
                        this.progFile.print("   public class inner_" + n2);
                        this.progFile.print(" extends inner_" + (n2 - 1));
                        if (bl) {
                            this.progFile.print(" implements IscobolDebugger");
                        }
                        if (bl2) {
                            this.progFile.print(", IscobolDebuggerExtension");
                        }
                        this.progFile.println(" {");
                        this.progFile.println("   public inner_" + n2 + "() {}");
                        ++n2;
                    }
                    this.progFile.println(string);
                    try {
                        string = lineNumberReader.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++n3;
                }
                this.progFile.println("   }");
                this.progFile.print("   public class inner_" + n2);
                this.progFile.print(" extends inner_" + (n2 - 1));
                if (bl) {
                    this.progFile.print(" implements IscobolDebugger");
                }
                if (bl2) {
                    this.progFile.print(", IscobolDebuggerExtension");
                }
                this.progFile.println(" {");
                this.progFile.println("   public inner_" + n2 + "() {}");
                ++n2;
                this.progFile.print(((StringBuffer)object).toString());
            } else {
                this.progFile.println(this.data.getCode(stringBuffer, null));
            }
        }
        if (this.calls.size() > 0) {
            object = this.calls.elements();
            while (object.hasMoreElements()) {
                object7 = (Token)object.nextElement();
                this.progFile.println("public   " + Call.getClassName((Token)object7) + " " + Call.getObjName((Token)object7) + " = new " + Call.getClassName((Token)object7) + "();");
            }
        }
        return n2;
    }

    private void addVar(HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> hashMap, Vector<MSVariableGenerator.Vd> vector, VariableDeclaration variableDeclaration) {
        MSVariableGenerator.Vd vd = new MSVariableGenerator.Vd(variableDeclaration);
        vector.addElement(vd);
        this.addChildren(hashMap, vd, variableDeclaration);
    }

    private void addChildren(HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> hashMap, MSVariableGenerator.Vd vd, VariableDeclaration variableDeclaration) {
        if (variableDeclaration.children != null) {
            vd.children = new Vector();
            hashMap.put(variableDeclaration, vd.children);
            VariableDeclaration variableDeclaration2 = variableDeclaration.children.getFirst();
            while (variableDeclaration2 != null) {
                MSVariableGenerator.Vd vd2;
                if (variableDeclaration2.level == 78 || variableDeclaration2.level == 66) {
                    vd2 = new MSVariableGenerator.Vd(variableDeclaration2);
                    hashMap.get(null).addElement(vd2);
                } else if (variableDeclaration2.level >= 1 && variableDeclaration2.level <= 49 || variableDeclaration2.level == 88) {
                    vd2 = new MSVariableGenerator.Vd(variableDeclaration2);
                    int n2 = variableDeclaration2.getNameToken().getFileIndex();
                    boolean bl = true;
                    if (n2 != variableDeclaration.getNameToken().getFileIndex()) {
                        Object object;
                        for (object = variableDeclaration.getParent(); object != null; object = ((VariableDeclaration)object).getParent()) {
                            if (((VariableDeclaration)object).getNameToken().getFileIndex() != n2) continue;
                            Vector<MSVariableGenerator.Vd> vector = hashMap.get(((VariableDeclaration)object).getParent());
                            vector.addElement(vd2);
                            bl = false;
                            break;
                        }
                        if (bl && n2 == 0) {
                            object = hashMap.get(null);
                            ((Vector)object).addElement(vd2);
                            bl = false;
                        }
                    }
                    if (bl) {
                        vd.children.addElement(vd2);
                        vd.hasRealChildren = variableDeclaration2.level != 88;
                    }
                    this.addChildren(hashMap, vd2, variableDeclaration2);
                }
                variableDeclaration2 = variableDeclaration.children.getNext();
            }
        }
    }

    private int writeProcedure(int n2) {
        if (this.procedure != null) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = this.procedure.getCode(stringBuffer, n2);
            this.progFile.println(stringBuffer);
        }
        return n2;
    }

    @Override
    public void setProgName(String string) {
        this.parent.setProgName(string);
    }

    @Override
    public String getProgName() {
        return this.parent.getProgName();
    }

    @Override
    protected void setClassName(String string) {
        this.parent.setClassName(string);
    }

    @Override
    public String getClassName() {
        return this.parent.getClassName();
    }

    @Override
    public String getInheritsClass() {
        return null;
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String string) {
        return this.parent.isThisClass(string);
    }

    @Override
    public EnvironmentDivision getEnvironmentDivision() {
        return this.environment;
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String string) {
        return this.parent.getSpecialNamesClass(string);
    }

    boolean setAtProgramStart(Use use) {
        if (this.atProgramStart != null) {
            return false;
        }
        this.atProgramStart = use;
        return true;
    }

    boolean setAtProgramEnd(Use use) {
        if (this.atProgramEnd != null) {
            return false;
        }
        this.atProgramEnd = use;
        return true;
    }
}

