/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.ElkParser;
import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.ErrorLimitReachedException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GUIControl;
import com.iscobol.compiler.MyStringTokenizer;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.OptionListForCodeAnalyzer;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.SMAPGenerator;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.client.Client;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.ICompilerExtension8;
import com.iscobol.interfaces.compiler.IError;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.IOptionListForCodeAnalyzer;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.IPreProcessorReaderProvider;
import com.iscobol.interfaces.compiler.IRealTimePreProcessor;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.ITokenList;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.interfaces.compiler.IVariableDeclaration;
import com.iscobol.interfaces.compiler.InvokeNotifier;
import com.iscobol.interfaces.compiler.ReferencedPccNotifier;
import com.iscobol.interfaces.compiler.VerbNotifier;
import com.iscobol.interfaces.compiler.remote.IRemoteCompiler;
import com.iscobol.interfaces.compiler.remote.IRemoteCompilerClient;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public class CompilerImpl
implements ICompilerExtension8 {
    private static Map<Integer, Set<String>> wd2UnsupportedEvents;
    private static Collection<String> windowWd2UnsupportedStyles;
    private static Collection<String> windowWd2UnsupportedProperties;
    private static Set<String> wd2UnsupportedControls;
    private static Set<Integer> wd2UnsupportedControlsTypes;
    private static final Hashtable nrw;

    @Override
    public IOptionList newOptionList(String[] stringArray) {
        return new OptionList(stringArray);
    }

    @Override
    public IErrors newErrors() {
        return new Errors();
    }

    @Override
    public IPreProcessor newPreProcessor(String string, String string2, IOptionList iOptionList, IErrors iErrors) {
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return new PreProcessor(string, string2, (OptionList)iOptionList, (Errors)iErrors);
    }

    @Override
    public IPreProcessor newPreProcessor(String string, String string2, IOptionList iOptionList, IErrors iErrors, FileFinder fileFinder) {
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return new PreProcessor(string, string2, (OptionList)iOptionList, (Errors)iErrors, fileFinder, null);
    }

    @Override
    public ITokenManager newTokenManager(IPreProcessor iPreProcessor, IOptionList iOptionList, IErrors iErrors) {
        if (iPreProcessor != null && !(iPreProcessor instanceof PreProcessor)) {
            throw new IllegalArgumentException(iPreProcessor.toString());
        }
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return new TokenManager((PreProcessor)iPreProcessor, (OptionList)iOptionList, (Errors)iErrors);
    }

    @Override
    public IPcc newPcc(String string, String string2, String string3, ITokenManager iTokenManager, IOptionList iOptionList, IErrors iErrors) {
        if (iTokenManager != null && !(iTokenManager instanceof TokenManager)) {
            throw new IllegalArgumentException(iTokenManager.toString());
        }
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return new Pcc(string, string2, string3, (TokenManager)iTokenManager, (OptionList)iOptionList, (Errors)iErrors, null);
    }

    @Override
    public IToken newToken(IToken iToken) {
        if (!(iToken instanceof Token)) {
            throw new IllegalArgumentException("" + iToken);
        }
        return new Token((Token)iToken);
    }

    @Override
    public IToken newToken(char c2, int n2, int n3, String string) {
        return new Token(c2, n2, n3, string);
    }

    @Override
    public IToken newToken(int n2, String string, int n3, int n4, String string2) {
        return new Token(n2, string, n3, n4, string2);
    }

    @Override
    public IVariableDeclaration newVariableDeclaration(IPcc iPcc, IToken iToken, ITokenManager iTokenManager) {
        if (iPcc != null && !(iPcc instanceof Pcc)) {
            throw new IllegalArgumentException(iPcc.toString());
        }
        if (iToken != null && !(iToken instanceof Token)) {
            throw new IllegalArgumentException(iToken.toString());
        }
        if (!(iTokenManager instanceof TokenManager)) {
            throw new IllegalArgumentException("" + iTokenManager);
        }
        return new VariableDeclaration((Pcc)iPcc, (Token)iToken, (TokenManager)iTokenManager);
    }

    @Override
    public IVariableDeclaration newVariableDeclaration(IPcc iPcc, ITokenManager iTokenManager, IErrors iErrors, IVariableDeclaration iVariableDeclaration) throws Exception {
        if (iPcc != null && !(iPcc instanceof Pcc)) {
            throw new IllegalArgumentException(iPcc.toString());
        }
        if (!(iTokenManager instanceof TokenManager)) {
            throw new IllegalArgumentException("" + iTokenManager);
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        if (iVariableDeclaration != null && !(iVariableDeclaration instanceof VariableDeclaration)) {
            throw new IllegalArgumentException(iVariableDeclaration.toString());
        }
        return new VariableDeclaration((Pcc)iPcc, (TokenManager)iTokenManager, (Errors)iErrors, (VariableDeclaration)iVariableDeclaration);
    }

    @Override
    public ITokenList tokenizer(StringBuffer stringBuffer, char c2, boolean bl) {
        return PreProcessor.tokenizer(stringBuffer, c2, bl, nrw);
    }

    @Override
    public ITokenList tokenizer(StringBuffer stringBuffer, char c2, boolean bl, boolean bl2) {
        return PreProcessor.tokenizer(stringBuffer, c2, bl, bl2, nrw);
    }

    @Override
    public boolean tokenizer(ITokenList iTokenList, StringBuffer stringBuffer, int n2, String string, boolean bl, char c2, IErrors iErrors, boolean bl2, boolean bl3, int n3, boolean bl4) {
        if (!(iTokenList instanceof TokenList)) {
            throw new IllegalArgumentException("" + iTokenList);
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        boolean[] blArray = new boolean[5];
        blArray[2] = bl4;
        int n4 = PreProcessor.tokenizer((TokenList)iTokenList, stringBuffer, n2, string, bl ? 2 : 0, c2, blArray, (Errors)iErrors, bl2, bl3, n3);
        return n4 == 2;
    }

    @Override
    public Enumeration<String> getCompilerOptionsStringTokenizer(String string) {
        return new MyStringTokenizer(string);
    }

    @Override
    public void resetAllCounters() {
        Pcc.resetAllCounters();
        Token.restoreKeywords();
    }

    @Override
    public void setInvokeNotifier(InvokeNotifier invokeNotifier) {
        Pcc.setInvokeNotifier(invokeNotifier);
    }

    @Override
    public InvokeNotifier getInvokeNotifier() {
        return Pcc.getInvokeNotifier();
    }

    @Override
    public void setVerbNotifier(VerbNotifier verbNotifier) {
        Pcc.setVerbNotifier(verbNotifier);
    }

    @Override
    public VerbNotifier getVerbNotifier() {
        return Pcc.getVerbNotifier();
    }

    @Override
    public IPcc analyze(String string, IOptionList iOptionList, IErrors iErrors, Reader reader, FileFinder fileFinder) {
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return Pcc.analyze(string, (OptionList)iOptionList, (Errors)iErrors, reader, fileFinder, null);
    }

    @Override
    public IPcc run(String string, String string2, IOptionList iOptionList, String string3, IErrors iErrors, Reader reader, boolean bl, FileFinder fileFinder) throws ErrorInCompilationException {
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        if (iErrors != null && !(iErrors instanceof Errors)) {
            throw new IllegalArgumentException(iErrors.toString());
        }
        return Pcc.run(string, string2, (OptionList)iOptionList, string3, (Errors)iErrors, reader, bl, fileFinder, null);
    }

    @Override
    public IPcc getPcc(Exception exception) {
        if (exception instanceof ErrorInCompilationException) {
            return ((ErrorInCompilationException)exception).pcc;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean optionValueIsDirectory(String string) {
        return OptionList.valueIsDirectory(string);
    }

    @Override
    public boolean optionValueIsPath(String string) {
        return OptionList.valueIsPath(string);
    }

    @Override
    public boolean optionValueIsFile(String string) {
        return OptionList.valueIsFile(string);
    }

    @Override
    public boolean optionHasValue(String string) {
        return OptionList.hasValue(string);
    }

    @Override
    public boolean optionIsImplicit(String string) {
        return OptionList.isImplicit(string);
    }

    @Override
    public boolean optionIsExperimental(String string) {
        return OptionList.isExperimental(string);
    }

    @Override
    public Map<String, String[]> getImplicitOptions() {
        return OptionList.getImplicits();
    }

    @Override
    public Enumeration<String> getAllOptionKeys(boolean bl) {
        return OptionList.getAllOptionKeys(bl);
    }

    @Override
    public int getAllOptionCount() {
        return OptionList.getAllOptionCount();
    }

    @Override
    public IOptionListForCodeAnalyzer newOptionListForCodeAnalyzer(String[] stringArray) {
        return OptionListForCodeAnalyzer.newInstance(stringArray);
    }

    @Override
    public IErrors newErrorsForCodeAnalyzer() {
        return new ErrorsExt(false);
    }

    @Override
    public IErrors newErrorsForCodeAnalyzer(boolean bl) {
        return new ErrorsExt(bl);
    }

    @Override
    public ITokenList newTokenList() {
        return new TokenList();
    }

    @Override
    public IError newError(String string) {
        return new ErrorObj(0, 0, 0, 0, null, string, null);
    }

    @Override
    public IRemoteCompilerClient newRemoteCompilerClient() {
        return new Client();
    }

    @Override
    public void generateSMAPInfos(String string) throws IOException {
        new SMAPGenerator(string);
    }

    @Override
    public void generateSMAPInfos(String string, FileFinder fileFinder) throws IOException {
        new SMAPGenerator(string);
    }

    @Override
    public IRealTimePreProcessor newRealTimePreProcessor(String string, FileFinder fileFinder, IPreProcessorReaderProvider iPreProcessorReaderProvider) {
        return new RealTimePreProcessor(string, fileFinder, iPreProcessorReaderProvider);
    }

    @Override
    public IRemoteCompiler newRemoteCompiler(Element element) throws XmlParseException {
        return new RemoteCompiler(element);
    }

    @Override
    public String getOptionDesc(String string) {
        return OptionList.getOptionDesc(string);
    }

    @Override
    public Vector getGlobalStyleWords() {
        return new Vector<String>(this.getAttributesWords(0, true, false));
    }

    @Override
    public Vector getGlobalPropertyWords() {
        return new Vector<String>(this.getAttributesWords(0, false, false));
    }

    @Override
    public Vector getBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(11, true, false));
    }

    @Override
    public Vector getBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(11, false, false));
    }

    @Override
    public Vector getBitmapStyleWords() {
        return new Vector<String>(this.getAttributesWords(13, true, false));
    }

    @Override
    public Vector getBitmapPropertyWords() {
        return new Vector<String>(this.getAttributesWords(13, false, false));
    }

    @Override
    public Vector getCheckBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(4, true, false));
    }

    @Override
    public Vector getCheckBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(4, false, false));
    }

    @Override
    public Vector getComboBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(8, true, false));
    }

    @Override
    public Vector getComboBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(8, false, false));
    }

    @Override
    public Vector getDateEntryStyleWords() {
        return new Vector<String>(this.getAttributesWords(20, true, false));
    }

    @Override
    public Vector getDateEntryPropertyWords() {
        return new Vector<String>(this.getAttributesWords(20, false, false));
    }

    @Override
    public Vector getEntryFieldStyleWords() {
        return new Vector<String>(this.getAttributesWords(2, true, false));
    }

    @Override
    public Vector getEntryFieldPropertyWords() {
        return new Vector<String>(this.getAttributesWords(2, false, false));
    }

    @Override
    public Vector getFrameStyleWords() {
        return new Vector<String>(this.getAttributesWords(9, true, false));
    }

    @Override
    public Vector getFramePropertyWords() {
        return new Vector<String>(this.getAttributesWords(9, false, false));
    }

    @Override
    public Vector getGridStyleWords() {
        return new Vector<String>(this.getAttributesWords(12, true, false));
    }

    @Override
    public Vector getGridPropertyWords() {
        return new Vector<String>(this.getAttributesWords(12, false, false));
    }

    @Override
    public Vector getJavaBeanStyleWords() {
        return new Vector<String>(this.getAttributesWords(19, true, false));
    }

    @Override
    public Vector getJavaBeanPropertyWords() {
        return new Vector<String>(this.getAttributesWords(19, false, false));
    }

    @Override
    public Vector getLabelStyleWords() {
        return new Vector<String>(this.getAttributesWords(1, true, false));
    }

    @Override
    public Vector getLabelPropertyWords() {
        return new Vector<String>(this.getAttributesWords(1, false, false));
    }

    @Override
    public Vector getListBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(7, true, false));
    }

    @Override
    public Vector getListBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(7, false, false));
    }

    @Override
    public Vector getPushButtonStyleWords() {
        return new Vector<String>(this.getAttributesWords(3, true, false));
    }

    @Override
    public Vector getPushButtonPropertyWords() {
        return new Vector<String>(this.getAttributesWords(3, false, false));
    }

    @Override
    public Vector getRadioButtonStyleWords() {
        return new Vector<String>(this.getAttributesWords(5, true, false));
    }

    @Override
    public Vector getRadioButtonPropertyWords() {
        return new Vector<String>(this.getAttributesWords(5, false, false));
    }

    @Override
    public Vector getScrollBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(6, true, false));
    }

    @Override
    public Vector getScrollBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(6, false, false));
    }

    @Override
    public Vector getSliderStyleWords() {
        return new Vector<String>(this.getAttributesWords(18, true, false));
    }

    @Override
    public Vector getSliderPropertyWords() {
        return new Vector<String>(this.getAttributesWords(18, false, false));
    }

    @Override
    public Vector getStatusBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(17, true, false));
    }

    @Override
    public Vector getStatusBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(17, false, false));
    }

    @Override
    public Vector getTabControlStyleWords() {
        return new Vector<String>(this.getAttributesWords(10, true, false));
    }

    @Override
    public Vector getTabControlPropertyWords() {
        return new Vector<String>(this.getAttributesWords(10, false, false));
    }

    @Override
    public Vector getTreeViewStyleWords() {
        return new Vector<String>(this.getAttributesWords(14, true, false));
    }

    @Override
    public Vector getTreeViewPropertyWords() {
        return new Vector<String>(this.getAttributesWords(14, false, false));
    }

    @Override
    public Vector getWebBrowserStyleWords() {
        return new Vector<String>(this.getAttributesWords(15, true, false));
    }

    @Override
    public Vector getWebBrowserPropertyWords() {
        return new Vector<String>(this.getAttributesWords(15, false, false));
    }

    public Vector getChipsBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(24, true, false));
    }

    public Vector getChipsBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(24, false, false));
    }

    @Override
    public Vector getControlTypeNames() {
        return new Vector<String>(GUIControl.controlNames.values());
    }

    @Override
    public Set<String> getElkTypeNames() {
        return ElkParser.getAllTypes();
    }

    @Override
    public Set<String> getAttributesWords(int n2, boolean bl, boolean bl2) {
        Collection<Object> collection;
        switch (n2) {
            case 0: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.globalUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.globalStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.globalUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.globalPropertyWords;
                break;
            }
            case 11: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.barUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.barStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.barPropertiesWords;
                break;
            }
            case 13: {
                if (bl) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.bitmapUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.bitmapPropertiesWords;
                break;
            }
            case 4: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.checkBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.checkBoxStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.checkBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.checkBoxPropertiesWords;
                break;
            }
            case 8: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.comboBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.comboBoxStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.comboBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.comboBoxPropertiesWords;
                break;
            }
            case 20: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.dateEntryUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.dateEntryStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.dateEntryUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.dateEntryPropertiesWords;
                break;
            }
            case 2: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.entryFieldUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.entryFieldStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.entryFieldUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.entryFieldPropertiesWords;
                break;
            }
            case 9: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.frameUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.frameStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.frameUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.framePropertiesWords;
                break;
            }
            case 12: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.gridUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.gridStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.gridUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.gridPropertiesWords;
                break;
            }
            case 19: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.javaBeanUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.javaBeanStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.javaBeanUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.javaBeanPropertiesWords;
                break;
            }
            case 1: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.labelUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.labelStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.labelUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.labelPropertiesWords;
                break;
            }
            case 7: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.listBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.listBoxStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.listBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.listBoxPropertiesWords;
                break;
            }
            case 16: {
                collection = Collections.EMPTY_LIST;
                break;
            }
            case 3: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.pushButtonUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.pushButtonStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.pushButtonUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.pushButtonPropertiesWords;
                break;
            }
            case 5: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.radioButtonUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.radioButtonStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.radioButtonUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.radioButtonPropertiesWords;
                break;
            }
            case 21: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.ribbonStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.ribbonPropertiesWords;
                break;
            }
            case 23: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.iwcPanelStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.iwcPanelPropertiesWords;
                break;
            }
            case 22: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.scrollPaneStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.scrollPanePropertiesWords;
                break;
            }
            case 6: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.scrollBarStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.scrollBarPropertiesWords;
                break;
            }
            case 18: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.sliderStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.sliderPropertiesWords;
                break;
            }
            case 17: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.statusBarStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.statusBarPropertiesWords;
                break;
            }
            case 10: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.tabUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.tabStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.tabUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.tabPropertiesWords;
                break;
            }
            case 14: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.treeUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.treeStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.treeUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.treePropertiesWords;
                break;
            }
            case 15: {
                if (bl) {
                    if (bl2) {
                        collection = Collections.EMPTY_LIST;
                        break;
                    }
                    collection = GUIControl.webBrowserStyleWords;
                    break;
                }
                if (bl2) {
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                collection = GUIControl.webBrowserPropertiesWords;
                break;
            }
            case 24: {
                if (bl) {
                    if (bl2) {
                        collection = GUIControl.chipsBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    collection = GUIControl.chipsBoxStyleWords;
                    break;
                }
                if (bl2) {
                    collection = GUIControl.chipsBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                collection = GUIControl.chipsBoxPropertiesWords;
                break;
            }
            case 100: {
                if (bl) {
                    if (bl2) {
                        collection = windowWd2UnsupportedStyles;
                        break;
                    }
                    collection = Collections.EMPTY_LIST;
                    break;
                }
                if (bl2) {
                    collection = windowWd2UnsupportedProperties;
                    break;
                }
                collection = Collections.EMPTY_LIST;
                break;
            }
            default: {
                collection = Collections.EMPTY_LIST;
            }
        }
        return new HashSet<String>(collection);
    }

    @Override
    public Set<String> getWd2UnsupportedEvents(int n2) {
        Set set = wd2UnsupportedEvents.get(n2);
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    @Override
    public Set<String> getWd2UnsupportedControls() {
        return wd2UnsupportedControls;
    }

    @Override
    public Set<Integer> getWd2UnsupportedControlsTypes() {
        return wd2UnsupportedControlsTypes;
    }

    @Override
    public void removeClasses(String string, String string2, boolean bl) {
        Pcc.removeClasses(string, string2, bl);
    }

    @Override
    public ReferencedPccNotifier getReferencedPccNotifier() {
        return Pcc.getReferencedPccNotifier();
    }

    @Override
    public void setReferencedPccNotifier(ReferencedPccNotifier referencedPccNotifier) {
        Pcc.setReferencedPccNotifier(referencedPccNotifier);
    }

    static {
        windowWd2UnsupportedStyles = new ArrayList<String>();
        windowWd2UnsupportedStyles.add("CONTROLS-UNCROPPED");
        windowWd2UnsupportedStyles.add("SCROLL");
        windowWd2UnsupportedStyles.add("SHADOW");
        windowWd2UnsupportedProperties = new ArrayList<String>();
        windowWd2UnsupportedProperties.add("AUTO-RESIZE");
        windowWd2UnsupportedProperties.add("MIN-SIZE");
        windowWd2UnsupportedProperties.add("MIN-LINES");
        windowWd2UnsupportedProperties.add("MAX-SIZE");
        windowWd2UnsupportedProperties.add("MAX-LINES");
        windowWd2UnsupportedProperties.add("LAYOUT-MANAGER");
        windowWd2UnsupportedProperties.add("WINDOW-STATE");
        wd2UnsupportedControls = new HashSet<String>();
        wd2UnsupportedControls.add("RIBBON");
        wd2UnsupportedControls.add("SCROLL-BAR");
        wd2UnsupportedControls.add("SLIDER");
        wd2UnsupportedControls.add("STATUS-BAR");
        wd2UnsupportedControls.add("WEB-BROWSER");
        wd2UnsupportedControls.add("IWC-PANEL");
        wd2UnsupportedControlsTypes = new HashSet<Integer>();
        wd2UnsupportedControlsTypes.add(21);
        wd2UnsupportedControlsTypes.add(23);
        wd2UnsupportedControlsTypes.add(6);
        wd2UnsupportedControlsTypes.add(18);
        wd2UnsupportedControlsTypes.add(17);
        wd2UnsupportedControlsTypes.add(15);
        wd2UnsupportedControlsTypes.add(23);
        wd2UnsupportedEvents = new HashMap<Integer, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        wd2UnsupportedEvents.put(11, hashSet);
        hashSet = new HashSet();
        hashSet.add("MSG-MOUSE-ENTERED");
        hashSet.add("MSG-MOUSE-EXITED");
        hashSet.add("MSG-MOUSE-CLICKED");
        hashSet.add("MSG-MOUSE-DBLCLICK");
        hashSet.add("EVENT PROCEDURE");
        wd2UnsupportedEvents.put(13, hashSet);
        hashSet = new HashSet();
        hashSet.add("CMD-DBLCLICK");
        wd2UnsupportedEvents.put(8, hashSet);
        hashSet = new HashSet();
        hashSet.add("MSG-SPIN-DOWN");
        hashSet.add("MSG-SPIN-UP");
        wd2UnsupportedEvents.put(2, hashSet);
        hashSet = new HashSet();
        hashSet.add("MSG-BEGIN-ENTRY");
        hashSet.add("MSG-BEGIN-DRAG");
        hashSet.add("MSG-BEGIN-HEADING-DRAG");
        hashSet.add("MSG-COL-WIDTH-CHANGED");
        hashSet.add("MSG-END-DRAG");
        hashSet.add("MSG-END-HEADING-DRAG");
        hashSet.add("MSG-GOTO-CELL");
        hashSet.add("MSG-GOTO-CELL-DRAG");
        hashSet.add("MSG-HEADING-DRAGGED");
        wd2UnsupportedEvents.put(12, hashSet);
        hashSet = new HashSet();
        hashSet.add("MSG-TV-EXPANDING");
        hashSet.add("MSG-TV-SELCHANGING");
        hashSet.add("MSG-BEGIN-ENTRY");
        hashSet.add("MSG-CANCEL-ENTRY");
        hashSet.add("MSG-FINISH-ENTRY");
        wd2UnsupportedEvents.put(9, hashSet);
        hashSet = new HashSet();
        hashSet.add("AFTER PROCEDURE");
        hashSet.add("BEFORE PROCEDURE");
        wd2UnsupportedEvents.put(10, hashSet);
        hashSet = new HashSet();
        hashSet.add("CMD-ACTIVATE");
        hashSet.add("NTF-RESIZED");
        wd2UnsupportedEvents.put(100, hashSet);
        nrw = new Hashtable();
    }

    private static class ErrorsExt
    extends Errors {
        private static final long serialVersionUID = 1L;
        public static final int TASK_TYPE = 1001;
        private boolean wu;

        public ErrorsExt(boolean bl) {
            this.wu = bl;
        }

        @Override
        public void printTask(int n2, int n3, int n4, String string, String string2) {
            this.allMessages.addElement(new ErrorObj(1001, n2, n3, n4, string2, string, null));
        }

        @Override
        public void print(int n2, int n3, int n4, int n5, String string, Exception exception, String string2) {
            String string3;
            if (this.ignoreErrors) {
                return;
            }
            n3 = Config.a(".compiler.messagelevel." + n2, n3);
            switch (n3) {
                case 0: {
                    return;
                }
                case 1: {
                    string3 = "--I: ";
                    break;
                }
                case 2: {
                    string3 = "--W: ";
                    break;
                }
                case 3: {
                    string3 = "--E: ";
                    break;
                }
                case 4: {
                    string3 = "--S: ";
                    break;
                }
                default: {
                    string3 = "--?: ";
                }
            }
            string3 = string3 + "#" + n2 + " ";
            String string4 = (String)errorDesc.get(new Integer(n2));
            string3 = string3 + string4;
            if (string != null) {
                string3 = string3 + " " + string;
            }
            this.allMessages.addElement(new ErrorObj(n2, n3, n4, n5, string2, string3, string));
            switch (n3) {
                case 1: {
                    ++this.info;
                    break;
                }
                case 2: {
                    ++this.warning;
                    break;
                }
                case 3: {
                    ++this.rErrors;
                    break;
                }
                case 4: {
                    ++this.sErrors;
                    break;
                }
            }
            if (this.getMaxErrors() > 0 && this.sErrors >= this.getMaxErrors()) {
                throw new ErrorLimitReachedException();
            }
        }

        @Override
        public boolean printEndMessage() {
            return this.sErrors > 0;
        }

        @Override
        public int getTotalErrorCount() {
            int n2 = this.info + this.warning + this.rErrors + this.sErrors;
            if (!this.wu) {
                for (int i2 = 0; i2 < this.allMessages.size() && n2 > 0; ++i2) {
                    ErrorObj errorObj = (ErrorObj)this.allMessages.elementAt(i2);
                    if (errorObj.getErrorNumber() != 108) continue;
                    --n2;
                }
            }
            return n2;
        }

        @Override
        public int getErrorCount(int n2) {
            switch (n2) {
                case 1: {
                    return this.info;
                }
                case 2: {
                    int n3 = this.warning;
                    if (!this.wu) {
                        for (int i2 = 0; i2 < this.allMessages.size() && n3 > 0; ++i2) {
                            ErrorObj errorObj = (ErrorObj)this.allMessages.elementAt(i2);
                            if (errorObj.getErrorNumber() != 108) continue;
                            --n3;
                        }
                    }
                    return n3;
                }
                case 3: {
                    return this.rErrors;
                }
                case 4: {
                    return this.sErrors;
                }
            }
            return 0;
        }

        @Override
        public Vector getAllMessages() {
            Vector<ErrorObj> vector = new Vector<ErrorObj>();
            if (this.wu) {
                vector.addAll(this.allMessages);
            } else {
                for (int i2 = 0; i2 < this.allMessages.size(); ++i2) {
                    ErrorObj errorObj = (ErrorObj)this.allMessages.elementAt(i2);
                    if (errorObj.getErrorNumber() == 108) continue;
                    vector.addElement(errorObj);
                }
            }
            return vector;
        }
    }

    private static class ErrorObj
    implements IError {
        private int errorNumber;
        private int errorType;
        private int lineNumber;
        private int offset;
        private String message;
        private String filename;
        private String pathFilename;
        private String other;

        public ErrorObj(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
            this.errorNumber = n2;
            this.errorType = n3;
            this.lineNumber = n4;
            this.offset = n5;
            this.message = string2;
            this.pathFilename = string = string.replace('\\', '/');
            this.filename = new File(string).getName();
            this.other = string3;
        }

        @Override
        public int getErrorNumber() {
            return this.errorNumber;
        }

        @Override
        public int getErrorType() {
            return this.errorType;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getPathFilename() {
            return this.pathFilename;
        }

        @Override
        public String getOther() {
            return this.other;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        public String toString() {
            String string;
            if (this.errorNumber != 1001) {
                switch (this.errorType) {
                    case 1: {
                        string = "--I: ";
                        break;
                    }
                    case 2: {
                        string = "--W: ";
                        break;
                    }
                    case 3: {
                        string = "--E: ";
                        break;
                    }
                    case 4: {
                        string = "--S: ";
                        break;
                    }
                    default: {
                        string = "--?: ";
                    }
                }
                string = string + "#" + this.errorNumber + " ";
                string = string + Errors.getErrorDescription(this.errorNumber);
                if (this.other != null) {
                    string = string + " " + this.other;
                }
            } else {
                string = "--Task: " + this.message;
            }
            string = string + "; file = " + this.filename;
            if (this.lineNumber > 0) {
                string = string + ", line = " + this.lineNumber;
            }
            if (this.offset > 0) {
                string = string + ", col " + this.offset;
            }
            return string;
        }
    }

    private static class RealTimePreProcessor
    extends PreProcessor
    implements IRealTimePreProcessor {
        private List<Token> copyStatementTokens = new ArrayList<Token>();
        private IPreProcessorReaderProvider readerProvider;

        public RealTimePreProcessor(String string, FileFinder fileFinder, IPreProcessorReaderProvider iPreProcessorReaderProvider) {
            super(string, null, new OptionList(new String[0]), new Errors(), fileFinder, null);
            if (iPreProcessorReaderProvider == null) {
                throw new IllegalArgumentException("readerProvider = null");
            }
            this.readerProvider = iPreProcessorReaderProvider;
        }

        private RealTimePreProcessor(PreProcessor preProcessor, File file, Writer writer, int n2, ReplaceList replaceList, Errors errors, OptionList optionList, char c2) {
            super(preProcessor, file, writer, n2, replaceList, errors, optionList, c2);
        }

        @Override
        protected PreProcessor createCopyPreProcessor(PreProcessor preProcessor, File file, Writer writer, int n2, ReplaceList replaceList, Errors errors, OptionList optionList, char c2) {
            return new RealTimePreProcessor(preProcessor, file, writer, n2, replaceList, errors, optionList, c2);
        }

        @Override
        protected boolean open(String string) {
            LineNumberReader lineNumberReader = this.getRoot().readerProvider.getReader(string);
            if (lineNumberReader != null) {
                this.src = lineNumberReader;
                return true;
            }
            return super.open(string);
        }

        @Override
        public RealTimePreProcessor getRoot() {
            PreProcessor preProcessor = this;
            while (preProcessor.getParent() != null) {
                preProcessor = preProcessor.getParent();
            }
            return preProcessor;
        }

        public List getCopyStatementTokens() {
            return this.getRoot().copyStatementTokens;
        }

        @Override
        protected int readCopy(Token token, String string, boolean bl, ReplaceList replaceList) {
            int n2 = super.readCopy(token, string, bl, replaceList);
            if (n2 == 0) {
                this.getRoot().copyStatementTokens.add(token);
            }
            return n2;
        }
    }
}

