/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Compute
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private VariableNameList varGiving = new VariableNameList();
    private Expression expr;
    private OnSizeError ose;

    public Compute(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = null;
        int n2 = 0;
        String string = "";
        Token token3 = this.tm.getToken();
        if (token3.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token3, token3.getWord(), this.error);
        }
        while (token3.getToknum() == 10009) {
            int n3;
            token2 = token3;
            this.tm.ungetToken();
            VariableName variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            this.varGiving.addItem(variableName);
            token3 = this.tm.getToken();
            if (!variableName.isNumeric()) {
                throw new GeneralErrorException(23, 4, token2, variableName.toString(), this.error);
            }
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            if (token3.getToknum() == 702) {
                variableName.rounded = true;
                token3 = this.tm.getToken();
                if (variableDeclaration.getDecimals() + 1 > n2) {
                    n2 = variableDeclaration.getDecimals() + 1;
                }
            } else if (variableDeclaration.getDecimals() > n2) {
                n2 = variableDeclaration.getDecimals();
            }
            if (!variableDeclaration.isNumericEdited() || !variableDeclaration.getPicture().contains("" + tokenManager.getDecimalPoint()) && !variableDeclaration.getPicture().contains("P")) continue;
            int n4 = 0;
            string = variableDeclaration.getPicture();
            if (string.contains("" + tokenManager.getDecimalPoint())) {
                string = string.substring(string.indexOf("" + tokenManager.getDecimalPoint()));
                for (n3 = 0; n3 < string.length(); ++n3) {
                    if (string.charAt(n3) != 'Z' && string.charAt(n3) != 'z' && string.charAt(n3) != '9') continue;
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < string.length(); ++n3) {
                    if (string.charAt(n3) != 'P' && string.charAt(n3) != 'p') continue;
                    ++n4;
                }
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        if (token3.getToknum() != 61 && token3.getToknum() != 462) {
            throw new ExpectedFoundException(token3, this.error, "'='");
        }
        int[] nArray = new int[]{0};
        this.expr = new Expression(nArray, token, block, pcc, tokenManager, errors, n2);
        if (this.expr.getType() != 3 && this.expr.getType() != 5) {
            throw new GeneralErrorException(49, 4, token, token.getWord(), this.error);
        }
        if (nArray[0] != 0) {
            throw new GeneralErrorException(44, 4, token, token.getWord(), this.error);
        }
        this.ose = new OnSizeError(token, block, this, pcc, tokenManager, errors);
        if (this.pc.getOption("-wdbz") != null && this.ose.sizeErrorBlock == null && this.expr.hasDivideByZero()) {
            this.error.print(220, 2, token2, "COMPUTE " + token2.getWord());
        }
        this.expr.checkdiv = this.ose.sizeErrorBlock == null;
        token3 = this.tm.getToken();
        if (token3.getToknum() != 427) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.expr.check();
    }

    @Override
    public String getCode() {
        int n2;
        VariableName variableName;
        String string;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        boolean bl2 = this.ose.hasBlocks();
        boolean bl3 = bl = !bl2 && this.expr.couldBeNativeInt();
        if (this.varGiving.getItemNum() > 1) {
            string = "compute$" + Compute.getUniqueId();
            if (bl) {
                stringBuffer.append("long ");
            } else {
                stringBuffer.append("CobolNum ");
            }
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(this.expr.getCode(bl));
            stringBuffer.append(";");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        } else {
            string = this.expr.getCode(bl);
        }
        VariableNameList variableNameList = new VariableNameList();
        int n3 = 0;
        while (n3 < this.varGiving.getItemNum()) {
            variableName = this.varGiving.getAt(n3);
            if (variableName.isPrimitive()) {
                variableNameList.addItem(variableName);
                this.varGiving.deleteCurrent();
                continue;
            }
            ++n3;
        }
        n3 = variableNameList.getItemNum();
        for (n2 = 0; n2 < n3; ++n2) {
            variableName = variableNameList.getAt(n2);
            stringBuffer.append(variableName.getCode());
            String string2 = variableName.getType().getName(true);
            stringBuffer.append(" = ");
            if (bl) {
                if (!"long".equals(string2)) {
                    stringBuffer.append("(").append(string2).append(") ");
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(Compute.getConversionMethod(string2, string));
            }
            stringBuffer.append(";");
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        n3 = this.varGiving.getItemNum();
        if (n3 > 0) {
            if (variableNameList.getItemNum() > 0) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append(this.ose.getCodeBefore());
            for (n2 = 0; n2 < n3; ++n2) {
                variableName = this.varGiving.getAt(n2);
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".set(");
                stringBuffer.append(string);
                if (bl) {
                    stringBuffer.append(",0");
                }
                stringBuffer.append(",");
                stringBuffer.append(variableName.rounded);
                stringBuffer.append(",");
                stringBuffer.append(bl2);
                stringBuffer.append(")");
                if (n2 >= n3 - 1) continue;
                if (bl2) {
                    stringBuffer.append("|");
                    continue;
                }
                stringBuffer.append(";");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append(this.ose.getCode());
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    static String getConversionMethod(String string, String string2) {
        switch (string) {
            case "long": {
                return string2 + ".longValue()";
            }
            case "int": {
                return string2 + ".intValue()";
            }
            case "short": {
                return "(short) " + string2 + ".longValue()";
            }
            case "byte": {
                return "(byte) " + string2 + ".longValue()";
            }
            case "float": {
                return string2 + ".floatValue()";
            }
            case "double": {
                return string2 + ".doubleValue()";
            }
        }
        return "(" + string + ") " + string2 + ".doubleValue()";
    }

    static String addCast(String string, String string2) {
        if ("long".equals(string)) {
            return string2;
        }
        return "(" + string + ") (" + string2 + ")";
    }

    static String getCobolNumCode(VariableName variableName) {
        StringBuffer stringBuffer = new StringBuffer();
        if (variableName.isNumericVar()) {
            stringBuffer.append(variableName.getCode());
            stringBuffer.append(".num()");
        } else {
            stringBuffer.append("CobolNum.noo(");
            if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                stringBuffer.append("(long) ").append(variableName.getCode()).append(", 0)");
            } else {
                stringBuffer.append("(double) ").append(variableName.getCode()).append(")");
            }
        }
        return stringBuffer.toString();
    }
}

