/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CondElement;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;

public class Condition
extends Verb
implements CobolToken,
ErrorsNumbers {
    VerbList allItems = new VerbList();
    int openPar;
    private Expression lastLeft;
    int lastOp = 14;
    boolean fullCondition;

    public Condition(Expression expression, boolean bl, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        SimpleCondition simpleCondition = new SimpleCondition(expression, bl, token, block, pcc, tokenManager, errors);
        this.setLastLeft(simpleCondition.left);
        this.lastOp = simpleCondition.op;
        this.allItems.addItem(simpleCondition);
        this.fullCondition = simpleCondition.isFullCondition();
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 274 || token2.getToknum() == 617) {
            this.allItems.addItem(new CondElement(token2, this.parent, this.pc, this.tm, this.error));
            this.init();
        } else {
            this.tm.ungetToken();
        }
    }

    public Condition(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.init();
    }

    private void init() throws GeneralErrorException, EndOfProgramException {
        while (this.fullCondition = this.parseCond()) {
            Token token = null;
            while (this.openPar > 0 && (token = this.tm.getToken()).getToknum() == 41) {
                this.allItems.addItem(new CondElement(new Token(')', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                --this.openPar;
            }
            if (token == null || token.getToknum() == 41) {
                token = this.tm.getToken();
            }
            if (token.getToknum() == 274 || token.getToknum() == 617) {
                this.allItems.addItem(new CondElement(token, this.parent, this.pc, this.tm, this.error));
                continue;
            }
            this.tm.ungetToken();
            break;
        }
        if (this.openPar != 0) {
            throw new GeneralErrorException(44, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
    }

    void setLastLeft(Expression expression) {
        this.lastLeft = expression.getType() != 1 || expression.isObjectReference() ? expression : null;
    }

    public boolean parseCond() throws GeneralErrorException, EndOfProgramException {
        CobolToken cobolToken;
        Token token;
        int n2 = 0;
        int[] nArray = new int[1];
        while ((token = this.tm.getToken()).getToknum() == 40 || token.getToknum() == 598) {
            if (token.getToknum() == 598) {
                cobolToken = this.tm.getToken();
                this.tm.ungetToken();
                if (SimpleCondition.isBinaryOperator(cobolToken)) break;
                while (n2 > 0) {
                    this.allItems.addItem(new CondElement(new Token('(', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                    ++this.openPar;
                    --n2;
                }
                this.allItems.addItem(new CondElement(token, this.parent, this.pc, this.tm, this.error));
                continue;
            }
            ++n2;
        }
        this.tm.ungetToken();
        nArray[0] = n2;
        SimpleCondition simpleCondition = new SimpleCondition(nArray, this.lastLeft, this.lastOp, this.keyWord, this.parent, this.pc, this.tm, this.error);
        cobolToken = null;
        if (simpleCondition.getLeft() != null && simpleCondition.getRight() != null) {
            if (this.isVarLenGroup(simpleCondition.getLeft())) {
                if (!this.isVarLenGroup(simpleCondition.getRight())) {
                    cobolToken = simpleCondition.getLeft().getAsVar();
                }
            } else if (this.isVarLenGroup(simpleCondition.getRight()) && !this.isVarLenGroup(simpleCondition.getLeft())) {
                cobolToken = simpleCondition.getRight().getAsVar();
            }
        }
        if (cobolToken != null) {
            this.error.print(257, 2, ((VariableName)cobolToken).getNameToken(), ((VariableName)cobolToken).getName());
        }
        if ((n2 = nArray[0]) > 0) {
            while (n2 > 0) {
                this.allItems.addItem(new CondElement(new Token('(', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                ++this.openPar;
                --n2;
            }
        }
        this.setLastLeft(simpleCondition.left);
        this.lastOp = simpleCondition.op;
        this.allItems.addItem(simpleCondition);
        return simpleCondition.isFullCondition();
    }

    private boolean isVarLenGroup(Expression expression) {
        VariableName variableName = expression.getAsVar();
        return variableName != null && variableName.isVariableLengthGroup();
    }

    public boolean isFullCondition() {
        return this.fullCondition;
    }

    public Expression getLeft() {
        return ((SimpleCondition)this.allItems.getFirst()).left;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        Verb verb = this.allItems.getFirst();
        while (verb != null) {
            stringBuffer.append(verb.getCode());
            verb = this.allItems.getNext();
        }
        return stringBuffer.toString();
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb verb = this.allItems.getFirst();
        while (verb != null) {
            verb.check();
            verb = this.allItems.getNext();
        }
    }

    public VerbList getAllItems() {
        return this.allItems;
    }
}

