/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IConfigurationSection;

public class ConfigurationSection
implements CobolToken,
ErrorsNumbers,
IConfigurationSection {
    TokenManager tm;
    Errors error;
    SpecialNames specNames;
    Repository repository;
    Pcc pc;
    private Token programCollatingSeq;
    private Token firstToken;
    private boolean debuggingMode;

    public ConfigurationSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        this.pc = pcc;
        this.firstToken = token;
        boolean bl = true;
        this.error = errors;
        this.tm = tokenManager;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token2, "'.'");
                this.tm.ungetToken();
            }
            block15: while (bl && (token2 = this.tm.getToken()).getToknum() != 535 && token2.getToknum() != 388 && token2.getToknum() != 651 && token2.getToknum() != 521 && token2.getToknum() != 522) {
                switch (token2.getToknum()) {
                    case 735: {
                        this.sourceComputer(token2);
                        continue block15;
                    }
                    case 607: {
                        if (this.tm.getToken().getToknum() != 10006) {
                            this.error.print(188, 3, token2, "'.'");
                            this.tm.ungetToken();
                        }
                        if ((token2 = this.tm.getToken()).getToknum() == 738 || token2.getToknum() == 686 || token2.getToknum() == 326 || token2.getToknum() == 535 || token2.getToknum() == 388 || token2.getToknum() == 651 || token2.getToknum() == 521 || token2.getToknum() == 522) {
                            this.tm.ungetToken();
                            continue block15;
                        }
                        if (token2.getToknum() == 735) {
                            this.sourceComputer(token2);
                            continue block15;
                        }
                        while (token2.getToknum() != 10006) {
                            switch (token2.getToknum()) {
                                case 653: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(token2, this.error);
                                    }
                                    token2 = this.tm.getToken();
                                    if (token2.getToknum() == 335) {
                                        token2 = this.tm.getToken();
                                        if (token2.getToknum() == 716) {
                                            if (pcc.isInterfaceChild()) {
                                                throw new GeneralErrorException(246, 4, token2, token2.getWord(), this.error);
                                            }
                                            this.collSequence();
                                            break;
                                        }
                                        throw new UnexpectedTokenException(token2, this.error);
                                    }
                                    if (token2.getToknum() == 716) {
                                        this.collSequence();
                                        break;
                                    }
                                    throw new UnexpectedTokenException(token2, this.error);
                                }
                                case 335: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(token2, this.error);
                                    }
                                    token2 = this.tm.getToken();
                                    if (token2.getToknum() == 716) {
                                        this.collSequence();
                                        break;
                                    }
                                    throw new UnexpectedTokenException(token2, this.error);
                                }
                                case 716: {
                                    if (this.programCollatingSeq != null) {
                                        throw new UnexpectedTokenException(token2, this.error);
                                    }
                                    this.collSequence();
                                }
                            }
                            token2 = this.tm.getToken();
                        }
                        continue block15;
                    }
                    case 738: {
                        if (this.specNames != null) {
                            throw new GeneralErrorException(225, 4, token2, token2.getWord(), this.error);
                        }
                        try {
                            this.specNames = new SpecialNames(pcc, tokenManager, this.error, this.programCollatingSeq, token2);
                        }
                        catch (GeneralErrorException generalErrorException) {
                            this.tm.skipToDot();
                        }
                        continue block15;
                    }
                    case 326: 
                    case 686: {
                        try {
                            this.repository = new Repository(pcc, tokenManager, this.error, token2);
                        }
                        catch (GeneralErrorException generalErrorException) {
                            this.tm.skipToDot();
                        }
                        continue block15;
                    }
                }
                bl = false;
            }
        } else {
            throw new UnexpectedTokenException(token2, errors);
        }
        this.tm.ungetToken();
    }

    private void sourceComputer(Token token) throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() != 10006) {
            this.error.print(188, 3, token, "'.'");
            this.tm.ungetToken();
        }
        token = this.tm.getToken();
        block5: while (true) {
            switch (token.getToknum()) {
                case 326: 
                case 388: 
                case 521: 
                case 522: 
                case 535: 
                case 607: 
                case 651: 
                case 686: 
                case 738: {
                    this.tm.ungetToken();
                    break block5;
                }
                case 10006: {
                    break block5;
                }
                case 813: {
                    token = this.tm.getToken();
                    if (token.getWord().equals("DEBUGGING")) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 587) {
                            this.debuggingMode = true;
                            this.tm.debuggingMode = true;
                        } else {
                            this.tm.ungetToken();
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                }
                default: {
                    token = this.tm.getToken();
                    continue block5;
                }
            }
            break;
        }
    }

    private void collSequence() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 545) {
            token = this.tm.getToken();
        }
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.programCollatingSeq = token;
    }

    @Override
    public SpecialNames getSpecialNames() {
        return this.specNames;
    }

    @Override
    public Token getProgramCollatingSeq() {
        return this.programCollatingSeq;
    }

    public void check(Pcc pcc) {
        if (this.programCollatingSeq != null && (this.specNames == null || this.specNames.getAlphabet(this.programCollatingSeq) == null)) {
            this.error.print(25, 4, this.programCollatingSeq, "ALPHABET " + this.programCollatingSeq.getWord());
        }
        try {
            if (this.specNames != null) {
                this.specNames.check(pcc);
            }
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.specNames != null) {
            stringBuffer2.append(this.specNames.getCode(stringBuffer));
        }
        return stringBuffer2.toString();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isDebuggingMode() {
        return this.debuggingMode;
    }
}

