/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

public class CopyGen {
    private static boolean overwriteAll;
    private static boolean overwriteNone;

    public static void main(String[] stringArray) {
        try {
            Class.forName("javafx.embed.swing.JFXPanel").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CopyGen._main(stringArray);
        }
        finally {
            System.exit(0);
        }
    }

    private static void _main(String[] stringArray) {
        File file;
        overwriteAll = false;
        overwriteNone = false;
        String string = "usage: java CopyGen [-p package] cls1 [ cls2 ... clsN] [-d outputDir]";
        Config.c();
        if (stringArray.length == 0) {
            System.err.println(string);
            System.exit(-1);
        }
        String string2 = ".";
        boolean bl = false;
        if (stringArray.length >= 3 && stringArray[stringArray.length - 2].equalsIgnoreCase("-d")) {
            string2 = stringArray[stringArray.length - 1];
            bl = true;
        }
        if (!(file = new File(string2)).exists() || !file.isDirectory()) {
            System.err.println("ERROR: directory " + string2 + " does not exist!");
            System.exit(-2);
        }
        String string3 = "";
        boolean bl2 = false;
        if (stringArray.length >= 3 && stringArray[0].equalsIgnoreCase("-p")) {
            if (bl && stringArray.length < 5) {
                System.err.println(string);
                System.exit(-1);
            }
            string3 = stringArray[1];
            bl2 = true;
        }
        Hashtable<Class, Class> hashtable = new Hashtable<Class, Class>();
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        int n3 = stringArray.length;
        if (bl) {
            n3 = stringArray.length - 2;
        }
        while (n2 < n3) {
            String string4 = "";
            if (bl2) {
                string4 = string4 + string3 + ".";
            }
            string4 = string4 + stringArray[n2];
            try {
                Class<?> clazz = Class.forName(string4);
                Vector vector = new Vector();
                Class<?> clazz2 = clazz.getSuperclass();
                while (clazz2 != null) {
                    vector.add(0, clazz);
                    clazz = clazz2;
                    clazz2 = clazz.getSuperclass();
                }
                vector.add(0, clazz);
                clazz2 = vector.elements();
                while (clazz2.hasMoreElements()) {
                    Class clazz3 = (Class)clazz2.nextElement();
                    if (hashtable.containsKey(clazz3)) continue;
                    hashtable.put(clazz3, clazz3);
                    CopyGen.printInfo(clazz3, string2);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
    }

    private static void printInfo(Class clazz, String string) throws Exception {
        Object object;
        Class clazz2 = clazz.getSuperclass();
        BeanInfo beanInfo = clazz2 != null ? Introspector.getBeanInfo(clazz, clazz2) : Introspector.getBeanInfo(clazz);
        String string2 = beanInfo.getBeanDescriptor().getName();
        String string3 = string + File.separator + string2.toLowerCase() + ".def";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        if (new File(string3).exists()) {
            if (overwriteNone) {
                return;
            }
            if (!overwriteAll) {
                while (true) {
                    System.out.print("File '" + string3 + "' already exists. Overwrite it? [y]es [n]o [A]ll [N]one ");
                    try {
                        object = bufferedReader.readLine();
                        if (!"yes".startsWith((String)object) && !"no".startsWith((String)object) && !"All".startsWith((String)object) && !"None".startsWith((String)object)) continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
                if ("no".startsWith((String)object)) {
                    return;
                }
                if ("None".startsWith((String)object)) {
                    overwriteNone = true;
                    return;
                }
                if ("All".startsWith((String)object)) {
                    overwriteAll = true;
                }
            }
        }
        System.out.println("Generating file '" + string3 + "' ...");
        object = new PrintStream(new FileOutputStream(string3));
        ((PrintStream)object).println("       >>SOURCE FORMAT FREE");
        ((PrintStream)object).println();
        ((PrintStream)object).println("*>   Class " + string2.toUpperCase());
        CopyGen.printSuperclassRef(clazz, (PrintStream)object);
        ((PrintStream)object).println();
        ((PrintStream)object).println();
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        for (int i2 = 0; i2 < eventSetDescriptorArray.length; ++i2) {
            CopyGen.printEventInfo(string2, eventSetDescriptorArray[i2], (PrintStream)object);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null && propertyDescriptorArray.length > 0) {
            ((PrintStream)object).println();
            ((PrintStream)object).println("*>   Control Properties.");
            ((PrintStream)object).println();
            for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                CopyGen.printPropertyInfo(propertyDescriptorArray[i3], (PrintStream)object);
            }
        }
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        Arrays.sort(methodDescriptorArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((MethodDescriptor)object).getMethod().getName().compareTo(((MethodDescriptor)object2).getMethod().getName());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        ((PrintStream)object).println();
        ((PrintStream)object).println();
        ((PrintStream)object).println("*>   Control Methods.");
        ((PrintStream)object).println();
        for (int i4 = 0; i4 < methodDescriptorArray.length; ++i4) {
            CopyGen.printMethodInfo(methodDescriptorArray[i4].getMethod(), (PrintStream)object);
        }
        ((PrintStream)object).println();
        ((PrintStream)object).println("       >>SOURCE FORMAT PREVIOUS");
        ((PrintStream)object).close();
        System.out.println("Done.");
    }

    private static void printEventInfo(String string, EventSetDescriptor eventSetDescriptor, PrintStream printStream) throws Exception {
        String string2 = eventSetDescriptor.getName();
        MethodDescriptor[] methodDescriptorArray = eventSetDescriptor.getListenerMethodDescriptors();
        if (methodDescriptorArray != null && methodDescriptorArray.length > 0) {
            Class<?>[] classArray = methodDescriptorArray[0].getMethod().getParameterTypes();
            printStream.println("*>   " + string2.toUpperCase() + " event definitions, Class: " + classArray[0].getName() + ".");
            printStream.println();
            for (int i2 = 0; i2 < methodDescriptorArray.length; ++i2) {
                String string3 = methodDescriptorArray[i2].getName();
                int n2 = Factory.getHashcode(string3.toUpperCase());
                printStream.print("78 " + string + "-" + string3 + " value " + n2 + ".");
                ParameterDescriptor[] parameterDescriptorArray = methodDescriptorArray[i2].getParameterDescriptors();
                if (parameterDescriptorArray != null && parameterDescriptorArray.length > 0) {
                    printStream.print(" | (" + parameterDescriptorArray[0].getShortDescription());
                    for (int i3 = 1; i3 < parameterDescriptorArray.length; ++i3) {
                        printStream.print("," + parameterDescriptorArray[i3].getShortDescription());
                    }
                    printStream.print(")");
                }
                printStream.println();
            }
            printStream.println();
            printStream.println();
        }
    }

    private static void printPropertyInfo(PropertyDescriptor propertyDescriptor, PrintStream printStream) {
        Class<Serializable> clazz = propertyDescriptor.getPropertyType();
        if (clazz == null) {
            return;
        }
        printStream.print("*> name: " + propertyDescriptor.getName() + " , type: ");
        if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Short.TYPE)) {
            printStream.print("numeric integer");
        } else if (clazz.isAssignableFrom(Boolean.TYPE)) {
            printStream.print("numeric integer [values 0/1]");
        } else if (clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(Float.TYPE)) {
            printStream.print("numeric not integer");
        } else if (clazz.isAssignableFrom(Character.TYPE) || clazz.getName().equals("java.lang.String")) {
            printStream.print("alphanumeric");
        } else if (clazz.getName().equals("java.awt.Image") || clazz.getName().equals("javax.swing.Icon")) {
            printStream.print("numeric integer or object reference");
        } else {
            printStream.print("object reference");
        }
        printStream.print(" (" + clazz.getName() + ")");
        if (propertyDescriptor.getReadMethod() != null) {
            if (propertyDescriptor.getWriteMethod() != null) {
                printStream.println(" r/w");
            } else {
                printStream.println(" r");
            }
        } else {
            printStream.println(" w");
        }
    }

    private static void printSuperclassRef(Class clazz, PrintStream printStream) throws Exception {
        if (clazz.getSuperclass() == null) {
            return;
        }
        printStream.print("*>   see also ");
        for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            printStream.print(Introspector.getBeanInfo(clazz2).getBeanDescriptor().getName().toLowerCase() + ".def ");
        }
        printStream.println();
    }

    private static void printMethodInfo(Method method, PrintStream printStream) throws Exception {
        printStream.print("*> ");
        printStream.print(CopyGen.typeToString(method.getReturnType()) + " " + method.getName() + "(");
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            printStream.print(CopyGen.typeToString(classArray[0]));
            for (int i2 = 1; i2 < classArray.length; ++i2) {
                printStream.print("," + CopyGen.typeToString(classArray[i2]));
            }
        }
        printStream.println(")");
    }

    private static String typeToString(Class clazz) throws Exception {
        int n2 = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n2;
        }
        String string = clazz.getName();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "[]";
        }
        return string;
    }
}

