/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.FileSection;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.ScreenSection;
import com.iscobol.compiler.ServiceBridgeUtility;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteFileFinder;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.CachedFileFinder;
import com.iscobol.interfaces.compiler.IDataDivisionExtension2;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public class DataDivision
implements CobolToken,
ErrorsNumbers,
IDataDivisionExtension2 {
    public static final String WORKING_STORAGE_SECTION_ID = "W";
    public static final String LINKAGE_SECTION_ID = "L";
    public static final String FILE_SECTION_ID = "F";
    public static final String SCREEN_SECTION_ID = "S";
    public static final String REPORT_SECTION_ID = "R";
    public static final String LOCAL_STORAGE_SECTION_ID = "LS";
    public static final String THREAD_LOCAL_STORAGE_SECTION_ID = "TLS";
    TokenManager tm;
    Errors error;
    FileSection fileSec;
    WorkingStorageSection wsSec;
    LocalStorageSection lsSec;
    ThreadLocalStorageSection tlsSec;
    ScreenSection screenSec;
    LinkageSection linkSec;
    ReportSection repoSec;
    Pcc pc;
    Map<String, Integer> wdslArraySizes = new HashMap<String, Integer>();
    private static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    Hashtable<String, StringBuffer> tagAreas = new Hashtable();
    public static final String startTag = "*>start ";
    public static final String endTag = "*>end ";
    public static final String tagCompDir = "{iscobol}compiler-directives";
    public static final String tagProgCom = "{iscobol}prog-comment";
    public static final String tagProgId = "{iscobol}progid";
    public static final String tagReposit = "{iscobol}repository";
    public static final String tagWorkSto = "{iscobol}working-storage";
    public static final String tagLinkage = "{iscobol}linkage";
    public static final String tagProcUsi = "{iscobol}procedure-using";
    public static final String tagAcceHtt = "{iscobol}accept-http";
    public static final String tagHttpLin = "{iscobol}http-to-linkage";
    public static final String tagCall = "{iscobol}call";
    public static final String tagLinkHtt = "{iscobol}linkage-to-http";
    public static final String tagHttpRes = "{iscobol}http-response";
    public static final String tagGoback = "{iscobol}goback";
    private Token firstToken;
    private Token lastToken;
    private final boolean serviceBridgeActivated;
    private boolean jj;
    private boolean jc;

    public DataDivision(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, null);
    }

    public DataDivision(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration variableDeclaration;
        this.jj = tokenManager.getOptionList().getOption("-jj") != null;
        this.jc = tokenManager.getOptionList().getOption("-jc") != null;
        this.firstToken = token;
        this.serviceBridgeActivated = pcc.isServiceBridgeActivated();
        boolean bl = true;
        this.pc = pcc;
        this.pc.inProcedure = false;
        this.error = errors;
        this.tm = tokenManager;
        block20: while (bl && (token = this.tm.getToken()).getToknum() != 651 && token.getToknum() != 705 && token.getToknum() != 422) {
            switch (token.getToknum()) {
                case 482: {
                    if (this.fileSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.fileSec = new FileSection(this.pc, this.tm, this.error, token);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 814: {
                    if (this.wsSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.wsSec = new WorkingStorageSection(this.pc, this.tm, this.error, token);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 569: {
                    if (!(this.pc instanceof CobolProgram) && !(this.pc instanceof CobolMethod)) {
                        throw new UnexpectedTokenException(token, errors);
                    }
                    if (this.lsSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.lsSec = new LocalStorageSection(this.pc, this.tm, this.error, token);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 765: {
                    if (!(this.pc instanceof CobolProgram) && !(this.pc instanceof CobolMethod)) {
                        throw new UnexpectedTokenException(token, errors);
                    }
                    if (this.tlsSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.tlsSec = new ThreadLocalStorageSection(this.pc, this.tm, this.error, token);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 568: {
                    if (this.linkSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.linkSec = new LinkageSection(this.pc, this.tm, this.error, token, this.wsSec);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 684: {
                    if (this.repoSec != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    try {
                        this.repoSec = new ReportSection(this.pc, this.tm, this.error);
                    }
                    catch (GeneralErrorException generalErrorException) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
            }
            bl = false;
        }
        if (this.wsSec != null && this.wsSec.tlVars.getItemNum() > 0) {
            if (this.tlsSec == null) {
                this.tlsSec = new ThreadLocalStorageSection(pcc, null, this.error, token);
            }
            variableDeclaration = this.wsSec.tlVars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.setParentSection(this.tlsSec);
                this.tlsSec.loadVariable(variableDeclaration);
                variableDeclaration = this.wsSec.tlVars.getNext();
            }
        }
        if (this.lsSec != null && this.lsSec.tlVars.getItemNum() > 0) {
            if (this.tlsSec == null) {
                this.tlsSec = new ThreadLocalStorageSection(pcc, null, this.error, token);
            }
            variableDeclaration = this.lsSec.tlVars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.setParentSection(this.tlsSec);
                this.tlsSec.loadVariable(variableDeclaration);
                variableDeclaration = this.lsSec.tlVars.getNext();
            }
        }
        if (this.fileSec != null && this.fileSec.hasThreadLocal() && this.tlsSec == null) {
            this.tlsSec = new ThreadLocalStorageSection(pcc, null, this.error, token);
        }
        this.lastToken = token;
        this.tm.ungetToken();
        this.pc.loadCounters();
    }

    void check() {
        if (this.repoSec != null) {
            this.repoSec.check();
        }
        if (this.fileSec != null) {
            this.fileSec.check();
        }
    }

    public void scanScreenSection(Token token) throws GeneralErrorException, EndOfProgramException {
        try {
            this.screenSec = new ScreenSection(this.pc, this.tm, this.error, token);
            this.screenSec.loadSS();
            this.lastToken = this.screenSec.getLastToken();
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        this.tm.ungetToken();
    }

    public String getCode(StringBuffer stringBuffer, String string) {
        return this.getCode(stringBuffer, null, string);
    }

    public String getCode(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        Object object;
        Object object2;
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(this.tm.getCommentCode(this.firstToken, ""));
        if (stringBuffer2 == null) {
            stringBuffer2 = stringBuffer3;
        }
        if (string == LOCAL_STORAGE_SECTION_ID) {
            if (this.lsSec != null) {
                stringBuffer3.append(this.lsSec.getCode(stringBuffer));
            }
        } else if (string == THREAD_LOCAL_STORAGE_SECTION_ID) {
            if (this.fileSec != null) {
                stringBuffer3.append(this.fileSec.getCode(stringBuffer, true));
                object2 = this.fileSec.getFileDescriptorList();
                object = ((FileDescriptorList)object2).getFirst();
                while (object != null) {
                    if (((FileDescriptor)object).threadLocal) {
                        stringBuffer3.append(((FileDescriptor)object).getSelect().getCode(stringBuffer));
                    }
                    object = ((FileDescriptorList)object2).getNext();
                }
            }
            if (this.tlsSec != null) {
                stringBuffer3.append(this.tlsSec.getCode(stringBuffer));
            }
        } else {
            if (this.fileSec != null) {
                stringBuffer3.append(this.fileSec.getCode(stringBuffer, false));
            }
            if (this.wsSec != null) {
                stringBuffer3.append(this.wsSec.getCode(stringBuffer));
            }
            if (this.linkSec != null) {
                stringBuffer3.append(this.linkSec.getCode(stringBuffer));
            }
            if (this.repoSec != null) {
                stringBuffer3.append(this.repoSec.getCode(stringBuffer));
            }
            if (this.screenSec != null && this.screenSec.vars.getItemNum() > 0 || this.pc.useScreen) {
                stringBuffer.append("ScrFactory.getGUIEnviroment()");
                stringBuffer.append(".setProgName(\"" + this.pc.getClassName() + "\");" + eol);
            }
            if (this.screenSec != null) {
                stringBuffer3.append(this.screenSec.getCode(this.pc, stringBuffer));
                stringBuffer3.append(eol);
            }
            if ((Config.a(".compiler.easylinkage", 0) == 1 || Config.b(".compiler.easylinkage", false) || Config.a(".compiler.easylinkage", 0) == 3) && Config.a(".compiler.easylinkage", 0) != 2) {
                object2 = null;
                object = this.pc.getOutNameBase();
                if (this.pc.getProcedureDivision() != null) {
                    object2 = this.pc.getProcedureDivision().using;
                    this.getEasyLinkCode(this.pc, (String)object, (VariableNameList)object2, this.pc.getProcedureDivision().getByValueParameters(), false);
                } else {
                    this.getEasyLinkCode(this.pc, (String)object, (VariableNameList)object2, new HashSet(), false);
                }
            }
            if (this.serviceBridgeActivated) {
                try {
                    object2 = null;
                    object = this.pc.outName;
                    String string2 = this.pc.outName;
                    if (this.pc.getProcedureDivision() != null) {
                        object2 = this.pc.getProcedureDivision().using;
                        if (this.pc.getProcedureDivision().getServiceBridgeOperation() != null) {
                            object = this.pc.getProcedureDivision().getServiceBridgeOperation();
                        }
                    }
                    if (Config.a(".compiler.servicebridge.type", "SOAP").equalsIgnoreCase("SOAP")) {
                        this.getServiceBridgeWsdlCode(this.pc, (String)object, (VariableNameList)object2);
                    }
                    this.getServiceBridgeCobCode(this.pc, (String)object, string2, (VariableNameList)object2, 0, false);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        }
        if (this.pc instanceof CobolProgram && this.pc.getOption("-cp") != null) {
            if (string == LOCAL_STORAGE_SECTION_ID || string == THREAD_LOCAL_STORAGE_SECTION_ID) {
                stringBuffer2.append("   ");
            }
            stringBuffer2.append("   public void syncMemory() {");
            if (string == LOCAL_STORAGE_SECTION_ID) {
                if (this.lsSec != null) {
                    object2 = this.lsSec.vars.getFirst();
                    while (object2 != null) {
                        this.getSyncMemoryCode((VariableDeclaration)object2, stringBuffer2);
                        object2 = this.lsSec.vars.getNext();
                    }
                }
            } else if (string == THREAD_LOCAL_STORAGE_SECTION_ID) {
                if (this.tlsSec != null) {
                    object2 = this.tlsSec.vars.getFirst();
                    while (object2 != null) {
                        this.getSyncMemoryCode((VariableDeclaration)object2, stringBuffer2);
                        object2 = this.tlsSec.vars.getNext();
                    }
                }
            } else {
                if (this.wsSec != null) {
                    object2 = this.wsSec.vars.getFirst();
                    while (object2 != null) {
                        this.getSyncMemoryCode((VariableDeclaration)object2, stringBuffer2);
                        object2 = this.wsSec.vars.getNext();
                    }
                }
                if (this.linkSec != null) {
                    object2 = this.linkSec.vars.getFirst();
                    while (object2 != null) {
                        this.getSyncMemoryCode((VariableDeclaration)object2, stringBuffer2);
                        object2 = this.linkSec.vars.getNext();
                    }
                }
            }
            if (string == LOCAL_STORAGE_SECTION_ID || string == THREAD_LOCAL_STORAGE_SECTION_ID) {
                stringBuffer2.append("   ");
            }
            stringBuffer2.append("   }");
            stringBuffer2.append(eol);
        }
        return stringBuffer3.toString();
    }

    private void getSyncMemoryCode(VariableDeclaration variableDeclaration, StringBuffer stringBuffer) {
        if (!variableDeclaration.isPrimitive() && !variableDeclaration.isObjectReference()) {
            if (variableDeclaration.isUsed()) {
                stringBuffer.append("      ");
                stringBuffer.append(variableDeclaration.getUnivoqueName());
                stringBuffer.append(".getMemory();");
                stringBuffer.append(eol);
            } else {
                VariableDeclarationList variableDeclarationList = variableDeclaration.getChildren();
                VariableDeclaration variableDeclaration2 = variableDeclarationList.getFirst();
                while (variableDeclaration2 != null) {
                    if (variableDeclaration2.getLevel() <= 49) {
                        this.getSyncMemoryCode(variableDeclaration2, stringBuffer);
                    }
                    variableDeclaration2 = variableDeclarationList.getNext();
                }
            }
        }
    }

    public StringBuffer getDataMap(String string, String string2) {
        VariableDeclaration variableDeclaration;
        CobolToken cobolToken;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileSec != null) {
            cobolToken = this.fileSec.fdArray.getFirst();
            while (cobolToken != null) {
                if (!((FileDescriptor)cobolToken).hasReports()) {
                    variableDeclaration = ((FileDescriptor)cobolToken).recordDesc.getFirst();
                    while (variableDeclaration != null) {
                        variableDeclaration.getLineDatamap(stringBuffer, "FD", " ", string2);
                        variableDeclaration = ((FileDescriptor)cobolToken).recordDesc.getNext();
                    }
                }
                cobolToken = this.fileSec.fdArray.getNext();
            }
        }
        if (this.repoSec != null) {
            for (int i2 = this.repoSec.getRdList().size() - 1; i2 >= 0; --i2) {
                cobolToken = (ReportDescriptor)this.repoSec.getRdList().elementAt(i2);
                for (ReportGroup reportGroup : ((ReportDescriptor)cobolToken).getReportGroups()) {
                    stringBuffer.append(reportGroup.getLineDatamap(string2));
                }
            }
        }
        if (this.wsSec != null) {
            variableDeclaration = this.wsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.getLineDatamap(stringBuffer, "WS", " ", string2);
                variableDeclaration = this.wsSec.vars.getNext();
            }
        }
        if (this.lsSec != null) {
            variableDeclaration = this.lsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.getLineDatamap(stringBuffer, "LC", " ", string2);
                variableDeclaration = this.lsSec.vars.getNext();
            }
        }
        if (this.tlsSec != null) {
            variableDeclaration = this.tlsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.getLineDatamap(stringBuffer, "TL", " ", string2);
                variableDeclaration = this.tlsSec.vars.getNext();
            }
        }
        if (this.linkSec != null) {
            variableDeclaration = this.linkSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.getLineDatamap(stringBuffer, LOCAL_STORAGE_SECTION_ID, " ", string2);
                variableDeclaration = this.linkSec.vars.getNext();
            }
        }
        if (this.screenSec != null) {
            variableDeclaration = this.screenSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.getLineDatamap(stringBuffer, "SS", " ", string2);
                variableDeclaration = this.screenSec.vars.getNext();
            }
        }
        variableDeclaration = this.pc.fixedVars.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.getLineDatamap(stringBuffer, "PG", " ", string2);
            variableDeclaration = this.pc.fixedVars.getNext();
        }
        return stringBuffer;
    }

    void writeExtDataMap(Element element) {
        VariableDeclaration variableDeclaration;
        CobolToken cobolToken;
        boolean bl;
        boolean bl2 = bl = this.pc.getOption("-m1") != null;
        if (this.fileSec != null) {
            cobolToken = this.fileSec.fdArray.getFirst();
            while (cobolToken != null) {
                if (!((FileDescriptor)cobolToken).hasReports()) {
                    variableDeclaration = ((FileDescriptor)cobolToken).recordDesc.getFirst();
                    while (variableDeclaration != null) {
                        variableDeclaration.writeExtDatamap(element, "FD", bl);
                        variableDeclaration = ((FileDescriptor)cobolToken).recordDesc.getNext();
                    }
                }
                cobolToken = this.fileSec.fdArray.getNext();
            }
        }
        if (this.repoSec != null) {
            for (int i2 = this.repoSec.getRdList().size() - 1; i2 >= 0; --i2) {
                cobolToken = (ReportDescriptor)this.repoSec.getRdList().elementAt(i2);
                for (ReportGroup reportGroup : ((ReportDescriptor)cobolToken).getReportGroups()) {
                    reportGroup.writeExtDatamap(element);
                }
            }
        }
        if (this.wsSec != null) {
            variableDeclaration = this.wsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.writeExtDatamap(element, "WS", bl);
                variableDeclaration = this.wsSec.vars.getNext();
            }
        }
        if (this.lsSec != null) {
            variableDeclaration = this.lsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.writeExtDatamap(element, "LC", bl);
                variableDeclaration = this.lsSec.vars.getNext();
            }
        }
        if (this.tlsSec != null) {
            variableDeclaration = this.tlsSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.writeExtDatamap(element, "TL", bl);
                variableDeclaration = this.tlsSec.vars.getNext();
            }
        }
        if (this.linkSec != null) {
            variableDeclaration = this.linkSec.vars.getFirst();
            while (variableDeclaration != null) {
                variableDeclaration.writeExtDatamap(element, LOCAL_STORAGE_SECTION_ID, bl);
                variableDeclaration = this.linkSec.vars.getNext();
            }
        }
        variableDeclaration = this.pc.fixedVars.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.writeExtDatamap(element, "PG", bl);
            variableDeclaration = this.pc.fixedVars.getNext();
        }
    }

    public StringBuffer getDataSize(String string, String string2) {
        VariableDeclaration variableDeclaration;
        CobolToken cobolToken;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        String string3 = "                                            ";
        String string4 = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (this.fileSec != null) {
            cobolToken = this.fileSec.fdArray.getFirst();
            while (cobolToken != null) {
                if (!((FileDescriptor)cobolToken).hasReports()) {
                    if (((FileDescriptor)cobolToken).isExternal()) {
                        n10 += ((FileDescriptor)cobolToken).getMaxRecLen();
                    } else {
                        n11 += ((FileDescriptor)cobolToken).getMaxRecLen();
                    }
                }
                cobolToken = this.fileSec.fdArray.getNext();
            }
        }
        string4 = "" + n11;
        stringBuffer.append(string2 + "File Description data size               " + string3.substring(string4.length()) + string4 + string);
        string4 = "" + n10;
        stringBuffer.append(string2 + "External File Description data size      " + string3.substring(string4.length()) + string4 + string);
        if (this.repoSec != null) {
            for (int i2 = this.repoSec.getRdList().size() - 1; i2 >= 0; --i2) {
                cobolToken = (ReportDescriptor)this.repoSec.getRdList().elementAt(i2);
                for (ReportGroup reportGroup : ((ReportDescriptor)cobolToken).getReportGroups()) {
                    n9 = reportGroup.getDataMapSize();
                }
            }
        }
        string4 = "" + n9;
        stringBuffer.append(string2 + "Report Description data size             " + string3.substring(string4.length()) + string4 + string);
        if (this.wsSec != null) {
            variableDeclaration = this.wsSec.vars.getFirst();
            while (variableDeclaration != null) {
                if (!variableDeclaration.isRedefines()) {
                    if (variableDeclaration.getOccurs() == 0) {
                        if (variableDeclaration.isExternal()) {
                            n5 += variableDeclaration.getPhisicLen();
                        } else {
                            n8 += variableDeclaration.getPhisicLen();
                        }
                    } else if (variableDeclaration.isExternal()) {
                        n5 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    } else {
                        n8 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    }
                }
                variableDeclaration = this.wsSec.vars.getNext();
            }
        }
        string4 = "" + n8;
        stringBuffer.append(string2 + "Working-Storage data size                " + string3.substring(string4.length()) + string4 + string);
        if (this.lsSec != null) {
            variableDeclaration = this.lsSec.vars.getFirst();
            while (variableDeclaration != null) {
                if (!variableDeclaration.isRedefines()) {
                    if (variableDeclaration.getOccurs() == 0) {
                        if (variableDeclaration.isExternal()) {
                            n5 += variableDeclaration.getPhisicLen();
                        } else {
                            n7 += variableDeclaration.getPhisicLen();
                        }
                    } else if (variableDeclaration.isExternal()) {
                        n5 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    } else {
                        n7 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    }
                }
                variableDeclaration = this.lsSec.vars.getNext();
            }
        }
        string4 = "" + n7;
        stringBuffer.append(string2 + "Local-Storage data size                  " + string3.substring(string4.length()) + string4 + string);
        if (this.tlsSec != null) {
            variableDeclaration = this.tlsSec.vars.getFirst();
            while (variableDeclaration != null) {
                if (!variableDeclaration.isRedefines()) {
                    if (variableDeclaration.getOccurs() == 0) {
                        if (variableDeclaration.isExternal()) {
                            n5 += variableDeclaration.getPhisicLen();
                        } else {
                            n6 += variableDeclaration.getPhisicLen();
                        }
                    } else if (variableDeclaration.isExternal()) {
                        n5 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    } else {
                        n6 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs();
                    }
                }
                variableDeclaration = this.tlsSec.vars.getNext();
            }
        }
        string4 = "" + n6;
        stringBuffer.append(string2 + "Thread-Local-Storage data size           " + string3.substring(string4.length()) + string4 + string);
        string4 = "" + n5;
        stringBuffer.append(string2 + "External variable data size              " + string3.substring(string4.length()) + string4 + string);
        if (this.linkSec != null) {
            variableDeclaration = this.linkSec.vars.getFirst();
            while (variableDeclaration != null) {
                if (!variableDeclaration.isRedefines()) {
                    n4 = variableDeclaration.getOccurs() == 0 ? (n4 += variableDeclaration.getPhisicLen()) : (n4 += variableDeclaration.getPhisicLen() * variableDeclaration.getOccurs());
                }
                variableDeclaration = this.linkSec.vars.getNext();
            }
        }
        string4 = "" + n4;
        stringBuffer.append(string2 + "Linkage data size                        " + string3.substring(string4.length()) + string4 + string);
        if (this.screenSec != null) {
            variableDeclaration = this.screenSec.vars.getFirst();
            while (variableDeclaration != null) {
                n3 += variableDeclaration.getDataMapSize();
                variableDeclaration = this.screenSec.vars.getNext();
            }
        }
        string4 = "" + n3;
        stringBuffer.append(string2 + "Screen data size                         " + string3.substring(string4.length()) + string4 + string);
        n2 = n11 + n10 + n5 + n9 + n8 + n7 + n6 + n4 + n3;
        string4 = "" + n2;
        stringBuffer.append(string2 + "Total Data Size                          " + string3.substring(string4.length()) + string4 + "   " + string);
        return stringBuffer;
    }

    void getEasyLinkCode(Pcc pcc, String string, VariableNameList variableNameList, Set set, boolean bl) {
        Object object;
        String string2 = Config.a(".compiler.easylinkage.prefix", "link").trim();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        String string4 = "";
        String string5 = string;
        if (string.lastIndexOf(File.separatorChar) > 0) {
            string5 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        }
        if (string5 == null || string5.length() == 0) {
            return;
        }
        if (variableNameList != null) {
            object = variableNameList.getFirst();
            while (object != null) {
                if (!((VariableName)object).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object).getVarDecl());
                }
                object = variableNameList.getNext();
            }
        }
        stringBuffer.append("/**" + eol);
        stringBuffer.append(" * Class generated by isCobol compiler for EasyLinkage feature" + eol);
        stringBuffer.append(" * " + Version.getRelease() + eol);
        stringBuffer.append(" * " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append(" *" + eol);
        stringBuffer.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append(" * compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
        if (bl) {
            stringBuffer.append(" * This Class is for a Cobol Entry point." + eol);
            stringBuffer.append(" * Ensure to have the entry point in memory or run the main cobol program" + eol);
            stringBuffer.append(" * " + pcc.getOutNameBase() + " before." + eol);
        }
        stringBuffer.append(" */");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        object = Config.a(".compiler.easylinkage.package", null);
        if (object != null) {
            stringBuffer.append("package " + (String)object + ";" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("import com.iscobol.java.IsCobol;" + eol);
        stringBuffer.append("import com.iscobol.java.StopRunAsException;" + eol);
        stringBuffer.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (pcc.getOptions().getOption("-xms") == null && pcc.getOptions().getOption("-cp") == null) {
            stringBuffer.append("import com.iscobol.rts.Factory;" + eol);
            stringBuffer.append("import com.iscobol.types.*;" + eol);
        } else {
            stringBuffer.append("import com.iscobol.rts_n.Factory;" + eol);
            stringBuffer.append("import com.iscobol.rts.Memory;" + eol);
            stringBuffer.append("import com.iscobol.types_n.*;" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("public class " + string2 + string5 + " {" + eol);
        stringBuffer.append(eol);
        if (pcc.getOption("-sddp") != null && !pcc.getSplitFlag()) {
            stringBuffer.append("   public static final boolean $isDPC$ = Factory.isDPC();" + eol);
        }
        if (pcc.getOption("-sdcs") != null && !pcc.getSplitFlag()) {
            stringBuffer.append("   public static final char $CurrencySign$ = Factory.getCS();" + eol);
        }
        stringBuffer.append("   public " + string2 + string5 + "() {" + eol);
        stringBuffer.append("      this(true);" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   public " + string2 + string5 + "(boolean create) {" + eol);
        stringBuffer.append("      if (create) {" + eol);
        VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            string4 = variableDeclaration.getDeclUnivoqueName(true);
            string4 = string4.length() > 1 ? string4.substring(0, 1).toUpperCase() + string4.substring(1) : string4.toUpperCase();
            stringBuffer.append("          new" + string4 + "();" + eol);
            variableDeclaration = variableDeclarationList.getNext();
        }
        stringBuffer.append("       }" + eol);
        stringBuffer.append("   }" + eol);
        variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            string4 = variableDeclaration.getDeclUnivoqueName(true);
            string4 = string4.length() > 1 ? string4.substring(0, 1).toUpperCase() + string4.substring(1) : string4.toUpperCase();
            stringBuffer2.append("    public void new" + string4 + "()" + eol);
            stringBuffer2.append("    {" + eol + "      ");
            if (variableDeclaration.isRedefines()) {
                stringBuffer.append(variableDeclaration.getRedefinesVar().getCode(string3, stringBuffer2, true));
            }
            stringBuffer.append(variableDeclaration.getCode(string3, stringBuffer2, true));
            stringBuffer2.append("    }" + eol);
            variableDeclaration = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("   public int run()" + eol);
        stringBuffer.append("      throws IscobolRuntimeException," + eol);
        stringBuffer.append("             StopRunAsException {" + eol);
        stringBuffer.append("      return run(false);" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append("   public int run(boolean isNew)" + eol);
        stringBuffer.append("      throws IscobolRuntimeException," + eol);
        stringBuffer.append("             StopRunAsException {" + eol);
        stringBuffer.append("      if (isNew)" + eol);
        stringBuffer.append("         IsCobol.cancel(\"" + string5 + "\");" + eol);
        boolean bl2 = false;
        VariableDeclaration variableDeclaration2 = variableDeclarationList.getFirst();
        while (variableDeclaration2 != null && !bl2) {
            if (variableDeclaration2.isObjectReference()) {
                bl2 = true;
            }
            variableDeclaration2 = variableDeclarationList.getNext();
        }
        if (bl2) {
            stringBuffer.append("      return IsCobol.call (\"" + string5 + "\", new Object[] {");
        } else {
            stringBuffer.append("      return IsCobol.call (\"" + string5 + "\", new CobolVar[] {");
        }
        int n2 = 0;
        Object object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            if (!((VariableDeclaration)object2).isObjectReference()) {
                if (set.contains(variableNameList.getAt(n2))) {
                    stringBuffer.append(((VariableDeclaration)object2).getEasyDeclUnivoqueName() + ".byVal()");
                } else {
                    stringBuffer.append(((VariableDeclaration)object2).getEasyDeclUnivoqueName() + ".byRef()");
                }
            } else {
                stringBuffer.append(((VariableDeclaration)object2).getEasyDeclUnivoqueName());
            }
            ++n2;
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append("}, false);" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append("   public int run(Object argv[])" + eol);
        stringBuffer.append("      throws IscobolRuntimeException," + eol);
        stringBuffer.append("             StopRunAsException {" + eol);
        stringBuffer.append("      return run(argv, false);" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append("   public int run(Object argv[], boolean isNew)" + eol);
        stringBuffer.append("      throws IscobolRuntimeException," + eol);
        stringBuffer.append("             StopRunAsException {" + eol);
        stringBuffer.append("      if (isNew)" + eol);
        stringBuffer.append("         IsCobol.cancel(\"" + string5 + "\");" + eol);
        stringBuffer.append("      return IsCobol.call (\"" + string5 + "\", argv, false);" + eol);
        stringBuffer.append("   }" + eol);
        stringBuffer.append("}" + eol);
        try {
            object2 = Pcc.getEasyLinkageFileName(string5 + ".java", true, this.tm);
            PrintWriter printWriter = PreProcessor.newPrintWriter((String)object2);
            printWriter.print(stringBuffer.toString());
            printWriter.close();
            if (this.jj) {
                System.out.println("Generated '" + (String)object2 + "'");
            }
            if (this.jc || !this.jj && !this.jc) {
                System.out.println("Generated '" + ((String)object2).replace(".java", ".class") + "'");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void getServiceBridgeWsdlCode(Pcc pcc, String string, VariableNameList variableNameList) {
        Object object;
        int n2;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "  ";
        String string3 = "unqualified";
        String string4 = Config.a(".compiler.servicebridge.soap.style", "RPC");
        boolean bl = true;
        if (string4.equalsIgnoreCase("DOCUMENT")) {
            bl = false;
            string3 = "qualified";
        }
        String string5 = Config.a(".compiler.servicebridge.soap.namespace", "http://tempuri.org/");
        String string6 = Config.a(".compiler.servicebridge.soap.namespace_suffix", string);
        String string7 = Config.a(".compiler.servicebridge.schemas", "http://schemas.xmlsoap.org/wsdl/");
        String string8 = Config.a(".compiler.servicebridge.xmlschema", "http://www.w3.org/2001/XMLSchema");
        String string9 = Config.a(".compiler.servicebridge.formdefault", string3);
        String string10 = Config.a(".compiler.servicebridge.soap.url", "http://localhost:8080");
        String string11 = Config.a(".compiler.servicebridge.wsiclaim", "http://ws-i.org/schemas/conformanceClaim/");
        String string12 = string;
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        String string13 = pcc.getWsdlFileName();
        if (variableNameList != null) {
            object2 = variableNameList.getFirst();
            while (object2 != null) {
                if (!((VariableName)object2).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object2).getVarDecl());
                }
                object2 = variableNameList.getNext();
            }
        }
        stringBuffer.append("<?xml version=\"");
        stringBuffer.append(Config.a(".compiler.servicebridge.xmlversion", "1.0"));
        stringBuffer.append("\" encoding=\"");
        stringBuffer.append(Config.a(".compiler.servicebridge.encoding", "UTF-8"));
        stringBuffer.append("\" standalone=\"");
        stringBuffer.append(Config.a(".compiler.servicebridge.standalone", "no"));
        stringBuffer.append("\" ?>" + eol);
        stringBuffer.append("<definitions name=\"" + string + "\" targetNamespace=\"" + string5 + string6 + "\"" + eol);
        stringBuffer.append("            xmlns=\"" + string7 + "\"" + eol);
        stringBuffer.append("            xmlns:soap=\"" + string7 + "soap/\"" + eol);
        stringBuffer.append("            xmlns:tns=\"" + string5 + string6 + "\"" + eol);
        stringBuffer.append("            xmlns:wsdl=\"" + string7 + "\"" + eol);
        if (!bl) {
            stringBuffer.append("            xmlns:wsi=\"" + string11 + "\"" + eol);
        }
        stringBuffer.append("            xmlns:xs=\"" + string8 + "\">" + eol);
        stringBuffer.append(" <!-- isCOBOL generated WSDL                     " + eol);
        stringBuffer.append("     * " + Version.getRelease() + eol);
        stringBuffer.append("     * " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append("     *" + eol);
        stringBuffer.append("     * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append("     * compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + "-->" + eol);
        stringBuffer.append(string2 + "<types>" + eol);
        string2 = string2 + "  ";
        stringBuffer.append(string2 + "<schema elementFormDefault=\"" + string9 + "\" targetNamespace=\"" + string5 + string6 + "\"" + eol);
        stringBuffer.append(string2 + "        xmlns=\"" + string8 + "\"" + eol);
        if (bl) {
            stringBuffer.append(string2 + "        xmlns:SOAP-ENC=\"" + NS_SOAPENC + "\"" + eol);
        }
        stringBuffer.append(string2 + "        xmlns:tns=\"" + string5 + string6 + "\">" + eol);
        object2 = new HashMap();
        object2.put(string12, this.doWsdlElement(string12, variableDeclarationList, stringBuffer, stringBuffer2, string2, bl));
        Entry[] entryArray = pcc.getEntryPoints();
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            Object object3;
            object = new VariableDeclarationList();
            if (entryArray[n2].using != null) {
                object3 = entryArray[n2].using.getFirst();
                while (object3 != null) {
                    if (!((VariableName)object3).isFactory()) {
                        ((VariableDeclarationList)object).addItem(((VariableName)object3).getVarDecl());
                    }
                    object3 = entryArray[n2].using.getNext();
                }
            }
            object3 = entryArray[n2].getServiceBridgeValueName();
            object2.put(object3, this.doWsdlElement((String)object3, (VariableDeclarationList)object, stringBuffer, stringBuffer2, string2, bl));
        }
        string2 = string2.substring(0, string2.length() - 2);
        stringBuffer.append(string2 + "</schema>" + eol);
        string2 = string2.substring(0, string2.length() - 2);
        stringBuffer.append(string2 + "</types>" + eol);
        this.doWsdlMessage(string12, stringBuffer, string2, (List[])object2.get(string12));
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            object = entryArray[n2].getServiceBridgeValueName();
            this.doWsdlMessage((String)object, stringBuffer, string2, (List[])object2.get(object));
        }
        stringBuffer.append(string2 + "<portType name=\"" + string + "\">" + eol);
        this.doWsdlPortOperation(string12, stringBuffer, string2);
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            this.doWsdlPortOperation(entryArray[n2].getServiceBridgeValueName(), stringBuffer, string2);
        }
        stringBuffer.append(string2 + "</portType>" + eol);
        stringBuffer.append(string2 + "<binding name=\"" + string + "\" type=\"tns:" + string + "\">" + eol);
        if (!bl) {
            stringBuffer.append(string2 + "  <soap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + eol);
        } else {
            stringBuffer.append(string2 + "  <soap:binding style=\"rpc\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + eol);
        }
        this.doWsdlBindOperation(string12, stringBuffer, string2, string5, string, bl, string6);
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            this.doWsdlBindOperation(entryArray[n2].getServiceBridgeValueName(), stringBuffer, string2, string5, string, bl, string6);
        }
        stringBuffer.append(string2 + "</binding>" + eol);
        stringBuffer.append(string2 + "<service name=\"" + string + "\">" + eol);
        stringBuffer.append(string2 + "  <port binding=\"tns:" + string + "\" name=\"" + string + "\">" + eol);
        stringBuffer.append(string2 + "      <soap:address location=\"" + string10 + "\"/>" + eol);
        stringBuffer.append(string2 + "  </port>" + eol);
        stringBuffer.append(string2 + "</service>" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("</definitions>" + eol);
        try {
            PrintWriter printWriter = PreProcessor.newPrintWriter(string13);
            printWriter.print(stringBuffer.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    List[] doWsdlElement(String string, VariableDeclarationList variableDeclarationList, StringBuffer stringBuffer, StringBuffer stringBuffer2, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (bl) {
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                int n2 = variableDeclaration.getWsdlMode();
                if (n2 == 0) {
                    if (bl && variableDeclaration.picture != null && (variableDeclaration.level == 1 || variableDeclaration.level == 77)) {
                        arrayList.add("fil_" + variableDeclaration.getWsdlNameReal(true) + variableDeclaration.getWsdlDecoration(true, true));
                    } else {
                        arrayList.add(variableDeclaration.getWsdlNameReal(true) + variableDeclaration.getWsdlDecoration(true, true));
                    }
                    arrayList2.add(variableDeclaration.getWsdlNameReal(false) + variableDeclaration.getWsdlDecoration(false, true));
                } else if (n2 == 2) {
                    if (variableDeclaration.hasChildDifferentMode(false)) {
                        arrayList.add(variableDeclaration.getWsdlNameReal(true) + variableDeclaration.getWsdlDecoration(true, true));
                        arrayList2.add(variableDeclaration.getWsdlNameReal(false) + variableDeclaration.getWsdlDecoration(false, true));
                    } else {
                        arrayList2.add(variableDeclaration.getWsdlName(false));
                    }
                } else if (n2 == 1) {
                    if (variableDeclaration.hasChildDifferentMode(true)) {
                        arrayList.add(variableDeclaration.getWsdlName(true) + variableDeclaration.getWsdlDecoration(true, true));
                        arrayList2.add(variableDeclaration.getWsdlName(false) + variableDeclaration.getWsdlDecoration(false, true));
                    } else if (bl && variableDeclaration.picture != null && (variableDeclaration.level == 1 || variableDeclaration.level == 77)) {
                        arrayList.add("fil_" + variableDeclaration.getWsdlName(true));
                    } else {
                        arrayList.add(variableDeclaration.getWsdlName(true));
                    }
                }
                variableDeclaration = variableDeclarationList.getNext();
            }
        }
        string2 = string2 + "  ";
        for (int i2 = 0; i2 < 2; ++i2) {
            if (variableDeclarationList.getFirst() != null) {
                if (!bl) {
                    stringBuffer.append(string2 + "<element name=\"" + string);
                    if (i2 == 0) {
                        stringBuffer.append("\">" + eol);
                    } else {
                        stringBuffer.append("Response\">" + eol);
                    }
                    string2 = string2 + "  ";
                    stringBuffer.append(string2 + "<complexType>" + eol);
                    string2 = string2 + "  ";
                    stringBuffer.append(string2 + "<sequence>" + eol);
                }
                VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
                while (variableDeclaration != null) {
                    StringBuffer stringBuffer3 = variableDeclaration.getServiceBridgeWsdlCode(string2, i2 == 0, stringBuffer2, bl);
                    if (!bl || bl && variableDeclaration.getPicture() != null) {
                        stringBuffer.append(stringBuffer3);
                    }
                    variableDeclaration = variableDeclarationList.getNext();
                }
                if (!bl) {
                    stringBuffer.append(string2 + "</sequence>" + eol);
                    string2 = string2.substring(0, string2.length() - 2);
                    stringBuffer.append(string2 + "</complexType>" + eol);
                    string2 = string2.substring(0, string2.length() - 2);
                    stringBuffer.append(string2 + "</element>" + eol);
                }
                stringBuffer.append(stringBuffer2);
                if (stringBuffer2.length() <= 0) continue;
                stringBuffer2.delete(0, stringBuffer2.length() - 1);
                continue;
            }
            if (!bl) {
                stringBuffer.append(string2 + "<element name=\"" + string);
                if (i2 == 0) {
                    stringBuffer.append("\">" + eol);
                } else {
                    stringBuffer.append("Response\">" + eol);
                }
                string2 = string2 + "  ";
                stringBuffer.append(string2 + "<complexType>" + eol);
                string2 = string2 + "  ";
                stringBuffer.append(string2 + "<sequence/>" + eol);
                string2 = string2.substring(0, string2.length() - 2);
                stringBuffer.append(string2 + "</complexType>" + eol);
                string2 = string2.substring(0, string2.length() - 2);
                stringBuffer.append(string2 + "</element>" + eol);
            }
            stringBuffer.append(stringBuffer2);
            if (stringBuffer2.length() <= 0) continue;
            stringBuffer2.delete(0, stringBuffer2.length() - 1);
        }
        return new List[]{arrayList, arrayList2};
    }

    void doWsdlMessage(String string, StringBuffer stringBuffer, String string2, List[] listArray) {
        int n2;
        if (listArray[0].size() > 0) {
            stringBuffer.append(string2 + "<message name=\"" + string + "Input\">" + eol);
            for (n2 = 0; n2 < listArray[0].size(); ++n2) {
                stringBuffer.append(string2 + "   <part name=\"" + listArray[0].get(n2) + "\" type=\"tns:" + listArray[0].get(n2) + "\"/>" + eol);
            }
            stringBuffer.append(string2 + "</message>" + eol);
        } else {
            stringBuffer.append(string2 + "<message name=\"" + string + "Input\">" + eol);
            stringBuffer.append(string2 + "   <part element=\"tns:" + string + "\" name=\"parameters\"/>" + eol);
            stringBuffer.append(string2 + "</message>" + eol);
        }
        if (listArray[1].size() > 0) {
            stringBuffer.append(string2 + "<message name=\"" + string + "Output\">" + eol);
            for (n2 = 0; n2 < listArray[1].size(); ++n2) {
                stringBuffer.append(string2 + "   <part name=\"" + listArray[1].get(n2) + "\" type=\"tns:" + listArray[1].get(n2) + "\"/>" + eol);
            }
            stringBuffer.append(string2 + "</message>" + eol);
        } else {
            stringBuffer.append(string2 + "<message name=\"" + string + "Output\">" + eol);
            stringBuffer.append(string2 + "   <part element=\"tns:" + string + "Response\" name=\"parameters\"/>" + eol);
            stringBuffer.append(string2 + "</message>" + eol);
        }
    }

    void doWsdlPortOperation(String string, StringBuffer stringBuffer, String string2) {
        stringBuffer.append(string2 + "   <operation name=\"" + string + "\">" + eol);
        stringBuffer.append(string2 + "     <input message=\"tns:" + string + "Input\"/>" + eol);
        stringBuffer.append(string2 + "     <output message=\"tns:" + string + "Output\"/>" + eol);
        stringBuffer.append(string2 + "   </operation>" + eol);
    }

    void doWsdlBindOperation(String string, StringBuffer stringBuffer, String string2, String string3, String string4, boolean bl, String string5) {
        stringBuffer.append(string2 + "    <operation name=\"" + string + "\">" + eol);
        stringBuffer.append(string2 + "    <soap:operation soapAction=\"\"/>" + eol);
        stringBuffer.append(string2 + "      <input>" + eol);
        if (!bl) {
            stringBuffer.append(string2 + "         <soap:body use=\"literal\"/>" + eol);
        } else {
            stringBuffer.append(string2 + "         <soap:body encodingStyle=\"" + NS_SOAPENC + "\" namespace=\"" + string3 + string5 + "\" use=\"encoded\"/>" + eol);
        }
        stringBuffer.append(string2 + "      </input>" + eol);
        stringBuffer.append(string2 + "      <output>" + eol);
        if (!bl) {
            stringBuffer.append(string2 + "         <soap:body use=\"literal\"/>" + eol);
        } else {
            stringBuffer.append(string2 + "         <soap:body encodingStyle=\"" + NS_SOAPENC + "\" namespace=\"" + string3 + string5 + "\" use=\"encoded\"/>" + eol);
        }
        stringBuffer.append(string2 + "      </output>" + eol);
        stringBuffer.append(string2 + "    </operation>" + eol);
    }

    void getServiceBridgeCobCode(Pcc pcc, String string, String string2, VariableNameList variableNameList, int n2, boolean bl) {
        String string3 = Config.a(".compiler.servicebridge.type", "SOAP");
        if (string3.equalsIgnoreCase("SOAP")) {
            this.getServiceBridgeCobCodeSOAP(pcc, string, string2, variableNameList, n2, bl);
            if (Config.a(".compiler.servicebridge.bean", "").equalsIgnoreCase("soap")) {
                this.getServiceBridgeCobCodeBeanSOAP(pcc, string, string2, variableNameList, n2, bl);
            }
        } else if (string3.equalsIgnoreCase("REST")) {
            this.getServiceBridgeCobCodeREST(pcc, string, string2, variableNameList, n2, bl);
            if (Config.a(".compiler.servicebridge.bean", "").equalsIgnoreCase("rest")) {
                this.getServiceBridgeCobCodeBeanREST(pcc, string, string2, variableNameList, n2, bl);
            }
        } else if (string3.equalsIgnoreCase("EJB")) {
            this.getServiceBridgeCobCodeREST(pcc, string, string2, variableNameList, n2, bl);
        } else {
            this.error.print(227, 2, this.firstToken, string3);
        }
    }

    void getServiceBridgeCobCodeSOAP(Pcc pcc, String string, String string2, VariableNameList variableNameList, int n2, boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        String string3 = Config.a(".compiler.servicebridge.soap.style", "RPC");
        String string4 = "       ";
        boolean bl2 = false;
        String string5 = pcc.getServiceBridgeSoapFileName(string);
        boolean bl3 = false;
        Object var14_14 = null;
        this.loadTagAreas(string5);
        if (string3.equalsIgnoreCase("RPC")) {
            bl2 = true;
        }
        if (variableNameList != null) {
            object = variableNameList.getFirst();
            while (object != null) {
                if (!((VariableName)object).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object).getVarDecl());
                }
                object = variableNameList.getNext();
            }
        }
        stringBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        stringBuffer.append("*>start {iscobol}compiler-directives" + eol);
        stringBuffer.append("            >>SET servicebridge false" + eol);
        stringBuffer.append("            >>SET easylinkage 0" + eol);
        stringBuffer.append("*>end {iscobol}compiler-directives" + eol);
        stringBuffer.append(this.tagAreas.get(tagCompDir));
        stringBuffer.append("*>start {iscobol}prog-comment" + eol);
        stringBuffer.append("*>*" + eol);
        stringBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature SOAP type" + eol);
        stringBuffer.append("*> " + Version.getRelease() + eol);
        stringBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append("*>" + eol);
        stringBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append("*> compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
        object = Config.a(".compiler.servicebridge.soap.prefix", "soap").trim();
        stringBuffer.append("*>end {iscobol}prog-comment" + eol);
        stringBuffer.append(this.tagAreas.get(tagProgCom));
        stringBuffer.append("*>start {iscobol}progid" + eol);
        stringBuffer.append("program-id. " + (String)object + string + "." + eol);
        stringBuffer.append("*>end {iscobol}progid" + eol);
        if (this.tagAreas.get(tagProgId).length() == 0) {
            stringBuffer.append("configuration section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagProgId));
        }
        stringBuffer.append("*>start {iscobol}repository" + eol);
        stringBuffer.append("repository. " + eol);
        stringBuffer.append("      class xml-stream  as \"com.iscobol.rts.XMLStream\"" + eol);
        stringBuffer.append("           class web-area as \"com.iscobol.rts.HTTPHandler\"" + eol);
        if (bl) {
            stringBuffer.append("           class varcob as \"" + Pcc.TYPES_PACKAGE + ".CobolVar[]\"" + eol);
            stringBuffer.append("           class withentrypoints as \"com.iscobol.rts.WithEntryPoints\"" + eol);
            stringBuffer.append("           class jclass as \"java.lang.Class\"" + eol);
        }
        stringBuffer.append("*>end {iscobol}repository" + eol);
        if (this.tagAreas.get(tagReposit).length() == 0) {
            stringBuffer.append("           ." + eol);
            stringBuffer.append("working-storage section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagReposit));
        }
        stringBuffer.append("*>start {iscobol}working-storage" + eol);
        Object object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            if (((VariableDeclaration)object2).isWithDynamic() && !((VariableDeclaration)object2).hasCapacity()) {
                bl3 = true;
            }
            ((VariableDeclaration)object2).getServiceBridgeCobCode(string4, stringBuffer);
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append("       77  prg-x-stream object reference xml-stream." + eol);
        if (bl) {
            stringBuffer.append("       77  classProg object reference withentrypoints." + eol);
            stringBuffer.append("       77  cobvars   object reference varcob." + eol);
        }
        stringBuffer.append("       77  ind0                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind1                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind2                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind3                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind4                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind5                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind6                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind7                      pic 9(18)." + eol);
        stringBuffer.append("       77  ind8                      pic 9(18)." + eol);
        stringBuffer.append(eol);
        this.runWsdl2Cobol(pcc, string, stringBuffer);
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}working-storage" + eol);
        if (this.tagAreas.get(tagWorkSto).length() == 0) {
            stringBuffer.append("linkage section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagWorkSto));
        }
        stringBuffer.append("*>start {iscobol}linkage" + eol);
        stringBuffer.append("       01  comm-area object reference web-area." + eol);
        stringBuffer.append("*>end {iscobol}linkage" + eol);
        stringBuffer.append(this.tagAreas.get(tagLinkage));
        stringBuffer.append("*>start {iscobol}procedure-using" + eol);
        stringBuffer.append("procedure division using comm-area." + eol);
        stringBuffer.append("*>end {iscobol}procedure-using" + eol);
        if (this.tagAreas.get(tagProcUsi).length() == 0) {
            stringBuffer.append("main." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagProcUsi));
        }
        stringBuffer.append("*>start {iscobol}accept-http" + eol);
        stringBuffer.append("    comm-area:>acceptFromXML(soap-in-" + string + ")" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}accept-http" + eol);
        stringBuffer.append(this.tagAreas.get(tagAcceHtt));
        stringBuffer.append("*>start {iscobol}http-to-linkage" + eol);
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeCobMove("    ", "a-", "", stringBuffer, true, "", string, bl2);
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}http-to-linkage" + eol);
        stringBuffer.append(this.tagAreas.get(tagHttpLin));
        stringBuffer.append("*>start {iscobol}call" + eol);
        if (bl) {
            object2 = Config.a(".compiler.servicebridge.package", "");
            if (((String)object2).length() > 0) {
                object2 = (String)object2 + ".";
            }
            stringBuffer.append("    try" + eol);
            stringBuffer.append("       set classProg to jclass:>forName(\"" + (String)object2 + pcc.getClassName() + "\"):>newInstance as withentrypoints" + eol);
            stringBuffer.append("    catch exception" + eol);
            stringBuffer.append("    end-try" + eol);
            stringBuffer.append("    set cobvars   to varcob:>new(" + variableDeclarationList.getItemNum() + ")" + eol);
            int n3 = 0;
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                stringBuffer.append("    set cobvars(" + n3 + ") to " + variableDeclaration.getName() + pcc.getNumName(variableDeclaration.getNameToken()) + eol);
                ++n3;
                variableDeclaration = variableDeclarationList.getNext();
            }
            stringBuffer.append("    classProg:>call(" + n2 + ", cobvars)" + eol);
        } else {
            if (variableDeclarationList.getFirst() != null) {
                stringBuffer.append("    call \"" + string2 + "\" using " + eol);
            } else {
                stringBuffer.append("    call \"" + string2 + "\"" + eol);
            }
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                stringBuffer.append("                   " + ((VariableDeclaration)object2).getName() + pcc.getNumName(((VariableDeclaration)object2).getNameToken()) + eol);
                object2 = variableDeclarationList.getNext();
            }
        }
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}call" + eol);
        stringBuffer.append(this.tagAreas.get(tagCall));
        stringBuffer.append("*>start {iscobol}linkage-to-http" + eol);
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeCobMove("    ", "a-", "", stringBuffer, false, "", string, bl2);
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append("                   ." + eol);
        stringBuffer.append("*>end {iscobol}linkage-to-http" + eol);
        stringBuffer.append(this.tagAreas.get(tagLinkHtt));
        stringBuffer.append("*>start {iscobol}http-response" + eol);
        object2 = Config.a(".compiler.servicebridge.soap.charset", "UTF-8");
        stringBuffer.append("    comm-area:>addOutHeader(\"Content-Type\",\"text/xml;charset=" + (String)object2 + "\")" + eol);
        stringBuffer.append("    comm-area:>displayXML(soap-out-" + string + ")" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}http-response" + eol);
        stringBuffer.append(this.tagAreas.get(tagHttpRes));
        stringBuffer.append("*>start {iscobol}goback" + eol);
        stringBuffer.append("    goback." + eol);
        stringBuffer.append("*>end {iscobol}goback" + eol);
        stringBuffer.append(this.tagAreas.get(tagGoback));
        try {
            PrintWriter printWriter = PreProcessor.newPrintWriter(string5);
            printWriter.print(stringBuffer.toString());
            System.out.println("Generated '" + string5 + "'");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeREST(Pcc pcc, String string, String string2, VariableNameList variableNameList, int n2, boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = pcc.getServiceBridgeRestFileName(string);
        boolean bl4 = false;
        Token token = null;
        this.loadTagAreas(string3);
        if (variableNameList != null) {
            object = variableNameList.getFirst();
            while (object != null) {
                if (!((VariableName)object).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object).getVarDecl());
                }
                object = variableNameList.getNext();
            }
        }
        object = variableDeclarationList.getFirst();
        while (!(object == null || bl2 && bl3)) {
            if (((VariableDeclaration)object).isWithDynamic() && !((VariableDeclaration)object).hasCapacity()) {
                bl4 = true;
                token = ((VariableDeclaration)object).getNameToken();
            }
            if (((VariableDeclaration)object).has49LevChildOf48Lev()) {
                this.error.print(286, 2, ((VariableDeclaration)object).getNameToken(), string3);
                return;
            }
            n3 = ((VariableDeclaration)object).getWsdlMode();
            if (n3 != -2 && (n3 == 1 || n3 == 0) && ((VariableDeclaration)object).picture != null || ((VariableDeclaration)object).hasChildDifferentMode(false)) {
                bl2 = true;
            }
            if (n3 != -2 && (n3 == 2 || n3 == 0) && ((VariableDeclaration)object).picture != null || ((VariableDeclaration)object).hasChildDifferentMode(true)) {
                bl3 = true;
            }
            object = variableDeclarationList.getNext();
        }
        stringBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        stringBuffer.append("*>start {iscobol}compiler-directives" + eol);
        stringBuffer.append("            >>SET servicebridge false" + eol);
        stringBuffer.append("            >>SET easylinkage 0" + eol);
        stringBuffer.append("*>end {iscobol}compiler-directives" + eol);
        stringBuffer.append(this.tagAreas.get(tagCompDir));
        stringBuffer.append("*>start {iscobol}prog-comment" + eol);
        stringBuffer.append("*>*" + eol);
        stringBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature REST type" + eol);
        stringBuffer.append("*> " + Version.getRelease() + eol);
        stringBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append("*>" + eol);
        stringBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append("*> compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
        object = Config.a(".compiler.servicebridge.rest.prefix", "rest").trim();
        stringBuffer.append("*>end {iscobol}prog-comment" + eol);
        stringBuffer.append(this.tagAreas.get(tagProgCom));
        stringBuffer.append("*>start {iscobol}progid" + eol);
        stringBuffer.append("program-id. " + (String)object + string + "." + eol);
        stringBuffer.append("*>end {iscobol}progid" + eol);
        if (this.tagAreas.get(tagProgId).length() == 0) {
            stringBuffer.append("configuration section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagProgId));
        }
        stringBuffer.append("*>start {iscobol}repository" + eol);
        stringBuffer.append("repository. " + eol);
        stringBuffer.append("           class web-area as \"com.iscobol.rts.HTTPHandler\"" + eol);
        if (bl) {
            stringBuffer.append("           class varcob as \"" + Pcc.TYPES_PACKAGE + ".CobolVar[]\"" + eol);
            stringBuffer.append("           class withentrypoints as \"com.iscobol.rts.WithEntryPoints\"" + eol);
            stringBuffer.append("           class jclass as \"java.lang.Class\"" + eol);
        }
        stringBuffer.append("*>end {iscobol}repository" + eol);
        if (this.tagAreas.get(tagReposit).length() == 0) {
            stringBuffer.append("           ." + eol);
            stringBuffer.append("working-storage section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagReposit));
        }
        stringBuffer.append("*>start {iscobol}working-storage" + eol);
        Object object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeCobCode("", "int", stringBuffer, true);
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        if (bl) {
            stringBuffer.append("77  classProg object reference withentrypoints." + eol);
            stringBuffer.append("77  cobvars   object reference varcob." + eol);
        }
        stringBuffer.append("77  ind0                      pic 9(18)." + eol);
        stringBuffer.append("77  ind1                      pic 9(18)." + eol);
        stringBuffer.append("77  ind2                      pic 9(18)." + eol);
        stringBuffer.append("77  ind3                      pic 9(18)." + eol);
        stringBuffer.append("77  ind4                      pic 9(18)." + eol);
        stringBuffer.append("77  ind5                      pic 9(18)." + eol);
        stringBuffer.append("77  ind6                      pic 9(18)." + eol);
        stringBuffer.append("77  ind7                      pic 9(18)." + eol);
        stringBuffer.append("77  ind8                      pic 9(18)." + eol);
        stringBuffer.append("77  request-method            pic x any length." + eol);
        stringBuffer.append("    88  post-method     value \"POST\"." + eol);
        stringBuffer.append("    88  put-method      value \"PUT\"." + eol);
        stringBuffer.append("    88  delete-method   value \"DELETE\"." + eol);
        stringBuffer.append("    88  get-method      value \"GET\"." + eol);
        stringBuffer.append("01  request-varin identified by \"Request\"." + eol);
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeRestCobCode("", stringBuffer, true);
            object2 = variableDeclarationList.getNext();
        }
        if (!bl2) {
            stringBuffer.append("         03  iscobol-dummy-varin pic x." + eol);
        }
        stringBuffer.append("01  response-varout identified by \"Response\"." + eol);
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeRestCobCode("  ", stringBuffer, false);
            object2 = variableDeclarationList.getNext();
        }
        if (!bl3) {
            stringBuffer.append("         03  iscobol-dummy-varout pic x." + eol);
        }
        stringBuffer.append("*>end {iscobol}working-storage" + eol);
        stringBuffer.append(eol);
        if (this.tagAreas.get(tagWorkSto).length() == 0) {
            stringBuffer.append("linkage section." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagWorkSto));
        }
        stringBuffer.append("*>start {iscobol}linkage" + eol);
        stringBuffer.append("01  comm-area object reference web-area." + eol);
        stringBuffer.append("*>end {iscobol}linkage" + eol);
        stringBuffer.append(this.tagAreas.get(tagLinkage));
        stringBuffer.append("*>start {iscobol}procedure-using" + eol);
        stringBuffer.append("procedure division using comm-area." + eol);
        stringBuffer.append("*>end {iscobol}procedure-using" + eol);
        if (this.tagAreas.get(tagProcUsi).length() == 0) {
            stringBuffer.append("main." + eol);
        } else {
            stringBuffer.append(this.tagAreas.get(tagProcUsi));
        }
        stringBuffer.append("*>start {iscobol}accept-http" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("    set request-method to comm-area:>getMethod()" + eol);
        if (bl2) {
            stringBuffer.append("   if post-method or put-method" + eol);
            stringBuffer.append("*> POST and PUT methods" + eol);
            stringBuffer.append("     comm-area:>acceptEx(request-varin)" + eol);
            stringBuffer.append("   else" + eol);
            stringBuffer.append("*> GET, DELETE and other methods" + eol);
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                n3 = ((VariableDeclaration)object2).getWsdlMode();
                if (n3 != -2 && (n3 == 1 || n3 == 0) || ((VariableDeclaration)object2).hasChildDifferentMode(false)) {
                    ((VariableDeclaration)object2).getServiceBridgeCobRestAccept("     ", stringBuffer, "");
                }
                object2 = variableDeclarationList.getNext();
            }
            stringBuffer.append("   end-if" + eol);
            stringBuffer.append(eol);
            stringBuffer.append("*>end {iscobol}accept-http" + eol);
            stringBuffer.append(this.tagAreas.get(tagAcceHtt));
            stringBuffer.append("*>start {iscobol}http-to-linkage" + eol);
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                n3 = ((VariableDeclaration)object2).getWsdlMode();
                if (n3 != -2 && (n3 == 1 || n3 == 0) || ((VariableDeclaration)object2).hasChildDifferentMode(false)) {
                    ((VariableDeclaration)object2).getServiceBridgeCobMove("    ", "", "int", stringBuffer, true, "", true, string);
                }
                object2 = variableDeclarationList.getNext();
            }
            stringBuffer.append("*>end {iscobol}http-to-linkage" + eol);
            stringBuffer.append(this.tagAreas.get(tagHttpLin));
        } else {
            stringBuffer.append("*>end {iscobol}accept-http" + eol);
            stringBuffer.append(this.tagAreas.get(tagAcceHtt));
        }
        stringBuffer.append(eol);
        stringBuffer.append("*>start {iscobol}call" + eol);
        if (bl) {
            object2 = Config.a(".compiler.servicebridge.package", "");
            if (((String)object2).length() > 0) {
                object2 = (String)object2 + ".";
            }
            stringBuffer.append("    try" + eol);
            stringBuffer.append("       set classProg to jclass:>forName(\"" + (String)object2 + pcc.getClassName() + "\"):>newInstance as withentrypoints" + eol);
            stringBuffer.append("    catch exception" + eol);
            stringBuffer.append("    end-try" + eol);
            stringBuffer.append("    set cobvars   to varcob:>new(" + variableDeclarationList.getItemNum() + ")" + eol);
            int n4 = 0;
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                stringBuffer.append("    set cobvars(" + n4 + ") to int" + variableDeclaration.getName() + eol);
                ++n4;
                variableDeclaration = variableDeclarationList.getNext();
            }
            stringBuffer.append("    classProg:>call(" + n2 + ", cobvars)" + eol);
        } else {
            if (variableDeclarationList.getFirst() != null) {
                stringBuffer.append("    call \"" + string2 + "\" using " + eol);
            } else {
                stringBuffer.append("    call \"" + string2 + "\"" + eol);
            }
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                stringBuffer.append("                   int" + ((VariableDeclaration)object2).getName() + eol);
                object2 = variableDeclarationList.getNext();
            }
        }
        stringBuffer.append("*>end {iscobol}call" + eol);
        stringBuffer.append(this.tagAreas.get(tagCall));
        stringBuffer.append("*>start {iscobol}linkage-to-http" + eol);
        stringBuffer.append(eol);
        if (bl3) {
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                n3 = ((VariableDeclaration)object2).getWsdlMode();
                if (n3 != -2 && (n3 == 2 || n3 == 0 || ((VariableDeclaration)object2).hasChildDifferentMode(true))) {
                    ((VariableDeclaration)object2).getServiceBridgeCobMove("    ", "", "int", stringBuffer, false, "", true, string);
                }
                object2 = variableDeclarationList.getNext();
            }
        }
        stringBuffer.append("                   ." + eol);
        stringBuffer.append("*>end {iscobol}linkage-to-http" + eol);
        stringBuffer.append(this.tagAreas.get(tagLinkHtt));
        stringBuffer.append("*>start {iscobol}http-response" + eol);
        if (bl3) {
            stringBuffer.append("    comm-area:>displayEx(response-varout)" + eol);
        }
        stringBuffer.append(eol);
        stringBuffer.append("*>end {iscobol}http-response" + eol);
        stringBuffer.append(this.tagAreas.get(tagHttpRes));
        stringBuffer.append("*>start {iscobol}goback" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("    goback." + eol);
        stringBuffer.append("*>end {iscobol}goback" + eol);
        try {
            object2 = PreProcessor.newPrintWriter(string3);
            ((PrintWriter)object2).print(stringBuffer.toString());
            ((PrintWriter)object2).close();
            System.out.println("Generated '" + string3 + "'");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeBeanREST(Pcc pcc, String string, String string2, VariableNameList variableNameList, int n2, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        String string3 = Config.a(".compiler.servicebridge.bean.prefix", "bean").trim();
        boolean bl4 = false;
        Token token = null;
        if (variableNameList != null) {
            object2 = variableNameList.getFirst();
            while (object2 != null) {
                if (!((VariableName)object2).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object2).getVarDecl());
                }
                object2 = variableNameList.getNext();
            }
        }
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            if (((VariableDeclaration)object2).isWithDynamic()) {
                bl4 = true;
                token = ((VariableDeclaration)object2).getNameToken();
            }
            object2 = variableDeclarationList.getNext();
        }
        object2 = variableDeclarationList.getFirst();
        while (!(object2 == null || bl2 && bl3)) {
            n3 = ((VariableDeclaration)object2).getWsdlMode();
            if (n3 != -2 && (n3 == 1 || n3 == 0) && ((VariableDeclaration)object2).picture != null || ((VariableDeclaration)object2).hasChildDifferentMode(false)) {
                bl2 = true;
            }
            if (n3 != -2 && (n3 == 2 || n3 == 0) && ((VariableDeclaration)object2).picture != null || ((VariableDeclaration)object2).hasChildDifferentMode(true)) {
                bl3 = true;
            }
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        stringBuffer.append("            >>IMP OPTION \"#whttp\"" + eol);
        stringBuffer.append("            >>SET servicebridge false" + eol);
        stringBuffer.append("            >>SET easylinkage 0" + eol);
        stringBuffer.append("*>*" + eol);
        stringBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature REST type" + eol);
        stringBuffer.append("*> " + Version.getRelease() + eol);
        stringBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append("*>" + eol);
        stringBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append("*> compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
        object2 = Config.a(".compiler.servicebridge.bean.package", "").trim();
        if (((String)object2).length() > 0) {
            object2 = (String)object2 + ".";
        }
        stringBuffer.append("class-id. " + string3 + string + " as \"" + (String)object2 + string3 + string + "\"." + eol);
        stringBuffer.append("configuration section." + eol);
        stringBuffer.append("repository. " + eol);
        stringBuffer.append("           class HTTP-CLIENT as \"com.iscobol.rts.HTTPClient\"" + eol);
        stringBuffer.append("           class HTTP-PARAM as \"com.iscobol.rts.HTTPData.Params\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("factory." + eol);
        stringBuffer.append("data division." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"main\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   copy \"" + string3 + string + ".wrk\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("01 var object reference " + string3 + string + "." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("01 value-in object reference \"java.lang.String[]\"." + eol);
        stringBuffer.append("procedure division using value-in." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set var to " + string3 + string + ":>new()." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   copy \"" + string3 + string + ".cpy\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("end method \"main\"." + eol);
        stringBuffer.append("end factory." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("object." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append(eol);
        Object object3 = variableDeclarationList.getFirst();
        while (object3 != null) {
            ((VariableDeclaration)object3).getServiceBridgeCobCode("", "bean-", stringBuffer);
            object3 = variableDeclarationList.getNext();
        }
        stringBuffer.append("       01  LNK-INVAR identified by \"Request\"." + eol);
        if (!bl2) {
            stringBuffer.append("         03  iscobol-dummy-varin pic x." + eol);
        }
        object3 = variableDeclarationList.getFirst();
        while (object3 != null) {
            ((VariableDeclaration)object3).getServiceBridgeRestCobCode("", stringBuffer, true);
            object3 = variableDeclarationList.getNext();
        }
        stringBuffer.append("       01  response-varout identified by \"Response\"." + eol);
        object3 = variableDeclarationList.getFirst();
        while (object3 != null) {
            ((VariableDeclaration)object3).getServiceBridgeRestCobCode("", stringBuffer, false);
            object3 = variableDeclarationList.getNext();
        }
        if (!bl3) {
            stringBuffer.append("         03  iscobol-dummy-varout pic x." + eol);
        }
        stringBuffer.append(eol);
        object3 = Config.a(".compiler.servicebridge.bean.url", "http://localhost:8080/services").trim() + "/" + string;
        stringBuffer.append("01  url pic x any length value" + eol);
        stringBuffer.append("    \"" + ((String)object3).trim() + "\"." + eol);
        stringBuffer.append("77  http object reference http-client." + eol);
        stringBuffer.append("77  params object reference http-param." + eol);
        stringBuffer.append("77  response-code        pic S9(3)." + eol);
        stringBuffer.append("77  response-message     pic x(256)." + eol);
        stringBuffer.append("77  indx                 pic 9(18)." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append("*> --------->" + eol);
        stringBuffer.append(eol);
        int n4 = 0;
        VariableDeclaration variableDeclaration = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (variableDeclarationList.getFirst() != null) {
            stringBuffer2.append(eol);
            stringBuffer2.append("identification division." + eol);
            stringBuffer2.append("method-id. \"run\"." + eol);
            stringBuffer2.append("working-storage section." + eol);
            stringBuffer2.append("linkage section." + eol);
            object = variableDeclarationList.getFirst();
            while (object != null) {
                ((VariableDeclaration)object).getServiceBridgeBeanCobCode("", "", stringBuffer2, vector, true);
                object = variableDeclarationList.getNext();
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                variableDeclaration = (VariableDeclaration)object.nextElement();
                if (variableDeclaration.getOccursAll() == 0) {
                    ++n4;
                    continue;
                }
                n4 += variableDeclaration.getOccursAll();
            }
            if (n4 > 254) {
                this.error.print(250, 2, this.firstToken, string3 + string2);
            } else if (bl4) {
                this.error.print(270, 2, token, string3 + string2);
            } else {
                int n5;
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("procedure division using");
                object = vector.elements();
                while (object.hasMoreElements()) {
                    variableDeclaration = (VariableDeclaration)object.nextElement();
                    if (variableDeclaration.haveOccursClause() && variableDeclaration.isDynamic()) {
                        stringBuffer.append(eol + " dyn-" + variableDeclaration.name.getWord());
                        continue;
                    }
                    if (variableDeclaration.getOccursAll() == 0) {
                        stringBuffer.append(eol + " " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name));
                        continue;
                    }
                    for (n5 = 0; n5 < variableDeclaration.getOccursAll(); ++n5) {
                        stringBuffer.append(eol + eol + " " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "_" + n5);
                    }
                }
                stringBuffer.append("." + eol);
                stringBuffer.append("main." + eol);
                object = vector.elements();
                while (object.hasMoreElements()) {
                    variableDeclaration = (VariableDeclaration)object.nextElement();
                    if (variableDeclaration.haveOccursClause() && variableDeclaration.isDynamic()) {
                        stringBuffer.append("     set dynamic-bean-" + variableDeclaration.name.getWord() + " to dyn-" + variableDeclaration.name.getWord() + eol);
                        continue;
                    }
                    if (variableDeclaration.getOccursAll() == 0) {
                        stringBuffer.append("     set bean-" + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + " to " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + eol);
                        continue;
                    }
                    for (n5 = 0; n5 < variableDeclaration.getOccursAll(); ++n5) {
                        stringBuffer.append("     set bean-" + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "(" + (n5 + 1) + ") to " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "_" + n5 + eol);
                    }
                }
                object = vector.elements();
                while (object.hasMoreElements()) {
                    variableDeclaration = (VariableDeclaration)object.nextElement();
                    if (variableDeclaration.haveOccursClause() && variableDeclaration.isDynamic()) {
                        stringBuffer.append("     set " + variableDeclaration.getWsdlNameSuff(true) + "-in to dyn-" + variableDeclaration.name.getWord() + eol);
                        continue;
                    }
                    if (variableDeclaration.getOccursAll() == 0) {
                        stringBuffer.append("     set " + variableDeclaration.getWsdlNameSuff(true) + "-in to " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + eol);
                        continue;
                    }
                    for (n5 = 0; n5 < variableDeclaration.getOccursAll(); ++n5) {
                        stringBuffer.append("     set " + variableDeclaration.getWsdlNameSuff(true) + "-in(" + (n5 + 1) + ") to " + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "_" + n5 + eol);
                    }
                }
                stringBuffer.append("     if http = null" + eol);
                stringBuffer.append("        set  http = http-client:>new()" + eol);
                stringBuffer.append("     end-if" + eol);
                stringBuffer.append("     try" + eol);
                stringBuffer.append("        http:>doPostEx (url, LNK-invar )" + eol);
                stringBuffer.append("        http:>getResponseCode (response-code)" + eol);
                stringBuffer.append(eol);
                stringBuffer.append("        if response-code = 200" + eol);
                stringBuffer.append("           http:>getResponseEx (response-varout)" + eol);
                object = variableDeclarationList.getFirst();
                while (object != null) {
                    ((VariableDeclaration)object).getServiceBridgeBeanCobMove("           ", "", "bean-", false, stringBuffer, 0);
                    object = variableDeclarationList.getNext();
                }
                stringBuffer.append("        else" + eol);
                stringBuffer.append("           http:>getResponseMessage (response-message)" + eol);
                stringBuffer.append("           display \"ERROR\" response-code \"-\" response-message" + eol);
                stringBuffer.append("        end-if" + eol);
                stringBuffer.append("     catch exception" + eol);
                stringBuffer.append("        display \"error[\" exception-object:>toString \"]\"" + eol);
                stringBuffer.append("     end-try" + eol);
                stringBuffer.append("     goback." + eol);
                stringBuffer.append(eol);
                stringBuffer.append("end method \"run\"." + eol);
            }
        }
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"run\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append("main." + eol);
        object = vector.elements();
        while (object.hasMoreElements()) {
            variableDeclaration = (VariableDeclaration)object.nextElement();
            if (variableDeclaration.haveOccursClause() && variableDeclaration.isInDynamic()) {
                stringBuffer.append("    perform varying indx from 1 by 1 until  indx > ");
                if (variableDeclaration.getCapacityAll() != null) {
                    stringBuffer.append(variableDeclaration.getCapacityAll().getVarDecl().name.getWord() + eol);
                } else if (variableDeclaration.isDynamic()) {
                    stringBuffer.append("cap-" + variableDeclaration.name.getWord() + "-in" + eol);
                } else {
                    stringBuffer.append("cap-" + variableDeclaration.getDynamicVarName() + "-in" + eol);
                }
                stringBuffer.append("       move bean-" + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "(indx) to " + variableDeclaration.getWsdlNameSuff(true) + "-in(indx)" + eol);
                stringBuffer.append("    end-perform" + eol);
                continue;
            }
            if (variableDeclaration.getOccursAll() == 0) {
                stringBuffer.append("     move bean-" + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + " to " + variableDeclaration.getWsdlNameSuff(true) + "-in" + eol);
                continue;
            }
            stringBuffer.append("     perform varying indx from 1 by 1 until  indx > " + variableDeclaration.getOccursAll() + eol);
            stringBuffer.append("        move bean-" + variableDeclaration.name.getWord() + pcc.getNumName(variableDeclaration.name) + "(indx) to " + variableDeclaration.getWsdlNameSuff(true) + "-in(indx)" + eol);
            stringBuffer.append("     end-perform" + eol);
        }
        stringBuffer.append("     if http = null" + eol);
        stringBuffer.append("        set  http = http-client:>new()" + eol);
        stringBuffer.append("     end-if" + eol);
        stringBuffer.append("     try" + eol);
        stringBuffer.append("        http:>doPostEx (url, LNK-invar )" + eol);
        stringBuffer.append("        http:>getResponseCode (response-code)" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("        if response-code = 200" + eol);
        stringBuffer.append("           http:>getResponseEx (response-varout)" + eol);
        object = variableDeclarationList.getFirst();
        while (object != null) {
            ((VariableDeclaration)object).getServiceBridgeBeanCobMove("           ", "", "bean-", false, stringBuffer, 0);
            object = variableDeclarationList.getNext();
        }
        stringBuffer.append("        else" + eol);
        stringBuffer.append("           http:>getResponseMessage (response-message)" + eol);
        stringBuffer.append("           display \"ERROR\" response-code \"-\" response-message" + eol);
        stringBuffer.append("     end-if" + eol);
        stringBuffer.append("     catch exception" + eol);
        stringBuffer.append("        display \"error[\" exception-object:>toString \"]\"" + eol);
        stringBuffer.append("     end-try" + eol);
        stringBuffer.append("     goback." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("end method \"run\"." + eol);
        stringBuffer.append(eol);
        object = variableDeclarationList.getFirst();
        while (object != null) {
            ((VariableDeclaration)object).getServiceBridgeBeanSetGetCobCode(stringBuffer);
            object = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"set_url\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("77 value-in object reference \"java.lang.String\"." + eol);
        stringBuffer.append("procedure division using value-in." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set url to value-in." + eol);
        stringBuffer.append("end method \"set_url\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"get_url\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("77 value-out object reference \"java.lang.String\"." + eol);
        stringBuffer.append("procedure division returning value-out." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set value-out to url." + eol);
        stringBuffer.append("end method \"get_url\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("end object." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("*> end class " + string3 + string + eol);
        try {
            object = pcc.getServiceBridgeRestBeanFileName(string);
            PrintWriter printWriter = PreProcessor.newPrintWriter((String)object);
            printWriter.print(stringBuffer.toString());
            printWriter.close();
            System.out.println("Generated '" + (String)object + "'");
            this.doCopyFile(pcc, string3 + string, false);
            this.doCopyFile(pcc, string3 + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeBeanSOAP(Pcc pcc, String string, String string2, VariableNameList variableNameList, int n2, boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        String string3 = Config.a(".compiler.servicebridge.bean.prefix", "bean").trim();
        boolean bl2 = false;
        Token token = null;
        if (variableNameList != null) {
            object = variableNameList.getFirst();
            while (object != null) {
                if (!((VariableName)object).isFactory()) {
                    variableDeclarationList.addItem(((VariableName)object).getVarDecl());
                }
                object = variableNameList.getNext();
            }
        }
        object = variableDeclarationList.getFirst();
        while (object != null && !bl2) {
            if (((VariableDeclaration)object).isWithDynamic()) {
                bl2 = true;
                token = ((VariableDeclaration)object).getNameToken();
            }
            object = variableDeclarationList.getNext();
        }
        stringBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        stringBuffer.append("            >>IMP OPTION \"#whttp\"" + eol);
        stringBuffer.append("            >>SET servicebridge false" + eol);
        stringBuffer.append("            >>SET easylinkage 0" + eol);
        stringBuffer.append("*>*" + eol);
        stringBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature SOAP type" + eol);
        stringBuffer.append("*> " + Version.getRelease() + eol);
        stringBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        stringBuffer.append("*>" + eol);
        stringBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        stringBuffer.append("*> compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
        object = Config.a(".compiler.servicebridge.bean.package", "").trim();
        if (((String)object).length() > 0) {
            object = (String)object + ".";
        }
        stringBuffer.append("class-id. " + string3 + string + " as \"" + (String)object + string3 + string + "\"." + eol);
        stringBuffer.append("configuration section." + eol);
        stringBuffer.append("repository. " + eol);
        stringBuffer.append("           class HTTP-CLIENT as \"com.iscobol.rts.HTTPClient\"" + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("factory." + eol);
        stringBuffer.append("data division." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"main\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("01 var object reference " + string3 + string + "." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   copy \"" + string3 + string + ".wrk\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("01 value-in object reference \"java.lang.String[]\"." + eol);
        stringBuffer.append("procedure division using value-in." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set var to " + string3 + string + ":>new()." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("   copy \"" + string3 + string + ".cpy\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("end method \"main\"." + eol);
        stringBuffer.append("end factory." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("object." + eol);
        stringBuffer.append("working-storage section." + eol);
        String string4 = Config.a(".compiler.servicebridge.bean.url", "http://localhost:8080/services").trim() + "/" + string;
        stringBuffer.append("01  var-url pic x any length value \"" + string4 + "/" + string + "\"." + eol);
        stringBuffer.append("77  ind0        pic 9(18)." + eol);
        VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.getServiceBridgeCobCode("", "bean-", stringBuffer);
            variableDeclaration = variableDeclarationList.getNext();
        }
        this.runWsdl2Cobol(pcc, string, stringBuffer);
        stringBuffer.append(eol);
        stringBuffer.append("77  http object reference http-client." + eol);
        stringBuffer.append("01  plain-response       pic x any length." + eol);
        stringBuffer.append("01  response-code        pic S9(3)." + eol);
        stringBuffer.append("01  response-message     pic x(256)." + eol);
        stringBuffer.append("77  indx                 pic 9(18)." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append("*>---------->");
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"run\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append(eol);
        stringBuffer.append(eol);
        stringBuffer.append("procedure division." + eol);
        stringBuffer.append("main." + eol);
        variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.getServiceBridgeCobMove("    ", "a-", "bean-", stringBuffer, true, "", string);
            variableDeclaration = variableDeclarationList.getNext();
        }
        stringBuffer.append("    set environment \"xmlstream.omit_empty_elements\" to 0." + eol);
        stringBuffer.append("    set http = http-client:>new." + eol);
        stringBuffer.append("    try" + eol);
        stringBuffer.append("       http:>doPostEx (" + eol);
        stringBuffer.append("                var-url " + eol);
        stringBuffer.append("                \"application/soap+xml; charset=utf-8\"" + eol);
        stringBuffer.append("                 soap-in-" + string + ")" + eol);
        stringBuffer.append("       http:>getResponseCode (response-code)" + eol);
        stringBuffer.append("       if response-code = 200" + eol);
        stringBuffer.append("          http:>getResponseXML (soap-out-" + string + ")" + eol);
        variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.getServiceBridgeCobMove("          ", "a-", "bean-", stringBuffer, false, "", string);
            variableDeclaration = variableDeclarationList.getNext();
        }
        stringBuffer.append("       else" + eol);
        stringBuffer.append("          http:>getResponsePlain (plain-response)" + eol);
        stringBuffer.append("          display \"error[\" plain-response \"]\"" + eol);
        stringBuffer.append("       end-if" + eol);
        stringBuffer.append("    catch exception" + eol);
        stringBuffer.append("       display \"error[\" exception-object:>toString \"]\"" + eol);
        stringBuffer.append("    end-try" + eol);
        stringBuffer.append(eol);
        stringBuffer.append("end method \"run\"." + eol);
        stringBuffer.append(eol);
        int n3 = 0;
        VariableDeclaration variableDeclaration2 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(eol);
        stringBuffer2.append("identification division." + eol);
        stringBuffer2.append("method-id. \"run\"." + eol);
        stringBuffer2.append("working-storage section." + eol);
        stringBuffer2.append("linkage section." + eol);
        Object object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeBeanCobCode("", "", stringBuffer2, vector, true);
            object2 = variableDeclarationList.getNext();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            variableDeclaration2 = (VariableDeclaration)object2.nextElement();
            if (variableDeclaration2.getOccursAll() == 0) {
                ++n3;
                continue;
            }
            n3 += variableDeclaration2.getOccursAll();
        }
        if (n3 > 254) {
            this.error.print(250, 2, this.firstToken, string3 + string2);
        } else if (bl2) {
            this.error.print(270, 2, token, string3 + string2);
        } else {
            int n4;
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("procedure division using");
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                variableDeclaration2 = (VariableDeclaration)object2.nextElement();
                if (variableDeclaration2.haveOccursClause() && variableDeclaration2.isDynamic()) {
                    stringBuffer.append(eol + " dyn-" + variableDeclaration2.name.getWord());
                    continue;
                }
                if (variableDeclaration2.getOccursAll() == 0) {
                    stringBuffer.append(eol + " " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name));
                    continue;
                }
                for (n4 = 0; n4 < variableDeclaration2.getOccursAll(); ++n4) {
                    stringBuffer.append(eol + " " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + "_" + n4);
                }
            }
            stringBuffer.append("." + eol);
            stringBuffer.append("main." + eol);
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                variableDeclaration2 = (VariableDeclaration)object2.nextElement();
                if (variableDeclaration2.isDynamic()) {
                    stringBuffer.append("    set dynamic-bean-" + variableDeclaration2.name.getWord() + " to dyn-" + variableDeclaration2.name.getWord() + eol);
                    continue;
                }
                if (variableDeclaration2.getOccursAll() == 0) {
                    stringBuffer.append("    set bean-" + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + " to " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + eol);
                    continue;
                }
                for (n4 = 0; n4 < variableDeclaration2.getOccursAll(); ++n4) {
                    stringBuffer.append("    set bean-" + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + "(" + (n4 + 1) + ") to " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + "_" + n4 + eol);
                }
            }
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                ((VariableDeclaration)object2).getServiceBridgeCobMove("    ", "a-", "bean-", stringBuffer, true, "", string);
                object2 = variableDeclarationList.getNext();
            }
            stringBuffer.append("    ." + eol);
            stringBuffer.append(eol);
            stringBuffer.append("    set environment \"xmlstream.omit_empty_elements\" to 0." + eol);
            stringBuffer.append("    set http = http-client:>new." + eol);
            stringBuffer.append("    try" + eol);
            stringBuffer.append("       http:>doPostEx (" + eol);
            stringBuffer.append("                var-url" + eol);
            stringBuffer.append("                \"application/soap+xml; charset=utf-8\"" + eol);
            stringBuffer.append("                 soap-in-" + string + ")" + eol);
            stringBuffer.append("       http:>getResponseCode (response-code)" + eol);
            stringBuffer.append("       if response-code = 200" + eol);
            stringBuffer.append("          http:>getResponseXML (soap-out-" + string + ")" + eol);
            object2 = variableDeclarationList.getFirst();
            while (object2 != null) {
                ((VariableDeclaration)object2).getServiceBridgeCobMove("          ", "a-", "bean-", stringBuffer, false, "", string);
                object2 = variableDeclarationList.getNext();
            }
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                variableDeclaration2 = (VariableDeclaration)object2.nextElement();
                if (variableDeclaration2.isDynamic()) {
                    stringBuffer.append("          set dyn-" + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + " to dynamic-bean-" + variableDeclaration2.name.getWord() + eol);
                    continue;
                }
                if (variableDeclaration2.getOccursAll() == 0) {
                    stringBuffer.append("          set " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + " to bean-" + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + eol);
                    continue;
                }
                for (n4 = 0; n4 < variableDeclaration2.getOccursAll(); ++n4) {
                    stringBuffer.append("          set " + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + "_" + n4 + " to bean-" + variableDeclaration2.name.getWord() + pcc.getNumName(variableDeclaration2.name) + "(" + (n4 + 1) + ")" + eol);
                }
            }
            stringBuffer.append("       else" + eol);
            stringBuffer.append("          http:>getResponsePlain (plain-response)" + eol);
            stringBuffer.append("          display \"error[\" plain-response \"]\"" + eol);
            stringBuffer.append("       end-if" + eol);
            stringBuffer.append("    catch exception" + eol);
            stringBuffer.append("       display \"error[\" exception-object:>toString \"]\"" + eol);
            stringBuffer.append("    end-try" + eol);
            stringBuffer.append(eol);
            stringBuffer.append("end method \"run\"." + eol);
        }
        stringBuffer.append(eol);
        object2 = variableDeclarationList.getFirst();
        while (object2 != null) {
            ((VariableDeclaration)object2).getServiceBridgeBeanSetGetCobCode(stringBuffer);
            object2 = variableDeclarationList.getNext();
        }
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"set_url\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("77 value-in object reference \"java.lang.String\"." + eol);
        stringBuffer.append("procedure division using value-in." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set var-url to value-in." + eol);
        stringBuffer.append("end method \"set_url\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("identification division." + eol);
        stringBuffer.append("method-id. \"get_url\"." + eol);
        stringBuffer.append("working-storage section." + eol);
        stringBuffer.append("linkage section." + eol);
        stringBuffer.append("77 value-out object reference \"java.lang.String\"." + eol);
        stringBuffer.append("procedure division returning value-out." + eol);
        stringBuffer.append("main." + eol);
        stringBuffer.append("   set value-out to var-url." + eol);
        stringBuffer.append("end method \"get_url\"." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("end object." + eol);
        stringBuffer.append(eol);
        stringBuffer.append("*> end class " + string3 + string + eol);
        try {
            object2 = pcc.getServiceBridgeSoapBeanFileName(string);
            PrintWriter printWriter = PreProcessor.newPrintWriter((String)object2);
            printWriter.print(stringBuffer.toString());
            printWriter.close();
            System.out.println("Generated '" + (String)object2 + "'");
            this.doCopyFile(pcc, string3 + string, false);
            this.doCopyFile(pcc, string3 + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void doCopyFile(Pcc pcc, String string) {
        this.doCopyFile(pcc, string, true);
    }

    void doCopyFile(Pcc pcc, String string, boolean bl) {
        String string2 = pcc.getServiceBridgeCopyFileName(string);
        if (!bl) {
            string2 = pcc.getServiceBridgeCopyFileNameWrk(string);
        }
        File file = new File(string2);
        if (pcc.getTokenManager().pp.getFileFinder().findFile(file.getName()) == null && !file.exists()) {
            if (pcc.getTokenManager().pp.getFileFinder() instanceof CachedFileFinder) {
                ((CachedFileFinder)pcc.getTokenManager().pp.getFileFinder()).clearCache();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*>*" + eol);
            stringBuffer.append("*> Copyfile generated by isCobol compiler for ServiceBridge feature" + eol);
            stringBuffer.append("*> " + Version.getRelease() + eol);
            stringBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
            stringBuffer.append("*>" + eol);
            stringBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
            stringBuffer.append("*> compiler options: " + pcc.getOptions().getAll().replace('\\', '/') + eol);
            stringBuffer.append("*>*" + eol);
            stringBuffer.append(eol);
            stringBuffer.append(eol);
            stringBuffer.append(eol);
            stringBuffer.append("*> --------->" + eol);
            stringBuffer.append("*> --------->" + eol);
            if (bl) {
                stringBuffer.append("*> ---------> ADD YOUR CODE HERE" + eol);
            } else {
                stringBuffer.append("*> ---------> ADD YOUR VARIABLE DECLARATION  HERE" + eol);
            }
            stringBuffer.append("*> --------->" + eol);
            stringBuffer.append("*> --------->" + eol);
            try {
                PrintWriter printWriter = PreProcessor.newPrintWriter(string2);
                printWriter.print(stringBuffer.toString());
                printWriter.close();
                if (pcc.getFileFinder() instanceof RemoteFileFinder) {
                    RemoteFileFinder remoteFileFinder = (RemoteFileFinder)pcc.getFileFinder();
                    remoteFileFinder.getCompileUnit().addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(string2, string2.substring(remoteFileFinder.getSourceDir().length() + 1), 4));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void runWsdl2Cobol(Pcc pcc, String string, StringBuffer stringBuffer) {
        int n2 = Config.a(".compiler.servicebridge.soap.envelope.version", 0);
        if (n2 < 0 || n2 > 1) {
            n2 = 0;
        }
        ServiceBridgeUtility serviceBridgeUtility = new ServiceBridgeUtility(pcc.getWsdlFileName(), n2);
        serviceBridgeUtility.setArraySizes(this.wdslArraySizes);
        try {
            Map<String, StringBuilder> map = serviceBridgeUtility.generateCopyfiles();
            stringBuffer.append((Object)map.get(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadTagAreas(String string) {
        this.tagAreas.clear();
        this.tagAreas.put(tagCompDir, new StringBuffer());
        this.tagAreas.put(tagProgCom, new StringBuffer());
        this.tagAreas.put(tagProgId, new StringBuffer());
        this.tagAreas.put(tagReposit, new StringBuffer());
        this.tagAreas.put(tagWorkSto, new StringBuffer());
        this.tagAreas.put(tagLinkage, new StringBuffer());
        this.tagAreas.put(tagProcUsi, new StringBuffer());
        this.tagAreas.put(tagAcceHtt, new StringBuffer());
        this.tagAreas.put(tagHttpLin, new StringBuffer());
        this.tagAreas.put(tagCall, new StringBuffer());
        this.tagAreas.put(tagLinkHtt, new StringBuffer());
        this.tagAreas.put(tagHttpRes, new StringBuffer());
        this.tagAreas.put(tagGoback, new StringBuffer());
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            String string3 = "";
            while (string2 != null) {
                if (string2.trim().startsWith(endTag) && this.tagAreas.containsKey(string3 = string2.trim().substring(endTag.length()).trim())) {
                    string2 = bufferedReader.readLine();
                    while (string2 != null && !string2.trim().startsWith(startTag)) {
                        this.tagAreas.get(string3).append(string2 + eol);
                        string2 = bufferedReader.readLine();
                    }
                }
                if (string2 == null) continue;
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public WorkingStorageSection getWorkingStorageSection() {
        return this.wsSec;
    }

    @Override
    public LocalStorageSection getLocalStorageSection() {
        return this.lsSec;
    }

    @Override
    public ThreadLocalStorageSection getThreadLocalStorageSection() {
        return this.tlsSec;
    }

    @Override
    public LinkageSection getLinkageSection() {
        return this.linkSec;
    }

    @Override
    public FileSection getFileSection() {
        return this.fileSec;
    }

    @Override
    public ReportSection getReportSection() {
        return this.repoSec;
    }

    @Override
    public ScreenSection getScreenSection() {
        return this.screenSec;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

