/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.VariableNameList;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class DefaultClass
extends MyClass {
    final Class extClass;
    final String extClassName;
    final Pcc intClass;
    MyMethod[] ctors;
    MyMethod[] methods;
    MyMethod[] methodsProt;
    MyField[] fields;
    MyField[] fieldsProt;
    MyMethod[] funcMethod;
    int dimensions;

    DefaultClass(String string, Pcc pcc, int n2) throws ClassNotFoundException {
        Pcc pcc2;
        String string2;
        Class clazz;
        try {
            clazz = DefaultClass.forName(string);
            string2 = string;
            pcc2 = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (pcc != null) {
                Pcc pcc3 = pcc.getReferencedPcc(string);
                if (pcc3 != Pcc.CLASS_NOT_FOUND) {
                    clazz = null;
                    string2 = null;
                    pcc2 = pcc3;
                    this.dimensions = n2;
                }
                throw classNotFoundException;
            }
            throw classNotFoundException;
        }
        this.extClass = clazz;
        this.extClassName = string2;
        this.intClass = pcc2;
    }

    DefaultClass(Class clazz) {
        this.extClass = clazz;
        this.extClassName = clazz.getName();
        this.intClass = null;
    }

    DefaultClass(Pcc pcc, int n2) {
        this.extClass = null;
        this.extClassName = null;
        this.intClass = pcc;
        if (this.intClass == null) {
            throw new NullPointerException();
        }
        this.dimensions = n2;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    @Override
    public String getName(boolean bl) {
        if (this.intClass != null) {
            if (this.dimensions > 0) {
                String string = "";
                for (int i2 = 0; i2 < this.dimensions; ++i2) {
                    string = string + "[";
                }
                return string + "L" + this.intClass.getFullClassName() + ";";
            }
            return this.intClass.getFullClassName();
        }
        if (bl) {
            String string = (String)autoboxingClassNames.get(this.extClassName);
            return string != null ? string : this.extClassName;
        }
        return this.extClassName;
    }

    @Override
    public MyMethod[] getConstructors() {
        if (this.ctors == null) {
            this.ctors = this.retrieveConstructors();
        }
        return this.ctors;
    }

    @Override
    public MyMethod[] retrieveConstructors() {
        MyMethod[] myMethodArray;
        if (this.extClass != null) {
            String string = this.extClass.getName();
            if (this.isArray()) {
                String string2 = this.extClassName;
                int n2 = 0;
                while (string2.charAt(n2) == '[') {
                    ++n2;
                }
                myMethodArray = new MyMethod[n2];
                while (n2 > 0) {
                    MyClass[] myClassArray = new MyClass[n2];
                    for (int i2 = n2 - 1; i2 >= 0; --i2) {
                        myClassArray[i2] = MyClass.getInstance(Integer.TYPE);
                    }
                    myMethodArray[n2 - 1] = new MyMethod(string, false, "new", this, myClassArray, 9, null);
                    --n2;
                }
            } else {
                Constructor<?>[] constructorArray = this.extClass.getConstructors();
                myMethodArray = new MyMethod[constructorArray.length];
                for (int i3 = 0; i3 < constructorArray.length; ++i3) {
                    myMethodArray[i3] = new MyMethod(constructorArray[i3]);
                }
            }
        } else {
            String string = this.intClass.getFullClassName();
            if (this.isArray()) {
                myMethodArray = new MyMethod[this.dimensions];
                for (int i4 = this.dimensions; i4 > 0; --i4) {
                    MyClass[] myClassArray = new MyClass[i4];
                    for (int i5 = i4 - 1; i5 >= 0; --i5) {
                        myClassArray[i5] = MyClass.getInstance(Integer.TYPE);
                    }
                    myMethodArray[i4 - 1] = new MyMethod(string, false, "new", this, myClassArray, 9, null);
                }
            } else {
                MyMethod[] myMethodArray2 = this.getMethods(true);
                ArrayList<MyMethod> arrayList = new ArrayList<MyMethod>();
                for (int i6 = 0; i6 < myMethodArray2.length; ++i6) {
                    if (!myMethodArray2[i6].getName().equals("new")) continue;
                    arrayList.add(myMethodArray2[i6]);
                }
                if (arrayList.isEmpty()) {
                    arrayList.add(new MyMethod(string, false, "new", this, new MyClass[0], 9, null));
                }
                myMethodArray = arrayList.toArray(new MyMethod[arrayList.size()]);
            }
        }
        return myMethodArray;
    }

    @Override
    public MyClass[] getInterfaces() {
        ArrayList<MyClass> arrayList;
        block6: {
            block5: {
                arrayList = new ArrayList<MyClass>();
                if (this.extClass == null) break block5;
                Class<?>[] classArray = this.extClass.getInterfaces();
                if (classArray == null) break block6;
                for (Class<?> clazz : classArray) {
                    arrayList.add(MyClass.getInstance(clazz));
                }
                break block6;
            }
            String[] stringArray = this.intClass.getImplementsClass();
            if (stringArray != null) {
                for (String string : stringArray) {
                    try {
                        arrayList.add(MyClass.getInstance(string, this.intClass, 0));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return arrayList.toArray(new MyClass[arrayList.size()]);
    }

    @Override
    public MyClass getSuperclass() {
        MyClass myClass;
        if (this.extClass != null) {
            Class clazz = this.extClass.getSuperclass();
            myClass = clazz != null ? MyClass.getInstance(clazz) : null;
        } else {
            String string = this.intClass.getInheritsClass();
            if (string != null) {
                try {
                    myClass = MyClass.getInstance(string, this.intClass, 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    myClass = MyClass.getInstance(Object.class);
                }
            } else {
                myClass = MyClass.getInstance(Object.class);
            }
        }
        return myClass;
    }

    @Override
    public MyMethod[] getMethods(boolean bl) {
        if (bl) {
            if (this.methodsProt == null) {
                this.methodsProt = this.retrieveMethods(bl);
            }
            return this.methodsProt;
        }
        if (this.methods == null) {
            this.methods = this.retrieveMethods(bl);
        }
        return this.methods;
    }

    private static void add(MyMethod myMethod, TreeSet<MyMethod> treeSet) {
        treeSet.remove(myMethod);
        treeSet.add(myMethod);
    }

    private MyMethod[] retrieveMethods(boolean bl) {
        MyMethod[] myMethodArray;
        if (this.extClass != null) {
            Method[] methodArray = DefaultClass.getAllMethods(this.extClass, bl);
            myMethodArray = new MyMethod[methodArray.length];
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                myMethodArray[i2] = new MyMethod(methodArray[i2]);
            }
        } else {
            Object object32;
            Object[] objectArray;
            TreeSet<MyMethod> treeSet = new TreeSet<MyMethod>();
            MyClass myClass = this.getSuperclass();
            if (myClass != null) {
                objectArray = myClass.getMethods(bl);
                int n2 = objectArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    Object object2 = objectArray[i3];
                    DefaultClass.add((MyMethod)object2, treeSet);
                }
            }
            if ((objectArray = this.getInterfaces()) != null) {
                for (Object object32 : objectArray) {
                    for (MyMethod myMethod : ((MyClass)object32).getMethods(bl)) {
                        if (!myMethod.isDefault()) continue;
                        DefaultClass.add(myMethod, treeSet);
                    }
                }
            }
            CobolMethod[] cobolMethodArray = this.intClass.getMethods();
            MyMethod[] myMethodArray2 = this.intClass.getMyMethods();
            object32 = this.intClass.getFullClassName();
            boolean bl2 = this.intClass.isInterface();
            for (CobolMethod object4 : cobolMethodArray) {
                MyMethod myMethod = new MyMethod((String)object32, bl2, object4.getMethodName(), object4.getReturnType(), object4.getParameterTypes(), object4.getModifiers(), object4.procedure.raising, object4.isDefault(), object4.isVarArgs());
                DefaultClass.add(myMethod, treeSet);
            }
            DefaultClass.add(new MyMethod("java.lang.Object", false, "finalize", MyClass.getInstance(Void.TYPE), new MyClass[0], 1, new VariableNameList(), false, false), treeSet);
            for (MyMethod myMethod : myMethodArray2) {
                DefaultClass.add(myMethod, treeSet);
            }
            myMethodArray = treeSet.toArray(new MyMethod[treeSet.size()]);
        }
        return myMethodArray;
    }

    private static Field[] getAllFields(Class clazz, boolean bl) {
        Field[] fieldArray;
        TreeSet<Field> treeSet = new TreeSet<Field>(new Comparator<Field>(){

            @Override
            public int compare(Field field, Field field2) {
                return field.getName().compareTo(field2.getName());
            }
        });
        do {
            fieldArray = clazz.getDeclaredFields();
            if (bl) {
                for (Field field : fieldArray) {
                    if ((treeSet.contains(field) || !Modifier.isPublic(field.getModifiers())) && !Modifier.isProtected(field.getModifiers())) continue;
                    treeSet.add(field);
                }
            } else {
                for (Field field : fieldArray) {
                    if (treeSet.contains(field) || !Modifier.isPublic(field.getModifiers())) continue;
                    treeSet.add(field);
                }
            }
            for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
                for (Field field : fieldArray = ((Class)annotatedElement).getFields()) {
                    if (treeSet.contains(field)) continue;
                    treeSet.add(field);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        fieldArray = treeSet.toArray(new Field[treeSet.size()]);
        return fieldArray;
    }

    private static void fillMethodWProt(Method[] methodArray, TreeSet<Method> treeSet) {
        for (Method method : methodArray) {
            if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers()) || treeSet.contains(method)) continue;
            treeSet.add(method);
        }
    }

    private static Method[] getAllMethods(Class clazz, boolean bl) {
        TreeSet<Method> treeSet = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                Class<?>[] classArray;
                Class<?>[] classArray2;
                int n2 = method.getName().compareTo(method2.getName());
                if (n2 == 0 && (n2 = (classArray2 = method.getParameterTypes()).length - (classArray = method2.getParameterTypes()).length) == 0) {
                    for (int i2 = 0; i2 < classArray2.length && n2 == 0; ++i2) {
                        n2 = classArray2[i2].getName().compareTo(classArray[i2].getName());
                    }
                }
                return n2;
            }
        });
        if (bl) {
            do {
                DefaultClass.fillMethodWProt(clazz.getDeclaredMethods(), treeSet);
            } while ((clazz = clazz.getSuperclass()) != null);
        } else {
            for (Method method : clazz.getMethods()) {
                try {
                    Method method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
                    if (treeSet.contains(method2)) continue;
                    treeSet.add(method2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return treeSet.toArray(new Method[treeSet.size()]);
    }

    @Override
    public MyField[] getFields(boolean bl) {
        if (bl) {
            if (this.fieldsProt == null) {
                this.fieldsProt = this.retrieveFields(bl);
            }
            return this.fieldsProt;
        }
        if (this.fields == null) {
            this.fields = this.retrieveFields(bl);
        }
        return this.fields;
    }

    private MyField[] retrieveFields(boolean bl) {
        MyField[] myFieldArray;
        if (this.extClass != null) {
            Field[] fieldArray = DefaultClass.getAllFields(this.extClass, bl);
            myFieldArray = new MyField[fieldArray.length];
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                myFieldArray[i2] = new MyField(fieldArray[i2]);
            }
        } else {
            MyClass myClass = this.getSuperclass();
            if (myClass == null) {
                myClass = MyClass.getInstance(Object.class);
            }
            MyField[] myFieldArray2 = myClass.getFields(bl);
            MyField[] myFieldArray3 = this.intClass.getMyFields();
            myFieldArray = new MyField[myFieldArray2.length + myFieldArray3.length];
            System.arraycopy(myFieldArray2, 0, myFieldArray, 0, myFieldArray2.length);
            System.arraycopy(myFieldArray3, 0, myFieldArray, myFieldArray2.length, myFieldArray3.length);
        }
        return myFieldArray;
    }

    @Override
    public MyField getField(String string, boolean bl) throws NoSuchFieldException {
        MyField[] myFieldArray = this.getFields(bl);
        for (int i2 = 0; i2 < myFieldArray.length; ++i2) {
            if (!myFieldArray[i2].getName().equals(string)) continue;
            return myFieldArray[i2];
        }
        throw new NoSuchFieldException(string);
    }

    @Override
    public boolean isString() {
        return this.extClass != null ? this.isString(this.extClass) : false;
    }

    @Override
    public boolean isBoolean() {
        return this.extClass != null ? this.isBoolean(this.extClass) : false;
    }

    @Override
    public boolean isFunctionalInterface() {
        return this.getFunctionalMethod() != null;
    }

    @Override
    public boolean isAbstract() {
        return this.extClass != null ? Modifier.isAbstract(this.extClass.getModifiers()) : false;
    }

    @Override
    public MyMethod getFunctionalMethod() {
        if (this.funcMethod == null) {
            MyMethod myMethod = null;
            if (this.isInterface()) {
                MyMethod[] myMethodArray;
                for (MyMethod myMethod2 : myMethodArray = this.getMethods(false)) {
                    if (!myMethod2.interfaceMethod || myMethod2.isStatic() || myMethod2.isDefault()) continue;
                    if (myMethod != null) {
                        myMethod = null;
                        break;
                    }
                    myMethod = myMethod2;
                }
            }
            this.funcMethod = new MyMethod[]{myMethod};
        }
        return this.funcMethod[0];
    }

    @Override
    public boolean isPrimitiveOrString() {
        if (this.isClass(String.class)) {
            return true;
        }
        return this.isPrimitive();
    }

    @Override
    public MyClass getWrappedType() {
        if (this.extClass == null) {
            return null;
        }
        if (this.extClass == Byte.class) {
            return MyClass.getInstance(Byte.TYPE);
        }
        if (this.extClass == Short.class) {
            return MyClass.getInstance(Short.TYPE);
        }
        if (this.extClass == Integer.class) {
            return MyClass.getInstance(Integer.TYPE);
        }
        if (this.extClass == Long.class) {
            return MyClass.getInstance(Long.TYPE);
        }
        if (this.extClass == Float.class) {
            return MyClass.getInstance(Float.TYPE);
        }
        if (this.extClass == Double.class) {
            return MyClass.getInstance(Double.TYPE);
        }
        if (this.extClass == Character.class) {
            return MyClass.getInstance(Character.TYPE);
        }
        if (this.extClass == Boolean.class) {
            return MyClass.getInstance(Boolean.TYPE);
        }
        return null;
    }

    @Override
    public boolean isStrictPrimitive() {
        if (this.extClass != null) {
            return this.extClass.isPrimitive();
        }
        return false;
    }

    @Override
    public boolean isPrimitiveWrapper() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveWrapper(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitiveNumericWrapper() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveNumericWrapper(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitiveInteger() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveInteger(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitive(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Class clazz) {
        return this.isAssignableFrom(clazz, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAssignableFrom(Class clazz, boolean bl) {
        void var5_6;
        if (clazz == null) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        if (this.extClass != null) {
            if (this.extClass.isAssignableFrom(clazz)) {
                return true;
            }
            if (DefaultClass.isPrimitive(this.extClass) && DefaultClass.isPrimitive(clazz)) {
                return DefaultClass.isPrimitiveAssignableFrom(this.extClass, clazz);
            }
            if (!bl && this.isPrimitiveOrString(clazz) && this.isCobolVar()) {
                return true;
            }
            return this.isPrimitiveOrString() && DefaultClass.isCobolVar(clazz);
        }
        String string = this.intClass.getFullClassName();
        int n2 = this.dimensions;
        if (n2 > 0) {
            while (n2 > 0 && clazz.isArray()) {
                clazz = clazz.getComponentType();
                --n2;
            }
            return n2 == 0 && !clazz.isArray() && string.equals(clazz.getName());
        }
        if (string.equals(clazz.getName())) {
            return true;
        }
        Class<?> object = clazz.getSuperclass();
        while (var5_6 != null) {
            if (string.equals(var5_6.getName())) {
                return true;
            }
            Class clazz2 = var5_6.getSuperclass();
        }
        if (this.intClass.isInterface()) {
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                if (!string.equals(clazz3.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(MyClass myClass) {
        return this.isAssignableFrom(myClass, true);
    }

    @Override
    public boolean isAssignableFrom(MyClass myClass, boolean bl) {
        if (myClass == null) {
            return true;
        }
        if (myClass instanceof DefaultClass) {
            DefaultClass defaultClass = (DefaultClass)myClass;
            if (defaultClass.extClass != null) {
                return this.isAssignableFrom(defaultClass.extClass, bl);
            }
            if (defaultClass.getName().equals(this.getName())) {
                return true;
            }
            String[] stringArray = defaultClass.intClass.getImplementsClass();
            if (stringArray != null) {
                for (String string : stringArray) {
                    try {
                        MyClass myClass2 = defaultClass.intClass.existsClass(string);
                        if (this.isAssignableFrom(myClass2, bl)) {
                            return true;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            return this.isAssignableFrom(defaultClass.getSuperclass(), bl);
        }
        return ((LambdaExpression)myClass).isAssignableTo(this);
    }

    @Override
    public boolean isNumericVar() {
        return this.extClass != null && DefaultClass.isNumericVar(this.extClass);
    }

    @Override
    public boolean isCobolVar() {
        return this.extClass != null && DefaultClass.isCobolVar(this.extClass);
    }

    @Override
    public boolean isNumericEditedVar() {
        return this.extClass != null && DefaultClass.isNumericEditedVar(this.extClass);
    }

    @Override
    public boolean isAssignableTo(MyClass myClass, boolean bl) {
        return myClass.isAssignableFrom(this, bl);
    }

    @Override
    public boolean isAssignableTo(MyClass myClass) {
        return myClass.isAssignableFrom(this, true);
    }

    @Override
    public boolean isAssignableTo(Class clazz) {
        if (this.extClass != null) {
            return DefaultClass.isAssignableFrom(clazz, this.extClass);
        }
        return this.getSuperclass().isAssignableTo(clazz);
    }

    @Override
    public boolean isClass(Class clazz) {
        return this.extClass != null && this.extClass.equals(clazz);
    }

    @Override
    public boolean isArray() {
        if (this.extClass != null) {
            return this.extClass.isArray();
        }
        return this.dimensions > 0;
    }

    @Override
    public MyClass getComponentType() {
        if (this.extClass != null) {
            return MyClass.getInstance(this.extClass.getComponentType());
        }
        return MyClass.getInstance(this.intClass, 0);
    }

    @Override
    public int getDimensions() {
        if (this.extClass != null) {
            if (this.extClass.isArray()) {
                int n2;
                String string = this.extClass.getName();
                int n3 = string.length();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (string.charAt(n2) == '[') continue;
                    return n2;
                }
                return n2;
            }
            return 0;
        }
        return this.dimensions;
    }

    public String toString() {
        return "MyClass::" + this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof Class) {
            if (this.extClass != null) {
                return this.extClass.equals((Class)object);
            }
            return false;
        }
        if (object instanceof DefaultClass) {
            if (this.extClass != null) {
                if (((DefaultClass)object).extClass != null) {
                    return this.extClass.equals(((DefaultClass)object).extClass);
                }
                return false;
            }
            return ((DefaultClass)object).extClass == null;
        }
        return object.equals(this);
    }

    @Override
    public String getPackageName() {
        if (this.intClass != null) {
            return this.intClass.getPackageName();
        }
        Package package_ = this.extClass.getPackage();
        if (package_ != null) {
            return package_.getName();
        }
        return "";
    }

    @Override
    public boolean isPublic() {
        if (this.extClass != null) {
            return Modifier.isPublic(this.extClass.getModifiers());
        }
        return true;
    }

    @Override
    public boolean isClassAccessible(MyClass myClass) {
        if (this.getPackageName().equals(myClass.getPackageName())) {
            return true;
        }
        return myClass.isPublic();
    }

    @Override
    public boolean isInterface() {
        if (this.intClass != null) {
            return this.intClass.isInterface();
        }
        return this.extClass.isInterface();
    }

    @Override
    public boolean isEnclosedClass() {
        if (this.extClass != null) {
            return this.extClass.getEnclosingClass() != null;
        }
        return false;
    }
}

