/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Delete
extends Verb
implements CobolToken,
ErrorsNumbers {
    private InvalidKey invKey;
    private boolean file;
    private SelectList sell = new SelectList();
    private final Select sel;
    private VariableName keyName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Delete(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 482) {
            this.file = true;
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(token2.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (!this.file && !this.sel.allowsDelete()) {
            throw new GeneralErrorException(142, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.sell.addItem(this.sel);
        if (!this.file) {
            if (this.sel.isXml()) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 670) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 551) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 545) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                    this.tm.ungetToken();
                    this.keyName = VariableName.get(this.tm, this.error, this.pc);
                    return;
                } else {
                    this.tm.ungetToken();
                }
                return;
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 670) {
                this.tm.ungetToken();
            }
            this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            token2 = this.tm.getToken();
            if (token2.getToknum() != 428) {
                this.tm.ungetToken();
                return;
            } else {
                this.endStmt = true;
            }
            return;
        } else {
            while ((token2 = this.tm.getToken()).getToknum() == 10009) {
                Select select = this.pc.getSelect(token2.getWord());
                if (select == null) {
                    throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
                }
                if (select.isSort()) {
                    throw new GeneralErrorException(103, 4, this.keyWord, token2.getWord(), this.error);
                }
                this.sell.addItem(select);
            }
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        if (this.file) {
            stringBuffer.append("try {");
            Select select = this.sell.getFirst();
            while (select != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(select.getName());
                stringBuffer.append(".deleteFile(");
                stringBuffer.append(select.getPathCode());
                stringBuffer.append(");");
                Use.putFileStatus(stringBuffer, select, this.parent.getIndent());
                stringBuffer.append(eol);
                select = this.sell.getNext();
            }
            Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
            Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), false);
        } else {
            boolean bl;
            stringBuffer.append(this.parent.getIndent());
            Select select = this.sell.getFirst();
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            boolean bl2 = bl = this.pc.getDeclarative(select) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
            if (select.isXml()) {
                stringBuffer.append(select.getName());
                stringBuffer.append(".deleteXml(");
                if (this.keyName != null) {
                    stringBuffer.append(this.keyName.getCode());
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(");");
                Use.putFileStatus(stringBuffer, select, this.parent.getIndent());
            } else {
                stringBuffer.append(this.invKey.getCodeBefore());
                stringBuffer.append(select.getName());
                stringBuffer.append(".delete();");
                Use.putFileStatus(stringBuffer, select, this.parent.getIndent());
                stringBuffer.append(this.invKey.getCode());
                stringBuffer.append(eol);
            }
            Use.putDeclaratives(stringBuffer, this.pc, select, this.parent.getIndent(), bl);
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isFileDeletion() {
        return this.file;
    }

    public SelectList getSelectList() {
        return this.sell;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }
}

