/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Divide
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private Token num;
    private VariableName var;
    private Token numDivisor;
    private VariableNameList varDivisorList;
    private Token numDividend;
    private VariableNameList varDividendList;
    private VariableNameList givingList = new VariableNameList();
    private VariableName remainder;
    private OnSizeError ose;
    private boolean giving;
    private boolean into;
    private boolean by;
    private final boolean cfp36 = this.pc.getOption("-cfp36") != null;

    /*
     * Unable to fully structure code
     */
    public Divide(Token var1_1, Block var2_2, Pcc var3_3, TokenManager var4_4, Errors var5_5) throws GeneralErrorException, EndOfProgramException {
        super(var1_1, var2_2, var3_3, var4_4, var5_5);
        var6_6 = this.tm.getToken();
        switch (var6_6.getToknum()) {
            case 10001: {
                if (var6_6.isNull()) {
                    var6_6.setZero();
                } else {
                    throw new UnexpectedTokenException(var6_6, this.error);
                }
            }
            case 10002: 
            case 10017: {
                this.num = var6_6;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.var = VariableName.getAny(this.tm, this.error, this.pc);
                if (this.var != null && this.var.isNumeric() && !this.var.isEdited()) break;
                throw new GeneralErrorException(109, 4, this.var.getNameToken(), this.var.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException(var6_6, this.error);
            }
        }
        var7_7 = false;
        var6_6 = this.tm.getToken();
        switch (var6_6.getToknum()) {
            case 312: {
                var7_7 = true;
                var6_6 = this.tm.getToken();
            }
            case 10001: {
                if (!var6_6.isNull()) ** GOTO lbl31
                var6_6.setZero();
                ** GOTO lbl33
lbl31:
                // 1 sources

                if (var6_6.getToknum() == 10001) {
                    throw new ExpectedFoundException(var6_6, this.error, "'INTO | BY'");
                }
            }
lbl33:
            // 4 sources

            case 10002: 
            case 10009: 
            case 10017: {
                this.by = true;
                break;
            }
            case 542: {
                var6_6 = this.tm.getToken();
                this.into = true;
                break;
            }
            default: {
                throw new ExpectedFoundException(var6_6, this.error, "'INTO | BY'");
            }
        }
        var8_8 = null;
        var9_9 = null;
        var10_10 = new VariableNameList();
        block16: while (true) {
            switch (var6_6.getToknum()) {
                case 702: {
                    if (var8_8 != null) {
                        var8_8.rounded = true;
                        break;
                    }
                    throw new UnexpectedTokenException(var6_6, this.error);
                }
                case 10002: 
                case 10017: {
                    if (var9_9 != null) {
                        throw new UnexpectedTokenException(var6_6, this.error);
                    }
                    var9_9 = var6_6;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    var8_8 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                    if (var8_8 != null && var8_8.isNumeric() && !var8_8.isEdited()) {
                        var10_10.addItem(var8_8);
                        break;
                    }
                    throw new GeneralErrorException(109, 4, var8_8.getNameToken(), var8_8.getName(), this.error);
                }
                default: {
                    break block16;
                }
            }
            var6_6 = this.tm.getToken();
        }
        if (var6_6.getToknum() == 505) {
            this.giving = true;
            var6_6 = this.tm.getToken();
            if (var6_6.getToknum() == 10009) {
                while (var6_6.getToknum() == 10009) {
                    this.tm.ungetToken();
                    var8_8 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (var8_8 != null && var8_8.isNumeric()) {
                        this.givingList.addItem(var8_8);
                        var6_6 = this.tm.getToken();
                        if (var6_6.getToknum() != 702) continue;
                        var8_8.rounded = true;
                        var6_6 = this.tm.getToken();
                        continue;
                    }
                    throw new GeneralErrorException(109, 4, var8_8.getNameToken(), var8_8.getName(), this.error);
                }
                if (var10_10.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, var6_6, var6_6.getWord(), this.error);
            }
            if (var6_6.getToknum() == 679) {
                this.remainder();
            } else if (!var7_7 && this.by) {
                throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
            }
            if (var10_10.getItemNum() > 0) {
                var10_10.getFirst().setPropTypeGet();
            }
        } else {
            if (var9_9 != null) {
                throw new GeneralErrorException(17, 4, var9_9, var9_9.getWord(), this.error);
            }
            if (this.by) {
                throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
            }
            var11_11 = var10_10.getFirst();
            while (var11_11 != null) {
                var11_11.checkPropTypeSetGet();
                var11_11 = var10_10.getNext();
            }
            if (var6_6.getToknum() == 679) {
                this.error.print(302, 3, var6_6, null);
                this.remainder();
            }
        }
        if (!this.giving && var8_8 == null || var10_10.getItemNum() == 0 && var9_9 == null) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        if (this.by) {
            this.numDivisor = var9_9;
            this.varDivisorList = var10_10;
            this.numDividend = this.num;
            this.varDividendList = new VariableNameList();
            this.varDividendList.addItem(this.var);
        } else {
            this.numDividend = var9_9;
            this.varDividendList = var10_10;
            this.numDivisor = this.num;
            this.varDivisorList = new VariableNameList();
            this.varDivisorList.addItem(this.var);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(var1_1, var2_2, this, var3_3, var4_4, var5_5);
        var6_6 = this.tm.getToken();
        if (var6_6.getToknum() != 430) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
        if (this.pc.getOption("-wdbz") != null && this.ose.sizeErrorBlock == null && (var11_11 = this.varDivisorList.getFirst()) != null) {
            this.error.print(220, 2, var11_11.name, var11_11.name.getWord());
        }
    }

    private void remainder() throws GeneralErrorException, EndOfProgramException {
        if (this.givingList.getItemNum() > 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        Token token = this.tm.getToken();
        if (token.getToknum() == 10009) {
            this.tm.ungetToken();
            this.remainder = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            if (this.remainder == null || !this.remainder.isNumeric()) {
                throw new GeneralErrorException(109, 4, this.remainder.getNameToken(), this.remainder.getName(), this.error);
            }
        } else {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.tm.getToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    String getDivideEvaluation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (this.giving) {
                if (this.numDividend != null) {
                    stringBuffer.append(Expression.toNum(this.numDividend));
                } else {
                    stringBuffer.append(this.varDividendList.getFirst().getCode());
                }
                stringBuffer.append(" / ");
                if (this.numDivisor != null) {
                    stringBuffer.append(Expression.toNum(this.numDivisor));
                } else {
                    stringBuffer.append(this.varDivisorList.getFirst().getCode());
                }
            } else if (this.var != null) {
                stringBuffer.append(this.var.getCode());
            } else {
                stringBuffer.append(Expression.toNum(this.num));
            }
        } else if (this.giving) {
            if (this.numDividend != null) {
                stringBuffer.append(this.getCodeLiteral(this.numDividend)).append(".num()");
            } else {
                stringBuffer.append(Compute.getCobolNumCode(this.varDividendList.getFirst()));
            }
            if (this.cfp36) {
                stringBuffer.append(".divide36(");
            } else {
                stringBuffer.append(".divide(");
            }
            stringBuffer.append(this.ose.sizeErrorBlock == null);
            stringBuffer.append(",");
            if (this.numDivisor != null) {
                stringBuffer.append(this.getCodeLiteral(this.numDivisor)).append(".num()");
            } else {
                stringBuffer.append(Compute.getCobolNumCode(this.varDivisorList.getFirst()));
            }
            stringBuffer.append(")");
        } else if (this.num != null) {
            stringBuffer.append(this.getCodeLiteral(this.num)).append(".num()");
        } else {
            stringBuffer.append(Compute.getCobolNumCode(this.var));
        }
        return stringBuffer.toString();
    }

    String getRemainderEvaluation(VariableName variableName, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            String string = this.numDividend != null ? Expression.toNum(this.numDividend) : this.varDividendList.getFirst().getCode();
            stringBuffer.append(string);
            stringBuffer.append(" - ((");
            stringBuffer.append(string);
            stringBuffer.append(" / ");
            String string2 = this.numDivisor != null ? Expression.toNum(this.numDivisor) : this.varDivisorList.getFirst().getCode();
            stringBuffer.append(string2);
            stringBuffer.append(") * ");
            stringBuffer.append(string2);
            stringBuffer.append(")");
        } else {
            if (this.numDividend != null) {
                stringBuffer.append(this.getCodeLiteral(this.numDividend)).append(".num()");
            } else {
                stringBuffer.append(Compute.getCobolNumCode(this.varDividendList.getFirst()));
            }
            stringBuffer.append(".remainder(");
            stringBuffer.append(this.ose.sizeErrorBlock == null);
            stringBuffer.append(",");
            if (this.numDivisor != null) {
                stringBuffer.append(this.getCodeLiteral(this.numDivisor)).append(".num()");
            } else {
                stringBuffer.append(Compute.getCobolNumCode(this.varDivisorList.getFirst()));
            }
            stringBuffer.append(",");
            if (variableName.isNumericVar()) {
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".scale()");
            } else if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                stringBuffer.append("0");
            } else {
                stringBuffer.append("-1");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration variableDeclaration;
        if (this.into && !this.ose.hasBlocks() && this.givingList.getItemNum() == 0 && this.remainder == null && (this.num != null && this.num.getToknum() == 10002 || this.var != null && (variableDeclaration = this.var.getVarDecl()).isInteger() && variableDeclaration.getLogicLen() <= 18)) {
            VariableName variableName = this.varDividendList.getFirst();
            while (variableName != null) {
                if (variableName.rounded || !(variableDeclaration = variableName.getVarDecl()).isInteger() || variableDeclaration.getLogicLen() > 18) {
                    return false;
                }
                variableName = this.varDividendList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCode() {
        int n2;
        VariableName variableName;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isOptimizable()) {
            this.getCodeDebug(stringBuffer);
            VariableName variableName2 = this.varDividendList.getFirst();
            while (variableName2 != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(variableName2.getCode());
                stringBuffer.append(".divideIntoMe(");
                stringBuffer.append(this.ose.sizeErrorBlock == null);
                stringBuffer.append(",");
                if (this.num != null) {
                    stringBuffer.append(this.num.getAsLong());
                } else {
                    stringBuffer.append(this.var.getCode());
                    stringBuffer.append(".tolong()");
                }
                stringBuffer.append(");");
                stringBuffer.append(eol);
                variableName2 = this.varDividendList.getNext();
            }
            this.getCodeDebugEnd(stringBuffer);
            return stringBuffer.toString();
        }
        VariableNameList variableNameList = this.giving ? this.givingList : (this.into ? this.varDividendList : this.varDivisorList);
        boolean bl = this.var != null ? Expression.couldBeNativeInt(this.var.getVarDecl()) : false;
        if (bl && this.giving) {
            bl = this.into ? (this.numDividend != null ? (bl &= false) : (bl &= Expression.couldBeNativeInt(this.varDividendList.getFirst().getVarDecl()))) : (this.numDivisor != null ? (bl &= false) : (bl &= Expression.couldBeNativeInt(this.varDivisorList.getFirst().getVarDecl())));
        }
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        String string = "";
        if (variableNameList.getItemNum() > 1 || this.remainder != null) {
            string = "div$" + Divide.getUniqueId();
            if (bl) {
                stringBuffer.append("long ");
            } else {
                stringBuffer.append("CobolNum ");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            if (this.remainder != null) {
                stringBuffer.append(this.getRemainderEvaluation(variableNameList.getFirst(), bl));
            } else {
                stringBuffer.append(this.getDivideEvaluation(bl));
            }
            stringBuffer.append(";");
            stringBuffer.append(eol);
        } else {
            string = this.getDivideEvaluation(bl);
        }
        stringBuffer.append(this.parent.getIndent());
        VariableNameList variableNameList2 = new VariableNameList();
        int n3 = 0;
        while (n3 < variableNameList.getItemNum()) {
            variableName = variableNameList.getAt(n3);
            if (variableName.isPrimitive()) {
                variableNameList2.addItem(variableName);
                variableNameList.deleteCurrent();
                continue;
            }
            ++n3;
        }
        n3 = variableNameList2.getItemNum();
        for (n2 = 0; n2 < n3; ++n2) {
            String string2;
            variableName = variableNameList2.getAt(n2);
            stringBuffer.append(variableName.getCode());
            String string3 = variableName.getType().getName(true);
            stringBuffer.append(" = ");
            if (this.giving) {
                if (this.remainder != null) {
                    if (bl) {
                        stringBuffer.append(Compute.addCast(string3, this.getDivideEvaluation(true)));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, this.getDivideEvaluation(false)));
                    }
                } else if (bl) {
                    stringBuffer.append(Compute.addCast(string3, string));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string3, string));
                }
            } else if (this.by) {
                if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                    if (bl) {
                        stringBuffer.append(Compute.addCast(string3, string + " / " + variableName.getCode()));
                    } else {
                        stringBuffer.append(Compute.getConversionMethod(string3, string + ".divide(CobolNum.noo((long) " + variableName.getCode() + ", 0))"));
                    }
                } else if (bl) {
                    string2 = string + " / ";
                    string2 = variableName.isNumericVar() ? string2 + variableName.getCode() + ".tolong()" : string2 + variableName.getCode();
                    stringBuffer.append(Compute.addCast(string3, string2));
                } else {
                    string2 = string + ".divide(";
                    string2 = variableName.isNumericVar() ? string2 + variableName.getCode() + ".num())" : string2 + "CobolNum.noo((double) " + variableName.getCode() + "))";
                    stringBuffer.append(Compute.getConversionMethod(string3, string2));
                }
            } else if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                if (bl) {
                    stringBuffer.append(Compute.addCast(string3, variableName.getCode() + " / " + string));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string3, "CobolNum.noo((long) " + variableName.getCode() + ", 0).divide(" + string + ")"));
                }
            } else if (bl) {
                string2 = variableName.isNumericVar() ? variableName.getCode() + ".tolong()" : variableName.getCode();
                string2 = string2 + " / " + string;
                stringBuffer.append(Compute.addCast(string3, string2));
            } else {
                string2 = variableName.isNumericVar() ? variableName.getCode() + ".num()" : "CobolNum.noo((double) " + variableName.getCode() + ")";
                string2 = string2 + ".divide(" + string + ")";
                stringBuffer.append(Compute.getConversionMethod(string3, string2));
            }
            stringBuffer.append(";");
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        n3 = variableNameList.getItemNum();
        if (n3 > 0) {
            if (variableNameList2.getItemNum() > 0) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            if (this.ose.sizeErrorBlock != null) {
                stringBuffer.append("if((");
            } else if (this.ose.notSizeErrorBlock != null) {
                stringBuffer.append("if(!(");
            }
            for (n2 = 0; n2 < n3; ++n2) {
                variableName = variableNameList.getAt(n2);
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".set(");
                if (this.giving) {
                    if (this.remainder != null) {
                        if (bl) {
                            stringBuffer.append("CobolNum.noo(");
                            stringBuffer.append(this.getDivideEvaluation(true));
                            stringBuffer.append(",0)");
                        } else {
                            stringBuffer.append(this.getDivideEvaluation(false));
                        }
                    } else if (bl) {
                        stringBuffer.append("CobolNum.noo(");
                        stringBuffer.append(string);
                        stringBuffer.append(",0)");
                    } else {
                        stringBuffer.append(string);
                    }
                } else if (this.by) {
                    if (bl) {
                        stringBuffer.append("CobolNum.noo(");
                        stringBuffer.append(string);
                        stringBuffer.append(",0)");
                    } else {
                        stringBuffer.append(string);
                    }
                    if (this.cfp36) {
                        stringBuffer.append(".divide36(");
                    } else {
                        stringBuffer.append(".divide(");
                    }
                    stringBuffer.append(this.ose.sizeErrorBlock == null);
                    stringBuffer.append(",");
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".num())");
                } else {
                    stringBuffer.append(variableName.getCode());
                    if (this.cfp36) {
                        stringBuffer.append(".num().divide36(");
                    } else {
                        stringBuffer.append(".num().divide(");
                    }
                    stringBuffer.append(this.ose.sizeErrorBlock == null);
                    stringBuffer.append(",");
                    if (bl) {
                        stringBuffer.append("CobolNum.noo(");
                        stringBuffer.append(string);
                        stringBuffer.append(",0)");
                    } else {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(")");
                }
                stringBuffer.append(",");
                stringBuffer.append(variableName.rounded);
                stringBuffer.append(",");
                stringBuffer.append(this.ose.hasBlocks());
                stringBuffer.append(")");
                if (n2 >= n3 - 1) break;
                if (this.ose.hasBlocks()) {
                    stringBuffer.append("|");
                    continue;
                }
                stringBuffer.append(";");
            }
        }
        if (this.remainder != null) {
            if (n3 > 0) {
                if (this.ose.hasBlocks()) {
                    stringBuffer.append(" || ");
                } else {
                    stringBuffer.append(";" + eol + this.parent.getIndent());
                }
            } else {
                stringBuffer.append(eol + this.parent.getIndent());
            }
            stringBuffer.append(this.remainder.getCode());
            if (this.remainder.isPrimitive()) {
                String string4 = this.remainder.getType().getName(true);
                stringBuffer.append(" = ");
                if (bl) {
                    stringBuffer.append(Compute.addCast(string4, string));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string4, string));
                }
                stringBuffer.append(";");
            } else {
                stringBuffer.append(".set(");
                stringBuffer.append(string);
                if (bl) {
                    stringBuffer.append(",0");
                }
                stringBuffer.append(",false,");
                stringBuffer.append(this.ose.hasBlocks());
                stringBuffer.append(")");
                if (this.ose.sizeErrorBlock == null && this.ose.notSizeErrorBlock == null) {
                    stringBuffer.append(";");
                }
            }
        }
        if (this.ose.hasBlocks() && (this.remainder == null || !this.remainder.isPrimitive())) {
            stringBuffer.append("))");
            if (this.ose.sizeErrorBlock != null) {
                stringBuffer.append(this.ose.sizeErrorBlock.getCode());
                if (this.ose.notSizeErrorBlock != null) {
                    stringBuffer.append(" else ");
                    stringBuffer.append(this.ose.notSizeErrorBlock.getCode());
                }
            } else if (this.ose.notSizeErrorBlock != null) {
                stringBuffer.append(this.ose.notSizeErrorBlock.getCode());
            }
        } else if (this.remainder == null && n3 > 0) {
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarDivisorList() {
        return this.varDivisorList;
    }

    public VariableNameList getVarDividendList() {
        return this.varDividendList;
    }

    public VariableNameList getVarGivingList() {
        return this.givingList;
    }

    public VariableName getRemainder() {
        return this.remainder;
    }

    public Token getNumDivisor() {
        return this.numDivisor;
    }

    public Token getNumDividend() {
        return this.numDividend;
    }
}

