/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IEntry;
import com.iscobol.rts.Config;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Entry
extends Verb
implements CobolToken,
ErrorsNumbers,
IEntry {
    private static final String entryPoint = "_entry_Point$";
    private final Token name;
    private final String methodName;
    private final String entryName;
    private Token elkToken;
    private String serviceBridgeOperation = null;
    private boolean callRequired = true;
    VariableNameList using = new VariableNameList();
    private HashSet byValueVars = new HashSet();
    private final boolean serviceBridgeActivated;
    VariableDeclaration usingVarargs;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Object object;
        int n2;
        Token token2;
        this.serviceBridgeActivated = pcc.isServiceBridgeActivated();
        TokenList tokenList = tokenManager.delExtraInfo("ELK");
        if (tokenList != null) {
            this.elkToken = tokenList.getFirst();
            if ("OPERATION".equalsIgnoreCase(tokenList.getNext().getWord())) {
                if (tokenList.getNext().getToknum() == 61) {
                    this.serviceBridgeOperation = tokenList.getNext().getWord();
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        if ((token2 = this.tm.getToken()).getToknum() != 10001) {
            throw new GeneralErrorException(97, 4, this.keyWord, token2.getWord(), this.error);
        }
        this.name = token2;
        token2 = this.tm.getToken();
        if (token2.getToknum() == 802) {
            n2 = 0;
            while ((token2 = this.tm.getToken()).getToknum() == 10009 || token2.getToknum() == 312 || token2.getToknum() == 803 || token2.getToknum() == 676) {
                if (token2.getToknum() == 312) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 803) {
                        n2 = 1;
                    } else {
                        if (token2.getToknum() != 676) throw new ExpectedFoundException(token2, this.error, "VALUE|REFERENCE");
                        n2 = 0;
                    }
                } else if (token2.getToknum() == 803) {
                    n2 = 1;
                } else if (token2.getToknum() == 676) {
                    n2 = 0;
                } else {
                    this.tm.ungetToken();
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                this.tm.ungetToken();
                object = VariableName.getAnyUsing(this.tm, this.error, this.parent, this.pc);
                if (!((VariableName)object).getVarDecl().isInLinkage()) throw new GeneralErrorException(139, 4, ((VariableName)object).getNameToken(), ((VariableName)object).getName(), this.error);
                if (((VariableName)object).getDimension() > 0) {
                    throw new GeneralErrorException(55, 4, ((VariableName)object).getNameToken(), ((VariableName)object).getName(), this.error);
                }
                this.using.addItem((VariableName)object);
                if (n2 != 0) {
                    this.byValueVars.add(object);
                }
                if (((VariableName)object).getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, token2, token2.getWord(), this.error);
            }
        }
        if (this.pc.data != null && this.pc.data.linkSec != null) {
            this.usingVarargs = this.pc.data.linkSec.checkUsingVarargs(this.using);
        }
        this.tm.ungetToken();
        if (block.nesting > 0) {
            throw new GeneralErrorException(98, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        object = this.name.getPlain().replace('-', '_');
        n2 = ((String)object).length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isJavaIdentifierPart(((String)object).charAt(i2))) continue;
            throw new GeneralErrorException(144, 4, this.keyWord, this.name.getWord(), this.error);
        }
        this.methodName = entryPoint + (String)object + "()";
        if (this.name.isHexdecimal()) {
            String string = this.name.getWord();
            this.entryName = "\"" + TokenManager.stringToHex(string.substring(1, string.length() - 1), this.name.isNational(), true) + "\"";
        } else {
            this.entryName = this.name.getLitArg().toUpperCase(Locale.US).replace('-', '_');
        }
        if (this.pc.setEntryPoint(this)) return;
        throw new GeneralErrorException(67, 4, this.keyWord, this.keyWord.getWord(), this.error);
    }

    public String getNameTokenValue() {
        if (this.name.getToknum() == 10001) {
            return this.name.getOriginalWord().substring(1, this.name.getOriginalWord().length() - 1);
        }
        return this.name.getOriginalWord();
    }

    public String getServiceBridgeValueName() {
        if (this.serviceBridgeOperation != null) {
            return this.serviceBridgeOperation;
        }
        return this.getNameTokenValue();
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object instanceof Entry && ((Entry)object).entryName.equals(this.entryName);
    }

    public int hashCode() {
        return this.entryName.hashCode();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public VariableNameList getUsing() {
        return this.using;
    }

    @Override
    public String getServiceBridgeOperation() {
        return this.serviceBridgeOperation;
    }

    @Override
    public String getServiceBridgeName() {
        if (this.serviceBridgeOperation != null) {
            return this.serviceBridgeOperation;
        }
        return this.entryName;
    }

    @Override
    public String getCode() {
        boolean bl;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if ((Config.a(".compiler.easylinkage", 0) == 1 || Config.b(".compiler.easylinkage", false) || Config.a(".compiler.easylinkage", 0) == 3 && Config.a(".compiler.easylinkage", 0) != 2) && this.pc.getDataDivision() != null) {
            this.pc.getDataDivision().getEasyLinkCode(this.pc, this.entryName.replace("\"", ""), this.using, this.byValueVars, true);
        }
        if (this.serviceBridgeActivated && this.pc.getDataDivision() != null) {
            object = this.getNameToken().getOriginalWord();
            String string = this.entryName;
            if (this.serviceBridgeOperation != null) {
                object = this.serviceBridgeOperation;
            }
            this.pc.getDataDivision().getServiceBridgeCobCode(this.pc, ((String)object).replace("\"", ""), string.replace("\"", ""), this.using, this.pc.getNumEntry(this.entryName), true);
        }
        boolean bl2 = Paragraph.getDebugSection(this.pc, (Paragraph)(object = this.parent.getParent())) != null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.pc.data != null) {
            bl3 = this.pc.data.lsSec != null;
            bl4 = this.pc.data.tlsSec != null;
        }
        boolean bl5 = bl = this.pc.getOption("-d") != null;
        if ((bl || bl3 || bl4 || bl2) && this.getDeferredMethodId() == 0) {
            stringBuffer.append(" } ");
        }
        stringBuffer.append("      return ");
        stringBuffer.append(this.methodName);
        stringBuffer.append(";");
        stringBuffer.append(eol);
        stringBuffer.append("   }");
        stringBuffer.append(eol);
        stringBuffer.append("   final ");
        if (!this.pc.getSplitFlag()) {
            stringBuffer.append("private ");
        }
        stringBuffer.append("int ");
        stringBuffer.append(this.methodName);
        stringBuffer.append(" throws GotoException {");
        if ((bl || bl3 || bl4) && this.getDeferredMethodId() == 0) {
            stringBuffer.append(" { ");
        }
        if (bl3) {
            stringBuffer.append(eol);
            stringBuffer.append("   ");
            this.pc.getLocalStorageCode(stringBuffer);
        }
        if (bl4) {
            stringBuffer.append(eol);
            stringBuffer.append("   ");
            this.pc.getThreadLocalStorageCode(stringBuffer);
        }
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public boolean isCallRequired() {
        return this.callRequired;
    }

    public void setCallRequired(boolean bl) {
        this.callRequired = bl;
    }

    public Set getByValueParameters() {
        return this.byValueVars;
    }
}

