/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.ErrorLimitReachedException;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Token;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.rts.Config;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class Errors
implements ErrorsNumbers,
IErrors,
Serializable {
    protected Vector allMessages = new Vector();
    protected HashSet msgHash = new HashSet();
    protected int info;
    protected int infoSave;
    protected int warning;
    protected int warningSave;
    protected int rErrors;
    protected int rErrorsSave;
    protected int sErrors;
    protected int sErrorsSave;
    protected boolean ignoreErrors;
    protected boolean verbose;
    protected int maxErrors;
    private String msgFormat;
    boolean ignoreInvString;
    protected static Hashtable errorDesc = new Hashtable();

    public Errors() {
    }

    public Errors(int n2) {
        this.maxErrors = n2;
    }

    public Errors(String string) {
        this.msgFormat = string != null ? string.toLowerCase() : null;
    }

    Errors(boolean bl) {
        this.ignoreErrors = bl;
    }

    @Override
    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public void setMaxErrors(int n2) {
        this.maxErrors = n2;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public void ignoreFurtherErrors() {
        this.ignoreErrors = true;
    }

    @Override
    public void print(int n2, int n3, IToken iToken, String string) {
        this.print(n2, n3, iToken.getFLN(), iToken.getOffset(), string, null, iToken.getFileName());
    }

    public void print(int n2, int n3, Token token, String string) {
        this.print(n2, n3, token.getFLN(), token.getOffset(), string, null, token.getFileName());
    }

    @Override
    public void print(int n2, int n3, int n4, int n5, String string, Exception exception, String string2) {
        String string3;
        if (this.ignoreErrors) {
            return;
        }
        if (this.ignoreInvString) {
            switch (n2) {
                case 310: 
                case 311: 
                case 312: {
                    return;
                }
            }
        }
        if (n3 != 4) {
            n3 = Config.a(".compiler.messagelevel." + n2, n3);
        }
        switch (n3) {
            case 0: {
                return;
            }
            case 1: {
                string3 = "--I: ";
                break;
            }
            case 2: {
                string3 = "--W: ";
                break;
            }
            case 3: {
                string3 = "--E: ";
                break;
            }
            case 4: {
                string3 = "--S: ";
                break;
            }
            default: {
                string3 = "--?: ";
            }
        }
        string3 = string3 + "#" + n2 + " ";
        string3 = string3 + (String)errorDesc.get(n2);
        if (string != null) {
            string3 = string3 + " " + string;
        }
        if (string2 != null) {
            string3 = string3 + "; file = " + string2;
        }
        if ("vs".equals(this.msgFormat)) {
            string3 = string3 + ":" + n4;
            string3 = string3 + ":" + n5;
        } else {
            if (n4 > 0) {
                string3 = string3 + ", line = " + n4;
            }
            if (n5 > 0) {
                string3 = string3 + ", col " + n5;
            }
            if (exception != null) {
                string3 = string3 + "( " + exception + ")";
            }
        }
        if (this.msgHash.add(string3)) {
            this.addMessage(n2, n3, n4, n5, string3, string, string2);
            switch (n3) {
                case 1: {
                    ++this.info;
                    break;
                }
                case 2: {
                    ++this.warning;
                    break;
                }
                case 3: {
                    ++this.rErrors;
                    break;
                }
                case 4: {
                    ++this.sErrors;
                    break;
                }
            }
        }
        if (this.maxErrors > 0 && this.sErrors >= this.maxErrors) {
            this.printEndMessage();
            throw new ErrorLimitReachedException();
        }
    }

    protected void addMessage(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
        System.err.println(string);
        this.allMessages.addElement(string);
    }

    @Override
    public void printTask(int n2, int n3, int n4, String string, String string2) {
        String string3 = "--Task: " + string;
        string3 = string3 + "; file = " + string2;
        if ("vs".equals(this.msgFormat)) {
            string3 = string3 + ":" + n3;
            string3 = string3 + ":" + n4;
        } else {
            if (n3 > 0) {
                string3 = string3 + ", line = " + n3;
            }
            if (n4 > 0) {
                string3 = string3 + ", col " + n4;
            }
        }
        System.err.println(string3);
        this.allMessages.addElement(string3);
    }

    @Override
    public int getErrorCount(int n2) {
        switch (n2) {
            case 1: {
                return this.info;
            }
            case 2: {
                return this.warning;
            }
            case 3: {
                return this.rErrors;
            }
            case 4: {
                return this.sErrors;
            }
        }
        return 0;
    }

    public int getUnitErrorCount(int n2) {
        switch (n2) {
            case 1: {
                return this.info - this.infoSave;
            }
            case 2: {
                return this.warning - this.warningSave;
            }
            case 3: {
                return this.rErrors - this.rErrorsSave;
            }
            case 4: {
                return this.sErrors - this.sErrorsSave;
            }
        }
        return 0;
    }

    @Override
    public boolean printEndMessage() {
        String string;
        if (this.verbose || this.info - this.infoSave + this.warning - this.warningSave + this.rErrors - this.rErrorsSave + this.sErrors - this.sErrorsSave > 0) {
            string = (String)errorDesc.get(100000);
            System.err.println(string);
            this.allMessages.addElement(string);
        }
        int n2 = this.info - this.infoSave;
        if (this.verbose || n2 > 0) {
            string = (String)errorDesc.get(100001) + " - " + n2;
            System.err.println(string);
            this.allMessages.addElement(string);
        }
        n2 = this.warning - this.warningSave;
        if (this.verbose || n2 > 0) {
            string = (String)errorDesc.get(100002) + " - " + n2;
            System.err.println(string);
            this.allMessages.addElement(string);
        }
        n2 = this.rErrors - this.rErrorsSave;
        if (this.verbose || n2 > 0) {
            string = (String)errorDesc.get(100003) + " - " + n2;
            System.err.println(string);
            this.allMessages.addElement(string);
        }
        n2 = this.sErrors - this.sErrorsSave;
        if (this.verbose || n2 > 0) {
            string = (String)errorDesc.get(100004) + " - " + n2;
            System.err.println(string);
            this.allMessages.addElement(string);
        }
        return n2 > 0;
    }

    protected void saveErrors() {
        this.infoSave = this.info;
        this.warningSave = this.warning;
        this.rErrorsSave = this.rErrors;
        this.sErrorsSave = this.sErrors;
    }

    @Override
    public int getTotalErrorCount() {
        return this.info + this.warning + this.rErrors + this.sErrors;
    }

    @Override
    public Vector getAllMessages() {
        return this.allMessages;
    }

    public static String getErrorDescription(int n2) {
        return (String)errorDesc.get(n2);
    }

    static {
        errorDesc.put(0, "No errors");
        errorDesc.put(1, "Incorrect string literal");
        errorDesc.put(2, "Unknown token");
        errorDesc.put(3, "Cannot open file");
        errorDesc.put(285, "Missing resource file");
        errorDesc.put(4, "Unexpected compiler directive");
        errorDesc.put(100, "Wrong compiler directive");
        errorDesc.put(5, "Unsupported compiler directive");
        errorDesc.put(111, "Undefined constant");
        errorDesc.put(112, "User defined error:");
        errorDesc.put(6, "Incomplete copy statement");
        errorDesc.put(7, "Incomplete replace statement");
        errorDesc.put(8, "Wrong copy statement:");
        errorDesc.put(9, "Wrong replace statement");
        errorDesc.put(10, "File not found");
        errorDesc.put(11, "Syntax error");
        errorDesc.put(12, "Unexpected end of program");
        errorDesc.put(73, "Missing Procedure Division");
        errorDesc.put(13, "Missing dot");
        errorDesc.put(14, "Missing SECTION keyword");
        errorDesc.put(15, "Unexpected token");
        errorDesc.put(16, "Invalid currency sign");
        errorDesc.put(17, "Identifier expected, found ");
        errorDesc.put(18, "Missing keyword ");
        errorDesc.put(19, "Unsupported feature ");
        errorDesc.put(271, "Deprecated feature");
        errorDesc.put(20, "Malformed variable name");
        errorDesc.put(21, "String value expected found");
        errorDesc.put(22, "Integer value expected found");
        errorDesc.put(23, "Numeric value expected found");
        errorDesc.put(24, "Data name expected found");
        errorDesc.put(25, "Missing clause ");
        errorDesc.put(26, "Undefined file ");
        errorDesc.put(27, "Invalid level number");
        errorDesc.put(28, "Missing picture clause");
        errorDesc.put(29, "Invalid clause ");
        errorDesc.put(196, "Invalid host variable: ");
        errorDesc.put(30, "Invalid value:");
        errorDesc.put(31, "Expected/found token mismatch:");
        errorDesc.put(32, "Illegal picture:");
        errorDesc.put(90, "'S' ignored:");
        errorDesc.put(33, "Missing");
        errorDesc.put(34, "Picture too big");
        errorDesc.put(35, "Undefined data item");
        errorDesc.put(36, "Ambiguous identifier");
        errorDesc.put(37, "Must be a GROUP item:");
        errorDesc.put(38, "Invalid file name:");
        errorDesc.put(39, "Cannot open file:");
        errorDesc.put(40, "Cannot write file:");
        errorDesc.put(41, "Subscript required:");
        errorDesc.put(299, "Subscript required, first occurrence assumed:");
        errorDesc.put(55, "Subscript not allowed here:");
        errorDesc.put(42, "Program-Id differs from source name:");
        errorDesc.put(281, "Class-Id differs from source name:");
        errorDesc.put(282, "Interface-Id differs from source name:");
        errorDesc.put(43, "Illegal condition");
        errorDesc.put(297, "Illegal condition");
        errorDesc.put(44, "Unbalanced parenthesis");
        errorDesc.put(45, "Unmatched");
        errorDesc.put(46, "Integer variable expected:");
        errorDesc.put(256, "ANY LENGTH variable expected:");
        errorDesc.put(68, "Usage must be DISPLAY:");
        errorDesc.put(288, "Usage should be DISPLAY:");
        errorDesc.put(47, "Procedure name required");
        errorDesc.put(48, "Clause clash ");
        errorDesc.put(49, "Numeric expression expected:");
        errorDesc.put(50, "Invalid THRU clause");
        errorDesc.put(51, "Missing FD for file:");
        errorDesc.put(52, "Picture should be XX:");
        errorDesc.put(284, "Picture should be NUMERIC SIGNED:");
        errorDesc.put(53, "Missing SELECT for file:");
        errorDesc.put(54, "Invalid open mode:");
        errorDesc.put(56, "Invalid key:");
        errorDesc.put(57, "Missing relative key");
        errorDesc.put(58, "Missing primary key");
        errorDesc.put(59, "Illegal receiver from source type:");
        errorDesc.put(241, "Illegal sending item:");
        errorDesc.put(61, "Internal error");
        errorDesc.put(62, "Object wrong type for subject");
        errorDesc.put(63, "Class already specified:");
        errorDesc.put(64, "a USE phrase cannot be here");
        errorDesc.put(65, "duplicate USE phrase");
        errorDesc.put(66, "String variable expected:");
        errorDesc.put(67, "Duplicate procedure name:");
        errorDesc.put(69, "Must be size 1 in this context:");
        errorDesc.put(70, "Illegal size:");
        errorDesc.put(233, "Illegal MOVE CONVERT size:");
        errorDesc.put(234, "MOVE from alphanum to numeric:");
        errorDesc.put(259, "Source and destination of MOVE POSITIONAL DELIMITED DEFAULT must have the same structure:");
        errorDesc.put(262, "Data item without VALUE involved in MOVE POSITIONAL DELIMITED DEFAULT:");
        errorDesc.put(263, "OCCURS DYNAMIC data item without INITIALIZED involved in MOVE POSITIONAL DELIMITED DEFAULT:");
        errorDesc.put(71, "Unknown OBJECT value");
        errorDesc.put(72, "Positive integer required");
        errorDesc.put(74, "Class not found");
        errorDesc.put(75, "Type clash");
        errorDesc.put(76, "Invalid constructor");
        errorDesc.put(274, "Invalid lambda expression");
        errorDesc.put(275, "Ambiguous lambda method name:");
        errorDesc.put(77, "Method not found");
        errorDesc.put(113, "Function not found");
        errorDesc.put(78, "Exception block required");
        errorDesc.put(79, "Invalid return type");
        errorDesc.put(80, "Invalid argument(s)");
        errorDesc.put(81, "Object reference variable expected");
        errorDesc.put(82, "Invalid class name");
        errorDesc.put(83, "Invalid method name");
        errorDesc.put(84, "Cannot invoke an instance method from a factory method");
        errorDesc.put(85, "EXIT PERFORM outside of PERFORM");
        errorDesc.put(86, "Invalid Program/Class Id");
        errorDesc.put(87, "REDEFINES too long");
        errorDesc.put(88, "SUPER not allowed here");
        errorDesc.put(89, "Invoke with SUPER must be the first statement");
        errorDesc.put(91, "Duplicate statement:");
        errorDesc.put(92, "Repeated or conflicting option:");
        errorDesc.put(93, "Undeclared cursor:");
        errorDesc.put(94, "Undeclared prepare:");
        errorDesc.put(95, "Unsupported fetch:");
        errorDesc.put(96, "Handle variable expected:");
        errorDesc.put(97, "String literal expected, found ");
        errorDesc.put(98, "Statement not allowed here");
        errorDesc.put(279, "Syntax not allowed in object reference:");
        errorDesc.put(246, "Syntax not allowed in interface:");
        errorDesc.put(248, "Procedural statements not allowed in interface, use the DEFAULT clause in the METHOD-ID:");
        errorDesc.put(249, "Data items not allowed in interface:");
        errorDesc.put(99, "Record len is not equal to declared size:");
        errorDesc.put(101, "Missing record for file:");
        errorDesc.put(102, "Wrong SELECT for sort file.");
        errorDesc.put(289, "Wrong SELECT for xml file.");
        errorDesc.put(290, "SD expected for sort file.");
        errorDesc.put(291, "XD expected for xml file.");
        errorDesc.put(103, "Invalid operation on sort file");
        errorDesc.put(104, "Not a sort file");
        errorDesc.put(105, "Procedure name not found:");
        errorDesc.put(109, "Numeric variable required, found:");
        errorDesc.put(110, "Statement not allowed on pointer:");
        errorDesc.put(198, "Source literal not numeric:");
        errorDesc.put(106, "Directive ignored:");
        errorDesc.put(107, "Parameters differs from ACU's:");
        errorDesc.put(114, "VALUE in REDEFINES ignored:");
        errorDesc.put(115, "Clause not allowed here:");
        errorDesc.put(116, "Incompatible options:");
        errorDesc.put(117, "Missing linage clause");
        errorDesc.put(118, "WHEN OTHER not last");
        errorDesc.put(119, "$EFD directive required:");
        errorDesc.put(120, "$EFD directive in wrong format:");
        errorDesc.put(306, "$EFD invalid name:");
        errorDesc.put(121, "Only levels 01 & 77 allowed in this context:");
        errorDesc.put(122, "Illegal expression");
        errorDesc.put(123, "Conflicting phrases:");
        errorDesc.put(124, "Invalid resource name");
        errorDesc.put(125, "Illegal DEPENDING ON");
        errorDesc.put(261, "DEPENDING ON subsidiary to OCCURS only allowed under -cod1");
        errorDesc.put(126, "OCCURS DEPENDING must be last in group: ");
        errorDesc.put(108, "Variable not used:");
        errorDesc.put(127, "Only 2 level of OCCURS allowed.");
        errorDesc.put(128, "USAGE conflict:");
        errorDesc.put(129, "Different number of SYMBOLIC names and values");
        errorDesc.put(235, "SYMBOLIC value must be between 1 and 256");
        errorDesc.put(130, "Missing method name");
        errorDesc.put(131, "Exception already caught:");
        errorDesc.put(132, "Exception not raised:");
        errorDesc.put(133, "EXCEPTION not last");
        errorDesc.put(134, "OPEN INPUT with LOCK may not work!");
        errorDesc.put(135, "Procedure name not unique");
        errorDesc.put(136, "ESQL statement not allowed here:");
        errorDesc.put(137, "ESQL cursor already declared:");
        errorDesc.put(164, "ESQL invalid STRLITERAL:");
        errorDesc.put(197, "ESQL invalid end statement:");
        errorDesc.put(138, "Dynamic-capacity tables and standards tables cannot be mixed:");
        errorDesc.put(255, "Dynamic table expected:");
        errorDesc.put(139, "Symbol not in linkage:");
        errorDesc.put(140, "Invalid XML structure:");
        errorDesc.put(141, "Numeric literal too large:");
        errorDesc.put(142, "Operation not permitted on:");
        errorDesc.put(144, "Invalid name:");
        errorDesc.put(145, "Duplicate method signature:");
        errorDesc.put(146, "Unsupported option:");
        errorDesc.put(147, "Option(s) requires WORKING-STORAGE SECTION. on a single line");
        errorDesc.put(148, "Behavior differs from ACU's:");
        errorDesc.put(149, "'void' type not allowed here:");
        errorDesc.put(150, "Static context: expression evaluated only once!");
        errorDesc.put(151, "National with -b option may not work!");
        errorDesc.put(152, "Variable has zero length:");
        errorDesc.put(153, "File in multiple areas:");
        errorDesc.put(154, "End statement required");
        errorDesc.put(155, "Duplicate");
        errorDesc.put(156, "Missing receiver:");
        errorDesc.put(157, "Constant already defined:");
        errorDesc.put(191, "Constant already defined with different value:");
        errorDesc.put(158, "Invalid concatenation:");
        errorDesc.put(159, "Option has no effect:");
        errorDesc.put(160, "SIZE or LINES phrase required");
        errorDesc.put(161, "Attempting to override a method");
        errorDesc.put(162, "Attempting to use incompatible return type:");
        errorDesc.put(163, "Only one-dimensional table allowed here:");
        errorDesc.put(165, "Screen name not allowed in this context:");
        errorDesc.put(166, "Stack overflow:");
        errorDesc.put(143, "Native character specified twice:");
        errorDesc.put(167, "Redefines not allowed as key:");
        errorDesc.put(168, "RECORD KEY not in FD:");
        errorDesc.put(169, "LOCK not supported:");
        errorDesc.put(170, "VALUE size error");
        errorDesc.put(171, "variable record len not supported for relative file:");
        errorDesc.put(173, "Reference modifier out of range");
        errorDesc.put(174, "Incomplete statement:");
        errorDesc.put(175, "Duplicate primary key");
        errorDesc.put(176, "Duplicate attribute");
        errorDesc.put(177, "Invalid OCCURS KEY");
        errorDesc.put(178, "RECORD KEY outside smallest record:");
        errorDesc.put(180, "Variable not allowed here:");
        errorDesc.put(181, "Operand not declared:");
        errorDesc.put(182, "Not a detail group:");
        errorDesc.put(183, "Invalid line: ");
        errorDesc.put(184, "Invalid column: ");
        errorDesc.put(185, "Not a CONTROL:");
        errorDesc.put(186, "Not with CONTROL FOOTING group:");
        errorDesc.put(187, "Missing clause in RD:");
        errorDesc.put(188, "Period missing. Period Assumed.");
        errorDesc.put(189, "Wrong subscript(s):");
        errorDesc.put(190, "Undeclared database:");
        errorDesc.put(192, "Directive not closed:");
        errorDesc.put(193, "With decimal point comma, comma can not be separator between two digits:");
        errorDesc.put(194, "The ALTER statement encourages the use of unstructured programming practices.");
        errorDesc.put(195, "The ALTER statement is only supported with the -aa compiler option.");
        errorDesc.put(199, "Illegal redefines.");
        errorDesc.put(200, "Maybe a directive:");
        errorDesc.put(201, "Reference modification not allowed here:");
        errorDesc.put(202, "Data item too long:");
        errorDesc.put(203, "Malformed option:");
        errorDesc.put(204, "Too many options:");
        errorDesc.put(205, "Not allowed in a nested program:");
        errorDesc.put(206, "Not allowed in an unnamed method :");
        errorDesc.put(208, "Invalid regular-expression pattern:");
        errorDesc.put(209, "Not allowed in class:");
        errorDesc.put(219, "Invalid ALL phrase, ALL removed:");
        errorDesc.put(225, "Duplicate definition: ");
        errorDesc.put(222, "The method signature might be ambiguous:");
        errorDesc.put(223, "Nested COPY ... REPLACING may cause unexpected results");
        errorDesc.put(228, "Only a host variable or a literal is allowed here:");
        errorDesc.put(247, "STATIC clause required");
        errorDesc.put(100000, "Compiling result");
        errorDesc.put(100001, "Informational(s)");
        errorDesc.put(100002, "Warning(s)");
        errorDesc.put(100003, "Error(s)");
        errorDesc.put(100004, "Severe error(s)");
        errorDesc.put(179, "WD2: Unsupported ");
        errorDesc.put(232, "EIS/Mobile: Unsupported ");
        errorDesc.put(207, "Duplicate EFD/EFC name ");
        errorDesc.put(229, "Missing EFD/EFC key name ");
        errorDesc.put(217, "WHEN EFD/EFC name not found ");
        errorDesc.put(210, "Duplicate key definition:");
        errorDesc.put(211, "Variable(s) declared in LINKAGE isn't in the USING clause:");
        errorDesc.put(212, "Assumed to be a paragraph without final dot:");
        errorDesc.put(213, "Condition name not allowed here:");
        errorDesc.put(214, "Not an interface:");
        errorDesc.put(215, "Must be public:");
        errorDesc.put(216, "Interface method missing:");
        errorDesc.put(218, "Numeric literal treated as alphanumeric:");
        errorDesc.put(220, "Possible divide by ZERO without ON SIZE ERROR");
        errorDesc.put(221, "duplicated $EFD directives not allowed, only the last is considered.");
        errorDesc.put(224, "This variable contains a KEY that will be lost in iss file, because in REDEFINE:");
        errorDesc.put(226, "$ELK directive in wrong format:");
        errorDesc.put(227, "ELK Directive ignored:");
        errorDesc.put(230, "$ELK directive has wrong value:");
        errorDesc.put(236, "VALUE has already been specified");
        errorDesc.put(237, "SET PROPERTY must have a single USING parameter");
        errorDesc.put(239, "GET PROPERTY must not have the USING phrase");
        errorDesc.put(238, "SET PROPERTY must not have the RETURNING phrase");
        errorDesc.put(240, "GET PROPERTY must have the RETURNING phrase");
        errorDesc.put(242, "Incorrect optional parameters for OUTDD, defaults will be used:");
        errorDesc.put(243, "Invalid SQL directive:");
        errorDesc.put(244, "$SQL directive in wrong format:");
        errorDesc.put(245, "XML file is invalid and easydb can not be activated!");
        errorDesc.put(250, "Too many parameters the bean code will be generated with only one 'run' method!");
        errorDesc.put(251, "Line truncated");
        errorDesc.put(252, "Ignored color name:");
        errorDesc.put(253, "Paragraph name found in Area B:");
        errorDesc.put(254, "Procedure name same as data name:");
        errorDesc.put(257, "Dynamic items will be ignored:");
        errorDesc.put(258, "Gradient settings will be ignored");
        errorDesc.put(258, "Gradient settings will be ignored");
        errorDesc.put(280, "Background Bitmap settings will be ignored");
        errorDesc.put(278, "Missing CLSID");
        errorDesc.put(266, "SELECTION-MODE will be ignored with TABLE-VIEW style");
        errorDesc.put(260, "$EFD date string shorter than field:");
        errorDesc.put(264, "Subscript out of bounds:");
        errorDesc.put(265, "Sql indicator not declared:");
        errorDesc.put(267, "Error: no Java compiler, ensure you're running with a JDK");
        errorDesc.put(268, "Missing out directory:");
        errorDesc.put(269, "Option -jj: SMAP information not included");
        errorDesc.put(270, "Since OCCURS DYNAMIC the bean code will be generated with only one 'run' method!");
        errorDesc.put(272, "servicebridge not generated due to OCCURS DYNAMIC without CAPACITY");
        errorDesc.put(286, "servicebridge bean not generated because more than 48 levels used in linkage");
        errorDesc.put(273, "Group items cannot be used except in INTO or VALUES clause");
        errorDesc.put(277, "NO-BOX style will be ignored in TAB-CONTROL allow-container/accordion");
        errorDesc.put(283, "open IO not supported");
        errorDesc.put(287, "Continuation character expected, end of literal assumed");
        errorDesc.put(292, "'maximize' feature not available for FLOATING window");
        errorDesc.put(293, "THREAD-LOCAL ignored");
        errorDesc.put(294, "THREAD-LOCAL ignored on external data item");
        errorDesc.put(295, "Custom Preprocessor:");
        errorDesc.put(296, "Data item length exceeds 2 GB:");
        errorDesc.put(298, "Abstract class cannot be instantiated:");
        errorDesc.put(300, "Classname assumed to be");
        errorDesc.put(301, "VARARGS must be the last parameter:");
        errorDesc.put(302, "REMAINDER without GIVING");
        errorDesc.put(303, "DRAG-MODE ignored for TREE-VIEW with TREE-TABLE property");
        errorDesc.put(304, "DRAG-MODE ignored for this gui component");
        errorDesc.put(305, "ANY LENGTH variable is not allowed");
        errorDesc.put(307, "Invalid configuration property value:");
        errorDesc.put(308, "'BY VALUE' clause required:");
        errorDesc.put(309, "Illegal character found in column 7. Blank assumed");
        errorDesc.put(310, "Invalid binary digit:");
        errorDesc.put(311, "Invalid hex digit:");
        errorDesc.put(312, "Invalid octal digit:");
        errorDesc.put(313, "Sign in VALUE clause ignored:");
        errorDesc.put(314, "VALUE too long for data item or has too many decimal positions:");
        errorDesc.put(315, "ALTER paragraph must contain only GO TO without DEPENDING:");
        errorDesc.put(317, "Alphanumeric literal has zero length, space assumed:");
    }
}

