/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import java.util.Hashtable;

public class EsqParser
implements CobolToken,
ErrorsNumbers {
    private Token first;
    private Errors error;
    private TokenList tl;
    private static Hashtable params = new Hashtable();

    public EsqParser() {
    }

    public EsqParser(TokenList tokenList, Errors errors) {
        this.error = errors;
        this.tl = tokenList;
        this.first = this.tl.getFirst();
        Token token = this.tl.getNext();
        if (!token.getWord().equalsIgnoreCase("HOSTVAR")) {
            this.error.print(244, 4, this.first, token.getWord() + " |" + this.first.getWord());
            return;
        }
        token = this.tl.getNext();
        while (token != null) {
            int n2 = 0;
            if (token.getToknum() == 59) {
                token = this.tl.getNext();
            }
            if (token == null || token.getToknum() != 10002) {
                if (token == null) {
                    this.error.print(244, 4, this.first, " invalid end directive");
                } else {
                    this.error.print(244, 4, token, token.getWord());
                }
                return;
            }
            n2 = Integer.parseInt(token.getWord());
            if (!this.carComma(this.tl, errors)) {
                return;
            }
            token = this.tl.getNext();
            if (token == null || !token.getWord().equalsIgnoreCase("I") && !token.getWord().equalsIgnoreCase("U") && !token.getWord().equalsIgnoreCase("O") && !token.getWord().equalsIgnoreCase("D")) {
                if (token == null) {
                    this.error.print(244, 4, this.first, " invalid end directive");
                } else {
                    this.error.print(244, 4, token, token.getWord());
                }
                return;
            }
            String string = token.getWord();
            token = this.tl.getNext();
            if (token == null || token != null && token.getToknum() == 59) {
                if (token != null) {
                    token = this.tl.getPrevious();
                }
            } else {
                token = this.tl.getPrevious();
                if (!this.carComma(this.tl, errors)) {
                    return;
                }
                token = this.tl.getNext();
                string = string + "," + token.getWord();
                if (token.getWord().equalsIgnoreCase("ARRAY") || token.getWord().equalsIgnoreCase("STRUCT")) {
                    if (!this.carComma(this.tl, errors)) {
                        return;
                    }
                    token = this.tl.getNext();
                    if (token == null || token.getWord().equals(";")) {
                        this.error.print(244, 4, this.first, " ARRAY/STRUCT must have a name");
                        return;
                    }
                    string = string + "," + token.getWord();
                }
            }
            params.put(n2, string);
            token = this.tl.getNext();
        }
    }

    boolean carComma(TokenList tokenList, Errors errors) {
        Token token = tokenList.getNext();
        if (token == null || token.getToknum() != 44) {
            if (token == null) {
                this.error.print(244, 4, this.first, " invalid end directive");
            } else {
                this.error.print(244, 4, token, token.getWord() + "comma expected");
            }
            return false;
        }
        return true;
    }

    public String getParam(int n2) {
        return (String)params.get(n2);
    }
}

