/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class Evaluate
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int EVAL_UNKNOWN = 0;
    public static final int EVAL_TRUE = 1;
    public static final int EVAL_FALSE = 2;
    public static final int EVAL_ANY = 3;
    public static final int EVAL_EXPR = 4;
    public static final int EVAL_COND = 5;
    public static final int EVAL_PARTCOND = 6;
    public static final int EVAL_OTHER = 7;
    static final int OPTIMIZE_INTEGER = 1;
    static final int OPTIMIZE_LEVEL88_INTEGER = 2;
    static final int OPTIMIZE_STRING = 3;
    static final int OPTIMIZE_LEVEL88_STRING = 4;
    private VerbList subjectSet = new VerbList();
    private VerbList objectSet = new VerbList();
    private boolean otherFound;
    private final boolean oeOpt;

    public Evaluate(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2;
        Expression expression;
        EvaluateSuObject evaluateSuObject;
        this.oeOpt = pcc.getOption("-oe") != null || pcc.getOption("-xoe") != null;
        while (true) {
            evaluateSuObject = new EvaluateSuObject(this.keyWord, this.parent, this.pc, this.tm, this.error, true, null);
            this.subjectSet.addItem(evaluateSuObject);
            expression = evaluateSuObject.expr;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 810) break;
            if (token2.getToknum() == 271) continue;
            this.tm.ungetToken();
        }
        int n2 = this.subjectSet.getItemNum();
        while (token2.getToknum() == 810) {
            token = token2;
            if (this.otherFound) {
                throw new GeneralErrorException(118, 4, token2, token2.getWord(), this.error);
            }
            evaluateSuObject = new EvaluateSuObject(token, this.parent, this.pc, this.tm, this.error, false, expression);
            this.objectSet.addItem(evaluateSuObject);
            if (evaluateSuObject.type != 7) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 271) {
                        this.tm.ungetToken();
                    }
                    evaluateSuObject = new EvaluateSuObject(token, this.parent, this.pc, this.tm, this.error, false, expression);
                    this.objectSet.addItem(evaluateSuObject);
                }
            } else {
                this.otherFound = true;
            }
            Block block2 = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            block2.parentSuObj = evaluateSuObject;
            evaluateSuObject.setBlock(block2);
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() != 431) {
            if (token2.getToknum() != 10006) {
                this.error.print(154, 3, token2, "END-EVALUATE");
            }
            this.tm.ungetToken();
        }
    }

    private int getOptimizableCode() {
        if (this.isOptimizableInt()) {
            return 1;
        }
        if (this.isOptimizableLev88Int()) {
            return 2;
        }
        if (this.isOptimizableString()) {
            return 3;
        }
        if (this.isOptimizableLev88String()) {
            return 4;
        }
        return 0;
    }

    private boolean isOptimizableInt() {
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        if (evaluateSuObject.isNot() || evaluateSuObject.getExprThru() != null || !this.isOptimizableInt(evaluateSuObject.getExpr(), false)) {
            return false;
        }
        int n2 = 0;
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getFirst();
        while (evaluateSuObject2 != null) {
            switch (evaluateSuObject2.getType()) {
                case 4: {
                    if (!evaluateSuObject2.isNot() && evaluateSuObject2.getExprThru() == null && this.isOptimizableInt(evaluateSuObject2.getExpr(), true)) break;
                    return false;
                }
                case 7: {
                    if (n2 != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
        return true;
    }

    private boolean isOptimizableInt(Expression expression, boolean bl) {
        VariableName variableName;
        if (expression == null || !expression.isNumeric()) {
            return false;
        }
        Stack stack = expression.getPFX();
        if (stack.size() != 1) {
            return false;
        }
        Expression.ExprItem exprItem = (Expression.ExprItem)stack.get(0);
        return !(bl ? exprItem.tk == null || !this.isOptimizableInt(exprItem.tk) : (variableName = exprItem.value) == null || !this.isOptimizableInt(variableName.getVarDecl()));
    }

    private boolean isOptimizableString(Expression expression, boolean bl) {
        VariableName variableName;
        if (expression == null || !expression.isString()) {
            return false;
        }
        Stack stack = expression.getPFX();
        if (stack.size() != 1) {
            return false;
        }
        Expression.ExprItem exprItem = (Expression.ExprItem)stack.get(0);
        return !(bl ? exprItem.tk == null || !this.isOptimizableString(exprItem.tk) : (variableName = exprItem.value) == null || !this.isOptimizableString(variableName.getVarDecl()));
    }

    private boolean isOptimizableInt(Token token) {
        if (token.getToknum() != 10002) {
            return false;
        }
        try {
            Integer.parseInt(token.getWord());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isOptimizableString(Token token) {
        return token.getToknum() == 10001 && !token.isResource() && !token.isHexdecimal();
    }

    private boolean isOptimizableInt(VariableDeclaration variableDeclaration) {
        if (!variableDeclaration.isInteger()) {
            return false;
        }
        return !(variableDeclaration.isBinary() ? variableDeclaration.getPhisicLen() > 3 : variableDeclaration.getLogicLen() > 9);
    }

    private boolean isOptimizableString(VariableDeclaration variableDeclaration) {
        return !variableDeclaration.isNumeric() || variableDeclaration.isEdited();
    }

    private boolean isOptimizableLev88Int() {
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        if (evaluateSuObject.getType() != 1) {
            return false;
        }
        VariableDeclaration variableDeclaration = null;
        int n2 = 0;
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getFirst();
        while (evaluateSuObject2 != null) {
            switch (evaluateSuObject2.getType()) {
                case 5: {
                    if (evaluateSuObject2.isNot()) {
                        return false;
                    }
                    if (evaluateSuObject2.getCond() == null) {
                        return false;
                    }
                    VerbList verbList = evaluateSuObject2.getCond().getAllItems();
                    if (verbList.getItemNum() != 1) {
                        return false;
                    }
                    Verb verb = verbList.getFirst();
                    if (!(verb instanceof SimpleCondition)) {
                        return false;
                    }
                    SimpleCondition simpleCondition = (SimpleCondition)verb;
                    Expression expression = simpleCondition.getLeft();
                    VariableNameList variableNameList = expression.getAllVars();
                    if (variableNameList.getItemNum() != 1) {
                        return false;
                    }
                    VariableName variableName = variableNameList.getFirst();
                    if (variableName.getLevel() != 88 || variableName.getIndexes() != null) {
                        return false;
                    }
                    VariableDeclaration variableDeclaration2 = variableName.getVarDecl().getParent();
                    if (variableDeclaration != null && variableDeclaration2 != variableDeclaration) {
                        return false;
                    }
                    if (!(variableDeclaration != null || (variableDeclaration = variableDeclaration2) != null && this.isOptimizableInt(variableDeclaration))) {
                        return false;
                    }
                    VariableDeclaration variableDeclaration3 = variableName.getVarDecl();
                    int n3 = variableDeclaration3.getValuesCount();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (!this.isOptimizableInt(variableDeclaration3.getLowValue(i2))) {
                            return false;
                        }
                        if (variableDeclaration3.getHighValue(i2) == null) continue;
                        if (!this.isOptimizableInt(variableDeclaration3.getHighValue(i2))) {
                            return false;
                        }
                        int n4 = Integer.parseInt(variableDeclaration3.getLowValue(i2).getWord());
                        int n5 = Integer.parseInt(variableDeclaration3.getHighValue(i2).getWord());
                        if (Math.abs(n5 - n4) <= 10) continue;
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (n2 != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
        return true;
    }

    private boolean isOptimizableString() {
        if (!this.oeOpt) {
            return false;
        }
        if (this.pc.getProgramCollatingSeq() != null) {
            return false;
        }
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        if (evaluateSuObject.isNot() || evaluateSuObject.getExprThru() != null || !this.isOptimizableString(evaluateSuObject.getExpr(), false)) {
            return false;
        }
        if (this.objectSet.getItemNum() < 10) {
            return false;
        }
        int n2 = 0;
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getFirst();
        while (evaluateSuObject2 != null) {
            switch (evaluateSuObject2.getType()) {
                case 4: {
                    if (!evaluateSuObject2.isNot() && evaluateSuObject2.getExprThru() == null && this.isOptimizableString(evaluateSuObject2.getExpr(), true)) break;
                    return false;
                }
                case 7: {
                    if (n2 != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
        return true;
    }

    private boolean isOptimizableLev88String() {
        if (!this.oeOpt) {
            return false;
        }
        if (this.pc.getProgramCollatingSeq() != null) {
            return false;
        }
        if (this.subjectSet.getItemNum() != 1) {
            return false;
        }
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        if (evaluateSuObject.getType() != 1) {
            return false;
        }
        if (this.objectSet.getItemNum() < 10) {
            return false;
        }
        VariableDeclaration variableDeclaration = null;
        int n2 = 0;
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getFirst();
        while (evaluateSuObject2 != null) {
            switch (evaluateSuObject2.getType()) {
                case 5: {
                    if (evaluateSuObject2.isNot()) {
                        return false;
                    }
                    if (evaluateSuObject2.getCond() == null) {
                        return false;
                    }
                    VerbList verbList = evaluateSuObject2.getCond().getAllItems();
                    if (verbList.getItemNum() != 1) {
                        return false;
                    }
                    Verb verb = verbList.getFirst();
                    if (!(verb instanceof SimpleCondition)) {
                        return false;
                    }
                    SimpleCondition simpleCondition = (SimpleCondition)verb;
                    Expression expression = simpleCondition.getLeft();
                    VariableNameList variableNameList = expression.getAllVars();
                    if (variableNameList.getItemNum() != 1) {
                        return false;
                    }
                    VariableName variableName = variableNameList.getFirst();
                    if (variableName.getLevel() != 88 || variableName.getIndexes() != null) {
                        return false;
                    }
                    VariableDeclaration variableDeclaration2 = variableName.getVarDecl().getParent();
                    if (variableDeclaration != null && variableDeclaration2 != variableDeclaration) {
                        return false;
                    }
                    if (!(variableDeclaration != null || (variableDeclaration = variableDeclaration2) != null && this.isOptimizableString(variableDeclaration))) {
                        return false;
                    }
                    VariableDeclaration variableDeclaration3 = variableName.getVarDecl();
                    int n3 = variableDeclaration3.getValuesCount();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (!this.isOptimizableString(variableDeclaration3.getLowValue(i2))) {
                            return false;
                        }
                        if (variableDeclaration3.getHighValue(i2) == null) continue;
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (n2 != 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
        return true;
    }

    @Override
    public void check() throws GeneralErrorException {
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getFirst();
        while (evaluateSuObject2 != null) {
            switch (evaluateSuObject2.type) {
                case 0: {
                    throw new GeneralErrorException(61, 4, evaluateSuObject2.keyWord, evaluateSuObject2.keyWord.getWord(), this.error);
                }
                case 1: 
                case 2: 
                case 5: {
                    if (evaluateSuObject.type != 1 && evaluateSuObject.type != 2 && evaluateSuObject.type != 5) {
                        throw new GeneralErrorException(62, 4, evaluateSuObject2.keyWord, evaluateSuObject2.keyWord.getWord(), this.error);
                    }
                    evaluateSuObject2.check();
                    break;
                }
                case 4: {
                    if (evaluateSuObject.type != 4) {
                        throw new GeneralErrorException(62, 4, evaluateSuObject2.keyWord, evaluateSuObject2.keyWord.getWord(), this.error);
                    }
                    SimpleCondition.check(evaluateSuObject2, evaluateSuObject.getExpr(), 1, evaluateSuObject2.getExpr());
                    break;
                }
                case 6: {
                    if (evaluateSuObject.type == 4) break;
                    throw new GeneralErrorException(62, 4, evaluateSuObject2.keyWord, evaluateSuObject2.keyWord.getWord(), this.error);
                }
            }
            evaluateSuObject = (EvaluateSuObject)this.subjectSet.getNext();
            if (evaluateSuObject == null) {
                evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
            }
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        int n2 = this.getOptimizableCode();
        switch (n2) {
            case 1: {
                this.getCodeOptimized(stringBuffer, false);
                break;
            }
            case 2: {
                this.getCodeOptimizedLevel88(stringBuffer, false);
                break;
            }
            case 3: {
                this.getCodeOptimized(stringBuffer, true);
                break;
            }
            case 4: {
                this.getCodeOptimizedLevel88(stringBuffer, true);
                break;
            }
            default: {
                String string = "";
                EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
                while (evaluateSuObject != null) {
                    if (evaluateSuObject.type == 5) {
                        string = "eval$" + Evaluate.getUniqueId();
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("boolean ");
                        stringBuffer.append(string);
                        stringBuffer.append("=");
                        stringBuffer.append(evaluateSuObject.getCode());
                        stringBuffer.append(";");
                        stringBuffer.append(eol);
                        evaluateSuObject.setBoolVar(string);
                    }
                    evaluateSuObject = (EvaluateSuObject)this.subjectSet.getNext();
                }
                this.getCode(stringBuffer, 0);
                stringBuffer.append(eol);
            }
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private void getCodeOptimized(StringBuffer stringBuffer, boolean bl) {
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        String string = "eval$" + Evaluate.getUniqueId();
        stringBuffer.append(bl ? "String " : "int ");
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        if (bl) {
            stringBuffer.append("Factory.rtrim(");
            stringBuffer.append(evaluateSuObject.expr.firstVar.getCode());
            stringBuffer.append(".toString());");
        } else {
            stringBuffer.append(evaluateSuObject.expr.firstVar.getCode());
            stringBuffer.append(".toint();");
        }
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("switch(");
        stringBuffer.append(string);
        stringBuffer.append(") {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        this.writeCases(stringBuffer, bl, 0, string, false, false, new HashSet());
        stringBuffer.append("}");
        stringBuffer.append(eol);
    }

    void writeCases(StringBuffer stringBuffer, boolean bl, int n2, String string, boolean bl2, boolean bl3, Set set) {
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.objectSet.getAt(n2);
        while (evaluateSuObject != null) {
            if (evaluateSuObject.getDeferredMethodId() > 0 && evaluateSuObject.getDeferredMethodId() != this.deferredMethodId) {
                this.writeDeferredMethodCode(stringBuffer, n2, bl ? 3 : 1, string, set, evaluateSuObject.getDeferredMethodId());
                return;
            }
            bl2 = this.writeCase(stringBuffer, evaluateSuObject, bl, bl2, bl3, set);
            bl3 = false;
            if (bl2) {
                ++n2;
                evaluateSuObject = (EvaluateSuObject)this.objectSet.getNext();
                while (evaluateSuObject != null) {
                    if (evaluateSuObject.getDeferredMethodId() > 0 && evaluateSuObject.getDeferredMethodId() != this.deferredMethodId) {
                        this.writeDeferredMethodCode(stringBuffer, n2, bl ? 3 : 1, string, set, evaluateSuObject.getDeferredMethodId());
                        return;
                    }
                    if (!(bl2 = this.writeCase(stringBuffer, evaluateSuObject, bl, bl2, bl3, set))) break;
                    evaluateSuObject = (EvaluateSuObject)this.objectSet.getNext();
                    ++n2;
                }
            }
            evaluateSuObject = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
    }

    private void writeDeferredMethodCode(StringBuffer stringBuffer, int n2, int n3, String string, Set set, int n4) {
        boolean bl = this.pc.getOption("-d") != null;
        boolean bl2 = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
        DeferredBlock deferredBlock = this.parent.parent.getDeferredBlock(n4);
        deferredBlock.setEvaluate(this, n2, n3, string, set);
        this.parent.parent.deferredBlockList.add(deferredBlock);
        stringBuffer.append("default:" + eol + this.parent.getIndent());
        stringBuffer.append(deferredBlock.getCallCode(this.deferredMethodId, bl, bl2) + eol);
        stringBuffer.append(this.parent.getIndent() + "   break;" + eol);
    }

    private void getCodeOptimizedLevel88(StringBuffer stringBuffer, boolean bl) {
        String string;
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.objectSet.getFirst();
        VariableName variableName = ((SimpleCondition)evaluateSuObject.getCond().getAllItems().getFirst()).getLeft().firstVar;
        VariableDeclaration variableDeclaration = variableName.getVarDecl().getParent();
        String string2 = "eval$" + Evaluate.getUniqueId();
        stringBuffer.append(bl ? "String " : "int ");
        stringBuffer.append(string2);
        stringBuffer.append(" = ");
        String string3 = string = this.pc.optionMS ? variableDeclaration.getUnivoqueName() : variableDeclaration.getDeclUnivoqueName() + variableName.getSubscriptCode();
        if (bl) {
            stringBuffer.append("Factory.rtrim(");
            stringBuffer.append(string);
            stringBuffer.append(".toString());");
        } else {
            stringBuffer.append(string);
            stringBuffer.append(".toint();");
        }
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("switch(");
        stringBuffer.append(string2);
        stringBuffer.append(") {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        this.writeCases(stringBuffer, bl, 0, string2, false, false, new HashSet());
        stringBuffer.append("}");
        stringBuffer.append(eol);
    }

    private String[] getTokens(EvaluateSuObject evaluateSuObject) {
        String[] stringArray = null;
        switch (evaluateSuObject.getType()) {
            case 7: {
                stringArray = new String[]{};
                break;
            }
            case 5: {
                VariableDeclaration variableDeclaration = ((SimpleCondition)evaluateSuObject.getCond().getAllItems().getFirst()).getLeft().firstVar.getVarDecl();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = variableDeclaration.getValuesCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (variableDeclaration.getHighValue(i2) != null) {
                        int n3;
                        int n4;
                        int n5 = Integer.parseInt(variableDeclaration.getLowValue(i2).getWord());
                        if (n5 > (n4 = Integer.parseInt(variableDeclaration.getHighValue(i2).getWord()))) {
                            n3 = n5;
                            n5 = n4;
                            n4 = n3;
                        }
                        for (n3 = n5; n3 <= n4; ++n3) {
                            arrayList.add(Integer.toString(n3));
                        }
                        continue;
                    }
                    arrayList.add(variableDeclaration.getLowValue(i2).getWord());
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                break;
            }
            case 4: {
                stringArray = new String[]{evaluateSuObject.getExpr().firstToken.getWord()};
            }
        }
        return stringArray;
    }

    private boolean writeCase(StringBuffer stringBuffer, EvaluateSuObject evaluateSuObject, boolean bl, boolean bl2, boolean bl3, Set set) {
        String[] stringArray = this.getTokens(evaluateSuObject);
        boolean bl4 = false;
        if (evaluateSuObject.getType() == 7) {
            stringBuffer.append("default:");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        } else {
            bl4 = true;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                string = bl ? Evaluate.removeTrailingSpacesAndEscape(string) : Evaluate.removeLeadingZeros(string);
                if (set.contains(string) && (!bl3 || i2 > 0)) {
                    stringBuffer.append("// ");
                } else {
                    bl4 = false;
                    set.add(string);
                }
                stringBuffer.append("case ");
                stringBuffer.append(string);
                stringBuffer.append(":");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
        }
        Block block = evaluateSuObject.getBlock();
        if (block != null) {
            if (!block.isEmpty()) {
                if (!bl4 || bl2) {
                    stringBuffer.append(evaluateSuObject.getBlock().getCode());
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("   break;");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                }
                return false;
            }
            if (bl4) {
                return bl2;
            }
            return true;
        }
        if (!bl4 || bl2) {
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("   break;");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        return false;
    }

    private static String removeTrailingSpacesAndEscape(String string) {
        int n2;
        if (string == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (n2 = cArray.length - 2; n2 >= 1 && cArray[n2] == ' '; --n2) {
        }
        block9: for (int i2 = 1; i2 <= n2; ++i2) {
            switch (cArray[i2]) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\').append(cArray[i2]);
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String removeLeadingZeros(String string) {
        if (string == null) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length() - 1;
        char c2 = string.charAt(0);
        if (c2 == '+' || c2 == '-') {
            n2 = 1;
        } else {
            c2 = '\u0000';
        }
        while (n2 < n3 && string.charAt(n2) == '0') {
            ++n2;
        }
        if (c2 == '\u0000') {
            if (n2 > 0) {
                return string.substring(n2);
            }
            return string;
        }
        if (n2 > 1) {
            return "" + c2 + string.substring(n2);
        }
        return string;
    }

    void getCode(StringBuffer stringBuffer, int n2) {
        EvaluateSuObject evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("if (");
        Alphabet alphabet = this.pc.getProgramCollatingSeq();
        EvaluateSuObject evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getAt(n2);
        while (evaluateSuObject2 != null) {
            boolean bl;
            boolean bl2;
            if (evaluateSuObject2.getDeferredMethodId() > 0 && evaluateSuObject2.getDeferredMethodId() != this.deferredMethodId) {
                bl2 = this.pc.getOption("-d") != null;
                bl = this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null;
                DeferredBlock deferredBlock = this.parent.parent.getDeferredBlock(evaluateSuObject2.getDeferredMethodId());
                deferredBlock.setEvaluate(this, n2);
                this.parent.parent.deferredBlockList.add(deferredBlock);
                stringBuffer.append(" else {" + eol + this.parent.getIndent());
                stringBuffer.append(deferredBlock.getCallCode(this.deferredMethodId, bl2, bl) + eol);
                stringBuffer.append(this.parent.getIndent() + " }" + eol);
                break;
            }
            boolean bl3 = evaluateSuObject2.not ^ evaluateSuObject.not && evaluateSuObject2.type != 7;
            if (bl3) {
                stringBuffer.append("!(");
            }
            switch (evaluateSuObject2.type) {
                case 0: {
                    break;
                }
                case 2: {
                    stringBuffer.append("!");
                    stringBuffer.append(evaluateSuObject.getCode());
                    break;
                }
                case 1: {
                    stringBuffer.append(evaluateSuObject.getCode());
                    break;
                }
                case 5: {
                    stringBuffer.append("(");
                    stringBuffer.append(evaluateSuObject.getCode());
                    stringBuffer.append("==");
                    stringBuffer.append(evaluateSuObject2.getCode());
                    stringBuffer.append(")");
                    break;
                }
                case 6: {
                    stringBuffer.append("(");
                    stringBuffer.append(evaluateSuObject2.getCode());
                    stringBuffer.append(")");
                    break;
                }
                case 4: {
                    boolean bl4 = bl2 = evaluateSuObject2.thru ? 3 != 0 : true;
                    if (this.pc.getOption("-cudc") != null && SimpleCondition.isUDisplayCond(evaluateSuObject.getExpr(), bl2 ? 1 : 0, evaluateSuObject2.getExpr(), stringBuffer, alphabet, this.tm)) {
                        bl = true;
                    } else {
                        bl = false;
                        boolean bl5 = evaluateSuObject.expr.isJavaString();
                        boolean bl6 = evaluateSuObject2.expr.isJavaString();
                        if (bl5 && bl6 || bl5 && evaluateSuObject2.expr.getType() == 2 || bl6 && evaluateSuObject.expr.getType() == 2) {
                            stringBuffer.append("ExprUtil.cmp(");
                            stringBuffer.append(evaluateSuObject.getCode());
                            stringBuffer.append(", ");
                            stringBuffer.append(evaluateSuObject2.getCode());
                        } else {
                            stringBuffer.append(evaluateSuObject.getCode());
                            stringBuffer.append(".compareTo(");
                            stringBuffer.append(evaluateSuObject2.getCode());
                            if (!evaluateSuObject.expr.isNumeric() && !evaluateSuObject2.expr.isNumeric() && alphabet != null) {
                                stringBuffer.append(", " + alphabet.getDeclUnivoqueName());
                            }
                        }
                        stringBuffer.append(")");
                    }
                    if (evaluateSuObject2.thru) {
                        if (!bl) {
                            stringBuffer.append(">=0");
                        }
                        stringBuffer.append("&&");
                        if (this.pc.getOption("-cudc") != null && SimpleCondition.isUDisplayCond(evaluateSuObject.getExpr(), 4, evaluateSuObject2.getExprThru(), stringBuffer, alphabet, this.tm)) break;
                        stringBuffer.append(evaluateSuObject.getCode());
                        stringBuffer.append(".compareTo(");
                        stringBuffer.append(evaluateSuObject2.getCodeThru());
                        if (!evaluateSuObject.expr.isNumeric() && !evaluateSuObject2.exprThru.isNumeric() && alphabet != null) {
                            stringBuffer.append(", " + alphabet.getDeclUnivoqueName());
                        }
                        stringBuffer.append(")<=0");
                        break;
                    }
                    if (bl) break;
                    stringBuffer.append("==0");
                    break;
                }
                case 3: {
                    stringBuffer.append("true");
                    break;
                }
                case 7: {
                    stringBuffer.append("true");
                    this.subjectSet.getLast();
                }
            }
            if (bl3) {
                stringBuffer.append(")");
            }
            if ((evaluateSuObject = (EvaluateSuObject)this.subjectSet.getNext()) == null) {
                if (evaluateSuObject2.block != null && evaluateSuObject2.block.isEmpty()) {
                    evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
                    ++n2;
                    if (evaluateSuObject2 != null) {
                        evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
                        stringBuffer.append(" ||");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        stringBuffer.append("          ");
                        continue;
                    }
                    stringBuffer.append(")");
                    stringBuffer.append("   ;");
                    continue;
                }
                stringBuffer.append(")");
                if (evaluateSuObject2.block != null) {
                    stringBuffer.append(evaluateSuObject2.block.getCode());
                } else {
                    stringBuffer.append("   ;");
                }
                evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
                ++n2;
                if (evaluateSuObject2 == null) continue;
                evaluateSuObject = (EvaluateSuObject)this.subjectSet.getFirst();
                if (evaluateSuObject2.getDeferredMethodId() != 0 && evaluateSuObject2.getDeferredMethodId() != this.deferredMethodId) continue;
                stringBuffer.append(" else if (");
                continue;
            }
            stringBuffer.append("&&");
            evaluateSuObject2 = (EvaluateSuObject)this.objectSet.getNext();
            ++n2;
        }
    }

    public VerbList getSubjectSet() {
        return this.subjectSet;
    }

    public VerbList getObjectSet() {
        return this.objectSet;
    }
}

