/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Verb;

public class EvaluateSuObject
extends Verb
implements CobolToken,
ErrorsNumbers {
    Expression expr;
    Expression exprThru;
    Condition cond;
    Block block;
    int type = 0;
    boolean not;
    boolean thru;
    String boolVar;

    public EvaluateSuObject(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, boolean bl, Expression expression) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        TokenManager.Marker marker = this.tm.getMarker();
        this.tm.setMarker(marker);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 598) {
            this.not = true;
            token2 = this.tm.getToken();
        }
        switch (token2.getToknum()) {
            case 780: {
                this.type = 1;
                return;
            }
            case 480: {
                this.type = 2;
                return;
            }
            case 275: {
                if (bl) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.type = 3;
                return;
            }
            case 620: {
                if (bl) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.type = 7;
                return;
            }
            case 40: 
            case 10001: 
            case 10002: 
            case 10009: 
            case 10017: {
                expression = null;
            }
        }
        this.tm.ungetToken();
        if (expression != null) {
            this.cond = new Condition(expression, this.not, this.keyWord, this.parent, this.pc, this.tm, this.error);
            this.not = false;
        } else {
            this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        }
        if (!this.cond.isFullCondition()) {
            this.expr = this.cond.getLeft();
            this.type = 4;
            if (!bl) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 768 || token2.getToknum() == 767) {
                    this.exprThru = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                    if (this.expr.isNumeric() != this.exprThru.isNumeric()) {
                        throw new IllegalConditionException(this.keyWord, this.error);
                    }
                    this.thru = true;
                } else {
                    this.tm.ungetToken();
                }
            }
        } else {
            if (this.not) {
                this.not = false;
                this.tm.rewindToMarker(marker);
                this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
            }
            this.type = expression != null ? 6 : 5;
        }
    }

    void setBlock(Block block) {
        this.block = block;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.cond != null) {
            this.cond.check();
        }
    }

    void setBoolVar(String string) {
        this.boolVar = string;
    }

    @Override
    public String getCode() {
        switch (this.type) {
            default: {
                return "false";
            }
            case 1: 
            case 3: 
            case 7: {
                return "true";
            }
            case 4: {
                return this.expr.getCode();
            }
            case 5: 
            case 6: 
        }
        if (this.boolVar == null) {
            return "(" + this.cond.getCode() + ")";
        }
        return this.boolVar;
    }

    public String getCodeThru() {
        return this.exprThru.getCode();
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Expression getExprThru() {
        return this.exprThru;
    }

    public Condition getCond() {
        return this.cond;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNot() {
        return this.not;
    }

    public String toString() {
        return this.keyWord.getOriginalWord();
    }
}

