/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Examine
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName source;
    private boolean tallying;
    private boolean replacing;
    static final int E_ALL = 1;
    static final int E_LEADING = 2;
    static final int E_FIRST = 3;
    static final int E_UNTIL_FIRST = 4;
    private int type;
    private Token target;
    private Token replace;
    private boolean hasNational;

    public Examine(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009 && token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!this.source.getVarDecl().isUsageDisplay()) {
            throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
        }
        this.setHasNational(this.source);
        token2 = this.tm.getToken();
        switch (token2.getToknum()) {
            case 757: {
                this.tallying = true;
                break;
            }
            case 683: {
                this.replacing = true;
                if (!this.source.isSetGetProperty()) break;
                throw new GeneralErrorException(68, 4, this.source.getNameToken(), this.source.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException(token2, this.error);
            }
        }
        token2 = this.tm.getToken();
        switch (token2.getToknum()) {
            case 556: {
                this.type = 2;
                break;
            }
            case 10002: {
                if (token2.isFigurativeZero()) {
                    token2 = Examine.cloneToken(token2, 10001, "'0'");
                }
            }
            case 10001: {
                if (token2.isAll()) {
                    this.type = 1;
                    token2.setAll(false);
                    this.tm.ungetToken();
                    break;
                }
                throw new UnexpectedTokenException(token2, this.error);
            }
            case 791: {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 489) {
                    this.type = 4;
                    break;
                }
                throw new ExpectedFoundException(token2, this.error, "FIRST");
            }
            case 489: {
                if (this.tallying) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.type = 3;
                break;
            }
            default: {
                throw new UnexpectedTokenException(token2, this.error);
            }
        }
        this.target = this.tm.getToken();
        if (this.target.getToknum() != 10002 && this.target.getToknum() != 10001) {
            throw new GeneralErrorException(97, 4, this.target, this.target.getWord(), this.error);
        }
        if (this.tallying) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 683) {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 312) {
                    throw new ExpectedFoundException(token2, this.error, "BY");
                }
                this.replacing = true;
                this.replace = this.tm.getToken();
                if (this.replace.getToknum() != 10002 && this.replace.getToknum() != 10001) {
                    throw new GeneralErrorException(97, 4, this.replace, this.replace.getWord(), this.error);
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 312) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 10002 && token2.getToknum() != 10001) {
                throw new GeneralErrorException(97, 4, this.replace, this.replace.getWord(), this.error);
            }
            this.replace = token2;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token token, int n2, String string) {
        Token token2 = new Token(token);
        token2.setToknum(n2);
        token2.setWord(string);
        token2.setAll(token.isAll());
        return token2;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.tallying) {
            stringBuffer.append("TALLY.set(");
        }
        stringBuffer.append(this.source.getCode());
        stringBuffer.append(".examine");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        stringBuffer.append("(");
        stringBuffer.append(this.getCodeLiteral(this.target));
        stringBuffer.append(" , ");
        if (this.replacing) {
            stringBuffer.append(this.getCodeLiteral(this.replace));
            stringBuffer.append(" , ");
            stringBuffer.append(this.type);
            stringBuffer.append(" , ");
            stringBuffer.append(this.tallying);
        } else {
            stringBuffer.append(this.type);
        }
        stringBuffer.append(")");
        if (this.tallying) {
            stringBuffer.append(")");
        }
        stringBuffer.append(";");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private void setHasNational(VariableName variableName) {
        if (!this.hasNational) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            this.hasNational = variableDeclaration != null && (variableDeclaration.isNational() || variableDeclaration.isPicG());
        }
    }
}

