/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExecHandlerIntf;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NoExec;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Verb;
import java.util.StringTokenizer;

public class Exec
extends Verb
implements CobolToken,
ErrorsNumbers {
    Verb statement;
    private NoExec unknownExec;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exec(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        String string = token2.getWord().toLowerCase();
        if (token2.getToknum() != 10009) throw new UnexpectedTokenException(token2, this.error);
        if (pcc.options.getOption("-noexec") != null) {
            this.unknownExec = new NoExec(token, token2, block, pcc, tokenManager, errors);
            this.statement = this.unknownExec;
            return;
        } else if ("sql".equals(string)) {
            this.statement = new ExecSql(token, block, pcc, tokenManager, errors);
            return;
        } else {
            String string2 = pcc.options.getOption("-exec=");
            if (string2 == null) throw new GeneralErrorException(19, 4, token2, "EXEC " + token2.getWord(), this.error);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ExecHandlerIntf execHandlerIntf;
                if (string.equals(stringTokenizer.nextToken()) && (execHandlerIntf = pcc.getExecHandler(token2.getWord().toLowerCase())) != null) {
                    this.statement = execHandlerIntf.parse(token, block, pcc, tokenManager, errors);
                    return;
                }
                ++n2;
            }
            throw new GeneralErrorException(19, 4, token2, "EXEC " + token2.getWord(), this.error);
        }
    }

    public NoExec getUnknownExec() {
        return this.unknownExec;
    }

    public boolean isUnknown() {
        return this.unknownExec != null;
    }

    public Verb getStatement() {
        return this.statement;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.statement != null) {
            this.statement.check();
        }
    }

    @Override
    public String getCode() {
        if (this.statement != null) {
            return this.statement.getCode();
        }
        return "";
    }

    public void getCode(StringBuffer stringBuffer) {
        if (this.statement != null) {
            stringBuffer.append(this.statement.getCode());
        }
    }
}

