/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlAllocate;
import com.iscobol.compiler.SqlCall;
import com.iscobol.compiler.SqlClose;
import com.iscobol.compiler.SqlCommit;
import com.iscobol.compiler.SqlConnect;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlDeclareDatabase;
import com.iscobol.compiler.SqlDeclareVar;
import com.iscobol.compiler.SqlDelete;
import com.iscobol.compiler.SqlDescribe;
import com.iscobol.compiler.SqlDisconnect;
import com.iscobol.compiler.SqlExecute;
import com.iscobol.compiler.SqlFetch;
import com.iscobol.compiler.SqlFree;
import com.iscobol.compiler.SqlGeneric;
import com.iscobol.compiler.SqlInsert;
import com.iscobol.compiler.SqlOpen;
import com.iscobol.compiler.SqlPrepare;
import com.iscobol.compiler.SqlRelease;
import com.iscobol.compiler.SqlRollback;
import com.iscobol.compiler.SqlSavepoint;
import com.iscobol.compiler.SqlSelect;
import com.iscobol.compiler.SqlSet;
import com.iscobol.compiler.SqlUpdate;
import com.iscobol.compiler.SqlValue;
import com.iscobol.compiler.SqlVar;
import com.iscobol.compiler.SqlWhenever;
import com.iscobol.compiler.SqlWith;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.rts.Config;
import java.util.Hashtable;
import java.util.Locale;

public class ExecSql
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final int SQL_INCLUDE = 10101;
    static final int SQL_CONNECT = 10102;
    static final int SQL_DISCONNECT = 10103;
    static final int SQL_WHENEVER = 10104;
    static final int SQL_COMMIT = 10105;
    static final int SQL_ROLLBACK = 10106;
    static final int SQL_PREPARE = 10107;
    static final int SQL_DECLARE = 10108;
    static final int SQL_EXECUTE = 10109;
    static final int SQL_FETCH = 10110;
    static final int SQL_CLOSE = 10111;
    static final int SQL_OPEN = 10112;
    static final int SQL_ALLOCATE = 10113;
    static final int SQL_FREE = 10114;
    static final int SQL_ALTER = 10115;
    static final int SQL_CREATE = 10116;
    static final int SQL_DROP = 10117;
    static final int SQL_GRANT = 10118;
    static final int SQL_REVOKE = 10119;
    static final int SQL_DESCRIBE = 10120;
    static final int SQL_GET = 10121;
    static final int SQL_SET = 10122;
    static final int SQL_DELETE = 10123;
    static final int SQL_INSERT = 10124;
    static final int SQL_SELECT = 10125;
    static final int SQL_UPDATE = 10126;
    static final int SQL_CALL = 10127;
    static final int SQL_PL_EQ = 10128;
    static final int SQL_PL_CAT = 10129;
    static final int SQL_VAR = 10130;
    static final int SQL_DEALLOCATE = 10131;
    static final int SQL_TRUNCATE = 10132;
    static final int SQL_LOCK = 10133;
    static final int SQL_VALUES = 10134;
    static final int SQL_WITH = 10135;
    static final int SQL_SAVEPOINT = 10136;
    static final int SQL_RELEASE = 10137;
    static final int SQL_DB2_REGISTER = 10199;
    private final VerbList stats = new VerbList();
    private boolean isWhenever;
    private Pcc pcc;
    private static Hashtable sqlToken = new Hashtable();
    private static Pcc lastPcc;

    static int getSqlToken(String string) {
        Integer n2 = (Integer)sqlToken.get(string.toUpperCase(Locale.US));
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public ExecSql(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        CobolToken cobolToken;
        SqlSet sqlSet = null;
        VariableName variableName = null;
        int n2 = 0;
        this.pcc = pcc;
        this.init();
        tokenManager.inExecSql = true;
        TokenManager.Marker marker = this.tm.getMarker();
        this.tm.setMarker(marker);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 58) {
            cobolToken = VariableName.get(this.tm, this.error, this.pc);
            if (cobolToken == null) {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 61) {
                token2 = this.tm.getToken();
                if (!token2.getWord().equals("CALL")) {
                    this.tm.rewindToMarker(marker);
                    token2 = this.tm.getToken();
                    marker = null;
                }
            } else {
                this.tm.rewindToMarker(marker);
                token2 = this.tm.getToken();
                marker = null;
            }
        } else {
            marker = null;
        }
        if (token2.getWord().equals("AT")) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 58) {
                cobolToken = VariableName.get(this.tm, this.error, this.pc);
                if (cobolToken == null) {
                    throw new UnexpectedTokenException(this.tm.getToken(), this.error);
                }
                sqlSet = new SqlSet(this, token2, (VariableName)cobolToken, block, pcc, tokenManager, errors);
                token2 = this.tm.getToken();
            } else {
                cobolToken = new Token(token2);
                ((Token)cobolToken).setToknum(10001);
                ((Token)cobolToken).setWord("'" + token2.getWord().replace('-', '_') + "'");
                sqlSet = new SqlSet(this, (Token)cobolToken, null, block, pcc, tokenManager, errors);
                token2 = this.tm.getToken();
            }
        } else if (pcc.inProcedure && pcc.getOption("-xsqlc") != null || pcc.getOption("-xsqlc") == null && pcc.hasAnySqlDatabase()) {
            cobolToken = new Token(token2);
            ((Token)cobolToken).setToknum(10001);
            ((Token)cobolToken).setWord("'DEFAULT'");
            sqlSet = new SqlSet(this, (Token)cobolToken, null, block, pcc, tokenManager, errors);
        }
        if (token2.getToknum() == 494) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 58) {
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName == null) {
                    throw new UnexpectedTokenException(this.tm.getToken(), this.error);
                }
                token2 = this.tm.getToken();
            } else if (token2.getToknum() == 10002) {
                n2 = Integer.parseInt(token2.getWord());
                token2 = this.tm.getToken();
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
        if (token2.getWord().equals("BEGIN") || token2.getWord().equals("END")) {
            while ((token2 = this.tm.getToken()).getToknum() != 432) {
            }
        }
        this.tm.ungetToken();
        block34: while ((token2 = this.tm.getToken()).getToknum() != 432) {
            if (token2.getToknum() == 10021) continue;
            try {
                int n3 = ExecSql.getSqlToken(token2.getWord());
                if (block == null && n3 != 10108 && n3 != 10130) {
                    throw new GeneralErrorException(136, 4, token2, token2.getWord(), this.error);
                }
                if (ExecSql.getSqlToken(token2.getWord()) != 10110 && ExecSql.getSqlToken(token2.getWord()) != 10123 && ExecSql.getSqlToken(token2.getWord()) != 10109 && ExecSql.getSqlToken(token2.getWord()) != 10124 && ExecSql.getSqlToken(token2.getWord()) != 10125 && ExecSql.getSqlToken(token2.getWord()) != 10126 && (variableName != null || n2 != 0)) {
                    throw new GeneralErrorException(115, 4, token2, "FOR in " + token2.getWord(), this.error);
                }
                switch (ExecSql.getSqlToken(token2.getWord())) {
                    case 10102: {
                        this.stats.addItem(new SqlConnect(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10103: {
                        this.stats.addItem(new SqlDisconnect(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10104: {
                        this.isWhenever = true;
                        SqlWhenever sqlWhenever = new SqlWhenever(this, token2, block, pcc, tokenManager, errors);
                        this.stats.addItem(sqlWhenever);
                        if (sqlWhenever.isWarning()) {
                            this.pc.warning = sqlWhenever;
                            continue block34;
                        }
                        if (sqlWhenever.isNotFound()) {
                            this.pc.notFound = sqlWhenever;
                            continue block34;
                        }
                        this.pc.werror = sqlWhenever;
                        continue block34;
                    }
                    case 10105: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlCommit(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10106: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlRollback(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10125: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlSelect(this, token2, block, pcc, tokenManager, variableName, n2, errors, true));
                        continue block34;
                    }
                    case 10124: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlInsert(this, token2, block, pcc, tokenManager, variableName, n2, errors));
                        continue block34;
                    }
                    case 10108: {
                        Token token3;
                        boolean bl = false;
                        int n4 = 0;
                        int n5 = 0;
                        ++n5;
                        while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                            ++n5;
                        }
                        if ((tokenManager.getOptionList().getOption("-csdb2") != null || Config.b(".compiler.esql.db2", false)) && token3.getToknum() == 58) {
                            this.stats.addItem(new SqlDeclareVar(this, token2, pcc, tokenManager, errors));
                            continue block34;
                        }
                        if (token3.getWord().equals("GLOBAL")) {
                            ++n4;
                        }
                        ++n5;
                        while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                            ++n5;
                        }
                        if (token3.getWord().equals(".")) {
                            bl = true;
                            ++n5;
                            while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                                ++n5;
                            }
                            ++n5;
                            while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                                ++n5;
                            }
                        } else if (token3.getWord().equals("TEMPORARY")) {
                            ++n4;
                            ++n5;
                            while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                                ++n5;
                            }
                        }
                        if (token3.getWord().equals("SENSITIVE") || token3.getWord().equals("INSENSITIVE")) {
                            ++n5;
                            while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                                ++n5;
                            }
                        }
                        if (token3.getWord().equals("SCROLL")) {
                            ++n5;
                            while ((token3 = this.tm.getToken()) != null && token3.getToknum() == 10021) {
                                ++n5;
                            }
                        }
                        while (n5 > 0) {
                            this.tm.ungetToken();
                            --n5;
                        }
                        if (n4 == 2) {
                            this.tm.getToken();
                        }
                        if (token3.getWord().equals("CURSOR")) {
                            if (sqlSet != null) {
                                this.stats.addItem(sqlSet);
                            }
                            this.stats.addItem(new SqlDeclareCursor(this, token2, pcc, tokenManager, errors));
                            continue block34;
                        }
                        if (token3.getWord().equals("TABLE")) {
                            if (n4 != 2) {
                                new SqlGeneric(this, token2, block, pcc, tokenManager, errors);
                                continue block34;
                            }
                            if (sqlSet != null) {
                                this.stats.addItem(sqlSet);
                            }
                            this.tm.ungetToken();
                            this.stats.addItem(new SqlGeneric(this, token2, block, pcc, tokenManager, errors));
                            continue block34;
                        }
                        if (token3.getWord().equals("DATABASE")) {
                            new SqlDeclareDatabase(this, token2, pcc, tokenManager, errors);
                            continue block34;
                        }
                        if (token3.getWord().equals("STATEMENT")) {
                            new SqlDeclareCursor(this, token2, pcc, tokenManager, errors);
                            continue block34;
                        }
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                    case 10110: {
                        this.stats.addItem(new SqlFetch(this, token2, block, pcc, tokenManager, variableName, n2, errors));
                        continue block34;
                    }
                    case 10112: {
                        this.stats.addItem(new SqlOpen(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10123: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlDelete(this, token2, block, pcc, tokenManager, variableName, n2, errors));
                        continue block34;
                    }
                    case 10126: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlUpdate(this, token2, block, pcc, tokenManager, variableName, n2, errors));
                        continue block34;
                    }
                    case 10127: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlCall(this, token2, block, pcc, tokenManager, errors, marker));
                        continue block34;
                    }
                    case 10107: {
                        this.stats.addItem(new SqlPrepare(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10109: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlExecute(this, token2, block, pcc, tokenManager, variableName, n2, errors));
                        continue block34;
                    }
                    case 10111: {
                        this.stats.addItem(new SqlClose(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10115: 
                    case 10116: 
                    case 10117: 
                    case 10118: 
                    case 10119: 
                    case 10132: 
                    case 10133: {
                        if (sqlSet != null) {
                            this.stats.addItem(sqlSet);
                        }
                        this.stats.addItem(new SqlGeneric(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10121: {
                        continue block34;
                    }
                    case 10122: {
                        Token token4;
                        Token token3 = this.tm.getToken();
                        this.tm.ungetToken();
                        while ((token4 = this.tm.getToken()) != null && token4.getToknum() != 432) {
                            if (token4.getToknum() == 10021) continue;
                            this.tm.ungetToken();
                            this.stats.addItem(new SqlSet(this, token2, block, pcc, tokenManager, errors));
                        }
                        this.tm.ungetToken();
                        continue block34;
                    }
                    case 10101: 
                    case 10131: {
                        while ((token2 = this.tm.getToken()).getToknum() != 432) {
                        }
                        this.tm.ungetToken();
                        continue block34;
                    }
                    case 432: {
                        continue block34;
                    }
                    case 10113: {
                        this.stats.addItem(new SqlAllocate(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10114: {
                        this.stats.addItem(new SqlFree(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10130: {
                        this.stats.addItem(new SqlVar(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10120: {
                        this.stats.addItem(new SqlDescribe(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10134: {
                        if (tokenManager.getOptionList().getOption("-csdb2") != null || Config.b(".compiler.esql.db2", false)) {
                            this.stats.addItem(new SqlValue(this, token2, block, pcc, tokenManager, null, 0, errors, true));
                            continue block34;
                        }
                    }
                    case 10135: {
                        this.stats.addItem(new SqlWith(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10136: {
                        this.stats.addItem(new SqlSavepoint(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                    case 10137: {
                        this.stats.addItem(new SqlRelease(this, token2, block, pcc, tokenManager, errors));
                        continue block34;
                    }
                }
                throw new UnexpectedTokenException(token2, this.error);
            }
            catch (GeneralErrorException generalErrorException) {
                while (this.tm.getToken().getToknum() != 432) {
                }
                throw generalErrorException;
            }
        }
        tokenManager.inExecSql = false;
    }

    private void init() {
        if (lastPcc != this.pc) {
            Pcc pcc = this.pc instanceof CobolMethod ? this.pc : this.pc.parent;
            Token token = new Token(10009, "ESQL-CURS-HNDL", 0, 0, this.tm.getFileName());
            VariableDeclaration variableDeclaration = VariableDeclaration.getHandle(pcc, this.tm, token);
            this.pc.fixedVars.addItem(variableDeclaration);
            this.pc.loadVariable(variableDeclaration);
            variableDeclaration.setUsed();
            token = new Token(10009, "ESQL-BIND-IND", 0, 0, this.tm.getFileName());
            variableDeclaration = VariableDeclaration.getPicDefaultNum(pcc, this.tm, token, true);
            this.pc.fixedVars.addItem(variableDeclaration);
            this.pc.loadVariable(variableDeclaration);
            variableDeclaration.setUsed();
            token = new Token(10009, "ESQL-BIND-TYPE", 0, 0, this.tm.getFileName());
            variableDeclaration = VariableDeclaration.getPicDefaultNum(pcc, this.tm, token, true);
            this.pc.fixedVars.addItem(variableDeclaration);
            this.pc.loadVariable(variableDeclaration);
            variableDeclaration.setUsed();
            lastPcc = this.pc;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb verb = this.stats.getFirst();
        while (verb != null) {
            verb.check();
            verb = this.stats.getNext();
        }
        if (this.pcc.getOption("-sqlj") != null) {
            this.pcc.setSqlj();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isWhenever) {
            Verb verb = this.stats.getFirst();
            while (verb != null) {
                stringBuffer.append(verb.getCode());
                verb = this.stats.getNext();
            }
        }
        return stringBuffer.toString();
    }

    public VerbList getStatements() {
        return this.stats;
    }

    public SqlWhenever getWhenError() {
        return this.pc.werror;
    }

    public SqlWhenever getWhenWarn() {
        return this.pc.warning;
    }

    public SqlWhenever getWhenNotFound() {
        return this.pc.notFound;
    }

    static {
        sqlToken.put("INCLUDE", new Integer(10101));
        sqlToken.put("CONNECT", new Integer(10102));
        sqlToken.put("DISCONNECT", new Integer(10103));
        sqlToken.put("WHENEVER", new Integer(10104));
        sqlToken.put("COMMIT", new Integer(10105));
        sqlToken.put("ROLLBACK", new Integer(10106));
        sqlToken.put("PREPARE", new Integer(10107));
        sqlToken.put("DECLARE", new Integer(10108));
        sqlToken.put("EXECUTE", new Integer(10109));
        sqlToken.put("FETCH", new Integer(10110));
        sqlToken.put("CLOSE", new Integer(10111));
        sqlToken.put("OPEN", new Integer(10112));
        sqlToken.put("ALTER", new Integer(10115));
        sqlToken.put("CREATE", new Integer(10116));
        sqlToken.put("DROP", new Integer(10117));
        sqlToken.put("GRANT", new Integer(10118));
        sqlToken.put("REVOKE", new Integer(10119));
        sqlToken.put("ALLOCATE", new Integer(10113));
        sqlToken.put("FREE", new Integer(10114));
        sqlToken.put("DESCRIBE", new Integer(10120));
        sqlToken.put("GET", new Integer(10121));
        sqlToken.put("SET", new Integer(10122));
        sqlToken.put("DELETE", new Integer(10123));
        sqlToken.put("INSERT", new Integer(10124));
        sqlToken.put("SELECT", new Integer(10125));
        sqlToken.put("UPDATE", new Integer(10126));
        sqlToken.put("CALL", new Integer(10127));
        sqlToken.put("VAR", new Integer(10130));
        sqlToken.put("DEALLOCATE", new Integer(10131));
        sqlToken.put("TRUNCATE", new Integer(10132));
        sqlToken.put("LOCK", new Integer(10133));
        sqlToken.put("DESCRIBE", new Integer(10120));
        sqlToken.put("VALUES", new Integer(10134));
        sqlToken.put("WITH", new Integer(10135));
        sqlToken.put("SAVEPOINT", new Integer(10136));
        sqlToken.put("RELEASE", new Integer(10137));
    }
}

