/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Exit
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final int EXIT_FIRST = 0;
    static final int EXIT_PLAIN = 0;
    static final int EXIT_PROGRAM = 1;
    static final int EXIT_PARAGRAPH = 2;
    static final int EXIT_SECTION = 3;
    static final int EXIT_PERFORM = 4;
    static final int EXIT_PERFORM_CYCLE = 5;
    static final int EXIT_METHOD = 6;
    static final int EXIT_LAST = 6;
    private final int type;
    Token tk_returnval;
    VariableName vn_returnval;

    public Exit(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        switch (token2.getToknum()) {
            case 653: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                if (pcc instanceof CobolMethod) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "METHOD", this.error);
                }
                this.type = 1;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 505 || token2.getToknum() == 694) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 10002 || token2.getToknum() == 10017 || token2.getToknum() == 10001) {
                    this.tk_returnval = token2;
                    break;
                }
                if (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_returnval = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            case 630: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                this.type = 2;
                break;
            }
            case 709: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                this.type = 3;
                this.parent.parent.setExitSect(true);
                break;
            }
            case 632: {
                if (!this.parent.parent.inLoop()) {
                    throw new GeneralErrorException(85, 4, this.keyWord, "", this.error);
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() == 387) {
                    this.type = 5;
                    break;
                }
                this.type = 4;
                this.tm.ungetToken();
                break;
            }
            case 584: {
                if (!(pcc instanceof CobolMethod)) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "METHOD", this.error);
                }
                this.type = 6;
                break;
            }
            default: {
                this.tm.ungetToken();
                this.type = 0;
            }
        }
    }

    public Exit(int n2, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) {
        super(token, block, pcc, tokenManager, errors);
        if (n2 < 0 || n2 > 6) {
            throw new IllegalArgumentException();
        }
        this.type = n2;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.tm.getOptionList().getOption("-d") != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.isExitProgram()) {
            stringBuffer.append("if (Factory.isCalled(\"");
            stringBuffer.append(this.pc.getClassName());
            stringBuffer.append("\")) ");
            if (this.tk_returnval != null) {
                if (this.tk_returnval.getToknum() == 10002) {
                    stringBuffer.append("{");
                    stringBuffer.append(this.getReturnCode());
                    stringBuffer.append(".set (");
                    stringBuffer.append(this.getCodeLiteral(this.tk_returnval));
                    stringBuffer.append("); throw GobackException.go;}");
                } else {
                    stringBuffer.append("throw new GobackException(");
                    stringBuffer.append(this.getCodeLiteral(this.tk_returnval));
                    stringBuffer.append(");");
                }
            } else if (this.vn_returnval != null) {
                stringBuffer.append("throw new GobackException(");
                stringBuffer.append(this.vn_returnval.getCode());
                stringBuffer.append(");");
            } else {
                stringBuffer.append("throw GobackException.go;");
            }
        } else if (this.isExitParagraph()) {
            stringBuffer.append("if(true) ");
            if (bl) {
                stringBuffer.append("{ ");
                Paragraph.getDebugExitCode(stringBuffer);
                stringBuffer.append(" ");
            }
            int n2 = this.getDeferredMethodId() > 0 ? -4 : 0;
            stringBuffer.append(" return " + n2 + ";");
            if (bl) {
                stringBuffer.append(" }");
            }
        } else if (this.isExitSection()) {
            stringBuffer.append("if(true) ");
            if (bl) {
                stringBuffer.append("{ ");
                Paragraph.getDebugExitCode(stringBuffer);
                stringBuffer.append(" ");
            }
            stringBuffer.append(" throw ExitSectionException.go;");
            if (bl) {
                stringBuffer.append(" }");
            }
        } else if (this.isExitPerform()) {
            int n3 = this.parent.getParent().getParagraphCodeLimit();
            int n4 = 0;
            if (n3 > 0) {
                Verb verb = this.getParent().getParentVerb();
                while (verb != null && !(verb instanceof Perform)) {
                    verb = verb.getParent().getParentVerb();
                }
                n4 = verb.getDeferredMethodId();
            }
            if (n4 == this.getDeferredMethodId()) {
                if (this.isExitPerformCycle()) {
                    stringBuffer.append(this.parent.getExitPerformCycle());
                } else {
                    stringBuffer.append("if(true) break");
                    if (this.parent != null && this.parent.getParent() != null) {
                        stringBuffer.append(this.parent.getParent().getActPerf());
                    }
                    stringBuffer.append(";");
                }
            } else if (this.isExitPerformCycle()) {
                stringBuffer.append("if (true) return -2;");
            } else {
                stringBuffer.append("if (true) return -1;");
            }
        } else if (this.isExitMethod()) {
            stringBuffer.append("if(true) throw GobackException.go;");
        } else {
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isExitProgram() {
        return this.type == 1;
    }

    public boolean isExitParagraph() {
        return this.type == 2;
    }

    public boolean isExitSection() {
        return this.type == 3;
    }

    public boolean isExitPerform() {
        return this.type == 4 || this.type == 5;
    }

    public boolean isExitPerformCycle() {
        return this.type == 5;
    }

    public boolean isExitMethod() {
        return this.type == 6;
    }

    public boolean isExitPlain() {
        return this.type == 0;
    }
}

