/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InlineSetGetProperty;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Stack;

public class Expression
extends Verb
implements CobolToken,
ErrorsNumbers,
GenericObject,
IExpression {
    public static final int EX_UNKNOWN = 0;
    public static final int EX_BOOLEAN = 1;
    public static final int EX_STRING = 2;
    public static final int EX_NUMERIC = 3;
    public static final int EX_OBJECT = 4;
    public static final int EX_PRIMITIVE = 5;
    public static final byte DJ_END = 0;
    public static final byte DJ_PLUS = 1;
    public static final byte DJ_MINUS = 2;
    public static final byte DJ_MULTIPLY = 3;
    public static final byte DJ_DIVIDE = 4;
    public static final byte DJ_POW = 5;
    public static final byte DJ_UNARY_MINUS = 6;
    public static final byte DJ_OPEN_PAR = 7;
    public static final byte DJ_CLOSE_PAR = 8;
    public static final byte DJ_UNKNOWN = 9;
    private static final char[] djdescr = new char[]{'!', '+', '-', '*', '/', '^', '_', '(', ')', '?'};
    private static final int D_2STK = 1;
    private static final int D_2PFX = 2;
    private static final int D_POP = 3;
    private static final int D_STOP = 4;
    private static final int D_ERR = 5;
    static final int[][] decTab = new int[][]{{4, 1, 1, 1, 1, 1, 1, 1, 5}, {2, 2, 2, 1, 1, 1, 1, 1, 2}, {2, 2, 2, 1, 1, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 2, 1, 1, 2}, {5, 1, 1, 1, 1, 1, 1, 1, 3}};
    private Stack pfx;
    private boolean objectReference;
    private MyClass cType;
    private int type = 0;
    VariableName firstVar;
    private VariableNameList allVars = new VariableNameList();
    Token firstToken;
    boolean hasOperator;
    boolean varcheckdim;
    boolean checkdiv = true;
    int dmax = -1;
    private final Alphabet cs;
    final boolean cfp36;
    private final boolean cudc;
    private boolean ibmArithm;
    private final boolean cva2;

    @Override
    public VariableNameList getAllVars() {
        return this.allVars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public static boolean couldBeNativeInt(Token token) {
        return Expression.couldBeNativeInt(token, 9);
    }

    public static boolean couldBeNativeInt(Token token, int n2) {
        return token.getToknum() == 10002 && token.getBitLen() == 0 && token.getLength() <= n2;
    }

    public static String toNum(Token token) {
        int n2;
        String string = token.getCode();
        int n3 = string.length() - 1;
        for (n2 = 0; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
        }
        return (n2 == 0 ? string : string.substring(n2)) + "L";
    }

    public static boolean couldBeNativeInt(VariableDeclaration variableDeclaration) {
        MyClass myClass;
        try {
            myClass = variableDeclaration.getType();
        }
        catch (Exception exception) {
            myClass = null;
        }
        return myClass != null && (myClass.isAssignableTo(Long.TYPE) || myClass.isAssignableTo(Integer.TYPE) || myClass.isAssignableTo(Short.TYPE) || myClass.isAssignableTo(Character.TYPE) || myClass.isAssignableTo(Byte.TYPE) || myClass.isAssignableTo(Long.class) || myClass.isAssignableTo(Integer.class) || myClass.isAssignableTo(Short.class) || myClass.isAssignableTo(Character.class) || myClass.isAssignableTo(Byte.class));
    }

    private static boolean canUseLong(VariableDeclaration variableDeclaration) {
        if (!(variableDeclaration instanceof InlineSetGetProperty) && variableDeclaration.isInteger()) {
            if (variableDeclaration.isBinary()) {
                int n2 = variableDeclaration.getPhisicLen();
                return n2 < 8 || n2 == 8 && variableDeclaration.isSigned();
            }
            int n3 = variableDeclaration.getLogicLen();
            return n3 <= 18;
        }
        return false;
    }

    public Expression(int[] nArray, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, int n2) throws GeneralErrorException, EndOfProgramException {
        this(nArray, token, block, pcc, tokenManager, errors, true, false);
        this.dmax = n2;
    }

    public Expression(int[] nArray, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(nArray, token, block, pcc, tokenManager, errors, true, false);
    }

    public Expression(int[] nArray, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, boolean bl, boolean bl2) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        if (this.pc != null) {
            this.cs = this.pc.getProgramCollatingSeq();
            this.cfp36 = this.pc.getOption("-cfp36") != null;
            this.cudc = this.pc.getOption("-cudc") != null;
            this.cva2 = this.pc.getOption("-cva2") != null;
            this.ibmArithm = this.cva2 || this.pc.getOption("-cva") != null || this.pc.getOption("-xcv") != null;
        } else {
            this.cs = null;
            this.cfp36 = false;
            this.cudc = false;
            this.cva2 = false;
            this.ibmArithm = false;
        }
        this.varcheckdim = bl;
        int[] nArray2 = new int[]{nArray[0]};
        Stack<ExprItem> stack = new Stack<ExprItem>();
        this.findValue(stack, nArray2, -1, bl2);
        stack.add(new ExprItem(0));
        while (nArray2[0] < nArray[0]) {
            stack.add(0, new ExprItem(7));
            nArray[0] = nArray[0] - 1;
        }
        this.pfx = this.buildRPN(stack);
    }

    private void findOp(Stack stack, int[] nArray, int n2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken(false);
        switch (token.getToknum()) {
            case 42: {
                if (this.tm.getToken(false).getToknum() == 42) {
                    stack.add(new ExprItem(5));
                    if (this.cva2 && n2 < 0 && this.ibmArithm) {
                        this.ibmArithm = false;
                        this.findValue(stack, nArray, nArray[0], bl);
                    } else {
                        this.findValue(stack, nArray, n2, bl);
                    }
                } else {
                    this.tm.ungetToken();
                    stack.add(new ExprItem(3));
                    this.findValue(stack, nArray, n2, bl);
                }
                this.hasOperator = true;
                break;
            }
            case 47: {
                stack.add(new ExprItem(4));
                this.findValue(stack, nArray, n2, bl);
                this.hasOperator = true;
                break;
            }
            case 43: {
                stack.add(new ExprItem(1));
                this.findValue(stack, nArray, n2, bl);
                this.hasOperator = true;
                break;
            }
            case 45: {
                stack.add(new ExprItem(2));
                this.findValue(stack, nArray, n2, bl);
                this.hasOperator = true;
                break;
            }
            case 41: {
                if (nArray[0] > 0) {
                    nArray[0] = nArray[0] - 1;
                    if (n2 == nArray[0]) {
                        n2 = -1;
                    }
                    stack.add(new ExprItem(8));
                    this.findOp(stack, nArray, n2, bl);
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
    }

    private void findValue(Stack stack, int[] nArray, int n2, boolean bl) throws GeneralErrorException, EndOfProgramException {
        TokenManager.Marker marker = this.tm.getMarker();
        Token token = this.tm.getToken(false);
        if (token.getToknum() == 45) {
            stack.add(new ExprItem(6));
            token = this.tm.getToken(false);
            this.type = 3;
        } else if (token.getToknum() == 43) {
            token = this.tm.getToken(false);
            this.type = 3;
        }
        switch (token.getToknum()) {
            case 40: {
                nArray[0] = nArray[0] + 1;
                stack.add(new ExprItem(7));
                this.findValue(stack, nArray, n2, bl);
                break;
            }
            case 259: 
            case 10009: {
                this.tm.ungetToken();
                this.tm.setMarker(marker);
                GetVarOpts getVarOpts = bl ? GetVarOpts.DYN_GRP_ALLOW : GetVarOpts.NO_OPTS;
                VariableName variableName = this.varcheckdim ? VariableName.getAny(this.tm, this.error, this.parent, this.pc, getVarOpts) : VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, getVarOpts);
                if (variableName != null) {
                    if (variableName.getVarDecl() == null) {
                        throw new GeneralErrorException(180, 4, token, token.getWord(), this.error);
                    }
                    VariableDeclarationScreen.checkScreenName(variableName.getVarDecl(), token, this.error);
                    this.objectReference = variableName.isStrictPrimitive() ? false : (variableName.isPrimitiveWrapper() ? true : (variableName.getVarDecl() instanceof InlineInvoke ? !variableName.getVarDecl().isCobolVar() : variableName.isObjectReference()));
                    this.cType = variableName.getType();
                    if (variableName.isBoolean()) {
                        this.type = 1;
                        stack.add(new ExprItem(variableName));
                        this.addVar(variableName);
                        break;
                    }
                    if (variableName.isPrimitive()) {
                        try {
                            MyClass myClass = variableName.getType();
                            if (!(myClass.isAssignableTo(Long.TYPE) || myClass.isAssignableTo(Integer.TYPE) || myClass.isAssignableTo(Short.TYPE) || myClass.isAssignableTo(Character.TYPE) || myClass.isAssignableTo(Byte.TYPE) || myClass.isAssignableTo(Double.TYPE) || myClass.isAssignableTo(Float.TYPE))) {
                                throw new ClassNotFoundException();
                            }
                            this.type = 5;
                            stack.add(new ExprItem(variableName));
                            this.addVar(variableName);
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.tm.rewindToMarker(marker);
                        }
                    } else {
                        if (this.objectReference) {
                            this.type = 4;
                            stack.add(new ExprItem(variableName));
                            this.addVar(variableName);
                            break;
                        }
                        this.tm.rewindToMarker(marker);
                    }
                } else {
                    this.tm.rewindToMarker(marker);
                }
                variableName = VariableName.get(this.tm, this.error, this.parent, this.pc, this.varcheckdim, true, true, true, getVarOpts);
                stack.add(new ExprItem(variableName));
                this.addVar(variableName);
                VariableDeclaration variableDeclaration = variableName.getVarDecl();
                if (n2 >= 0 && this.cva2 && variableDeclaration.isInteger()) {
                    this.ibmArithm = true;
                }
                if (variableDeclaration.isNumeric() && !variableName.isEdited() && !variableName.hasSubValue()) {
                    switch (this.type) {
                        case 0: 
                        case 3: 
                        case 5: {
                            break;
                        }
                        default: {
                            throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                        }
                    }
                    if (this.type != 5) {
                        this.type = 3;
                    }
                } else {
                    this.type = Expression.isBoolean(variableName) ? 1 : 2;
                }
                if (n2 != nArray[0]) break;
                n2 = -1;
                break;
            }
            case 10001: {
                if (token.isNull()) {
                    this.type = 4;
                    this.objectReference = true;
                } else {
                    if (this.type == 3) {
                        throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                    }
                    this.type = 2;
                }
                stack.add(new ExprItem(token));
                if (this.firstToken != null) break;
                this.firstToken = token;
                break;
            }
            case 10002: 
            case 10017: {
                switch (this.type) {
                    case 0: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(122, 4, token, "", this.error);
                    }
                }
                stack.add(new ExprItem(token));
                if (this.type != 5) {
                    this.type = 3;
                }
                if (this.firstToken == null) {
                    this.firstToken = token;
                }
                if (n2 != nArray[0]) break;
                n2 = -1;
                break;
            }
            default: {
                this.tm.ungetToken();
                return;
            }
        }
        this.findOp(stack, nArray, n2, bl);
    }

    private static boolean isBoolean(VariableName variableName) {
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        if (variableDeclaration.level == 88) {
            return true;
        }
        if (variableDeclaration.isPic1()) {
            if (variableDeclaration.getLogicLen() == 1) {
                return true;
            }
            SubValueList subValueList = variableName.getSubValueList();
            try {
                if (subValueList != null && Integer.parseInt(subValueList.getLen()) == 1) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int setStringType() {
        if (this.type == 2) {
            return 0;
        }
        if (this.type == 3 && !this.hasOperator) {
            if (this.firstToken != null) {
                if (this.firstToken.getToknum() == 10002) {
                    this.type = 2;
                    return 0;
                }
                if (this.firstToken.getToknum() == 10017) {
                    this.type = 2;
                    return 3;
                }
            } else if (this.firstVar != null) {
                this.type = 2;
                VariableDeclaration variableDeclaration = this.firstVar.getVarDecl();
                if (variableDeclaration.is9Display() && variableDeclaration.isInteger()) {
                    return 0;
                }
                return 3;
            }
        } else if (this.firstToken != null && this.firstToken.isNull() && !this.hasOperator) {
            this.type = 2;
            return 0;
        }
        return 4;
    }

    public boolean setNumericType() {
        if (this.type == 3) {
            return true;
        }
        if (this.type == 4 && !this.hasOperator) {
            this.type = 3;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.type == 3;
    }

    @Override
    public boolean isString() {
        return this.type == 2;
    }

    @Override
    public String getCode() {
        return this.getCode(false);
    }

    public String getCode(boolean bl) {
        if (this.type == 2 && !this.hasOperator) {
            return ((ExprItem)this.pfx.peek()).getACode();
        }
        return this.buildCode(bl);
    }

    private void addVar(VariableName variableName) {
        if (this.firstVar == null) {
            this.firstVar = variableName;
        }
        this.allVars.addItem(variableName);
    }

    @Override
    public void check() throws GeneralErrorException {
        VariableName variableName = this.allVars.getFirst();
        while (variableName != null) {
            variableName.check();
            variableName = this.allVars.getNext();
        }
        int n2 = 0;
        block5: for (ExprItem exprItem : this.pfx) {
            if (exprItem.tk != null || exprItem.value != null) {
                ++n2;
                continue;
            }
            switch (exprItem.oper) {
                case 6: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    --n2;
                    continue block5;
                }
            }
            throw new InternalErrorException("buildCode oper=" + exprItem.oper);
        }
        if (n2 != 1) {
            throw new GeneralErrorException(122, 4, this.getKW(), this.getKW().getWord(), this.error);
        }
    }

    @Override
    public boolean isVoid() {
        return this.pfx.size() == 0;
    }

    private Stack buildRPN(Stack stack) throws GeneralErrorException {
        Stack<ExprItem> stack2 = new Stack<ExprItem>();
        Stack<ExprItem> stack3 = new Stack<ExprItem>();
        stack3.add(new ExprItem(0));
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            ExprItem exprItem = (ExprItem)iterator.next();
            if (exprItem.isValue()) {
                stack2.add(exprItem);
                continue;
            }
            boolean bl = true;
            block8: while (bl) {
                ExprItem exprItem2 = (ExprItem)stack3.peek();
                switch (decTab[exprItem2.oper][exprItem.oper]) {
                    case 1: {
                        stack3.add(exprItem);
                        bl = false;
                        continue block8;
                    }
                    case 2: {
                        stack2.add((ExprItem)stack3.pop());
                        continue block8;
                    }
                    case 3: {
                        stack3.pop();
                        bl = false;
                        continue block8;
                    }
                    case 4: {
                        if (iterator.hasNext()) {
                            throw new InternalErrorException("buildRPN I");
                        }
                        bl = false;
                        continue block8;
                    }
                    case 5: {
                        if (this.pc.getOption("-cv") != null) {
                            if (exprItem2.tk != null) {
                                this.error.print(44, 3, this.getKW(), this.getKW().getWord());
                            } else if (exprItem2.value != null) {
                                this.error.print(44, 3, exprItem2.value.name, exprItem2.value.name.getWord());
                            } else {
                                this.error.print(44, 3, this.getKW(), null);
                            }
                            bl = false;
                            continue block8;
                        }
                        throw new GeneralErrorException(44, 4, this.getKW(), this.getKW().getWord(), this.error);
                    }
                }
                throw new InternalErrorException("buildRPN III");
            }
        }
        return stack2;
    }

    private String buildCode(boolean bl) {
        Stack<ExprCode> stack = new Stack<ExprCode>();
        block7: for (ExprItem exprItem : this.pfx) {
            ExprCode exprCode;
            if (exprItem.tk != null) {
                if (exprItem.tk.isNull()) {
                    if (this.type == 3) {
                        exprItem.tk.setZero();
                        stack.add(new ExprCode(this.getCodeLiteral(exprItem.tk), 0, exprItem.isNative));
                        continue;
                    }
                    if (this.type == 2) {
                        stack.add(new ExprCode(this.getCodeLiteral(exprItem.tk), 0, exprItem.isNative));
                        continue;
                    }
                    stack.add(new ExprCode(exprItem.getCode(bl), exprItem.tk.getDecimals(), exprItem.isNative));
                    continue;
                }
                stack.add(new ExprCode(exprItem.getCode(bl), exprItem.tk.getDecimals(), exprItem.isNative));
                continue;
            }
            if (exprItem.value != null) {
                stack.add(new ExprCode(exprItem.getCode(bl), exprItem.value.getVarDecl().getDecimals(), exprItem.isNative));
                continue;
            }
            if (exprItem.oper == 6) {
                exprCode = (ExprCode)stack.peek();
                if (bl && exprCode.isNative) {
                    exprCode.code = "-" + exprCode.code;
                    continue;
                }
                exprCode.code = exprCode.code + ".negate()";
                continue;
            }
            ExprCode exprCode2 = (ExprCode)stack.pop();
            exprCode = (ExprCode)stack.pop();
            switch (exprItem.oper) {
                case 1: {
                    if (bl && exprCode.isNative && exprCode2.isNative) {
                        stack.add(new ExprCode("(" + exprCode + "+" + exprCode2 + ")", Math.max(exprCode.dec, exprCode2.dec), true));
                        continue block7;
                    }
                    stack.add(new ExprCode(exprCode + ".add(" + exprCode2 + ")", Math.max(exprCode.dec, exprCode2.dec), false));
                    continue block7;
                }
                case 2: {
                    if (bl && exprCode.isNative && exprCode2.isNative) {
                        stack.add(new ExprCode("(" + exprCode + "-" + exprCode2 + ")", Math.max(exprCode.dec, exprCode2.dec), true));
                        continue block7;
                    }
                    stack.add(new ExprCode(exprCode + ".subtract(" + exprCode2 + ")", Math.max(exprCode.dec, exprCode2.dec), false));
                    continue block7;
                }
                case 3: {
                    if (bl && exprCode.isNative && exprCode2.isNative) {
                        stack.add(new ExprCode("(" + exprCode + "*" + exprCode2 + ")", exprCode.dec + exprCode2.dec, true));
                        continue block7;
                    }
                    if (this.cfp36) {
                        stack.add(new ExprCode(exprCode + ".multiply36(" + exprCode2 + ")", exprCode.dec + exprCode2.dec, false));
                        continue block7;
                    }
                    stack.add(new ExprCode(exprCode + ".multiply(" + exprCode2 + ")", exprCode.dec + exprCode2.dec, false));
                    continue block7;
                }
                case 4: {
                    if (bl && exprCode.isNative && exprCode2.isNative) {
                        stack.add(new ExprCode("(" + exprCode + "/" + exprCode2 + ")", exprCode.dec + exprCode2.dec, true));
                        continue block7;
                    }
                    int n2 = Math.max(this.dmax, exprCode.dec - exprCode2.dec);
                    if (this.dmax >= 0 && this.ibmArithm) {
                        if (this.cfp36) {
                            stack.add(new ExprCode(exprCode + ".divide36(" + this.checkdiv + "," + exprCode2 + "," + n2 + ")", n2, false));
                            continue block7;
                        }
                        stack.add(new ExprCode(exprCode + ".divide(" + this.checkdiv + "," + exprCode2 + "," + n2 + ")", n2, false));
                        continue block7;
                    }
                    if (this.cfp36) {
                        stack.add(new ExprCode(exprCode + ".divide36(" + this.checkdiv + "," + exprCode2 + ")", n2, false));
                        continue block7;
                    }
                    stack.add(new ExprCode(exprCode + ".divide(" + this.checkdiv + "," + exprCode2 + ")", n2, false));
                    continue block7;
                }
                case 5: {
                    if (bl && exprCode.isNative && exprCode2.isNative) {
                        stack.add(new ExprCode("(long)Math.pow(" + exprCode + "," + exprCode2 + ")", this.dmax, true));
                        continue block7;
                    }
                    stack.add(new ExprCode(exprCode + ".pow(" + exprCode2 + ")", this.dmax, false));
                    continue block7;
                }
            }
            throw new InternalErrorException("buildCode oper=" + exprItem.oper);
        }
        if (stack.size() != 1) {
            throw new InternalErrorException("buildCode stk.size =" + stack.size());
        }
        return stack.pop().toString();
    }

    @Override
    public Token getAsToken() {
        if (!this.hasOperator) {
            return this.firstToken;
        }
        return null;
    }

    @Override
    public VariableName getAsVar() {
        if (!this.hasOperator) {
            return this.allVars.getFirst();
        }
        return null;
    }

    public boolean isNull() {
        Token token = this.getAsToken();
        return token != null && token.isNull();
    }

    public Token getKW() {
        if (this.firstToken != null) {
            return this.firstToken;
        }
        if (this.firstVar != null) {
            return this.firstVar.name;
        }
        Token token = new Token(this.keyWord);
        token.setWord("()");
        return token;
    }

    public String toString() {
        if (this.hasOperator) {
            return this.getKW().getOriginalWord() + " ...";
        }
        return this.getKW().getOriginalWord();
    }

    public Stack getPFX() {
        return this.pfx;
    }

    public boolean couldBeNativeInt() {
        boolean bl;
        if (this.type == 2 && !this.hasOperator) {
            bl = false;
        } else if (this.cfp36) {
            bl = false;
        } else {
            bl = true;
            for (ExprItem exprItem : this.pfx) {
                bl &= exprItem.couldBeNativeInt();
            }
        }
        return bl;
    }

    public boolean couldBeNative() {
        boolean bl;
        if (this.type == 2 && !this.hasOperator) {
            bl = false;
        } else if (this.cfp36) {
            bl = false;
        } else {
            bl = true;
            for (ExprItem exprItem : this.pfx) {
                bl &= exprItem.couldBeNative();
            }
        }
        return bl;
    }

    public boolean hasDivideByZero() throws GeneralErrorException {
        boolean bl = true;
        ExprItem exprItem = null;
        Iterator iterator = this.pfx.iterator();
        while (iterator.hasNext()) {
            ExprItem exprItem2 = exprItem;
            exprItem = (ExprItem)iterator.next();
            if (exprItem2 != null && exprItem.value != null) {
                bl = true;
            }
            if (exprItem.oper != 4) continue;
            if (exprItem2.value != null) {
                return true;
            }
            if (exprItem2.tk == null && bl) {
                return true;
            }
            if (exprItem2.tk == null || !exprItem2.tk.getWord().equals("0")) continue;
            return true;
        }
        return false;
    }

    public void setNull() {
        this.firstToken.setNull((char)this.tm.getLowValue());
        this.type = 4;
        this.objectReference = true;
    }

    public void setObject() {
        this.type = 4;
        this.objectReference = true;
    }

    @Override
    public boolean isObjectReference() {
        return this.objectReference;
    }

    @Override
    public MyClass getCType() {
        return this.cType;
    }

    public boolean isJavaString() {
        return this.cType != null && this.cType.isAssignableTo(String.class);
    }

    public boolean isJavaNumericWrapper() {
        return this.cType != null && (this.cType.isPrimitiveNumericWrapper() || this.cType.isClass(BigDecimal.class) || this.cType.isClass(BigInteger.class));
    }

    public boolean isPrimitiveInteger() {
        return this.cType != null && this.cType.isPrimitiveInteger();
    }

    public ExprItem[] getExpressionItems() {
        ExprItem[] exprItemArray = new ExprItem[this.pfx.size()];
        this.pfx.toArray(exprItemArray);
        return exprItemArray;
    }

    @Override
    public boolean isUniversal() {
        return false;
    }

    @Override
    public boolean isCobolVar() {
        return this.cType != null && this.cType.isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        return this.cType != null && this.cType.isNumericVar();
    }

    @Override
    public boolean isPrimitive() {
        return this.cType != null && this.cType.isPrimitive();
    }

    public boolean isPrimitiveWrapper() {
        return this.cType != null && this.cType.isPrimitiveWrapper();
    }

    @Override
    public boolean isFactory() {
        return false;
    }

    @Override
    public boolean isSuper() {
        return false;
    }

    @Override
    public boolean isSelf() {
        return false;
    }

    @Override
    public VariableName getVariableName() {
        return this.getAsVar();
    }

    private static class ExprCode {
        String code;
        final int dec;
        boolean isNative;

        ExprCode(String string, int n2, boolean bl) {
            this.code = string;
            this.dec = n2;
            this.isNative = bl;
        }

        public String toString() {
            return this.code;
        }
    }

    public class ExprItem {
        final Token tk;
        final VariableName value;
        final int oper;
        boolean isNative;

        ExprItem(Token token) {
            this(token, null, 9);
        }

        ExprItem(VariableName variableName) {
            this(null, variableName, 9);
        }

        ExprItem(byte by) {
            this(null, null, by);
        }

        private ExprItem(Token token, VariableName variableName, byte by) {
            this.tk = token;
            this.value = variableName;
            this.oper = by;
        }

        boolean isValue() {
            return this.tk != null || this.value != null;
        }

        public String getACode() {
            if (this.tk != null) {
                return Expression.this.getCodeLiteral(this.tk);
            }
            return this.getCode(false);
        }

        public boolean couldBeNativeInt() {
            if (this.tk != null) {
                if (Expression.this.cfp36) {
                    this.isNative = false;
                } else {
                    switch (this.tk.getToknum()) {
                        case 10002: {
                            if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        default: {
                            this.isNative = false;
                            break;
                        }
                    }
                }
            } else if (this.value != null) {
                VariableDeclaration variableDeclaration = this.value.getVarDecl();
                this.isNative = Expression.this.type == 5 ? Expression.couldBeNativeInt(variableDeclaration) : (Expression.this.type == 3 ? !Expression.this.cfp36 && Expression.canUseLong(variableDeclaration) : false);
            } else {
                this.isNative = this.oper == 4 ? false : !Expression.this.cfp36;
            }
            return this.isNative;
        }

        public boolean couldBeNative() {
            if (this.tk != null) {
                if (Expression.this.cfp36) {
                    this.isNative = false;
                } else {
                    switch (this.tk.getToknum()) {
                        case 10002: 
                        case 10017: {
                            if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        case 10001: {
                            if (this.tk.isNull()) {
                                this.isNative = false;
                                break;
                            }
                            if (this.tk.getLength() == 1) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        default: {
                            this.isNative = false;
                            break;
                        }
                    }
                }
            } else {
                MyClass myClass;
                this.isNative = this.value != null ? (Expression.this.type == 5 ? (myClass = this.value.getType()) != null && (myClass.isAssignableTo(Long.TYPE) || myClass.isAssignableTo(Integer.TYPE) || myClass.isAssignableTo(Short.TYPE) || myClass.isAssignableTo(Character.TYPE) || myClass.isAssignableTo(Byte.TYPE) || myClass.isAssignableTo(Float.TYPE) || myClass.isAssignableTo(Double.TYPE) || myClass.isAssignableTo(Long.class) || myClass.isAssignableTo(Integer.class) || myClass.isAssignableTo(Short.class) || myClass.isAssignableTo(Character.class) || myClass.isAssignableTo(Byte.class) || myClass.isAssignableTo(Float.class) || myClass.isAssignableTo(Double.class)) : (Expression.this.type == 3 ? !Expression.this.cfp36 && Expression.canUseLong(this.value.getVarDecl()) : false)) : (this.oper == 4 ? false : !Expression.this.cfp36);
            }
            return this.isNative;
        }

        public String getCode(boolean bl) {
            VariableDeclaration variableDeclaration;
            VariableDeclaration variableDeclaration2 = variableDeclaration = this.value != null ? this.value.getVarDecl() : null;
            if (this.tk != null) {
                switch (this.tk.getToknum()) {
                    case 10001: {
                        if (this.tk.isNull()) {
                            if (Expression.this.type == 3) {
                                this.tk.setZero();
                                return Expression.this.getCodeLiteral(this.tk);
                            }
                            if (Expression.this.type == 2) {
                                return Expression.this.getCodeLiteral(this.tk);
                            }
                            return "null";
                        }
                        return Expression.this.getCodeLiteral(this.tk);
                    }
                    case 10002: {
                        if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0 && !Expression.this.cfp36) {
                            if (Expression.this.pc.optionMS) {
                                if (bl) {
                                    return Expression.this.getCodeLiteral(this.tk) + ".tolong()";
                                }
                                return Expression.this.getCodeLiteral(this.tk) + ".num()";
                            }
                            if (bl) {
                                return Expression.this.getCodeLiteral(this.tk) + ".theValue.lnUnscValue";
                            }
                            return Expression.this.getCodeLiteral(this.tk) + ".theValue";
                        }
                        return Expression.this.getCodeLiteral(this.tk) + ".num()";
                    }
                    case 10017: {
                        if (bl) {
                            return Expression.this.getCodeLiteral(this.tk) + ".todouble()";
                        }
                        return Expression.this.getCodeLiteral(this.tk) + ".num()";
                    }
                }
                return Expression.this.getCodeLiteral(this.tk);
            }
            if (this.value != null) {
                if (variableDeclaration.level == 88) {
                    if (Expression.this.pc.optionMS) {
                        return variableDeclaration.getUnivoqueName() + ".get()";
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    SimpleCondition.NameAndLen nameAndLen = null;
                    if (Expression.this.cudc) {
                        nameAndLen = SimpleCondition.NameAndLen.get(this.value);
                    }
                    boolean bl2 = !Expression.this.cudc && Expression.canUseLong(this.value.getVarDecl().getParent());
                    stringBuffer.append("(");
                    for (int i2 = 0; i2 < variableDeclaration.getValuesCount(); ++i2) {
                        SimpleCondition.NameAndLen nameAndLen2;
                        Token token = variableDeclaration.getHighValue(i2);
                        Token token2 = variableDeclaration.getLowValue(i2);
                        boolean bl3 = bl = bl2 && Expression.couldBeNativeInt(token2, 18) && (token == null || Expression.couldBeNativeInt(token, 18));
                        if (i2 > 0) {
                            stringBuffer.append(" || ");
                        }
                        if (bl) {
                            stringBuffer.append("(");
                            stringBuffer.append(this.value.getCode88());
                            stringBuffer.append(".tolong() ");
                            if (token != null) {
                                stringBuffer.append(">= ");
                                stringBuffer.append(Expression.this.getCodeLiteral(token2));
                                stringBuffer.append(".theValue.lnUnscValue && ");
                                stringBuffer.append(this.value.getCode88());
                                stringBuffer.append(".tolong() <= ");
                                stringBuffer.append(Expression.this.getCodeLiteral(token));
                            } else {
                                stringBuffer.append("== ");
                                stringBuffer.append(Expression.this.getCodeLiteral(token2));
                            }
                            stringBuffer.append(".theValue.lnUnscValue)");
                            continue;
                        }
                        if (token != null) {
                            stringBuffer.append("(");
                            if (nameAndLen != null && (nameAndLen2 = SimpleCondition.NameAndLen.get(Expression.this.tm, token2)) != null && SimpleCondition.getUDisplayCond(nameAndLen, nameAndLen2, 3, stringBuffer, Expression.this.cs)) {
                                stringBuffer.append(" && ");
                            } else {
                                stringBuffer.append(this.value.getCode88());
                                stringBuffer.append(".compareTo(");
                                stringBuffer.append(Expression.this.getCodeLiteral(token2));
                                if (Expression.this.cs != null) {
                                    stringBuffer.append("," + Expression.this.cs.getDeclUnivoqueName());
                                }
                                stringBuffer.append(") >= 0 && ");
                            }
                            if (nameAndLen != null && (nameAndLen2 = SimpleCondition.NameAndLen.get(Expression.this.tm, token)) != null && SimpleCondition.getUDisplayCond(nameAndLen, nameAndLen2, 4, stringBuffer, Expression.this.cs)) {
                                stringBuffer.append(")");
                                continue;
                            }
                            stringBuffer.append(this.value.getCode88());
                            stringBuffer.append(".compareTo(");
                            stringBuffer.append(Expression.this.getCodeLiteral(token));
                            if (Expression.this.cs != null) {
                                stringBuffer.append("," + Expression.this.cs.getDeclUnivoqueName());
                            }
                            stringBuffer.append(") <= 0)");
                            continue;
                        }
                        if (nameAndLen != null && (nameAndLen2 = SimpleCondition.NameAndLen.get(Expression.this.tm, token2)) != null && SimpleCondition.getUDisplayCond(nameAndLen, nameAndLen2, 1, stringBuffer, Expression.this.cs)) continue;
                        stringBuffer.append(this.value.getCode88());
                        stringBuffer.append(".compareTo(");
                        stringBuffer.append(Expression.this.getCodeLiteral(token2));
                        if (Expression.this.cs != null) {
                            stringBuffer.append("," + Expression.this.cs.getDeclUnivoqueName());
                        }
                        stringBuffer.append(") == 0");
                    }
                    stringBuffer.append(")");
                    return stringBuffer.toString();
                }
                if (Expression.this.type == 5) {
                    if (this.value.isNumericVar()) {
                        return this.value.getCode() + ".num()";
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    MyClass myClass = this.value.getType();
                    if (bl) {
                        if (myClass != null && (myClass.isAssignableTo(Long.TYPE) || myClass.isAssignableTo(Integer.TYPE) || myClass.isAssignableTo(Short.TYPE) || myClass.isAssignableTo(Character.TYPE) || myClass.isAssignableTo(Byte.TYPE) || myClass.isAssignableTo(Long.class) || myClass.isAssignableTo(Integer.class) || myClass.isAssignableTo(Short.class) || myClass.isAssignableTo(Character.class) || myClass.isAssignableTo(Byte.class) || myClass.isAssignableTo(Double.TYPE) || myClass.isAssignableTo(Float.TYPE) || myClass.isAssignableTo(Double.class) || myClass.isAssignableTo(Float.class))) {
                            stringBuffer.append(this.value.getCode());
                        }
                    } else {
                        stringBuffer.append("(CobolNum.noo(");
                        if (myClass != null) {
                            if (myClass.isAssignableTo(Long.TYPE) || myClass.isAssignableTo(Integer.TYPE) || myClass.isAssignableTo(Short.TYPE) || myClass.isAssignableTo(Character.TYPE) || myClass.isAssignableTo(Byte.TYPE) || myClass.isAssignableTo(Long.class) || myClass.isAssignableTo(Integer.class) || myClass.isAssignableTo(Short.class) || myClass.isAssignableTo(Character.class) || myClass.isAssignableTo(Byte.class)) {
                                stringBuffer.append("(long)");
                                stringBuffer.append(this.value.getCode());
                                stringBuffer.append(",0))");
                            } else if (myClass.isAssignableTo(Double.TYPE) || myClass.isAssignableTo(Float.TYPE) || myClass.isAssignableTo(Double.class) || myClass.isAssignableTo(Float.class)) {
                                stringBuffer.append("(double)");
                                stringBuffer.append(this.value.getCode());
                                stringBuffer.append("))");
                            }
                        }
                    }
                    return stringBuffer.toString();
                }
                if (Expression.this.type == 3) {
                    if (Expression.canUseLong(variableDeclaration)) {
                        if (Expression.this.pc.optionMS || variableDeclaration.isAccessedByAddress()) {
                            if (bl) {
                                return this.value.getCode(true) + ".tolong()";
                            }
                            return this.value.getCode() + ".num()";
                        }
                        if (bl) {
                            return this.value.getCode() + ".theValue.lnUnscValue";
                        }
                        return this.value.getCode() + ".theValue";
                    }
                    return this.value.getCode() + ".num()";
                }
                if (Expression.this.type == 1 && this.value.getVarDecl().isPic1()) {
                    return this.value.getCode() + ".isTrue()";
                }
                return this.value.getCode();
            }
            return "###";
        }

        public String toString() {
            if (this.value != null) {
                return this.value.getName();
            }
            if (this.tk != null) {
                return this.tk.getWord();
            }
            return "" + djdescr[this.oper];
        }

        public Token getToken() {
            return this.tk;
        }

        public VariableName getVariable() {
            return this.value;
        }

        public int getOperation() {
            return this.oper;
        }
    }
}

