/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EfdHint;
import com.iscobol.compiler.EfdHintContainer;
import com.iscobol.compiler.EfdParser;
import com.iscobol.compiler.EfdWhen;
import com.iscobol.compiler.EfdWhenContainer;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.PList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.interfaces.compiler.IFileDescriptorExtension;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.IVariableDeclarationList;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.interfaces.compiler.ThreadLocal;
import com.iscobol.rts.Config;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class FileDescriptor
implements CobolToken,
EfdHintContainer,
EfdWhenContainer,
ErrorsNumbers,
IDataSection,
IFileDescriptorExtension,
ThreadLocal {
    private boolean isSortDescriptor;
    private boolean isXmlDescriptor;
    private TokenManager tm;
    private Errors error;
    Token fileName;
    private boolean isExternal;
    private Token external;
    private boolean isGlobal;
    private int blockMin;
    private int blockMax;
    int recordMin;
    private int recordMax;
    private VariableName depending;
    private int dependingOffs;
    private boolean isBlockRecords;
    private boolean isVarying;
    private boolean anyLength;
    private VariableDeclaration virtualParent;
    VariableDeclarationList recordDesc = new VariableDeclarationList();
    public String byteDecl;
    Select sel;
    private Pcc pc;
    private Token tkLinage;
    private VariableName vnLinage;
    private Token tkFooting;
    private VariableName vnFooting;
    private Token tkTop;
    private VariableName vnTop;
    private Token tkBottom;
    private VariableName vnBottom;
    private int efdWhenCounter;
    private Vector efdWhenList;
    private String alwaysTab = null;
    private int efdHintCounter;
    private Vector efdHintList;
    private EfdParser efdExtraInfo;
    private TokenList reports;
    private boolean optionXMS;
    private Alphabet codeSet;
    Token PAGE_COUNTER;
    Token LINE_COUNTER;
    Token PRINT_SWITCH;
    boolean threadLocal;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileDescriptor(Token token, Pcc pcc, TokenManager tokenManager, Errors errors, boolean bl) throws GeneralErrorException, EndOfProgramException {
        CobolToken cobolToken;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        boolean bl2 = this.optionXMS = tokenManager.getOptionList().getOption("-xms") != null;
        if (this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.b(".compiler.easydb", false)) {
            boolean bl3 = false;
            if (this.tm.getOptionList().getOption("-efc") != null) {
                bl3 = true;
            }
            if ((cobolToken = this.tm.delExtraInfo("XFD")) != null || (cobolToken = this.tm.delExtraInfo("EFD")) != null) {
                this.efdExtraInfo = new EfdParser((TokenList)cobolToken, bl3, this.error);
            }
        }
        this.isXmlDescriptor = bl;
        if (token.getToknum() == 707) {
            this.isSortDescriptor = true;
        }
        if ((token = this.tm.getToken()).getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.fileName = token;
        this.virtualParent = new VariableDeclaration(this.pc, this.fileName, this.tm);
        this.virtualParent.setParentSection(this);
        this.virtualParent.setFdVirtualParent(true);
        this.virtualParent.setUsed();
        this.sel = this.pc.getSelect(this.fileName.getWord());
        if (this.sel == null) {
            this.error.print(53, 4, this.fileName, this.fileName.getWord());
            this.sel = new Select();
        } else if (this.isSortDescriptor) {
            if (this.sel.isXml()) {
                this.error.print(102, 3, token, "SD treated as XD");
                this.isXmlDescriptor = true;
                this.isSortDescriptor = false;
            } else if (!this.sel.isSort() && this.sel.organization != 717) {
                this.error.print(102, 3, token, "SD treated as FD");
                this.isSortDescriptor = false;
            }
        } else if (this.isXmlDescriptor) {
            if (this.sel.isSort()) {
                this.error.print(289, 3, token, "XD treated as SD");
                this.isXmlDescriptor = false;
                this.isSortDescriptor = true;
            } else if (!this.sel.isXml()) {
                this.error.print(289, 3, token, "XD treated as FD");
                this.isXmlDescriptor = false;
            }
        } else if (this.sel.isSort()) {
            this.error.print(290, 3, token, "FD treated as SD");
            this.isSortDescriptor = true;
        } else if (this.sel.isXml()) {
            this.error.print(291, 3, token, "FD treated as XD");
            this.isXmlDescriptor = true;
        }
        if (this.isSortDescriptor) {
            this.pc.setHasSort();
        }
        block15: while ((token = this.tm.getToken()).getToknum() != 10006) {
            switch (token.getToknum()) {
                case 545: {
                    continue block15;
                }
                case 764: {
                    this.threadLocal = true;
                    continue block15;
                }
                case 478: {
                    this.isExternal = true;
                    token = this.tm.getToken();
                    if (token.getToknum() == 280) {
                        token = this.tm.getToken();
                        if (token.getToknum() != 10009) {
                            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                        }
                        this.external = token;
                        continue block15;
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 502: {
                    this.isGlobal = true;
                    this.virtualParent.setGlobal();
                    continue block15;
                }
                case 671: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 587) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009 && ("V".equals(token.getWord()) || "F".equals(token.getWord()) || "U".equals(token.getWord()) || "S".equals(token.getWord()) || "FIXED".equals(token.getWord()) || "VARIABLE".equals(token.getWord()))) continue block15;
                    throw new UnexpectedTokenException(token, errors);
                }
                case 553: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 670 && token.getToknum() != 672) throw new ExpectedFoundException(token, this.error, "RECORD");
                    token = this.tm.getToken();
                    if (token.getToknum() == 545 || token.getToknum() == 277) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 612 || token.getToknum() == 739) continue block15;
                    throw new ExpectedFoundException(token, this.error, "OMITTED,STANDARD");
                }
                case 307: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 370) {
                        token = this.tm.getToken();
                    }
                    if (!Token.isIntLit(token)) {
                        throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                    }
                    this.blockMin = Integer.parseInt(token.getWord());
                    token = this.tm.getToken();
                    if (token.getToknum() == 773) {
                        token = this.tm.getToken();
                        if (!Token.isIntLit(token)) {
                            throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                        }
                        this.blockMax = Integer.parseInt(token.getWord());
                        if (this.blockMax < this.blockMin) {
                            throw new GeneralErrorException(30, 4, token, "BLOCK", this.error);
                        }
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 672) {
                        this.isBlockRecords = true;
                        continue block15;
                    }
                    if (token.getToknum() == 324) continue block15;
                    this.tm.ungetToken();
                    continue block15;
                }
                case 670: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 370 || token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 807) {
                        this.isVarying = true;
                        token = this.tm.getToken();
                        if (token.getToknum() == 526) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 728) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 498) {
                            token = this.tm.getToken();
                        }
                        if (Token.isIntLit(token)) {
                            this.recordMin = Integer.parseInt(token.getWord());
                            token = this.tm.getToken();
                        } else {
                            this.recordMin = 0;
                        }
                        if (token.getToknum() == 773) {
                            token = this.tm.getToken();
                            if (!Token.isIntLit(token)) {
                                throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                            }
                            this.recordMax = Integer.parseInt(token.getWord());
                            if (this.recordMax < this.recordMin) {
                                throw new GeneralErrorException(30, 4, token, "", this.error);
                            }
                        } else {
                            this.tm.ungetToken();
                        }
                        if ((token = this.tm.getToken()).getToknum() == 324) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 400) {
                            token = this.tm.getToken();
                            if (token.getToknum() != 613) {
                                this.tm.ungetToken();
                            }
                            this.depending = VariableName.get(this.tm, this.error);
                            if (this.depending != null) continue block15;
                            throw new GeneralErrorException(21, 4, token, token.getWord(), this.error);
                        }
                        this.tm.ungetToken();
                        continue block15;
                    }
                    if (!Token.isIntLit(token)) throw new UnexpectedTokenException(token, errors);
                    this.recordMax = this.recordMin = Integer.parseInt(token.getWord());
                    token = this.tm.getToken();
                    if (token.getToknum() == 773) {
                        token = this.tm.getToken();
                        if (!Token.isIntLit(token)) {
                            throw new GeneralErrorException(22, 4, token, token.getWord(), this.error);
                        }
                        this.recordMax = Integer.parseInt(token.getWord());
                        if (this.recordMax < this.recordMin) {
                            throw new GeneralErrorException(30, 4, token, "", this.error);
                        }
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 324) continue block15;
                    this.tm.ungetToken();
                    continue block15;
                }
                case 803: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 609) throw new ExpectedFoundException(token, this.error, "OF");
                    token = this.tm.getToken();
                    if (token.getToknum() != 553 && token.getToknum() != 521 && token.getToknum() != 10001 && token.getToknum() != 484) throw new ExpectedFoundException(token, this.error, "LABEL,FILE-ID,ID");
                    cobolToken = token;
                    token = this.tm.getToken();
                    if (token.getToknum() == 545 || token.getToknum() == 277) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() != 10009 && token.getToknum() != 10001) {
                        throw new ExpectedFoundException(token, this.error, "USERNAME, STR_LITERAL");
                    }
                    if (((Token)cobolToken).getToknum() != 521 && ((Token)cobolToken).getToknum() != 484) continue block15;
                    if (token.getToknum() == 10001) {
                        this.sel.setOpSysName(token);
                        continue block15;
                    }
                    if (token.getToknum() != 10009) continue block15;
                    this.sel.setOpSysName(token);
                    this.tm.ungetToken();
                    this.sel.setOpSysNameVar(VariableName.get(this.tm, this.error));
                    continue block15;
                }
                case 564: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.vnLinage = VariableName.get(this.tm, this.error);
                        if (this.vnLinage == null) {
                            throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                        }
                    } else {
                        if (!Token.isIntLit(token)) throw new ExpectedFoundException(token, this.error, "USERNAME, INT_LITERAL");
                        this.tkLinage = token;
                    }
                    if ((token = this.tm.getToken()).getToknum() != 566) {
                        this.tm.ungetToken();
                    }
                    if ((token = this.tm.getToken()).getToknum() == 813 || token.getToknum() == 493) {
                        if (token.getToknum() == 813) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() != 493) throw new ExpectedFoundException(token, this.error, "FOOTING");
                        token = this.tm.getToken();
                        if (token.getToknum() == 284) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnFooting = VariableName.get(this.tm, this.error);
                            if (this.vnFooting == null) {
                                throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                            }
                        } else {
                            if (!Token.isIntLit(token)) throw new ExpectedFoundException(token, this.error, "USERNAME, INT_LITERAL");
                            this.tkFooting = token;
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    if ((token = this.tm.getToken()).getToknum() == 566) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 284) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 775) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnTop = VariableName.get(this.tm, this.error);
                            if (this.vnTop == null) {
                                throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                            }
                        } else {
                            if (!Token.isIntLit(token)) throw new ExpectedFoundException(token, this.error, "USERNAME, INT_LITERAL");
                            this.tkTop = token;
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    if ((token = this.tm.getToken()).getToknum() == 566) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 284) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 309) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnBottom = VariableName.get(this.tm, this.error);
                            if (this.vnBottom != null) continue block15;
                            throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                        }
                        if (!Token.isIntLit(token)) throw new ExpectedFoundException(token, this.error, "USERNAME, INT_LITERAL");
                        this.tkBottom = token;
                        continue block15;
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 388: {
                    token = this.tm.getToken();
                    if (token.getToknum() != 670 && token.getToknum() != 672) throw new ExpectedFoundException(token, this.error, "RECORD");
                    token = this.tm.getToken();
                    if (token.getToknum() == 545 || token.getToknum() == 277) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() != 10009) {
                        throw new ExpectedFoundException(token, this.error, "USERNAME");
                    }
                    while (token.getToknum() == 10009) {
                        token = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 684: 
                case 685: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 545 || token.getToknum() == 277) {
                        token = this.tm.getToken();
                    }
                    this.reports = new TokenList();
                    while (token.getToknum() == 10009) {
                        this.reports.addItem(token);
                        token = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 333: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 545) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() != 10009) {
                        throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                    }
                    this.codeSet = this.pc.getAlphabet(token);
                    if (this.codeSet != null) continue block15;
                    throw new GeneralErrorException(25, 4, token, "ALPHABET " + token.getWord(), this.error);
                }
            }
            throw new UnexpectedTokenException(token, errors);
        }
        if (this.isExternal && this.threadLocal) {
            this.error.print(294, 3, this.fileName, this.fileName.getWord());
            this.threadLocal = false;
        }
        this.sel.setExternal(this.isExternal);
        this.virtualParent.setExternal(this.isExternal);
        if (this.reports == null) {
            this.genericFile();
            return;
        } else {
            this.reportFile();
            token = this.tm.getToken();
            this.tm.ungetToken();
            if (!Token.isIntLit(token)) return;
            this.genericFile();
        }
    }

    private void reportFile() throws GeneralErrorException, EndOfProgramException {
        this.sel.isPrinter = true;
    }

    private void genericFile() throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration variableDeclaration;
        boolean bl;
        boolean bl2 = bl = this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.b(".compiler.easydb", false);
        while (Token.isIntLit(this.tm.getToken())) {
            this.tm.ungetToken();
            variableDeclaration = new VariableDeclaration(this.pc, this.tm, this.error, this.virtualParent, 0, this);
            if (variableDeclaration.getLevel() == 78 || variableDeclaration.isTypedef()) continue;
            if (bl) {
                variableDeclaration.checkEfd(this, this, variableDeclaration, null);
            }
            variableDeclaration.setUsed();
            this.recordDesc.addItem(variableDeclaration);
            this.virtualParent.addChild(variableDeclaration);
        }
        this.tm.ungetToken();
        this.pc.loadProgVariable(this.virtualParent);
        boolean bl3 = false;
        if (this.isVarying && this.recordMin == 0) {
            bl3 = true;
        }
        variableDeclaration = this.recordDesc.getFirst();
        while (variableDeclaration != null) {
            variableDeclaration.calcOffset(this.pc, 0);
            if (bl3 && (this.recordMin == 0 || variableDeclaration.getPhisicLen() < this.recordMin)) {
                this.recordMin = variableDeclaration.getPhisicLen();
            }
            variableDeclaration = this.recordDesc.getNext();
        }
        if (this.recordDesc.isEmpty()) {
            throw new GeneralErrorException(101, 4, this.fileName, this.fileName.getWord(), this.error);
        }
        if (this.recordMin != 0 && this.recordMax != 0) {
            variableDeclaration = this.recordDesc.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.phisicLen < this.recordMin || variableDeclaration.phisicLen > this.recordMax) {
                    String string = variableDeclaration.name.getWord();
                    string = this.recordMin == this.recordMax || variableDeclaration.phisicLen < this.recordMin ? string + " (" + this.recordMin + "/" + variableDeclaration.phisicLen + ")" : string + " (" + this.recordMax + "/" + variableDeclaration.phisicLen + ")";
                    this.error.print(99, 2, variableDeclaration.name, string);
                }
                variableDeclaration = this.recordDesc.getNext();
            }
        }
        if (!this.isVarying && this.tm.getOptionList().getOption("-crv") != null) {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            variableDeclaration = this.recordDesc.getFirst();
            while (variableDeclaration != null) {
                if (this.sel.organization == 717) {
                    if (variableDeclaration.getMinLen(0) < n2) {
                        n2 = variableDeclaration.getMinLen(0);
                    }
                } else if (variableDeclaration.phisicLen < n2) {
                    n2 = variableDeclaration.phisicLen;
                }
                if (variableDeclaration.phisicLen > n3) {
                    n3 = variableDeclaration.phisicLen;
                }
                variableDeclaration = this.recordDesc.getNext();
            }
            this.isVarying = n2 != n3;
            if (this.isVarying) {
                if (this.recordMin == 0 || this.recordMin > n2) {
                    this.recordMin = n2;
                }
                if (this.recordMax < n3) {
                    this.recordMax = n3;
                }
            }
        }
        if (this.sel.organization == 677 && (this.depending != null || this.recordMax != this.recordMin)) {
            this.error.print(171, 2, this.fileName, this.fileName.getWord());
        }
        if (this.sel.organization == 717 && this.tm.getOptionList().getOption("-fsv") != null && !this.sel.isLine() && !this.sel.isSort()) {
            this.isVarying = true;
            this.recordMin = 1;
        }
    }

    void defineReportVar(Token token, int n2) {
        VariableDeclaration variableDeclaration = VariableDeclaration.getPicX(this.pc, this.tm, token, n2, this.virtualParent);
        variableDeclaration.setUsed();
        this.recordDesc.addItem(variableDeclaration);
    }

    @Override
    public int getEfdCounter() {
        return ++this.efdWhenCounter;
    }

    @Override
    public void addWhen(EfdWhen efdWhen) {
        efdWhen.setNumber(this.getEfdCounter());
        if (this.efdWhenList == null) {
            this.efdWhenList = new Vector();
        }
        this.efdWhenList.addElement(efdWhen);
    }

    @Override
    public void setAlways(String string) {
        this.alwaysTab = string;
    }

    @Override
    public int getHintCounter() {
        return ++this.efdHintCounter;
    }

    @Override
    public void addHint(EfdHint efdHint) {
        if (this.efdHintList == null) {
            this.efdHintList = new Vector();
        }
        this.efdHintList.addElement(efdHint);
    }

    public Vector getHints() {
        return this.efdHintList;
    }

    public void check() throws GeneralErrorException {
        CobolToken cobolToken;
        if (this.depending != null) {
            this.depending.check(this.pc);
            cobolToken = this.depending.getVarDecl();
            if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited()) {
                throw new GeneralErrorException(109, 4, this.depending.name, this.depending.name.getWord(), this.error);
            }
        }
        if (this.vnLinage != null) {
            this.vnLinage.check(this.pc);
            cobolToken = this.vnLinage.getVarDecl();
            if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnLinage.name, this.vnLinage.name.getWord(), this.error);
            }
        }
        if (this.vnFooting != null) {
            this.vnFooting.check(this.pc);
            cobolToken = this.vnFooting.getVarDecl();
            if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnFooting.name, this.vnFooting.name.getWord(), this.error);
            }
        }
        if (this.vnTop != null) {
            this.vnTop.check(this.pc);
            cobolToken = this.vnTop.getVarDecl();
            if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnTop.name, this.vnTop.name.getWord(), this.error);
            }
        }
        if (this.vnBottom != null) {
            this.vnBottom.check(this.pc);
            cobolToken = this.vnBottom.getVarDecl();
            if (!((VariableDeclaration)cobolToken).isNumeric() || ((VariableDeclaration)cobolToken).isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnBottom.name, this.vnBottom.name.getWord(), this.error);
            }
        }
        if (this.recordMin != 0 && this.recordMax != 0 && this.sel.organization == 529) {
            cobolToken = this.sel.getAllKeyFields();
            for (int i2 = 0; i2 < ((CobolToken)cobolToken).length; ++i2) {
                if (this.recordMin >= ((VariableDeclaration)cobolToken[i2]).getOffset() + ((VariableDeclaration)cobolToken[i2]).getPhisicLen()) continue;
                throw new GeneralErrorException(178, 4, ((VariableDeclaration)cobolToken[i2]).name, ((VariableDeclaration)cobolToken[i2]).name.getWord(), this.error);
            }
        }
        if (this.reports != null) {
            cobolToken = this.reports.getFirst();
            while (cobolToken != null) {
                VariableDeclaration variableDeclaration = this.recordDesc.getFirst();
                while (variableDeclaration != null && !variableDeclaration.name.getWord().equals(((Token)cobolToken).getWord())) {
                    variableDeclaration = this.recordDesc.getNext();
                }
                if (variableDeclaration == null) {
                    throw new GeneralErrorException(181, 4, (Token)cobolToken, ((Token)cobolToken).getWord(), this.error);
                }
                cobolToken = this.reports.getNext();
            }
        }
        cobolToken = this.recordDesc.getFirst();
        while (cobolToken != null) {
            if (((VariableDeclaration)cobolToken).isAnyLength()) {
                this.anyLength = true;
                throw new GeneralErrorException(305, 4, ((VariableDeclaration)cobolToken).getNameToken(), ((VariableDeclaration)cobolToken).getName(), this.error);
            }
            cobolToken = this.recordDesc.getNext();
        }
    }

    public boolean hasLinage() {
        return this.vnLinage != null || this.tkLinage != null;
    }

    @Override
    public boolean isSort() {
        return this.isSortDescriptor;
    }

    public boolean isXml() {
        return this.isXmlDescriptor;
    }

    public boolean equals(Object object) {
        return object instanceof FileDescriptor && ((FileDescriptor)object).fileName.getWord().equals(this.fileName.getWord());
    }

    public boolean hasRecord(VariableDeclaration variableDeclaration) {
        VariableDeclaration variableDeclaration2 = this.recordDesc.getFirst();
        while (variableDeclaration2 != null) {
            if (variableDeclaration == variableDeclaration2) {
                return true;
            }
            variableDeclaration2 = this.recordDesc.getNext();
        }
        return false;
    }

    public boolean hasReport(String string) {
        if (this.reports != null) {
            Token token = this.reports.getFirst();
            while (token != null) {
                if (string.equals(token.getWord())) {
                    return true;
                }
                token = this.reports.getNext();
            }
        }
        return false;
    }

    public boolean hasReports() {
        return this.reports != null;
    }

    public VariableDeclaration getFirstRecord() {
        return this.recordDesc.getFirst();
    }

    public VariableDeclaration getRecord(String string) {
        VariableDeclaration variableDeclaration = null;
        variableDeclaration = this.recordDesc.getFirst();
        while (variableDeclaration != null && !string.equals(variableDeclaration.name.getWord())) {
            variableDeclaration = this.recordDesc.getNext();
        }
        return variableDeclaration;
    }

    public Object[] getLinageVars() {
        Object[] objectArray;
        if (this.tkLinage != null || this.vnLinage != null) {
            if (this.tkFooting != null || this.vnFooting != null || this.tkTop != null || this.vnTop != null || this.tkBottom != null || this.vnBottom != null) {
                objectArray = new Object[4];
                if (this.tkFooting != null) {
                    objectArray[1] = this.tkFooting;
                } else if (this.vnFooting != null) {
                    objectArray[1] = this.vnFooting;
                }
                if (this.tkTop != null) {
                    objectArray[2] = this.tkTop;
                } else if (this.vnTop != null) {
                    objectArray[2] = this.vnTop;
                }
                if (this.tkBottom != null) {
                    objectArray[3] = this.tkBottom;
                } else if (this.vnBottom != null) {
                    objectArray[3] = this.vnBottom;
                }
            } else {
                objectArray = new Object[1];
            }
            objectArray[0] = this.tkLinage != null ? this.tkLinage : this.vnLinage;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public void getLinageCode(StringBuffer stringBuffer) {
        if (this.tkLinage != null || this.vnLinage != null) {
            stringBuffer.append("setLinage (");
            if (this.tkLinage != null) {
                stringBuffer.append(this.tm.getCodeLiteral(this.tkLinage));
            } else {
                stringBuffer.append(this.vnLinage.getCode());
            }
            if (this.tkFooting != null || this.vnFooting != null || this.tkTop != null || this.vnTop != null || this.tkBottom != null || this.vnBottom != null) {
                stringBuffer.append(",");
                if (this.tkFooting != null) {
                    stringBuffer.append(this.tm.getCodeLiteral(this.tkFooting));
                } else if (this.vnFooting != null) {
                    stringBuffer.append(this.vnFooting.getCode());
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(",");
                if (this.tkTop != null) {
                    stringBuffer.append(this.tm.getCodeLiteral(this.tkTop));
                } else if (this.vnTop != null) {
                    stringBuffer.append(this.vnTop.getCode());
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(",");
                if (this.tkBottom != null) {
                    stringBuffer.append(this.tm.getCodeLiteral(this.tkBottom));
                } else if (this.vnBottom != null) {
                    stringBuffer.append(this.vnBottom.getCode());
                } else {
                    stringBuffer.append("null");
                }
            }
            stringBuffer.append(")");
        }
    }

    public String getEfdName() {
        if (this.efdExtraInfo != null && this.efdExtraInfo.getFile() != null) {
            return this.efdExtraInfo.getFile().replace('-', '_').toLowerCase(Locale.US);
        }
        return null;
    }

    public void getEfdCode(StringBuffer stringBuffer, String string, String string2) {
        VariableDeclaration[] variableDeclarationArray;
        Object object;
        if (this.efdWhenList != null) {
            int n2;
            int n3;
            object = null;
            variableDeclarationArray = new Hashtable();
            VariableDeclaration variableDeclaration = null;
            stringBuffer.append(string2);
            stringBuffer.append(" <conditions>");
            stringBuffer.append(string);
            for (n3 = 0; n3 < this.efdWhenList.size(); ++n3) {
                if (!((EfdWhen)this.efdWhenList.elementAt(n3)).isOther()) continue;
                object = ((EfdWhen)this.efdWhenList.elementAt(n3)).getOthers();
                for (n2 = 0; n2 < ((PList)object).getItemNum(); ++n2) {
                    if (variableDeclarationArray.get(((StringList)object).getAt(n2).replace('-', '_')) != null) continue;
                    variableDeclarationArray.put(((StringList)object).getAt(n2), this.getEfdOtherCond(((StringList)object).getAt(n2).replace('-', '_'), string2, string));
                }
            }
            for (n3 = 0; n3 < this.efdWhenList.size(); ++n3) {
                object = ((EfdWhen)this.efdWhenList.elementAt(n3)).getFields();
                for (n2 = 0; n2 < ((PList)object).getItemNum(); ++n2) {
                    variableDeclaration = null;
                    VariableDeclaration variableDeclaration2 = this.recordDesc.getFirst();
                    while (variableDeclaration2 != null && variableDeclaration == null) {
                        variableDeclaration = this.getChildByNameOrAlias(((StringList)object).getAt(n2), variableDeclaration2);
                        variableDeclaration2 = this.recordDesc.getNext();
                    }
                    if (variableDeclaration != null) continue;
                    this.error.print(217, 2, this.fileName, ((StringList)object).getAt(n2));
                }
                ((EfdWhen)this.efdWhenList.elementAt(n3)).getCode(stringBuffer, string, string2 + " ", (Hashtable)variableDeclarationArray, n3 + 1);
            }
            stringBuffer.append(string2);
            stringBuffer.append(" </conditions>");
            stringBuffer.append(string);
        }
        if ((object = this.sel.getEfdCobTrigger()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(" <trigger value='");
            stringBuffer.append((String)object);
            stringBuffer.append("'/>");
            stringBuffer.append(string);
        }
        variableDeclarationArray = this.sel.getAllKeyFields();
        for (int i2 = 0; i2 < this.recordDesc.getItemNum() && this.recordDesc.getAt(i2) != null; ++i2) {
            this.recordDesc.getAt(i2).getEfdFieldCode(variableDeclarationArray, stringBuffer, string, string2, this.recordDesc, this.sel);
        }
    }

    public void getEfcCode(StringBuffer stringBuffer, String string, String string2) {
        String string3;
        VariableDeclaration variableDeclaration;
        Object object;
        int n2;
        VariableDeclaration variableDeclaration2 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        Vector<Integer> vector = new Vector<Integer>();
        VariableDeclaration variableDeclaration3 = null;
        Vector<String> vector2 = new Vector<String>();
        boolean bl = false;
        vector.add(new Integer(0));
        if (this.efdWhenList != null) {
            boolean bl2 = true;
            for (n2 = 0; bl2 && n2 < this.efdWhenList.size(); ++n2) {
                if (((EfdWhen)this.efdWhenList.elementAt(n2)).getTableName() == null) continue;
                bl2 = false;
            }
            if (!bl2) {
                stringBuffer.append(string2);
                stringBuffer.append(" <filters>");
                stringBuffer.append(string);
                boolean bl3 = true;
                for (n2 = 0; n2 < this.efdWhenList.size(); ++n2) {
                    int n3;
                    if (((EfdWhen)this.efdWhenList.elementAt(n2)).getTableName() == null) continue;
                    object = ((EfdWhen)this.efdWhenList.elementAt(n2)).getFields();
                    for (n3 = 0; n3 < ((PList)object).getItemNum(); ++n3) {
                        variableDeclaration3 = null;
                        variableDeclaration = this.recordDesc.getFirst();
                        while (variableDeclaration != null && variableDeclaration3 == null) {
                            variableDeclaration3 = this.getChildByNameOrAlias(((StringList)object).getAt(n3), variableDeclaration);
                            variableDeclaration = this.recordDesc.getNext();
                        }
                        if (variableDeclaration3 != null) continue;
                        this.error.print(217, 2, this.fileName, ((StringList)object).getAt(n3));
                    }
                    object = ((EfdWhen)this.efdWhenList.elementAt(n2)).getFields();
                    String string4 = ((StringList)object).getFirst();
                    while (string4 != null) {
                        bl3 = true;
                        for (n3 = 0; n3 < vector2.size(); ++n3) {
                            if (!((String)vector2.elementAt(n3)).equalsIgnoreCase(string4)) continue;
                            bl3 = false;
                        }
                        if (bl3) {
                            vector2.addElement(string4);
                        }
                        string4 = ((StringList)object).getNext();
                    }
                }
                EfdWhen efdWhen = (EfdWhen)this.efdWhenList.elementAt(0);
                variableDeclaration = this.recordDesc.getFirst();
                while (variableDeclaration != null) {
                    if (this.alwaysTab != null && variableDeclaration.getEfdExtraInfo() != null && variableDeclaration.getEfdExtraInfo().getAlways() != null) {
                        variableDeclaration.getEfdExtraInfo().setAlwaysNumber(this.efdWhenList.size() + 1);
                    }
                    if (variableDeclaration2 == null && vector2 != null) {
                        for (n2 = 0; n2 < vector2.size(); ++n2) {
                            variableDeclaration2 = variableDeclaration.searchChild((String)vector2.elementAt(n2), variableDeclaration);
                            if (variableDeclaration2 == null) {
                                variableDeclaration2 = variableDeclaration.searchEfdAlias((String)vector2.elementAt(n2), variableDeclaration);
                            }
                            variableDeclaration.fillVectorEfcFilters(vector);
                            if (variableDeclaration2 == null) continue;
                            variableDeclaration2.getEfcFieldFilter(stringBuffer, string, string2 + "  ");
                        }
                    }
                    if (variableDeclaration.getEfdWhen() == null) {
                        bl = true;
                    }
                    variableDeclaration = this.recordDesc.getNext();
                }
                for (n2 = 0; n2 < this.efdWhenList.size(); ++n2) {
                    if (((EfdWhen)this.efdWhenList.elementAt(n2)).getTableName() == null) continue;
                    ((EfdWhen)this.efdWhenList.elementAt(n2)).getCodeCtree(stringBuffer, string, string2 + " ", stringBuffer2, variableDeclaration2, false);
                }
                if (stringBuffer2.length() >= 6 && stringBuffer2.substring(0, 7).equals("<filter")) {
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append("  </filter>");
                    stringBuffer.append(string);
                }
                if (this.alwaysTab != null) {
                    stringBuffer.append(string2 + "  <filter number='" + (this.efdWhenList.size() + 1) + "' table='" + this.alwaysTab + "'><always/></filter>" + string);
                }
                stringBuffer.append(string2);
                stringBuffer.append("  </filters>");
                stringBuffer.append(string);
            }
        }
        if ((string3 = this.sel.getEfdCobTrigger()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(" <trigger value='");
            stringBuffer.append(string3);
            stringBuffer.append("'/>");
            stringBuffer.append(string);
        }
        object = this.sel.getAllKeyFields();
        if (this.efdWhenList == null) {
            for (int i2 = 0; i2 < this.recordDesc.getItemNum() && this.recordDesc.getAt(i2) != null; ++i2) {
                if (!this.recordDesc.getAt(i2).containsEfcNoHidden(this.sel, this.recordDesc, (VariableDeclaration[])object)) continue;
                this.recordDesc.getAt(i2).getEfcFieldCode(this.sel.getEfdName(), (VariableDeclaration[])object, stringBuffer, string, string2, "", new Integer(0), -1, this.recordDesc, this.sel);
            }
        } else {
            for (int i3 = 0; i3 < this.recordDesc.getItemNum() && this.recordDesc.getAt(i3) != null; ++i3) {
                variableDeclaration = this.recordDesc.getAt(i3);
                if (variableDeclaration.getEfdWhen() == null) {
                    for (n2 = 1; n2 < vector.size(); ++n2) {
                        if (!variableDeclaration.containsEfcNoHidden(this.sel, this.recordDesc, (VariableDeclaration[])object)) continue;
                        variableDeclaration.getEfcFieldCode(((EfdWhen)this.efdWhenList.elementAt(n2 - 1)).getTableName(), (VariableDeclaration[])object, stringBuffer, string, string2, "", (Integer)vector.elementAt(n2), -1, this.recordDesc, this.sel);
                    }
                    if (!variableDeclaration.containsEfcNoHidden(this.sel, this.recordDesc, (VariableDeclaration[])object)) continue;
                    variableDeclaration.getEfcFieldCode(this.sel.getEfdName().toUpperCase(Locale.US) + "_ALL", (VariableDeclaration[])object, stringBuffer, string, string2, "", new Integer(0), -1, this.recordDesc, this.sel);
                    continue;
                }
                if (!variableDeclaration.containsEfcNoHidden(this.sel, this.recordDesc, (VariableDeclaration[])object)) continue;
                variableDeclaration.getEfcFieldCode(variableDeclaration.getEfdWhen().getTableName(), (VariableDeclaration[])object, stringBuffer, string, string2, "", new Integer(variableDeclaration.getEfdWhen().getNumber()), -1, this.recordDesc, this.sel);
            }
        }
    }

    int memorySize() {
        int n2 = 0;
        VariableDeclaration variableDeclaration = this.recordDesc.getFirst();
        while (variableDeclaration != null) {
            int n3 = variableDeclaration.phisicLen;
            if (variableDeclaration.occursMin > 1) {
                n3 *= variableDeclaration.occursMax > 0 ? variableDeclaration.occursMax : variableDeclaration.occursMin;
            }
            if (n3 > n2) {
                n2 = n3;
            }
            variableDeclaration = this.recordDesc.getNext();
        }
        return n2;
    }

    private int getSameRecordAreaSize(int n2) {
        int n3 = n2;
        Vector vector = this.sel.getMasterRecordAreaFor();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Select select = (Select)enumeration.nextElement();
                int n4 = select.getFD().memorySize();
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        return n3;
    }

    public boolean hasEfdWhen() {
        return this.efdWhenList != null;
    }

    @Override
    public Token getNameToken() {
        return this.fileName;
    }

    @Override
    public VariableDeclarationList getRecordDescription() {
        return this.recordDesc;
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("/* [FILE DESCRIPTOR] */" + eol);
        stringBuffer2.append("/* fileName = " + this.fileName.getWord() + " */" + eol);
        stringBuffer2.append("/* isExternal = " + this.isExternal + " */" + eol);
        if (this.external != null) {
            stringBuffer2.append("/* external = " + this.external.getWord() + " */" + eol);
        }
        stringBuffer2.append("/* isGlobal = " + this.isGlobal + " */" + eol);
        if (this.blockMin != 0) {
            stringBuffer2.append("/* blockMin = " + this.blockMin + " */" + eol);
        }
        if (this.blockMax != 0) {
            stringBuffer2.append("/* blockMax = " + this.blockMax + " */" + eol);
        }
        stringBuffer2.append("/* isBlockRecords = " + this.isBlockRecords + " */" + eol);
        stringBuffer2.append("/* isVarying = " + this.isVarying + " */" + eol);
        if (this.recordMin != 0) {
            stringBuffer2.append("/* recordMin = " + this.recordMin + " */" + eol);
        }
        if (this.recordMax != 0) {
            stringBuffer2.append("/* recordMax = " + this.recordMax + " */" + eol);
        }
        if (this.depending != null) {
            stringBuffer2.append("/* depending = ");
            stringBuffer2.append(this.depending.getName());
            stringBuffer2.append(" */" + eol);
        }
        stringBuffer2.append(this.tm.getCommentCode(this.fileName, "   "));
        int n2 = this.memorySize();
        int n3 = this.getSameRecordAreaSize(n2);
        Select select = this.sel.getSameRecordArea();
        String string = this.sel.getMemBufName();
        if (this.pc.isFactory()) {
            stringBuffer2.append("   static ");
        } else {
            stringBuffer2.append("   ");
        }
        if (this.optionXMS) {
            stringBuffer2.append("Memory ");
        } else {
            stringBuffer2.append("byte[] ");
        }
        stringBuffer2.append(string);
        if (select != null) {
            stringBuffer2.append("=");
            stringBuffer2.append(select.getMemBufName());
            stringBuffer2.append(";");
        } else {
            if (this.isExternal) {
                stringBuffer2.append("=Factory.getSharedMem(\"");
                stringBuffer2.append(this.fileName.getWord());
                stringBuffer2.append("\",");
            } else {
                stringBuffer2.append("=Factory.getMem(");
            }
            stringBuffer2.append(this.recordMax > n3 ? this.recordMax : n3);
            byte by = VariableDeclaration.getDefaultByte(this.tm.getOptionList(), this.isExternal, false);
            if (!this.isExternal && by != 32 || this.isExternal && by != 0) {
                stringBuffer2.append(", (byte)");
                stringBuffer2.append(by);
            }
            stringBuffer2.append(");");
        }
        stringBuffer2.append(eol);
        this.virtualParent.setOffset(0);
        this.virtualParent.setPhisicLen(this.getMaxRecLen());
        stringBuffer2.append(this.virtualParent.getCode(string, stringBuffer));
        if (!this.optionXMS && this.sel.hasSameRecordArea()) {
            stringBuffer.append(this.virtualParent.getDeclUnivoqueName());
            stringBuffer.append(".setMemSync();");
            stringBuffer.append(eol);
        }
        return stringBuffer2.toString();
    }

    public VariableName getDepending() {
        return this.depending;
    }

    public int getDependingOffs() {
        return this.dependingOffs;
    }

    int getMaxRecLen() {
        int n2 = 0;
        if (this.virtualParent.phisicLen != 0 || this.recordMax > 0) {
            n2 = this.virtualParent.phisicLen > this.recordMax ? this.virtualParent.phisicLen : this.recordMax;
        } else {
            VariableDeclaration variableDeclaration = this.virtualParent.children.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.phisicLen > n2) {
                    n2 = variableDeclaration.phisicLen;
                }
                variableDeclaration = this.virtualParent.children.getNext();
            }
        }
        return n2;
    }

    int getEfdMaxRecLen() {
        int n2 = 0;
        VariableDeclaration variableDeclaration = this.virtualParent.children.getFirst();
        while (variableDeclaration != null) {
            if (variableDeclaration.phisicLen > n2) {
                n2 = variableDeclaration.phisicLen;
            }
            variableDeclaration = this.virtualParent.children.getNext();
        }
        return n2;
    }

    int getMinRecLen(int n2) {
        int n3 = n2;
        VariableDeclaration variableDeclaration = this.virtualParent.children.getFirst();
        while (variableDeclaration != null) {
            if (variableDeclaration.getMinLen(0) < n3) {
                n3 = variableDeclaration.getMinLen(0);
            }
            variableDeclaration = this.virtualParent.children.getNext();
        }
        return n3;
    }

    @Override
    public VariableDeclaration getVirtualParent() {
        return this.virtualParent;
    }

    @Override
    public int getRecordMin() {
        return this.recordMin;
    }

    @Override
    public int getRecordMax() {
        return this.recordMax;
    }

    @Override
    public Select getSelect() {
        return this.sel;
    }

    public Alphabet getCodeSet() {
        return this.codeSet;
    }

    private VariableDeclaration getChildByNameOrAlias(String string, VariableDeclaration variableDeclaration) {
        VariableDeclaration variableDeclaration2 = null;
        VariableDeclarationList variableDeclarationList = variableDeclaration.getChildren();
        String string2 = variableDeclaration.getName();
        if (variableDeclaration.getEfdExtraInfo() != null && variableDeclaration.getEfdExtraInfo().getName() != null) {
            string2 = variableDeclaration.getEfdExtraInfo().getName();
        }
        if (string2.length() > 0 && Config.a(".compiler.efd_field_name_num", 0) == 1 && Character.isDigit(string2.charAt(0))) {
            string2 = string2.substring(1);
        }
        if (string.replace('-', '_').equalsIgnoreCase(string2.replace('-', '_'))) {
            return variableDeclaration;
        }
        if (variableDeclarationList != null) {
            variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null && (variableDeclaration2 = this.getChildByNameOrAlias(string, variableDeclaration)) == null) {
                variableDeclaration = variableDeclarationList.getNext();
            }
        }
        return variableDeclaration2;
    }

    private String getEfdOtherCond(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.efdWhenList.size(); ++i2) {
            ((EfdWhen)this.efdWhenList.elementAt(i2)).getNotCond(stringBuffer, string, string2, string3);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public Pcc getPcc() {
        return this.pc;
    }

    @Override
    public int getBlockMin() {
        return this.blockMin;
    }

    @Override
    public int getBlockMax() {
        return this.blockMax;
    }

    @Override
    public boolean isBlockRecords() {
        return this.isBlockRecords;
    }

    @Override
    public IToken getLinage() {
        return this.tkLinage;
    }

    @Override
    public IVariableName getLinageVar() {
        return this.vnLinage;
    }

    @Override
    public IToken getLinageFooting() {
        return this.tkFooting;
    }

    @Override
    public IVariableName getLinageFootingVar() {
        return this.vnFooting;
    }

    @Override
    public IToken getLinageTop() {
        return this.tkTop;
    }

    @Override
    public IVariableName getLinageTopVar() {
        return this.vnTop;
    }

    @Override
    public IToken getLinageBottom() {
        return this.tkBottom;
    }

    @Override
    public IVariableName getLinageBottomVar() {
        return this.vnBottom;
    }

    public EfdParser getEfdExtraInfo() {
        return this.efdExtraInfo;
    }

    public String getEfdTemporaryType() {
        String string = null;
        if (this.efdExtraInfo != null && this.efdExtraInfo.isTemporary()) {
            return this.efdExtraInfo.getTemporaryType();
        }
        VariableDeclaration variableDeclaration = this.recordDesc.getFirst();
        while (variableDeclaration != null) {
            if (variableDeclaration.getEfdExtraInfo() != null && variableDeclaration.getEfdExtraInfo().isTemporary()) {
                return variableDeclaration.getEfdExtraInfo().getTemporaryType();
            }
            variableDeclaration = this.recordDesc.getNext();
        }
        return string;
    }

    @Override
    public IVariableDeclarationList getVariableDeclarationList() {
        return this.getRecordDescription();
    }

    @Override
    public IToken getFirstToken() {
        return this.getNameToken();
    }

    @Override
    public IToken getLastToken() {
        return null;
    }

    @Override
    public boolean isThreadLocal() {
        return this.threadLocal;
    }

    public boolean isAnyLength() {
        return this.anyLength;
    }
}

