/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IFileSection;

public class FileSection
implements CobolToken,
ErrorsNumbers,
IFileSection {
    TokenManager tm;
    Errors error;
    FileDescriptorList fdArray = new FileDescriptorList();
    Pcc pc;
    private Token firstToken;
    private Token lastToken;
    private boolean hasThreadLocal;

    public FileSection(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, null);
    }

    public FileSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = token;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        token = this.tm.getToken();
        if (token.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token, "'.'");
                this.tm.ungetToken();
            }
            boolean bl = this.pc.isInterfaceChild();
            boolean bl2 = false;
            while ((token = this.tm.getToken()).getToknum() == 481 || token.getToknum() == 707 || (bl2 = token.getToknum() == 10009 && "XD".equals(token.getWord()))) {
                FileDescriptor fileDescriptor = new FileDescriptor(token, this.pc, this.tm, this.error, bl2);
                this.hasThreadLocal |= fileDescriptor.threadLocal;
                bl2 = false;
                if (bl) {
                    throw new GeneralErrorException(249, 4, fileDescriptor.getNameToken(), fileDescriptor.getNameToken().getWord(), this.error);
                }
                if (this.fdArray.exists(fileDescriptor)) {
                    throw new GeneralErrorException(91, 4, token, "FD", this.error);
                }
                this.fdArray.addItem(fileDescriptor);
            }
        } else {
            throw new UnexpectedTokenException(token, errors);
        }
        this.lastToken = token;
        this.tm.ungetToken();
    }

    boolean hasThreadLocal() {
        return this.hasThreadLocal;
    }

    FileDescriptor getFD(String string) {
        FileDescriptor fileDescriptor = null;
        fileDescriptor = this.fdArray.getFirst();
        while (fileDescriptor != null && !string.equals(fileDescriptor.fileName.getWord())) {
            fileDescriptor = this.fdArray.getNext();
        }
        return fileDescriptor;
    }

    void check() {
        FileDescriptor fileDescriptor = this.fdArray.getFirst();
        while (fileDescriptor != null) {
            try {
                fileDescriptor.check();
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            fileDescriptor = this.fdArray.getNext();
        }
    }

    public String getCode(StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.tm.getCommentCode(this.firstToken, ""));
        FileDescriptor fileDescriptor = this.fdArray.getFirst();
        while (fileDescriptor != null) {
            if (fileDescriptor.getSelect().getSameRecordArea() == null && bl == fileDescriptor.threadLocal) {
                stringBuffer2.append(fileDescriptor.getCode(stringBuffer));
            }
            fileDescriptor = this.fdArray.getNext();
        }
        fileDescriptor = this.fdArray.getFirst();
        while (fileDescriptor != null) {
            if (fileDescriptor.getSelect().getSameRecordArea() != null && bl == fileDescriptor.threadLocal) {
                stringBuffer2.append(fileDescriptor.getCode(stringBuffer));
            }
            fileDescriptor = this.fdArray.getNext();
        }
        return stringBuffer2.toString();
    }

    @Override
    public FileDescriptorList getFileDescriptorList() {
        return this.fdArray;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

