/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Function
extends VariableDeclaration {
    private static final Set<String> functionNames;
    private Vector arguments;
    private Vector expArgs;
    private Token func;
    private boolean numericArgs;
    private String compileTime;
    private boolean hasArgsWithAll;

    public static boolean is(String string) {
        return functionNames.contains(string);
    }

    private Function(Pcc pcc, Token token, TokenManager tokenManager) {
        super(pcc, token, tokenManager);
        this.pc = pcc;
        this.parent = null;
        this.name = token;
        this.level = 78;
        this.dimension = 0;
    }

    public Function(Pcc pcc, Token token, TokenManager tokenManager, boolean bl) {
        this(pcc, token, tokenManager);
        this.setNumeric(bl);
        this.isUsageNumeric = bl;
    }

    public Function(Pcc pcc, Token token, TokenManager tokenManager, Errors errors) throws EndOfProgramException, GeneralErrorException {
        this(pcc, token, tokenManager);
        this.error = errors;
        this.func = this.tm.getToken();
        switch (this.func.getToknum()) {
            case 558: {
                this.getArguments();
                if (this.arguments == null || this.arguments.size() != 1) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            case 664: {
                this.getExpArgs();
                if (this.expArgs != null && this.expArgs.size() != 1 && this.expArgs.size() != 0) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            case 695: {
                this.getArguments();
                if (this.arguments != null && this.arguments.size() == 1) break;
                throw new GeneralErrorException(80, 4, this.func, "", this.error);
            }
            case 724: {
                this.getExpArgs();
                if (this.expArgs == null || this.expArgs.size() != 1) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            default: {
                String string = this.func.getWord();
                if ("UPPER-CASE".equals(string)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("LOWER-CASE".equals(string)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIM".equals(string)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIMR".equals(string)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIML".equals(string)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("INTEGER-OF-BOOLEAN".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    Object e2 = this.arguments.elementAt(0);
                    if (e2 instanceof Token) {
                        Token token2 = (Token)e2;
                        if (token2.getToknum() != 10002) {
                            throw new GeneralErrorException(80, 4, this.func, token2.getWord(), this.error);
                        }
                    } else {
                        VariableName variableName = (VariableName)e2;
                        if (!variableName.getVarDecl().isInteger() && !variableName.getVarDecl().isPic1()) {
                            throw new GeneralErrorException(80, 4, this.func, variableName.getName(), this.error);
                        }
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("BOOLEAN-OF-INTEGER".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 2) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("INTEGER-OF-DATE".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER-OF-DAY".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DATE-OF-INTEGER".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DAY-OF-INTEGER".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DATE-TO-YYYYMMDD".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DAY-TO-YYYYDDD".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("YEAR-TO-YYYY".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MIN".equals(string)) {
                    int n2 = this.getExpOrVarArgs(true);
                    if (n2 < 1 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(this.numericArgs);
                    this.isUsageNumeric = this.numericArgs;
                    break;
                }
                if ("ORD-MIN".equals(string)) {
                    int n3 = this.getExpOrVarArgs(true);
                    if (n3 < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MAX".equals(string)) {
                    int n4 = this.getExpOrVarArgs(true);
                    if (n4 < 1 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(this.numericArgs);
                    this.isUsageNumeric = this.numericArgs;
                    break;
                }
                if ("ORD-MAX".equals(string)) {
                    int n5 = this.getExpOrVarArgs(true);
                    if (n5 < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ANNUITY".equals(string)) {
                    int n6 = this.getExpArgs();
                    if (n6 != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MEAN".equals(string)) {
                    int n7 = this.getExpArgs(true);
                    if (n7 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MEDIAN".equals(string)) {
                    int n8 = this.getExpArgs(true);
                    if (n8 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("RANGE".equals(string)) {
                    int n9 = this.getExpArgs(true);
                    if (n9 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MIDRANGE".equals(string)) {
                    int n10 = this.getExpArgs(true);
                    if (n10 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("PRESENT-VALUE".equals(string)) {
                    int n11 = this.getExpArgs(true);
                    if (n11 < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("STANDARD-DEVIATION".equals(string)) {
                    int n12 = this.getExpArgs(true);
                    if (n12 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SUM".equals(string)) {
                    int n13 = this.getExpArgs(true);
                    if (n13 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("VARIANCE".equals(string)) {
                    int n14 = this.getExpArgs(true);
                    if (n14 < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MOD".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("NUMVAL".equals(string) || "NUMVAL-F".equals(string) || "TEST-NUMVAL".equals(string) || "TEST-NUMVAL-F".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("NUMVAL-C".equals(string) || "TEST-NUMVAL-C".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1 && this.arguments.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("HANDLE-TYPE".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CHAR".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("ORD".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1 || this.numericArgs) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2HEX".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("HEX2DEC".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2OCT".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("OCT2DEC".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2BIN".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("BIN2DEC".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER-PART".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ABS".equals(string) || "ABSOLUTE-VALUE".equals(string)) {
                    int n15 = this.getExpArgs();
                    if (n15 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ACOS".equals(string)) {
                    int n16 = this.getExpArgs();
                    if (n16 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ASIN".equals(string)) {
                    int n17 = this.getExpArgs();
                    if (n17 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ATAN".equals(string)) {
                    int n18 = this.getExpArgs();
                    if (n18 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("COS".equals(string)) {
                    int n19 = this.getExpArgs();
                    if (n19 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SIN".equals(string)) {
                    int n20 = this.getExpArgs();
                    if (n20 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("TAN".equals(string)) {
                    int n21 = this.getExpArgs();
                    if (n21 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("FACTORIAL".equals(string)) {
                    int n22 = this.getExpArgs();
                    if (n22 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LOG".equals(string)) {
                    int n23 = this.getExpArgs();
                    if (n23 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LOG10".equals(string)) {
                    int n24 = this.getExpArgs();
                    if (n24 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SQRT".equals(string)) {
                    int n25 = this.getExpArgs();
                    if (n25 != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("REM".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CURRENT-DATE".equals(string)) {
                    this.getArguments(true, false);
                    break;
                }
                if ("BYTE-LENGTH".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LENGTH OF".equals(string)) {
                    Token token3 = this.tm.getToken();
                    if (token3.getToknum() == 10009) {
                        int n26;
                        this.tm.ungetToken();
                        VariableName variableName = VariableName.get(this.tm, this.error, this.pc, false);
                        int n27 = variableName.getVarDecl().getDimension();
                        if (n27 > 0 && (n26 = variableName.getDimension()) != n27 && n26 != 0) {
                            throw new GeneralErrorException(189, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
                        }
                        this.arguments = new Vector();
                        this.arguments.addElement(variableName);
                    } else if (token3.getToknum() == 10001) {
                        this.arguments = new Vector();
                        this.arguments.addElement(token3);
                    } else {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ADDRESS OF".equals(string) || "ADDRESS".equals(string)) {
                    Token token4 = this.tm.getToken();
                    if (token4.getToknum() != 10009) {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.tm.ungetToken();
                    VariableName variableName = VariableName.get(this.tm, this.error, this.pc);
                    this.arguments = new Vector();
                    this.arguments.addElement(variableName);
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("WHEN-COMPILED".equals(string)) {
                    this.getArguments(true, false);
                    this.setNumeric(false);
                    this.isUsageNumeric = false;
                    this.compileTime = this.whenCompiled();
                    break;
                }
                if ("COMPILED-INFO".equals(string)) {
                    this.getArguments(true, false);
                    this.setNumeric(false);
                    this.isUsageNumeric = false;
                    break;
                }
                if ("E".equals(string) || "PI".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() != 0) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    if (this.expArgs != null) break;
                    this.expArgs = new Vector();
                    break;
                }
                if ("EXP".equals(string) || "EXP10".equals(string) || "FRACTION-PART".equals(string)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CAPACITY".equals(string)) {
                    Token token5 = this.tm.getToken();
                    if (token5.getToknum() != 40) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    token5 = this.tm.getToken();
                    if (token5.getToknum() == 10009) {
                        this.tm.ungetToken();
                        VariableName variableName = VariableName.get(this.tm, errors, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                        VariableDeclaration variableDeclaration = variableName.getVarDecl();
                        if (!variableDeclaration.isInDynamic()) {
                            throw new GeneralErrorException(255, 4, variableName.getNameToken(), variableName.getName(), this.error);
                        }
                        if (variableName.getDimension() != variableDeclaration.getDyDimension() - 1) {
                            throw new GeneralErrorException(189, 4, variableName.getNameToken(), variableName.getName(), this.error);
                        }
                        this.arguments = new Vector();
                        this.arguments.addElement(variableName);
                        token5 = this.tm.getToken();
                        if (token5.getToknum() != 41) {
                            throw new GeneralErrorException(80, 4, this.func, "", this.error);
                        }
                    } else {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DISPLAY-OF".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() == 0 || this.arguments.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.checkNational(0);
                    this.checkAlphanumericOrNumeric(1);
                    break;
                }
                if ("NATIONAL-OF".equals(string)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() == 0 || this.arguments.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.checkAlphanumeric(0);
                    this.checkNationalOrNumeric(1);
                    this.setNational(true);
                    break;
                }
                throw new GeneralErrorException(19, 4, this.func, "FUNCTION " + string, this.error);
            }
        }
    }

    private void checkNational(int n2) throws GeneralErrorException {
        if (n2 < this.arguments.size()) {
            VariableName variableName;
            Object e2 = this.arguments.elementAt(n2);
            if (e2 instanceof Token) {
                Token token = (Token)e2;
                if (!token.isNational()) {
                    throw new GeneralErrorException(80, 4, token, token.getWord(), this.error);
                }
            } else if (e2 instanceof VariableName && !(variableName = (VariableName)e2).getVarDecl().isNational()) {
                throw new GeneralErrorException(80, 4, variableName.getNameToken(), variableName.getName(), this.error);
            }
        }
    }

    private void checkNationalOrNumeric(int n2) throws GeneralErrorException {
        if (n2 < this.arguments.size()) {
            VariableName variableName;
            Object e2 = this.arguments.elementAt(n2);
            if (e2 instanceof Token) {
                Token token = (Token)e2;
                if (!(token.isNational() || token.getToknum() != 10001 && token.getBitLen() == 0)) {
                    throw new GeneralErrorException(80, 4, token, token.getWord(), this.error);
                }
            } else if (e2 instanceof VariableName && !(variableName = (VariableName)e2).getVarDecl().isNational() && (!variableName.isNumeric() || variableName.isEdited() || variableName.getVarDecl().isPic1())) {
                throw new GeneralErrorException(80, 4, variableName.getNameToken(), variableName.getName(), this.error);
            }
        }
    }

    private void checkAlphanumeric(int n2) throws GeneralErrorException {
        if (n2 < this.arguments.size()) {
            VariableName variableName;
            Object e2 = this.arguments.elementAt(n2);
            if (e2 instanceof Token) {
                Token token = (Token)e2;
                if (token.getToknum() != 10001) {
                    throw new GeneralErrorException(80, 4, token, token.getWord(), this.error);
                }
            } else if (e2 instanceof VariableName && (variableName = (VariableName)e2).isNumeric() && !variableName.isEdited()) {
                throw new GeneralErrorException(80, 4, variableName.getNameToken(), variableName.getName(), this.error);
            }
        }
    }

    private void checkAlphanumericOrNumeric(int n2) throws GeneralErrorException {
        if (n2 < this.arguments.size()) {
            VariableName variableName;
            Object e2 = this.arguments.elementAt(n2);
            if (e2 instanceof Token) {
                Token token = (Token)e2;
                if (token.getBitLen() > 0) {
                    throw new GeneralErrorException(80, 4, token, token.getWord(), this.error);
                }
            } else if (e2 instanceof VariableName && (variableName = (VariableName)e2).getVarDecl().isPic1()) {
                throw new GeneralErrorException(80, 4, variableName.getNameToken(), variableName.getName(), this.error);
            }
        }
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    private int getExpArgs() throws EndOfProgramException, GeneralErrorException {
        return this.getExpArgs(false);
    }

    private int getExpArgs(boolean bl) throws EndOfProgramException, GeneralErrorException {
        block6: {
            Token token = this.tm.getToken();
            if (token.getToknum() != 40) {
                this.tm.ungetToken();
                this.numericArgs = false;
                return 0;
            }
            this.numericArgs = true;
            Expression expression = null;
            VariableName variableName = null;
            this.expArgs = new Vector();
            do {
                if (bl && (variableName = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                    this.numericArgs &= variableName.isNumeric();
                    this.expArgs.addElement(variableName);
                    this.hasArgsWithAll = true;
                } else {
                    expression = new Expression(new int[]{0}, null, null, this.pc, this.tm, this.error);
                    if (!expression.isVoid()) {
                        this.numericArgs &= expression.isNumeric();
                        this.expArgs.addElement(expression);
                    }
                }
                token = this.tm.getToken();
                if (token.getToknum() == 41) break block6;
                this.tm.ungetToken();
            } while (variableName != null || expression != null && !expression.isVoid());
            throw new GeneralErrorException(80, 4, this.func, "", this.error);
        }
        if (!this.numericArgs) {
            throw new GeneralErrorException(80, 4, this.func, "", this.error);
        }
        return this.expArgs.size();
    }

    private int getArgumentsAll() throws EndOfProgramException, GeneralErrorException {
        return this.getArguments(false, true);
    }

    private int getArguments() throws EndOfProgramException, GeneralErrorException {
        return this.getArguments(false, false);
    }

    private int getArguments(boolean bl, boolean bl2) throws EndOfProgramException, GeneralErrorException {
        if (bl) {
            Token token = this.tm.getToken();
            if (token.getToknum() == 40) {
                token = this.tm.getToken();
                if (token.getToknum() != 41) {
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
            return 0;
        }
        Token token = this.tm.getToken();
        if (token.getToknum() != 40) {
            this.tm.ungetToken();
            this.numericArgs = false;
            return 0;
        }
        if (!bl2) {
            this.numericArgs = true;
        }
        this.arguments = new Vector();
        while (true) {
            token = this.tm.getToken();
            switch (token.getToknum()) {
                case 10009: {
                    VariableName variableName;
                    this.tm.ungetToken();
                    if (bl2 && (variableName = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                        this.hasArgsWithAll = true;
                    } else {
                        variableName = VariableName.get(this.tm, this.error, this.pc);
                    }
                    if (variableName == null) {
                        throw new GeneralErrorException(24, 4, token, "", this.error);
                    }
                    this.arguments.addElement(variableName);
                    if (variableName.getVarDecl().isNumeric()) {
                        if (!bl2) break;
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.numericArgs = false;
                    break;
                }
                case 10002: 
                case 10017: {
                    if (bl2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.arguments.addElement(token);
                    break;
                }
                case 10001: {
                    this.numericArgs = false;
                    this.arguments.addElement(token);
                    break;
                }
                case 41: {
                    this.tm.ungetToken();
                    break;
                }
                default: {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
            }
            if ((token = this.tm.getToken()).getToknum() == 41) break;
            this.tm.ungetToken();
        }
        return this.arguments.size();
    }

    private int getExpOrVarArgs(boolean bl) throws EndOfProgramException, GeneralErrorException {
        TokenManager.Marker marker = this.tm.getMarker();
        this.tm.setMarker(marker);
        Token token = this.tm.getToken();
        if (token.getToknum() != 40) {
            this.tm.ungetToken();
            this.numericArgs = false;
            return 0;
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                VariableName variableName;
                this.tm.ungetToken();
                if (bl && (variableName = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                    this.hasArgsWithAll = true;
                } else {
                    variableName = VariableName.get(this.tm, this.error, this.pc);
                }
                if (variableName == null) {
                    throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
                }
                this.numericArgs = variableName.getVarDecl().isNumeric();
                break;
            }
            case 10001: {
                this.numericArgs = false;
                break;
            }
            case 10002: 
            case 10017: {
                this.numericArgs = true;
                break;
            }
            case 41: {
                this.numericArgs = false;
                return 0;
            }
            case 40: {
                this.numericArgs = true;
                break;
            }
            default: {
                throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
            }
        }
        this.tm.rewindToMarker(marker);
        if (this.numericArgs) {
            return this.getExpArgs(bl);
        }
        if (bl) {
            return this.getArgumentsAll();
        }
        return this.getArguments();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String args() {
        StringBuffer stringBuffer;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            stringBuffer = new StringBuffer();
                            if (this.expArgs == null) break block19;
                            if (this.expArgs.size() == 0) {
                                return "";
                            }
                            if (this.hasArgsWithAll) break block20;
                            break block21;
                        }
                        if (this.arguments == null) return "";
                        if (this.arguments.size() == 0) {
                            return "";
                        }
                        if (this.hasArgsWithAll) break block22;
                        break block23;
                    }
                    int n2 = 0;
                    do {
                        Object e2 = this.expArgs.elementAt(n2);
                        stringBuffer.append(".put(");
                        if (e2 instanceof VariableName) {
                            stringBuffer.append(((VariableName)e2).getCode());
                        } else {
                            stringBuffer.append(((Expression)e2).getCode());
                        }
                        stringBuffer.append(")");
                    } while (++n2 != this.expArgs.size());
                    return stringBuffer.toString();
                }
                int n3 = 0;
                while (true) {
                    Object e3;
                    if ((e3 = this.expArgs.elementAt(n3)) instanceof VariableName) {
                        stringBuffer.append(((VariableName)e3).getCode());
                    } else {
                        stringBuffer.append(((Expression)e3).getCode());
                    }
                    if (++n3 == this.expArgs.size()) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(",");
                }
            }
            int n4 = 0;
            do {
                Object e4 = this.arguments.elementAt(n4);
                stringBuffer.append(".put(");
                if (e4 instanceof VariableName) {
                    stringBuffer.append(((VariableName)e4).getCode());
                } else {
                    stringBuffer.append(this.tm.getCodeLiteral((Token)e4));
                }
                stringBuffer.append(")");
            } while (++n4 != this.arguments.size());
            return stringBuffer.toString();
        }
        int n5 = 0;
        while (true) {
            Object e5;
            if ((e5 = this.arguments.elementAt(n5)) instanceof VariableName) {
                VariableName variableName = (VariableName)e5;
                if (variableName.getVarDecl().isNational() && variableName.hasIndexes()) {
                    stringBuffer.append("((PicN) ");
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(variableName.getCode());
                }
            } else {
                stringBuffer.append(this.tm.getCodeLiteral((Token)e5));
            }
            if (++n5 == this.arguments.size()) {
                return stringBuffer.toString();
            }
            stringBuffer.append(",");
        }
    }

    private String displayOf() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Functions.displayOf(");
        stringBuffer.append(this.args());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String integerOfBoolean() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Functions.integerOfBoolean(");
        stringBuffer.append(this.args());
        stringBuffer.append(",");
        stringBuffer.append(this.tm.getDecimalPointIsComma());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String booleanOfInteger() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Functions.booleanOfInteger(");
        stringBuffer.append(this.args());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String nationalOf() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Functions.nationalOf(");
        stringBuffer.append(this.args());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String capacity() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NumericVar.literal(");
        VariableName variableName = (VariableName)this.arguments.elementAt(0);
        SubscriptList subscriptList = variableName.getIndexes();
        variableName.setIndexes(null);
        stringBuffer.append(variableName.getCode());
        variableName.setIndexes(subscriptList);
        stringBuffer.append(".getDynamicCapacity(new int[] { ");
        if (subscriptList != null) {
            boolean bl = true;
            Subscript subscript = subscriptList.getFirst();
            while (subscript != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(subscript.getCode());
                subscript = subscriptList.getNext();
            }
        }
        stringBuffer.append(" }, true), 10, 0, false)");
        return stringBuffer.toString();
    }

    private String funcFixArgs(String string) {
        if (this.expArgs == null) {
            return "Functions." + string + "(" + this.args() + ")";
        }
        String string2 = this.args();
        if (string2 == null || string2.length() == 0) {
            return "Functions." + string + "(" + this.tm.getDecimalPointIsComma() + ")";
        }
        return "Functions." + string + "(" + string2 + "," + this.tm.getDecimalPointIsComma() + ")";
    }

    private String funcVarArgs(String string, boolean bl) {
        if (this.expArgs != null) {
            if (this.hasArgsWithAll) {
                return "Functions." + string + "(new FunctionArgs()" + this.args() + ".nums()," + this.tm.getDecimalPointIsComma() + ")";
            }
            return "Functions." + string + "(new CobolNum[] {" + this.args() + "}," + this.tm.getDecimalPointIsComma() + ")";
        }
        if (bl) {
            return "Functions." + string + "(new NumericVar[] {" + this.args() + "})";
        }
        if (this.hasArgsWithAll) {
            return "Functions." + string + "(new FunctionArgs()" + this.args() + ".vars())";
        }
        return "Functions." + string + "(new CobolVar[] {" + this.args() + "})";
    }

    private String whenCompiled() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringBuffer stringBuffer = new StringBuffer("Factory.getStrLiteral(\"");
        long l2 = (long)gregorianCalendar.get(1) * 1000000000000L;
        l2 += (long)(gregorianCalendar.get(2) + 1) * 10000000000L;
        l2 += (long)gregorianCalendar.get(5) * 100000000L;
        l2 += (long)(gregorianCalendar.get(11) * 1000000);
        l2 += (long)(gregorianCalendar.get(12) * 10000);
        l2 += (long)(gregorianCalendar.get(13) * 100);
        stringBuffer.append(l2 += (long)(gregorianCalendar.get(14) / 10));
        stringBuffer.append("00000\")");
        return stringBuffer.toString();
    }

    @Override
    public String getUnivoqueName() {
        if (this.func == null) {
            return super.getUnivoqueName();
        }
        switch (this.func.getToknum()) {
            case 558: {
                return this.funcFixArgs(this.pc.getOption("-cm") != null ? "lengthComp_5" : "length");
            }
            case 664: {
                return this.funcFixArgs("random");
            }
            case 695: {
                return this.funcFixArgs("reverse");
            }
            case 724: {
                return this.funcFixArgs("sign");
            }
            case 259: 
            case 10009: {
                String string = this.func.getWord();
                if ("UPPER-CASE".equals(string)) {
                    return this.funcFixArgs("upperCase");
                }
                if ("LOWER-CASE".equals(string)) {
                    return this.funcFixArgs("lowerCase");
                }
                if ("TRIM".equals(string)) {
                    return this.funcFixArgs("trim");
                }
                if ("TRIMR".equals(string)) {
                    return this.funcFixArgs("trimr");
                }
                if ("TRIML".equals(string)) {
                    return this.funcFixArgs("triml");
                }
                if ("INTEGER-OF-DATE".equals(string)) {
                    return this.funcFixArgs("integerOfDate");
                }
                if ("INTEGER-OF-DAY".equals(string)) {
                    return this.funcFixArgs("integerOfDay");
                }
                if ("DATE-OF-INTEGER".equals(string)) {
                    return this.funcFixArgs("dateOfInteger");
                }
                if ("DAY-OF-INTEGER".equals(string)) {
                    return this.funcFixArgs("dayOfInteger");
                }
                if ("DATE-TO-YYYYMMDD".equals(string)) {
                    return this.funcFixArgs("dateToYyyyMmDd");
                }
                if ("DAY-TO-YYYYDDD".equals(string)) {
                    return this.funcFixArgs("dayToYyyyDdd");
                }
                if ("YEAR-TO-YYYY".equals(string)) {
                    return this.funcFixArgs("yearToYyyy");
                }
                if ("MIN".equals(string)) {
                    return this.funcVarArgs("min", this.numericArgs);
                }
                if ("MAX".equals(string)) {
                    return this.funcVarArgs("max", this.numericArgs);
                }
                if ("ORD-MIN".equals(string)) {
                    return this.funcVarArgs("ordMin", this.numericArgs);
                }
                if ("ORD-MAX".equals(string)) {
                    return this.funcVarArgs("ordMax", this.numericArgs);
                }
                if ("ANNUITY".equals(string)) {
                    return this.funcFixArgs("annuity");
                }
                if ("MEAN".equals(string)) {
                    return this.funcVarArgs("mean", this.numericArgs);
                }
                if ("MEDIAN".equals(string)) {
                    return this.funcVarArgs("median", this.numericArgs);
                }
                if ("RANGE".equals(string)) {
                    return this.funcVarArgs("range", this.numericArgs);
                }
                if ("MIDRANGE".equals(string)) {
                    return this.funcVarArgs("midrange", this.numericArgs);
                }
                if ("PRESENT-VALUE".equals(string)) {
                    return this.funcVarArgs("presentValue", this.numericArgs);
                }
                if ("STANDARD-DEVIATION".equals(string)) {
                    return this.funcVarArgs("standardDeviation", this.numericArgs);
                }
                if ("SUM".equals(string)) {
                    return this.funcVarArgs("sum", this.numericArgs);
                }
                if ("VARIANCE".equals(string)) {
                    return this.funcVarArgs("variance", this.numericArgs);
                }
                if ("MOD".equals(string)) {
                    return this.funcFixArgs("mod");
                }
                if ("NUMVAL".equals(string)) {
                    return this.funcFixArgs("numVal");
                }
                if ("NUMVAL-C".equals(string)) {
                    return this.funcFixArgs("numValC");
                }
                if ("NUMVAL-F".equals(string)) {
                    return this.funcFixArgs("numValF");
                }
                if ("TEST-NUMVAL".equals(string)) {
                    return this.funcFixArgs("testNumVal");
                }
                if ("TEST-NUMVAL-C".equals(string)) {
                    return this.funcFixArgs("testNumValC");
                }
                if ("TEST-NUMVAL-F".equals(string)) {
                    return this.funcFixArgs("testNumValF");
                }
                if ("HANDLE-TYPE".equals(string)) {
                    return this.funcFixArgs("handleType");
                }
                if ("CHAR".equals(string)) {
                    return this.funcFixArgs("chr");
                }
                if ("ORD".equals(string)) {
                    return this.funcFixArgs("ord");
                }
                if ("HEX2DEC".equals(string)) {
                    return this.funcFixArgs("hex2Dec");
                }
                if ("DEC2HEX".equals(string)) {
                    return this.funcFixArgs("dec2Hex");
                }
                if ("OCT2DEC".equals(string)) {
                    return this.funcFixArgs("oct2Dec");
                }
                if ("DEC2OCT".equals(string)) {
                    return this.funcFixArgs("dec2Oct");
                }
                if ("BIN2DEC".equals(string)) {
                    return this.funcFixArgs("bin2Dec");
                }
                if ("DEC2BIN".equals(string)) {
                    return this.funcFixArgs("dec2Bin");
                }
                if ("INTEGER".equals(string)) {
                    return this.funcFixArgs("integer");
                }
                if ("INTEGER-PART".equals(string)) {
                    return this.funcFixArgs("integerPart");
                }
                if ("ABS".equals(string) || "ABSOLUTE-VALUE".equals(string)) {
                    return this.funcFixArgs("abs");
                }
                if ("ACOS".equals(string)) {
                    return this.funcFixArgs("acos");
                }
                if ("ASIN".equals(string)) {
                    return this.funcFixArgs("asin");
                }
                if ("ATAN".equals(string)) {
                    return this.funcFixArgs("atan");
                }
                if ("COS".equals(string)) {
                    return this.funcFixArgs("cos");
                }
                if ("SIN".equals(string)) {
                    return this.funcFixArgs("sin");
                }
                if ("TAN".equals(string)) {
                    return this.funcFixArgs("tan");
                }
                if ("FACTORIAL".equals(string)) {
                    return this.funcFixArgs("factorial");
                }
                if ("LOG".equals(string)) {
                    return this.funcFixArgs("log");
                }
                if ("LOG10".equals(string)) {
                    return this.funcFixArgs("log10");
                }
                if ("SQRT".equals(string)) {
                    return this.funcFixArgs("sqrt");
                }
                if ("REM".equals(string)) {
                    return this.funcFixArgs("rem");
                }
                if ("CURRENT-DATE".equals(string)) {
                    return this.funcFixArgs("currentDate");
                }
                if ("BYTE-LENGTH".equals(string)) {
                    return this.funcFixArgs("byteLength");
                }
                if ("LENGTH OF".equals(string)) {
                    return this.funcFixArgs(this.pc.getOption("-cm") != null ? "lengthComp_5" : "length");
                }
                if ("WHEN-COMPILED".equals(string)) {
                    return this.compileTime;
                }
                if ("COMPILED-INFO".equals(string)) {
                    String string2 = "Functions.compiledInfo(";
                    if (this.pc instanceof CobolProgram) {
                        string2 = string2 + this.pc.getParent().getFullClassName();
                        string2 = string2 + ".this";
                    } else {
                        string2 = string2 + this.pc.getRoot().getFullClassName();
                        string2 = this.pc.isFactory() ? string2 + ".class" : string2 + ".this";
                    }
                    string2 = string2 + ")";
                    return string2;
                }
                if ("ADDRESS OF".equals(string) || "ADDRESS".equals(string)) {
                    return "Factory.getNumLiteral(\"\"+" + this.args() + ".getAddressAsLong(),false)";
                }
                if ("E".equals(string)) {
                    return this.funcFixArgs("e");
                }
                if ("EXP".equals(string)) {
                    return this.funcFixArgs("exp");
                }
                if ("EXP10".equals(string)) {
                    return this.funcFixArgs("exp10");
                }
                if ("FRACTION-PART".equals(string)) {
                    return this.funcFixArgs("fractionPart");
                }
                if ("PI".equals(string)) {
                    return this.funcFixArgs("pi");
                }
                if ("CAPACITY".equals(string)) {
                    return this.capacity();
                }
                if ("DISPLAY-OF".equals(string)) {
                    return this.displayOf();
                }
                if ("NATIONAL-OF".equals(string)) {
                    return this.nationalOf();
                }
                if ("BOOLEAN-OF-INTEGER".equals(string)) {
                    return this.booleanOfInteger();
                }
                if (!"INTEGER-OF-BOOLEAN".equals(string)) break;
                return this.integerOfBoolean();
            }
        }
        return "### " + this.func + " UNKNOWN FUNCTION";
    }

    public Vector getArgumentList() {
        return this.arguments;
    }

    @Override
    boolean notElementary() {
        return false;
    }

    public Vector getExpArgList() {
        return this.expArgs;
    }

    public Token getFunc() {
        return this.func;
    }

    @Override
    boolean isNotXOptimizable(boolean bl) {
        return true;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ABS");
        hashSet.add("ABSOLUTE-VALUE");
        hashSet.add("ACOS");
        hashSet.add("ADDRESS");
        hashSet.add("ANNUITY");
        hashSet.add("ASIN");
        hashSet.add("ATAN");
        hashSet.add("BIN2DEC");
        hashSet.add("BOOLEAN-OF-INTEGER");
        hashSet.add("BYTE-LENGTH");
        hashSet.add("CAPACITY");
        hashSet.add("CHAR");
        hashSet.add("COMPILED-INFO");
        hashSet.add("COS");
        hashSet.add("CURRENT-DATE");
        hashSet.add("DATE-OF-INTEGER");
        hashSet.add("DATE-TO-YYYYMMDD");
        hashSet.add("DAY-OF-INTEGER");
        hashSet.add("DAY-TO-YYYYDDD");
        hashSet.add("DEC2BIN");
        hashSet.add("DEC2HEX");
        hashSet.add("DEC2OCT");
        hashSet.add("DISPLAY-OF");
        hashSet.add("E");
        hashSet.add("EXP");
        hashSet.add("EXP10");
        hashSet.add("FACTORIAL");
        hashSet.add("FRACTION-PART");
        hashSet.add("INTEGER");
        hashSet.add("INTEGER-OF-BOOLEAN");
        hashSet.add("INTEGER-OF-DATE");
        hashSet.add("INTEGER-OF-DAY");
        hashSet.add("INTEGER-PART");
        hashSet.add("HANDLE-TYPE");
        hashSet.add("HEX2DEC");
        hashSet.add("LENGTH");
        hashSet.add("LOG");
        hashSet.add("LOG10");
        hashSet.add("LOWER-CASE");
        hashSet.add("MAX");
        hashSet.add("MEAN");
        hashSet.add("MEDIAN");
        hashSet.add("MIDRANGE");
        hashSet.add("MIN");
        hashSet.add("MOD");
        hashSet.add("NATIONAL-OF");
        hashSet.add("NUMVAL");
        hashSet.add("NUMVAL-C");
        hashSet.add("NUMVAL-F");
        hashSet.add("PRESENT-VALUE");
        hashSet.add("OCT2DEC");
        hashSet.add("ORD");
        hashSet.add("ORD-MAX");
        hashSet.add("ORD-MIN");
        hashSet.add("RANDOM");
        hashSet.add("RANGE");
        hashSet.add("REM");
        hashSet.add("REVERSE");
        hashSet.add("SIGN");
        hashSet.add("SIN");
        hashSet.add("SQRT");
        hashSet.add("STANDARD-DEVIATION");
        hashSet.add("SUM");
        hashSet.add("TAN");
        hashSet.add("TEST-NUMVAL");
        hashSet.add("TEST-NUMVAL-C");
        hashSet.add("TEST-NUMVAL-F");
        hashSet.add("TRIM");
        hashSet.add("TRIML");
        hashSet.add("TRIMR");
        hashSet.add("UPPER-CASE");
        hashSet.add("VARIANCE");
        hashSet.add("WHEN-COMPILED");
        hashSet.add("YEAR-TO-YYYY");
        functionNames = Collections.unmodifiableSet(hashSet);
    }
}

