/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ControlsType;
import com.iscobol.compiler.Display;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ScreenAttribute;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IPropElementValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class GUIControl
implements CobolToken,
ControlsType,
ErrorsNumbers,
IGUIControl {
    public static final HashMap<String, Integer> controlIds = new HashMap();
    public static final HashMap<Integer, String> controlNames = new HashMap();
    private static final HashSet<String> eisWords = new HashSet();
    public static final HashSet<String> globalStyleWords = new HashSet();
    public static final HashSet<String> globalPropertyWords = new HashSet();
    public static final HashSet<String> globalUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> globalUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> labelStyleWords = new HashSet();
    public static final HashSet<String> entryFieldStyleWords = new HashSet();
    public static final HashSet<String> pushButtonStyleWords = new HashSet();
    public static final HashSet<String> checkBoxStyleWords = new HashSet();
    public static final HashSet<String> radioButtonStyleWords = new HashSet();
    public static final HashSet<String> comboBoxStyleWords = new HashSet();
    public static final HashSet<String> listBoxStyleWords = new HashSet();
    public static final HashSet<String> frameStyleWords = new HashSet();
    public static final HashSet<String> tabStyleWords = new HashSet();
    public static final HashSet<String> ribbonStyleWords = new HashSet();
    public static final HashSet<String> iwcPanelStyleWords = new HashSet();
    public static final HashSet<String> gridStyleWords = new HashSet();
    public static final HashSet<String> treeStyleWords = new HashSet();
    public static final HashSet<String> statusBarStyleWords = new HashSet();
    public static final HashSet<String> barStyleWords = new HashSet();
    public static final HashSet<String> webBrowserStyleWords = new HashSet();
    public static final HashSet<String> scrollBarStyleWords = new HashSet();
    public static final HashSet<String> sliderStyleWords = new HashSet();
    public static final HashSet<String> javaBeanStyleWords = new HashSet();
    public static final HashSet<String> dateEntryStyleWords = new HashSet();
    public static final HashSet<String> scrollPaneStyleWords = new HashSet();
    public static final HashSet<String> chipsBoxStyleWords = new HashSet();
    public static final HashSet<String> labelPropertiesWords = new HashSet();
    public static final HashSet<String> entryFieldPropertiesWords = new HashSet();
    public static final HashSet<String> pushButtonPropertiesWords = new HashSet();
    public static final HashSet<String> checkBoxPropertiesWords = new HashSet();
    public static final HashSet<String> radioButtonPropertiesWords = new HashSet();
    public static final HashSet<String> comboBoxPropertiesWords = new HashSet();
    public static final HashSet<String> listBoxPropertiesWords = new HashSet();
    public static final HashSet<String> framePropertiesWords = new HashSet();
    public static final HashSet<String> bitmapPropertiesWords = new HashSet();
    public static final HashSet<String> tabPropertiesWords = new HashSet();
    public static final HashSet<String> ribbonPropertiesWords = new HashSet();
    public static final HashSet<String> iwcPanelPropertiesWords = new HashSet();
    public static final HashSet<String> gridPropertiesWords = new HashSet();
    public static final HashSet<String> treePropertiesWords = new HashSet();
    public static final HashSet<String> statusBarPropertiesWords = new HashSet();
    public static final HashSet<String> barPropertiesWords = new HashSet();
    public static final HashSet<String> webBrowserPropertiesWords = new HashSet();
    public static final HashSet<String> scrollBarPropertiesWords = new HashSet();
    public static final HashSet<String> sliderPropertiesWords = new HashSet();
    public static final HashSet<String> javaBeanPropertiesWords = new HashSet();
    public static final HashSet<String> dateEntryPropertiesWords = new HashSet();
    public static final HashSet<String> scrollPanePropertiesWords = new HashSet();
    public static final HashSet<String> chipsBoxPropertiesWords = new HashSet();
    public static final HashMap<String, int[]> rgbSpecialProperties = new HashMap();
    public static final HashSet<String> labelUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> entryFieldUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> pushButtonUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> checkBoxUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> radioButtonUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> comboBoxUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> listBoxUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> frameUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> tabUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> gridUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> treeUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> javaBeanUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> dateEntryUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> barUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> chipsBoxUnsupportedWD2StyleWords = new HashSet();
    public static final HashSet<String> labelUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> bitmapUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> entryFieldUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> pushButtonUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> checkBoxUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> radioButtonUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> comboBoxUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> listBoxUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> frameUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> tabUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> gridUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> treeUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> javaBeanUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> dateEntryUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> chipsBoxUnsupportedWD2PropertiesWords = new HashSet();
    public static final HashSet<String> webBrowserUnsupportedPropertiesWords = new HashSet();
    public static final String tabgroupProp = "TAB-GROUP";
    public static final String tabgroupvalueProp = "TAB-GROUP-VALUE";
    public static final String scrollgroupProp = "SCROLL-GROUP";
    public static final Set<String> windowPropertyNames = new HashSet<String>();
    private TokenManager tm;
    private Errors error;
    private Pcc pc;
    int graphicControlType = -1;
    private int toknumValueIS_IN = 545;
    private Token name;
    private Set<String> controlStyles;
    private PropElementList controlProperties;
    ScreenAttribute sa;
    private Token keyWord;
    private boolean guiWd2UnsupportedLog;
    final short kind;

    public GUIControl(Pcc pcc, TokenManager tokenManager, Errors errors, Token token, Token token2, short s2, VariableDeclarationScreen variableDeclarationScreen) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, token, token2, false, false, s2, variableDeclarationScreen);
    }

    public GUIControl(Pcc pcc, TokenManager tokenManager, Errors errors, Token token, Token token2, boolean bl, boolean bl2, short s2, VariableDeclarationScreen variableDeclarationScreen) throws GeneralErrorException, EndOfProgramException {
        this.keyWord = token2;
        this.name = token;
        this.pc = pcc;
        this.error = errors;
        this.kind = s2;
        this.controlStyles = new HashSet<String>();
        this.controlProperties = new PropElementList();
        this.toknumValueIS_IN = this.keyWord != null && this.keyWord.getToknum() == 536 ? 526 : 545;
        this.guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
        this.sa = new ScreenAttribute(this.pc, variableDeclarationScreen, tokenManager, errors, this.toknumValueIS_IN, bl, bl2, s2);
        this.sa.setIsguicontrol(true);
    }

    public void loadGUIControl(TokenManager tokenManager) throws GeneralErrorException, EndOfProgramException {
        Token token;
        boolean bl = true;
        this.tm = tokenManager;
        while (bl && (token = this.tm.getToken()) != null) {
            bl = this.tokenIsAttrScreen(token, this.tm);
            this.tm.ungetToken();
        }
    }

    int loadGraphicalControl(Token token, VariableDeclaration variableDeclaration, TokenManager tokenManager) throws GeneralErrorException, EndOfProgramException {
        this.tm = tokenManager;
        if (token.getToknum() == 606) {
            if (!Token.isIntLit(token = this.remgetToken(token))) {
                throw new GeneralErrorException(72, 4, token, token.getWord(), this.error);
            }
            this.graphicControlType = Integer.parseInt(token.getWord());
            if (this.graphicControlType < 1 || this.graphicControlType > 17) {
                throw new GeneralErrorException(71, 4, token, token.getWord(), this.error);
            }
        } else if (token.getToknum() == 553) {
            this.graphicControlType = 1;
        } else if (token.getWord().toUpperCase().equalsIgnoreCase("RIBBON")) {
            this.graphicControlType = 21;
        } else if (token.getWord().toUpperCase().equalsIgnoreCase("SCROLL-PANE")) {
            this.graphicControlType = 22;
        } else if (token.getWord().toUpperCase().equalsIgnoreCase("IWC-PANEL")) {
            this.graphicControlType = 23;
        } else if (token.getWord().toUpperCase().equalsIgnoreCase("TAB-CONTROL")) {
            this.graphicControlType = 10;
        } else if (token.getToknum() == 508) {
            this.graphicControlType = 12;
        } else {
            String string = token.getWord().toUpperCase();
            this.graphicControlType = GUIControl.getGCT(string);
        }
        if (this.graphicControlType >= 0) {
            boolean bl = false;
            this.checkControlType(token);
            if (variableDeclaration != null) {
                ((VariableDeclarationScreen)variableDeclaration).hasGraphicalControl = true;
            }
            if ((token = this.remgetToken(token)).getToknum() == 771) {
                token = this.remgetToken(token);
                bl = true;
            }
            if (token.getToknum() == this.toknumValueIS_IN || token.getToknum() == 61) {
                token = this.remgetToken(token);
            }
            if (token.getToknum() == 10001) {
                this.sa.setTitle(token);
                token = this.remgetToken(token);
            } else if (token.getToknum() == 10009) {
                if (!(this.isControlStyle(token, false) || this.isSpecialProperties(token) || this.is3D(token))) {
                    this.sa.setTitle(this.localVariableNameGet());
                    token = this.remgetToken(token);
                }
            } else if (bl) {
                throw new ExpectedFoundException(token, this.error, "literal");
            }
        }
        return this.graphicControlType;
    }

    private VariableName localVariableNameGet() throws GeneralErrorException, EndOfProgramException {
        return this.localVariableNameGet(false, true);
    }

    private VariableName localVariableNameGet(boolean bl, boolean bl2) throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        boolean bl3 = this.sa == null || this.sa.parVds == null || this.kind != 1;
        VariableName variableName = VariableName.get(this.tm, this.error, null, this.pc, false, true, bl2, bl3);
        if (this.sa != null && !bl) {
            this.sa.checkDimension(variableName);
        }
        if (!bl3 && variableName != null && variableName.varDecl != null) {
            this.sa.parVds.attrVariables.addItem(variableName.varDecl);
        }
        return variableName;
    }

    public boolean isGraphicControlType() {
        return this.graphicControlType != -1;
    }

    private Token remgetToken(Token token) throws GeneralErrorException, EndOfProgramException {
        return this.tm.remgetToken(token);
    }

    private boolean allowsRgb(String string, int n2) {
        int[] nArray = rgbSpecialProperties.get(string.toUpperCase());
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != n2) continue;
                return true;
            }
        }
        return false;
    }

    private Token putProperties(Object object, Token token) throws GeneralErrorException, EndOfProgramException {
        Object object2;
        Token token2 = null;
        VariableName variableName = null;
        Object object3 = object;
        VariableName variableName2 = null;
        Token token3 = null;
        Expression expression = null;
        boolean bl = false;
        Token token4 = null;
        TokenManager.Marker marker = null;
        PropElement propElement = null;
        boolean bl2 = false;
        if (object instanceof Token && ((Token)object).getToknum() == 10009) {
            if (this.tm.getConstant(((Token)object).getWord()) == null && this.tm.getConstVar(((Token)object).getWord()) == null) {
                variableName = this.localVariableNameGet();
            } else {
                object2 = new VariableName((Token)object);
                ((VariableName)object2).check(this.pc);
                variableName = object2;
            }
            object3 = variableName;
        }
        if ((token = this.remgetToken(token)).getWord().equalsIgnoreCase("RGB")) {
            if (object instanceof String && this.allowsRgb((String)object, this.graphicControlType)) {
                object2 = this.tm.getToken();
                if (!(((Token)object2).getToknum() != 10009 || this.pc.optionMS && this.tm.getConstVar(((Token)object2).getWord(), true) != null)) {
                    throw new GeneralErrorException(23, 4, (Token)object2, ((Token)object2).getWord(), this.error);
                }
                this.tm.ungetToken();
                token = this.remgetToken(token);
                bl2 = true;
            } else {
                throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
            }
        }
        if (token.getToknum() == 277 || token.getToknum() == this.toknumValueIS_IN || token.getToknum() == 61) {
            token = this.remgetToken(token);
        }
        if (token.getToknum() == 591 || token.getToknum() == 756) {
            token2 = token;
            token = this.remgetToken(token);
        }
        if (token.getToknum() == 40) {
            if (this.toknumValueIS_IN == 526) {
                throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
            }
            object2 = new LinkedList();
            token = this.remgetToken(token);
            while (token.getToknum() != 41 && token.getToknum() != 10006) {
                Object object4;
                boolean bl3 = false;
                if (token.getWord().equalsIgnoreCase("RGB")) {
                    if (object instanceof String && this.allowsRgb((String)object, this.graphicControlType)) {
                        object4 = this.tm.getToken();
                        if (!(((Token)object4).getToknum() != 10009 || this.pc.optionMS && this.tm.getConstVar(((Token)object4).getWord(), true) != null)) {
                            throw new GeneralErrorException(23, 4, (Token)object4, ((Token)object4).getWord(), this.error);
                        }
                        this.tm.ungetToken();
                        token = this.remgetToken(token);
                        bl3 = true;
                    } else {
                        throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                    }
                }
                if (token.getToknum() == 10017 || token.getToknum() == 10002 || token.getToknum() == 10001) {
                    token3 = token;
                    token4 = token;
                } else if (token.getToknum() == 10009) {
                    marker = this.tm.getMarker();
                    this.tm.setMarker(marker);
                    variableName2 = this.localVariableNameGet(token2 != null, true);
                    token4 = token;
                } else {
                    bl = true;
                }
                if (!bl) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 43 || token.getToknum() == 45 || token.getToknum() == 42 || token.getToknum() == 47) {
                        bl = true;
                        if (marker != null) {
                            this.tm.rewindToMarker(marker);
                        } else {
                            this.tm.ungetToken();
                        }
                        variableName2 = null;
                        token3 = null;
                    } else {
                        if (variableName2 != null) {
                            ((LinkedList)object2).addLast(new PropElementValue(variableName2, bl3));
                        } else if (token3 != null) {
                            ((LinkedList)object2).addLast(new PropElementValue(token3, bl3));
                        }
                        variableName2 = null;
                        token3 = null;
                        this.tm.ungetToken();
                        token = this.remgetToken(token4);
                    }
                }
                if (!bl) continue;
                this.tm.ungetToken();
                object4 = this.tm.getMarker();
                this.tm.setMarker((TokenManager.Marker)object4);
                int[] nArray = new int[]{0};
                expression = new Expression(nArray, token, this.sa.par, this.pc, this.tm, this.error);
                if (nArray[0] != 0) {
                    throw new GeneralErrorException(44, 4, token, token.getWord(), this.error);
                }
                if (!expression.isNumeric()) {
                    throw new GeneralErrorException(49, 4, token, token.getWord(), this.error);
                }
                if (expression.getType() == 0) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
                if (expression.isVoid()) {
                    throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
                }
                ((LinkedList)object2).addLast(new PropElementValue(expression, bl3));
                expression = null;
                bl = false;
                this.tm.removeToMarker((TokenManager.Marker)object4);
                token = this.tm.getToken();
            }
            if (token.getToknum() == 41) {
                token = this.remgetToken(token);
            }
            PropElementValue[] propElementValueArray = new PropElementValue[((LinkedList)object2).size()];
            ((LinkedList)object2).toArray(propElementValueArray);
            propElement = new PropElement(object3, propElementValueArray, null);
            this.controlProperties.put(propElement);
        } else {
            Object object5;
            boolean bl4 = Token.isZero(token);
            if (bl4) {
                token = this.tm.getToken();
                if (token.getToknum() == 43 || token.getToknum() == 45 || token.getToknum() == 42 || token.getToknum() == 47) {
                    bl4 = false;
                }
                this.tm.ungetToken();
                this.tm.ungetToken();
                token = this.tm.getToken();
            }
            if (bl4) {
                if (this.toknumValueIS_IN == 526) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
                Token token5 = new Token(10002, "0", token.getFLN(), token.getOffset(), token.getFileName());
                propElement = new PropElement(object3, new PropElementValue(token5, bl2), null);
                this.controlProperties.put(propElement);
                token = this.remgetToken(token);
            } else if (token.getToknum() == 10017 || token.getToknum() == 10002 || token.getToknum() == 10001) {
                if (this.toknumValueIS_IN == 526) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
                token3 = token;
                token4 = token;
            } else if (token.getToknum() == 10009) {
                marker = this.tm.getMarker();
                this.tm.setMarker(marker);
                this.tm.ungetToken();
                boolean bl5 = this.sa == null || this.sa.parVds == null || this.kind != 1;
                variableName2 = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, bl5);
                if (variableName2 != null && variableName2.getVarDecl().getLevel() == 88) {
                    throw new GeneralErrorException(213, 4, variableName2.getNameToken(), variableName2.getName(), this.error);
                }
                if (token2 != null) {
                    object5 = variableName2.getVarDecl();
                    if (!((VariableDeclaration)object5).checkDimension(1)) {
                        throw new GeneralErrorException(163, 4, variableName2.getNameToken(), variableName2.getNameToken().getWord(), this.error);
                    }
                } else if (this.sa != null) {
                    this.sa.checkDimension(variableName2);
                }
                token4 = token;
                if (!bl5 && variableName2 != null && variableName2.varDecl != null) {
                    this.sa.parVds.attrVariables.addItem(variableName2.varDecl);
                }
            } else {
                if (this.toknumValueIS_IN == 526) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
                bl = true;
            }
            if (!bl) {
                token = this.tm.getToken();
                if (token.getToknum() == 43 || token.getToknum() == 45 || token.getToknum() == 42 || token.getToknum() == 47) {
                    bl = true;
                    if (marker != null) {
                        this.tm.rewindToMarker(marker);
                    } else {
                        this.tm.ungetToken();
                    }
                    variableName2 = null;
                    token3 = null;
                } else {
                    if (variableName2 != null) {
                        String string = null;
                        if (token2 != null) {
                            string = token2.getWord().toUpperCase();
                        }
                        propElement = new PropElement(object3, new PropElementValue(variableName2, bl2), (Object)string);
                        this.controlProperties.put(propElement);
                    } else if (token3 != null) {
                        propElement = new PropElement(object3, new PropElementValue(token3, bl2), null);
                        this.controlProperties.put(propElement);
                    }
                    variableName2 = null;
                    token3 = null;
                    this.tm.ungetToken();
                    token = this.remgetToken(token4);
                }
            }
            if (bl) {
                this.tm.ungetToken();
                TokenManager.Marker marker2 = this.tm.getMarker();
                this.tm.setMarker(marker2);
                object5 = new int[]{0};
                expression = new Expression((int[])object5, token, this.sa.par, this.pc, this.tm, this.error);
                if (object5[0] != 0) {
                    throw new GeneralErrorException(44, 4, token, token.getWord(), this.error);
                }
                if (!expression.isNumeric()) {
                    throw new GeneralErrorException(49, 4, token, token.getWord(), this.error);
                }
                if (expression.getType() == 0) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), this.error);
                }
                if (expression.isVoid()) {
                    throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
                }
                propElement = new PropElement(object3, new PropElementValue(expression, bl2), null);
                this.controlProperties.put(propElement);
                expression = null;
                bl = false;
                this.tm.removeToMarker(marker2);
                token = this.tm.getToken();
            }
        }
        if (token.isLength()) {
            if ((token = this.putPropertiesLENGTH(token, propElement)).getToknum() == 505) {
                token = this.putPropertiesGIVING(token, propElement);
            }
        } else if (token.getToknum() == 505 && (token = this.putPropertiesGIVING(token, propElement)).isLength()) {
            token = this.putPropertiesLENGTH(token, propElement);
        }
        return token;
    }

    private Token putPropertiesLENGTH(Token token, PropElement propElement) throws GeneralErrorException, EndOfProgramException {
        if ((token = this.remgetToken(token)).getToknum() == 277 || token.getToknum() == this.toknumValueIS_IN || token.getToknum() == 61) {
            token = this.remgetToken(token);
        }
        if (Token.isNumLit(token)) {
            propElement.setVarLength(token);
            token = this.remgetToken(token);
        } else if (token.getToknum() == 10009) {
            propElement.setVarLength(this.localVariableNameGet());
            token = this.remgetToken(token);
        } else {
            throw new ExpectedFoundException(token, this.error, "literal");
        }
        return token;
    }

    private Token putPropertiesGIVING(Token token, PropElement propElement) throws GeneralErrorException, EndOfProgramException {
        if ((token = this.remgetToken(token)).getToknum() != 10009) {
            throw new ExpectedFoundException(token, this.error, "literal");
        }
        propElement.setVarGiving(this.localVariableNameGet());
        token = this.remgetToken(token);
        return token;
    }

    @Override
    public int getGraphicControlType() {
        return this.graphicControlType;
    }

    void setGraphicControlType(int n2) {
        this.graphicControlType = n2;
        if (this.sa != null) {
            this.sa.gct = n2;
        }
    }

    boolean isSpecialProperties(Token token) throws GeneralErrorException, EndOfProgramException {
        boolean bl = false;
        boolean bl2 = false;
        Token token2 = null;
        if (token.getToknum() == 657) {
            token = this.remgetToken(token);
            bl2 = true;
        }
        token2 = token;
        String string = token.getWord().toUpperCase();
        GUIControl.checkControlProperty(string, token, this.graphicControlType, this.error, this.guiWd2UnsupportedLog);
        bl = GUIControl.containsProperty(token, string, this.graphicControlType, this.error);
        if (bl) {
            token = this.putProperties(string, token);
        } else if (bl2) {
            token = this.putProperties(token2, token);
        }
        return bl || bl2;
    }

    static boolean containsProperty(Token token, String string, int n2, Errors errors) throws GeneralErrorException {
        if (eisWords.contains(string)) {
            Pcc.checkEIS(token, errors, true);
        }
        switch (n2) {
            case 1: {
                if (!globalPropertyWords.contains(string) && !labelPropertiesWords.contains(string)) break;
                return true;
            }
            case 2: {
                if (!globalPropertyWords.contains(string) && !entryFieldPropertiesWords.contains(string)) break;
                return true;
            }
            case 3: {
                if (!globalPropertyWords.contains(string) && !pushButtonPropertiesWords.contains(string)) break;
                return true;
            }
            case 4: {
                if (!globalPropertyWords.contains(string) && !checkBoxPropertiesWords.contains(string)) break;
                return true;
            }
            case 5: {
                if (!globalPropertyWords.contains(string) && !radioButtonPropertiesWords.contains(string)) break;
                return true;
            }
            case 8: {
                if (!globalPropertyWords.contains(string) && !comboBoxPropertiesWords.contains(string)) break;
                return true;
            }
            case 9: {
                if (!globalPropertyWords.contains(string) && !framePropertiesWords.contains(string)) break;
                return true;
            }
            case 13: {
                if (!globalPropertyWords.contains(string) && !bitmapPropertiesWords.contains(string)) break;
                return true;
            }
            case 21: {
                if (ribbonPropertiesWords.contains(string)) {
                    return true;
                }
            }
            case 23: {
                if (iwcPanelPropertiesWords.contains(string)) {
                    return true;
                }
            }
            case 10: {
                if (!globalPropertyWords.contains(string) && !tabPropertiesWords.contains(string)) break;
                return true;
            }
            case 7: {
                if (!globalPropertyWords.contains(string) && !listBoxPropertiesWords.contains(string)) break;
                return true;
            }
            case 12: {
                if (!globalPropertyWords.contains(string) && !gridPropertiesWords.contains(string)) break;
                return true;
            }
            case 14: {
                if (!globalPropertyWords.contains(string) && !treePropertiesWords.contains(string)) break;
                return true;
            }
            case 11: {
                if (!globalPropertyWords.contains(string) && !barPropertiesWords.contains(string)) break;
                return true;
            }
            case 17: {
                if (!globalPropertyWords.contains(string) && !statusBarPropertiesWords.contains(string)) break;
                return true;
            }
            case 15: {
                if (!globalPropertyWords.contains(string) && !webBrowserPropertiesWords.contains(string) && !webBrowserUnsupportedPropertiesWords.contains(string)) break;
                return true;
            }
            case 6: {
                if (!globalPropertyWords.contains(string) && !scrollBarPropertiesWords.contains(string)) break;
                return true;
            }
            case 18: {
                if (!globalPropertyWords.contains(string) && !sliderPropertiesWords.contains(string)) break;
                return true;
            }
            case 19: {
                if (!globalPropertyWords.contains(string) && !javaBeanPropertiesWords.contains(string)) break;
                return true;
            }
            case 20: {
                if (!globalPropertyWords.contains(string) && !dateEntryPropertiesWords.contains(string)) break;
                return true;
            }
            case 22: {
                if (!scrollPanePropertiesWords.contains(string)) break;
                return true;
            }
            case 24: {
                if (!globalPropertyWords.contains(string) && !chipsBoxPropertiesWords.contains(string)) break;
                return true;
            }
            default: {
                if (!globalPropertyWords.contains(string)) break;
                return true;
            }
        }
        return false;
    }

    boolean is3D(Token token) throws GeneralErrorException, EndOfProgramException {
        boolean bl = false;
        Token token2 = null;
        Token token3 = null;
        if (token.getToknum() == 10002 && token.getWord().equals("3")) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 45) {
                this.tm.ungetToken();
            } else {
                token3 = this.tm.getToken();
                if (token3 != null && token3.getWord().equalsIgnoreCase("D")) {
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                    token = this.remgetToken(token);
                    token = this.remgetToken(token2);
                    token = this.remgetToken(token3);
                    this.controlStyles.add("3-D");
                    bl = true;
                } else {
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                }
            }
        }
        return bl;
    }

    boolean isControlStyle(Token token, boolean bl) throws GeneralErrorException, EndOfProgramException {
        boolean bl2 = false;
        bl2 = GUIControl.containsStyle(token, this.graphicControlType, this.error, this.guiWd2UnsupportedLog);
        if (bl2) {
            String string = token.getWord().toUpperCase();
            if (bl) {
                this.controlStyles.add("!" + string);
            } else {
                this.controlStyles.add(string);
            }
            this.checktabcontrolstyle();
            this.remgetToken(token);
        }
        return bl2;
    }

    static boolean containsStyle(Token token, int n2, Errors errors, boolean bl) {
        String string = token.getWord().toUpperCase();
        GUIControl.checkControlStyle(string, token, n2, errors, bl);
        switch (n2) {
            case 1: {
                if (!globalStyleWords.contains(string) && !labelStyleWords.contains(string)) break;
                return true;
            }
            case 2: {
                if (!globalStyleWords.contains(string) && !entryFieldStyleWords.contains(string)) break;
                return true;
            }
            case 3: {
                if (!globalStyleWords.contains(string) && !pushButtonStyleWords.contains(string)) break;
                return true;
            }
            case 4: {
                if (!globalStyleWords.contains(string) && !checkBoxStyleWords.contains(string)) break;
                return true;
            }
            case 5: {
                if (!globalStyleWords.contains(string) && !radioButtonStyleWords.contains(string)) break;
                return true;
            }
            case 8: {
                if (string.equals("STATIC-LIST")) {
                    errors.print(19, 2, token, "STATIC-LIST combo-box style");
                }
                if (!globalStyleWords.contains(string) && !comboBoxStyleWords.contains(string)) break;
                return true;
            }
            case 9: {
                if (!globalStyleWords.contains(string) && !frameStyleWords.contains(string)) break;
                return true;
            }
            case 21: {
                if (!globalStyleWords.contains(string) && !ribbonStyleWords.contains(string)) break;
                return true;
            }
            case 23: {
                if (!globalStyleWords.contains(string) && !iwcPanelStyleWords.contains(string)) break;
                return true;
            }
            case 10: {
                if (string.equals("HOT-TRACK")) {
                    errors.print(19, 2, token, "HOT-TRACK tab control style");
                } else if (string.equals("NO-DIVIDERS")) {
                    errors.print(19, 2, token, "NO-DIVIDERS tab control style");
                } else if (string.equals("FIXED-WIDTH")) {
                    errors.print(19, 2, token, "FIXED-WIDTH tab control style");
                } else if (string.equals("NO-FOCUS")) {
                    errors.print(19, 2, token, "NO-FOCUS tab control style");
                }
                if (!globalStyleWords.contains(string) && !tabStyleWords.contains(string)) break;
                return true;
            }
            case 7: {
                if (!globalStyleWords.contains(string) && !listBoxStyleWords.contains(string)) break;
                return true;
            }
            case 12: {
                if (!globalStyleWords.contains(string) && !gridStyleWords.contains(string)) break;
                return true;
            }
            case 14: {
                if (!globalStyleWords.contains(string) && !treeStyleWords.contains(string)) break;
                return true;
            }
            case 13: {
                if (!globalStyleWords.contains(string)) break;
                return true;
            }
            case 11: {
                if (!globalStyleWords.contains(string) && !barStyleWords.contains(string)) break;
                return true;
            }
            case 17: {
                if (!globalStyleWords.contains(string) && !statusBarStyleWords.contains(string)) break;
                return true;
            }
            case 15: {
                if (!globalStyleWords.contains(string) && !webBrowserStyleWords.contains(string)) break;
                return true;
            }
            case 6: {
                if (!globalStyleWords.contains(string) && !scrollBarStyleWords.contains(string)) break;
                return true;
            }
            case 18: {
                if (!globalStyleWords.contains(string) && !sliderStyleWords.contains(string)) break;
                return true;
            }
            case 19: {
                if (!globalStyleWords.contains(string) && !javaBeanStyleWords.contains(string)) break;
                return true;
            }
            case 20: {
                if (!globalStyleWords.contains(string) && !dateEntryStyleWords.contains(string)) break;
                return true;
            }
            case 22: {
                if (!globalStyleWords.contains(string) && !scrollPaneStyleWords.contains(string)) break;
                return true;
            }
            case 24: {
                if (!globalStyleWords.contains(string)) break;
                return true;
            }
        }
        return false;
    }

    public boolean tokenIsAttrScreen(Token token, TokenManager tokenManager) throws GeneralErrorException, EndOfProgramException {
        boolean bl = true;
        this.tm = tokenManager;
        if (token.getToknum() == 598) {
            if (this.kind != 4) {
                return false;
            }
            token = this.tm.getToken();
            if (token != null && token.getToknum() == 813) {
                token = this.tm.getToken();
            }
            boolean bl2 = this.isControlStyle(token, true);
            this.tm.ungetToken();
            if (!bl2) {
                return false;
            }
            this.tm.ungetToken();
            token = this.tm.getToken();
            token = this.remgetToken(token);
            return true;
        }
        if (token != null && token.getToknum() == 813) {
            token = this.tm.getToken();
        }
        if (this.isControlStyle(token, false)) {
            bl = true;
        } else if (!this.isGlobalGroupProperty(token) && this.isSpecialProperties(token) || this.is3D(token)) {
            bl = true;
        } else if (!this.sa.tokenIsAttrScreen(token, tokenManager, this.keyWord, this.graphicControlType)) {
            bl = false;
            if (!this.sa.haveTitle() && token.getToknum() == 10001) {
                this.sa.setTitle(token);
                token = this.remgetToken(token);
                bl = true;
            }
        }
        return bl;
    }

    private boolean isGlobalGroupProperty(Token token) {
        return this.getGraphicControlType() < 0 && globalPropertyWords.contains(token.getWord());
    }

    public boolean tokenIsTitleVar(TokenManager tokenManager, Token token) throws GeneralErrorException, EndOfProgramException {
        boolean bl = false;
        if (token != null && token.getToknum() == 10009 && !this.sa.haveTitle()) {
            this.sa.setTitle(this.localVariableNameGet());
            token = this.remgetToken(token);
            tokenManager.ungetToken();
            bl = true;
        }
        return bl;
    }

    public boolean tokenIsTitleVar(TokenManager tokenManager) throws GeneralErrorException, EndOfProgramException {
        this.tm = tokenManager;
        Token token = this.tm.getToken();
        boolean bl = false;
        if (token != null) {
            if (!(this.isControlStyle(token, false) || this.isSpecialProperties(token) || this.is3D(token) || this.sa.allTokenIsAttrScreen(token, tokenManager, this.keyWord, this.graphicControlType, false))) {
                if (!this.tokenIsTitleVar(tokenManager, token)) {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
        }
        return bl;
    }

    void check(Verb verb) throws GeneralErrorException {
        int n2 = this.controlProperties.size();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.controlProperties.getKey(i2).toString().toUpperCase();
            hashSet.add(string);
            PropElementValue[] propElementValueArray = this.controlProperties.getValue(i2);
            for (int i3 = 0; i3 < propElementValueArray.length; ++i3) {
                Expression expression = propElementValueArray[i3].getExpression();
                if (expression == null) continue;
                expression.check();
            }
        }
        if (hashSet.contains("DRAG-MODE")) {
            switch (this.graphicControlType) {
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.error.print(304, 2, this.name, null);
                }
            }
        }
        switch (this.graphicControlType) {
            case 7: 
            case 10: 
            case 21: 
            case 22: {
                if (!hashSet.contains("BACKGROUND-BITMAP-HANDLE") && !hashSet.contains("BACKGROUND-BITMAP-SCALE") || !hashSet.contains("GRADIENT-ORIENTATION") && !hashSet.contains("GRADIENT-COLOR-1") && !hashSet.contains("GRADIENT-COLOR-2")) break;
                this.error.print(258, 2, this.name, null);
                break;
            }
            case 14: {
                if (this.controlStyles.contains("TABLE-VIEW")) {
                    if (hashSet.contains("SELECTION-MODE")) {
                        this.error.print(266, 2, this.name, null);
                        break;
                    }
                    if (hashSet.contains("GRADIENT-ORIENTATION") || hashSet.contains("GRADIENT-COLOR-1") || hashSet.contains("GRADIENT-COLOR-2")) {
                        this.error.print(258, 2, this.name, null);
                    }
                    if (hashSet.contains("BACKGROUND-BITMAP-HANDLE") || hashSet.contains("BACKGROUND-BITMAP-SCALE")) {
                        this.error.print(280, 2, this.name, null);
                    }
                    if (!hashSet.contains("DRAG-MODE")) break;
                    this.error.print(303, 2, this.name, null);
                    break;
                }
                if (!hashSet.contains("BACKGROUND-BITMAP-HANDLE") && !hashSet.contains("BACKGROUND-BITMAP-SCALE") || !hashSet.contains("GRADIENT-ORIENTATION") && !hashSet.contains("GRADIENT-COLOR-1") && !hashSet.contains("GRADIENT-COLOR-2")) break;
                this.error.print(258, 2, this.name, null);
                break;
            }
            case 9: {
                if (hashSet.contains("FILL-COLOR") || hashSet.contains("FILL-COLOR2")) {
                    if (hashSet.contains("GRADIENT-ORIENTATION") || hashSet.contains("GRADIENT-COLOR-1") || hashSet.contains("GRADIENT-COLOR-2")) {
                        this.error.print(258, 2, this.name, null);
                    }
                    if (!hashSet.contains("BACKGROUND-BITMAP-HANDLE") && !hashSet.contains("BACKGROUND-BITMAP-SCALE")) break;
                    this.error.print(280, 2, this.name, null);
                    break;
                }
                if (!hashSet.contains("BACKGROUND-BITMAP-HANDLE") && !hashSet.contains("BACKGROUND-BITMAP-SCALE") || !hashSet.contains("GRADIENT-ORIENTATION") && !hashSet.contains("GRADIENT-COLOR-1") && !hashSet.contains("GRADIENT-COLOR-2")) break;
                this.error.print(258, 2, this.name, null);
                break;
            }
            case 19: {
                if (verb != null && !(verb instanceof Display) || hashSet.contains("CLSID")) break;
                this.error.print(278, 2, this.name, null);
            }
        }
        if (this.sa != null) {
            this.sa.check(verb != null ? verb.parent.parent : null);
        }
    }

    public StringBuffer getGraphicalScreenCodeHeader(VariableDeclaration variableDeclaration, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.graphicControlType) {
            case 1: {
                stringBuffer.append("ScrFactory.getGUILabel(");
                break;
            }
            case 2: {
                stringBuffer.append("ScrFactory.getGUIEntryField(");
                break;
            }
            case 3: {
                stringBuffer.append("ScrFactory.getGUIPushButton(");
                break;
            }
            case 4: {
                stringBuffer.append("ScrFactory.getGUICheckBox(");
                break;
            }
            case 5: {
                stringBuffer.append("ScrFactory.getGUIRadioButton(");
                break;
            }
            case 8: {
                stringBuffer.append("ScrFactory.getGUIComboBox(");
                break;
            }
            case 9: {
                stringBuffer.append("ScrFactory.getGUIFrame(");
                break;
            }
            case 13: {
                stringBuffer.append("ScrFactory.getGUIBitmap(");
                break;
            }
            case 21: {
                stringBuffer.append("ScrFactory.getGUIRibbon(");
                break;
            }
            case 23: {
                stringBuffer.append("ScrFactory.getGUIIWCPanel(");
                break;
            }
            case 10: {
                stringBuffer.append("ScrFactory.getGUITab(");
                break;
            }
            case 7: {
                stringBuffer.append("ScrFactory.getGUIListBox(");
                break;
            }
            case 12: {
                stringBuffer.append("ScrFactory.getGUIGrid(");
                break;
            }
            case 14: {
                stringBuffer.append("ScrFactory.getGUITreeView(");
                if (this.pc.optionMS && this.kind == 1 && this.sa != null && this.sa.parVds != null && this.sa.parVds.getGraphicControlType() == -1) {
                    stringBuffer.append("params.getCrtStatus(), params.getScreenControl(), params.getEventStatus()");
                } else {
                    stringBuffer.append(this.pc.getCodeScreenCrtStatusSpecialNames());
                    stringBuffer.append(this.pc.getCodeScreenScreenControlSpecialNames());
                    stringBuffer.append(this.pc.getCodeScreenEventStatusSpecialNames());
                }
                stringBuffer.append(", ");
                break;
            }
            case 17: {
                stringBuffer.append("ScrFactory.getGUIStatusBar(");
                break;
            }
            case 11: {
                stringBuffer.append("ScrFactory.getGUIBar(");
                break;
            }
            case 15: {
                stringBuffer.append("ScrFactory.getGUIWebBrowser(");
                break;
            }
            case 6: {
                stringBuffer.append("ScrFactory.getGUIScrollBar(");
                break;
            }
            case 18: {
                stringBuffer.append("ScrFactory.getGUISlider(");
                break;
            }
            case 19: {
                stringBuffer.append("ScrFactory.getGUIJavaBean(");
                break;
            }
            case 20: {
                stringBuffer.append("ScrFactory.getGUIDateEntry(");
                break;
            }
            case 22: {
                stringBuffer.append("ScrFactory.getGUIScrollPane(");
                break;
            }
            case 24: {
                stringBuffer.append("ScrFactory.getGUIChipsBox(");
            }
        }
        if (this.name != null) {
            if (string != null) {
                stringBuffer.append("\"" + string + "\"");
            } else {
                stringBuffer.append("\"" + this.name.getWord() + "\"");
            }
        }
        if (variableDeclaration != null) {
            if (variableDeclaration instanceof VariableDeclarationScreen) {
                VariableDeclarationScreen variableDeclarationScreen = (VariableDeclarationScreen)variableDeclaration;
                if (variableDeclarationScreen.getGuiControl() != null && variableDeclarationScreen.getGuiControl().getGraphicControlType() != -1) {
                    VariableDeclaration variableDeclaration2 = variableDeclaration.getGrandPa();
                    stringBuffer.append(", " + variableDeclaration2.getDeclUnivoqueName());
                } else {
                    stringBuffer.append(", " + variableDeclaration.getDeclUnivoqueName());
                }
            } else {
                stringBuffer.append(", " + variableDeclaration.getDeclUnivoqueName());
            }
        } else {
            stringBuffer.append(", (BaseGUIControl)null");
        }
        stringBuffer.append(")");
        return stringBuffer;
    }

    public StringBuffer getControlStyleScreenCodeTail(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equalsIgnoreCase(".set") && this.graphicControlType == 13) {
            stringBuffer.append(".setStyle(\"USE-NOTIFY-MOUSE\")");
        }
        for (String string2 : this.controlStyles) {
            if (string2.charAt(0) == '!') {
                stringBuffer.append(string + "UnsetStyle(\"" + string2.substring(1) + "\")");
                continue;
            }
            stringBuffer.append(string + "Style(\"" + string2 + "\")");
        }
        return stringBuffer;
    }

    public StringBuffer getGraphicalScreenCodeTail(Token token, String string) {
        return this.getGraphicalScreenCodeTail(token, string, true);
    }

    public StringBuffer getGraphicalScreenCodeTail(Token token, String string, boolean bl) {
        return this.getGraphicalScreenCodeTail(token, string, bl, false);
    }

    public StringBuffer getGraphicalScreenCodeTail(Token token, String string, boolean bl, boolean bl2) {
        return this.getGraphicalScreenCodeTail(token, string, bl, bl2, false);
    }

    public StringBuffer getGraphicalScreenCodeTail(Token token, String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equalsIgnoreCase(".set") && this.graphicControlType == 12 && this.tm.getDecimalPointIsComma().equals("true")) {
            stringBuffer.append(".setStyle(\"DECIMAL-POINT-IS-COMMA\")");
        }
        stringBuffer.append(this.sa.getGraphicalScreenAttributeCode(token, string, string, bl, bl2, bl3));
        int n2 = this.controlProperties.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.controlProperties.getKey(i2);
            PropElementValue[] propElementValueArray = this.controlProperties.getValue(i2);
            Object object2 = this.controlProperties.getVarLength(i2);
            Object object3 = this.controlProperties.getVarGiving(i2);
            String string2 = null;
            String string3 = null;
            if (object instanceof String) {
                string2 = string3 = "\"" + ((String)object).toUpperCase();
                if (propElementValueArray.length > 0 && propElementValueArray[0] != null && propElementValueArray[0].isRgb()) {
                    string3 = string3 + "-RGB";
                }
                string3 = string3 + "\"";
            } else if (object instanceof Token) {
                string2 = string3 = this.tm.getCodeLiteral((Token)object);
            } else if (object instanceof VariableName) {
                string2 = string3 = ((VariableName)object).getCode();
            }
            if (object2 != null) {
                if (object2 instanceof String) {
                    stringBuffer.append(string + "PropLength(" + string3 + ", \"" + ((String)object2).toUpperCase() + "\")");
                } else if (object2 instanceof VariableName) {
                    stringBuffer.append(string + "PropLength(" + string3 + ", " + this.sa.printVariableName((VariableName)object2) + ")");
                } else if (object2 instanceof Token) {
                    stringBuffer.append(string + "PropLength(" + string3 + ", " + this.tm.getCodeLiteral((Token)object2) + ")");
                }
            }
            if (object3 != null) {
                stringBuffer.append(string + "PropGiving(" + string3 + ", " + this.sa.printVariableName((VariableName)object3) + ")");
            }
            for (int i3 = 0; i3 < propElementValueArray.length; ++i3) {
                string3 = string2;
                if (object instanceof String) {
                    if (propElementValueArray[i3].isRgb()) {
                        string3 = string3 + "-RGB";
                    }
                    string3 = string3 + "\"";
                }
                stringBuffer.append(string + "Prop(");
                if ((string.equalsIgnoreCase(".set") || string.equalsIgnoreCase(".modify")) && string3.equalsIgnoreCase("\"ACTION\"")) {
                    if (this.pc.optionMS && this.kind == 1 && this.sa != null && this.sa.parVds != null && this.sa.parVds.getGraphicControlType() == -1) {
                        stringBuffer.append("params.getCrtStatus(), params.getScreenControl(), params.getEventStatus()");
                    } else {
                        stringBuffer.append(this.pc.getCodeScreenCrtStatusSpecialNames());
                        stringBuffer.append(this.pc.getCodeScreenScreenControlSpecialNames());
                        stringBuffer.append(this.pc.getCodeScreenEventStatusSpecialNames());
                    }
                    stringBuffer.append(", null, ");
                }
                stringBuffer.append(string3 + ", ");
                Token token2 = propElementValueArray[i3].getToken();
                if (token2 != null) {
                    stringBuffer.append(this.tm.getCodeLiteral(token2));
                } else {
                    VariableName variableName = propElementValueArray[i3].getVariableName();
                    if (variableName != null) {
                        stringBuffer.append(this.sa.printVariableName(variableName));
                    } else {
                        Expression expression = propElementValueArray[i3].getExpression();
                        if (expression != null) {
                            if (this.pc.optionMS) {
                                stringBuffer.append("Num.get(" + expression.getCode() + ".intValue())");
                            } else {
                                stringBuffer.append("Factory.getNumLiteral((long)(" + expression.getCode() + ".intValue()), 18, 0, false)");
                            }
                        }
                    }
                }
                Object object4 = this.controlProperties.getTabMul(i2);
                if (object4 != null) {
                    stringBuffer.append(" ,\"" + ((String)object4).toUpperCase() + "\"");
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer;
    }

    String getScreenCodeType(Token token, char[] cArray, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.graphicControlType != -1) {
            stringBuffer.append("GUI");
        }
        switch (this.graphicControlType) {
            case 1: {
                stringBuffer.append("Label");
                break;
            }
            case 2: {
                stringBuffer.append("EntryField");
                break;
            }
            case 3: {
                stringBuffer.append("PushButton");
                break;
            }
            case 4: {
                stringBuffer.append("CheckBox");
                break;
            }
            case 5: {
                stringBuffer.append("RadioButton");
                break;
            }
            case 8: {
                stringBuffer.append("ComboBox");
                break;
            }
            case 9: {
                stringBuffer.append("Frame");
                break;
            }
            case 13: {
                stringBuffer.append("Bitmap");
                break;
            }
            case 21: {
                stringBuffer.append("Ribbon");
                break;
            }
            case 23: {
                stringBuffer.append("IWCPanel");
                break;
            }
            case 10: {
                stringBuffer.append("Tab");
                break;
            }
            case 7: {
                stringBuffer.append("ListBox");
                break;
            }
            case 12: {
                stringBuffer.append("Grid");
                break;
            }
            case 14: {
                stringBuffer.append("TreeView");
                break;
            }
            case 17: {
                stringBuffer.append("StatusBar");
                break;
            }
            case 11: {
                stringBuffer.append("Bar");
                break;
            }
            case 15: {
                stringBuffer.append("WebBrowser");
                break;
            }
            case 6: {
                stringBuffer.append("ScrollBar");
                break;
            }
            case 18: {
                stringBuffer.append("Slider");
                break;
            }
            case 19: {
                stringBuffer.append("JavaBean");
                break;
            }
            case 20: {
                stringBuffer.append("DateEntry");
                break;
            }
            case 22: {
                stringBuffer.append("ScrollPane");
                break;
            }
            case 24: {
                stringBuffer.append("ChipsBox");
                break;
            }
            default: {
                stringBuffer.append(this.sa.getScreenAttributeCodeHeaderType(cArray, n2, bl));
            }
        }
        return stringBuffer.toString();
    }

    public boolean hasProcedureAfter() {
        return this.sa.attrAFTER_p1 != null;
    }

    public boolean hasProcedureBefore() {
        return this.sa.attrBEFORE_p1 != null;
    }

    public boolean hasProcedureEvent() {
        return this.sa.attrEVENT_p1 != null;
    }

    public boolean hasProcedureException() {
        return this.sa.attrEXCEPTION_p1 != null;
    }

    public void setTitle(Token token) {
        this.sa.setTitle(token);
    }

    public void setIndexXY(int n2, int n3) {
        if (this.sa != null) {
            this.sa.setIndexXY(n2, n3);
        }
    }

    private void checkControlType(Token token) {
        if (this.guiWd2UnsupportedLog) {
            switch (this.graphicControlType) {
                case -1: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.error.print(179, 2, token, GUIControl.getGCN(this.graphicControlType) + " control");
                    break;
                }
            }
        }
    }

    static void checkControlStyle(String string, Token token, int n2, Errors errors, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (globalUnsupportedWD2StyleWords.contains(string)) {
                bl2 = true;
            }
            switch (n2) {
                case 1: {
                    if (!labelUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (!entryFieldUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 3: {
                    if (!pushButtonUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (!checkBoxUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 5: {
                    if (!radioButtonUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 8: {
                    if (!comboBoxUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 9: {
                    if (!frameUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 10: 
                case 21: {
                    if (!tabUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 7: {
                    if (!listBoxUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 12: {
                    if (!gridUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 14: {
                    if (!treeUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 19: {
                    if (!javaBeanUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 20: {
                    if (!dateEntryUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 11: {
                    if (!barUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 24: {
                    if (!chipsBoxUnsupportedWD2StyleWords.contains(string)) break;
                    bl2 = true;
                }
            }
            if (bl2) {
                errors.print(179, 2, token, token.getWord().toUpperCase() + " in " + GUIControl.getGCN(n2) + " control");
            }
        }
    }

    static void checkControlProperty(String string, Token token, int n2, Errors errors, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (globalUnsupportedWD2PropertiesWords.contains(string)) {
                bl2 = true;
            }
            switch (n2) {
                case 1: {
                    if (!labelUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (!entryFieldUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 3: {
                    if (!pushButtonUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (!checkBoxUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 5: {
                    if (!radioButtonUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 8: {
                    if (!comboBoxUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 9: {
                    if (!frameUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 10: 
                case 21: {
                    if (!tabUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 7: {
                    if (!listBoxUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 12: {
                    if (!gridUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 14: {
                    if (!treeUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 13: {
                    if (!bitmapUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 19: {
                    if (!javaBeanUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 20: {
                    if (!dateEntryUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                    break;
                }
                case 24: {
                    if (!chipsBoxUnsupportedWD2PropertiesWords.contains(string)) break;
                    bl2 = true;
                }
            }
            if (bl2) {
                errors.print(179, 2, token, token.getWord().toUpperCase() + " in " + GUIControl.getGCN(n2) + " control");
            }
        } else if (n2 == 15 && webBrowserUnsupportedPropertiesWords.contains(string)) {
            errors.print(19, 2, token, token.getWord().toUpperCase() + " in " + GUIControl.getGCN(n2) + " control");
        }
    }

    @Override
    public ScreenAttribute getSa() {
        return this.sa;
    }

    @Override
    public Vector<String> getControlStyles() {
        return new Vector<String>(this.controlStyles);
    }

    @Override
    public PropElementList getControlProperties() {
        return this.controlProperties;
    }

    static int getGCT(String string) {
        Integer n2 = controlIds.get(string);
        return n2 != null ? n2 : -1;
    }

    static String getGCN(int n2) {
        String string = controlNames.get(n2);
        return string != null ? string : "";
    }

    void checktabcontrolstyle() {
        if (this.graphicControlType == 10 && (this.controlStyles.contains("NO-BOX") || this.controlStyles.contains("BUTTONS")) && (this.controlStyles.contains("ACCORDION") || this.controlStyles.contains("ALLOW-CONTAINER"))) {
            this.error.print(277, 2, this.name, null);
            this.controlStyles.remove("NO-BOX");
            this.controlStyles.remove("BUTTONS");
        }
    }

    static {
        windowPropertyNames.add("BACKGROUND-BITMAP-HANDLE");
        windowPropertyNames.add("BACKGROUND-BITMAP-SCALE");
        windowPropertyNames.add("CUSTOM-DATA");
        windowPropertyNames.add("GRADIENT-COLOR-1");
        windowPropertyNames.add("GRADIENT-COLOR-2");
        windowPropertyNames.add("GRADIENT-ORIENTATION");
        windowPropertyNames.add("SCREEN-INDEX");
        windowPropertyNames.add("WINDOW-STATE");
        controlIds.put("BAR", 11);
        controlIds.put("BITMAP", 13);
        controlIds.put("CHECK-BOX", 4);
        controlIds.put("CHIPS-BOX", 24);
        controlIds.put("COMBO-BOX", 8);
        controlIds.put("DATE-ENTRY", 20);
        controlIds.put("ENTRY-FIELD", 2);
        controlIds.put("FRAME", 9);
        controlIds.put("GRID", 12);
        controlIds.put("IWC-PANEL", 23);
        controlIds.put("JAVA-BEAN", 19);
        controlIds.put("LABEL", 1);
        controlIds.put("LIST-BOX", 7);
        controlIds.put("OLE", 16);
        controlIds.put("PUSH-BUTTON", 3);
        controlIds.put("RADIO-BUTTON", 5);
        controlIds.put("RIBBON", 21);
        controlIds.put("SCROLL-BAR", 6);
        controlIds.put("SCROLL-PANE", 22);
        controlIds.put("SLIDER", 18);
        controlIds.put("STATUS-BAR", 17);
        controlIds.put("TAB-CONTROL", 10);
        controlIds.put("TREE-VIEW", 14);
        controlIds.put("WEB-BROWSER", 15);
        for (String string : controlIds.keySet()) {
            controlNames.put(controlIds.get(string), string);
        }
        eisWords.add("CSS-BASE-STYLE-NAME");
        eisWords.add("CSS-ICON");
        eisWords.add("CSS-STYLE-NAME");
        eisWords.add("ROWS-PER-PAGE");
        globalStyleWords.add("FLAT");
        globalStyleWords.add("HEIGHT-IN-CELLS");
        globalStyleWords.add("NO-TAB");
        globalStyleWords.add("NOTIFY-MOUSE");
        globalStyleWords.add("OVERLAP-LEFT");
        globalStyleWords.add("OVERLAP-TOP");
        globalStyleWords.add("PERMANENT");
        globalStyleWords.add("TEMPORARY");
        globalStyleWords.add("WIDTH-IN-CELLS");
        globalPropertyWords.add("EVENT-LIST");
        globalPropertyWords.add("EXCLUDE-EVENT-LIST");
        globalPropertyWords.add("HINT");
        globalPropertyWords.add("LAYOUT-DATA");
        globalPropertyWords.add("MAX-HEIGHT");
        globalPropertyWords.add("MAX-WIDTH");
        globalPropertyWords.add("MIN-HEIGHT");
        globalPropertyWords.add("MIN-WIDTH");
        globalPropertyWords.add("PLACEHOLDER");
        globalPropertyWords.add("CSS-BASE-STYLE-NAME");
        globalPropertyWords.add("CSS-STYLE-NAME");
        globalPropertyWords.add("CUSTOM-DATA");
        globalPropertyWords.add(tabgroupProp);
        globalPropertyWords.add(tabgroupvalueProp);
        globalPropertyWords.add(scrollgroupProp);
        globalPropertyWords.add("DRAG-MODE");
        labelStyleWords.add("BOTTOM");
        labelStyleWords.add("CENTER");
        labelStyleWords.add("CENTERED");
        labelStyleWords.add("LEFT");
        labelStyleWords.add("NO-KEY-LETTER");
        labelStyleWords.add("RIGHT");
        labelStyleWords.add("TOP");
        labelStyleWords.add("TRANSPARENT");
        labelStyleWords.add("VERTICAL");
        labelPropertiesWords.add("LABEL-OFFSET");
        entryFieldStyleWords.add("3-D");
        entryFieldStyleWords.add("AUTO");
        entryFieldStyleWords.add("AUTO-SPIN");
        entryFieldStyleWords.add("BOXED");
        entryFieldStyleWords.add("CENTER");
        entryFieldStyleWords.add("CENTERED");
        entryFieldStyleWords.add("EMPTY-CHECK");
        entryFieldStyleWords.add("LEFT");
        entryFieldStyleWords.add("LOWER");
        entryFieldStyleWords.add("MULTILINE");
        entryFieldStyleWords.add("NO-AUTOSEL");
        entryFieldStyleWords.add("NO-BOX");
        entryFieldStyleWords.add("NO-WRAP");
        entryFieldStyleWords.add("NOTIFY-CHANGE");
        entryFieldStyleWords.add("NUMERIC");
        entryFieldStyleWords.add("PROPOSALS-UNSORTED");
        entryFieldStyleWords.add("READ-ONLY");
        entryFieldStyleWords.add("RIGHT");
        entryFieldStyleWords.add("SECURE");
        entryFieldStyleWords.add("SPINNER");
        entryFieldStyleWords.add("UPPER");
        entryFieldStyleWords.add("USE-RETURN");
        entryFieldStyleWords.add("USE-TAB");
        entryFieldStyleWords.add("VSCROLL");
        entryFieldStyleWords.add("VSCROLL-BAR");
        entryFieldPropertiesWords.add("ACTION");
        entryFieldPropertiesWords.add("AUTO-DECIMAL");
        entryFieldPropertiesWords.add("BITMAP-DISABLED");
        entryFieldPropertiesWords.add("BITMAP-HANDLE");
        entryFieldPropertiesWords.add("BITMAP-HINT");
        entryFieldPropertiesWords.add("BITMAP-NUMBER");
        entryFieldPropertiesWords.add("BITMAP-ROLLOVER");
        entryFieldPropertiesWords.add("BITMAP-TRAILING-DISABLED");
        entryFieldPropertiesWords.add("BITMAP-TRAILING-HINT");
        entryFieldPropertiesWords.add("BITMAP-TRAILING-NUMBER");
        entryFieldPropertiesWords.add("BITMAP-TRAILING-ROLLOVER");
        entryFieldPropertiesWords.add("BITMAP-WIDTH");
        entryFieldPropertiesWords.add("BORDER-COLOR");
        entryFieldPropertiesWords.add("BORDER-WIDTH");
        entryFieldPropertiesWords.add("CURSOR");
        entryFieldPropertiesWords.add("CURSOR-COL");
        entryFieldPropertiesWords.add("CURSOR-ROW");
        entryFieldPropertiesWords.add("FILL-CHAR");
        entryFieldPropertiesWords.add("FORMAT-STRING");
        entryFieldPropertiesWords.add("FORMAT-TYPE");
        entryFieldPropertiesWords.add("INPUT-FILTER");
        entryFieldPropertiesWords.add("MARGIN-WIDTH");
        entryFieldPropertiesWords.add("MAX-LINES");
        entryFieldPropertiesWords.add("MAX-TEXT");
        entryFieldPropertiesWords.add("MAX-VAL");
        entryFieldPropertiesWords.add("MIN-VAL");
        entryFieldPropertiesWords.add("NOTIFY-CHANGE-DELAY");
        entryFieldPropertiesWords.add("PROPOSAL");
        entryFieldPropertiesWords.add("PROPOSAL-DELAY");
        entryFieldPropertiesWords.add("PROPOSAL-FILTER-TYPE");
        entryFieldPropertiesWords.add("PROPOSAL-INDEX");
        entryFieldPropertiesWords.add("PROPOSAL-MIN-TEXT");
        entryFieldPropertiesWords.add("PROPOSAL-TO-DELETE");
        entryFieldPropertiesWords.add("RESET-PROPOSALS");
        entryFieldPropertiesWords.add("SELECTION-START");
        entryFieldPropertiesWords.add("SELECTION-START-COL");
        entryFieldPropertiesWords.add("SELECTION-START-ROW");
        entryFieldPropertiesWords.add("SELECTION-TEXT");
        entryFieldPropertiesWords.add("SPELL-CHECKING");
        entryFieldPropertiesWords.add("TEXT-ORIENTATION");
        entryFieldPropertiesWords.add("TEXT-WRAPPING");
        entryFieldPropertiesWords.add("VALIDATION-ERRMSG");
        entryFieldPropertiesWords.add("VALIDATION-OPTS");
        entryFieldPropertiesWords.add("VALIDATION-REGEXP");
        entryFieldPropertiesWords.add("VISIBLE-PROPOSAL-COUNT");
        pushButtonStyleWords.add("BITMAP");
        pushButtonStyleWords.add("BOTTOM");
        pushButtonStyleWords.add("CANCEL-BUTTON");
        pushButtonStyleWords.add("CENTER");
        pushButtonStyleWords.add("CENTERED");
        pushButtonStyleWords.add("DEFAULT-BUTTON");
        pushButtonStyleWords.add("ESCAPE-BUTTON");
        pushButtonStyleWords.add("FRAMED");
        pushButtonStyleWords.add("LEFT");
        pushButtonStyleWords.add("MULTILINE");
        pushButtonStyleWords.add("NO-AUTO-DEFAULT");
        pushButtonStyleWords.add("OK-BUTTON");
        pushButtonStyleWords.add("ON-HEADER");
        pushButtonStyleWords.add("RIGHT");
        pushButtonStyleWords.add("SELF-ACT");
        pushButtonStyleWords.add("SQUARE");
        pushButtonStyleWords.add("TOP");
        pushButtonStyleWords.add("TRANSPARENT");
        pushButtonStyleWords.add("UNFRAMED");
        pushButtonStyleWords.add("VERTICAL");
        pushButtonPropertiesWords.add("BITMAP-DEFAULT");
        pushButtonPropertiesWords.add("BITMAP-DISABLED");
        pushButtonPropertiesWords.add("BITMAP-HANDLE");
        pushButtonPropertiesWords.add("BITMAP-NUMBER");
        pushButtonPropertiesWords.add("BITMAP-PRESSED");
        pushButtonPropertiesWords.add("BITMAP-ROLLOVER");
        pushButtonPropertiesWords.add("BITMAP-SCALE");
        pushButtonPropertiesWords.add("BITMAP-WIDTH");
        pushButtonPropertiesWords.add("BORDER-COLOR");
        pushButtonPropertiesWords.add("BORDER-WIDTH");
        pushButtonPropertiesWords.add("CSS-ICON");
        pushButtonPropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        pushButtonPropertiesWords.add("DISABLED-COLOR");
        pushButtonPropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        pushButtonPropertiesWords.add("EXCEPTION-VALUE");
        pushButtonPropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        pushButtonPropertiesWords.add("ROLLOVER-BORDER-COLOR");
        pushButtonPropertiesWords.add("ROLLOVER-COLOR");
        pushButtonPropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        pushButtonPropertiesWords.add("TERMINATION-VALUE");
        pushButtonPropertiesWords.add("TITLE-POSITION");
        pushButtonPropertiesWords.add("TRANSPARENT-COLOR");
        checkBoxStyleWords.add("BITMAP");
        checkBoxStyleWords.add("FRAMED");
        checkBoxStyleWords.add("LEFT-TEXT");
        checkBoxStyleWords.add("MULTILINE");
        checkBoxStyleWords.add("NOTIFY");
        checkBoxStyleWords.add("SELF-ACT");
        checkBoxStyleWords.add("SQUARE");
        checkBoxStyleWords.add("TRANSPARENT");
        checkBoxStyleWords.add("UNFRAMED");
        checkBoxStyleWords.add("VTOP");
        checkBoxPropertiesWords.add("BITMAP-DEFAULT");
        checkBoxPropertiesWords.add("BITMAP-DISABLED");
        checkBoxPropertiesWords.add("BITMAP-DISABLED-SELECTED");
        checkBoxPropertiesWords.add("BITMAP-HANDLE");
        checkBoxPropertiesWords.add("BITMAP-NUMBER");
        checkBoxPropertiesWords.add("BITMAP-PRESSED");
        checkBoxPropertiesWords.add("BITMAP-ROLLOVER");
        checkBoxPropertiesWords.add("BITMAP-ROLLOVER-SELECTED");
        checkBoxPropertiesWords.add("BITMAP-SCALE");
        checkBoxPropertiesWords.add("BITMAP-SELECTED");
        checkBoxPropertiesWords.add("BITMAP-WIDTH");
        checkBoxPropertiesWords.add("CHECK-OFF-VALUE");
        checkBoxPropertiesWords.add("CHECK-ON-VALUE");
        checkBoxPropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        checkBoxPropertiesWords.add("DISABLED-COLOR");
        checkBoxPropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        checkBoxPropertiesWords.add("EXCEPTION-VALUE");
        checkBoxPropertiesWords.add("LEFT-TEXT-ALIGNMENT");
        checkBoxPropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        checkBoxPropertiesWords.add("ROLLOVER-COLOR");
        checkBoxPropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        checkBoxPropertiesWords.add("TERMINATION-VALUE");
        checkBoxPropertiesWords.add("TITLE-POSITION");
        radioButtonStyleWords.add("BITMAP");
        radioButtonStyleWords.add("FRAMED");
        radioButtonStyleWords.add("LEFT-TEXT");
        radioButtonStyleWords.add("MULTILINE");
        radioButtonStyleWords.add("NO-GROUP-TAB");
        radioButtonStyleWords.add("NOTIFY");
        radioButtonStyleWords.add("SELF-ACT");
        radioButtonStyleWords.add("SQUARE");
        radioButtonStyleWords.add("TRANSPARENT");
        radioButtonStyleWords.add("UNFRAMED");
        radioButtonStyleWords.add("VTOP");
        radioButtonPropertiesWords.add("BITMAP-DEFAULT");
        radioButtonPropertiesWords.add("BITMAP-DISABLED");
        radioButtonPropertiesWords.add("BITMAP-DISABLED-SELECTED");
        radioButtonPropertiesWords.add("BITMAP-HANDLE");
        radioButtonPropertiesWords.add("BITMAP-NUMBER");
        radioButtonPropertiesWords.add("BITMAP-PRESSED");
        radioButtonPropertiesWords.add("BITMAP-ROLLOVER");
        radioButtonPropertiesWords.add("BITMAP-ROLLOVER-SELECTED");
        radioButtonPropertiesWords.add("BITMAP-SCALE");
        radioButtonPropertiesWords.add("BITMAP-SELECTED");
        radioButtonPropertiesWords.add("BITMAP-WIDTH");
        radioButtonPropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        radioButtonPropertiesWords.add("DISABLED-COLOR");
        radioButtonPropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        radioButtonPropertiesWords.add("EXCEPTION-VALUE");
        radioButtonPropertiesWords.add("GROUP");
        radioButtonPropertiesWords.add("GROUP-VALUE");
        radioButtonPropertiesWords.add("LEFT-TEXT-ALIGNMENT");
        radioButtonPropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        radioButtonPropertiesWords.add("ROLLOVER-COLOR");
        radioButtonPropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        radioButtonPropertiesWords.add("TERMINATION-VALUE");
        radioButtonPropertiesWords.add("TITLE-POSITION");
        comboBoxStyleWords.add("3-D");
        comboBoxStyleWords.add("BOXED");
        comboBoxStyleWords.add("DROP-DOWN");
        comboBoxStyleWords.add("DROP-LIST");
        comboBoxStyleWords.add("LOWER");
        comboBoxStyleWords.add("NO-AUTOSEL");
        comboBoxStyleWords.add("NO-BOX");
        comboBoxStyleWords.add("NOTIFY-DBLCLICK");
        comboBoxStyleWords.add("NOTIFY-SELCHANGE");
        comboBoxStyleWords.add("STATIC-LIST");
        comboBoxStyleWords.add("UNSORTED");
        comboBoxStyleWords.add("UPPER");
        comboBoxPropertiesWords.add("ACTION");
        comboBoxPropertiesWords.add("BITMAP-HANDLE");
        comboBoxPropertiesWords.add("BITMAP-NUMBER");
        comboBoxPropertiesWords.add("BITMAP-WIDTH");
        comboBoxPropertiesWords.add("CURSOR");
        comboBoxPropertiesWords.add("EXCEPTION-VALUE");
        comboBoxPropertiesWords.add("HIDDEN-DATA");
        comboBoxPropertiesWords.add("INPUT-FILTER");
        comboBoxPropertiesWords.add("INSERTION-INDEX");
        comboBoxPropertiesWords.add("ITEM");
        comboBoxPropertiesWords.add("ITEM-BACKGROUND-COLOR");
        comboBoxPropertiesWords.add("ITEM-COLOR");
        comboBoxPropertiesWords.add("ITEM-FOREGROUND-COLOR");
        comboBoxPropertiesWords.add("ITEM-HEIGHT");
        comboBoxPropertiesWords.add("ITEM-TEXT");
        comboBoxPropertiesWords.add("ITEM-TO-ADD");
        comboBoxPropertiesWords.add("ITEM-TO-DELETE");
        comboBoxPropertiesWords.add("ITEM-VALUE");
        comboBoxPropertiesWords.add("MASS-UPDATE");
        comboBoxPropertiesWords.add("MAX-TEXT");
        comboBoxPropertiesWords.add("QUERY-INDEX");
        comboBoxPropertiesWords.add("RESET-LIST");
        comboBoxPropertiesWords.add("SELECTION-BACKGROUND-COLOR");
        comboBoxPropertiesWords.add("SELECTION-COLOR");
        comboBoxPropertiesWords.add("SELECTION-FOREGROUND-COLOR");
        comboBoxPropertiesWords.add("TERMINATION-VALUE");
        frameStyleWords.add("ALTERNATE");
        frameStyleWords.add("ENGRAVED");
        frameStyleWords.add("FULL-HEIGHT");
        frameStyleWords.add("HEAVY");
        frameStyleWords.add("LOWERED");
        frameStyleWords.add("RAISED");
        frameStyleWords.add("RIMMED");
        frameStyleWords.add("TRANSPARENT");
        frameStyleWords.add("VERY-HEAVY");
        framePropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        framePropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        framePropertiesWords.add("FILL-COLOR");
        framePropertiesWords.add("FILL-COLOR2");
        framePropertiesWords.add("FILL-PERCENT");
        framePropertiesWords.add("GRADIENT-COLOR-1");
        framePropertiesWords.add("GRADIENT-COLOR-2");
        framePropertiesWords.add("GRADIENT-ORIENTATION");
        framePropertiesWords.add("HIGH-COLOR");
        framePropertiesWords.add("LOW-COLOR");
        framePropertiesWords.add("TITLE-POSITION");
        bitmapPropertiesWords.add("BITMAP-END");
        bitmapPropertiesWords.add("BITMAP-HANDLE");
        bitmapPropertiesWords.add("BITMAP-NUMBER");
        bitmapPropertiesWords.add("BITMAP-RAW-HEIGHT");
        bitmapPropertiesWords.add("BITMAP-RAW-WIDTH");
        bitmapPropertiesWords.add("BITMAP-SCALE");
        bitmapPropertiesWords.add("BITMAP-START");
        bitmapPropertiesWords.add("BITMAP-TIMER");
        bitmapPropertiesWords.add("BITMAP-WIDTH");
        bitmapPropertiesWords.add("TRANSPARENT-COLOR");
        listBoxStyleWords.add("3-D");
        listBoxStyleWords.add("BOXED");
        listBoxStyleWords.add("CHECK-LIST");
        listBoxStyleWords.add("LOWER");
        listBoxStyleWords.add("NO-BOX");
        listBoxStyleWords.add("NO-SEARCH");
        listBoxStyleWords.add("NOTIFY-DBLCLICK");
        listBoxStyleWords.add("NOTIFY-SELCHANGE");
        listBoxStyleWords.add("PAGED");
        listBoxStyleWords.add("UNSORTED");
        listBoxStyleWords.add("UPPER");
        listBoxPropertiesWords.add("ACTION");
        listBoxPropertiesWords.add("ALIGNMENT");
        listBoxPropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        listBoxPropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        listBoxPropertiesWords.add("BORDER-COLOR");
        listBoxPropertiesWords.add("BORDER-WIDTH");
        listBoxPropertiesWords.add("DATA-COLUMNS");
        listBoxPropertiesWords.add("DISPLAY-COLUMNS");
        listBoxPropertiesWords.add("DIVIDERS");
        listBoxPropertiesWords.add("EXCEPTION-VALUE");
        listBoxPropertiesWords.add("EXPORT-FILE-FORMAT");
        listBoxPropertiesWords.add("EXPORT-FILE-NAME");
        listBoxPropertiesWords.add("EXPORT-FILE-OPEN");
        listBoxPropertiesWords.add("GRADIENT-COLOR-1");
        listBoxPropertiesWords.add("GRADIENT-COLOR-2");
        listBoxPropertiesWords.add("GRADIENT-ORIENTATION");
        listBoxPropertiesWords.add("HIDDEN-DATA");
        listBoxPropertiesWords.add("INSERTION-INDEX");
        listBoxPropertiesWords.add("ITEM-BACKGROUND-COLOR");
        listBoxPropertiesWords.add("ITEM-COLOR");
        listBoxPropertiesWords.add("ITEM-FOREGROUND-COLOR");
        listBoxPropertiesWords.add("ITEM-TO-ADD");
        listBoxPropertiesWords.add("ITEM-TO-DELETE");
        listBoxPropertiesWords.add("ITEM-VALUE");
        listBoxPropertiesWords.add("LM-ON-COLUMNS");
        listBoxPropertiesWords.add("MASS-UPDATE");
        listBoxPropertiesWords.add("MOUSE-WHEEL-SCROLL");
        listBoxPropertiesWords.add("QUERY-INDEX");
        listBoxPropertiesWords.add("RESET-LIST");
        listBoxPropertiesWords.add("ROW-BACKGROUND-COLOR-PATTERN");
        listBoxPropertiesWords.add("ROW-COLOR-PATTERN");
        listBoxPropertiesWords.add("ROW-FOREGROUND-COLOR-PATTERN");
        listBoxPropertiesWords.add("ROWS-SELECTED");
        listBoxPropertiesWords.add("SEARCH-PANEL");
        listBoxPropertiesWords.add("SEARCH-TEXT");
        listBoxPropertiesWords.add("SELECTION-BACKGROUND-COLOR");
        listBoxPropertiesWords.add("SELECTION-COLOR");
        listBoxPropertiesWords.add("SELECTION-FOREGROUND-COLOR");
        listBoxPropertiesWords.add("SELECTION-INDEX");
        listBoxPropertiesWords.add("SELECTION-MODE");
        listBoxPropertiesWords.add("SEPARATION");
        listBoxPropertiesWords.add("SORT-ORDER");
        listBoxPropertiesWords.add("TERMINATION-VALUE");
        listBoxPropertiesWords.add("THUMB-POSITION");
        ribbonStyleWords.add("MULTILINE");
        ribbonPropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        ribbonPropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        ribbonPropertiesWords.add("COLLAPSE");
        ribbonPropertiesWords.add("GRADIENT-COLOR-1");
        ribbonPropertiesWords.add("GRADIENT-COLOR-2");
        ribbonPropertiesWords.add("GRADIENT-ORIENTATION");
        ribbonPropertiesWords.add("HEADER-ALIGN");
        ribbonPropertiesWords.add("LAYOUT-MANAGER");
        iwcPanelPropertiesWords.add("JS-NAME");
        tabStyleWords.add("ACCORDION");
        tabStyleWords.add("ALLOW-CONTAINER");
        tabStyleWords.add("BOTTOM");
        tabStyleWords.add("BUTTONS");
        tabStyleWords.add("FIXED-WIDTH");
        tabStyleWords.add("FLAT-BUTTONS");
        tabStyleWords.add("HOT-TRACK");
        tabStyleWords.add("MULTILINE");
        tabStyleWords.add("NO-BOX");
        tabStyleWords.add("NO-DIVIDERS");
        tabStyleWords.add("NO-FOCUS");
        tabStyleWords.add("RELATIVE-OFFSET");
        tabStyleWords.add("TAB-FLAT");
        tabStyleWords.add("TEXT-NOROTATE");
        tabStyleWords.add("VERTICAL");
        tabPropertiesWords.add("ACTIVE-TAB-BACKGROUND-COLOR");
        tabPropertiesWords.add("ACTIVE-TAB-BORDER-COLOR");
        tabPropertiesWords.add("ACTIVE-TAB-BORDER-WIDTH");
        tabPropertiesWords.add("ACTIVE-TAB-COLOR");
        tabPropertiesWords.add("ACTIVE-TAB-FOREGROUND-COLOR");
        tabPropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        tabPropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        tabPropertiesWords.add("BITMAP-HANDLE");
        tabPropertiesWords.add("BITMAP-NUMBER");
        tabPropertiesWords.add("BITMAP-WIDTH");
        tabPropertiesWords.add("GRADIENT-COLOR-1");
        tabPropertiesWords.add("GRADIENT-COLOR-2");
        tabPropertiesWords.add("GRADIENT-ORIENTATION");
        tabPropertiesWords.add("INSERTION-INDEX");
        tabPropertiesWords.add("RESET-TABS");
        tabPropertiesWords.add("TAB-ALIGNMENT");
        tabPropertiesWords.add("TAB-BACKGROUND-COLOR");
        tabPropertiesWords.add("TAB-BORDER-COLOR");
        tabPropertiesWords.add("TAB-BORDER-WIDTH");
        tabPropertiesWords.add("TAB-COLOR");
        tabPropertiesWords.add("TAB-DELAY");
        tabPropertiesWords.add("TAB-ENABLED");
        tabPropertiesWords.add("TAB-FOREGROUND-COLOR");
        tabPropertiesWords.add("TAB-INDEX");
        tabPropertiesWords.add("TAB-ROLLOVER-COLOR");
        tabPropertiesWords.add("TAB-TEXT");
        tabPropertiesWords.add("TAB-TO-ADD");
        tabPropertiesWords.add("TAB-TO-DELETE");
        tabPropertiesWords.add("TAB-WIDTHS");
        gridStyleWords.add("3-D");
        gridStyleWords.add("ADJUSTABLE-COLUMNS");
        gridStyleWords.add("ADJUSTABLE-ROWS");
        gridStyleWords.add("BOXED");
        gridStyleWords.add("CENTERED-HEADINGS");
        gridStyleWords.add("COLUMN-HEADINGS");
        gridStyleWords.add("FILTERABLE-COLUMNS");
        gridStyleWords.add("HSCROLL");
        gridStyleWords.add("NO-AUTOSEL");
        gridStyleWords.add("NO-BOX");
        gridStyleWords.add("NO-CELL-DRAG");
        gridStyleWords.add("NO-SEARCH");
        gridStyleWords.add("PAGED");
        gridStyleWords.add("REORDERING-COLUMNS");
        gridStyleWords.add("ROW-HEADINGS");
        gridStyleWords.add("SORTABLE-COLUMNS");
        gridStyleWords.add("TILED-HEADINGS");
        gridStyleWords.add("USE-TAB");
        gridStyleWords.add("VSCROLL");
        gridPropertiesWords.add("ACTION");
        gridPropertiesWords.add("ALIGNMENT");
        gridPropertiesWords.add("BITMAP");
        gridPropertiesWords.add("BITMAP-NUMBER");
        gridPropertiesWords.add("BITMAP-TRAILING");
        gridPropertiesWords.add("BITMAP-WIDTH");
        gridPropertiesWords.add("BORDER-COLOR");
        gridPropertiesWords.add("BORDER-WIDTH");
        gridPropertiesWords.add("CELL-BACKGROUND-COLOR");
        gridPropertiesWords.add("CELL-COLOR");
        gridPropertiesWords.add("CELL-COLUMNS-SPAN");
        gridPropertiesWords.add("CELL-CURRENT-BACKGROUND-COLOR");
        gridPropertiesWords.add("CELL-CURRENT-COLOR");
        gridPropertiesWords.add("CELL-CURRENT-FONT");
        gridPropertiesWords.add("CELL-CURRENT-FOREGROUND-COLOR");
        gridPropertiesWords.add("CELL-CURRENT-PROTECTION");
        gridPropertiesWords.add("CELL-DATA");
        gridPropertiesWords.add("CELL-ENTRY-BACKGROUND-COLOR");
        gridPropertiesWords.add("CELL-ENTRY-COLOR");
        gridPropertiesWords.add("CELL-ENTRY-FOREGROUND-COLOR");
        gridPropertiesWords.add("CELL-FONT");
        gridPropertiesWords.add("CELL-FOREGROUND-COLOR");
        gridPropertiesWords.add("CELL-HINT");
        gridPropertiesWords.add("CELL-PROTECTION");
        gridPropertiesWords.add("CELL-ROWS-SPAN");
        gridPropertiesWords.add("CELL-SECURE");
        gridPropertiesWords.add("CELL-SELECTED-BACKGROUND-COLOR");
        gridPropertiesWords.add("CELL-SELECTED-COLOR");
        gridPropertiesWords.add("CELL-SELECTED-FOREGROUND-COLOR");
        gridPropertiesWords.add("CELLS-SELECTED");
        gridPropertiesWords.add("COLUMN-BACKGROUND-COLOR");
        gridPropertiesWords.add("COLUMN-COLOR");
        gridPropertiesWords.add("COLUMN-DIVIDERS");
        gridPropertiesWords.add("COLUMN-FONT");
        gridPropertiesWords.add("COLUMN-FOREGROUND-COLOR");
        gridPropertiesWords.add("COLUMN-HEADINGS-HEIGHT");
        gridPropertiesWords.add("COLUMN-HEADINGS-LAYOUT");
        gridPropertiesWords.add("COLUMN-HIDING");
        gridPropertiesWords.add("COLUMN-PROTECTION");
        gridPropertiesWords.add("COLUMN-SELECTED-BACKGROUND-COLOR");
        gridPropertiesWords.add("COLUMN-SELECTED-COLOR");
        gridPropertiesWords.add("COLUMN-SELECTED-FOREGROUND-COLOR");
        gridPropertiesWords.add("COLUMNS-SELECTED");
        gridPropertiesWords.add("CURSOR-BACKGROUND-COLOR");
        gridPropertiesWords.add("CURSOR-COLOR");
        gridPropertiesWords.add("CURSOR-FRAME-COLOR");
        gridPropertiesWords.add("CURSOR-FOREGROUND-COLOR");
        gridPropertiesWords.add("CURSOR-FRAME-WIDTH");
        gridPropertiesWords.add("CURSOR-X");
        gridPropertiesWords.add("CURSOR-Y");
        gridPropertiesWords.add("DATA-COLUMNS");
        gridPropertiesWords.add("DATA-TYPES");
        gridPropertiesWords.add("DISPLAY-COLUMNS");
        gridPropertiesWords.add("DIVIDER-COLOR");
        gridPropertiesWords.add("DRAG-BACKGROUND-COLOR");
        gridPropertiesWords.add("DRAG-COLOR");
        gridPropertiesWords.add("DRAG-FOREGROUND-COLOR");
        gridPropertiesWords.add("EDITOR-SHOW-ALWAYS");
        gridPropertiesWords.add("END-COLOR");
        gridPropertiesWords.add("ENTRY-REASON");
        gridPropertiesWords.add("EXPORT-FILE-FORMAT");
        gridPropertiesWords.add("EXPORT-FILE-NAME");
        gridPropertiesWords.add("EXPORT-FILE-OPEN");
        gridPropertiesWords.add("FILE-POS");
        gridPropertiesWords.add("FILTER-TYPES");
        gridPropertiesWords.add("FINISH-REASON");
        gridPropertiesWords.add("HEADING-BACKGROUND-COLOR");
        gridPropertiesWords.add("HEADING-COLOR");
        gridPropertiesWords.add("HEADING-CURSOR-BACKGROUND-COLOR");
        gridPropertiesWords.add("HEADING-CURSOR-COLOR");
        gridPropertiesWords.add("HEADING-CURSOR-FOREGROUND-COLOR");
        gridPropertiesWords.add("HEADING-DIVIDER-COLOR");
        gridPropertiesWords.add("HEADING-FONT");
        gridPropertiesWords.add("HEADING-FOREGROUND-COLOR");
        gridPropertiesWords.add("HEADING-MENU-POPUP");
        gridPropertiesWords.add("HIDDEN-DATA");
        gridPropertiesWords.add("HSCROLL-POS");
        gridPropertiesWords.add("INSERT-ROWS");
        gridPropertiesWords.add("INSERTION-INDEX");
        gridPropertiesWords.add("LAST-ROW");
        gridPropertiesWords.add("LAST-ROW-VIEW");
        gridPropertiesWords.add("LM-ON-COLUMNS");
        gridPropertiesWords.add("LOD-THRESHOLD");
        gridPropertiesWords.add("MASS-UPDATE");
        gridPropertiesWords.add("MODEL-TO-VIEW-Y");
        gridPropertiesWords.add("MOUSE-WHEEL-SCROLL");
        gridPropertiesWords.add("NUM-COL-HEADINGS");
        gridPropertiesWords.add("NUM-ROW-HEADINGS");
        gridPropertiesWords.add("NUM-ROWS");
        gridPropertiesWords.add("PROTECTION");
        gridPropertiesWords.add("RECORD-DATA");
        gridPropertiesWords.add("RECORD-TO-ADD");
        gridPropertiesWords.add("RECORD-TO-DELETE");
        gridPropertiesWords.add("REGION-BACKGROUND-COLOR");
        gridPropertiesWords.add("REGION-COLOR");
        gridPropertiesWords.add("REGION-FOREGROUND-COLOR");
        gridPropertiesWords.add("REORDERING-COL-INDEX");
        gridPropertiesWords.add("RESET-GRID");
        gridPropertiesWords.add("ROW-BACKGROUND-COLOR");
        gridPropertiesWords.add("ROW-BACKGROUND-COLOR-PATTERN");
        gridPropertiesWords.add("ROW-CAPACITY");
        gridPropertiesWords.add("ROW-COLOR");
        gridPropertiesWords.add("ROW-COLOR-PATTERN");
        gridPropertiesWords.add("ROW-CURSOR-BACKGROUND-COLOR");
        gridPropertiesWords.add("ROW-CURSOR-COLOR");
        gridPropertiesWords.add("ROW-CURSOR-FOREGROUND-COLOR");
        gridPropertiesWords.add("ROW-DIVIDERS");
        gridPropertiesWords.add("ROW-FONT");
        gridPropertiesWords.add("ROW-FOREGROUND-COLOR");
        gridPropertiesWords.add("ROW-FOREGROUND-COLOR-PATTERN");
        gridPropertiesWords.add("ROW-HEADING-LINE-HEIGHT");
        gridPropertiesWords.add("ROW-HIDING");
        gridPropertiesWords.add("ROW-PROTECTION");
        gridPropertiesWords.add("ROW-SELECTED-BACKGROUND-COLOR");
        gridPropertiesWords.add("ROW-SELECTED-COLOR");
        gridPropertiesWords.add("ROW-SELECTED-FOREGROUND-COLOR");
        gridPropertiesWords.add("ROWS-FILTERED");
        gridPropertiesWords.add("ROWS-PER-PAGE");
        gridPropertiesWords.add("ROWS-SELECTED");
        gridPropertiesWords.add("SEARCH-OPTIONS");
        gridPropertiesWords.add("SEARCH-PANEL");
        gridPropertiesWords.add("SEARCH-TEXT");
        gridPropertiesWords.add("SEARCH-TEXT-IN-VIEW");
        gridPropertiesWords.add("SELECTION-MODE");
        gridPropertiesWords.add("SEPARATION");
        gridPropertiesWords.add("SORT-DATA");
        gridPropertiesWords.add("SORT-TYPES");
        gridPropertiesWords.add("START-X");
        gridPropertiesWords.add("START-Y");
        gridPropertiesWords.add("VIEW-CURSOR-Y");
        gridPropertiesWords.add("VIEW-TO-MODEL-Y");
        gridPropertiesWords.add("VIRTUAL-WIDTH");
        gridPropertiesWords.add("VPADDING");
        gridPropertiesWords.add("VSCROLL-POS");
        gridPropertiesWords.add("X");
        gridPropertiesWords.add("Y");
        gridPropertiesWords.add("FILTER-PANEL");
        gridPropertiesWords.add("COLUMN-FILTER");
        gridPropertiesWords.add("INPUT-FILTER");
        gridPropertiesWords.add("ROW-ROLLOVER-COLOR");
        gridPropertiesWords.add("ROW-ROLLOVER-BACKGROUND-COLOR");
        gridPropertiesWords.add("ROW-ROLLOVER-FOREGROUND-COLOR");
        gridPropertiesWords.add("HEADING-ROLLOVER-COLOR");
        gridPropertiesWords.add("HEADING-ROLLOVER-BACKGROUND-COLOR");
        gridPropertiesWords.add("HEADING-ROLLOVER-FOREGROUND-COLOR");
        treeStyleWords.add("3-D");
        treeStyleWords.add("ADJUSTABLE-COLUMNS");
        treeStyleWords.add("BOXED");
        treeStyleWords.add("BUTTONS");
        treeStyleWords.add("CENTERED-HEADINGS");
        treeStyleWords.add("COLUMN-HEADINGS");
        treeStyleWords.add("FLAT");
        treeStyleWords.add("LINES-AT-ROOT");
        treeStyleWords.add("NO-BOX");
        treeStyleWords.add("REORDERING-COLUMNS");
        treeStyleWords.add("SHOW-LINES");
        treeStyleWords.add("SHOW-SEL-ALWAYS");
        treeStyleWords.add("SORTABLE-COLUMNS");
        treeStyleWords.add("TABLE-VIEW");
        treeStyleWords.add("TILED-HEADINGS");
        treePropertiesWords.add("ACTION");
        treePropertiesWords.add("ALIGNMENT");
        treePropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        treePropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        treePropertiesWords.add("BITMAP-HANDLE");
        treePropertiesWords.add("BITMAP-NUMBER");
        treePropertiesWords.add("BITMAP-TRAILING");
        treePropertiesWords.add("BITMAP-WIDTH");
        treePropertiesWords.add("BORDER-COLOR");
        treePropertiesWords.add("BORDER-WIDTH");
        treePropertiesWords.add("COLUMN-HIDING");
        treePropertiesWords.add("DATA-COLUMNS");
        treePropertiesWords.add("DISPLAY-COLUMNS");
        treePropertiesWords.add("END-COLOR");
        treePropertiesWords.add("ENSURE-VISIBLE");
        treePropertiesWords.add("EXPAND");
        treePropertiesWords.add("GRADIENT-COLOR-1");
        treePropertiesWords.add("GRADIENT-COLOR-2");
        treePropertiesWords.add("GRADIENT-ORIENTATION");
        treePropertiesWords.add("HAS-CHILDREN");
        treePropertiesWords.add("HEADING-BACKGROUND-COLOR");
        treePropertiesWords.add("HEADING-COLOR");
        treePropertiesWords.add("HEADING-FONT");
        treePropertiesWords.add("HEADING-FOREGROUND-COLOR");
        treePropertiesWords.add("HEADING-MENU-POPUP");
        treePropertiesWords.add("HIDDEN-DATA");
        treePropertiesWords.add("ITEM");
        treePropertiesWords.add("ITEM-BACKGROUND-COLOR");
        treePropertiesWords.add("ITEM-COLOR");
        treePropertiesWords.add("ITEM-COLUMN");
        treePropertiesWords.add("ITEM-FOREGROUND-COLOR");
        treePropertiesWords.add("ITEM-HINT");
        treePropertiesWords.add("ITEM-TEXT");
        treePropertiesWords.add("ITEM-TO-ADD");
        treePropertiesWords.add("ITEM-TO-DELETE");
        treePropertiesWords.add("ITEM-TO-EMPTY");
        treePropertiesWords.add("ITEMS-SELECTED");
        treePropertiesWords.add("LM-ON-COLUMNS");
        treePropertiesWords.add("MASS-UPDATE");
        treePropertiesWords.add("NEXT-ITEM");
        treePropertiesWords.add("PARENT");
        treePropertiesWords.add("PLACEMENT");
        treePropertiesWords.add("RECORD-DATA");
        treePropertiesWords.add("RESET-LIST");
        treePropertiesWords.add("SEARCH-PANEL");
        treePropertiesWords.add("SELECTION-BACKGROUND-COLOR");
        treePropertiesWords.add("SELECTION-COLOR");
        treePropertiesWords.add("SELECTION-FOREGROUND-COLOR");
        treePropertiesWords.add("SELECTION-MODE");
        treePropertiesWords.add("SORT-TYPES");
        treePropertiesWords.add("VIRTUAL-WIDTH");
        treePropertiesWords.add("VPADDING");
        treePropertiesWords.add("X");
        scrollPaneStyleWords.add("NO-BOX");
        scrollPaneStyleWords.add("TRANSPARENT");
        scrollPanePropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        scrollPanePropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        scrollPanePropertiesWords.add("BORDER-COLOR");
        scrollPanePropertiesWords.add("GRADIENT-COLOR-1");
        scrollPanePropertiesWords.add("GRADIENT-COLOR-2");
        scrollPanePropertiesWords.add("GRADIENT-ORIENTATION");
        chipsBoxPropertiesWords.add("BITMAP");
        chipsBoxPropertiesWords.add("BITMAP-NUMBER");
        chipsBoxPropertiesWords.add("BITMAP-WIDTH");
        chipsBoxPropertiesWords.add("BORDER-COLOR");
        chipsBoxPropertiesWords.add("ITEM-BACKGROUND-COLOR");
        chipsBoxPropertiesWords.add("ITEM-BORDER-COLOR");
        chipsBoxPropertiesWords.add("ITEM-COLOR");
        chipsBoxPropertiesWords.add("ITEM-FOREGROUND-COLOR");
        chipsBoxPropertiesWords.add("ITEM-ROLLOVER-BACKGROUND-COLOR");
        chipsBoxPropertiesWords.add("ITEM-ROLLOVER-BORDER-COLOR");
        chipsBoxPropertiesWords.add("ITEM-ROLLOVER-COLOR");
        chipsBoxPropertiesWords.add("ITEM-ROLLOVER-FOREGROUND-COLOR");
        chipsBoxPropertiesWords.add("CHIPS-BORDER-WIDTH");
        chipsBoxPropertiesWords.add("CHIPS-RADIUS");
        chipsBoxPropertiesWords.add("CHIPS-ROLLOVER-BORDER-WIDTH");
        chipsBoxPropertiesWords.add("CHIPS-TYPE");
        chipsBoxPropertiesWords.add("HIDDEN-DATA");
        chipsBoxPropertiesWords.add("ITEM");
        chipsBoxPropertiesWords.add("ITEM-TEXT");
        chipsBoxPropertiesWords.add("ITEM-TO-ADD");
        chipsBoxPropertiesWords.add("ITEM-TO-DELETE");
        chipsBoxPropertiesWords.add("LAST-ITEM");
        chipsBoxPropertiesWords.add("RESET-LIST");
        globalUnsupportedWD2StyleWords.add("FLAT");
        globalUnsupportedWD2StyleWords.add("NOTIFY-MOUSE");
        globalUnsupportedWD2StyleWords.add("OVERLAP-LEFT");
        globalUnsupportedWD2StyleWords.add("OVERLAP-TOP");
        globalUnsupportedWD2PropertiesWords.add("DRAG-MODE");
        globalUnsupportedWD2PropertiesWords.add("MAX-HEIGHT");
        globalUnsupportedWD2PropertiesWords.add("MAX-WIDTH");
        globalUnsupportedWD2PropertiesWords.add("MIN-HEIGHT");
        globalUnsupportedWD2PropertiesWords.add("MIN-WIDTH");
        labelUnsupportedWD2StyleWords.add("VERTICAL");
        entryFieldUnsupportedWD2StyleWords.add("AUTO");
        entryFieldUnsupportedWD2StyleWords.add("SPINNER");
        entryFieldUnsupportedWD2StyleWords.add("EMPTY-CHECK");
        entryFieldUnsupportedWD2StyleWords.add("NO-BOX");
        entryFieldUnsupportedWD2StyleWords.add("NO-WRAP");
        entryFieldUnsupportedWD2StyleWords.add("PROPOSALS-UNSORTED");
        entryFieldUnsupportedWD2StyleWords.add("USE-RETURN");
        entryFieldUnsupportedWD2StyleWords.add("USE-TAB");
        entryFieldUnsupportedWD2StyleWords.add("VSCROLL");
        entryFieldUnsupportedWD2PropertiesWords.add("ACTION");
        entryFieldUnsupportedWD2PropertiesWords.add("AUTO-DECIMAL");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-DISABLED");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-HANDLE");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-HINT");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-NUMBER");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-ROLLOVER");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-TRAILING-DISABLED");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-TRAILING-HINT");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-TRAILING-NUMBER");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-TRAILING-ROLLOVER");
        entryFieldUnsupportedWD2PropertiesWords.add("BITMAP-WIDTH");
        entryFieldUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        entryFieldUnsupportedWD2PropertiesWords.add("CURSOR");
        entryFieldUnsupportedWD2PropertiesWords.add("CURSOR-COL");
        entryFieldUnsupportedWD2PropertiesWords.add("CURSOR-ROW");
        entryFieldUnsupportedWD2PropertiesWords.add("FILL-CHAR");
        entryFieldUnsupportedWD2PropertiesWords.add("FORMAT-STRING");
        entryFieldUnsupportedWD2PropertiesWords.add("FORMAT-TYPE");
        entryFieldUnsupportedWD2PropertiesWords.add("INPUT-FILTER");
        entryFieldUnsupportedWD2PropertiesWords.add("MARGIN-WIDTH");
        entryFieldUnsupportedWD2PropertiesWords.add("MAX-LINES");
        entryFieldUnsupportedWD2PropertiesWords.add("NOTIFY-CHANGE-DELAY");
        entryFieldUnsupportedWD2PropertiesWords.add("SELECTION-START");
        entryFieldUnsupportedWD2PropertiesWords.add("SELECTION-START-COL");
        entryFieldUnsupportedWD2PropertiesWords.add("SELECTION-START-ROW");
        entryFieldUnsupportedWD2PropertiesWords.add("SELECTION-TEXT");
        entryFieldUnsupportedWD2PropertiesWords.add("SPELL-CHECKING");
        entryFieldUnsupportedWD2PropertiesWords.add("TEXT-ORIENTATION");
        entryFieldUnsupportedWD2PropertiesWords.add("TEXT-WRAPPING");
        entryFieldUnsupportedWD2PropertiesWords.add("VISIBLE-PROPOSAL-COUNT");
        pushButtonUnsupportedWD2StyleWords.add("BOTTOM");
        pushButtonUnsupportedWD2StyleWords.add("CENTER");
        pushButtonUnsupportedWD2StyleWords.add("DEFAULT-BUTTON");
        pushButtonUnsupportedWD2StyleWords.add("FRAMED");
        pushButtonUnsupportedWD2StyleWords.add("LEFT");
        pushButtonUnsupportedWD2StyleWords.add("MULTILINE");
        pushButtonUnsupportedWD2StyleWords.add("RIGHT");
        pushButtonUnsupportedWD2StyleWords.add("SQUARE");
        pushButtonUnsupportedWD2StyleWords.add("TOP");
        pushButtonUnsupportedWD2StyleWords.add("TRANSPARENT");
        pushButtonUnsupportedWD2StyleWords.add("UNFRAMED");
        pushButtonUnsupportedWD2PropertiesWords.add("BITMAP-PRESSED");
        pushButtonUnsupportedWD2PropertiesWords.add("BITMAP-SCALE");
        pushButtonUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("BORDER-WIDTH");
        pushButtonUnsupportedWD2PropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("DISABLED-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-BORDER-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        pushButtonUnsupportedWD2PropertiesWords.add("TRANSPARENT-COLOR");
        checkBoxUnsupportedWD2StyleWords.add("FLAT");
        checkBoxUnsupportedWD2StyleWords.add("FRAMED");
        checkBoxUnsupportedWD2StyleWords.add("LEFT-TEXT");
        checkBoxUnsupportedWD2StyleWords.add("MULTILINE");
        checkBoxUnsupportedWD2StyleWords.add("SQUARE");
        checkBoxUnsupportedWD2StyleWords.add("TRANSPARENT");
        checkBoxUnsupportedWD2StyleWords.add("UNFRAMED");
        checkBoxUnsupportedWD2StyleWords.add("VTOP");
        checkBoxUnsupportedWD2PropertiesWords.add("BITMAP-PRESSED");
        checkBoxUnsupportedWD2PropertiesWords.add("BITMAP-SCALE");
        checkBoxUnsupportedWD2PropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("DISABLED-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("LEFT-TEXT-ALIGNMENT");
        checkBoxUnsupportedWD2PropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("ROLLOVER-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        checkBoxUnsupportedWD2PropertiesWords.add("TITLE-POSITION");
        radioButtonUnsupportedWD2StyleWords.add("FLAT");
        radioButtonUnsupportedWD2StyleWords.add("FRAMED");
        radioButtonUnsupportedWD2StyleWords.add("LEFT-TEXT");
        radioButtonUnsupportedWD2StyleWords.add("MULTILINE");
        radioButtonUnsupportedWD2StyleWords.add("NO-GROUP-TAB");
        radioButtonUnsupportedWD2StyleWords.add("SQUARE");
        radioButtonUnsupportedWD2StyleWords.add("TRANSPARENT");
        radioButtonUnsupportedWD2StyleWords.add("UNFRAMED");
        radioButtonUnsupportedWD2StyleWords.add("VTOP");
        radioButtonUnsupportedWD2PropertiesWords.add("BITMAP-PRESSED");
        radioButtonUnsupportedWD2PropertiesWords.add("BITMAP-SCALE");
        radioButtonUnsupportedWD2PropertiesWords.add("DISABLED-BACKGROUND-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("DISABLED-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("DISABLED-FOREGROUND-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("LEFT-TEXT-ALIGNMENT");
        radioButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-BACKGROUND-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("ROLLOVER-FOREGROUND-COLOR");
        radioButtonUnsupportedWD2PropertiesWords.add("TITLE-POSITION");
        comboBoxUnsupportedWD2StyleWords.add("3-D");
        comboBoxUnsupportedWD2StyleWords.add("NO-AUTOSEL");
        comboBoxUnsupportedWD2StyleWords.add("NO-BOX");
        comboBoxUnsupportedWD2StyleWords.add("NOTIFY-DBLCLICK");
        comboBoxUnsupportedWD2StyleWords.add("STATIC-LIST");
        comboBoxUnsupportedWD2PropertiesWords.add("INPUT-FILTER");
        comboBoxUnsupportedWD2PropertiesWords.add("MASS-UPDATE");
        comboBoxUnsupportedWD2PropertiesWords.add("MAX-TEXT");
        frameUnsupportedWD2StyleWords.add("ALTERNATE");
        frameUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        frameUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        frameUnsupportedWD2PropertiesWords.add("FILL-COLOR2");
        frameUnsupportedWD2PropertiesWords.add("FILL-PERCENT");
        frameUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-1");
        frameUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-2");
        frameUnsupportedWD2PropertiesWords.add("GRADIENT-ORIENTATION");
        frameUnsupportedWD2PropertiesWords.add("HIGH-COLOR");
        frameUnsupportedWD2PropertiesWords.add("LOW-COLOR");
        frameUnsupportedWD2PropertiesWords.add("TRANSPARENT");
        bitmapUnsupportedWD2PropertiesWords.add("BITMAP-END");
        bitmapUnsupportedWD2PropertiesWords.add("BITMAP-START");
        bitmapUnsupportedWD2PropertiesWords.add("BITMAP-TIMER");
        listBoxUnsupportedWD2StyleWords.add("3-D");
        listBoxUnsupportedWD2StyleWords.add("CHECK-LIST");
        listBoxUnsupportedWD2StyleWords.add("NO-BOX");
        listBoxUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        listBoxUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        listBoxUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        listBoxUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-1");
        listBoxUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-2");
        listBoxUnsupportedWD2PropertiesWords.add("GRADIENT-ORIENTATION");
        listBoxUnsupportedWD2PropertiesWords.add("LM-ON-COLUMNS");
        listBoxUnsupportedWD2PropertiesWords.add("MOUSE-WHEEL-SCROLL");
        listBoxUnsupportedWD2PropertiesWords.add("SEARCH-PANEL");
        listBoxUnsupportedWD2PropertiesWords.add("SEARCH-TEXT");
        listBoxUnsupportedWD2PropertiesWords.add("SELECTION-MODE");
        listBoxUnsupportedWD2PropertiesWords.add("SORT-ORDER");
        listBoxUnsupportedWD2PropertiesWords.add("THUMB-POSITION");
        tabUnsupportedWD2StyleWords.add("BOTTOM");
        tabUnsupportedWD2StyleWords.add("BUTTONS");
        tabUnsupportedWD2StyleWords.add("FIXED-WIDTH");
        tabUnsupportedWD2StyleWords.add("FLAT-BUTTONS");
        tabUnsupportedWD2StyleWords.add("HOT-TRACK");
        tabUnsupportedWD2StyleWords.add("MULTILINE");
        tabUnsupportedWD2StyleWords.add("NO-BOX");
        tabUnsupportedWD2StyleWords.add("NO-DIVIDERS");
        tabUnsupportedWD2StyleWords.add("NO-FOCUS");
        tabUnsupportedWD2StyleWords.add("TAB-FLAT");
        tabUnsupportedWD2StyleWords.add("TEXT-NOROTATE");
        tabUnsupportedWD2PropertiesWords.add("ACTIVE-TAB-BACKGROUND-COLOR");
        tabUnsupportedWD2PropertiesWords.add("ACTIVE-TAB-BORDER-COLOR");
        tabUnsupportedWD2PropertiesWords.add("ACTIVE-TAB-BORDER-WIDTH");
        tabUnsupportedWD2PropertiesWords.add("ACTIVE-TAB-COLOR");
        tabUnsupportedWD2PropertiesWords.add("ACTIVE-TAB-FOREGROUND-COLOR");
        tabUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        tabUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        tabUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-1");
        tabUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-2");
        tabUnsupportedWD2PropertiesWords.add("GRADIENT-ORIENTATION");
        tabUnsupportedWD2PropertiesWords.add("TAB-BACKGROUND-COLOR");
        tabUnsupportedWD2PropertiesWords.add("TAB-BORDER-COLOR");
        tabUnsupportedWD2PropertiesWords.add("TAB-BORDER-WIDTH");
        tabUnsupportedWD2PropertiesWords.add("TAB-COLOR");
        tabUnsupportedWD2PropertiesWords.add("TAB-DELAY");
        tabUnsupportedWD2PropertiesWords.add("TAB-FOREGROUND-COLOR");
        tabUnsupportedWD2PropertiesWords.add("TAB-ROLLOVER-COLOR");
        tabUnsupportedWD2PropertiesWords.add("TAB-WIDTHS");
        treeUnsupportedWD2StyleWords.add("3-D");
        treeUnsupportedWD2StyleWords.add("ADJUSTABLE-COLUMNS");
        treeUnsupportedWD2StyleWords.add("BUTTONS");
        treeUnsupportedWD2StyleWords.add("CENTERED-HEADINGS");
        treeUnsupportedWD2StyleWords.add("COLUMN-HEADINGS");
        treeUnsupportedWD2StyleWords.add("FLAT");
        treeUnsupportedWD2StyleWords.add("LINES-AT-ROOT");
        treeUnsupportedWD2StyleWords.add("NO-BOX");
        treeUnsupportedWD2StyleWords.add("REORDERING-COLUMNS");
        treeUnsupportedWD2StyleWords.add("SHOW-SEL-ALWAYS");
        treeUnsupportedWD2StyleWords.add("SORTABLE-COLUMNS");
        treeUnsupportedWD2StyleWords.add("TABLE-VIEW");
        treeUnsupportedWD2StyleWords.add("TILED-HEADINGS");
        treeUnsupportedWD2PropertiesWords.add("ACTION");
        treeUnsupportedWD2PropertiesWords.add("ALIGNMENT");
        treeUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-HANDLE");
        treeUnsupportedWD2PropertiesWords.add("BACKGROUND-BITMAP-SCALE");
        treeUnsupportedWD2PropertiesWords.add("BITMAP-TRAILING");
        treeUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        treeUnsupportedWD2PropertiesWords.add("COLUMN-HIDING");
        treeUnsupportedWD2PropertiesWords.add("DATA-COLUMNS");
        treeUnsupportedWD2PropertiesWords.add("DISPLAY-COLUMNS");
        treeUnsupportedWD2PropertiesWords.add("END-COLOR");
        treeUnsupportedWD2PropertiesWords.add("ENSURE-VISIBLE");
        treeUnsupportedWD2PropertiesWords.add("EXPAND");
        treeUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-1");
        treeUnsupportedWD2PropertiesWords.add("GRADIENT-COLOR-2");
        treeUnsupportedWD2PropertiesWords.add("GRADIENT-ORIENTATION");
        treeUnsupportedWD2PropertiesWords.add("HEADING-BACKGROUND-COLOR");
        treeUnsupportedWD2PropertiesWords.add("HEADING-COLOR");
        treeUnsupportedWD2PropertiesWords.add("HEADING-FONT");
        treeUnsupportedWD2PropertiesWords.add("HEADING-FOREGROUND-COLOR");
        treeUnsupportedWD2PropertiesWords.add("HEADING-MENU-POPUP");
        treeUnsupportedWD2PropertiesWords.add("ITEMS-SELECTED");
        treeUnsupportedWD2PropertiesWords.add("LM-ON-COLUMNS");
        treeUnsupportedWD2PropertiesWords.add("MASS-UPDATE");
        treeUnsupportedWD2PropertiesWords.add("NEXT-ITEM");
        treeUnsupportedWD2PropertiesWords.add("RECORD-DATA");
        treeUnsupportedWD2PropertiesWords.add("SEARCH-PANEL");
        treeUnsupportedWD2PropertiesWords.add("SELECTION-MODE");
        treeUnsupportedWD2PropertiesWords.add("SORT-TYPES");
        treeUnsupportedWD2PropertiesWords.add("VPADDING");
        treeUnsupportedWD2PropertiesWords.add("X");
        gridUnsupportedWD2StyleWords.add("3-D");
        gridUnsupportedWD2StyleWords.add("ADJUSTABLE-ROWS");
        gridUnsupportedWD2StyleWords.add("FILTERABLE-COLUMNS");
        gridUnsupportedWD2StyleWords.add("NO-BOX");
        gridUnsupportedWD2StyleWords.add("NO-CELL-DRAG");
        gridUnsupportedWD2StyleWords.add("REORDERING-COLUMNS");
        gridUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        gridUnsupportedWD2PropertiesWords.add("COLUMN-FILTER");
        gridUnsupportedWD2PropertiesWords.add("COLUMN-HEADINGS-LAYOUT");
        gridUnsupportedWD2PropertiesWords.add("DRAG-BACKGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("DRAG-COLOR");
        gridUnsupportedWD2PropertiesWords.add("DRAG-FOREGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("END-COLOR");
        gridUnsupportedWD2PropertiesWords.add("FILTER-PANEL");
        gridUnsupportedWD2PropertiesWords.add("FILTER-TYPES");
        gridUnsupportedWD2PropertiesWords.add("FINISH-REASON");
        gridUnsupportedWD2PropertiesWords.add("HEADING-DIVIDER-COLOR");
        gridUnsupportedWD2PropertiesWords.add("HSCROLL-POS");
        gridUnsupportedWD2PropertiesWords.add("LAST-ROW-VIEW");
        gridUnsupportedWD2PropertiesWords.add("LM-ON-COLUMNS");
        gridUnsupportedWD2PropertiesWords.add("MOUSE-WHEEL-SCROLL");
        gridUnsupportedWD2PropertiesWords.add("REORDERING-COL-INDEX");
        gridUnsupportedWD2PropertiesWords.add("ROW-DIVIDERS");
        gridUnsupportedWD2PropertiesWords.add("ROW-HEIGHT");
        gridUnsupportedWD2PropertiesWords.add("ROW-HIDING");
        gridUnsupportedWD2PropertiesWords.add("SEARCH-PANEL");
        gridUnsupportedWD2PropertiesWords.add("SORT-TYPES");
        gridUnsupportedWD2PropertiesWords.add("VSCROLL-POS");
        gridUnsupportedWD2PropertiesWords.add("INPUT-FILTER");
        gridUnsupportedWD2PropertiesWords.add("ROW-ROLLOVER-COLOR");
        gridUnsupportedWD2PropertiesWords.add("ROW-ROLLOVER-BACKGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("ROW-ROLLOVER-FOREGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("HEADING-ROLLOVER-COLOR");
        gridUnsupportedWD2PropertiesWords.add("HEADING-ROLLOVER-BACKGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("HEADING-ROLLOVER-FOREGROUND-COLOR");
        gridUnsupportedWD2PropertiesWords.add("CURSOR-FRAME-COLOR");
        javaBeanUnsupportedWD2StyleWords.add("3-D");
        javaBeanUnsupportedWD2StyleWords.add("BOXED");
        javaBeanUnsupportedWD2StyleWords.add("HAS-BITMAPS");
        javaBeanUnsupportedWD2StyleWords.add("HSCROLL");
        javaBeanUnsupportedWD2StyleWords.add("NO-BOX");
        javaBeanUnsupportedWD2StyleWords.add("USE-ALT");
        javaBeanUnsupportedWD2StyleWords.add("USE-RETURN");
        javaBeanUnsupportedWD2StyleWords.add("VSCROLL");
        javaBeanUnsupportedWD2PropertiesWords.add("BITMAP-HANDLE");
        javaBeanUnsupportedWD2PropertiesWords.add("BITMAP-WIDTH");
        javaBeanUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        dateEntryUnsupportedWD2StyleWords.add("DECORATION-BACKGROUND-VISIBLE");
        dateEntryUnsupportedWD2StyleWords.add("DECORATION-BORDERS-VISIBLE");
        dateEntryUnsupportedWD2StyleWords.add("NO-F4");
        dateEntryUnsupportedWD2StyleWords.add("NO-UPDOWN");
        dateEntryUnsupportedWD2StyleWords.add("RIGHT-ALIGN");
        dateEntryUnsupportedWD2StyleWords.add("SHORT-DATE");
        dateEntryUnsupportedWD2StyleWords.add("SHOW-NONE");
        dateEntryUnsupportedWD2StyleWords.add("SPINNER");
        dateEntryUnsupportedWD2StyleWords.add("NUMERIC");
        dateEntryUnsupportedWD2StyleWords.add("READ-ONLY");
        dateEntryUnsupportedWD2StyleWords.add("WEEK-OF-YEAR-VISIBLE");
        dateEntryUnsupportedWD2PropertiesWords.add("BITMAP-HANDLE");
        dateEntryUnsupportedWD2PropertiesWords.add("BITMAP-NUMBER");
        dateEntryUnsupportedWD2PropertiesWords.add("BITMAP-WIDTH");
        dateEntryUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        dateEntryUnsupportedWD2PropertiesWords.add("BORDER-WIDTH");
        dateEntryUnsupportedWD2PropertiesWords.add("CALENDAR-FONT");
        dateEntryUnsupportedWD2PropertiesWords.add("DECORATION-BACKGROUND");
        dateEntryUnsupportedWD2PropertiesWords.add("ILLEGAL-DATE-VALUE");
        dateEntryUnsupportedWD2PropertiesWords.add("MAXDAY-CHARACTERS");
        dateEntryUnsupportedWD2PropertiesWords.add("SUNDAY-FOREGROUND");
        dateEntryUnsupportedWD2PropertiesWords.add("WEEKDAY-FOREGROUND");
        chipsBoxUnsupportedWD2PropertiesWords.add("BITMAP");
        chipsBoxUnsupportedWD2PropertiesWords.add("BITMAP-NUMBER");
        chipsBoxUnsupportedWD2PropertiesWords.add("BITMAP-WIDTH");
        chipsBoxUnsupportedWD2PropertiesWords.add("BORDER-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-BACKGROUND-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-BORDER-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-FOREGROUND-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-ROLLOVER-BACKGROUND-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-ROLLOVER-BORDER-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-ROLLOVER-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-ROLLOVER-FOREGROUND-COLOR");
        chipsBoxUnsupportedWD2PropertiesWords.add("CHIPS-BORDER-WIDTH");
        chipsBoxUnsupportedWD2PropertiesWords.add("CHIPS-RADIUS");
        chipsBoxUnsupportedWD2PropertiesWords.add("CHIPS-ROLLOVER-BORDER-WIDTH");
        chipsBoxUnsupportedWD2PropertiesWords.add("CHIPS-TYPE");
        chipsBoxUnsupportedWD2PropertiesWords.add("HIDDEN-DATA");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-TEXT");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-TO-ADD");
        chipsBoxUnsupportedWD2PropertiesWords.add("ITEM-TO-DELETE");
        chipsBoxUnsupportedWD2PropertiesWords.add("LAST-ITEM");
        chipsBoxUnsupportedWD2PropertiesWords.add("RESET-LIST");
        barUnsupportedWD2StyleWords.add("DASHED");
        barUnsupportedWD2StyleWords.add("DOT-DASH");
        barUnsupportedWD2StyleWords.add("DOTTED");
        barStyleWords.add("DASHED");
        barStyleWords.add("DOT-DASH");
        barStyleWords.add("DOTTED");
        barPropertiesWords.add("COLORS");
        barPropertiesWords.add("LEADING-SHIFT");
        barPropertiesWords.add("POSITION-SHIFT");
        barPropertiesWords.add("SHADING");
        barPropertiesWords.add("TRAILING-SHIFT");
        barPropertiesWords.add("WIDTH");
        webBrowserStyleWords.add("NO-MSG-BEFORE-NAVIGATE");
        webBrowserStyleWords.add("USE-ALT");
        webBrowserStyleWords.add("USE-RETURN");
        webBrowserStyleWords.add("USE-TAB");
        webBrowserPropertiesWords.add("BUSY");
        webBrowserPropertiesWords.add("COPY-SELECTION");
        webBrowserPropertiesWords.add("FILE-NAME");
        webBrowserPropertiesWords.add("GO-BACK");
        webBrowserPropertiesWords.add("GO-FORWARD");
        webBrowserPropertiesWords.add("GO-HOME");
        webBrowserPropertiesWords.add("GO-SEARCH");
        webBrowserPropertiesWords.add("MAX-PROGRESS");
        webBrowserPropertiesWords.add("NAVIGATE-URL");
        webBrowserPropertiesWords.add("PRINT");
        webBrowserPropertiesWords.add("PRINT-NO-PROMPT");
        webBrowserPropertiesWords.add("PROGRESS");
        webBrowserPropertiesWords.add("REFRESH");
        webBrowserPropertiesWords.add("SAVE-AS");
        webBrowserPropertiesWords.add("SAVE-AS-NO-PROMPT");
        webBrowserPropertiesWords.add("SELECT-ALL");
        webBrowserPropertiesWords.add("STATUS-TEXT");
        webBrowserPropertiesWords.add("STOP-BROWSER");
        webBrowserUnsupportedPropertiesWords.add("CLEAR-SELECTION");
        webBrowserUnsupportedPropertiesWords.add("CUSTOM-PRINT-TEMPLATE");
        webBrowserUnsupportedPropertiesWords.add("PAGE-SETUP");
        webBrowserUnsupportedPropertiesWords.add("PRINT-PREVIEW");
        webBrowserUnsupportedPropertiesWords.add("PROPERTIES");
        webBrowserUnsupportedPropertiesWords.add("TYPE");
        statusBarStyleWords.add("GRIP");
        statusBarPropertiesWords.add("PANEL-ALIGNMENT");
        statusBarPropertiesWords.add("PANEL-BACKGROUND-COLOR");
        statusBarPropertiesWords.add("PANEL-BITMAP");
        statusBarPropertiesWords.add("PANEL-BITMAP-ALIGNMENT");
        statusBarPropertiesWords.add("PANEL-BITMAP-NUMBER");
        statusBarPropertiesWords.add("PANEL-BITMAP-WIDTH");
        statusBarPropertiesWords.add("PANEL-COLOR");
        statusBarPropertiesWords.add("PANEL-FOREGROUND-COLOR");
        statusBarPropertiesWords.add("PANEL-HINT");
        statusBarPropertiesWords.add("PANEL-INDEX");
        statusBarPropertiesWords.add("PANEL-STYLE");
        statusBarPropertiesWords.add("PANEL-TEXT");
        statusBarPropertiesWords.add("PANEL-WIDTHS");
        scrollBarStyleWords.add("HORIZONTAL");
        scrollBarStyleWords.add("TRACK-THUMB");
        scrollBarPropertiesWords.add("MAX-VAL");
        scrollBarPropertiesWords.add("MIN-VAL");
        scrollBarPropertiesWords.add("PAGE-SIZE");
        sliderStyleWords.add("HORIZONTAL");
        sliderStyleWords.add("INVERTED");
        sliderStyleWords.add("SHOW-LABELS");
        sliderStyleWords.add("SHOW-TICKS");
        sliderStyleWords.add("TRANSPARENT");
        sliderPropertiesWords.add("LABELS-INCREMENT");
        sliderPropertiesWords.add("MAJOR-TICK-SPACING");
        sliderPropertiesWords.add("MAX-VAL");
        sliderPropertiesWords.add("MIN-VAL");
        sliderPropertiesWords.add("MINOR-TICK-SPACING");
        sliderPropertiesWords.add("PAGE-SIZE");
        javaBeanStyleWords.add("3-D");
        javaBeanStyleWords.add("BOXED");
        javaBeanStyleWords.add("HAS-BITMAPS");
        javaBeanStyleWords.add("HSCROLL");
        javaBeanStyleWords.add("NO-BOX");
        javaBeanStyleWords.add("SELF-ACT");
        javaBeanStyleWords.add("USE-ALT");
        javaBeanStyleWords.add("USE-RETURN");
        javaBeanStyleWords.add("USE-TAB");
        javaBeanStyleWords.add("VSCROLL");
        javaBeanPropertiesWords.add("BITMAP-HANDLE");
        javaBeanPropertiesWords.add("BITMAP-WIDTH");
        javaBeanPropertiesWords.add("BORDER-COLOR");
        javaBeanPropertiesWords.add("BORDER-WIDTH");
        javaBeanPropertiesWords.add("CLSID");
        javaBeanPropertiesWords.add("EVENT-LIST");
        javaBeanPropertiesWords.add("EXCLUDE-EVENT-LIST");
        javaBeanPropertiesWords.add("INIT-PARAMS");
        javaBeanPropertiesWords.add("INIT-SIGNATURE");
        dateEntryStyleWords.add("ALLOW-EMPTY");
        dateEntryStyleWords.add("CENTURY-DATE");
        dateEntryStyleWords.add("DECORATION-BACKGROUND-VISIBLE");
        dateEntryStyleWords.add("DECORATION-BORDERS-VISIBLE");
        dateEntryStyleWords.add("LONG-DATE");
        dateEntryStyleWords.add("NO-F4");
        dateEntryStyleWords.add("NO-UPDOWN");
        dateEntryStyleWords.add("NOTIFY-CHANGE");
        dateEntryStyleWords.add("NUMERIC");
        dateEntryStyleWords.add("READ-ONLY");
        dateEntryStyleWords.add("RIGHT-ALIGN");
        dateEntryStyleWords.add("SELF-ACT");
        dateEntryStyleWords.add("SHORT-DATE");
        dateEntryStyleWords.add("SHOW-NONE");
        dateEntryStyleWords.add("SPINNER");
        dateEntryStyleWords.add("TIME");
        dateEntryStyleWords.add("WEEK-OF-YEAR-VISIBLE");
        dateEntryPropertiesWords.add("BITMAP-HANDLE");
        dateEntryPropertiesWords.add("BITMAP-NUMBER");
        dateEntryPropertiesWords.add("BITMAP-WIDTH");
        dateEntryPropertiesWords.add("BORDER-COLOR");
        dateEntryPropertiesWords.add("BORDER-WIDTH");
        dateEntryPropertiesWords.add("CALENDAR-FONT");
        dateEntryPropertiesWords.add("DECORATION-BACKGROUND");
        dateEntryPropertiesWords.add("DISPLAY-FORMAT");
        dateEntryPropertiesWords.add("ILLEGAL-DATE-VALUE");
        dateEntryPropertiesWords.add("MAX-VAL");
        dateEntryPropertiesWords.add("MAXDAY-CHARACTERS");
        dateEntryPropertiesWords.add("MIN-VAL");
        dateEntryPropertiesWords.add("SUNDAY-FOREGROUND");
        dateEntryPropertiesWords.add("VALUE-FORMAT");
        dateEntryPropertiesWords.add("WEEKDAY-FOREGROUND");
        rgbSpecialProperties.put("ACTIVE-TAB-BACKGROUND-COLOR", new int[]{10});
        rgbSpecialProperties.put("ACTIVE-TAB-BORDER-COLOR", new int[]{10});
        rgbSpecialProperties.put("ACTIVE-TAB-FOREGROUND-COLOR", new int[]{10});
        rgbSpecialProperties.put("BORDER-COLOR", new int[]{2, 12, 14, 19, 7, 22, 3, 20, 24});
        rgbSpecialProperties.put("CELL-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CELL-ENTRY-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CELL-ENTRY-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CELL-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CELL-SELECTED-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CELL-SELECTED-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("COLORS", new int[]{11});
        rgbSpecialProperties.put("COLUMN-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("COLUMN-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("COLUMN-SELECTED-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("COLUMN-SELECTED-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CURSOR-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("CURSOR-FRAME-COLOR", new int[]{12});
        rgbSpecialProperties.put("CURSOR-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("DECORATION-BACKGROUND", new int[]{20});
        rgbSpecialProperties.put("DISABLED-BACKGROUND-COLOR", new int[]{3, 4, 5});
        rgbSpecialProperties.put("DISABLED-FOREGROUND-COLOR", new int[]{3, 4, 5});
        rgbSpecialProperties.put("DIVIDER-COLOR", new int[]{12});
        rgbSpecialProperties.put("DRAG-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("DRAG-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("END-COLOR", new int[]{12, 14});
        rgbSpecialProperties.put("FILL-COLOR", new int[]{9});
        rgbSpecialProperties.put("FILL-COLOR2", new int[]{9});
        rgbSpecialProperties.put("GRADIENT-COLOR-1", new int[]{9, 22, 10, 21, 14, 7});
        rgbSpecialProperties.put("GRADIENT-COLOR-2", new int[]{9, 22, 10, 21, 14, 7});
        rgbSpecialProperties.put("HEADING-BACKGROUND-COLOR", new int[]{12, 14});
        rgbSpecialProperties.put("HEADING-CURSOR-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("HEADING-CURSOR-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("HEADING-DIVIDER-COLOR", new int[]{12});
        rgbSpecialProperties.put("HEADING-FOREGROUND-COLOR", new int[]{12, 14});
        rgbSpecialProperties.put("HEADING-ROLLOVER-COLOR", new int[]{12});
        rgbSpecialProperties.put("HEADING-ROLLOVER-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("HEADING-ROLLOVER-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("HIGH-COLOR", new int[]{9});
        rgbSpecialProperties.put("ITEM-BACKGROUND-COLOR", new int[]{14, 7, 8, 24});
        rgbSpecialProperties.put("ITEM-FOREGROUND-COLOR", new int[]{14, 7, 8, 24});
        rgbSpecialProperties.put("LOW-COLOR", new int[]{9});
        rgbSpecialProperties.put("PANEL-BACKGROUND-COLOR", new int[]{17});
        rgbSpecialProperties.put("PANEL-FOREGROUND-COLOR", new int[]{17});
        rgbSpecialProperties.put("REGION-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("REGION-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROLLOVER-BACKGROUND-COLOR", new int[]{3, 4, 5});
        rgbSpecialProperties.put("ROLLOVER-BORDER-COLOR", new int[]{3});
        rgbSpecialProperties.put("ROLLOVER-FOREGROUND-COLOR", new int[]{3, 4, 5});
        rgbSpecialProperties.put("ROW-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-BACKGROUND-COLOR-PATTERN", new int[]{12, 7});
        rgbSpecialProperties.put("ROW-CURSOR-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-CURSOR-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-FOREGROUND-COLOR-PATTERN", new int[]{12, 7});
        rgbSpecialProperties.put("ROW-ROLLOVER-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-ROLLOVER-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-ROLLOVER-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-SELECTED-BACKGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("ROW-SELECTED-FOREGROUND-COLOR", new int[]{12});
        rgbSpecialProperties.put("SELECTION-BACKGROUND-COLOR", new int[]{14, 7, 8});
        rgbSpecialProperties.put("SELECTION-FOREGROUND-COLOR", new int[]{14, 7, 8});
        rgbSpecialProperties.put("SUNDAY-FOREGROUND", new int[]{20});
        rgbSpecialProperties.put("TAB-BACKGROUND-COLOR", new int[]{10});
        rgbSpecialProperties.put("TAB-BORDER-COLOR", new int[]{10});
        rgbSpecialProperties.put("TAB-FOREGROUND-COLOR", new int[]{10});
        rgbSpecialProperties.put("TAB-ROLLOVER-COLOR", new int[]{10});
        rgbSpecialProperties.put("WEEKDAY-FOREGROUND", new int[]{20});
        rgbSpecialProperties.put("ITEM-BORDER-COLOR", new int[]{24});
        rgbSpecialProperties.put("ITEM-ROLLOVER-BACKGROUND-COLOR", new int[]{24});
        rgbSpecialProperties.put("ITEM-ROLLOVER-BORDER-COLOR", new int[]{24});
        rgbSpecialProperties.put("ITEM-ROLLOVER-COLOR", new int[]{24});
        rgbSpecialProperties.put("ITEM-ROLLOVER-FOREGROUND-COLOR", new int[]{24});
    }

    public class PropElementList
    implements IPropElementList {
        private Vector<PropElement> propList = new Vector();

        public void put(PropElement propElement) {
            this.propList.addElement(propElement);
        }

        @Override
        public Object getKey(int n2) {
            try {
                return this.propList.elementAt(n2).getKey();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public PropElementValue[] getValue(int n2) {
            try {
                return this.propList.elementAt(n2).getValue();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getTabMul(int n2) {
            try {
                return this.propList.elementAt(n2).getTabmul();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getVarGiving(int n2) {
            try {
                return this.propList.elementAt(n2).getVarGiving();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getVarLength(int n2) {
            try {
                return this.propList.elementAt(n2).getVarLength();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public int size() {
            return this.propList.size();
        }
    }

    public class PropElement {
        private Object key;
        private PropElementValue[] value;
        private Object tabmul;
        private Object varLength;
        private Object varGiving;

        public PropElement(Object object, PropElementValue[] propElementValueArray, Object object2) {
            this.key = object;
            this.value = propElementValueArray;
            this.tabmul = object2;
        }

        public PropElement(Object object, PropElementValue propElementValue, Object object2) {
            this(object, new PropElementValue[]{propElementValue}, object2);
        }

        public Object getKey() {
            return this.key;
        }

        public PropElementValue[] getValue() {
            return this.value;
        }

        public Object getTabmul() {
            return this.tabmul;
        }

        public void setVarGiving(Object object) {
            this.varGiving = object;
        }

        public Object getVarGiving() {
            return this.varGiving;
        }

        public void setVarLength(Object object) {
            this.varLength = object;
        }

        public Object getVarLength() {
            return this.varLength;
        }
    }

    public class PropElementValue
    implements IPropElementValue {
        private VariableName vnProp;
        private Token tkProp;
        private Expression exprProp;
        private boolean isRgb;

        public PropElementValue(Token token, boolean bl) {
            this.tkProp = token;
            this.isRgb = bl;
        }

        public PropElementValue(VariableName variableName, boolean bl) {
            this.vnProp = variableName;
            this.isRgb = bl;
        }

        public PropElementValue(Expression expression, boolean bl) {
            this.exprProp = expression;
            this.isRgb = bl;
        }

        @Override
        public VariableName getVariableName() {
            return this.vnProp;
        }

        @Override
        public Token getToken() {
            return this.tkProp;
        }

        @Override
        public Expression getExpression() {
            return this.exprProp;
        }

        @Override
        public boolean isRgb() {
            return this.isRgb;
        }
    }
}

