/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;

public class Generate
extends Verb {
    private ReportDescriptor rd;
    private ReportGroup rg;

    public Generate(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        Token token3 = token2;
        token2 = this.tm.getToken();
        if (token2.getToknum() == 609 || token2.getToknum() == 526) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.rd = this.pc.getReport(token2);
            if (this.rd == null) {
                throw new GeneralErrorException(181, 4, token2, token2.getWord(), this.error);
            }
            this.rg = this.rd.getDetail(token3);
            if (this.rg == null) {
                throw new GeneralErrorException(181, 4, token3, token3.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
            this.rd = this.pc.getReport(token3);
            if (this.rd == null) {
                this.rg = this.pc.getDetail(token3);
                if (this.rg == null) {
                    throw new GeneralErrorException(181, 4, token3, token3.getWord(), this.error);
                }
                this.rd = this.rg.rd;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.pc.getDeclarative(this.rd.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (this.rg == null) {
            stringBuffer.append(this.rd.getName());
            stringBuffer.append(".generate();");
        } else {
            stringBuffer.append(this.rg.rd.getName());
            stringBuffer.append(".generate(");
            stringBuffer.append(this.rg.getUnivoqueName());
            stringBuffer.append(");");
        }
        Use.putDeclaratives(stringBuffer, this.pc, this.rd.fd.sel, this.parent.getIndent(), bl);
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public ReportDescriptor getReportDescriptor() {
        return this.rd;
    }

    public ReportGroup getReportGroup() {
        return this.rg;
    }
}

