/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class GenericValue
implements CobolToken,
ErrorsNumbers {
    private VariableName variable;
    private Token literal;
    TokenManager tm;

    private GenericValue(TokenManager tokenManager) {
        this.tm = tokenManager;
    }

    public static GenericValue get(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        GenericValue genericValue;
        Token token = tokenManager.getToken();
        switch (token.getToknum()) {
            case 10001: 
            case 10002: 
            case 10017: {
                genericValue = new GenericValue(tokenManager);
                new GenericValue(tokenManager).literal = token;
                break;
            }
            case 10009: {
                tokenManager.ungetToken();
                VariableName variableName = VariableName.get(tokenManager, errors, pcc);
                if (variableName != null) {
                    genericValue = new GenericValue(tokenManager);
                    new GenericValue(tokenManager).variable = variableName;
                    break;
                }
                genericValue = null;
                break;
            }
            default: {
                tokenManager.ungetToken();
                genericValue = null;
            }
        }
        return genericValue;
    }

    public String getLiteralContent() {
        String string;
        string = this.literal != null ? ((string = this.literal.getWord()).length() > 2 ? string.substring(1, string.length() - 1) : "") : null;
        return string;
    }

    public boolean isNumeric() {
        if (this.literal != null) {
            return this.literal.getToknum() != 10001;
        }
        return this.variable.isNumeric();
    }

    public VariableName getVariable() {
        return this.variable;
    }

    public String getCode() {
        if (this.literal != null) {
            return this.tm.getCodeLiteral(this.literal);
        }
        if (this.variable != null) {
            return this.variable.getCode();
        }
        return null;
    }

    public String toString() {
        if (this.literal != null) {
            return this.literal.getWord();
        }
        if (this.variable != null) {
            return this.variable.getName();
        }
        return null;
    }
}

