/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.LabelNameList;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Goto
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final String ALTER_PREF = "alter$";
    LabelNameList labels = new LabelNameList();
    int[] toNums;
    VariableName depending;
    private boolean isInDeclaratives;
    private boolean _isVariableTarget;

    public Goto(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        LabelName labelName;
        this.isInDeclaratives = this.pc.inDeclaratives;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 773) {
            this.tm.ungetToken();
        }
        while ((labelName = LabelName.get(this.parent, this.tm, this.error, this.pc)) != null) {
            this.labels.addItem(labelName);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 400) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 613) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.depending = VariableName.get(this.tm, this.error, this.pc);
            }
        } else {
            this.tm.ungetToken();
        }
        if (this.labels.getItemNum() != 1 && this.labels.getItemNum() > 1) {
            if (this.depending == null) {
                throw new GeneralErrorException(18, 4, this.keyWord, "DEPENDING", this.error);
            }
            if (!this.depending.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, this.keyWord, this.depending.getName(), this.error);
            }
        }
        if (this.parent.parent.inThread()) {
            throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check() throws GeneralErrorException {
        if (this.labels.getItemNum() == 0) {
            return;
        }
        if (this.isVariableTarget() || this.labels.getItemNum() == 0) {
            this.parent.parent.setHasGoto(null);
        }
        this.toNums = new int[this.labels.getItemNum()];
        int n2 = 0;
        LabelName labelName = this.labels.getFirst();
        while (labelName != null) {
            if (this.isInDeclaratives) {
                GeneralErrorInfo generalErrorInfo = labelName.check(this.isInDeclaratives);
                if (generalErrorInfo != null) {
                    if (generalErrorInfo.type != 105) throw new GeneralErrorException(generalErrorInfo);
                    generalErrorInfo = labelName.check(false);
                    if (generalErrorInfo != null) {
                        throw new GeneralErrorException(generalErrorInfo);
                    }
                }
            } else {
                labelName.check();
            }
            this.toNums[n2] = labelName.getParIdNumber();
            this.parent.parent.setHasGoto(labelName.getParagraph());
            ++n2;
            labelName = this.labels.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.tm.getOptionList().getOption("-d") != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.toNums != null || this.isVariableTarget()) {
            if (this.depending != null) {
                stringBuffer.append("switch (");
                stringBuffer.append(this.depending.getCode());
                stringBuffer.append(".num().intValue()) {");
                stringBuffer.append(eol);
                for (int i2 = 1; i2 <= this.toNums.length; ++i2) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("case ");
                    stringBuffer.append(i2);
                    stringBuffer.append(": ");
                    if (bl) {
                        Paragraph.getDebugExitCode(stringBuffer);
                        stringBuffer.append(" ");
                    }
                    if (this.isInDeclaratives && !this.labels.getAt(i2 - 1).isInDeclaratives()) {
                        stringBuffer.append("throw new GotoException (");
                        stringBuffer.append(this.toNums[i2 - 1]);
                        stringBuffer.append(");");
                    } else {
                        stringBuffer.append("return ");
                        stringBuffer.append(this.toNums[i2 - 1]);
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(eol);
                }
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("}");
                stringBuffer.append(eol);
            } else {
                if (this.isVariableTarget() && this.toNums == null) {
                    stringBuffer.append("if(");
                    stringBuffer.append(this.getAlterVarName());
                    stringBuffer.append(" > 0) { ");
                } else {
                    stringBuffer.append("if(true) { ");
                }
                if (bl) {
                    Paragraph.getDebugExitCode(stringBuffer);
                    stringBuffer.append(" ");
                }
                if (this.isInDeclaratives && !this.labels.getAt(0).isInDeclaratives()) {
                    stringBuffer.append("throw new GotoException (");
                    if (this.isVariableTarget()) {
                        stringBuffer.append(this.getAlterVarName());
                    } else {
                        stringBuffer.append(this.toNums[0]);
                    }
                    stringBuffer.append(");");
                } else {
                    stringBuffer.append("return ");
                    if (this.isVariableTarget()) {
                        stringBuffer.append(this.getAlterVarName());
                    } else {
                        stringBuffer.append(this.toNums[0]);
                    }
                    stringBuffer.append(";");
                }
                stringBuffer.append(" }");
                stringBuffer.append(eol);
            }
        } else {
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public int[] getToNums() {
        return this.toNums;
    }

    public VariableName getDepending() {
        return this.depending;
    }

    public LabelNameList getLabels() {
        return this.labels;
    }

    public void setVariableTarget() {
        if (!this._isVariableTarget) {
            this._isVariableTarget = true;
            this.pc.addVariableTargetGoto(this);
            this.parent.parent.setHasGoto(true);
        }
    }

    public boolean isVariableTarget() {
        return this._isVariableTarget;
    }

    public String getAlterVarName() {
        if (this.isVariableTarget()) {
            return ALTER_PREF + this.parent.parent.getJavaName();
        }
        return null;
    }
}

