/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DocGen;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.interfaces.compiler.IIdentificationDivision;

public class IdentificationDivision
implements CobolToken,
ErrorsNumbers,
IIdentificationDivision {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private Token programId;
    private Token classId;
    private boolean isInterface;
    private Token pgmType;
    private String as;
    private Token inheritsTk;
    private VariableName inheritsVn;
    private TokenList implTkList;
    private VariableNameList implVnList;
    private String doc;
    private boolean common;

    public IdentificationDivision(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        Token token;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        this.common = false;
        boolean bl = true;
        int n2 = this.tm.getFormat();
        int n3 = n2 == 1 ? 4 : (n2 = n2 == 2 ? 4 : 0);
        block6: while (bl && (token = this.tm.getToken()).getToknum() != 522 && token.getToknum() != 458 && token.getToknum() != 388 && token.getToknum() != 651) {
            switch (token.getToknum()) {
                case 500: 
                case 654: {
                    this.programId(token);
                    continue block6;
                }
                case 327: {
                    if (this.programId != null || this.classId != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
                    token = this.tm.getToken();
                    if (token.getToknum() != 10006) {
                        this.error.print(13, 2, token.getFLN(), token.getOffset(), null, null, this.tm.getFileName());
                        this.tm.skipToDot();
                        continue block6;
                    }
                    this.classId();
                    token = this.tm.getToken();
                    if (token.getToknum() == 10006) continue block6;
                    this.error.print(31, 4, token.getFLN(), token.getOffset(), "./" + token.getWord(), null, this.tm.getFileName());
                    this.tm.skipToDot();
                    continue block6;
                }
                case 541: {
                    if (this.programId != null || this.classId != null) {
                        throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
                    }
                    this.isInterface = true;
                    this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
                    token = this.tm.getToken();
                    if (token.getToknum() != 10006) {
                        this.error.print(13, 2, token.getFLN(), token.getOffset(), null, null, this.tm.getFileName());
                        this.tm.skipToDot();
                        continue block6;
                    }
                    this.interfaceId();
                    token = this.tm.getToken();
                    if (token.getToknum() == 10006) continue block6;
                    this.error.print(31, 4, token.getFLN(), token.getOffset(), "./" + token.getWord(), null, this.tm.getFileName());
                    this.tm.skipToDot();
                    continue block6;
                }
                case 285: 
                case 390: 
                case 391: 
                case 538: 
                case 680: 
                case 711: {
                    if (n2 > 0) {
                        while ((token = this.tm.getToken()).getOffset() >= n2) {
                        }
                        this.tm.ungetToken();
                        continue block6;
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() != 10006) {
                        this.error.print(13, 2, token.getFLN(), token.getOffset(), null, null, this.tm.getFileName());
                    }
                    this.tm.skipToDot();
                    continue block6;
                }
            }
            if ("PROGRAM-ID".equals(token.getWord())) {
                this.programId(token);
                continue;
            }
            bl = false;
        }
        this.tm.ungetToken();
    }

    private void preclassId() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.classId = token;
                token = this.tm.getToken();
                if (token.getToknum() == 280) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 10001) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                    this.as = token.getCode().replace('-', '_');
                    break;
                }
                this.tm.ungetToken();
                this.as = this.classId.getWord().replace('-', '_');
                break;
            }
            case 10001: {
                String string = token.getWord();
                string = string.substring(1, string.length() - 1);
                token.setToknum(10009);
                token.setWord(string.toUpperCase());
                this.classId = token;
                token = this.tm.getToken();
                if (token.getToknum() == 280) {
                    token = this.tm.getToken();
                    if (token.getToknum() != 10001) {
                        throw new SyntaxErrorException(token, token.getWord(), this.error);
                    }
                    this.as = token.getCode().replace('-', '_');
                    break;
                }
                this.tm.ungetToken();
                this.as = string;
                break;
            }
            default: {
                throw new SyntaxErrorException(token, token.getWord(), this.error);
            }
        }
    }

    private void classId() throws GeneralErrorException, EndOfProgramException {
        this.preclassId();
        Token token = this.tm.getToken();
        if (token.getToknum() == 530) {
            token = this.tm.getToken();
            if (token.getToknum() == 498) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
            }
            this.inheritsTk = token;
            this.tm.ungetToken();
            this.inheritsVn = VariableName.getObject(this.tm, this.error, null, null);
        } else {
            this.tm.ungetToken();
        }
        token = this.tm.getToken();
        if (token.getToknum() == 525) {
            this.implTkList = new TokenList();
            this.implVnList = new VariableNameList();
            while ((token = this.tm.getToken()).getToknum() == 10009) {
                this.implTkList.addItem(token);
                this.tm.ungetToken();
                this.implVnList.addItem(VariableName.getObject(this.tm, this.error, null, null));
            }
            if (this.implTkList.getItemNum() == 0) {
                throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
        }
        if (Pcc.isValidClassName(this.as) == null) {
            throw new GeneralErrorException(82, 4, this.classId, this.as, this.error);
        }
        this.pc.loadVariable(VariableDeclaration.getObject(this.pc, this.classId, this.tm, this.as, true));
    }

    private void interfaceId() throws GeneralErrorException, EndOfProgramException {
        this.preclassId();
        Token token = this.tm.getToken();
        if (token.getToknum() == 530) {
            token = this.tm.getToken();
            if (token.getToknum() == 498) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
            }
            this.implTkList = new TokenList();
            this.implVnList = new VariableNameList();
            while (token.getToknum() == 10009) {
                this.implTkList.addItem(token);
                this.tm.ungetToken();
                this.implVnList.addItem(VariableName.getObject(this.tm, this.error, null, null));
                token = this.tm.getToken();
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
        }
        if (Pcc.isValidClassName(this.as) == null) {
            throw new GeneralErrorException(82, 4, this.classId, this.as, this.error);
        }
        this.pc.loadVariable(VariableDeclaration.getObject(this.pc, this.classId, this.tm, this.as, true));
    }

    @Override
    public String getProgramName() {
        String string = this.programId.getWord();
        if (this.programId.getToknum() == 10001) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public Token getProgramId() {
        return this.programId;
    }

    @Override
    public Token getClassId() {
        return this.classId;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public int getProgramType() {
        if (this.pgmType != null) {
            return this.pgmType.getToknum();
        }
        return 0;
    }

    public void doCheck() throws GeneralErrorException {
        if (this.inheritsVn != null) {
            this.inheritsVn.checkObject(this.pc);
            if (!this.inheritsVn.getVarDecl().isFactory) {
                throw new MissingClassException(this.inheritsTk.getWord(), this.inheritsTk, this.error);
            }
        }
        if (this.implVnList != null) {
            VariableName variableName = this.implVnList.getFirst();
            Token token = this.implTkList.getFirst();
            while (variableName != null) {
                variableName.checkObject(this.pc);
                if (!variableName.getVarDecl().isFactory) {
                    throw new MissingClassException(token.getWord(), token, this.error);
                }
                variableName = this.implVnList.getNext();
                token = this.implTkList.getNext();
            }
        }
    }

    @Override
    public String getInheritsClass() {
        if (this.inheritsVn != null && this.inheritsVn.getVarDecl() != null) {
            return this.inheritsVn.getVarDecl().getTypeName();
        }
        return "java.lang.Object";
    }

    @Override
    public String[] getImplementsClass() {
        String[] stringArray = null;
        if (this.implVnList != null) {
            stringArray = new String[this.implVnList.getItemNum()];
            int n2 = 0;
            VariableName variableName = this.implVnList.getFirst();
            while (variableName != null) {
                stringArray[n2] = variableName.getVarDecl() != null ? variableName.getVarDecl().getTypeName() : "java.lang.Object";
                ++n2;
                variableName = this.implVnList.getNext();
            }
        }
        return stringArray;
    }

    public String getImplements() {
        String string = null;
        if (this.implVnList != null && this.implVnList.getItemNum() > 0) {
            string = "";
            VariableName variableName = this.implVnList.getFirst();
            while (true) {
                string = string + variableName.getVarDecl().getTypeName();
                variableName = this.implVnList.getNext();
                if (variableName == null) break;
                string = string + ", ";
            }
        }
        return string;
    }

    @Override
    public String getClassName() {
        return this.as;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    private void programId(Token token) throws GeneralErrorException, EndOfProgramException {
        if (this.programId != null || this.classId != null) {
            throw new GeneralErrorException(225, 4, token, token.getWord(), this.error);
        }
        this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
        token = this.tm.getToken();
        if (token.getToknum() != 10006) {
            this.error.print(13, 2, token.getFLN(), token.getOffset(), null, null, this.tm.getFileName());
        } else {
            this.programId = this.tm.getToken();
            this.programId.setWord(this.programId.getWord().replace('-', '_'));
            token = this.tm.getToken();
            if (token.getToknum() == 545) {
                token = this.tm.getToken();
            }
            if (token.getToknum() == 531) {
                this.pgmType = token;
                token = this.tm.getToken();
                if (token.getToknum() == 342) {
                    throw new GeneralErrorException(19, 4, token, "", this.error);
                }
                if (token.getToknum() == 653) {
                    token = this.tm.getToken();
                }
            }
            switch (token.getToknum()) {
                case 342: {
                    throw new GeneralErrorException(19, 4, token, "", this.error);
                }
                case 690: {
                    String string = "-zi";
                    if (this.tm.getOptionList().getOption(string) != null) {
                        this.error.print(159, 2, token.getFLN(), token.getOffset(), string, null, this.tm.getFileName());
                        string = '#' + string.substring(1, string.length());
                        this.tm.getOptionList().addOption(string);
                    }
                    this.pgmType = token;
                    token = this.tm.getToken();
                    if (token.getToknum() != 653) break;
                    token = this.tm.getToken();
                    break;
                }
                case 10009: {
                    if (!token.getWord().equals("RECURSIVE")) break;
                }
                case 673: {
                    if (this.pgmType != null && this.pgmType.getToknum() == 531) {
                        throw new UnexpectedTokenException(token, this.error);
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() != 653) break;
                    token = this.tm.getToken();
                }
            }
            if (token.getToknum() != 10006) {
                this.error.print(188, 3, token.getFLN(), token.getOffset(), null, null, this.tm.getFileName());
                this.tm.skipToDot();
            }
        }
    }

    public void checkInterface(MyMethod[] myMethodArray) throws GeneralErrorException {
        if (this.implVnList != null && !this.isInterface()) {
            VariableName variableName = this.implVnList.getFirst();
            Token token = this.implTkList.getFirst();
            while (variableName != null) {
                try {
                    String string;
                    VariableDeclaration variableDeclaration = variableName.getVarDecl();
                    if (variableDeclaration != null && !"com.iscobol.rts.IscobolClass".equals(string = variableDeclaration.getClassName())) {
                        MyClass myClass = this.pc.existsClass(string);
                        if (!myClass.isInterface()) {
                            throw new GeneralErrorException(214, 4, token, string, this.error);
                        }
                        MyMethod[] myMethodArray2 = myClass.getMethods(false);
                        for (int i2 = 0; i2 < myMethodArray2.length; ++i2) {
                            int n2;
                            if (myMethodArray2[i2].isDefault() || myMethodArray2[i2].isStatic() || myMethodArray2[i2].isIscobolClassMethod()) continue;
                            for (n2 = 0; n2 < myMethodArray.length; ++n2) {
                                if (!myMethodArray[n2].same(myMethodArray2[i2])) continue;
                                int n3 = myMethodArray[n2].getModifiers();
                                if ((n3 & 1) != 0) break;
                                throw new GeneralErrorException(215, 4, token, myMethodArray2[i2].getName(), this.error);
                            }
                            if (n2 != myMethodArray.length) continue;
                            throw new GeneralErrorException(216, 4, token, myMethodArray2[i2].getName(), this.error);
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MissingClassException(classNotFoundException, token, this.error);
                }
                variableName = this.implVnList.getNext();
                token = this.implTkList.getNext();
            }
        }
    }
}

