/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class If
extends Verb
implements CobolToken,
ErrorsNumbers {
    Condition cond;
    boolean hasElse;
    Block ifBlock;
    Block elseBlock;
    NextSentence ns;

    public If(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = null;
        this.cond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.cond.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
        Token token3 = this.tm.getToken();
        if (token3.getToknum() == 762) {
            token3 = this.tm.getToken();
        }
        if (token3.getToknum() == 595) {
            token2 = token3;
            token3 = this.tm.getToken();
            if (token3.getToknum() != 714) {
                throw new ExpectedFoundException(token3, this.error, "SENTENCE");
            }
            token3 = this.tm.getToken();
            if (token3.getToknum() != 10006 && token3.getToknum() != 417 && token3.getToknum() != 622 && token3.getToknum() != 433) {
                throw new ExpectedFoundException(token3, this.error, "ELSE|.");
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
            this.ifBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        }
        token3 = this.tm.getToken();
        if (token3.getToknum() == 417 || token3.getToknum() == 622) {
            this.hasElse = true;
            token3 = this.tm.getToken();
            if (token3.getToknum() == 595) {
                token2 = token3;
                token3 = this.tm.getToken();
                if (token3.getToknum() != 714) {
                    throw new ExpectedFoundException(token3, this.error, "SENTENCE");
                }
                token3 = this.tm.getToken();
                if (token3.getToknum() != 10006 && token3.getToknum() != 417 && token3.getToknum() != 622 && token3.getToknum() != 433) {
                    throw new ExpectedFoundException(token3, this.error, "ELSE|.");
                }
            } else {
                this.tm.ungetToken();
                this.elseBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                token3 = this.tm.getToken();
            }
        }
        if (token3.getToknum() != 433) {
            if (token3.getToknum() != 10006 && token3.getToknum() != 417) {
                this.error.print(154, 3, token3, "END-IF");
            }
            this.tm.ungetToken();
        } else if (token2 != null) {
            this.ns = new NextSentence(token2, block, this.pc, this.tm, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.cond.check();
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("if (");
        stringBuffer.append(this.cond.getCode());
        stringBuffer.append(")");
        if (this.ifBlock != null) {
            stringBuffer.append(this.ifBlock.getCode());
        } else if (this.ns != null) {
            stringBuffer.append("{");
            stringBuffer.append(this.ns.getCode());
            stringBuffer.append("}");
        } else {
            stringBuffer.append("{ // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
        }
        if (this.hasElse) {
            if (this.elseBlock != null) {
                stringBuffer.append(" else ");
                stringBuffer.append(this.elseBlock.getCode());
            } else if (this.ns != null) {
                stringBuffer.append(" else {" + this.ns.getCode());
                stringBuffer.append("}");
            } else {
                stringBuffer.append(" else { // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
            }
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public Block getIfBlock() {
        return this.ifBlock;
    }

    public Block getElseBlock() {
        return this.elseBlock;
    }

    public Condition getCondition() {
        return this.cond;
    }

    public NextSentence getNextSentence() {
        return this.ns;
    }

    public boolean hasElse() {
        return this.hasElse;
    }
}

