/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.OffsetHelper;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IDataSection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Initialize
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final Integer T_ALPHABETIC = 1;
    public static final Integer T_ALPHANUMERIC = 2;
    public static final Integer T_ALPHANUMERIC_EDITED = 3;
    public static final Integer T_NUMERIC = 4;
    public static final Integer T_NUMERIC_EDITED = 5;
    public static final Integer T_BOOLEAN = 6;
    private VariableNameList destList = new VariableNameList();
    private boolean withFiller;
    private Token anyLengthSizeTk;
    private VariableName anyLengthSizeVn;
    private boolean toDefault;
    private Set<Integer> valueCats = new LinkedHashSet<Integer>();
    private boolean allToValue;
    private Map<Integer, Object> repCats = new LinkedHashMap<Integer, Object>();

    public Initialize(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        boolean bl = this.pc.getOption("-dx") != null;
        int n2 = 0;
        while (true) {
            VariableName variableName;
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1, true));
                variableName.getVarDecl().setUsedAll(true, !bl);
                if (variableName.getVarDecl().containsRenames()) {
                    throw new GeneralErrorException(59, 4, token2, token2.getWord(), this.error);
                }
            } else {
                if (n2 != 0) break;
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.destList.addItem(variableName);
            token2 = this.tm.getToken();
            ++n2;
        }
        block0 : switch (token2.getToknum()) {
            case 813: {
                token2 = this.tm.getToken();
                switch (token2.getToknum()) {
                    case 486: {
                        this.withFiller = true;
                        token2 = this.tm.getToken();
                        break block0;
                    }
                    case 728: {
                        this.withSize();
                        return;
                    }
                }
                throw new ExpectedFoundException(token2, this.error, "'FILLER'");
            }
            case 486: {
                this.withFiller = true;
                token2 = this.tm.getToken();
                break;
            }
            case 728: {
                this.withSize();
                return;
            }
        }
        if (this.withFiller) {
            VariableName variableName = this.destList.getFirst();
            while (variableName != null) {
                variableName.getVarDecl().setInitializedWithFiller();
                variableName = this.destList.getNext();
            }
        }
        if (token2.getToknum() == 262) {
            this.allToValue = true;
        } else {
            block30: while (true) {
                switch (token2.getToknum()) {
                    case 266: {
                        this.valueCats.add(T_ALPHABETIC);
                        break;
                    }
                    case 269: {
                        this.valueCats.add(T_ALPHANUMERIC);
                        break;
                    }
                    case 270: {
                        this.valueCats.add(T_ALPHANUMERIC_EDITED);
                        break;
                    }
                    case 603: {
                        this.valueCats.add(T_NUMERIC);
                        break;
                    }
                    case 604: {
                        this.valueCats.add(T_NUMERIC_EDITED);
                        break;
                    }
                    case 10009: {
                        if ("BOOLEAN".equals(token2.getWord())) {
                            this.valueCats.add(T_BOOLEAN);
                            break;
                        }
                    }
                    default: {
                        break block30;
                    }
                }
                token2 = this.tm.getToken();
            }
        }
        if (!this.valueCats.isEmpty() || this.allToValue) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 773 ? (token2 = this.tm.getToken()).getToknum() != 803 : token2.getToknum() != 803) {
                throw new ExpectedFoundException(token2, this.error, "'VALUE'");
            }
            token2 = this.tm.getToken();
        }
        switch (token2.getToknum()) {
            case 762: {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 683) {
                    token2 = this.initializeRepr(this.tm.getToken());
                    break;
                }
                if (token2.getToknum() == 773) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 396) {
                        throw new ExpectedFoundException(token2, this.error, "'DEFAULT'");
                    }
                    this.toDefault = true;
                } else if (token2.getToknum() == 396) {
                    this.toDefault = true;
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
                break;
            }
            case 773: {
                token2 = this.tm.getToken();
                if (token2.getToknum() != 396) {
                    throw new ExpectedFoundException(token2, this.error, "'DEFAULT'");
                }
                this.toDefault = true;
                token2 = this.tm.getToken();
                break;
            }
            case 396: {
                this.toDefault = true;
                token2 = this.tm.getToken();
                break;
            }
            case 683: {
                token2 = this.initializeRepr(this.tm.getToken());
            }
        }
        if (!this.toDefault) {
            switch (token2.getToknum()) {
                case 762: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 773) {
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 396) {
                            throw new ExpectedFoundException(token2, this.error, "'DEFAULT'");
                        }
                        this.toDefault = true;
                        break;
                    }
                    if (token2.getToknum() == 396) {
                        this.toDefault = true;
                        break;
                    }
                    throw new UnexpectedTokenException(token2, this.error);
                }
                case 773: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 396) {
                        throw new ExpectedFoundException(token2, this.error, "'DEFAULT'");
                    }
                    this.toDefault = true;
                    break;
                }
                case 396: {
                    this.toDefault = true;
                    break;
                }
                default: {
                    this.tm.ungetToken();
                    break;
                }
            }
        } else {
            this.tm.ungetToken();
        }
    }

    private void withSize() throws GeneralErrorException, EndOfProgramException {
        CobolToken cobolToken = this.destList.getFirst();
        while (cobolToken != null) {
            if (!((VariableName)cobolToken).getVarDecl().isAnyLength()) {
                throw new GeneralErrorException(256, 4, ((VariableName)cobolToken).getNameToken(), ((VariableName)cobolToken).getName(), this.error);
            }
            cobolToken = this.destList.getNext();
        }
        cobolToken = this.tm.getToken();
        switch (((Token)cobolToken).getToknum()) {
            case 10002: {
                this.anyLengthSizeTk = cobolToken;
                break;
            }
            case 10001: {
                if (((Token)cobolToken).isNull()) {
                    ((Token)cobolToken).setZero();
                    this.anyLengthSizeTk = cobolToken;
                    break;
                }
            }
            case 10017: {
                throw new GeneralErrorException(22, 4, (Token)cobolToken, ((Token)cobolToken).getWord(), this.error);
            }
            case 10009: {
                this.tm.ungetToken();
                this.anyLengthSizeVn = VariableName.get(this.tm, this.error, this.pc);
                if (this.anyLengthSizeVn.isInteger()) break;
                throw new GeneralErrorException(46, 4, this.anyLengthSizeVn.getNameToken(), this.anyLengthSizeVn.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException((Token)cobolToken, this.error);
            }
        }
    }

    private Token initializeRepr(Token token) throws GeneralErrorException, EndOfProgramException {
        int n2 = 0;
        block12: while (true) {
            Token token2;
            Integer n3;
            switch (token.getToknum()) {
                case 266: {
                    n3 = T_ALPHABETIC;
                    if (!this.repCats.containsKey(n3)) break;
                    throw new GeneralErrorException(63, 4, token, token.getWord(), this.error);
                }
                case 269: {
                    n3 = T_ALPHANUMERIC;
                    if (!this.repCats.containsKey(n3)) break;
                    throw new GeneralErrorException(63, 4, token, token.getWord(), this.error);
                }
                case 270: {
                    n3 = T_ALPHANUMERIC_EDITED;
                    if (!this.repCats.containsKey(n3)) break;
                    throw new GeneralErrorException(63, 4, token, token.getWord(), this.error);
                }
                case 603: {
                    n3 = T_NUMERIC;
                    if (!this.repCats.containsKey(n3)) break;
                    throw new GeneralErrorException(63, 4, token, token.getWord(), this.error);
                }
                case 604: {
                    n3 = T_NUMERIC_EDITED;
                    if (!this.repCats.containsKey(n3)) break;
                    throw new GeneralErrorException(63, 4, token, token.getWord(), this.error);
                }
                default: {
                    if (n2 != 0) break block12;
                    throw new UnexpectedTokenException(token, this.error);
                }
            }
            if ((token2 = this.tm.getToken()).getToknum() == 388) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 312) {
                throw new ExpectedFoundException(token2, this.error, "'BY'");
            }
            token2 = this.tm.getToken();
            switch (token2.getToknum()) {
                case 10017: {
                    if (this.illegalInitialize(token.getToknum(), token2.getToknum())) {
                        throw new GeneralErrorException(59, 4, token, token.getWord(), this.error);
                    }
                }
                case 10001: 
                case 10002: {
                    this.repCats.put(n3, token2);
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    VariableName variableName = VariableName.get(this.tm, this.error, this.pc);
                    if (this.illegalInitialize(token.getToknum(), variableName.getVarDecl())) {
                        throw new GeneralErrorException(59, 4, token, token.getWord(), this.error);
                    }
                    this.repCats.put(n3, variableName);
                    break;
                }
                default: {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
            }
            token = this.tm.getToken();
            ++n2;
        }
        return token;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private boolean illegalInitialize(int n2, VariableDeclaration variableDeclaration) {
        return variableDeclaration.isNumeric() && !variableDeclaration.isInteger() && !variableDeclaration.isEdited() && !this.isNumeric(n2) || !variableDeclaration.isNumeric() && variableDeclaration.isEdited() && this.isNumeric(n2);
    }

    private boolean illegalInitialize(int n2, int n3) {
        return !this.isNumeric(n2) && n3 == 10017;
    }

    private boolean isNumeric(int n2) {
        return n2 == 603 || n2 == 604;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.anyLengthSizeTk != null || this.anyLengthSizeVn != null) {
            this.getCodeWithSize(stringBuffer);
        } else {
            this.getCode(stringBuffer);
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private void getCodeWithSize(StringBuffer stringBuffer) {
        boolean bl = true;
        VariableName variableName = this.destList.getFirst();
        while (variableName != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append("((com.iscobol.rts.IPicAnyLength) ");
            stringBuffer.append(variableName.getCode());
            stringBuffer.append(").setSize(");
            if (this.anyLengthSizeTk != null) {
                stringBuffer.append(this.anyLengthSizeTk.getCode());
            } else {
                stringBuffer.append(this.anyLengthSizeVn.getCode());
                stringBuffer.append(".toint()");
            }
            stringBuffer.append(");");
            variableName = this.destList.getNext();
        }
    }

    private void getCode(StringBuffer stringBuffer) {
        Enumeration enumeration = this.destList.elements();
        while (enumeration.hasMoreElements()) {
            block47: {
                Object object;
                Serializable serializable;
                VariableDeclaration[] variableDeclarationArray;
                VariableDeclaration variableDeclaration;
                VariableName variableName;
                block48: {
                    block49: {
                        block46: {
                            variableName = (VariableName)enumeration.nextElement();
                            variableDeclaration = variableName.getVarDecl();
                            variableDeclarationArray = this.getValidChildren(variableDeclaration);
                            if (!variableDeclaration.isInDynamic() || variableName.hasSubValue() || variableDeclarationArray.length <= 0) break block46;
                            stringBuffer.append(variableName.getCode());
                            stringBuffer.append(".initialize(null,null,false);");
                            stringBuffer.append(eol);
                            break block47;
                        }
                        if (!variableName.hasSubValue()) break block48;
                        serializable = this.repCats.get(T_ALPHANUMERIC);
                        if (serializable == null) break block49;
                        if (serializable instanceof Token) {
                            stringBuffer.append(this.getCodeLiteral((Token)((Object)serializable)));
                        } else {
                            stringBuffer.append(((VariableName)((Object)serializable)).getCode());
                        }
                        stringBuffer.append(".moveTo(");
                        stringBuffer.append(variableName.getCode());
                        stringBuffer.append(");");
                        stringBuffer.append(eol);
                        break block47;
                    }
                    if (!this.toDefault && (this.allToValue || !this.valueCats.isEmpty() || !this.repCats.isEmpty())) break block47;
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".setSpace();");
                    stringBuffer.append(eol);
                    break block47;
                }
                if (this.pc.optionMS) {
                    Iterator<Integer> iterator;
                    stringBuffer.append(variableName.getCode());
                    serializable = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (this.allToValue) {
                        ((StringBuffer)serializable).append("CobolVar.ALL_TO_VALUE");
                        stringBuffer2.append("null");
                        if (!this.repCats.isEmpty() || this.toDefault) {
                            ((StringBuffer)serializable).append(", ");
                            stringBuffer2.append(", ");
                        }
                    } else if (!this.valueCats.isEmpty()) {
                        iterator = this.valueCats.iterator();
                        while (iterator.hasNext()) {
                            switch (iterator.next()) {
                                case 1: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHABETIC");
                                    break;
                                }
                                case 2: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHANUMERIC");
                                    break;
                                }
                                case 3: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHANUMERIC_EDITED");
                                    break;
                                }
                                case 4: {
                                    ((StringBuffer)serializable).append("CobolVar.NUMERIC");
                                    break;
                                }
                                case 5: {
                                    ((StringBuffer)serializable).append("CobolVar.NUMERIC_EDITED");
                                    break;
                                }
                                case 6: {
                                    ((StringBuffer)serializable).append("CobolVar.BOOLEAN");
                                }
                            }
                            stringBuffer2.append("null");
                            if (!iterator.hasNext()) continue;
                            ((StringBuffer)serializable).append(", ");
                            stringBuffer2.append(", ");
                        }
                        if (!this.repCats.isEmpty() || this.toDefault) {
                            ((StringBuffer)serializable).append(", ");
                            stringBuffer2.append(", ");
                        }
                    }
                    if (!this.repCats.isEmpty()) {
                        iterator = this.repCats.keySet().iterator();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            switch ((Integer)object) {
                                case 1: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHABETIC");
                                    break;
                                }
                                case 2: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHANUMERIC");
                                    break;
                                }
                                case 3: {
                                    ((StringBuffer)serializable).append("CobolVar.ALPHANUMERIC_EDITED");
                                    break;
                                }
                                case 4: {
                                    ((StringBuffer)serializable).append("CobolVar.NUMERIC");
                                    break;
                                }
                                case 5: {
                                    ((StringBuffer)serializable).append("CobolVar.NUMERIC_EDITED");
                                    break;
                                }
                                case 6: {
                                    ((StringBuffer)serializable).append("CobolVar.BOOLEAN");
                                }
                            }
                            Object object2 = this.repCats.get(object);
                            if (object2 instanceof Token) {
                                stringBuffer2.append(this.getCodeLiteral((Token)object2));
                            } else {
                                stringBuffer2.append(((VariableName)object2).getCode());
                            }
                            if (!iterator.hasNext()) continue;
                            ((StringBuffer)serializable).append(", ");
                            stringBuffer2.append(", ");
                        }
                        if (this.toDefault) {
                            ((StringBuffer)serializable).append(", ");
                            stringBuffer2.append(", ");
                        }
                    }
                    if (this.toDefault) {
                        ((StringBuffer)serializable).append("CobolVar.TO_DEFAULT");
                        stringBuffer2.append("null");
                    }
                    stringBuffer.append(".initialize(");
                    if (((StringBuffer)serializable).length() > 0) {
                        stringBuffer.append(eol).append(this.parent.getIndent()).append("   ");
                        stringBuffer.append("new int[] { ");
                        stringBuffer.append((StringBuffer)serializable);
                        stringBuffer.append(" },");
                        stringBuffer.append(eol).append(this.parent.getIndent()).append("   ");
                        stringBuffer.append("new CobolVar[] { ");
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append(" },");
                        stringBuffer.append(eol).append(this.parent.getIndent()).append("   ");
                        stringBuffer.append(this.withFiller);
                    } else if (this.withFiller) {
                        stringBuffer.append("null, null, true");
                    }
                    stringBuffer.append(");");
                    stringBuffer.append(eol);
                } else {
                    serializable = new ArrayList();
                    if (variableName.hasIndexes()) {
                        String string = "initIdx$" + Initialize.getUniqueId();
                        stringBuffer.append("int[] ");
                        stringBuffer.append(string);
                        stringBuffer.append(" = new int[] { ");
                        int n2 = 0;
                        object = variableName.getIndexes().elements();
                        while (object.hasMoreElements()) {
                            if (variableDeclaration.hasVariableOffset()) {
                                stringBuffer.append("(");
                            }
                            stringBuffer.append(((Subscript)object.nextElement()).getCode());
                            if (variableDeclaration.hasVariableOffset()) {
                                stringBuffer.append("-1)");
                            }
                            ((ArrayList)serializable).add(string + "[" + n2 + "]");
                            if (object.hasMoreElements()) {
                                stringBuffer.append(", ");
                            }
                            ++n2;
                        }
                        stringBuffer.append("};");
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                        if (!variableDeclaration.hasVariableOffset()) {
                            this.getUnivoqueName(variableDeclaration, stringBuffer);
                            stringBuffer.append(".atNC(");
                            stringBuffer.append(string);
                            stringBuffer.append(");");
                            stringBuffer.append(eol);
                            stringBuffer.append(this.parent.getIndent());
                        }
                    }
                    if (variableDeclarationArray.length == 0) {
                        this.getInitCode(variableDeclaration, stringBuffer, (ArrayList)serializable);
                    } else {
                        for (int i2 = 0; i2 < variableDeclarationArray.length; ++i2) {
                            String string = this.getCode(variableDeclarationArray[i2], 0, (ArrayList)serializable);
                            if (string.length() <= 0) continue;
                            if (i2 > 0) {
                                stringBuffer.append(this.parent.getIndent());
                            }
                            stringBuffer.append(string);
                        }
                    }
                }
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(this.parent.getIndent());
        }
    }

    private String getCode(VariableDeclaration variableDeclaration, int n2, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "   ";
        }
        stringBuffer.append(string);
        if (variableDeclaration.isDynamic()) {
            bl = true;
            this.getDynVarCode(variableDeclaration, stringBuffer, arrayList);
        } else {
            VariableDeclaration[] variableDeclarationArray = this.getValidChildren(variableDeclaration);
            if (variableDeclaration.redefines == null && variableDeclaration.getLevel() <= 49 && (variableDeclarationArray.length > 0 || this.withFiller || !variableDeclaration.isFiller())) {
                if (variableDeclaration.getOccurs() > 0) {
                    int n3;
                    String string2 = "i" + n2;
                    stringBuffer.append(string);
                    stringBuffer.append("for(int ");
                    stringBuffer.append(string2);
                    if (variableDeclaration.hasVariableOffset()) {
                        stringBuffer.append("=0;");
                        stringBuffer.append(string2);
                        stringBuffer.append("<");
                    } else {
                        stringBuffer.append("=1;");
                        stringBuffer.append(string2);
                        stringBuffer.append("<=");
                    }
                    stringBuffer.append(variableDeclaration.getOccurs());
                    stringBuffer.append(";");
                    stringBuffer.append(string2);
                    stringBuffer.append("++) {");
                    stringBuffer.append(eol);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.addAll(arrayList);
                    arrayList2.add(string2);
                    if (variableDeclarationArray.length == 0) {
                        stringBuffer.append(this.parent.getIndent());
                        for (n3 = 0; n3 < n2 + 1; ++n3) {
                            stringBuffer.append("   ");
                        }
                        bl |= this.getInitCode(variableDeclaration, stringBuffer, arrayList2);
                    } else {
                        for (n3 = 0; n3 < variableDeclarationArray.length; ++n3) {
                            String string3 = this.getCode(variableDeclarationArray[n3], n2 + 1, arrayList2);
                            bl |= string3.length() > 0;
                            stringBuffer.append(string3);
                        }
                    }
                    stringBuffer.append(this.parent.getIndent());
                    for (n3 = 0; n3 < n2 - 1; ++n3) {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append("}");
                    stringBuffer.append(eol);
                } else if (variableDeclarationArray.length == 0) {
                    bl |= this.getInitCode(variableDeclaration, stringBuffer, arrayList);
                } else {
                    for (int i3 = 0; i3 < variableDeclarationArray.length; ++i3) {
                        String string4 = this.getCode(variableDeclarationArray[i3], n2 + 1, arrayList);
                        bl |= string4.length() > 0;
                        stringBuffer.append(string4);
                    }
                }
            }
        }
        return bl ? stringBuffer.toString() : "";
    }

    private VariableDeclaration[] getValidChildren(VariableDeclaration variableDeclaration) {
        Vector<VariableDeclaration> vector = new Vector<VariableDeclaration>();
        VariableDeclaration[] variableDeclarationArray = variableDeclaration.getChildren().elements();
        while (variableDeclarationArray.hasMoreElements()) {
            VariableDeclaration variableDeclaration2 = (VariableDeclaration)variableDeclarationArray.nextElement();
            if (variableDeclaration2.level > 49) continue;
            vector.addElement(variableDeclaration2);
        }
        variableDeclarationArray = new VariableDeclaration[vector.size()];
        vector.toArray(variableDeclarationArray);
        return variableDeclarationArray;
    }

    private boolean getInitCode(VariableDeclaration variableDeclaration, StringBuffer stringBuffer, ArrayList arrayList) {
        boolean bl = true;
        Integer n2 = this.varDeclToCategory(variableDeclaration);
        if ((this.allToValue || this.valueCats.contains(n2)) && variableDeclaration.value != null) {
            stringBuffer.append(this.getCodeLiteral(variableDeclaration.value));
            stringBuffer.append(".moveTo(");
            this.getVarCode(variableDeclaration, stringBuffer, true, arrayList);
            stringBuffer.append(");");
            stringBuffer.append(eol);
        } else {
            Object object = this.repCats.get(n2);
            if (object != null) {
                if (object instanceof Token) {
                    stringBuffer.append(this.getCodeLiteral((Token)object));
                } else {
                    stringBuffer.append(((VariableName)object).getCode());
                }
                stringBuffer.append(".moveTo(");
                this.getVarCode(variableDeclaration, stringBuffer, true, arrayList);
                stringBuffer.append(");");
                stringBuffer.append(eol);
            } else if (this.toDefault || !this.allToValue && this.valueCats.isEmpty() && this.repCats.isEmpty()) {
                this.getDefaultInitializeCode(variableDeclaration, stringBuffer, arrayList);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private void getDefaultInitializeCode(VariableDeclaration variableDeclaration, StringBuffer stringBuffer, ArrayList arrayList) {
        this.getUnivoqueName(variableDeclaration, stringBuffer);
        if (variableDeclaration.hasVariableOffset()) {
            Object[] objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            stringBuffer.append(".offsNC(" + new OffsetHelper(variableDeclaration, objectArray) + ")");
            stringBuffer.append(".defaultInitialize();");
        } else if (arrayList.size() > 0) {
            if (arrayList.size() > 1) {
                stringBuffer.append(".atDefaultInitialize(new int[] {");
                stringBuffer.append(arrayList.get(0));
                for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                    stringBuffer.append("," + arrayList.get(i2));
                }
                stringBuffer.append("});");
            } else {
                stringBuffer.append(".atDefaultInitialize(");
                stringBuffer.append(arrayList.get(0));
                stringBuffer.append(");");
            }
        } else {
            stringBuffer.append(".defaultInitialize();");
        }
        stringBuffer.append(eol);
    }

    private void getVarCode(VariableDeclaration variableDeclaration, StringBuffer stringBuffer, boolean bl, ArrayList arrayList) {
        if ((arrayList.size() > 0 || variableDeclaration.hasVariableOffset()) && bl) {
            stringBuffer.append("(");
            if (variableDeclaration.isNumeric()) {
                if (variableDeclaration.isEdited()) {
                    stringBuffer.append("PicNumEdit");
                } else {
                    stringBuffer.append("NumericVar");
                }
            } else if (variableDeclaration.isNational()) {
                stringBuffer.append("PicN");
            } else {
                stringBuffer.append("PicX");
            }
            stringBuffer.append(")");
        }
        this.getUnivoqueName(variableDeclaration, stringBuffer);
        if (variableDeclaration.hasVariableOffset()) {
            Object[] objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            stringBuffer.append(".offsNC(" + new OffsetHelper(variableDeclaration, objectArray) + ")");
        } else if (arrayList.size() > 0) {
            stringBuffer.append(".atNC(new int[] {");
            stringBuffer.append(arrayList.get(0));
            for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                stringBuffer.append("," + arrayList.get(i2));
            }
            stringBuffer.append("})");
        }
    }

    private void getUnivoqueName(VariableDeclaration variableDeclaration, StringBuffer stringBuffer) {
        if (variableDeclaration.getClass() == VariableDeclaration.class) {
            IDataSection iDataSection = variableDeclaration.getParentSection();
            if (iDataSection instanceof ThreadLocalStorageSection || iDataSection instanceof FileDescriptor && ((FileDescriptor)iDataSection).threadLocal) {
                if (!this.pc.optionMS) {
                    stringBuffer.append("$my_thloc_stg$.");
                }
            } else if (iDataSection instanceof LocalStorageSection) {
                if (!this.pc.optionMS) {
                    stringBuffer.append("$my_loc_stg$.");
                }
            } else if (variableDeclaration.pc instanceof CobolMethod) {
                stringBuffer.append("this.");
            } else if (variableDeclaration.pc instanceof CobolClass) {
                Pcc pcc = this.pc.getRoot();
                stringBuffer.append(pcc.getFullClassName() + ".");
                if (!this.pc.isFactory()) {
                    stringBuffer.append("this.");
                }
            }
        }
        stringBuffer.append(variableDeclaration.getUnivoqueName());
    }

    private void getDynVarCode(VariableDeclaration variableDeclaration, StringBuffer stringBuffer, ArrayList arrayList) {
        this.getUnivoqueName(variableDeclaration, stringBuffer);
        stringBuffer.append(".dynInitialize(");
        if (arrayList.size() > 0) {
            stringBuffer.append("new int[] {");
            stringBuffer.append(arrayList.get(0));
            for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                stringBuffer.append("," + arrayList.get(i2));
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
    }

    private Integer varDeclToCategory(VariableDeclaration variableDeclaration) {
        if (variableDeclaration.isNumeric()) {
            if (variableDeclaration.isEdited) {
                return T_NUMERIC_EDITED;
            }
            return T_NUMERIC;
        }
        if (variableDeclaration.isEdited) {
            return T_ALPHANUMERIC_EDITED;
        }
        if (variableDeclaration.isAlphabetic()) {
            return T_ALPHABETIC;
        }
        if (variableDeclaration.isPic1()) {
            return T_BOOLEAN;
        }
        return T_ALPHANUMERIC;
    }
}

