/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.As;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IInlineInvoke;

public class InlineInvoke
extends VariableDeclaration
implements IInlineInvoke {
    private Invoke inlInvoke;
    private VariableName obj;
    private MyClass clazz;
    private As oas;
    private Token lastToken;

    private InlineInvoke(Pcc pcc, Token token, TokenManager tokenManager) {
        super(pcc, token, tokenManager);
        this.pc = pcc;
        this.parent = null;
        this.name = token;
        this.level = 77;
        this.dimension = 0;
    }

    public InlineInvoke(VariableName variableName, Block block, Pcc pcc, Token token, TokenManager tokenManager, Errors errors) throws EndOfProgramException, GeneralErrorException {
        this(pcc, token, tokenManager);
        this.obj = variableName;
        this.error = errors;
        Token token2 = new Token(544, "::", token.getFLN(), token.getOffset(), token.getFileName());
        token2.setFileIndex(token.getFileIndex());
        this.inlInvoke = new Invoke(this.obj, token2, block, this.pc, tokenManager, errors);
        token = this.tm.getToken();
        if (token.getToknum() == 280) {
            if (variableName.isLambdaExpression()) {
                throw new GeneralErrorException(274, 4, token2, token.getWord(), this.error);
            }
            this.oas = new As(token2, block, pcc, tokenManager, errors, null);
        } else {
            this.tm.ungetToken();
        }
        this.preCheck();
        this.checkInvokeNotifier();
    }

    private void checkInvokeNotifier() throws GeneralErrorException, EndOfProgramException {
        if (Pcc.getInvokeNotifier() != null) {
            this.tm.ungetToken();
            this.lastToken = this.tm.getToken();
            if (!Pcc.getInvokeNotifier().foundInlineInvoke(this)) {
                throw new EndOfProgramException();
            }
        }
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    public void preCheck() throws GeneralErrorException {
        this.clazz = this.inlInvoke.getType();
        if (this.oas != null) {
            MyClass myClass = this.oas.getType();
            if (myClass == null) {
                throw new MissingClassException(this.oas.as, this.oas.keyWord, this.error);
            }
            if (this.clazz.isPrimitive() && myClass.isPrimitive()) {
                if (this.clazz.isAssignableFrom(Boolean.TYPE) != myClass.isAssignableFrom(Boolean.TYPE)) {
                    throw new GeneralErrorException(80, 4, this.inlInvoke.keyWord, myClass.toString(), this.error);
                }
                this.clazz = myClass;
                if (!this.isBoolean()) {
                    this.setNumeric(true);
                }
            } else if (!this.clazz.isAssignableFrom(myClass, false)) {
                throw new GeneralErrorException(80, 4, this.inlInvoke.keyWord, myClass.toString(), this.error);
            }
            this.clazz = myClass;
        }
        if (this.clazz != null) {
            if (this.clazz.isAssignableTo(Pcc.TYPES_PACKAGE + ".NumericVar")) {
                this.setNumeric(true);
            } else if (!this.clazz.isAssignableTo(Pcc.TYPES_PACKAGE + ".PicX")) {
                this.setClassName(this.clazz.getName());
            }
        }
    }

    @Override
    public boolean isInteger() {
        return this.clazz.isClass(Byte.TYPE) || this.clazz.isClass(Short.TYPE) || this.clazz.isClass(Integer.TYPE) || this.clazz.isClass(Long.TYPE);
    }

    @Override
    boolean notElementary() {
        return false;
    }

    @Override
    public boolean isField() {
        return this.inlInvoke.isField();
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.clazz == null) {
            this.preCheck();
        }
        this.inlInvoke.check();
    }

    @Override
    public Invoke getInvoke() {
        return this.inlInvoke;
    }

    @Override
    public String getTypeName() {
        return this.clazz.getName();
    }

    @Override
    public boolean isObjectReference() {
        return !this.clazz.isCobolVar() && !this.clazz.isPrimitive();
    }

    @Override
    public boolean isBoolean() {
        return this.clazz.isClass(Boolean.TYPE);
    }

    @Override
    public String getUnivoqueName() {
        if (this.oas == null) {
            return this.inlInvoke.getCode();
        }
        try {
            MyClass myClass = this.inlInvoke.getType();
            if (myClass.isCobolVar() && this.oas.isPrimitiveOrString()) {
                return this.inlInvoke.getCode() + ".to" + this.oas.as + "()";
            }
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        return "(" + this.oas.getCode() + this.inlInvoke.getCode() + ")";
    }

    @Override
    public String toString() {
        return super.toString() + "::" + this.inlInvoke;
    }
}

