/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Version;
import com.iscobol.interfaces.compiler.IInputOutputSectionExtension;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;

public class InputOutputSection
implements CobolToken,
ErrorsNumbers,
IInputOutputSectionExtension {
    private Pcc pc;
    TokenManager tm;
    Errors error;
    SelectList selects = new SelectList();
    private Token firstToken;
    private Token fcFirstToken;

    public InputOutputSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = token;
        boolean bl = true;
        this.pc = pcc;
        this.error = errors;
        this.tm = tokenManager;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token2, "'.'");
                this.tm.ungetToken();
            }
            block8: while (bl && (token2 = this.tm.getToken()).getToknum() != 388 && token2.getToknum() != 651) {
                switch (token2.getToknum()) {
                    case 483: {
                        this.fcFirstToken = token2;
                        try {
                            this.fileControl();
                        }
                        catch (GeneralErrorException generalErrorException) {
                            this.tm.skipToDot();
                        }
                        continue block8;
                    }
                    case 519: {
                        try {
                            this.ioControl();
                        }
                        catch (GeneralErrorException generalErrorException) {
                            this.tm.skipToDot();
                        }
                        continue block8;
                    }
                }
                bl = false;
            }
        } else {
            throw new UnexpectedTokenException(token2, errors);
        }
        this.tm.ungetToken();
    }

    private void fileControl() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 10006) {
            while ((token = this.tm.getToken()).getToknum() == 712) {
                Select select = new Select(this.pc, this.tm, this.error);
                Select select2 = this.selects.getFirst();
                while (select2 != null) {
                    if (select2.fileName.getWord().equals(select.fileName.getWord())) {
                        throw new GeneralErrorException(155, 4, select.fileName, select.fileName.getWord(), this.error);
                    }
                    select2 = this.selects.getNext();
                }
                this.selects.addItem(select);
            }
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        this.tm.ungetToken();
    }

    private void ioControl() throws GeneralErrorException, EndOfProgramException {
        boolean bl = false;
        HashSet<Select> hashSet = new HashSet<Select>();
        Token token = this.tm.getToken();
        if (token.getToknum() == 10006) {
            boolean bl2 = true;
            block4: while (bl2) {
                token = this.tm.getToken();
                switch (token.getToknum()) {
                    case 704: {
                        Select select;
                        boolean bl3;
                        Select select2 = null;
                        token = this.tm.getToken();
                        if (token.getToknum() == 670 || token.getToknum() == 672) {
                            bl3 = true;
                            token = this.tm.getToken();
                        } else if (token.getToknum() == 732 || token.getToknum() == 733) {
                            bl3 = false;
                            token = this.tm.getToken();
                        } else {
                            bl3 = false;
                        }
                        if (token.getToknum() == 278) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() != 494) {
                            this.tm.ungetToken();
                        }
                        while ((token = this.tm.getToken()).getToknum() == 10009) {
                            select = this.selects.getFirst();
                            while (select != null && !select.fileName.getWord().equals(token.getWord())) {
                                select = this.selects.getNext();
                            }
                            if (select == null) {
                                throw new GeneralErrorException(26, 4, token, token.getWord(), this.error);
                            }
                            if (!bl3) continue;
                            if (hashSet.contains(select)) {
                                throw new GeneralErrorException(153, 4, token, token.getWord(), this.error);
                            }
                            hashSet.add(select);
                            if (select2 == null) {
                                select2 = select;
                                continue;
                            }
                            select.setSameRecordArea(select2);
                        }
                        this.tm.ungetToken();
                        bl = true;
                        continue block4;
                    }
                    case 276: {
                        boolean bl4;
                        Select select;
                        token = this.tm.getToken();
                        if (token.getToknum() == 571) {
                            bl4 = true;
                            token = this.tm.getToken();
                            if (token.getToknum() != 613) {
                                throw new ExpectedFoundException(token, this.error, "ON");
                            }
                        } else if ("WRITE-ONLY".equals(token.getWord())) {
                            if (this.tm.getToken().getToknum() != 613) {
                                this.tm.ungetToken();
                            }
                            bl4 = false;
                        } else {
                            throw new UnexpectedTokenException(token, this.error);
                        }
                        while ((token = this.tm.getToken()).getToknum() == 10009) {
                            select = this.selects.getFirst();
                            while (select != null && !select.fileName.getWord().equals(token.getWord())) {
                                select = this.selects.getNext();
                            }
                            if (select == null) {
                                throw new GeneralErrorException(26, 4, token, token.getWord(), this.error);
                            }
                            if (!bl4) continue;
                            select.setMultipleRecords(true);
                        }
                        this.tm.ungetToken();
                        bl = true;
                        continue block4;
                    }
                }
                bl2 = false;
            }
            if (bl) {
                if (token.getToknum() != 10006) {
                    throw new UnexpectedTokenException(token, this.error);
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
    }

    void check(Pcc pcc) {
        Select select = this.selects.getFirst();
        while (select != null) {
            try {
                select.check(pcc);
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            select = this.selects.getNext();
        }
    }

    @Override
    public void generateEfdFiles() throws Exception {
        this.makeEFD();
    }

    void makeEFD() throws GeneralErrorException {
        char c2 = Pcc.hyphenRepl;
        char c3 = Pcc.identifierSep;
        Pcc.hyphenRepl = (char)95;
        Pcc.identifierSep = (char)36;
        try {
            this.makeEFD0();
        }
        finally {
            Pcc.hyphenRepl = c2;
            Pcc.identifierSep = c3;
        }
    }

    private void makeEFD0() throws GeneralErrorException {
        String string = this.tm.getOptionList().getOption("-efo=");
        String string2 = "                                                                                          ";
        Select select = this.selects.getFirst();
        while (select != null) {
            if (!(select.isPrinter || select.isSort() || this.pc.options.getOption("-efa") == null && select.organization != 529)) {
                try {
                    String string3;
                    PrintWriter printWriter;
                    File file;
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (string == null) {
                        if (this.pc.sourceDir != null && this.pc.sourceDir.length() > 0) {
                            stringBuffer.append(this.pc.sourceDir);
                            stringBuffer.append(File.separator);
                        }
                    } else {
                        stringBuffer.append(string);
                        stringBuffer.append(File.separator);
                    }
                    stringBuffer2.append(stringBuffer.toString());
                    stringBuffer.append(select.getEfdName() + ".xml");
                    stringBuffer2.append(select.getEfdName() + ".iss");
                    if (this.pc.options.getOption("-efc") != null && select.organization == 529) {
                        file = new File(stringBuffer2.toString());
                        if (file.exists()) {
                            file.delete();
                        }
                        if (file.createNewFile()) {
                            printWriter = PreProcessor.newPrintWriter(file);
                            string3 = "<!-- Generated by " + Version.getRelease();
                            string3 = string3.length() < 75 ? string3 + string2.substring(0, 75 - string3.length()) + "-->" + eol : string3 + "-->" + eol;
                            printWriter.print(string3);
                            string3 = "<!-- compiler options: " + this.pc.getOptions().getAll().replace('\\', '/');
                            string3 = string3.length() < 75 ? string3 + string2.substring(0, 75 - string3.length()) + "-->" + eol : string3 + "-->" + eol;
                            printWriter.print(string3);
                            printWriter.print(select.getEfcCode());
                            printWriter.close();
                        }
                    }
                    if (this.pc.options.getOption("-efd") != null || this.pc.options.getOption("-efa") != null) {
                        file = new File(stringBuffer.toString());
                        if (file.exists()) {
                            file.delete();
                        }
                        if (file.createNewFile()) {
                            printWriter = PreProcessor.newPrintWriter(file);
                            string3 = "<!-- Generated by " + Version.getRelease();
                            string3 = string3.length() < 75 ? string3 + string2.substring(0, 75 - string3.length()) + "-->" + eol : string3 + "-->" + eol;
                            printWriter.print(string3);
                            string3 = "<!-- compiler options: " + this.pc.getOptions().getAll().replace('\\', '/');
                            string3 = string3.length() < 75 ? string3 + string2.substring(0, 75 - string3.length()) + "-->" + eol : string3 + "-->" + eol;
                            printWriter.print(string3);
                            printWriter.print(select.getEfdCode());
                            printWriter.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            select = this.selects.getNext();
        }
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Select select = this.selects.getFirst();
        while (select != null) {
            if (!select.getFD().threadLocal) {
                stringBuffer2.append(select.getCode(stringBuffer));
            }
            select = this.selects.getNext();
        }
        return stringBuffer2.toString();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getFileControlFirstToken() {
        return this.fcFirstToken;
    }

    @Override
    public SelectList getSelectList() {
        return this.selects;
    }
}

