/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GUIControl;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class Inquire
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int HND_NO_HANDLE = -1;
    public static final int HND_GENERIC = 1;
    public static final int HND_WINDOW = 2;
    public static final int HND_CONTROL = 3;
    LinkedList child = new LinkedList();
    Vector args = new Vector();
    int inquireType = -1;
    VariableName name;
    Token nameToken;
    GUIControl guictl;
    boolean isGraphical;
    Map<String, Object> windowProperties = new HashMap<String, Object>();
    VariableName linesVar;
    VariableName screenLineVar;
    Token screenLineToken;
    VariableName screenColumnVar;
    Token screenColumnToken;
    VariableName screenAbsLineVar;
    VariableName screenAbsColumnVar;
    VariableName sizeVar;
    VariableName colorVar;
    VariableName colorBackVar;
    VariableName colorForeVar;
    VariableName titleVar;
    boolean visible = false;
    VariableName visibleVar;
    VariableName popupMenuVar;
    VariableName classVar;
    VariableName objVar;
    VariableName statusVar;
    VariableName systemHandleVar;
    VariableName layoutManagerVar;
    VariableName hintVar;
    VariableName layoutVar;
    VariableName massUpdateVar;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Inquire(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        if (this.pc.getOption("-whttp") != null) {
            this.error.print(232, 2, token, token.getWord());
        }
        this.pc.useScreen = true;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 812 || token2.getToknum() == 373) {
            this.inquireType = token2.getToknum();
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 10009) {
            int n2;
            this.nameToken = token2;
            this.name = this.localVariableNameGet(false);
            if (this.inquireType == -1) {
                this.inquireType = this.typeItemName(this.name);
            } else if (this.inquireType == 812 && (n2 = this.typeItemName(this.name)) != 2 && n2 != 1) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            if (this.inquireType == 2 || this.inquireType == 812) {
                if (!this.name.getVarDecl().checkDimension(this.name.getDimension())) {
                    throw new GeneralErrorException(41, 4, this.name.getNameToken(), this.name.getNameToken().getWord(), this.error);
                }
                this.inquireWindow();
            } else {
                if (this.inquireType != 3 && this.inquireType != 1) throw new UnexpectedTokenException(token2, this.error);
                VariableDeclaration variableDeclaration = null;
                if (this.name != null && (variableDeclaration = this.name.getVarDecl()) != null && !(variableDeclaration instanceof VariableDeclarationScreen) && variableDeclaration.getControlHandle() != 12 && variableDeclaration.getControlHandle() != 10 && variableDeclaration.getControlHandle() != 21 && variableDeclaration.getControlHandle() != 7 && variableDeclaration.getControlHandle() != 8 && variableDeclaration.getControlHandle() != 14 && variableDeclaration.getControlHandle() != 17 && !this.name.getVarDecl().checkDimension(this.name.getDimension())) {
                    throw new GeneralErrorException(41, 4, this.name.getNameToken(), this.name.getNameToken().getWord(), this.error);
                }
                if (this.name != null && this.name.hasSubValue()) {
                    token2 = this.name.getNameToken();
                    throw new GeneralErrorException(17, 4, new Token(':', token2.getFLN(), token2.getOffset(), token2.getFileName()), ":", this.error);
                }
                this.guictl = new GUIControl(this.pc, this.tm, this.error, this.nameToken, this.keyWord, 5, null);
                this.guictl.setGraphicControlType(this.getGraphicControlType(this.name));
                token2 = this.tm.getToken();
                if (token2.getToknum() == 40) {
                    this.guictl.sa.loadIndexes(this.nameToken, this.tm, errors, this.pc);
                } else {
                    this.tm.ungetToken();
                }
                this.loadInquireControl(this.guictl);
            }
        } else if (this.inquireType == 373) {
            this.tm.ungetToken();
            this.guictl = new GUIControl(this.pc, this.tm, this.error, this.nameToken, this.keyWord, 5, null);
            this.loadInquireControl(this.guictl);
        } else {
            if (this.inquireType != 812) throw new UnexpectedTokenException(token2, this.error);
            this.tm.ungetToken();
            this.inquireWindow();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.child.add(new Inquire(token, block, pcc, tokenManager, errors));
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    private VariableName localVariableNameGet() throws GeneralErrorException, EndOfProgramException {
        return this.localVariableNameGet(true);
    }

    private VariableName localVariableNameGet(boolean bl) throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        VariableName variableName = VariableName.get(this.tm, this.error, null, this.pc, false, true, bl, true);
        return variableName;
    }

    protected int getGraphicControlType(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        int n2 = -1;
        variableDeclaration = this.pc.getVar(variableName, false);
        if (variableDeclaration != null && variableDeclaration instanceof VariableDeclarationScreen && ((VariableDeclarationScreen)variableDeclaration).guictl.isGraphicControlType()) {
            n2 = ((VariableDeclarationScreen)variableDeclaration).guictl.getGraphicControlType();
        }
        if (n2 == -1 && variableDeclaration.isControlHandle()) {
            n2 = variableDeclaration.getControlHandle();
        }
        return n2;
    }

    protected int typeItemName(VariableName variableName) throws GeneralErrorException {
        VariableDeclaration variableDeclaration = null;
        int n2 = -1;
        variableDeclaration = this.pc.getVar(variableName, false);
        if (variableDeclaration != null) {
            if (variableDeclaration instanceof VariableDeclarationScreen) {
                if (((VariableDeclarationScreen)variableDeclaration).guictl.isGraphicControlType()) {
                    n2 = 3;
                }
            } else if (variableDeclaration instanceof VariableDeclaration) {
                if (variableDeclaration.isControlHandle()) {
                    n2 = 3;
                } else if (variableDeclaration.isGenericHandle()) {
                    n2 = 1;
                } else if (variableDeclaration.isWindowHandle()) {
                    n2 = 2;
                }
            }
        }
        return n2;
    }

    @Override
    public void check() throws GeneralErrorException {
        this.checkPerform();
    }

    private void inquireWindow() throws GeneralErrorException, EndOfProgramException {
        Token token;
        boolean bl = true;
        block15: while (bl && (token = this.tm.getToken()) != null) {
            switch (token.getToknum()) {
                case 566: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.linesVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new ExpectedFoundException(token, this.error, "literal");
                }
                case 771: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.titleVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new ExpectedFoundException(token, this.error, "literal");
                }
                case 565: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 602) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.screenLineVar = this.localVariableNameGet();
                        continue block15;
                    }
                    if (Token.isNumLit(token)) {
                        this.screenLineToken = token;
                        continue block15;
                    }
                    throw new ExpectedFoundException(token, this.error, "literal");
                }
                case 334: 
                case 338: 
                case 640: 
                case 641: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 602) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.screenColumnVar = this.localVariableNameGet();
                        continue block15;
                    }
                    if (Token.isNumLit(token)) {
                        this.screenColumnToken = token;
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 705: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 565) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 602) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 526 || token.getToknum() == 61) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 10009) {
                            this.screenAbsLineVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(token, this.error);
                    }
                    if (token.getToknum() == 338 || token.getToknum() == 334 || token.getToknum() == 641 || token.getToknum() == 640) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 602) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 526 || token.getToknum() == 61) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 10009) {
                            this.screenAbsColumnVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(token, this.error);
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 728: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.sizeVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 336: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.colorVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 292: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.colorBackVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 495: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.colorForeVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 808: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.visibleVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 639: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 580) {
                        token = this.tm.getToken();
                        if (token.getToknum() == 526 || token.getToknum() == 61) {
                            token = this.tm.getToken();
                        }
                        if (token.getToknum() == 10009) {
                            this.popupMenuVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(token, this.error);
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 742: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.statusVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
                case 753: {
                    throw new GeneralErrorException(11, 4, token, token.getWord(), this.error);
                }
            }
            if (token.getWord().equalsIgnoreCase("HINT")) {
                token = this.tm.getToken();
                if (token.getToknum() == 526 || token.getToknum() == 61) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.hintVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
            if (token.getWord().equalsIgnoreCase("LAYOUT")) {
                token = this.tm.getToken();
                if (token.getToknum() == 526 || token.getToknum() == 61) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.layoutVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
            if (token.getWord().equalsIgnoreCase("PLACEHOLDER")) {
                token = this.tm.getToken();
                if (token.getToknum() == 526 || token.getToknum() == 61) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.hintVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
            if (token.getWord().equalsIgnoreCase("MASS-UPDATE")) {
                token = this.tm.getToken();
                if (token.getToknum() == 526 || token.getToknum() == 61) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.massUpdateVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
            if (GUIControl.windowPropertyNames.contains(token.getWord())) {
                String string = token.getWord();
                token = this.tm.getToken();
                if (token.getToknum() == 526 || token.getToknum() == 61) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 10009) {
                    this.windowProperties.put(string, this.localVariableNameGet());
                    continue;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
            bl = false;
            this.tm.ungetToken();
        }
    }

    private String printVariableName(VariableName variableName) {
        String string = "";
        if (variableName != null) {
            string = variableName.getCode();
        }
        return string;
    }

    private void loadJavaBeanRef() throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration variableDeclaration = this.name.getVarDecl();
        if (!(variableDeclaration.isHandle() || variableDeclaration instanceof VariableDeclarationScreen && ((VariableDeclarationScreen)variableDeclaration).graphicControlType == 19)) {
            throw new GeneralErrorException(75, 4, this.name.getNameToken(), this.name.getName(), this.error);
        }
        Token token = this.tm.getToken();
        if (token.getToknum() == 526 || token.getToknum() == 61) {
            token = this.tm.getToken();
        }
        if (token.getToknum() == 10009) {
            this.tm.ungetToken();
            this.objVar = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
            if (this.objVar == null) {
                throw new GeneralErrorException(81, 4, token, token.getWord(), this.error);
            }
            if (!this.objVar.getType().getName().equals("com.iscobol.gui.server.CobolGUIJavaBean")) {
                throw new GeneralErrorException(75, 4, this.objVar.getNameToken(), this.objVar.getName(), this.error);
            }
        } else {
            throw new ExpectedFoundException(token, this.error, "literal");
        }
    }

    private String printToken(Token token) {
        String string = "";
        if (token != null) {
            string = token.getToknum() == 10002 || token.getToknum() == 10017 ? token.getCodeFltLiteral(this.tm.getDecimalPointIsComma()) : token.getWord();
        }
        return string;
    }

    private void getInquireObjCode(StringBuffer stringBuffer) {
        stringBuffer.append(this.objVar.getCode());
        stringBuffer.append("=CobolGUIJavaBean.getObjectRef(");
        stringBuffer.append(this.name.getCode());
        stringBuffer.append(");");
        stringBuffer.append(eol);
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.objVar != null) {
            this.getInquireObjCode(stringBuffer);
            return stringBuffer.toString();
        }
        if (this.inquireType == 3 || this.inquireType == 1) {
            stringBuffer.append("ScrFactory.getGUIEnviroment().inquireControl");
        } else if (this.inquireType == 812 || this.inquireType == 2) {
            stringBuffer.append("ScrFactory.getGUIEnviroment().inquireWindow");
        }
        if (this.name != null) {
            stringBuffer.append("(");
            if (this.guictl != null && this.guictl.sa != null) {
                stringBuffer.append(this.guictl.sa.getCodeName(this.name, this.inquireType == 3 || this.inquireType == 812 || this.inquireType == 2));
            } else {
                stringBuffer.append(this.name.getCode());
            }
            if (this.statusVar != null) {
                stringBuffer.append(",");
                stringBuffer.append(this.statusVar.getCode());
            }
            stringBuffer.append(")");
        } else if (this.inquireType == 812) {
            if (this.statusVar != null) {
                stringBuffer.append("Status(");
                stringBuffer.append(this.statusVar.getCode());
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(")");
        }
        if (this.inquireType == 373) {
            if (this.guictl != null && this.guictl.sa != null) {
                stringBuffer.append("if (ScrFactory.getGUIEnviroment().getControl(");
                stringBuffer.append(this.guictl.sa.getScreenAttributeLINEPOSITION());
                stringBuffer.append(") != null)" + eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("   ScrFactory.getGUIEnviroment().inquireControl(ScrFactory.getGUIEnviroment().getControl(");
                stringBuffer.append(this.guictl.sa.getScreenAttributeLINEPOSITION());
                stringBuffer.append("))");
                stringBuffer.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".get", false, false, true));
            }
        } else if (this.guictl != null) {
            stringBuffer.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".get"));
        }
        if (this.inquireType != 373) {
            if (this.screenLineVar != null || this.screenLineToken != null) {
                stringBuffer.append(".getAtLine(");
                stringBuffer.append(this.printVariableName(this.screenLineVar));
                stringBuffer.append(this.printToken(this.screenLineToken));
                stringBuffer.append(")");
            }
            if (this.screenColumnVar != null || this.screenColumnToken != null) {
                stringBuffer.append(".getAtColumn(");
                stringBuffer.append(this.printVariableName(this.screenColumnVar));
                stringBuffer.append(this.printToken(this.screenColumnToken));
                stringBuffer.append(")");
            }
        }
        if (this.screenAbsLineVar != null) {
            stringBuffer.append(".getScreenLine(");
            stringBuffer.append(this.printVariableName(this.screenAbsLineVar));
            stringBuffer.append(")");
        }
        if (this.screenAbsColumnVar != null) {
            stringBuffer.append(".getScreenColumn(");
            stringBuffer.append(this.printVariableName(this.screenAbsColumnVar));
            stringBuffer.append(")");
        }
        if (this.sizeVar != null) {
            stringBuffer.append(".getColumns(");
            stringBuffer.append(this.printVariableName(this.sizeVar));
            stringBuffer.append(")");
        }
        if (this.linesVar != null) {
            stringBuffer.append(".getLines(");
            stringBuffer.append(this.printVariableName(this.linesVar));
            stringBuffer.append(")");
        }
        if (this.colorVar != null) {
            stringBuffer.append(".getColor(");
            stringBuffer.append(this.printVariableName(this.colorVar));
            stringBuffer.append(")");
        }
        if (this.colorBackVar != null) {
            stringBuffer.append(".getColorBackground(");
            stringBuffer.append(this.printVariableName(this.colorBackVar));
            stringBuffer.append(")");
        }
        if (this.colorForeVar != null) {
            stringBuffer.append(".getColorForeground(");
            stringBuffer.append(this.printVariableName(this.colorForeVar));
            stringBuffer.append(")");
        }
        if (this.classVar != null) {
            stringBuffer.append(".getClassType(");
            stringBuffer.append(this.printVariableName(this.classVar));
            stringBuffer.append(")");
        }
        if (this.titleVar != null) {
            stringBuffer.append(".getTitle(");
            stringBuffer.append(this.printVariableName(this.titleVar));
            stringBuffer.append(")");
        }
        if (this.hintVar != null) {
            stringBuffer.append(".getToolTipText(");
            stringBuffer.append(this.hintVar.getCode());
            stringBuffer.append(")");
        }
        if (this.layoutVar != null) {
            stringBuffer.append(".getDockInfo(");
            stringBuffer.append(this.layoutVar.getCode());
            stringBuffer.append(")");
        }
        for (String object : this.windowProperties.keySet()) {
            stringBuffer.append(".getWindowProperty(\"" + object + "\", ");
            stringBuffer.append(this.printVariableName((VariableName)this.windowProperties.get(object)));
            stringBuffer.append(")");
        }
        if (this.visibleVar != null) {
            stringBuffer.append(".getVisible(");
            stringBuffer.append(this.printVariableName(this.visibleVar));
            stringBuffer.append(")");
        }
        if (this.popupMenuVar != null) {
            stringBuffer.append(".getPopupMenu(");
            stringBuffer.append(this.printVariableName(this.popupMenuVar));
            stringBuffer.append(")");
        }
        if (this.layoutManagerVar != null) {
            stringBuffer.append(".getLayoutManager(");
            stringBuffer.append(this.printVariableName(this.layoutManagerVar));
            stringBuffer.append(")");
        }
        if (this.massUpdateVar != null) {
            stringBuffer.append(".getMassUpdate(");
            stringBuffer.append(this.massUpdateVar.getCode());
            stringBuffer.append(")");
        }
        stringBuffer.append(".endInquire();" + eol);
        if (this.inquireType == 373 && this.guictl != null && this.guictl.sa != null && this.classVar != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("else" + eol);
            stringBuffer.append(this.printVariableName(this.classVar) + ".defaultInitialize();" + eol);
        }
        if (this.child.size() > 0) {
            Iterator<String> iterator = this.child.listIterator(0);
            while (iterator.hasNext()) {
                Inquire inquire = (Inquire)iterator.next();
                stringBuffer.append(inquire.getCode());
            }
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public void checkPerform() throws GeneralErrorException {
    }

    public void loadInquireControl(GUIControl gUIControl) throws GeneralErrorException, EndOfProgramException {
        Token token;
        boolean bl = true;
        block5: while (bl && (token = this.tm.getToken()) != null) {
            switch (token.getToknum()) {
                case 325: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.classVar = this.localVariableNameGet();
                        continue block5;
                    }
                    throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                }
                case 606: {
                    this.loadJavaBeanRef();
                    continue block5;
                }
                case 742: {
                    token = this.tm.getToken();
                    if (token.getToknum() == 526 || token.getToknum() == 61) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() == 10009) {
                        this.statusVar = this.localVariableNameGet();
                        continue block5;
                    }
                    throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
                }
            }
            bl = gUIControl.tokenIsAttrScreen(token, this.tm);
            this.tm.ungetToken();
        }
    }
}

