/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Inspect
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int I_ALL = 1;
    public static final int I_LEADING = 2;
    public static final int I_FIRST = 3;
    public static final int I_CHARACTERS = 4;
    private VariableName source;
    private InspectDelimPhrase globDelimPhrase;
    private boolean tallying;
    private boolean replacing;
    private boolean converting;
    private boolean globTrailing;
    private boolean hasNational;
    private VerbList tallyingCounterPhrases = new VerbList();
    private VerbList replacingPhrases = new VerbList();
    private Token tk_target;
    private Token tk_replace;
    private boolean isTkReplFigZero;
    private VariableName vn_target;
    private VariableName vn_replace;
    private Token tk_comp_chars;
    private Token tk_conv_chars;
    private boolean isTkConvCharsFigZero;
    private VariableName vn_comp_chars;
    private VariableName vn_conv_chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inspect(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.allowAllLitGen = false;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!Inspect.isUsageDisplay(this.source)) {
            throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
        }
        this.setHasNational(this.source);
        token2 = this.tm.getToken();
        boolean bl = this.tm.setKeepAll(true);
        try {
            switch (token2.getToknum()) {
                case 757: {
                    this.inspectTallying(this.tm.getToken());
                    break;
                }
                case 683: {
                    if (this.source.isSetGetProperty()) {
                        throw new GeneralErrorException(68, 4, this.source.getNameToken(), this.source.getName(), this.error);
                    }
                    this.inspectReplacing(this.tm.getToken());
                    break;
                }
                case 378: {
                    this.inspectConverting(this.tm.getToken());
                    break;
                }
                default: {
                    throw new UnexpectedTokenException(token2, this.error);
                }
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 683) {
                if (!this.tallying) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
                this.inspectReplacing(token2);
            } else {
                this.tm.ungetToken();
            }
        }
        finally {
            this.tm.setKeepAll(bl);
        }
    }

    static Token cloneToken(Token token, int n2, String string) {
        Token token2 = new Token(token);
        token2.setToknum(n2);
        token2.setWord(string);
        token2.setAll(token.isAll());
        return token2;
    }

    void inspectTallying(Token token) throws GeneralErrorException, EndOfProgramException {
        this.tallying = true;
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        do {
            this.tm.ungetToken();
            this.tallyingCounterPhrases.addItem(new InspectTallyingCounterPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, token));
        } while ((token = this.tm.getToken()).getToknum() == 10009);
        this.tm.ungetToken();
    }

    void inspectReplacing(Token token) throws GeneralErrorException, EndOfProgramException {
        this.replacing = true;
        if (token.getToknum() == 776) {
            this.inspectReplacingTrailing(this.tm.getToken());
            return;
        }
        int n2 = -1;
        int n3 = 0;
        block5: while (true) {
            switch (token.getToknum()) {
                case 10002: {
                    if (token.isFigurativeZero()) {
                        token = Inspect.cloneToken(token, 10001, "'0'");
                    }
                }
                case 10001: 
                case 10009: {
                    if (token.isAll()) {
                        n2 = 262;
                        break;
                    }
                    if (n3 != 0) break;
                    throw new ExpectedFoundException(token, this.error, "'ALL'");
                }
                case 324: 
                case 489: 
                case 556: {
                    n2 = token.getToknum();
                    token = this.tm.getToken();
                    break;
                }
                default: {
                    if (n3 != 0) break block5;
                    throw new UnexpectedTokenException(token, this.error);
                }
            }
            this.replacingPhrases.addItem(new InspectReplacingPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, token, n2));
            token = this.tm.getToken();
            ++n3;
        }
        this.tm.ungetToken();
    }

    void inspectReplacingTrailing(Token token) throws GeneralErrorException, EndOfProgramException {
        this.globTrailing = true;
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                this.vn_target = VariableName.get(this.tm, this.error, this.pc);
                if (this.vn_target.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, token, token.getWord(), this.error);
                }
                if (this.vn_target.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
                }
                this.setHasNational(this.vn_target);
                break;
            }
            case 10001: {
                this.tk_target = token;
                if (token.getRealLength() <= 1) break;
                throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
            }
            default: {
                if (token.isFigurativeZero()) {
                    this.tk_target = Inspect.cloneToken(token, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
        }
        token = this.tm.getToken();
        if (token.getToknum() != 312) {
            throw new ExpectedFoundException(token, this.error, "'BY'");
        }
        token = this.tm.getToken();
        switch (token.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                this.vn_replace = VariableName.get(this.tm, this.error, this.pc);
                if (this.vn_replace.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, token, token.getWord(), this.error);
                }
                if (this.vn_replace.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
                }
                this.setHasNational(this.vn_replace);
                break;
            }
            case 10001: {
                this.tk_replace = token;
                if (this.tk_replace.getRealLength() <= 1) break;
                throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
            }
            default: {
                if (token.isFigurativeZero()) {
                    this.tk_replace = Inspect.cloneToken(token, 10001, "'0'");
                    this.isTkReplFigZero = true;
                    break;
                }
                throw new UnexpectedTokenException(token, this.error);
            }
        }
        this.globDelimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
    }

    void inspectConverting(Token token) throws GeneralErrorException, EndOfProgramException {
        this.converting = true;
        if (token.getToknum() == 10009) {
            this.tm.ungetToken();
            this.vn_comp_chars = VariableName.get(this.tm, this.error, this.pc);
            if (!Inspect.isUsageDisplay(this.vn_comp_chars)) {
                throw new GeneralErrorException(68, 4, token, token.getWord(), this.error);
            }
            this.setHasNational(this.vn_comp_chars);
        } else if (token.getToknum() == 10001) {
            this.tk_comp_chars = token;
        } else if (token.isFigurativeZero()) {
            this.tk_comp_chars = Inspect.cloneToken(token, 10001, "'0'");
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() != 773) {
            throw new ExpectedFoundException(token, this.error, "'TO'");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 10009) {
            this.tm.ungetToken();
            this.vn_conv_chars = VariableName.get(this.tm, this.error, this.pc);
            if (!Inspect.isUsageDisplay(this.vn_conv_chars)) {
                throw new GeneralErrorException(68, 4, token, token.getWord(), this.error);
            }
            this.setHasNational(this.vn_conv_chars);
        } else if (token.getToknum() == 10001) {
            this.tk_conv_chars = token;
        } else if (token.isFigurativeZero()) {
            this.tk_conv_chars = Inspect.cloneToken(token, 10001, "'0'");
            this.isTkConvCharsFigZero = true;
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        if (this.tk_comp_chars != null) {
            if (this.tk_conv_chars != null) {
                if (!(this.isTkConvCharsFigZero || this.tk_conv_chars.isFigurative() || this.tk_conv_chars.isAll() || this.tk_comp_chars.getRealLength() == this.tk_conv_chars.getRealLength())) {
                    throw new GeneralErrorException(70, 4, this.tk_conv_chars, this.tk_conv_chars.getWord(), this.error);
                }
            } else {
                int n2 = this.vn_conv_chars.getVariableLength();
                if (n2 != -1 && this.tk_comp_chars.getRealLength() != n2) {
                    throw new GeneralErrorException(70, 4, this.vn_conv_chars.getNameToken(), this.vn_conv_chars.getName(), this.error);
                }
            }
        } else if (this.tk_conv_chars != null) {
            int n3;
            if (!(this.isTkConvCharsFigZero || this.tk_conv_chars.isFigurative() || this.tk_conv_chars.isAll() || (n3 = this.vn_comp_chars.getVariableLength()) == -1 || n3 == this.tk_conv_chars.getRealLength())) {
                throw new GeneralErrorException(70, 4, this.tk_conv_chars, this.tk_conv_chars.getWord(), this.error);
            }
        } else {
            int n4;
            int n5 = this.vn_comp_chars.getVariableLength();
            if (n5 != -1 && (n4 = this.vn_conv_chars.getVariableLength()) != -1 && n5 != n4) {
                throw new GeneralErrorException(70, 4, this.vn_conv_chars.getNameToken(), this.vn_conv_chars.getName(), this.error);
            }
        }
        this.globDelimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getHeader(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.source.getCode());
        stringBuffer.append(".inspect");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        if (bl) {
            stringBuffer.append("Trailing");
        }
        stringBuffer.append("(");
        return stringBuffer.toString();
    }

    private boolean isOptimizable() {
        if (this.hasNational || this.pc.getOption("-b") == null) {
            return false;
        }
        if (this.globTrailing) {
            return false;
        }
        if (this.tallying) {
            InspectTallyingCounterPhrase inspectTallyingCounterPhrase;
            if (!this.replacing && this.tallyingCounterPhrases.getItemNum() == 1 && !(inspectTallyingCounterPhrase = (InspectTallyingCounterPhrase)this.tallyingCounterPhrases.getFirst()).isTrailing() && inspectTallyingCounterPhrase.tallyingPhrases.getItemNum() == 1) {
                InspectTallyingPhrase inspectTallyingPhrase = (InspectTallyingPhrase)inspectTallyingCounterPhrase.tallyingPhrases.getFirst();
                if (inspectTallyingPhrase.delimPhrase == null || inspectTallyingPhrase.delimPhrase.isEmpty()) {
                    return true;
                }
            }
        } else if (this.replacing) {
            if (!this.tallying && this.replacingPhrases.getItemNum() == 1) {
                InspectReplacingPhrase inspectReplacingPhrase = (InspectReplacingPhrase)this.replacingPhrases.getFirst();
                if (inspectReplacingPhrase.delimPhrase == null || inspectReplacingPhrase.delimPhrase.isEmpty()) {
                    return true;
                }
            }
        } else if (this.converting && (this.globDelimPhrase == null || this.globDelimPhrase.isEmpty())) {
            return true;
        }
        return false;
    }

    private void getCodeOptimized(StringBuffer stringBuffer) {
        stringBuffer.append(this.source.getCode());
        stringBuffer.append(".inspect");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        stringBuffer.append("Opt(");
        if (this.tallying) {
            InspectTallyingCounterPhrase inspectTallyingCounterPhrase = (InspectTallyingCounterPhrase)this.tallyingCounterPhrases.getFirst();
            InspectTallyingPhrase inspectTallyingPhrase = (InspectTallyingPhrase)inspectTallyingCounterPhrase.tallyingPhrases.getFirst();
            stringBuffer.append(inspectTallyingCounterPhrase.counter.getCode());
            stringBuffer.append(", ");
            stringBuffer.append(inspectTallyingPhrase.getCodeType());
            stringBuffer.append(", ");
            stringBuffer.append(inspectTallyingPhrase.getCodeCV());
            stringBuffer.append(");");
        } else if (this.replacing) {
            InspectReplacingPhrase inspectReplacingPhrase = (InspectReplacingPhrase)this.replacingPhrases.getFirst();
            stringBuffer.append(inspectReplacingPhrase.getCodeType());
            stringBuffer.append(", ");
            stringBuffer.append(inspectReplacingPhrase.getCodeTarg());
            stringBuffer.append(", ");
            stringBuffer.append(inspectReplacingPhrase.getCodeRepl());
            stringBuffer.append(");");
        } else {
            if (this.tk_comp_chars != null) {
                stringBuffer.append(this.getCodeLiteral(this.tk_comp_chars));
            } else {
                stringBuffer.append(this.vn_comp_chars.getCode());
            }
            stringBuffer.append(", ");
            if (this.tk_conv_chars != null) {
                stringBuffer.append(this.getCodeLiteral(this.tk_conv_chars));
            } else {
                stringBuffer.append(this.vn_conv_chars.getCode());
            }
            stringBuffer.append(");");
        }
        stringBuffer.append(eol);
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.isOptimizable()) {
            this.getCodeOptimized(stringBuffer);
            this.getCodeDebugEnd(stringBuffer);
            return stringBuffer.toString();
        }
        if (this.tallying) {
            Object object;
            boolean bl = false;
            Object object2 = this.tallyingCounterPhrases.elements();
            while (object2.hasMoreElements()) {
                object = (InspectTallyingCounterPhrase)object2.nextElement();
                if (!((InspectTallyingCounterPhrase)object).isTrailing()) continue;
                bl = true;
                break;
            }
            if (bl || this.pc.getOption("-ca") != null) {
                object2 = this.tallyingCounterPhrases.elements();
                while (object2.hasMoreElements()) {
                    object = (InspectTallyingCounterPhrase)object2.nextElement();
                    stringBuffer.append(this.getHeader(((InspectTallyingCounterPhrase)object).isTrailing()));
                    if (((InspectTallyingCounterPhrase)object).isTrailing()) {
                        stringBuffer.append(((InspectTallyingCounterPhrase)object).getCodeTallyingTrailing());
                    } else {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        StringBuffer stringBuffer4 = new StringBuffer();
                        StringBuffer stringBuffer5 = new StringBuffer();
                        StringBuffer stringBuffer6 = new StringBuffer();
                        StringBuffer stringBuffer7 = new StringBuffer();
                        stringBuffer2.append("new NumericVar[] {");
                        stringBuffer3.append("new int[] {");
                        stringBuffer4.append("new CobolVar[] {");
                        stringBuffer5.append("new CobolVar[] {");
                        stringBuffer6.append("new CobolVar[] {");
                        stringBuffer7.append("new boolean[] {");
                        ((InspectTallyingCounterPhrase)object).getCode(stringBuffer2, stringBuffer3, stringBuffer4, stringBuffer5, stringBuffer6, stringBuffer7);
                        stringBuffer2.append(" }");
                        stringBuffer3.append(" }");
                        stringBuffer4.append(" }");
                        stringBuffer5.append(" }");
                        stringBuffer6.append(" }");
                        stringBuffer7.append("}");
                        stringBuffer.append(stringBuffer2.toString());
                        stringBuffer.append(", ");
                        stringBuffer.append(stringBuffer3.toString());
                        stringBuffer.append(", ");
                        stringBuffer.append(stringBuffer4.toString());
                        stringBuffer.append(", ");
                        stringBuffer.append(stringBuffer5.toString());
                        stringBuffer.append(", ");
                        stringBuffer.append(stringBuffer6.toString());
                        stringBuffer.append(", ");
                        stringBuffer.append(stringBuffer7.toString());
                    }
                    if (!object2.hasMoreElements()) continue;
                    stringBuffer.append(");");
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                }
            } else {
                object2 = new StringBuffer();
                object = new StringBuffer();
                StringBuffer stringBuffer8 = new StringBuffer();
                StringBuffer stringBuffer9 = new StringBuffer();
                StringBuffer stringBuffer10 = new StringBuffer();
                StringBuffer stringBuffer11 = new StringBuffer();
                ((StringBuffer)object2).append("new NumericVar[] {");
                ((StringBuffer)object).append("new int[] {");
                stringBuffer8.append("new CobolVar[] {");
                stringBuffer9.append("new CobolVar[] {");
                stringBuffer10.append("new CobolVar[] {");
                stringBuffer11.append("new boolean[] {");
                Enumeration enumeration = this.tallyingCounterPhrases.elements();
                while (enumeration.hasMoreElements()) {
                    InspectTallyingCounterPhrase inspectTallyingCounterPhrase = (InspectTallyingCounterPhrase)enumeration.nextElement();
                    inspectTallyingCounterPhrase.getCode((StringBuffer)object2, (StringBuffer)object, stringBuffer8, stringBuffer9, stringBuffer10, stringBuffer11);
                    if (!enumeration.hasMoreElements()) continue;
                    ((StringBuffer)object2).append(",");
                    ((StringBuffer)object).append(",");
                    stringBuffer8.append(",");
                    stringBuffer9.append(",");
                    stringBuffer10.append(",");
                    stringBuffer11.append(",");
                }
                ((StringBuffer)object2).append(" }");
                ((StringBuffer)object).append(" }");
                stringBuffer8.append(" }");
                stringBuffer9.append(" }");
                stringBuffer10.append(" }");
                stringBuffer11.append("}");
                stringBuffer.append(this.getHeader(false));
                stringBuffer.append(((StringBuffer)object2).toString());
                stringBuffer.append(", ");
                stringBuffer.append(((StringBuffer)object).toString());
                stringBuffer.append(", ");
                stringBuffer.append(stringBuffer8.toString());
                stringBuffer.append(", ");
                stringBuffer.append(stringBuffer9.toString());
                stringBuffer.append(", ");
                stringBuffer.append(stringBuffer10.toString());
                stringBuffer.append(", ");
                stringBuffer.append(stringBuffer11.toString());
            }
        } else if (this.replacing) {
            stringBuffer.append(this.getHeader(this.globTrailing));
            if (this.globTrailing) {
                stringBuffer.append(this.getCodeReplacingTrailing());
            } else {
                stringBuffer.append(this.getCodeReplacing());
            }
        } else if (this.converting) {
            stringBuffer.append(this.getHeader(false));
            stringBuffer.append(this.getCodeConverting());
        }
        stringBuffer.append(");");
        if (this.tallying && this.replacing) {
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.getHeader(this.globTrailing));
            if (this.globTrailing) {
                stringBuffer.append(this.getCodeReplacingTrailing());
            } else {
                stringBuffer.append(this.getCodeReplacing());
            }
            stringBuffer.append(");");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private String getCodeReplacing() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        stringBuffer2.append("new int[] {");
        stringBuffer3.append("new CobolVar[] {");
        stringBuffer4.append("new CobolVar[] {");
        stringBuffer5.append("new CobolVar[] {");
        stringBuffer6.append("new CobolVar[] {");
        stringBuffer7.append("new boolean[] {");
        Enumeration enumeration = this.replacingPhrases.elements();
        while (enumeration.hasMoreElements()) {
            InspectReplacingPhrase inspectReplacingPhrase = (InspectReplacingPhrase)enumeration.nextElement();
            stringBuffer2.append(inspectReplacingPhrase.getCodeType());
            stringBuffer3.append(inspectReplacingPhrase.getCodeTarg());
            stringBuffer4.append(inspectReplacingPhrase.getCodeRepl());
            stringBuffer5.append(inspectReplacingPhrase.delimPhrase.getCodeBef());
            stringBuffer6.append(inspectReplacingPhrase.delimPhrase.getCodeAft());
            stringBuffer7.append(inspectReplacingPhrase.delimPhrase.isTrailing);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer2.append(",");
            stringBuffer3.append(",");
            stringBuffer4.append(",");
            stringBuffer5.append(",");
            stringBuffer6.append(",");
            stringBuffer7.append(",");
        }
        stringBuffer2.append(" }");
        stringBuffer3.append(" }");
        stringBuffer4.append(" }");
        stringBuffer5.append(" }");
        stringBuffer6.append(" }");
        stringBuffer7.append("}");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(", ");
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(", ");
        stringBuffer.append(stringBuffer4.toString());
        stringBuffer.append(", ");
        stringBuffer.append(stringBuffer5.toString());
        stringBuffer.append(", ");
        stringBuffer.append(stringBuffer6.toString());
        stringBuffer.append(", ");
        stringBuffer.append(stringBuffer7.toString());
        return stringBuffer.toString();
    }

    private String getCodeReplacingTrailing() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tk_target != null) {
            stringBuffer.append(this.getCodeLiteral(this.tk_target));
        } else {
            stringBuffer.append(this.vn_target.getCode());
        }
        stringBuffer.append(", ");
        if (this.tk_replace != null) {
            stringBuffer.append(this.getCodeLiteral(this.tk_replace));
        } else {
            stringBuffer.append(this.vn_replace.getCode());
        }
        this.globDelimPhrase.getDelimPhraseCode(stringBuffer);
        return stringBuffer.toString();
    }

    private String getCodeConverting() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tk_comp_chars != null) {
            stringBuffer.append(this.getCodeLiteral(this.tk_comp_chars));
        } else {
            stringBuffer.append(this.vn_comp_chars.getCode());
        }
        stringBuffer.append(", ");
        if (this.tk_conv_chars != null) {
            stringBuffer.append(this.getCodeLiteral(this.tk_conv_chars));
        } else {
            stringBuffer.append(this.vn_conv_chars.getCode());
        }
        this.globDelimPhrase.getDelimPhraseCode(stringBuffer);
        return stringBuffer.toString();
    }

    private void setHasNational(VariableName variableName) {
        if (!this.hasNational) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            this.hasNational = variableDeclaration != null && (variableDeclaration.isNational() || variableDeclaration.isPicG());
        }
    }

    private static boolean isUsageDisplay(VariableName variableName) {
        return variableName.hasSubValue() || variableName.getVarDecl().isUsageDisplay() || variableName.getVarDecl().hasRealChildren();
    }

    public class InspectDelimPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        boolean after;
        boolean before;
        boolean isTrailing;
        private final List aft_delims;
        private final List bef_delims;

        public InspectDelimPhrase(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, Token token2) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.allowAllLitGen = false;
            this.aft_delims = new ArrayList();
            this.bef_delims = new ArrayList();
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean bl = false;
                if (token2.getToknum() != 299 && token2.getToknum() != 261) break;
                if (token2.getToknum() == 261) {
                    if (this.after) {
                        throw new SyntaxErrorException(token2, "Duplicate AFTER phrase", this.error);
                    }
                    this.after = true;
                } else {
                    if (this.before) {
                        throw new SyntaxErrorException(token2, "Duplicate BEFORE phrase", this.error);
                    }
                    this.before = true;
                    bl = true;
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() == 531) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() == 776) {
                    if (this.after) {
                        throw new SyntaxErrorException(token2, token2.getWord(), this.error);
                    }
                    token2 = this.tm.getToken();
                    this.isTrailing = true;
                }
                token2 = bl ? this.getDelimiter(this.tm, this.bef_delims) : this.getDelimiter(this.tm, this.aft_delims);
            }
            this.tm.ungetToken();
        }

        void getDelimPhraseCode(StringBuffer stringBuffer) {
            stringBuffer.append(", ");
            stringBuffer.append(this.getCodeBef());
            stringBuffer.append(", ");
            stringBuffer.append(this.getCodeAft());
            stringBuffer.append(", ");
            stringBuffer.append(this.isTrailing);
        }

        private Token getDelimiter(TokenManager tokenManager, List list) throws EndOfProgramException, GeneralErrorException {
            tokenManager.ungetToken();
            Token token = tokenManager.getToken();
            if (token.getToknum() == 10009) {
                tokenManager.ungetToken();
                VariableName variableName = VariableName.get(tokenManager, this.error, this.pc);
                if (!Inspect.isUsageDisplay(variableName)) {
                    throw new GeneralErrorException(68, 4, token, token.getWord(), this.error);
                }
                Inspect.this.setHasNational(variableName);
                list.add(variableName);
            } else if (token.getToknum() == 10001) {
                list.add(token);
            } else if (token.isFigurativeZero()) {
                token = Inspect.cloneToken(token, 10001, "'0'");
                list.add(token);
            } else {
                throw new UnexpectedTokenException(token, this.error);
            }
            token = tokenManager.getToken();
            if (token.getToknum() == 617) {
                throw new GeneralErrorException(19, 4, token, "", this.error);
            }
            return token;
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeBef() {
            if (!this.before) {
                return "null";
            }
            Object e2 = this.bef_delims.get(0);
            if (e2 instanceof VariableName) {
                return ((VariableName)e2).getCode();
            }
            return this.getCodeLiteral((Token)e2);
        }

        public String getCodeAft() {
            if (!this.after) {
                return "null";
            }
            Object e2 = this.aft_delims.get(0);
            if (e2 instanceof VariableName) {
                return ((VariableName)e2).getCode();
            }
            return this.getCodeLiteral((Token)e2);
        }

        @Override
        public String getCode() {
            return "";
        }

        public boolean isEmpty() {
            return this.bef_delims.isEmpty() && this.aft_delims.isEmpty();
        }
    }

    public class InspectReplacingPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        int type;
        Token tk_repl;
        VariableName vn_repl;
        Token tk_targ;
        VariableName vn_targ;
        InspectDelimPhrase delimPhrase;

        public InspectReplacingPhrase(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, Token token2, int n2) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.tk_repl = null;
            this.vn_repl = null;
            this.tk_targ = null;
            this.vn_targ = null;
            this.allowAllLitGen = false;
            switch (n2) {
                case 262: {
                    this.type = 1;
                    break;
                }
                case 556: {
                    this.type = 2;
                    break;
                }
                case 489: {
                    this.type = 3;
                    break;
                }
                case 324: {
                    this.type = 4;
                }
            }
            if (this.type != 4) {
                if (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_targ = VariableName.get(this.tm, this.error, this.pc);
                    if (!Inspect.isUsageDisplay(this.vn_targ)) {
                        throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.vn_targ);
                } else if (token2.getToknum() == 10001) {
                    this.tk_targ = token2;
                } else if (token2.isFigurativeZero()) {
                    this.tk_targ = Inspect.cloneToken(token2, 10001, "'0'");
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 312) {
                throw new ExpectedFoundException(token2, this.error, "'BY'");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.vn_repl = VariableName.get(this.tm, this.error, this.pc);
                if (!Inspect.isUsageDisplay(this.vn_repl)) {
                    throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                }
                if (this.type == 4 && this.vn_repl.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, token2, token2.getWord(), this.error);
                }
                Inspect.this.setHasNational(this.vn_repl);
            } else if (token2.getToknum() == 10001) {
                if (this.type == 4 && token2.getRealLength() > 1) {
                    throw new GeneralErrorException(69, 4, token2, token2.getWord(), this.error);
                }
                this.tk_repl = token2;
            } else if (token2.isFigurativeZero()) {
                this.tk_repl = Inspect.cloneToken(token2, 10001, "'0'");
                Inspect.this.isTkReplFigZero = true;
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            if (this.type != 4) {
                if (this.tk_targ != null) {
                    if (this.tk_repl != null) {
                        if (!Inspect.this.isTkReplFigZero && !this.tk_repl.isFigurative() && this.tk_targ.getRealLength() != this.tk_repl.getRealLength()) {
                            throw new GeneralErrorException(70, 4, this.tk_repl, this.tk_repl.getWord(), this.error);
                        }
                    } else {
                        int n3 = this.vn_repl.getVariableLength();
                        if (n3 != -1 && this.tk_targ.getRealLength() != n3) {
                            throw new GeneralErrorException(70, 4, this.vn_repl.getNameToken(), this.vn_repl.getName(), this.error);
                        }
                    }
                } else if (this.tk_repl != null) {
                    int n4;
                    if (!Inspect.this.isTkReplFigZero && !this.tk_repl.isFigurative() && (n4 = this.vn_targ.getVariableLength()) != -1 && n4 != this.tk_repl.getRealLength()) {
                        throw new GeneralErrorException(70, 4, this.tk_repl, this.tk_repl.getWord(), this.error);
                    }
                } else {
                    int n5;
                    int n6 = this.vn_targ.getVariableLength();
                    if (n6 != -1 && (n5 = this.vn_repl.getVariableLength()) != -1 && n6 != n5) {
                        throw new GeneralErrorException(70, 4, this.vn_repl.getNameToken(), this.vn_repl.getName(), this.error);
                    }
                }
            }
            this.delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeType() {
            return Integer.toString(this.type);
        }

        public String getCodeTarg() {
            if (this.type == 4) {
                return "null";
            }
            if (this.tk_targ != null) {
                return this.getCodeLiteral(this.tk_targ);
            }
            return this.vn_targ.getCode();
        }

        public String getCodeRepl() {
            if (this.tk_repl != null) {
                return this.getCodeLiteral(this.tk_repl);
            }
            return this.vn_repl.getCode();
        }

        @Override
        public String getCode() {
            return "";
        }
    }

    public class InspectTallyingPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        int type;
        Token tk_comp_val;
        VariableName vn_comp_val;
        InspectDelimPhrase delimPhrase;

        public InspectTallyingPhrase(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, Token token2, int n2) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.tk_comp_val = null;
            this.vn_comp_val = null;
            this.allowAllLitGen = false;
            switch (token2.getToknum()) {
                case 10002: {
                    if (token2.isFigurativeZero()) {
                        token2 = Inspect.cloneToken(token2, 10001, "'0'");
                    }
                }
                case 10001: 
                case 10009: {
                    if (token2.isAll()) {
                        this.type = 1;
                        token2.setAll(false);
                    } else if (n2 != -1 && n2 != 4) {
                        this.type = n2;
                    } else {
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                    this.tm.ungetToken();
                    break;
                }
                case 556: {
                    this.type = 2;
                    break;
                }
                case 324: {
                    this.type = 4;
                }
            }
            if (this.type != 4) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_comp_val = VariableName.get(this.tm, this.error, this.pc);
                    if (!Inspect.isUsageDisplay(this.vn_comp_val)) {
                        throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.vn_comp_val);
                } else if (token2.getToknum() == 10001) {
                    this.tk_comp_val = token2;
                } else if (token2.isFigurativeZero()) {
                    this.tk_comp_val = Inspect.cloneToken(token2, 10001, "'0'");
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
            }
            this.delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeType() {
            return Integer.toString(this.type);
        }

        public String getCodeCV() {
            if (this.type == 4) {
                return "null";
            }
            if (this.tk_comp_val != null) {
                return this.getCodeLiteral(this.tk_comp_val);
            }
            return this.vn_comp_val.getCode();
        }

        @Override
        public String getCode() {
            return "";
        }
    }

    public class InspectTallyingCounterPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VerbList tallyingPhrases;
        VariableName counter;
        Token trail_tk_comp_value;
        VariableName trail_vn_comp_value;
        InspectDelimPhrase trail_delimPhrase;

        public InspectTallyingCounterPhrase(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, Token token2) throws GeneralErrorException, EndOfProgramException {
            super(token, block, pcc, tokenManager, errors);
            this.tallyingPhrases = new VerbList();
            this.allowAllLitGen = false;
            this.counter = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(Inspect.this, 1));
            if (!this.counter.getVarDecl().isNumeric() || this.counter.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() != 494) {
                throw new ExpectedFoundException(token2, this.error, "'FOR'");
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 776) {
                if (Inspect.this.tallyingCounterPhrases.getItemNum() > 0) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                this.inspectTallyingTrailing(this.tm.getToken());
                return;
            }
            int n2 = -1;
            int n3 = 0;
            block7: while (true) {
                switch (token2.getToknum()) {
                    case 10002: {
                        if (token2.isFigurativeZero()) {
                            token2 = Inspect.cloneToken(token2, 10001, "'0'");
                        }
                        if (!token2.isAll()) break;
                        n2 = 1;
                        break;
                    }
                    case 10009: {
                        if (token2.isAll()) {
                            n2 = 1;
                            break;
                        }
                        TokenManager.Marker marker = this.tm.getMarker();
                        this.tm.setMarker(marker);
                        this.tm.ungetToken();
                        VariableName.get(this.tm, this.error, this.pc);
                        boolean bl = this.tm.getToken().getToknum() == 494;
                        this.tm.rewindToMarker(marker);
                        if (!bl) break;
                        this.tm.ungetToken();
                        return;
                    }
                    case 10001: {
                        if (!token2.isAll()) break;
                        n2 = 1;
                        break;
                    }
                    case 556: {
                        n2 = 2;
                        break;
                    }
                    case 324: {
                        n2 = 4;
                        break;
                    }
                    default: {
                        if (n3 != 0) break block7;
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                }
                this.tallyingPhrases.addItem(new InspectTallyingPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, token2, n2));
                token2 = this.tm.getToken();
                ++n3;
            }
            this.tm.ungetToken();
        }

        String getCodeTallyingTrailing() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.counter.getCode());
            stringBuffer.append(", ");
            if (this.trail_tk_comp_value != null) {
                stringBuffer.append(this.getCodeLiteral(this.trail_tk_comp_value));
            } else {
                stringBuffer.append(this.trail_vn_comp_value.getCode());
            }
            this.trail_delimPhrase.getDelimPhraseCode(stringBuffer);
            return stringBuffer.toString();
        }

        boolean isTrailing() {
            return this.trail_tk_comp_value != null || this.trail_vn_comp_value != null;
        }

        void inspectTallyingTrailing(Token token) throws GeneralErrorException, EndOfProgramException {
            switch (token.getToknum()) {
                case 10009: {
                    this.tm.ungetToken();
                    this.trail_vn_comp_value = VariableName.get(this.tm, this.error, this.pc);
                    if (this.trail_vn_comp_value.getVarDecl().isNumeric()) {
                        throw new GeneralErrorException(66, 4, token, token.getWord(), this.error);
                    }
                    if (this.trail_vn_comp_value.getVariableLength() > 1) {
                        throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.trail_vn_comp_value);
                    break;
                }
                case 10001: {
                    if (token.getRealLength() > 1) {
                        throw new GeneralErrorException(69, 4, token, token.getWord(), this.error);
                    }
                    this.trail_tk_comp_value = token;
                    break;
                }
                default: {
                    if (token.isFigurativeZero()) {
                        this.trail_tk_comp_value = Inspect.cloneToken(token, 10001, "'0'");
                        break;
                    }
                    throw new UnexpectedTokenException(token, this.error);
                }
            }
            this.trail_delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        public void getCode(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4, StringBuffer stringBuffer5, StringBuffer stringBuffer6) {
            Enumeration enumeration = this.tallyingPhrases.elements();
            while (enumeration.hasMoreElements()) {
                InspectTallyingPhrase inspectTallyingPhrase = (InspectTallyingPhrase)enumeration.nextElement();
                stringBuffer.append(this.counter.getCode());
                stringBuffer2.append(inspectTallyingPhrase.getCodeType());
                stringBuffer3.append(inspectTallyingPhrase.getCodeCV());
                stringBuffer4.append(inspectTallyingPhrase.delimPhrase.getCodeBef());
                stringBuffer5.append(inspectTallyingPhrase.delimPhrase.getCodeAft());
                stringBuffer6.append(inspectTallyingPhrase.delimPhrase.isTrailing);
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(",");
                stringBuffer2.append(",");
                stringBuffer3.append(",");
                stringBuffer4.append(",");
                stringBuffer5.append(",");
                stringBuffer6.append(",");
            }
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        @Override
        public String getCode() {
            return null;
        }
    }
}

