/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.As;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.lang.reflect.Modifier;

public class Invoke
extends Verb
implements CobolToken,
ErrorsNumbers,
GenericObject {
    public static final String prefix = "invoke$";
    public static final String _self = "this";
    public static final String _super = "super";
    private GenericObject nameObj;
    boolean lambdaExpr;
    private Invoke next;
    private String className;
    private int dimension;
    private Token methodToken;
    private VariableName methodVar;
    private VerbList usings = new VerbList();
    private VariableName returning;
    private As returningAs;
    private MyClass[] exceptions;
    private BlockException onException;
    private Block notOnException;
    private MyClass retType;
    private boolean not;
    private boolean isField;
    private boolean isInline;
    private boolean isStatic;
    private boolean isCall;
    private boolean universal;
    private boolean printEOL = true;
    private static final MyField CLASS_FIELD = new MyField("class", MyClass.getInstance(Class.class), 25);

    public Invoke(GenericObject genericObject, Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.nameObj = genericObject;
        boolean bl = this.lambdaExpr = this.nameObj instanceof VariableName && ((VariableName)this.nameObj).isLambdaExpression();
        if (this.nameObj.isFactory()) {
            this.className = this.nameObj.getCType().getName();
            this.isStatic = true;
        }
        this.parseMethodName();
        this.parseInlineArgs();
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10018) {
            if (this.lambdaExpr) {
                throw new GeneralErrorException(274, 4, this.getKeyWord(), token2.getWord(), this.error);
            }
            this.next = new Invoke(token2, token2, this.parent, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        this.isInline = true;
        this.endStmt = true;
    }

    public Invoke(Token token, Token token2, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token2, block, pcc, tokenManager, errors);
        if (token.getToknum() == 10001) {
            this.className = token.getCode();
            this.isStatic = true;
        } else if ("SELF".equals(token.getWord())) {
            this.className = _self;
        } else if ("SUPER".equals(token.getWord())) {
            this.className = _super;
        } else if (token.getToknum() == 10018) {
            this.className = "";
        } else {
            throw new UnexpectedTokenException(token, this.error);
        }
        this.parseMethodName();
        this.parseInlineArgs();
        token = this.tm.getToken();
        if (token.getToknum() == 10018) {
            this.next = new Invoke(token, token, this.parent, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        this.isInline = true;
        this.endStmt = true;
    }

    public Invoke(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        boolean bl = false;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            if ("SELF".equals(token2.getWord())) {
                if (this.tm.getToken().getToknum() == 10018) {
                    this.nameObj = new Invoke(token2, token2, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    this.className = _self;
                }
            } else if ("SUPER".equals(token2.getWord())) {
                if (this.tm.getToken().getToknum() == 10018) {
                    this.nameObj = new Invoke(token2, token2, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    this.className = _super;
                }
            } else {
                this.tm.ungetToken();
                this.nameObj = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
                bl = this.nameObj instanceof VariableName && ((VariableName)this.nameObj).getVarDecl() instanceof InlineInvoke;
                token2 = this.tm.getToken();
                if (token2.getToknum() == 10018) {
                    this.nameObj = new Invoke((VariableName)this.nameObj, token2, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    if (this.nameObj.isFactory()) {
                        this.className = this.nameObj.getCType().getName();
                        this.isStatic = true;
                    }
                }
            }
        } else if (token2.getToknum() == 10001) {
            if (this.tm.getToken().getToknum() == 10018) {
                this.nameObj = new Invoke(token2, token2, this.parent, this.pc, this.tm, this.error);
            } else {
                this.tm.ungetToken();
                this.className = token2.getCode();
                this.isStatic = true;
            }
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
        if (!bl) {
            this.parseMethodName();
        }
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        token2 = this.tm.getToken();
        if (token2.getToknum() == 802) {
            while ((token2 = this.tm.getToken()).getToknum() == 312 || token2.getToknum() == 371 || token2.getToknum() == 803 || token2.getToknum() == 676 || token2.getToknum() == 10009 || token2.getToknum() == 10001 || token2.getToknum() == 10002 || token2.getToknum() == 780 || token2.getToknum() == 480 || token2.getToknum() == 612 || token2.getToknum() == 10017) {
                this.tm.ungetToken();
                this.usings.addItem(new Using(token, block, pcc, tokenManager, errors, blArray, blArray2, true));
            }
        }
        if (token2.getToknum() == 694 || token2.getToknum() == 505) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            token2 = this.tm.getToken();
            if (token2.getToknum() == 280) {
                this.returningAs = new As(token, block, pcc, tokenManager, errors, this.returning);
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 598 || token2.getToknum() == 613 || token2.getToknum() == 472 || token2.getToknum() == 624) {
            Token token3;
            boolean bl2 = false;
            if (token2.getToknum() == 598) {
                this.not = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 613) {
                bl2 = true;
                token2 = this.tm.getToken();
            }
            if ((token3 = token2).getToknum() == 472 || token3.getToknum() == 624) {
                if (this.not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(Exception.class));
                }
                token2 = this.tm.getToken();
                if (!this.not && token2.getToknum() == 598) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 613) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != token3.getToknum()) {
                        throw new ExpectedFoundException(token2, this.error, "'" + token3.getWord() + "'");
                    }
                    this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (bl2) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 434) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void parseMethodName() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 10001) {
            this.methodToken = token;
        } else if (token.getToknum() == 10009) {
            this.tm.ungetToken();
            this.methodVar = VariableName.getAny(this.tm, this.error, this.parent, this.pc, GetVarOpts.NO_OPTS);
            if (this.methodVar == null) {
                throw new GeneralErrorException(130, 4, this.keyWord, "", this.error);
            }
        } else {
            throw new GeneralErrorException(130, 4, this.keyWord, "", this.error);
        }
    }

    private void parseInlineArgs() throws GeneralErrorException, EndOfProgramException {
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        if (this.tm.getToken().getToknum() == 40) {
            Token token;
            while ((token = this.tm.getToken()).getToknum() != 41) {
                if (this.lambdaExpr) {
                    throw new GeneralErrorException(274, 4, this.getKeyWord(), token.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.usings.addItem(new Using(this.keyWord, this.parent, this.pc, this.tm, this.error, blArray, blArray2, true));
            }
        } else {
            this.tm.ungetToken();
        }
    }

    private void adjustArgs(MyClass[] myClassArray) throws GeneralErrorException {
        Using using = (Using)this.usings.getFirst();
        for (int i2 = 0; using != null && i2 < myClassArray.length; ++i2) {
            try {
                if (using.isCobolVarClass()) {
                    Token token;
                    if (myClassArray[i2].isPrimitive() || myClassArray[i2].isClass(String.class)) {
                        using.setAs(myClassArray[i2]);
                    } else if (using.getAs() == null && (token = using.getNameToken()) != null && token.getToknum() == 10001 && !token.isHexdecimal() && !token.isNational() && !token.isResource() && myClassArray[i2].isClass(Object.class)) {
                        using.setAs(MyClass.getInstance(String.class));
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            using = (Using)this.usings.getNext();
        }
    }

    private int checkCallArgs(MyClass[] myClassArray) throws GeneralErrorException {
        int n2 = -1;
        if (this.usings.getItemNum() != 1) {
            return n2;
        }
        if (myClassArray.length == 1 && myClassArray[0].isAssignableFrom(Object[].class)) {
            n2 += 5;
        }
        return n2;
    }

    private int _checkArgs(MyClass[] myClassArray) throws GeneralErrorException {
        int n2;
        int n3 = -1;
        if (this.usings.getItemNum() != myClassArray.length) {
            return n3;
        }
        n3 = 0;
        Using using = (Using)this.usings.getFirst();
        for (n2 = 0; n2 < myClassArray.length; ++n2) {
            block19: {
                try {
                    if (using.isAssignableTo(myClassArray[n2])) {
                        if (using.isCobolVar() && !myClassArray[n2].isCobolVar()) {
                            n3 = using.isNumericVar() ? (myClassArray[n2].isString() ? (n3 += 400) : (using.getType().equals(myClassArray[n2]) ? (n3 += 1000) : (n3 += 800))) : (myClassArray[n2].isString() ? (n3 += 800) : (n3 += 400));
                        } else if (using.isPlainLiteral()) {
                            n3 = using.isPlainStrLiteral() ? (myClassArray[n2].isString() ? (n3 += 800) : (n3 += 400)) : (myClassArray[n2].isString() ? (n3 += 400) : (n3 += 800));
                        } else if (using.getType() == null) {
                            n3 += 900;
                        } else {
                            n3 += 1000;
                            if (!using.getType().equals(myClassArray[n2])) {
                                n3 -= 10;
                                if (using.getType().isStrictPrimitive()) {
                                    if (myClassArray[n2].isPrimitiveWrapper() && !using.getType().equals(myClassArray[n2].getWrappedType())) {
                                        n3 -= 10;
                                    }
                                } else if (myClassArray[n2].isStrictPrimitive()) {
                                    if (using.getType().isPrimitiveWrapper() && !using.getType().getWrappedType().equals(myClassArray[n2])) {
                                        n3 -= 10;
                                    }
                                } else {
                                    for (MyClass myClass = using.getType().getSuperclass(); myClass != null && !myClass.equals(myClassArray[n2]); myClass = myClass.getSuperclass()) {
                                        n3 -= 10;
                                    }
                                }
                            }
                        }
                        break block19;
                    }
                    if (!using.isAssignableTo(MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar")) || !myClassArray[n2].isPrimitive() && !myClassArray[n2].isClass(String.class)) break;
                    n3 += 100;
                    throw new InternalErrorException("Unexpected behaviour Invoke.java line ~307");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MissingClassException(classNotFoundException, this.keyWord, this.error);
                }
            }
            using = (Using)this.usings.getNext();
        }
        return n2 == myClassArray.length ? n3 : -1;
    }

    private int checkArgs(MyClass[][] myClassArray, boolean bl) throws GeneralErrorException {
        MyClass[] myClassArray2 = myClassArray[0];
        int n2 = this._checkArgs(myClassArray2);
        if (n2 == -1 && bl) {
            MyClass myClass = myClassArray2[myClassArray2.length - 1];
            int n3 = this.usings.getItemNum();
            if (n3 >= myClassArray2.length - 1 && myClass.isArray()) {
                MyClass[] myClassArray3 = new MyClass[n3];
                if (n3 == 0) {
                    n2 = 400;
                } else {
                    int n4;
                    for (n4 = 0; n4 < myClassArray2.length - 1; ++n4) {
                        myClassArray3[n4] = myClassArray2[n4];
                    }
                    while (n4 < n3) {
                        myClassArray3[n4] = myClassArray2[myClassArray2.length - 1].getComponentType();
                        ++n4;
                    }
                    n2 = this._checkArgs(myClassArray3);
                }
                if (n3 == myClassArray2.length - 1) {
                    n2 -= 10;
                }
                myClassArray[0] = myClassArray3;
            }
        }
        return n2;
    }

    private void checkType() throws GeneralErrorException {
        MyClass myClass;
        MyClass myClass2 = null;
        MyClass myClass3 = null;
        this.exceptions = new MyClass[0];
        String string = this.pc.getInheritsClass();
        if (string != null) {
            try {
                myClass = MyClass.getInstance(string, this.pc);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("!ASSERT Invoke #1 " + string);
                myClass = MyClass.getInstance(Object.class);
            }
        } else {
            myClass = MyClass.getInstance(Object.class);
        }
        if (this.returningAs != null) {
            this.returningAs.check();
        }
        if (this.nameObj != null) {
            if (this.nameObj.isSuper()) {
                this.className = _super;
                this.nameObj = null;
            } else if (this.nameObj.isSelf()) {
                if (this.pc.isFactory()) {
                    throw new GeneralErrorException(84, 4, this.keyWord, "SELF", this.error);
                }
                this.className = _self;
                this.nameObj = null;
            } else {
                this.nameObj.check();
                if (this.nameObj.getCType() == null) {
                    return;
                }
            }
        }
        if (this.className != null) {
            try {
                myClass2 = this.pc.existsClass(this.className);
                if (this.className.charAt(0) == '[') {
                    while (this.className.charAt(this.dimension) == '[') {
                        ++this.dimension;
                    }
                    if (this.className.length() - this.dimension == 1) {
                        switch (this.className.charAt(this.dimension)) {
                            case 'B': {
                                this.className = "byte";
                                break;
                            }
                            case 'C': {
                                this.className = "char";
                                break;
                            }
                            case 'S': {
                                this.className = "short";
                                break;
                            }
                            case 'I': {
                                this.className = "int";
                                break;
                            }
                            case 'J': {
                                this.className = "long";
                                break;
                            }
                            case 'F': {
                                this.className = "float";
                                break;
                            }
                            case 'D': {
                                this.className = "double";
                                break;
                            }
                            case 'Z': {
                                this.className = "boolean";
                            }
                        }
                    } else {
                        this.className = this.className.substring(this.dimension + 1, this.className.length() - 1);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MissingClassException(this.className, this.keyWord, this.error);
            }
        }
        if (this.returning != null) {
            try {
                int n2;
                myClass3 = this.returning.getVarDecl().getType();
                int n3 = n2 = this.returning.getIndexes() != null ? this.returning.getIndexes().getItemNum() : 0;
                if (n2 > 0) {
                    myClass3 = MyClass.removeDimension(myClass3, n2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MissingClassException(this.returning.getVarDecl().getTypeName(), this.keyWord, this.error);
            }
        }
        if (this.methodToken != null) {
            if ("new".equals(this.methodToken.getCode())) {
                MyClass myClass4;
                if (this.lambdaExpr) {
                    throw new GeneralErrorException(274, 4, this.keyWord, "new", this.error);
                }
                if (this.className != _super && myClass2.isAbstract() && !myClass2.isArray()) {
                    throw new GeneralErrorException(298, 4, this.keyWord, myClass2.getName(), this.error);
                }
                if (this.className == _self) {
                    this.className = myClass2.getName();
                }
                MyMethod myMethod = null;
                MyClass[] myClassArray = null;
                MyClass[][] myClassArray2 = new MyClass[1][];
                int n4 = -1;
                int n5 = 0;
                if (this.nameObj != null && !this.nameObj.isFactory() || this.className == null) {
                    throw new GeneralErrorException(76, 4, this.keyWord, "new", this.error);
                }
                this.retType = myClass2;
                MyMethod[] myMethodArray = myClass2.getConstructors();
                for (int i2 = 0; i2 < myMethodArray.length; ++i2) {
                    myClassArray2[0] = myMethodArray[i2].getParameterTypes();
                    int n6 = this.checkArgs(myClassArray2, myMethodArray[i2].isVarArgs());
                    if (n6 > n4) {
                        myMethod = myMethodArray[i2];
                        n4 = n6;
                        myClassArray = myClassArray2[0];
                        n5 = 1;
                        continue;
                    }
                    if (n6 != n4) continue;
                    ++n5;
                }
                if (myMethod == null) {
                    throw new GeneralErrorException(80, 4, this.keyWord, this.toString(), this.error);
                }
                if (n5 > 1) {
                    this.error.print(222, 2, this.keyWord, this.methodToken.getCode());
                }
                if (!(this.returning == null || this.returning.getVarDecl().isObjectReference() && myClass3.isAssignableFrom(myClass2) || this.returningAs != null && (myClass4 = this.returningAs.getType()) != null && myClass3.isAssignableFrom(myClass4) && myClass2.isAssignableFrom(myClass4))) {
                    throw new GeneralErrorException(79, 4, this.keyWord, "new", this.error);
                }
                this.exceptions = myMethod.getExceptionTypes();
                this.adjustArgs(myClassArray);
                if (this.className == _super) {
                    Verb verb;
                    if (!(this.pc instanceof CobolMethod)) {
                        throw new GeneralErrorException(88, 4, this.keyWord, "", this.error);
                    }
                    if (this.keyWord.getToknum() != 544) {
                        throw new GeneralErrorException(88, 4, this.keyWord, "", this.error);
                    }
                    boolean bl = true;
                    if (this.parent.nesting != 0 || (verb = this.parent.verbs.getFirst()) != null && verb != this) {
                        bl = false;
                    }
                    if (!((CobolMethod)this.pc).isConstructor()) {
                        bl = false;
                    }
                    if (bl) {
                        ((CobolMethod)this.pc).setSuperInvoke(this);
                    } else {
                        this.className = myClass2.getName();
                    }
                }
            } else {
                MyMethod myMethod = null;
                MyClass[] myClassArray = null;
                MyClass[][] myClassArray3 = new MyClass[1][];
                MyClass myClass5 = null;
                int n7 = -1;
                int n8 = 0;
                boolean bl = false;
                if (this.isStatic) {
                    if (!this.lambdaExpr && this.usings.getItemNum() == 0) {
                        try {
                            String string2 = this.methodToken.getCode();
                            MyField myField = this.isSelf() || this.isSuper() ? myClass2.getField(string2, true) : (string2.equals("class") ? CLASS_FIELD : myClass2.getField(string2, false));
                            if (Modifier.isStatic(myField.getModifiers())) {
                                myClass5 = myField.getType();
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (myClass5 != null) {
                        this.isField = true;
                    } else {
                        MyMethod[] myMethodArray = myClass2.getMethods(false);
                        for (int i3 = 0; i3 < myMethodArray.length; ++i3) {
                            if (!myMethodArray[i3].getName().equals(this.methodToken.getCode()) || !Modifier.isStatic(myMethodArray[i3].getModifiers())) continue;
                            bl = true;
                            if (this.lambdaExpr) {
                                myMethod = myMethodArray[i3];
                                myClassArray = myMethodArray[i3].getParameterTypes();
                                ++n8;
                                continue;
                            }
                            myClassArray3[0] = myMethodArray[i3].getParameterTypes();
                            int n9 = this.checkArgs(myClassArray3, myMethodArray[i3].isVarArgs());
                            if (n9 > n7) {
                                n7 = n9;
                                myMethod = myMethodArray[i3];
                                myClassArray = myClassArray3[0];
                                n8 = 1;
                                continue;
                            }
                            if (n9 != n7) continue;
                            ++n8;
                        }
                    }
                } else {
                    if (myClass2 == null) {
                        myClass2 = this.nameObj.getCType();
                    }
                    if (!this.lambdaExpr && this.usings.getItemNum() == 0) {
                        if (myClass2.isArray() && "length".equals(this.methodToken.getCode())) {
                            this.isField = true;
                            myClass5 = MyClass.getInstance(Integer.TYPE);
                        } else {
                            try {
                                MyField myField;
                                if (this.isSuper()) {
                                    myField = myClass.getField(this.methodToken.getCode(), true);
                                } else {
                                    boolean bl2 = this.isSelf();
                                    myField = myClass2.getField(this.methodToken.getCode(), bl2);
                                    if (bl2) {
                                        myField.setUsed();
                                    }
                                }
                                myClass5 = myField.getType();
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                // empty catch block
                            }
                        }
                    }
                    if (myClass5 != null) {
                        this.isField = true;
                    } else {
                        MyMethod[] myMethodArray = myClass2.getMethods(this.isSelf() || this.isSuper());
                        for (int i4 = 0; i4 < myMethodArray.length; ++i4) {
                            if (!myMethodArray[i4].getName().equals(this.methodToken.getCode())) continue;
                            bl = true;
                            if (this.lambdaExpr) {
                                ++n8;
                                myMethod = myMethodArray[i4];
                                myClassArray = myMethodArray[i4].getParameterTypes();
                                continue;
                            }
                            myClassArray3[0] = myMethodArray[i4].getParameterTypes();
                            int n10 = this.checkArgs(myClassArray3, myMethodArray[i4].isVarArgs());
                            if (n10 > n7) {
                                n7 = n10;
                                myMethod = myMethodArray[i4];
                                myClassArray = myClassArray3[0];
                                this.isCall = false;
                                n8 = 1;
                                continue;
                            }
                            if ("call".equals(this.methodToken.getCode())) {
                                n10 = this.checkCallArgs(myMethodArray[i4].getParameterTypes());
                                if (n10 <= n7) continue;
                                n7 = n10;
                                myMethod = myMethodArray[i4];
                                myClassArray = myMethodArray[i4].getParameterTypes();
                                this.isCall = true;
                                continue;
                            }
                            if (n10 != n7) continue;
                            ++n8;
                        }
                    }
                }
                if (myClass5 == null && myMethod == null) {
                    if (this.nameObj != null && this.nameObj.isUniversal()) {
                        this.universal = true;
                    } else {
                        if (bl) {
                            throw new GeneralErrorException(80, 4, this.keyWord, this.toString(), this.error);
                        }
                        throw new GeneralErrorException(77, 4, this.keyWord, this.toString(true), this.error);
                    }
                }
                this.retType = myClass5 != null ? myClass5 : (myMethod != null ? (this.lambdaExpr ? MyClass.getInstance(myMethod) : myMethod.getReturnType()) : MyClass.getInstance(Object.class));
                if (!this.isUniversal()) {
                    if (this.isField) {
                        if (this.returning != null && !Invoke.isReturningOk(this.returning, myClass3, this.returningAs, myClass5)) {
                            throw new GeneralErrorException(79, 4, this.keyWord, this.methodToken.getCode(), this.error);
                        }
                    } else {
                        if (n8 > 1) {
                            if (this.lambdaExpr) {
                                throw new GeneralErrorException(275, 4, this.keyWord, this.methodToken.getCode(), this.error);
                            }
                            this.error.print(222, 2, this.keyWord, this.methodToken.getCode());
                        }
                        this.exceptions = myMethod.getExceptionTypes();
                        if (!this.lambdaExpr) {
                            this.adjustArgs(myClassArray);
                            if (this.returning != null && !Invoke.isReturningOk(this.returning, myClass3, this.returningAs, myMethod.getReturnType())) {
                                throw new GeneralErrorException(79, 4, this.keyWord, this.methodToken.getCode(), this.error);
                            }
                        }
                    }
                }
            }
        }
        if (this.next != null) {
            this.next.className = this.retType.getName();
            this.next.checkType();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb verb = this.usings.getFirst();
        while (verb != null) {
            verb.check();
            verb = this.usings.getNext();
        }
        if (this.exceptions == null) {
            this.checkType();
        }
        if (this.onException == null && !this.lambdaExpr) {
            for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
                if (this.exceptions[i2].isAssignableTo(RuntimeException.class) || this.exceptions[i2].isAssignableTo(Error.class) || this.parent.isCaughtExcpt(this.exceptions[i2])) continue;
                throw new GeneralErrorException(78, 4, this.keyWord, this.exceptions[i2].getName(), this.error);
            }
        }
        if (this.next != null) {
            this.next.check();
        }
    }

    static boolean isReturningOk(VariableName variableName, MyClass myClass, As as, MyClass myClass2) {
        MyClass myClass3;
        if (myClass.isAssignableFrom(myClass2)) {
            return true;
        }
        if (!variableName.getVarDecl().isObjectReference() && myClass2.isPrimitive() || myClass2.isAssignableTo(String.class)) {
            return true;
        }
        if (myClass != null && as != null && (myClass3 = as.getType()) != null && myClass.isAssignableFrom(myClass3) && myClass2.isAssignableFrom(myClass3)) {
            return true;
        }
        return myClass2.isAssignableFrom(myClass);
    }

    String getConstructor(StringBuffer stringBuffer) {
        if (this.returning != null) {
            stringBuffer.append(this.returning.getCode());
            stringBuffer.append("=");
        }
        if (this.returningAs != null) {
            stringBuffer.append(this.returningAs.getCode());
        }
        stringBuffer.append(" new ");
        stringBuffer.append(this.className);
        if (this.dimension > 0) {
            int n2 = 0;
            if (this.usings.getItemNum() > 0) {
                Using using = (Using)this.usings.getFirst();
                while (using != null) {
                    stringBuffer.append('[');
                    stringBuffer.append(using.getCode());
                    stringBuffer.append(']');
                    using = (Using)this.usings.getNext();
                    ++n2;
                }
            }
            while (n2 < this.dimension) {
                stringBuffer.append("[]");
                ++n2;
            }
        } else {
            stringBuffer.append("(");
            if (this.usings.getItemNum() > 0) {
                Using using = (Using)this.usings.getFirst();
                while (true) {
                    stringBuffer.append(using.getCode());
                    using = (Using)this.usings.getNext();
                    if (using == null) break;
                    stringBuffer.append(",");
                }
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    void unsetInLine() {
        this.isInline = false;
    }

    @Override
    public MyClass getCType() throws GeneralErrorException {
        return this.getType();
    }

    public MyClass getType() throws GeneralErrorException {
        if (this.exceptions == null) {
            this.checkType();
        }
        if (this.next != null) {
            return this.next.getType();
        }
        return this.retType;
    }

    @Override
    public String getCode() {
        if (this.isSuperConstructor()) {
            return "";
        }
        Pcc pcc = this.pc.getRoot();
        if (this.retType instanceof LambdaExpression) {
            String string;
            if (this.isStatic && this.className != null) {
                string = MyClass.getClassNameCode(this.className) + ".";
            } else if (this.nameObj != null) {
                string = this.nameObj.getVariableName().getName() + ".";
            } else if (this.className == _super) {
                if (this.pc.isFactory()) {
                    string = this.pc.getInheritsClass() + ".";
                } else {
                    string = "";
                    if (pcc != this.pc) {
                        string = string + pcc.getFullClassName() + ".";
                    }
                    string = string + "super.";
                }
            } else {
                string = this.className == _self ? (this.pc.isFactory() ? this.pc.getClassName() + "." : (pcc != this.pc ? (this.pc.isDefault() ? "$This$." : pcc.getFullClassName() + ".this.") : "")) : "";
            }
            return ((LambdaExpression)this.retType).getCode(string);
        }
        String string = this.parent == null ? "" : this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.keyWord.getToknum() == 544) {
            stringBuffer.append(string);
            if (!this.isInline) {
                this.getCodeDebug(stringBuffer);
            }
            if (this.onException != null || this.notOnException != null) {
                stringBuffer.append("try {");
                stringBuffer.append(eol);
                string = string + "   ";
                stringBuffer.append(string);
            }
        }
        if (this.methodToken != null && "new".equals(this.methodToken.getCode())) {
            this.getConstructor(stringBuffer);
        } else {
            if (this.returning != null) {
                if (this.returning.getVarDecl().isObjectReference()) {
                    stringBuffer.append(this.returning.getVarDecl().getUnivoqueName());
                    stringBuffer.append("=((");
                    stringBuffer.append(this.returning.getVarDecl().getTypeName());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(this.returning.getCode());
                    stringBuffer.append(".set(");
                }
            }
            if (this.isUniversal()) {
                stringBuffer.append("Factory.univInvoke (");
                stringBuffer.append(this.nameObj.getCode());
                stringBuffer.append(",\"");
                stringBuffer.append(this.methodToken.getCode());
                stringBuffer.append("\",");
                if (this.usings.getItemNum() > 0) {
                    stringBuffer.append("new Object[] {");
                    Using using = (Using)this.usings.getFirst();
                    while (true) {
                        stringBuffer.append(using.getCode());
                        using = (Using)this.usings.getNext();
                        if (using == null) break;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(")");
            } else if (this.methodToken != null) {
                if (this.isStatic && this.className != null) {
                    stringBuffer.append(MyClass.getClassNameCode(this.className));
                } else if (this.nameObj != null) {
                    stringBuffer.append(this.nameObj.getCode());
                } else if (this.className == _super) {
                    if (this.pc.isFactory()) {
                        stringBuffer.append(this.pc.getInheritsClass());
                    } else {
                        if (pcc != this.pc) {
                            stringBuffer.append(pcc.getFullClassName() + ".");
                        }
                        stringBuffer.append(_super);
                    }
                } else if (this.className == _self) {
                    if (this.pc.isFactory()) {
                        stringBuffer.append(this.pc.getClassName() + ".");
                    } else if (pcc != this.pc) {
                        if (this.pc.isDefault()) {
                            stringBuffer.append("$This$.");
                        } else {
                            stringBuffer.append(pcc.getFullClassName() + ".this.");
                        }
                    }
                }
                if (this.className != _self) {
                    stringBuffer.append(".");
                }
                stringBuffer.append(this.methodToken.getCode());
                if (!this.isField) {
                    stringBuffer.append("(");
                    if (this.usings.getItemNum() > 0) {
                        if (this.isCall) {
                            stringBuffer.append("new Object[] {");
                            Using using = (Using)this.usings.getFirst();
                            while (true) {
                                stringBuffer.append(using.getCode());
                                using = (Using)this.usings.getNext();
                                if (using == null) break;
                                stringBuffer.append(",");
                            }
                            stringBuffer.append("}");
                        } else {
                            Using using = (Using)this.usings.getFirst();
                            while (true) {
                                stringBuffer.append(using.getCode());
                                using = (Using)this.usings.getNext();
                                if (using == null) break;
                                stringBuffer.append(",");
                            }
                        }
                    }
                    stringBuffer.append(")");
                }
            } else if (this.methodVar == null && this.nameObj != null) {
                stringBuffer.append(this.nameObj.getCode());
            } else {
                stringBuffer.append("Factory.univInvoke (");
                stringBuffer.append(this.nameObj.getCode());
                stringBuffer.append(",");
                stringBuffer.append(this.methodVar.getCode());
                stringBuffer.append(".toString().trim(),");
                if (this.usings.getItemNum() > 0) {
                    stringBuffer.append("new Object[] {");
                    Using using = (Using)this.usings.getFirst();
                    while (true) {
                        stringBuffer.append(using.getCode());
                        using = (Using)this.usings.getNext();
                        if (using == null) break;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(")");
            }
            if (this.returning != null) {
                stringBuffer.append(")");
            }
        }
        if (this.next != null) {
            stringBuffer.append(this.next.getCode());
        }
        if (!this.isInline) {
            stringBuffer.append(";");
        }
        if (this.printEOL) {
            stringBuffer.append(eol);
        }
        if (this.keyWord.getToknum() == 544) {
            if (this.notOnException != null) {
                stringBuffer.append(this.notOnException.getCode());
            }
            if (this.onException != null || this.notOnException != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append("} catch (Exception ");
                stringBuffer.append(this.parent.getExceptName());
                stringBuffer.append(")");
                if (this.onException != null) {
                    stringBuffer.append(this.onException.getCode());
                } else {
                    stringBuffer.append("{ }");
                }
            }
        }
        if (this.keyWord.getToknum() == 544 && !this.isInline) {
            this.getCodeDebugEnd(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static VariableDeclaration getRootVarDecl(VariableName variableName) {
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        if (variableDeclaration instanceof InlineInvoke) {
            VariableName variableName2 = ((InlineInvoke)variableDeclaration).getInvoke().getVariableName();
            variableDeclaration = variableName2 != null ? variableName2.getVarDecl() : null;
        }
        return variableDeclaration;
    }

    public String getCode(VariableNameList variableNameList) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parent == null ? "" : this.parent.getIndent();
        stringBuffer.append(string);
        if (!this.isSuperConstructor()) {
            this.getCodeDebug(stringBuffer);
        }
        if (this.onException != null || this.notOnException != null) {
            stringBuffer.append("try {");
            stringBuffer.append(eol);
            string = string + "   ";
            stringBuffer.append(string);
        }
        stringBuffer.append("super (");
        if (this.usings.getItemNum() > 0) {
            Using using = (Using)this.usings.getFirst();
            while (true) {
                VariableName variableName;
                if ((variableName = using.getVariableName()) != null) {
                    VariableName variableName2 = variableNameList.getFirst();
                    while (variableName2 != null && Invoke.getRootVarDecl(variableName) != Invoke.getRootVarDecl(variableName2)) {
                        variableName2 = variableNameList.getNext();
                    }
                    if (variableName2 != null) {
                        stringBuffer.append(using.getCode());
                    } else {
                        stringBuffer.append(using.getCode());
                    }
                } else {
                    stringBuffer.append(using.getCode());
                }
                using = (Using)this.usings.getNext();
                if (using == null) break;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(");");
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} catch (Exception ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            if (this.onException != null) {
                stringBuffer.append(this.onException.getCode());
            } else {
                stringBuffer.append("{ }");
            }
        }
        stringBuffer.append(eol);
        if (!this.isSuperConstructor()) {
            this.getCodeDebugEnd(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public boolean isField() {
        return this.isField;
    }

    @Override
    public boolean isPrimitive() {
        return this.retType.isPrimitive();
    }

    @Override
    public boolean isObjectReference() {
        return !this.retType.isPrimitive();
    }

    @Override
    public boolean isUniversal() {
        return this.universal;
    }

    @Override
    public boolean isCobolVar() {
        return this.retType.isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        return this.retType.isNumericVar();
    }

    @Override
    public boolean isFactory() {
        return false;
    }

    public boolean isSuperConstructor() {
        return this.className == _super && "new".equals(this.methodToken.getCode());
    }

    @Override
    public boolean isSelf() {
        return this.className == _self || this.nameObj != null && this.nameObj.isSelf();
    }

    @Override
    public boolean isSuper() {
        return this.className == _super || this.nameObj != null && this.nameObj.isSuper();
    }

    @Override
    public VariableName getVariableName() {
        return this.nameObj != null ? this.nameObj.getVariableName() : null;
    }

    boolean getPrintEOL() {
        return this.printEOL;
    }

    void setPrintEOL(boolean bl) {
        this.printEOL = bl;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean bl) {
        ErrorsNumbers errorsNumbers;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.className != null) {
            stringBuffer.append(this.className);
            stringBuffer.append("::");
        } else if (this.nameObj != null && (errorsNumbers = this.nameObj.getVariableName()) != null) {
            MyClass myClass = ((VariableName)errorsNumbers).getType();
            if (myClass != null) {
                stringBuffer.append(myClass.getName());
            } else {
                stringBuffer.append(((VariableName)errorsNumbers).getName());
            }
            stringBuffer.append("::");
        }
        if (this.methodToken != null) {
            stringBuffer.append(this.methodToken.getWord());
        }
        if (this.usings != null && (errorsNumbers = (Using)this.usings.getFirst()) != null) {
            stringBuffer.append("(");
            while (true) {
                if (bl && ((Using)errorsNumbers).getAs() != null) {
                    stringBuffer.append(((Using)errorsNumbers).getAs().as);
                } else {
                    stringBuffer.append(((Using)errorsNumbers).toString());
                }
                errorsNumbers = (Using)this.usings.getNext();
                if (errorsNumbers == null) break;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

