/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.JSONException;
import java.util.LinkedHashMap;

public class Json
extends Verb {
    private VariableName var1;
    private VariableName var2;
    private VariableName count;
    private LinkedHashMap<VariableDeclaration, Object[]> namesVnMap = new LinkedHashMap();
    private VariableNameList supprVnList;
    private BlockException onException;
    private Block notOnException;
    private boolean parse;

    public Json(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2;
        if (!this.pc.jsonVarsDeclared) {
            this.pc.addImport("import com.iscobol.rts.JSONParseGenerate;");
            this.pc.addImport("import com.iscobol.rts.JSONException;");
        }
        if ((token2 = this.tm.getToken()).getToknum() == 631) {
            this.parse();
        } else if (token2.getToknum() == 501) {
            this.generate();
        } else {
            throw new ExpectedFoundException(token2, this.error, "PARSE|GENERATE");
        }
    }

    private void parse() throws GeneralErrorException, EndOfProgramException {
        this.parse = true;
        this.header();
        Token token = this.tm.getToken();
        if (token.getToknum() == 813) {
            token = this.tm.getToken();
            if (token.getToknum() != 404) {
                throw new ExpectedFoundException(token, this.error, "DETAIL");
            }
            token = this.tm.getToken();
        } else if (token.getToknum() == 404) {
            token = this.tm.getToken();
        }
        this.footer(token);
    }

    private void generate() throws GeneralErrorException, EndOfProgramException {
        this.header();
        Token token = this.tm.getToken();
        if (token.getToknum() == 382) {
            token = this.tm.getToken();
            if (token.getToknum() == 526) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.count = VariableName.get(this.tm, this.error, this.pc);
            token = this.tm.getToken();
        }
        this.footer(token);
    }

    private void header() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc);
        token = this.tm.getToken();
        if (this.parse) {
            if (token.getToknum() != 542) {
                throw new ExpectedFoundException(token, this.error, "INTO");
            }
        } else if (token.getToknum() != 498) {
            throw new ExpectedFoundException(token, this.error, "FROM");
        }
        if ((token = this.tm.getToken()).getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.var2 = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (!this.parse) {
            this.var2.getVarDecl().setAutoIdentifiedBy();
        }
        this.var2.getVarDecl().setUsedAll();
    }

    private void footer(Token token) throws GeneralErrorException, EndOfProgramException {
        Object object;
        if ("NAME".equals(token.getWord())) {
            token = this.tm.getToken();
            if (token.getToknum() == 609) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            while (token.getToknum() == 10009) {
                this.tm.ungetToken();
                object = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                token = this.tm.getToken();
                if (token.getToknum() == 545) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() != 10001) {
                    throw new GeneralErrorException(97, 4, token, token.getWord(), this.error);
                }
                this.namesVnMap.put(((VariableName)object).getVarDecl(), new Object[]{object, token});
                token = this.tm.getToken();
            }
        }
        if (this.pc.getOption("-ostrip") != null && (object = this.var2.getVarDecl().getChildren()) != null) {
            VariableDeclaration variableDeclaration = ((VariableDeclarationList)object).getFirst();
            while (variableDeclaration != null) {
                this.fillNamesMap(variableDeclaration);
                variableDeclaration = ((VariableDeclarationList)object).getNext();
            }
        }
        if (token.getToknum() == 748) {
            this.supprVnList = new VariableNameList();
            token = this.tm.getToken();
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            while (token.getToknum() == 10009) {
                this.tm.ungetToken();
                object = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                this.supprVnList.addItem((VariableName)object);
                token = this.tm.getToken();
            }
        }
        if (token.getToknum() == 598 || token.getToknum() == 613 || token.getToknum() == 472) {
            boolean bl = false;
            boolean bl2 = false;
            if (token.getToknum() == 598) {
                bl2 = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 613) {
                bl = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 472) {
                if (bl2) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(JSONException.class));
                }
                TokenManager.Marker marker = this.tm.getMarker();
                this.tm.setMarker(marker);
                token = this.tm.getToken();
                if (!bl2 && token.getToknum() == 598) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 613) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() != 472) {
                        this.tm.rewindToMarker(marker);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (bl2) {
                    this.tm.ungetToken();
                }
                if (bl) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token = this.tm.getToken();
        if (token.getToknum() != 435) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void fillNamesMap(VariableDeclaration variableDeclaration) {
        if (variableDeclaration.getLevel() >= 2 && variableDeclaration.getLevel() <= 49 && !variableDeclaration.isFiller() && !variableDeclaration.isRedefines()) {
            Object object;
            if (!this.namesVnMap.containsKey(variableDeclaration)) {
                object = new Token(variableDeclaration.getNameToken());
                ((Token)object).setToknum(10001);
                ((Token)object).setWord("\"" + ((Token)object).getOriginalWord() + "\"");
                this.namesVnMap.put(variableDeclaration, new Object[]{new VariableName(variableDeclaration), object});
            }
            if ((object = variableDeclaration.getChildren()) != null) {
                VariableDeclaration variableDeclaration2 = ((VariableDeclarationList)object).getFirst();
                while (variableDeclaration2 != null) {
                    this.fillNamesMap(variableDeclaration2);
                    variableDeclaration2 = ((VariableDeclarationList)object).getNext();
                }
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        string = string + "   ";
        stringBuffer.append(string);
        stringBuffer.append("new JSONParseGenerate ()");
        if (!this.namesVnMap.isEmpty()) {
            for (Object[] objectArray : this.namesVnMap.values()) {
                stringBuffer.append(".name(");
                stringBuffer.append(((VariableName)objectArray[0]).getCode());
                stringBuffer.append(", ");
                stringBuffer.append(this.tm.getCodeLiteral((Token)objectArray[1]));
                stringBuffer.append(")");
            }
        }
        if (this.supprVnList != null) {
            Object object = this.supprVnList.getFirst();
            while (object != null) {
                stringBuffer.append(".suppress(");
                stringBuffer.append(((VariableName)object).getCode());
                stringBuffer.append(")");
                object = this.supprVnList.getNext();
            }
        }
        if (this.parse) {
            stringBuffer.append(".parse(");
        } else {
            stringBuffer.append(".generate(");
        }
        stringBuffer.append(this.var1.getCode());
        stringBuffer.append(",");
        stringBuffer.append(this.var2.getCode());
        if (!this.parse && this.count != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.count.getCode());
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("} catch (JSONException ");
        stringBuffer.append(this.parent.getExceptName());
        stringBuffer.append(")");
        if (this.onException != null) {
            stringBuffer.append(this.onException.getCode());
        } else {
            stringBuffer.append("{ }");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

