/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IKeyExtension2;
import com.iscobol.interfaces.compiler.IVariableName;
import java.util.Vector;

public class Key
implements CobolToken,
ErrorsNumbers,
IKeyExtension2 {
    TokenManager tm;
    Errors error;
    VariableName keyName;
    Vector segments = new Vector();
    boolean duplicates;

    public Key(TokenManager tokenManager, Errors errors, boolean bl) throws GeneralErrorException, EndOfProgramException {
        this.duplicates = bl ? false : tokenManager.getOptionList().getOption("-ci") != null;
        this.error = errors;
        this.tm = tokenManager;
        this.keyName = VariableName.get(this.tm, this.error);
        Token token = this.tm.getToken();
        if (this.keyName == null) {
            token = this.tm.getToken();
            throw new UnexpectedTokenException(token, this.error);
        }
        if (this.keyName.hasIndexes()) {
            throw new GeneralErrorException(55, 4, this.keyName.name, this.keyName.name.getWord(), this.error);
        }
        if (token.getToknum() == 61) {
            this.getSegments();
        } else {
            this.tm.ungetToken();
        }
        token = this.tm.getToken();
        if (token.getToknum() == 813) {
            token = this.tm.getToken();
        }
        if (token.getToknum() == 596) {
            token = this.tm.getToken();
            if (token.getToknum() != 413) {
                throw new ExpectedFoundException(token, this.error, "DUPLICATES");
            }
            this.duplicates = false;
        } else if (token.getToknum() == 413) {
            this.duplicates = true;
        } else {
            this.tm.ungetToken();
        }
    }

    private void getSegments() throws GeneralErrorException, EndOfProgramException {
        VariableName variableName;
        while ((variableName = VariableName.get(this.tm, this.error)) != null) {
            if (variableName.hasIndexes()) {
                throw new GeneralErrorException(55, 4, variableName.name, variableName.name.getWord(), this.error);
            }
            this.segments.addElement(variableName);
        }
        if (this.segments.size() == 0) {
            Token token = this.tm.getToken();
            throw new SyntaxErrorException(token, token.getWord(), this.error);
        }
    }

    void check(Pcc pcc, VariableDeclaration variableDeclaration) throws GeneralErrorException {
        if (this.segments.size() > 0) {
            for (int i2 = 0; i2 < this.segments.size(); ++i2) {
                VariableName variableName = (VariableName)this.segments.elementAt(i2);
                if (variableName.getOf() == null) {
                    variableName.setOf(new VariableName(variableDeclaration));
                }
                variableName.check(pcc);
                if (variableName.getVarDecl().isIn(variableDeclaration)) continue;
                throw new GeneralErrorException(168, 4, variableName.name, variableName.name.getWord(), this.error);
            }
        } else {
            if (this.keyName.getOf() == null) {
                this.keyName.setOf(new VariableName(variableDeclaration));
            }
            this.keyName.check(pcc);
            if (!this.keyName.getVarDecl().isIn(variableDeclaration)) {
                throw new GeneralErrorException(168, 4, this.keyName.name, this.keyName.name.getWord(), this.error);
            }
            if ((this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efo=") != null) && this.keyName.getVarDecl().redefines != null) {
                this.error.print(167, 2, this.keyName.getNameToken(), this.keyName.getName());
            }
        }
    }

    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/* [KEY] */" + eol);
        if (this.keyName != null) {
            stringBuffer.append("/* keyName */" + eol + this.keyName.getCode());
            if (this.segments.size() > 0) {
                stringBuffer.append("/* segments */" + eol);
                for (int i2 = 0; i2 < this.segments.size(); ++i2) {
                    stringBuffer.append("/* segment " + i2 + " */" + eol + ((VariableName)this.segments.elementAt(i2)).getCode());
                }
            }
        }
        return stringBuffer.toString();
    }

    public VariableDeclaration[] getVars() {
        VariableDeclaration[] variableDeclarationArray;
        if (this.segments.size() > 0) {
            variableDeclarationArray = new VariableDeclaration[this.segments.size()];
            for (int i2 = 0; i2 < this.segments.size(); ++i2) {
                variableDeclarationArray[i2] = ((VariableName)this.segments.elementAt(i2)).getVarDecl();
            }
        } else {
            variableDeclarationArray = new VariableDeclaration[]{this.keyName.getVarDecl()};
        }
        return variableDeclarationArray;
    }

    public VariableName[] getVarNames() {
        VariableName[] variableNameArray;
        if (this.segments.size() > 0) {
            variableNameArray = new VariableName[this.segments.size()];
            for (int i2 = 0; i2 < this.segments.size(); ++i2) {
                variableNameArray[i2] = (VariableName)this.segments.elementAt(i2);
            }
        } else {
            variableNameArray = new VariableName[]{this.keyName};
        }
        return variableNameArray;
    }

    @Override
    public boolean isDuplicates() {
        return this.duplicates;
    }

    @Override
    public IVariableName getKeyName() {
        return this.keyName;
    }
}

