/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DuplicateParagraph;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import java.util.Vector;

public class LabelName
implements CobolToken,
ErrorsNumbers {
    private final TokenManager tm;
    private final Pcc pc;
    private final Errors error;
    private boolean isInDeclaratives;
    private Token name;
    private Token of;
    private TokenManager.Marker mk;
    private int parIdNumber;
    private Paragraph pargrf;
    private Paragraph foundIn;
    private CobolMethod method;

    public static LabelName get(Block block, TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        LabelName labelName = new LabelName(block, tokenManager, errors, pcc);
        if (!labelName.isValid()) {
            labelName = null;
        }
        return labelName;
    }

    private LabelName(Block block, TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        if (block != null) {
            this.foundIn = block.parent;
        }
        this.tm = tokenManager;
        this.pc = pcc;
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.error = errors;
        this.mk = this.tm.getMarker();
        this.tm.setMarker(this.mk);
        Token token = this.tm.getToken();
        if (token.getToknum() == 10009 || token.getToknum() == 10002) {
            this.name = token;
            token = this.tm.getToken();
            if (token.getToknum() == 609 || token.getToknum() == 526) {
                token = this.tm.getToken();
                switch (token.getToknum()) {
                    case 10001: {
                        if (!(this.pc instanceof CobolClass) || "\"new\"".equals(token.getWord())) {
                            this.name = null;
                            this.rewind();
                            break;
                        }
                    }
                    case 10002: 
                    case 10009: {
                        this.of = token;
                        token = this.tm.getToken();
                        if (token.getToknum() == 609 || token.getToknum() == 526) {
                            this.name = null;
                            this.rewind();
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    default: {
                        this.name = null;
                        this.rewind();
                        break;
                    }
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.rewind();
        }
    }

    boolean isValid() {
        return this.name != null;
    }

    void rewind() {
        if (this.mk != null) {
            this.tm.rewindToMarker(this.mk);
            this.mk = null;
        }
    }

    public Token getName() {
        return this.name;
    }

    public void removeTokens() {
        if (this.mk != null) {
            this.tm.removeToMarker(this.mk);
            this.mk = null;
        }
    }

    public void setFoundIn(Paragraph paragraph) {
        this.foundIn = paragraph;
    }

    public void check() throws GeneralErrorException {
        GeneralErrorInfo generalErrorInfo = this.check(this.isInDeclaratives);
        if (generalErrorInfo != null) {
            throw new GeneralErrorException(generalErrorInfo);
        }
    }

    GeneralErrorInfo check(boolean bl) {
        if (this.of != null) {
            if (this.of.getToknum() == 10001) {
                CobolMethod cobolMethod;
                CobolMethod[] cobolMethodArray = this.pc.parent.getMethods();
                Vector<CobolMethod> vector = new Vector<CobolMethod>();
                String string = this.of.getWord().substring(1, this.of.getWord().length() - 1);
                for (CobolMethod cobolMethod2 : cobolMethodArray) {
                    if (!cobolMethod2.getMethodName().equals(string)) continue;
                    vector.addElement(cobolMethod2);
                }
                switch (vector.size()) {
                    case 0: {
                        return new GeneralErrorInfo(77, 4, this.of, this.of.getWord(), this.error);
                    }
                    case 1: {
                        Object[] objectArray = ((CobolMethod)vector.elementAt(0)).getParameterTypes();
                        if (objectArray == null || objectArray.length <= 0) break;
                        return new GeneralErrorInfo(83, 4, this.of, this.of.getWord() + " must be without parameters", this.error);
                    }
                    default: {
                        Object[] objectArray;
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            objectArray = ((CobolMethod)vector.elementAt(n2)).getParameterTypes();
                            if (objectArray != null && objectArray.length > 0) {
                                vector.remove(n2);
                                continue;
                            }
                            ++n2;
                        }
                        if (vector.size() > 1) {
                            return new GeneralErrorInfo(145, 4, this.of, this.of.getWord(), this.error);
                        }
                        if (vector.size() != 0) break;
                        return new GeneralErrorInfo(83, 4, this.of, this.of.getWord() + " must be without parameters", this.error);
                    }
                }
                if (!(cobolMethod = (CobolMethod)vector.elementAt(0)).isFactory() && this.pc.isFactory()) {
                    return new GeneralErrorInfo(84, 4, this.of, this.of.getWord(), this.error);
                }
                this.pargrf = cobolMethod.getParagraph(this.name.getWord(), null);
                if (this.pargrf == null) {
                    return new GeneralErrorInfo(105, 4, this.name, this.toString(), this.error);
                }
                if (this.pargrf instanceof DuplicateParagraph) {
                    return new GeneralErrorInfo(67, 4, this.name, this.name.getWord(), this.error);
                }
                this.method = cobolMethod;
            } else {
                this.pargrf = this.pc.getParagraph(this.name.getWord(), this.of.getWord(), bl);
            }
        } else {
            this.pargrf = this.pc.getParagraph(this.name.getWord(), this.foundIn, bl);
        }
        if (this.pargrf == null) {
            return new GeneralErrorInfo(105, 4, this.name, this.toString(), this.error);
        }
        if (this.pargrf instanceof DuplicateParagraph) {
            return new GeneralErrorInfo(67, 4, this.name, this.name.getWord(), this.error);
        }
        this.isInDeclaratives = bl;
        this.parIdNumber = this.pargrf.getIdNumber();
        return null;
    }

    public Paragraph getParagraph() {
        return this.pargrf;
    }

    public int getParIdNumber() {
        return this.parIdNumber;
    }

    public String toString() {
        if (this.of != null) {
            return this.name.getWord() + " OF " + this.of.getWord();
        }
        return this.name.getWord();
    }

    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    public CobolMethod getMethod() {
        return this.method;
    }
}

