/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LikeFlags
implements CobolToken,
ErrorsNumbers {
    private static final int CASE_SET = 1;
    private static final int CASE_SENSITIVE = 1;
    private static final int CASE_INSENSITIVE = 3;
    private static final int TRIMMED_LEFT = 4;
    private static final int TRIMMED_RIGHT = 8;
    private static final int TRIMMED = 12;
    private final Errors error;
    private int flags;
    private VariableName vApprox;
    private Token tApprox;

    public LikeFlags(TokenManager tokenManager, Errors errors, Pcc pcc) throws GeneralErrorException, EndOfProgramException {
        this.error = errors;
        Token token = tokenManager.getToken();
        String string = token.getWord();
        while (true) {
            if ("TRIMMED".equals(string)) {
                token.setToknum(10025);
                if ((this.flags & 0xC) != 0) {
                    throw new IllegalConditionException(token, this.error);
                }
                token = tokenManager.getToken();
                string = token.getWord();
                if (token.getToknum() == 557) {
                    this.flags |= 4;
                    token = tokenManager.getToken();
                    string = token.getWord();
                    continue;
                }
                if (token.getToknum() == 700) {
                    this.flags |= 8;
                    token = tokenManager.getToken();
                    string = token.getWord();
                    continue;
                }
                this.flags |= 0xC;
                continue;
            }
            if ("CASE-SENSITIVE".equals(string)) {
                token.setToknum(10025);
                if ((this.flags & 1) != 0) {
                    throw new IllegalConditionException(token, this.error);
                }
                this.flags |= 1;
                token = tokenManager.getToken();
                string = token.getWord();
                continue;
            }
            if ("CASE-INSENSITIVE".equals(string)) {
                token.setToknum(10025);
                if ((this.flags & 1) != 0) {
                    throw new IllegalConditionException(token, this.error);
                }
                this.flags |= 3;
                token = tokenManager.getToken();
                string = token.getWord();
                continue;
            }
            if (!"APPROX".equals(string)) break;
            token.setToknum(10025);
            if (this.tApprox != null || this.vApprox != null) {
                throw new IllegalConditionException(token, this.error);
            }
            token = tokenManager.getToken();
            if (Token.isIntLit(token)) {
                this.tApprox = token;
            } else if (token.getToknum() == 10009) {
                tokenManager.ungetToken();
                this.vApprox = VariableName.get(tokenManager, this.error, pcc);
                if (this.vApprox == null) {
                    throw new UnexpectedTokenException(token, this.error);
                }
            } else {
                throw new UnexpectedTokenException(token, this.error);
            }
            token = tokenManager.getToken();
            string = token.getWord();
        }
        tokenManager.ungetToken();
    }

    public void check(Token token) throws GeneralErrorException {
        String string;
        if (token != null && (string = token.getWord()).length() > 2) {
            string = string.substring(1, string.length() - 1);
            try {
                Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new GeneralErrorException(208, 4, token, patternSyntaxException.getMessage(), this.error);
            }
        }
    }

    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.flags & 3) == 3) {
            stringBuffer.append("CobolVar.LIKE_NOT_CS");
        }
        switch (this.flags & 0xC) {
            case 12: {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append("CobolVar.LIKE_TRIM");
                break;
            }
            case 4: {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append("CobolVar.LIKE_L_TRIM");
                break;
            }
            case 8: {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append("CobolVar.LIKE_R_TRIM");
                break;
            }
            default: {
                if (stringBuffer.length() != 0) break;
                stringBuffer.append("0");
            }
        }
        if (this.tApprox != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.tApprox.longValue());
        } else if (this.vApprox != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.vApprox.getCode());
            stringBuffer.append(".toint()");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return "0";
    }
}

