/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.interfaces.compiler.ILinkageSection;
import java.util.HashMap;

public class LinkageSection
implements CobolToken,
ErrorsNumbers,
ILinkageSection {
    static final Token lnkNull = new Token(10009, "$lnknull$", 0, 0, "");
    TokenManager tm;
    Errors error;
    Pcc pc;
    VariableDeclarationList vars = new VariableDeclarationList();
    private Token firstToken;
    private Token lastToken;
    private String serviceBridgeDecoration = "DEFAULT";
    private Token elkToken;
    HashMap<VariableDeclaration, Token> varargsItems = new HashMap();

    public LinkageSection(Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, null);
    }

    public LinkageSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        this(pcc, tokenManager, errors, token, null);
    }

    public LinkageSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token, WorkingStorageSection workingStorageSection) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = token;
        this.error = errors;
        this.tm = tokenManager;
        this.pc = pcc;
        TokenList tokenList = tokenManager.delExtraInfo("ELK");
        if (tokenList != null) {
            this.elkToken = tokenList.getFirst();
            if ("DECORATION".equalsIgnoreCase(tokenList.getNext().getWord())) {
                if (tokenList.getNext().getToknum() == 61) {
                    this.serviceBridgeDecoration = tokenList.getNext().getWord();
                    if (!this.serviceBridgeDecoration.equalsIgnoreCase("DEFAULT") && !this.serviceBridgeDecoration.equalsIgnoreCase("NONE")) {
                        this.error.print(226, 4, this.elkToken, this.serviceBridgeDecoration);
                    }
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        if ((token = this.tm.getToken()).getToknum() == 709) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, token, "'.'");
                this.tm.ungetToken();
            }
            while ((token = this.tm.getToken()).getToknum() == 10002 || token.getToknum() == 474 && workingStorageSection != null) {
                if (token.getToknum() == 10002) {
                    this.tm.ungetToken();
                    try {
                        VariableDeclaration variableDeclaration = new VariableDeclaration(this, 0);
                        this.vars.addItem(variableDeclaration);
                        this.pc.loadVariable(variableDeclaration);
                        variableDeclaration.calcOffset(this.pc, 0);
                        continue;
                    }
                    catch (GeneralErrorException generalErrorException) {
                        while ((token = this.tm.getToken()).getToknum() != 10006 && token.getWord().length() > 1) {
                        }
                        continue;
                    }
                }
                workingStorageSection.exec(token);
            }
        } else {
            throw new UnexpectedTokenException(token, errors);
        }
        this.lastToken = token;
        this.tm.ungetToken();
    }

    void checkVarargsItems() {
        if (this.pc.procedure != null) {
            if (this.pc.procedure.usingVarargs != null) {
                this.varargsItems.remove(this.pc.procedure.usingVarargs);
            }
            for (Entry cobolToken : this.pc.entryPoints) {
                if (cobolToken.usingVarargs == null) continue;
                this.varargsItems.remove(cobolToken.usingVarargs);
            }
        }
        for (VariableDeclaration variableDeclaration : this.varargsItems.keySet()) {
            Token token = this.varargsItems.get(variableDeclaration);
            String string = token.getWord();
            this.error.print(300, 3, token, string.substring(1, string.length() - 4) + "[]");
        }
    }

    VariableDeclaration checkUsingVarargs(VariableNameList variableNameList) throws GeneralErrorException {
        boolean bl = true;
        VariableDeclaration variableDeclaration = null;
        VariableName variableName = variableNameList.getLast();
        while (variableName != null) {
            if (this.varargsItems.containsKey(variableName.getVarDecl())) {
                if (bl) {
                    variableDeclaration = variableName.getVarDecl();
                } else {
                    throw new GeneralErrorException(301, 4, variableName.getNameToken(), variableName.getName(), this.error);
                }
            }
            bl = false;
            variableName = variableNameList.getPrevious();
        }
        return variableDeclaration;
    }

    public String getCode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.tm.getCommentCode(this.firstToken, "   "));
        VariableDeclaration variableDeclaration = this.vars.getFirst();
        while (variableDeclaration != null) {
            stringBuffer2.append(variableDeclaration.getCode(true, stringBuffer));
            variableDeclaration = this.vars.getNext();
        }
        return stringBuffer2.toString();
    }

    @Override
    public String getServiceBridgeDecoration() {
        return this.serviceBridgeDecoration;
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

