/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;

public class LocalStorageSection
extends StorageSection {
    VariableDeclarationList tlVars = new VariableDeclarationList();

    public LocalStorageSection(Pcc pcc, TokenManager tokenManager, Errors errors, Token token) throws GeneralErrorException, EndOfProgramException {
        super(pcc, tokenManager, errors, token);
        if (tokenManager == null) {
            return;
        }
        token = tokenManager.getToken();
        if (token.getToknum() != 709) {
            throw new UnexpectedTokenException(token, errors);
        }
        if (this.tm.getToken().getToknum() != 10006) {
            this.error.print(188, 3, token, "'.'");
            this.tm.ungetToken();
        }
        boolean bl = this.pc.isInterfaceChild();
        block6: while (true) {
            token = this.tm.getToken();
            switch (token.getToknum()) {
                case 10002: {
                    this.tm.ungetToken();
                    try {
                        this.memoryOffset += LocalStorageSection.calcAlign(this.memoryOffset, this.align);
                        VariableDeclaration variableDeclaration = new VariableDeclaration(this, this.memoryOffset);
                        if (bl) {
                            throw new GeneralErrorException(249, 4, variableDeclaration.getNameToken(), variableDeclaration.getName(), this.error);
                        }
                        if (variableDeclaration.threadLocal) {
                            this.tlVars.addItem(variableDeclaration);
                            continue block6;
                        }
                        this.loadVariable(variableDeclaration);
                        continue block6;
                    }
                    catch (GeneralErrorException generalErrorException) {
                        while (true) {
                            if ((token = this.tm.getToken()).getToknum() == 10006 || token.getWord().length() < 1) continue block6;
                        }
                    }
                }
                case 474: {
                    this.exec(token);
                    continue block6;
                }
            }
            break;
        }
        this.lastToken = token;
        this.tm.ungetToken();
    }

    protected void loadVariable(VariableDeclaration variableDeclaration) throws GeneralErrorException {
        this.vars.addItem(variableDeclaration);
        this.pc.loadVariable(variableDeclaration);
        int n2 = this.memoryOffset;
        if (variableDeclaration.isExternal()) {
            variableDeclaration.calcOffset(this.pc, 0);
        } else {
            variableDeclaration.calcOffset(this.pc, this.memoryOffset);
            if (this.memIn1block) {
                if (variableDeclaration.getRedefinesVar() != null) {
                    if ((n2 = variableDeclaration.globalLen(n2) + variableDeclaration.getOffset()) > this.memoryOffset) {
                        this.memoryOffset = n2;
                    }
                } else {
                    this.memoryOffset += variableDeclaration.globalLen(n2);
                }
            }
        }
    }
}

