/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Supplier;

public class MSVariableGenerator {
    private static final Set<String> javaKeywords;
    public static final String LSS_CLASS = "LocalStorageSection";
    public static final String TLSS_CLASS = "ThreadLocalStorageSection";
    public static final String LSS_OBJ = "$lss$";
    public static final String TLSS_OBJ = "$tlss$";
    public static final String GROUP_OBJ = "$group$";
    public static final String NUM_OBJ = "Num";
    public static final String STR_OBJ = "Str";
    static final String FLD_PFX = "";
    private static final String PROG_KEY = "$prog$";
    static final int _DCI = 1;
    static final int _DCM = 2;
    static final int _DCMI = 3;
    static final int _DCII = 4;
    static final int _DCD = 5;
    static final int _DCDM = 6;
    static final int _DCN = 7;
    static final int _DCB = 8;
    static final int _DCR = 9;
    static final int _DCV = 10;
    static final int _DC_MASK = 15;
    static final int _CP = 16;
    static final int _CV = 32;
    static final int _DZ = 64;
    static final int _DPNTCO = 128;
    static final int _D64 = 256;
    static long timestamp;
    private final String COPY_PKG;
    private final String UI_PKG;
    private final String pkgName;
    private final String path;
    private final Pcc pcc;
    private final List<String[]> classToBeRemoved;
    private String od;
    private final boolean cp;
    private final boolean dpc;
    private final String typesPkg;
    private final String genPkg;
    private final int options;
    private Vector<PreProcessor> allPPs;
    private Map<String, FileObject> fileObjs = new HashMap<String, FileObject>();
    private int[] prog = new int[1];

    public MSVariableGenerator(Pcc pcc) throws GeneralErrorException {
        String string;
        int n2;
        this.pcc = pcc;
        this.classToBeRemoved = new ArrayList<String[]>();
        File file = new File(this.pcc.getProgName());
        this.classToBeRemoved.add(new String[]{file.getParent(), file.getName().substring(0, file.getName().length() - 5)});
        this.COPY_PKG = Config.a("iscobol.compiler.jjms.copy_package", "common");
        this.UI_PKG = Config.a("iscobol.compiler.jjms.ui_package", "ui");
        Supplier<GeneralErrorException> supplier = () -> new GeneralErrorException(307, 4, 1, 0, "iscobol.compiler.jjms.copy_package = " + this.COPY_PKG, this.pcc.getSourceFileName(), null, this.pcc.getErrors());
        if (this.COPY_PKG.length() == 0 || !Character.isJavaIdentifierStart(this.COPY_PKG.charAt(0))) {
            throw supplier.get();
        }
        for (n2 = 1; n2 < this.COPY_PKG.length(); ++n2) {
            if (Character.isJavaIdentifierPart(this.COPY_PKG.charAt(n2))) continue;
            throw supplier.get();
        }
        this.allPPs = this.pcc.getTokenManager().getAllPreProcessors();
        n2 = this.pcc.getTokenManager().getDecimalPoint();
        this.dpc = n2 == 44;
        boolean bl = this.cp = pcc.getOption("-cp") != null;
        if (this.cp) {
            this.typesPkg = "com.iscobol.types_n";
            this.genPkg = "com.iscobol.java.generator_n";
        } else {
            this.typesPkg = "com.iscobol.types";
            this.genPkg = "com.iscobol.java.generator";
        }
        int n3 = 0;
        if (this.cp) {
            n3 += 16;
        }
        if (this.dpc) {
            n3 += 128;
        }
        if (pcc.getOption("-dci") != null) {
            ++n3;
        } else if (pcc.getOption("-dcm") != null) {
            n3 += 2;
        } else if (pcc.getOption("-dcmi") != null) {
            n3 += 3;
        } else if (pcc.getOption("-dcii") != null) {
            n3 += 4;
        } else if (pcc.getOption("-dcd") != null) {
            n3 += 5;
        } else if (pcc.getOption("-dcdm") != null) {
            n3 += 6;
        } else if (pcc.getOption("-dcn") != null) {
            n3 += 7;
        } else if (pcc.getOption("-dcb") != null) {
            n3 += 8;
        } else if (pcc.getOption("-dcr") != null) {
            n3 += 9;
        } else if (pcc.getOption("-dcv") != null) {
            n3 += 10;
        }
        if (pcc.getOption("-cv") != null) {
            n3 += 32;
        }
        if (pcc.getOption("-dz") != null) {
            n3 += 64;
        }
        if (pcc.getOption("-d64") != null) {
            n3 += 256;
        }
        this.options = n3;
        String string2 = this.pcc.getSourceFileName();
        int n4 = string2.lastIndexOf(46);
        if (n4 >= 0) {
            string2 = string2.substring(0, n4);
        }
        if (javaKeywords.contains(string = MSVariableGenerator.getClassName(new File(string2).getName()).toLowerCase())) {
            string = "_" + string;
        }
        this.pkgName = string;
        this.od = pcc.outDir;
        if (this.od == null || this.od.length() == 0) {
            this.od = new File(this.pcc.getSourceFileName()).getParent();
            if (this.od == null) {
                this.od = ".";
            }
        }
        this.path = this.od + File.separator + this.pkgName + File.separator;
        File file2 = new File(this.path);
        file2.mkdirs();
    }

    List<String[]> getClassToBeRemoved() {
        return this.classToBeRemoved;
    }

    public String generateVars(Type type, Vector<Vd> vector) {
        try {
            if (type == Type.SCREEN_SECTION) {
                return this.getScreenVarsCode(vector);
            }
            return this.getVarsCode(type, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return FLD_PFX;
        }
    }

    private String getScreenVarsCode(Vector<Vd> vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        FileObject fileObject = this.getFileObject(0, null, null);
        LineNumberWriter lineNumberWriter = fileObject.out.peek();
        lineNumberWriter.init(Integer.MAX_VALUE);
        StringBuffer stringBuffer2 = new StringBuffer();
        this.writeScreen(vector, "   ", lineNumberWriter, stringBuffer2);
        lineNumberWriter.println("   {");
        lineNumberWriter.println("      final PictureHelper phlp = new PictureHelper(" + this.options + ");");
        lineNumberWriter.println("      ScrFactory.getGUIEnviroment().setProgName(\"" + this.pcc.getClassName() + "\");");
        lineNumberWriter.print(stringBuffer2.toString());
        lineNumberWriter.println("   }");
        return stringBuffer.toString();
    }

    private String getVarsCode(Type type, Vector<Vd> vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        FileObject fileObject = this.getFileObject(0, null, null);
        fileObject.writeDecl = true;
        fileObject.writeDef = true;
        fileObject.writeInit = true;
        LineNumberWriter lineNumberWriter = fileObject.out.peek();
        lineNumberWriter.init(Integer.MAX_VALUE);
        String string = null;
        String string2 = FLD_PFX;
        String string3 = FLD_PFX;
        switch (type) {
            case LOCAL_STORAGE_SECTION: {
                string = LSS_CLASS;
                string3 = "   ";
                break;
            }
            case THREAD_LOCAL_STORAGE_SECTION: {
                string = TLSS_CLASS;
                string3 = "   ";
                break;
            }
            case WORKING_STORAGE_SECTION: {
                string2 = "WS";
                break;
            }
            case LINKAGE_SECTION: {
                string2 = "LS";
                break;
            }
        }
        if (string != null) {
            lineNumberWriter.println("   public static class " + string + " {");
        }
        this.write(vector, true, string3 + "   ", 0, lineNumberWriter);
        if (string != null) {
            lineNumberWriter.println(string3 + "   public " + string + "(CobolVarHelper cvh) {");
        } else {
            lineNumberWriter.println(string3 + "   {");
            lineNumberWriter.println(string3 + "      final CobolVarHelper cvh = CobolVarHelper.getSectionHelper(\"" + (Object)((Object)type) + "\", " + this.options + ");");
        }
        lineNumberWriter.println(string3 + "      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
        lineNumberWriter.init();
        this.writeInit(vector, true, string3 + "      ", 0, lineNumberWriter);
        lineNumberWriter.println(string3 + "      this.createVars" + string2 + "(cvh);");
        lineNumberWriter.println(string3 + "   }");
        lineNumberWriter.println(string3 + "   private void createVars" + string2 + "(final CobolVarHelper cvh) {");
        lineNumberWriter.println(string3 + "      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
        this.writeCreateVars(vector, true, string3 + "      ", 0, lineNumberWriter);
        lineNumberWriter.println(string3 + "   }");
        if (string != null) {
            lineNumberWriter.println(string3 + "}");
        }
        for (FileObject fileObject2 : this.fileObjs.values()) {
            if (fileObject2.index <= 0) continue;
            LineNumberWriter lineNumberWriter2 = fileObject2.out.peek();
            lineNumberWriter2.println("   }");
            lineNumberWriter2.println("}");
            lineNumberWriter2.close();
        }
        return stringBuffer.toString();
    }

    public static String getClassName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            boolean bl;
            boolean bl2 = bl = i2 == 0;
            if (i2 == 0 && !Character.isJavaIdentifierStart(cArray[i2])) {
                stringBuffer.append('_');
            }
            if (cArray[i2] == '.') {
                bl = true;
                if (++i2 == cArray.length - 1) break;
            }
            if (Character.isJavaIdentifierPart(cArray[i2])) {
                stringBuffer.append(bl ? Character.toUpperCase(cArray[i2]) : Character.toLowerCase(cArray[i2]));
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static String getDeclUnivoqueName(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 == 0 && Character.isDigit(cArray[i2])) {
                stringBuffer.append('_');
            }
            if (cArray[i2] == '-' || cArray[i2] == '_') {
                if (i2 < cArray.length - 1 && Character.isLetter(cArray[i2 + 1])) {
                    stringBuffer.append(Character.toUpperCase(cArray[++i2]));
                    continue;
                }
                stringBuffer.append(Pcc.hyphenRepl);
                continue;
            }
            stringBuffer.append(Character.toLowerCase(cArray[i2]));
        }
        if (n2 > 0) {
            stringBuffer.append(Pcc.identifierSep);
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    private FileObject getFileObject(int n2, String string, String string2) throws Exception {
        String string3;
        String string4 = string3 = n2 == 0 ? "null" : string;
        if (string2 != null) {
            string3 = string3 + "," + string2;
        }
        long l2 = timestamp;
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        FileObject fileObject = this.fileObjs.get(string3);
        String string5 = null;
        if (fileObject == null) {
            Object object;
            fileObject = new FileObject(n2);
            fileObject.replacing = string2;
            if (n2 == 0) {
                object = "         init_$prog$(cvh, cvhext);" + Verb.eol + "      }" + Verb.eol + "      private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                fileObject.out.push(new LineNumberWriter(this.pcc.getCobolProgram().progFile, (String)object, this.prog));
            } else {
                String string6;
                File file;
                string5 = MSVariableGenerator.getClassName(string);
                if (string2 != null) {
                    object = Integer.toHexString(string2.hashCode());
                    string5 = string5 + "$" + (String)object;
                }
                object = new File(this.od + File.separator + this.COPY_PKG);
                this.classToBeRemoved.add(new String[]{((File)object).getPath(), string5});
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                if (!(file = new File(string6 = ((File)object).getPath() + File.separator + string5 + ".java")).exists() || file.lastModified() < l2) {
                    String string7 = "         init_$prog$(cvh, cvhext);" + Verb.eol + "      }" + Verb.eol + "      private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                    fileObject.out.push(new LineNumberWriter(PreProcessor.newPrintWriter(string6, true), string7, this.prog));
                } else {
                    fileObject.out.push(new LineNumberWriter(new PrintWriter(new OutputStream(){

                        @Override
                        public void write(int n2) throws IOException {
                        }
                    }), FLD_PFX, this.prog));
                }
                fileObject.pkgName = string5.toLowerCase().replace('$', '_');
            }
            fileObject.className = string5;
            if (fileObject.className != null) {
                fileObject.fieldName = Character.toLowerCase(fileObject.className.charAt(0)) + fileObject.className.substring(1);
            }
            if (javaKeywords.contains(fileObject.pkgName)) {
                fileObject.pkgName = "_" + fileObject.pkgName;
            }
            if (n2 > 0) {
                object = fileObject.out.peek();
                ((LineNumberWriter)object).println("package " + this.COPY_PKG + ";");
                ((LineNumberWriter)object).println("import " + this.typesPkg + ".*;");
                ((LineNumberWriter)object).println("import com.iscobol.java.*;");
                ((LineNumberWriter)object).println("import " + this.genPkg + ".*;");
                if (fileObject.replacing != null) {
                    ((LineNumberWriter)object).println("@Replacing(replacingString = \"" + fileObject.replacing + "\")");
                }
                ((LineNumberWriter)object).println("public class " + string5 + " extends VarGroup {");
            }
            this.fileObjs.put(string3, fileObject);
        }
        return fileObject;
    }

    private void writeCreateVars(Vector<Vd> vector, boolean bl, String string, int n2, LineNumberWriter lineNumberWriter) throws Exception {
        for (Vd vd : vector) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n3 = vd.var.getNameToken().getFileIndex();
            FileObject fileObject = this.getFileObject(n3, this.allPPs.elementAt(n3).getOrigFilename(), this.allPPs.elementAt(n3).getReplacingString());
            if (n3 != n2) {
                object4 = fileObject;
                while (object4 != null) {
                    PreProcessor preProcessor = this.allPPs.elementAt(((FileObject)object4).index);
                    object3 = preProcessor.getParent();
                    object2 = object3 == null ? null : this.getFileObject(preProcessor.parentFileIndex, this.allPPs.elementAt(preProcessor.parentFileIndex).getOrigFilename(), this.allPPs.elementAt(preProcessor.parentFileIndex).getReplacingString());
                    object = ((FileObject)object4).out.peek();
                    if (!((FileObject)object4).writeDef) {
                        if (object2 != null) {
                            ((FileObject)object2).hdr2 = string + ((FileObject)object4).fieldName + ".createVars(cvh);";
                        }
                        ((LineNumberWriter)object).println("   }");
                        ((LineNumberWriter)object).println("   public void createVars(final CobolVarHelper cvh) {");
                        ((LineNumberWriter)object).println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                        if (((FileObject)object4).hdr2 != null) {
                            ((LineNumberWriter)object).println(((FileObject)object4).hdr2);
                        }
                        ((FileObject)object4).writeDef = true;
                        object4 = object2;
                        continue;
                    }
                    if (((FileObject)object4).hdr2 == null) break;
                    ((LineNumberWriter)object).println(((FileObject)object4).hdr2);
                    ((FileObject)object4).hdr2 = null;
                    break;
                }
                lineNumberWriter = fileObject.out.peek();
            }
            n2 = n3;
            if (vd.var.getLevel() == 88 || vd.var.getLevel() == 78) continue;
            object4 = this.getName(vd.var);
            boolean bl2 = vd.hasRealChildren;
            if (bl2 && MSVariableGenerator.isRootElem(vd.var, n3)) {
                lineNumberWriter.println(string + vd.var.getDeclUnivoqueName() + ".createVars(cvh);");
            } else if (!vd.var.isObjectReference()) {
                lineNumberWriter.println(string + vd.var.getDeclUnivoqueName() + " = (" + vd.var.getTypeName() + ") " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + (String)object4 + "\");");
                object3 = vd.children;
                if (bl2) {
                    this.writeCreateVars((Vector<Vd>)object3, false, string, n2, lineNumberWriter);
                } else if (object3 != null) {
                    object2 = ((Vector)object3).iterator();
                    while (object2.hasNext()) {
                        object = (Vd)object2.next();
                        if (((Vd)object).var.getLevel() != 88) continue;
                        lineNumberWriter.println(string + ((Vd)object).var.getDeclUnivoqueName() + " = " + MSVariableGenerator.getCVHName(vd.var) + ".getCondName(\"" + this.getName(((Vd)object).var) + "\");");
                    }
                }
            }
            object3 = MSVariableGenerator.getImplicitVars(vd.var);
            object2 = ((VariableNameList)object3).getFirst();
            while (object2 != null) {
                lineNumberWriter.println(string + ((VariableName)object2).getVarDecl().getDeclUnivoqueName() + " = (NumericVar) " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + ((VariableName)object2).getName() + "\");");
                object2 = ((VariableNameList)object3).getNext();
            }
        }
    }

    private void writeInit(Vector<Vd> vector, boolean bl, String string, int n2, LineNumberWriter lineNumberWriter) throws Exception {
        for (Vd vd : vector) {
            Object object;
            Iterator<Vd> iterator;
            Object object2;
            Object object3;
            int n3 = vd.var.getNameToken().getFileIndex();
            FileObject fileObject = this.getFileObject(n3, this.allPPs.elementAt(n3).getOrigFilename(), this.allPPs.elementAt(n3).getReplacingString());
            if (n3 != n2) {
                Object object4 = fileObject;
                while (object4 != null) {
                    object3 = this.allPPs.elementAt(((FileObject)object4).index);
                    object2 = ((PreProcessor)object3).getParent();
                    iterator = object2 == null ? null : this.getFileObject(((PreProcessor)object3).parentFileIndex, this.allPPs.elementAt(((PreProcessor)object3).parentFileIndex).getOrigFilename(), this.allPPs.elementAt(((PreProcessor)object3).parentFileIndex).getReplacingString());
                    object = ((FileObject)object4).out.peek();
                    if (!((FileObject)object4).writeInit) {
                        if (iterator != null) {
                            ((FileObject)((Object)iterator)).hdr = string + ((FileObject)object4).fieldName + " = new " + this.COPY_PKG + "." + ((FileObject)object4).className + "(cvh);";
                        }
                        ((LineNumberWriter)object).println("   public " + ((FileObject)object4).className + "(CobolVarHelper cvh) {");
                        ((LineNumberWriter)object).println("      super(cvh);");
                        ((LineNumberWriter)object).println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                        if (((FileObject)object4).hdr != null) {
                            ((LineNumberWriter)object).println(((FileObject)object4).hdr);
                        }
                        ((FileObject)object4).writeInit = true;
                        object4 = iterator;
                        continue;
                    }
                    if (((FileObject)object4).hdr == null) break;
                    ((LineNumberWriter)object).println(((FileObject)object4).hdr);
                    ((FileObject)object4).hdr = null;
                    break;
                }
                lineNumberWriter = fileObject.out.peek();
            }
            n2 = n3;
            if (vd.var.getLevel() == 88) {
                this.printCondName(vd.var, string, lineNumberWriter);
                continue;
            }
            if (vd.var.getLevel() == 78) continue;
            boolean bl2 = vd.hasRealChildren;
            if (bl2 && MSVariableGenerator.isRootElem(vd.var, n3)) {
                object3 = this.pkgName;
                object2 = vd.var.getDeclUnivoqueName();
                iterator = Character.toUpperCase(((String)object2).charAt(0)) + ((String)object2).substring(1);
                if (fileObject.index > 0) {
                    object3 = this.COPY_PKG + "." + fileObject.pkgName;
                }
                lineNumberWriter.println(string + object2 + " = new " + (String)object3 + "." + iterator + "(cvh);");
                continue;
            }
            if (vd.var.isObjectReference()) continue;
            if (vd.var.getRename1() == null) {
                lineNumberWriter.print(string + MSVariableGenerator.getCVHName(vd.var) + ".");
            }
            object3 = this.getName(vd.var);
            if (bl2) {
                lineNumberWriter.print("group(\"" + (String)object3 + "\")");
            } else {
                MSVariableGenerator.writeHelperDecl(vd.var, (String)object3, string, lineNumberWriter);
            }
            lineNumberWriter.println(";");
            this.addAttributes(vd.var, string, lineNumberWriter);
            object2 = vd.children;
            if (bl2) {
                this.writeInit((Vector<Vd>)object2, false, "      ", n2, lineNumberWriter);
                lineNumberWriter.println(string + MSVariableGenerator.getCVHName(vd.var) + ".endGroup(); // end group " + (String)object3);
                continue;
            }
            if (object2 == null) continue;
            iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((Vd)object).var.getLevel() != 88) continue;
                this.printCondName(((Vd)object).var, string, lineNumberWriter);
            }
        }
    }

    static String writeHelperDecl(VariableDeclaration variableDeclaration, String string) {
        StringWriter stringWriter = new StringWriter();
        LineNumberWriter lineNumberWriter = new LineNumberWriter(new PrintWriter(stringWriter), FLD_PFX, new int[1]);
        MSVariableGenerator.writeHelperDecl(variableDeclaration, string, FLD_PFX, lineNumberWriter);
        lineNumberWriter.close();
        return stringWriter.toString();
    }

    static void writeHelperDecl(VariableDeclaration variableDeclaration, String string, String string2, LineNumberWriter lineNumberWriter) {
        if (variableDeclaration.isNumeric()) {
            if (variableDeclaration.isEdited()) {
                lineNumberWriter.print("picNumEdit(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ", \"" + variableDeclaration.getPicture() + "\")");
            } else if (variableDeclaration.getUsageToken() != null) {
                switch (variableDeclaration.getUsageToken().getToknum()) {
                    case 343: 
                    case 355: {
                        lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "9Comp(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 345: 
                    case 357: {
                        lineNumberWriter.print("pic9Comp1(\"" + string + "\")");
                        break;
                    }
                    case 346: 
                    case 358: {
                        lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "9Comp2(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 347: 
                    case 359: {
                        lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "9Comp3(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 301: {
                        if (variableDeclaration.isBinaryFixedLength()) {
                            lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "Binary(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ", " + variableDeclaration.getPhisicLen() + ")");
                            break;
                        }
                    }
                    case 348: 
                    case 360: {
                        lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "9Comp4(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 349: 
                    case 361: {
                        lineNumberWriter.print("pic" + (variableDeclaration.isSigned() ? "S" : FLD_PFX) + "9Comp5(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 350: 
                    case 362: {
                        lineNumberWriter.print("pic9Comp6(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
                        break;
                    }
                    case 353: 
                    case 365: {
                        lineNumberWriter.print("pic9CompN(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ")");
                        break;
                    }
                    case 352: 
                    case 364: {
                        lineNumberWriter.print("pic9CompX(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ")");
                        break;
                    }
                    case 411: {
                        lineNumberWriter.print("picDouble(\"" + string + "\")");
                        break;
                    }
                    case 490: {
                        lineNumberWriter.print("picFloat(\"" + string + "\")");
                        break;
                    }
                    case 723: {
                        lineNumberWriter.print("picShort(\"" + string + "\")");
                        break;
                    }
                    case 539: {
                        lineNumberWriter.print("picInt(\"" + string + "\")");
                        break;
                    }
                    case 572: {
                        lineNumberWriter.print("picLong(\"" + string + "\")");
                        break;
                    }
                    case 789: {
                        lineNumberWriter.print("picNativeShort(\"" + string + "\")");
                        break;
                    }
                    case 787: {
                        lineNumberWriter.print("picNativeInt(\"" + string + "\")");
                        break;
                    }
                    case 788: {
                        lineNumberWriter.print("picNativeLong(\"" + string + "\")");
                        break;
                    }
                    case 727: {
                        lineNumberWriter.print("picSNativeShort(\"" + string + "\")");
                        break;
                    }
                    case 725: {
                        lineNumberWriter.print("picSNativeInt(\"" + string + "\")");
                        break;
                    }
                    case 726: {
                        lineNumberWriter.print("picSNativeLong(\"" + string + "\")");
                        break;
                    }
                    case 510: {
                        lineNumberWriter.print("objectVar(\"" + string + "\")");
                        break;
                    }
                    case 638: {
                        lineNumberWriter.print("pointer(\"" + string + "\")");
                        break;
                    }
                    default: {
                        MSVariableGenerator.printNumericDisplay(variableDeclaration, string, string2, lineNumberWriter);
                        break;
                    }
                }
            } else {
                MSVariableGenerator.printNumericDisplay(variableDeclaration, string, string2, lineNumberWriter);
            }
        } else if (variableDeclaration.isEdited()) {
            lineNumberWriter.print("picAlphaEdit(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ", \"" + variableDeclaration.getPicture() + "\")");
        } else if (variableDeclaration.isNational()) {
            if (variableDeclaration.isAnyLength()) {
                lineNumberWriter.print("picNAnyLength(\"" + string + "\")");
            } else {
                lineNumberWriter.print("picN(\"" + string + "\", " + variableDeclaration.getPhisicLen() / 2 + ")");
            }
        } else if (variableDeclaration.isPicG()) {
            if (variableDeclaration.isAnyLength()) {
                lineNumberWriter.print("picGAnyLength(\"" + string + "\")");
            } else {
                lineNumberWriter.print("picG(\"" + string + "\", " + variableDeclaration.getPhisicLen() / 2 + ")");
            }
        } else if (variableDeclaration.isPic1()) {
            if (variableDeclaration.getUsageToken() != null && variableDeclaration.getUsageToken().getToknum() == 303) {
                lineNumberWriter.print("pic1Bit(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ", " + variableDeclaration.getBitOffset() + ", " + variableDeclaration.getLogicLen() + ")");
            } else {
                lineNumberWriter.print("pic1(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ")");
            }
        } else if (variableDeclaration.isAnyLength()) {
            lineNumberWriter.print("picXAnyLength(\"" + string + "\")");
        } else if (variableDeclaration.getRename1() == null) {
            lineNumberWriter.print("picX(\"" + string + "\", " + variableDeclaration.getPhisicLen() + ")");
        }
    }

    private void addAttributes(VariableDeclaration variableDeclaration, String string, LineNumberWriter lineNumberWriter) {
        Object object;
        if (variableDeclaration.getRedefines() != null) {
            lineNumberWriter.println(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".redefines(\"" + this.getRedefineName(variableDeclaration) + "\");");
        } else if (variableDeclaration.getRename1() != null) {
            lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".renames(\"" + this.getName(variableDeclaration) + "\", \"" + this.getName(variableDeclaration.getRename1()) + "\", ");
            if (variableDeclaration.getRename2() != null) {
                lineNumberWriter.println("\"" + this.getName(variableDeclaration.getRename2()) + "\");");
            } else {
                lineNumberWriter.println("null);");
            }
        }
        if (variableDeclaration.isDynamic()) {
            lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".occursDynamic(");
            if (variableDeclaration.getCapacity() != null) {
                lineNumberWriter.print("\"" + variableDeclaration.getCapacity().getName() + "\", ");
            } else {
                lineNumberWriter.print("(String) null, ");
            }
            if (variableDeclaration.getTo() != null) {
                try {
                    lineNumberWriter.print(FLD_PFX + Integer.parseInt(variableDeclaration.getTo().getWord()));
                }
                catch (Exception exception) {
                    lineNumberWriter.print("0");
                }
            } else {
                lineNumberWriter.print("0");
            }
            lineNumberWriter.println(", " + variableDeclaration.isInitialized() + ");");
        } else if (variableDeclaration.getOccurs() > 0) {
            lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".occurs(" + variableDeclaration.getOccurs() + ", ");
            if (variableDeclaration.getDepending() != null) {
                lineNumberWriter.print("\"" + this.getName(variableDeclaration.getDepending()) + "\", ");
            } else {
                lineNumberWriter.print("null, ");
            }
            object = variableDeclaration.getIndexes();
            if (object != null) {
                lineNumberWriter.print("new String[] {");
                boolean bl = true;
                VariableName variableName = ((VariableNameList)object).getFirst();
                while (variableName != null) {
                    if (bl) {
                        bl = false;
                    } else {
                        lineNumberWriter.print(",");
                    }
                    lineNumberWriter.print(" \"" + variableName.getName() + "\"");
                    variableName = ((VariableNameList)object).getNext();
                }
                lineNumberWriter.print(" }");
            } else {
                lineNumberWriter.print("null");
            }
            lineNumberWriter.println(");");
        }
        if (variableDeclaration.getValueToken() != null && !(variableDeclaration.getParentSection() instanceof LinkageSection)) {
            lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".value(");
            this.printConstVal(variableDeclaration.getValueToken(), lineNumberWriter);
            lineNumberWriter.println(");");
        }
        if ((object = variableDeclaration.getIdentifiedToken()) != null || variableDeclaration.getIdentifiedVar() != null) {
            lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".xmlIdentifier(");
            if (object != null) {
                this.printConstVal((Token)object, lineNumberWriter);
            } else {
                lineNumberWriter.print("\"" + this.getName(variableDeclaration.getIdentifiedVar()) + "\"");
            }
            lineNumberWriter.print(")");
            if (variableDeclaration.getCountIn() != null) {
                lineNumberWriter.print(".xmlCount(\"" + this.getName(variableDeclaration.getCountIn()) + "\")");
            }
            if (variableDeclaration.getNamespaceToken() != null) {
                lineNumberWriter.print(".xmlNamespace(");
                this.printConstVal(variableDeclaration.getNamespaceToken(), lineNumberWriter);
                lineNumberWriter.print(")");
            } else if (variableDeclaration.getNamespaceVar() != null) {
                lineNumberWriter.print(".xmlNamespace(\"" + this.getName(variableDeclaration.getNamespaceVar()) + "\")");
            }
            if (variableDeclaration.isAttribute()) {
                lineNumberWriter.print(".xmlAttribute(true)");
            }
            if (variableDeclaration.isProcessingInstruction()) {
                lineNumberWriter.print(".xmlProcessingInstruction(true)");
            }
            if (variableDeclaration.isRaw()) {
                lineNumberWriter.print(".xmlRaw(true)");
            }
            if (variableDeclaration.isBase64Binary()) {
                lineNumberWriter.print(".xmlBase64Binary(true)");
            }
            if (variableDeclaration.isHexBinary()) {
                lineNumberWriter.print(".xmlHexBinary(true)");
            }
            if (variableDeclaration.isNullable()) {
                lineNumberWriter.print(".xmlNullable(true)");
            }
            if (variableDeclaration.isBoolean()) {
                lineNumberWriter.print(".xmlBoolean(true)");
            }
            if (variableDeclaration.isCdata()) {
                lineNumberWriter.print(".xmlCdata(true)");
            }
            lineNumberWriter.println(";");
        }
    }

    private static void printNumericDisplay(VariableDeclaration variableDeclaration, String string, String string2, LineNumberWriter lineNumberWriter) {
        boolean bl;
        String string3 = "pic";
        if (variableDeclaration.isSigned()) {
            string3 = string3 + "S";
        }
        string3 = (bl = variableDeclaration.is9Display()) ? string3 + "9" : string3 + "9Comp4";
        lineNumberWriter.print(string3 + "(\"" + string + "\", " + (variableDeclaration.getLogicLen() - variableDeclaration.getDecimals()) + ", " + variableDeclaration.getDecimals() + ")");
        if (bl) {
            if (variableDeclaration.isSignLeading()) {
                lineNumberWriter.print(".signLeading(true)");
            }
            if (variableDeclaration.isSignSeparate()) {
                lineNumberWriter.print(".signSeparate(true)");
            }
        }
    }

    private void printCondName(VariableDeclaration variableDeclaration, String string, LineNumberWriter lineNumberWriter) {
        lineNumberWriter.print(string + MSVariableGenerator.getCVHName(variableDeclaration) + ".condName(\"" + this.getName(variableDeclaration) + "\", ");
        Token token = variableDeclaration.getFalseValue();
        if (token != null) {
            this.printConstVal(token, lineNumberWriter);
            lineNumberWriter.print(", ");
        } else {
            lineNumberWriter.print("null, ");
        }
        for (int i2 = 0; i2 < variableDeclaration.getValuesCount(); ++i2) {
            if (i2 > 0) {
                lineNumberWriter.print(", ");
            }
            lineNumberWriter.print("new com.iscobol.rts.ICobolVar[] { ");
            this.printConstVal(variableDeclaration.getLowValue(i2), lineNumberWriter);
            if (variableDeclaration.getHighValue(i2) != null) {
                lineNumberWriter.print(", ");
                this.printConstVal(variableDeclaration.getHighValue(i2), lineNumberWriter);
            }
            lineNumberWriter.print(" }");
        }
        lineNumberWriter.println(");");
    }

    private void printConstVal(Token token, LineNumberWriter lineNumberWriter) {
        lineNumberWriter.print(token.getLiteralFactory("false", true, true));
    }

    private void writeScreen(Vector<Vd> vector, String string, LineNumberWriter lineNumberWriter, StringBuffer stringBuffer) throws Exception {
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence;
            Vd vd = vector.elementAt(i2);
            lineNumberWriter.print(this.pcc.tm.getCommentCode(vd.var.getNameToken(), string));
            Vector<Vd> vector2 = vd.children;
            if (vector2 != null && vector2.size() > 0) {
                CharSequence charSequence2;
                charSequence = vd.var.getDeclUnivoqueName();
                String string2 = Character.toUpperCase(((String)charSequence).charAt(0)) + ((String)charSequence).substring(1);
                if (vd.var.getLevel() == 1) {
                    String string3;
                    Iterator<String> iterator;
                    charSequence2 = this.pkgName + "." + this.UI_PKG;
                    String string4 = this.path + File.separator + this.UI_PKG;
                    File file = new File(string4);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    lineNumberWriter.println(string + "public " + (String)charSequence2 + "." + string2 + " " + (String)charSequence + ";");
                    this.classToBeRemoved.add(new String[]{string4, string2});
                    boolean bl = this.pcc.getTokenManager().hasResources();
                    String string5 = string + "init_" + PROG_KEY + "(cvh, params";
                    if (bl) {
                        string5 = string5 + ", resourceMap";
                    }
                    string5 = string5 + ");" + Verb.eol + string.substring(3) + "}" + Verb.eol + string.substring(3) + "private void init_" + PROG_KEY + "(final CobolVarHelper cvh, ScreenGroupParams params";
                    if (bl) {
                        string5 = string5 + ", Map<String, ICobolVar> resourceMap";
                    }
                    string5 = string5 + ") {";
                    LineNumberWriter lineNumberWriter2 = new LineNumberWriter(PreProcessor.newPrintWriter(string4 + File.separator + string2 + ".java", true), string5, this.prog);
                    lineNumberWriter2.println("package " + (String)charSequence2 + ";");
                    lineNumberWriter2.println("import " + this.typesPkg + ".*;");
                    lineNumberWriter2.println("import com.iscobol.java.*;");
                    if (this.cp) {
                        lineNumberWriter2.println("import com.iscobol.java.generator.ScreenGroupParams;");
                    }
                    lineNumberWriter2.println("import " + this.genPkg + ".*;");
                    lineNumberWriter2.println("import com.iscobol.gui.*;");
                    lineNumberWriter2.println("import com.iscobol.gui.server.*;");
                    lineNumberWriter2.println("import com.iscobol.rts.CobValue;");
                    lineNumberWriter2.println("import com.iscobol.rts.ICobolVar;");
                    lineNumberWriter2.println("import java.util.Map;");
                    lineNumberWriter2.println("public class " + string2 + " extends ScreenGroup {");
                    CobolProgram cobolProgram = this.pcc.getCobolProgram();
                    cobolProgram.registerScreenAttrs = true;
                    StringBuffer stringBuffer2 = new StringBuffer("      " + (String)charSequence + " = ");
                    vd.var.getCode(stringBuffer2);
                    lineNumberWriter2.println("   public BaseGUIControl " + (String)charSequence + ";");
                    this.writeScreen(vector2, "   ", lineNumberWriter2, stringBuffer2);
                    Map<String, String> map = null;
                    Map<String, String> map2 = null;
                    Map<String, String> map3 = null;
                    cobolProgram.registerScreenAttrs = false;
                    map = cobolProgram.screenVars;
                    map2 = cobolProgram.screenObjVars;
                    map3 = cobolProgram.screenProcs;
                    cobolProgram.screenVars = new LinkedHashMap<String, String>();
                    cobolProgram.screenNames = new HashSet();
                    cobolProgram.screenObjVars = new LinkedHashMap<String, String>();
                    cobolProgram.screenProcs = new LinkedHashMap<String, String>();
                    lineNumberWriter2.print("   public " + string2 + "(final CobolVarHelper cvh, ScreenGroupParams params");
                    if (bl) {
                        lineNumberWriter2.print(", Map<String, ICobolVar> resourceMap");
                    }
                    lineNumberWriter2.println(") {");
                    lineNumberWriter2.print("      super(cvh");
                    if (bl) {
                        lineNumberWriter2.print(", resourceMap");
                    }
                    lineNumberWriter2.println(");");
                    lineNumberWriter2.init(200);
                    lineNumberWriter2.print(stringBuffer2.toString());
                    lineNumberWriter2.println("   }");
                    lineNumberWriter2.println("}");
                    lineNumberWriter2.close();
                    String string6 = "params" + (String)charSequence;
                    stringBuffer.append("   ");
                    stringBuffer.append(string);
                    stringBuffer.append("ScreenGroupParams " + string6 + " = new ScreenGroupParams();");
                    stringBuffer.append(Verb.eol);
                    VariableDeclaration variableDeclaration = cobolProgram.getSNCrtStatus();
                    if (variableDeclaration != null) {
                        stringBuffer.append("   ");
                        stringBuffer.append(string);
                        stringBuffer.append(string6);
                        stringBuffer.append(".setCrtStatus(");
                        stringBuffer.append(variableDeclaration.getUnivoqueName());
                        stringBuffer.append(");");
                        stringBuffer.append(Verb.eol);
                    }
                    if ((variableDeclaration = cobolProgram.getSNEventStatus()) != null) {
                        stringBuffer.append("   ");
                        stringBuffer.append(string);
                        stringBuffer.append(string6);
                        stringBuffer.append(".setEventStatus(");
                        stringBuffer.append(variableDeclaration.getUnivoqueName());
                        stringBuffer.append(");");
                        stringBuffer.append(Verb.eol);
                    }
                    if ((variableDeclaration = cobolProgram.getSNScreenControl()) != null) {
                        stringBuffer.append("   ");
                        stringBuffer.append(string);
                        stringBuffer.append(string6);
                        stringBuffer.append(".setScreenControl(");
                        stringBuffer.append(variableDeclaration.getUnivoqueName());
                        stringBuffer.append(");");
                        stringBuffer.append(Verb.eol);
                    }
                    if (!map.isEmpty()) {
                        iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append("   ");
                            stringBuffer.append(string);
                            stringBuffer.append(string6);
                            stringBuffer.append(".set(\"");
                            string3 = iterator.next();
                            stringBuffer.append(map.get(string3));
                            stringBuffer.append("\", ");
                            stringBuffer.append(string3);
                            stringBuffer.append(");");
                            stringBuffer.append(Verb.eol);
                        }
                    }
                    if (!map3.isEmpty()) {
                        iterator = map3.keySet().iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append("   ");
                            stringBuffer.append(string);
                            stringBuffer.append(string6);
                            stringBuffer.append(".set(\"");
                            string3 = iterator.next();
                            stringBuffer.append(map3.get(string3));
                            stringBuffer.append("\", ");
                            stringBuffer.append(string3);
                            stringBuffer.append(");");
                            stringBuffer.append(Verb.eol);
                        }
                    }
                    stringBuffer.append("   ");
                    stringBuffer.append(string);
                    stringBuffer.append((String)charSequence);
                    stringBuffer.append(" = new ");
                    stringBuffer.append((String)charSequence2);
                    stringBuffer.append(".");
                    stringBuffer.append(string2);
                    stringBuffer.append("(new CobolVarHelper(\"");
                    stringBuffer.append(vd.var.getName());
                    stringBuffer.append("\", ");
                    stringBuffer.append(this.options);
                    stringBuffer.append("), ");
                    stringBuffer.append(string6);
                    if (bl) {
                        stringBuffer.append(", resourceMap");
                    }
                    stringBuffer.append(");");
                    stringBuffer.append(Verb.eol);
                    if (map2.isEmpty()) continue;
                    iterator = map2.keySet().iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(string);
                        stringBuffer.append("   ");
                        string3 = iterator.next();
                        stringBuffer.append(string3);
                        stringBuffer.append(" = ");
                        stringBuffer.append(string6);
                        stringBuffer.append(".get");
                        String string7 = map2.get(string3);
                        int n3 = string7.indexOf(32);
                        if (n3 > 0) {
                            stringBuffer.append(string7.substring(0, n3));
                            string7 = string7.substring(n3 + 1);
                        } else {
                            stringBuffer.append("Value");
                        }
                        stringBuffer.append("(\"");
                        stringBuffer.append(string7);
                        stringBuffer.append("\");");
                        stringBuffer.append(Verb.eol);
                    }
                    continue;
                }
                charSequence2 = new StringBuffer();
                if (vd.var.getOccurs() <= 1) {
                    charSequence2.append((String)charSequence + " = ");
                }
                lineNumberWriter.print(vd.var.getCode((StringBuffer)charSequence2));
                stringBuffer.append("   ").append(string).append((StringBuffer)charSequence2);
                this.writeScreen(vector2, string, lineNumberWriter, stringBuffer);
                continue;
            }
            if (vd.var.getOccursAll() != 0 && vd.var.getOccurs() <= 1) continue;
            charSequence = new StringBuffer();
            lineNumberWriter.print(vd.var.getCode((StringBuffer)charSequence));
            stringBuffer.append("   ").append(string).append((StringBuffer)charSequence);
        }
    }

    private void write(Vector<Vd> vector, boolean bl, String string, int n2, LineNumberWriter lineNumberWriter) throws Exception {
        String string2 = string;
        for (Vd vd : vector) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n3 = vd.var.getNameToken().getFileIndex();
            FileObject fileObject = this.getFileObject(n3, this.allPPs.elementAt(n3).getOrigFilename(), this.allPPs.elementAt(n3).getReplacingString());
            if (n3 != n2) {
                PreProcessor preProcessor;
                object4 = fileObject;
                while ((object3 = (preProcessor = this.allPPs.elementAt(((FileObject)object4).index)).getParent()) != null) {
                    object2 = this.getFileObject(preProcessor.parentFileIndex, this.allPPs.elementAt(preProcessor.parentFileIndex).getOrigFilename(), this.allPPs.elementAt(preProcessor.parentFileIndex).getReplacingString());
                    if (((FileObject)object4).writeDecl) break;
                    ((FileObject)object2).out.peek().println(string + "public " + this.COPY_PKG + "." + ((FileObject)object4).className + " " + ((FileObject)object4).fieldName + ";");
                    ((FileObject)object4).writeDecl = true;
                    object4 = object2;
                }
                lineNumberWriter = fileObject.out.peek();
                string = n3 == 0 ? string2 : "   ";
            }
            n2 = n3;
            lineNumberWriter.print(this.pcc.tm.getCommentCode(vd.var.getNameToken(), string));
            if (vd.var.getLevel() == 78) {
                lineNumberWriter.print(string + "public final " + vd.var.getTypeName() + " " + vd.var.getDeclUnivoqueName() + " = ");
                this.printConstVal(vd.var.getValueToken(), lineNumberWriter);
                lineNumberWriter.println(";");
                continue;
            }
            object4 = vd.children;
            boolean bl2 = vd.hasRealChildren;
            if (bl2) {
                if (MSVariableGenerator.isRootElem(vd.var, n3)) {
                    Select select;
                    FileDescriptor fileDescriptor;
                    Object object5;
                    object3 = this.pkgName;
                    object2 = this.path;
                    object = vd.var.getDeclUnivoqueName();
                    String string3 = Character.toUpperCase(((String)object).charAt(0)) + ((String)object).substring(1);
                    if (fileObject.index > 0) {
                        object3 = this.COPY_PKG + "." + fileObject.pkgName;
                        object2 = this.od + File.separator + this.COPY_PKG + File.separator + fileObject.pkgName;
                        object5 = new File((String)object2);
                        if (!((File)object5).exists()) {
                            ((File)object5).mkdirs();
                        }
                    }
                    lineNumberWriter.println(string + "public " + (String)object3 + "." + string3 + " " + (String)object + ";");
                    this.classToBeRemoved.add(new String[]{object2, string3});
                    object5 = "      init_$prog$(cvh, cvhext);" + Verb.eol + "   }" + Verb.eol + "   private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                    LineNumberWriter lineNumberWriter2 = new LineNumberWriter(PreProcessor.newPrintWriter((String)object2 + File.separator + string3 + ".java", true), (String)object5, this.prog);
                    fileObject.out.push(lineNumberWriter2);
                    lineNumberWriter2.println("package " + (String)object3 + ";");
                    lineNumberWriter2.println("import " + this.typesPkg + ".*;");
                    lineNumberWriter2.println("import com.iscobol.java.*;");
                    lineNumberWriter2.println("import " + this.genPkg + ".*;");
                    lineNumberWriter2.println("public class " + string3 + " extends VarGroup {");
                    lineNumberWriter2.println("   public PicX $group$;");
                    this.write((Vector<Vd>)object4, false, "   ", n2, lineNumberWriter2);
                    lineNumberWriter2.println("   public " + string3 + "(CobolVarHelper cvh) {");
                    lineNumberWriter2.println("      super(cvh);");
                    lineNumberWriter2.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    String string4 = this.getName(vd.var);
                    lineNumberWriter2.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".group(\"" + string4 + "\");");
                    if (vd.var.getParentSection() instanceof FileDescriptor && (fileDescriptor = (FileDescriptor)vd.var.getParentSection()).getSelect() != null && (select = fileDescriptor.getSelect().getSameRecordArea()) != null) {
                        lineNumberWriter2.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".redefines(\"" + select.getFD().getVirtualParent().getName() + "\");");
                    }
                    this.addAttributes(vd.var, string + "   ", lineNumberWriter2);
                    lineNumberWriter2.init();
                    this.writeInit((Vector<Vd>)object4, false, "      ", n2, lineNumberWriter2);
                    lineNumberWriter2.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".endGroup(); // end group " + string4);
                    lineNumberWriter2.println("   }");
                    lineNumberWriter2.println("   public void createVars(final CobolVarHelper cvh) {");
                    lineNumberWriter2.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    lineNumberWriter2.println("      $group$ = (PicX) " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + string4 + "\");");
                    lineNumberWriter2.init();
                    this.writeCreateVars((Vector<Vd>)object4, false, "      ", n2, lineNumberWriter2);
                    lineNumberWriter2.println("   }");
                    lineNumberWriter2.println("}");
                    lineNumberWriter2.close();
                    fileObject.out.pop();
                } else {
                    object3 = vd.var.getTypeName();
                    lineNumberWriter.println(string + "public " + (String)object3 + " " + vd.var.getDeclUnivoqueName() + ";");
                    this.write((Vector<Vd>)object4, false, "   ", n2, lineNumberWriter);
                }
            } else {
                object3 = vd.var.getTypeName();
                if (vd.var.isObjectReference() && vd.var.getOccurs() > 0) {
                    object3 = (String)object3 + "[]";
                }
                lineNumberWriter.println(string + "public " + (String)object3 + " " + vd.var.getDeclUnivoqueName() + ";");
                if (object4 != null) {
                    object2 = ((Vector)object4).iterator();
                    while (object2.hasNext()) {
                        object = (Vd)object2.next();
                        if (((Vd)object).var.getLevel() != 88) continue;
                        lineNumberWriter.println(string + "public CondName " + ((Vd)object).var.getDeclUnivoqueName() + ";");
                    }
                }
            }
            object3 = MSVariableGenerator.getImplicitVars(vd.var);
            object2 = ((VariableNameList)object3).getFirst();
            while (object2 != null) {
                lineNumberWriter.println(string + "public NumericVar " + ((VariableName)object2).getVarDecl().getDeclUnivoqueName() + ";");
                object2 = ((VariableNameList)object3).getNext();
            }
        }
    }

    static String getSectionObjectName(IDataSection iDataSection) {
        if (iDataSection instanceof ThreadLocalStorageSection) {
            return TLSS_OBJ;
        }
        if (iDataSection instanceof LocalStorageSection) {
            return LSS_OBJ;
        }
        return null;
    }

    private static VariableNameList getImplicitVars(VariableDeclaration variableDeclaration) {
        VariableNameList variableNameList;
        VariableNameList variableNameList2 = new VariableNameList();
        if (variableDeclaration.getCapacity() != null) {
            variableNameList2.addItem(variableDeclaration.getCapacity());
        }
        if ((variableNameList = variableDeclaration.getIndexes()) != null) {
            VariableName variableName = variableNameList.getFirst();
            while (variableName != null) {
                variableNameList2.addItem(variableName);
                variableName = variableNameList.getNext();
            }
        }
        return variableNameList2;
    }

    private static String getCVHName(VariableDeclaration variableDeclaration) {
        return variableDeclaration.isExternal() ? "cvhext" : "cvh";
    }

    private String getName(VariableName variableName) {
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        if (variableDeclaration != null) {
            return this.getName(variableDeclaration);
        }
        return variableName.getName();
    }

    private String getRedefineName(VariableDeclaration variableDeclaration) {
        try {
            VariableDeclaration variableDeclaration2 = variableDeclaration.findRedefine();
            if (variableDeclaration2 != null) {
                return this.getName(variableDeclaration2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return variableDeclaration.getRedefines().getName();
    }

    private String getName(VariableDeclaration variableDeclaration) {
        String string = variableDeclaration.getName();
        int n2 = variableDeclaration.getProg();
        if (n2 > 0) {
            if (variableDeclaration.isFiller()) {
                string = string + "-" + n2;
                Token token = variableDeclaration.getNameToken();
                if (token.getFileIndex() > 0) {
                    string = string + " of " + new File(token.getFileName()).getName().toLowerCase();
                }
            } else {
                VariableDeclaration variableDeclaration2 = variableDeclaration.getParent();
                if (variableDeclaration2 != null) {
                    while (variableDeclaration2.getParent() != null) {
                        variableDeclaration2 = variableDeclaration2.getParent();
                    }
                    string = string + " of " + variableDeclaration2.getName();
                }
            }
        }
        return string;
    }

    private static boolean isRootElem(VariableDeclaration variableDeclaration, int n2) {
        int n3 = variableDeclaration.getLevel();
        switch (n3) {
            case 0: {
                return true;
            }
            case 1: {
                return !(variableDeclaration.getParentSection() instanceof FileDescriptor);
            }
        }
        return n2 > variableDeclaration.getParent().getNameToken().getFileIndex();
    }

    public int getOptions() {
        return this.options;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("abstract");
        hashSet.add("assert");
        hashSet.add("boolean");
        hashSet.add("break");
        hashSet.add("byte");
        hashSet.add("case");
        hashSet.add("catch");
        hashSet.add("char");
        hashSet.add("class");
        hashSet.add("const");
        hashSet.add("continue");
        hashSet.add("default");
        hashSet.add("do");
        hashSet.add("double");
        hashSet.add("else");
        hashSet.add("enum");
        hashSet.add("extends");
        hashSet.add("false");
        hashSet.add("final");
        hashSet.add("finally");
        hashSet.add("float");
        hashSet.add("for");
        hashSet.add("goto");
        hashSet.add("if");
        hashSet.add("implements");
        hashSet.add("import");
        hashSet.add("instanceof");
        hashSet.add("int");
        hashSet.add("interface");
        hashSet.add("long");
        hashSet.add("native");
        hashSet.add("new");
        hashSet.add("null");
        hashSet.add("package");
        hashSet.add("private");
        hashSet.add("protected");
        hashSet.add("public");
        hashSet.add("return");
        hashSet.add("short");
        hashSet.add("static");
        hashSet.add("strictfp");
        hashSet.add("super");
        hashSet.add("switch");
        hashSet.add("synchronized");
        hashSet.add("this");
        hashSet.add("throw");
        hashSet.add("throws");
        hashSet.add("transient");
        hashSet.add("true");
        hashSet.add("try");
        hashSet.add("void");
        hashSet.add("volatile");
        hashSet.add("while");
        javaKeywords = Collections.unmodifiableSet(hashSet);
    }

    private static class FileObject {
        String replacing;
        Stack<LineNumberWriter> out = new Stack();
        final int index;
        boolean writeDef;
        boolean writeInit;
        boolean writeDecl;
        String className;
        String fieldName;
        String pkgName;
        String hdr;
        String hdr2;

        FileObject(int n2) {
            this.index = n2;
        }
    }

    public static class Vd {
        final VariableDeclaration var;
        Vector<Vd> children;
        boolean hasRealChildren;

        Vd(VariableDeclaration variableDeclaration) {
            this.var = variableDeclaration;
        }

        public String toString() {
            return this.var != null ? this.var.toString() : "<void>";
        }
    }

    public static enum Type {
        WORKING_STORAGE_SECTION,
        LINKAGE_SECTION,
        LOCAL_STORAGE_SECTION,
        THREAD_LOCAL_STORAGE_SECTION,
        SCREEN_SECTION;

    }

    private static class LineNumberWriter {
        final PrintWriter pw;
        int lineNumber;
        int maxLines = Integer.MAX_VALUE;
        final String text;
        final int[] prog;

        LineNumberWriter(PrintWriter printWriter, String string, int[] nArray) {
            this.pw = printWriter;
            this.text = string;
            this.prog = nArray;
        }

        void init() {
            this.init(1000);
        }

        void init(int n2) {
            this.lineNumber = 0;
            this.maxLines = n2;
        }

        void print(String string) {
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (cArray[i2] != '\n') continue;
                if (this.lineNumber == this.maxLines) {
                    this.pw.print(string.substring(n3, i2 + 1));
                    this.prog[0] = this.prog[0] + 1;
                    this.pw.println(this.text.replace(MSVariableGenerator.PROG_KEY, MSVariableGenerator.FLD_PFX + this.prog[0]));
                    this.lineNumber = 0;
                    n3 = i2 + 1;
                    ++i2;
                    continue;
                }
                ++this.lineNumber;
            }
            this.pw.print(string.substring(n3));
        }

        void println(String string) {
            this.print(string + Verb.eol);
        }

        void close() {
            this.pw.close();
        }
    }
}

