/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Set;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import java.util.Vector;

public class Move
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final boolean cudcOpt;
    private final boolean _cp;
    private final boolean _cv;
    private final boolean _xxm28529;
    private boolean _cmc;
    private VariableName fromVar;
    private Token fromToken;
    private VariableNameList to;
    private VariableNameList toConv;
    private boolean corresponding;
    private boolean positional;
    private boolean delimitedDefault;
    private boolean conversion;
    private Block exceptionBlock;
    private Block notExceptionBlock;
    private boolean not;
    private boolean moveJava;
    private boolean moveJavaToVar;
    private boolean moveNull;
    private Vector posVars;

    public Move(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.cudcOpt = this.pc.getOption("-cudc") != null;
        this._cp = this.pc.getOption("-cp") != null;
        this._cv = this.pc.getOption("-cv") != null;
        this._xxm28529 = this.pc.getOption("-xxm28529") != null;
        this.to = new VariableNameList();
        this.toConv = new VariableNameList();
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 381 || token2.getToknum() == 380) {
            this.moveCorr(token2);
        } else if (token2.getToknum() == 10009 && token2.getWord().equals("POSITIONAL")) {
            this.movePos(token2);
        } else {
            this.moveTo(token2);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 437) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private static void getPositionalItems(Vector vector, VariableDeclarationList variableDeclarationList) {
        if (variableDeclarationList != null) {
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.level != 88 && variableDeclaration.level != 78 && variableDeclaration.redefines == null) {
                    vector.addElement(variableDeclaration);
                    int n2 = vector.size();
                    Move.getPositionalItems(vector, variableDeclaration.children);
                    if (vector.size() > n2) {
                        vector.removeElementAt(n2 - 1);
                    }
                }
                variableDeclaration = variableDeclarationList.getNext();
            }
        }
    }

    private static void getPositionalDelimitedItems(Vector vector, VariableDeclarationList variableDeclarationList) {
        if (variableDeclarationList != null) {
            VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
            while (variableDeclaration != null) {
                if (variableDeclaration.level != 88 && variableDeclaration.level != 78 && variableDeclaration.redefines == null) {
                    boolean bl = variableDeclaration.isOccursClause();
                    boolean bl2 = variableDeclaration.isDynamic();
                    Vector vector2 = bl ? new Vector() : vector;
                    int n2 = vector2.size();
                    Move.getPositionalDelimitedItems(vector2, variableDeclaration.children);
                    Item item = null;
                    if (vector2.size() > n2) {
                        if (bl) {
                            item = new Item(variableDeclaration, vector2, bl, bl2);
                        }
                    } else {
                        item = new Item(variableDeclaration, bl, bl2);
                    }
                    if (item != null) {
                        if (bl) {
                            int n3;
                            for (n3 = 0; n3 < vector.size(); ++n3) {
                                if (((Item)vector.elementAt((int)n3)).occurs) continue;
                                vector.add(n3, item);
                                break;
                            }
                            if (n3 == vector.size()) {
                                vector.addElement(item);
                            }
                        } else {
                            vector.addElement(item);
                        }
                    }
                }
                variableDeclaration = variableDeclarationList.getNext();
            }
        }
    }

    private void getPositionalMoves(Vector vector, Vector vector2) throws GeneralErrorException {
        int n2 = 0;
        for (int i2 = 0; n2 < vector.size() && i2 < vector2.size(); ++n2, ++i2) {
            VariableDeclaration variableDeclaration;
            VariableDeclaration variableDeclaration2 = (VariableDeclaration)vector.elementAt(n2);
            if (this.illegalMove(variableDeclaration2, variableDeclaration = (VariableDeclaration)vector2.elementAt(i2))) {
                throw new GeneralErrorException(59, 4, variableDeclaration.getNameToken(), variableDeclaration.getName(), this.error);
            }
            this.posVars.addElement(new VariableDeclaration[]{variableDeclaration2, variableDeclaration});
        }
    }

    private void getPositionalDelimitedMoves(Vector vector, Vector vector2, boolean bl) throws GeneralErrorException {
        if (vector.size() != vector2.size()) {
            throw new GeneralErrorException(259, 4, this.to.getFirst().getNameToken(), this.to.getFirst().getName(), this.error);
        }
        int n2 = 0;
        for (int i2 = 0; n2 < vector.size() && i2 < vector2.size(); ++n2, ++i2) {
            Item item = (Item)vector.elementAt(n2);
            Item item2 = (Item)vector2.elementAt(i2);
            if (item.isGroup() != item2.isGroup() || item.occurs != item2.occurs) {
                throw new GeneralErrorException(259, 4, this.to.getFirst().getNameToken(), this.to.getFirst().getName(), this.error);
            }
            if (item2.vd.isDynamic() && !item2.vd.isDynamicInitialized()) {
                this.error.print(263, 2, item2.vd.getNameToken(), item2.vd.getName());
            }
            if (item.isGroup()) {
                this.getPositionalDelimitedMoves(item.grp, item2.grp, bl || item2.vd.isDynamic());
                continue;
            }
            if (this.illegalMove(item.vd, item2.vd)) {
                throw new GeneralErrorException(59, 4, item2.vd.getNameToken(), item2.vd.getName(), this.error);
            }
            if (!bl && !item2.vd.isDynamic() || item2.vd.getValueToken() != null || item2.vd.hasParentValue()) continue;
            this.error.print(262, 2, item2.vd.getNameToken(), item2.vd.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void movePos(Token token) throws GeneralErrorException, EndOfProgramException {
        this.positional = true;
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.fromVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.fromVar.hasSubValue()) {
            throw new GeneralErrorException(37, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() != 773) {
            throw new ExpectedFoundException(token, this.error, "TO");
        }
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(156, 4, token, "", this.error);
        }
        this.tm.ungetToken();
        VariableName variableName = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (variableName.hasSubValue()) {
            throw new GeneralErrorException(37, 4, variableName.getNameToken(), variableName.getName(), this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() == 398) {
            token = this.tm.getToken();
            if (token.getToknum() == 312) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 396) throw new UnexpectedTokenException(token, this.error);
            this.delimitedDefault = true;
            token = this.tm.getToken();
            if (token.getToknum() != 803) {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
        Vector vector = new Vector();
        if (this.delimitedDefault) {
            Move.getPositionalDelimitedItems(vector, this.fromVar.getVarDecl().children);
        } else {
            Move.getPositionalItems(vector, this.fromVar.getVarDecl().children);
        }
        if (vector.size() == 0) {
            throw new GeneralErrorException(37, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
        }
        Vector vector2 = new Vector();
        if (this.delimitedDefault) {
            Move.getPositionalDelimitedItems(vector2, variableName.getVarDecl().children);
        } else {
            Move.getPositionalItems(vector2, variableName.getVarDecl().children);
        }
        if (vector2.size() == 0) {
            throw new GeneralErrorException(37, 4, variableName.getNameToken(), variableName.getName(), this.error);
        }
        this.to.addItem(variableName);
        this.posVars = new Vector();
        if (this.delimitedDefault) {
            boolean bl;
            boolean bl2;
            this.getPositionalDelimitedMoves(vector, vector2, false);
            int n2 = this.fromVar.getIndexes() != null ? this.fromVar.getIndexes().getItemNum() : 0;
            int n3 = this.fromVar.getVarDecl().getDyDimension();
            boolean bl3 = bl2 = n3 > n2;
            if (!bl2) {
                n3 = this.fromVar.getVarDecl().getDimension();
                bl3 = n3 > n2;
            }
            int n4 = variableName.getIndexes() != null ? variableName.getIndexes().getItemNum() : 0;
            int n5 = variableName.getVarDecl().getDyDimension();
            boolean bl4 = bl = n5 > n4;
            if (!bl) {
                n5 = variableName.getVarDecl().getDimension();
                bl4 = n5 > n4;
            }
            this.posVars.addElement(new Item[]{new Item(this.fromVar.getVarDecl(), vector, bl3, bl2), new Item(variableName.getVarDecl(), vector2, bl4, bl)});
        } else {
            this.getPositionalMoves(vector, vector2);
        }
        this.fromVar.getVarDecl().setUsedAll();
        variableName.getVarDecl().setUsedAll();
    }

    private void moveCorr(Token token) throws GeneralErrorException, EndOfProgramException {
        this.corresponding = true;
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, token, token.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.fromVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        this.fromVar.getVarDecl().setUsedAll();
        VariableDeclarationList variableDeclarationList = this.fromVar.getVarDecl().getChildren();
        if (variableDeclarationList.getItemNum() < 1) {
            throw new GeneralErrorException(37, 4, token, token.getWord(), this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() != 773) {
            throw new ExpectedFoundException(token, this.error, "TO");
        }
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(156, 4, token, "", this.error);
        }
        this.tm.ungetToken();
        VariableName variableName = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (variableName.isSetGetProperty()) {
            throw new GeneralErrorException(75, 4, variableName.getNameToken(), variableName.getNameToken().getWord(), this.error);
        }
        variableName.getVarDecl().setUsedAll();
        VariableDeclarationList variableDeclarationList2 = variableName.getVarDecl().getChildren();
        if (variableDeclarationList2.getItemNum() < 1) {
            throw new GeneralErrorException(37, 4, token, token.getWord(), this.error);
        }
        String string = this.illegalMoveCorr(this.fromVar, variableName);
        if (!string.equals("")) {
            throw new GeneralErrorException(59, 4, variableName.getNameToken(), string, this.error);
        }
        this.to.addItem(variableName);
    }

    private void moveTo(Token token) throws GeneralErrorException, EndOfProgramException {
        Object object;
        Object object2;
        MyClass myClass;
        switch (token.getToknum()) {
            case 480: 
            case 780: {
                this.moveJava = true;
                this.fromToken = token;
                break;
            }
            case 10001: 
            case 10002: 
            case 10017: {
                if (token.isNull()) {
                    this.moveJava = true;
                    this.moveNull = true;
                    break;
                }
                this.fromToken = token;
                break;
            }
            case 10009: {
                if (token.isAll()) {
                    this.error.print(219, 3, token, "ALL " + token.getWord());
                }
                this.tm.ungetToken();
                this.fromVar = VariableName.getAny(this.tm, this.error, null, this.pc, GetVarOpts.DYN_GRP_ALLOW);
                if (this.fromVar == null || !this.fromVar.isObjectReference() && !this.fromVar.isPrimitive()) break;
                myClass = this.fromVar.getType();
                if (myClass != null && myClass.getName().equals("void")) {
                    throw new GeneralErrorException(149, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
                }
                if (this.fromVar.isFactory()) {
                    throw new GeneralErrorException(81, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
                }
                this.moveJavaToVar = true;
                break;
            }
            default: {
                throw new UnexpectedTokenException(this.keyWord, this.error);
            }
        }
        token = this.tm.getToken();
        if (token.getToknum() != 773) {
            throw new ExpectedFoundException(token, this.error, "TO");
        }
        while ((token = this.tm.getToken()).getToknum() == 10009) {
            this.tm.ungetToken();
            object2 = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1, true));
            this.moveJava = this.moveJava || this.fromToken != null && ((VariableName)object2).getVarDecl().isPrimitive() || ((VariableName)object2).isObjectReference() && !((VariableName)object2).isCobolVar() || ((VariableName)object2).isPrimitive();
            myClass = ((VariableName)object2).getType();
            if (myClass != null && myClass.getName().equals("void")) {
                throw new GeneralErrorException(149, 4, ((VariableName)object2).getNameToken(), ((VariableName)object2).getName(), this.error);
            }
            if (!this.moveJava && !this.moveJavaToVar) {
                int n2;
                object = new VariableName[]{object2};
                int n3 = n2 = this.fromToken != null ? this.illegalMove(this.fromToken, (VariableName)object2) : this.illegalMove(this.fromVar, (VariableName)object2, (VariableName[])object);
                if (n2 != 0) {
                    throw new GeneralErrorException(n2, 4, ((VariableName)object[0]).getNameToken(), ((VariableName)object[0]).getName(), this.error);
                }
            }
            this.to.addItem((VariableName)object2);
            if (!this._cv || this.tm.getToken().getToknum() == 773) continue;
            this.tm.ungetToken();
        }
        if (this.to.getItemNum() == 0) {
            throw new GeneralErrorException(156, 4, token, "", this.error);
        }
        if (this.moveJava || this.moveJavaToVar) {
            this.tm.ungetToken();
        } else {
            this.moveConvert(token);
            if (this.conversion) {
                this.toConv = this.to;
            } else if (this.fromToken != null && this.fromToken.getToknum() == 10001 || this.fromVar != null && !this.fromVar.isNumeric()) {
                if (this.pc.getOption("-xcaec") != null) {
                    object2 = new VariableNameList();
                    object = this.to.getFirst();
                    while (object != null) {
                        if (((VariableName)object).isNumeric() && ((VariableName)object).isEdited()) {
                            this.toConv.addItem((VariableName)object);
                        } else {
                            ((VariableNameList)object2).addItem((VariableName)object);
                        }
                        object = this.to.getNext();
                    }
                    this.to = object2;
                } else if ((this.fromToken != null && !this.fromToken.isAll() || this.fromVar != null && !this.fromVar.getVarDecl().isGroup()) && this.pc.getOption("-cmc") != null) {
                    this._cmc = true;
                    object2 = new VariableNameList();
                    object = this.to.getFirst();
                    while (object != null) {
                        if (((VariableName)object).isNumeric()) {
                            this.toConv.addItem((VariableName)object);
                        } else {
                            ((VariableNameList)object2).addItem((VariableName)object);
                        }
                        object = this.to.getNext();
                    }
                    this.to = object2;
                }
            }
            if (!this.toConv.isEmpty() && this.pc.getOption("-wmwc") != null) {
                boolean bl = false;
                boolean bl2 = false;
                VariableName variableName = this.toConv.getFirst();
                while (variableName != null) {
                    VariableDeclaration variableDeclaration = variableName.getVarDecl();
                    boolean bl3 = variableName.isNumeric();
                    bl |= bl3;
                    bl2 |= bl3 && !variableDeclaration.isFloatingPoint() && variableDeclaration.getDecimals() == 0;
                    variableName = this.toConv.getNext();
                }
                if (bl) {
                    int n4;
                    int n5 = bl2 ? 31 : 32;
                    int n6 = n4 = this.fromToken != null ? this.fromToken.getRealLength() : this.fromVar.getVariableLength();
                    if (n4 > n5) {
                        Token token2 = this.fromToken != null ? this.fromToken : this.fromVar.getNameToken();
                        this.error.print(233, 2, token2, token2.getWord());
                    }
                }
            }
            if (!this.conversion && !this.to.isEmpty() && this.pc.getOption("-watn") != null && (this.fromToken != null && this.fromToken.getToknum() == 10001 || this.fromVar != null && !this.fromVar.isNumeric())) {
                boolean bl;
                CobolToken cobolToken = this.to.getFirst();
                for (bl = false; cobolToken != null && !bl; bl |= ((VariableName)cobolToken).isNumeric()) {
                    cobolToken = this.to.getNext();
                }
                if (bl) {
                    cobolToken = this.fromToken != null ? this.fromToken : this.fromVar.getNameToken();
                    this.error.print(234, 2, (Token)cobolToken, ((Token)cobolToken).getWord());
                }
            }
        }
    }

    private void moveConvert(Token token) throws GeneralErrorException, EndOfProgramException {
        if (token.getToknum() == 813 && (token = this.tm.getToken()).getToknum() != 377 && token.getToknum() != 376) {
            throw new ExpectedFoundException(token, this.error, "'CONVERSION' | 'CONVERT'");
        }
        if (token.getToknum() != 377 && token.getToknum() != 376) {
            this.tm.ungetToken();
            return;
        }
        this.conversion = true;
        if (this.to.getItemNum() > 1) {
            throw new ExpectedFoundException(this.to.getLast().getNameToken(), this.error, "'WITH'");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 598 || token.getToknum() == 613 || token.getToknum() == 472) {
            boolean bl = false;
            if (token.getToknum() == 598) {
                this.not = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 613) {
                bl = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 472) {
                if (this.not) {
                    this.notExceptionBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.exceptionBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 1);
                }
                TokenManager.Marker marker = this.tm.getMarker();
                this.tm.setMarker(marker);
                token = this.tm.getToken();
                if (!this.not && token.getToknum() == 598) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 613) {
                        token = this.tm.getToken();
                        bl = true;
                    }
                    if (token.getToknum() != 472) {
                        this.tm.rewindToMarker(marker);
                    } else {
                        this.notExceptionBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (bl) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
    }

    private void getCodePositionalDelimited(StringBuffer stringBuffer) {
        stringBuffer.append("{" + eol);
        Item[] itemArray = (Item[])this.posVars.elementAt(0);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("   ");
        stringBuffer.append(this.to.getFirst().getCode());
        stringBuffer.append(".initialize(null, null, false);");
        stringBuffer.append(eol);
        this.getCodePositionalDelimited(itemArray, new SubscriptList[]{this.fromVar.getIndexes(), this.to.getFirst().getIndexes()}, false, new boolean[2], 0, stringBuffer, new StringBuffer(), new StringBuffer());
        stringBuffer.append(eol + this.parent.getIndent() + "}" + eol);
    }

    private void getCodePositionalDelimited(Item[] itemArray, SubscriptList[] subscriptListArray, boolean bl, boolean[] blArray, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        StringBuffer stringBuffer4 = new StringBuffer(this.parent.getIndent() + "   ");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer4.append("   ");
        }
        SubscriptList subscriptList = null;
        SubscriptList subscriptList2 = null;
        int n3 = itemArray[0].grp.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            boolean bl2;
            Item item = (Item)itemArray[0].grp.elementAt(i3);
            Item item2 = (Item)itemArray[1].grp.elementAt(i3);
            VariableName variableName = new VariableName(item.vd);
            VariableName variableName2 = new VariableName(item2.vd);
            subscriptList2 = new SubscriptList();
            if (subscriptListArray[1] != null) {
                subscriptList2.addListObject(subscriptListArray[1]);
            }
            subscriptList = new SubscriptList();
            if (subscriptListArray[0] != null) {
                subscriptList.addListObject(subscriptListArray[0]);
            }
            boolean bl3 = bl2 = blArray[1] || item2.dynamic;
            if (item.occurs) {
                String string = "$idx" + n2 + "_" + Move.getUniqueId();
                String string2 = null;
                if (!item2.dynamic) {
                    string2 = "$toN" + n2 + "_" + Move.getUniqueId();
                }
                String string3 = "$fromN" + n2 + "_" + Move.getUniqueId();
                String string4 = null;
                if (n2 > 0) {
                    string4 = "$ok" + n2 + "_" + Move.getUniqueId();
                }
                stringBuffer.append(stringBuffer4);
                stringBuffer.append("int ");
                Subscript subscript = Subscript.get(string);
                stringBuffer.append(string);
                stringBuffer.append(" = 1;");
                stringBuffer.append(eol);
                if (!item2.dynamic) {
                    stringBuffer.append(stringBuffer4);
                    stringBuffer.append("int ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" = ");
                    stringBuffer.append(variableName2.getCode());
                    stringBuffer.append(".getLastDimension()");
                    stringBuffer.append(";");
                    stringBuffer.append(eol);
                } else if (n2 > 0) {
                    stringBuffer.append(stringBuffer4);
                    stringBuffer.append("boolean ");
                    stringBuffer.append(string4);
                    stringBuffer.append(" = false;");
                    stringBuffer.append(eol);
                }
                stringBuffer.append(stringBuffer4);
                stringBuffer.append("int ");
                stringBuffer.append(string3);
                stringBuffer.append(" = ");
                if (item.dynamic) {
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".getDynamicCapacity");
                    if (subscriptList.getItemNum() == 0) {
                        stringBuffer.append("(new int[0])");
                    } else {
                        subscriptList.getCodeNum(stringBuffer, true);
                    }
                } else {
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".getLastDimension()");
                }
                stringBuffer.append(";");
                stringBuffer.append(eol);
                subscriptList2.addItem(subscript);
                subscriptList.addItem(subscript);
                stringBuffer.append(stringBuffer4);
                stringBuffer.append("for( ; ");
                stringBuffer.append(string);
                stringBuffer.append(" <= ");
                stringBuffer.append(string3);
                if (!item2.dynamic) {
                    stringBuffer.append(" && ");
                    stringBuffer.append(string);
                    stringBuffer.append(" <= ");
                    stringBuffer.append(string2);
                }
                stringBuffer.append("; ");
                stringBuffer.append(string);
                stringBuffer.append("++) {");
                stringBuffer.append(eol);
                if (item.isGroup()) {
                    StringBuffer stringBuffer5 = new StringBuffer();
                    StringBuffer stringBuffer6 = new StringBuffer();
                    StringBuffer stringBuffer7 = new StringBuffer();
                    this.getCodePositionalDelimited(new Item[]{item, item2}, new SubscriptList[]{subscriptList, subscriptList2}, bl || item.occurs, new boolean[]{blArray[0] || item.dynamic, bl2}, n2 + 1, stringBuffer6, stringBuffer7, stringBuffer5);
                    if (bl2) {
                        stringBuffer.append(stringBuffer6);
                        stringBuffer.append(stringBuffer5);
                        stringBuffer.append(stringBuffer7);
                        if (string4 != null) {
                            stringBuffer.append(stringBuffer4);
                            stringBuffer.append("      ");
                            stringBuffer.append(string4);
                            stringBuffer.append(" = true;");
                            stringBuffer.append(eol);
                            if (stringBuffer3.length() == 0) {
                                stringBuffer3.append(stringBuffer4);
                                stringBuffer3.append("if(");
                            } else {
                                stringBuffer3.append(" || ");
                            }
                            stringBuffer3.append(string4);
                            if (i3 == n3 - 1) {
                                stringBuffer3.append(") {");
                                stringBuffer3.append(eol);
                            }
                        }
                        stringBuffer.append(stringBuffer4);
                        stringBuffer.append("   } else break;");
                        stringBuffer.append(eol);
                    } else {
                        stringBuffer.append(stringBuffer6);
                        stringBuffer.append(stringBuffer7);
                    }
                } else {
                    if (bl2) {
                        stringBuffer.append(stringBuffer4);
                        stringBuffer.append("   if(!");
                        stringBuffer.append(variableName2.getCode());
                        stringBuffer.append(".isDynamicDefault(");
                        variableName.setIndexes(subscriptList);
                        stringBuffer.append(variableName.getCode());
                        stringBuffer.append(")) {");
                        stringBuffer.append(eol);
                    }
                    stringBuffer.append(stringBuffer4);
                    stringBuffer.append("      ");
                    this.getCodePositional(stringBuffer, variableName, variableName2, item.vd, item2.vd, subscriptList, subscriptList2);
                    if (bl2) {
                        if (string4 != null) {
                            stringBuffer.append(stringBuffer4);
                            stringBuffer.append("      ");
                            stringBuffer.append(string4);
                            stringBuffer.append(" = true;");
                            stringBuffer.append(eol);
                            if (stringBuffer3.length() == 0) {
                                stringBuffer3.append(stringBuffer4);
                                stringBuffer3.append("if(");
                            } else {
                                stringBuffer3.append(" || ");
                            }
                            stringBuffer3.append(string4);
                            if (i3 == n3 - 1) {
                                stringBuffer3.append(") {");
                                stringBuffer3.append(eol);
                            }
                        }
                        stringBuffer.append(stringBuffer4);
                        stringBuffer.append("   } else break;");
                        stringBuffer.append(eol);
                    }
                }
                stringBuffer.append(stringBuffer4);
                stringBuffer.append("}");
                stringBuffer.append(eol);
                continue;
            }
            if (bl) {
                if (bl2) {
                    variableName.setIndexes(subscriptList);
                    if (stringBuffer3.length() == 0) {
                        stringBuffer3.append(stringBuffer4);
                        stringBuffer3.append("if(");
                    } else {
                        stringBuffer3.append(" || ");
                    }
                    stringBuffer3.append("!");
                    stringBuffer3.append(variableName2.getCode());
                    stringBuffer3.append(".isDynamicDefault(");
                    stringBuffer3.append(variableName.getCode());
                    stringBuffer3.append(")");
                    if (i3 == n3 - 1) {
                        stringBuffer3.append(") {");
                        stringBuffer3.append(eol);
                    }
                }
                stringBuffer2.append(stringBuffer4);
                if (bl2) {
                    stringBuffer2.append("   ");
                }
                this.getCodePositional(stringBuffer2, variableName, variableName2, item.vd, item2.vd, subscriptList, subscriptList2);
                continue;
            }
            stringBuffer.append(stringBuffer4);
            this.getCodePositional(stringBuffer, variableName, variableName2, item.vd, item2.vd, subscriptList, subscriptList2);
        }
    }

    private void getCodePositional(StringBuffer stringBuffer) {
        SubscriptList subscriptList = this.fromVar.getIndexes();
        SubscriptList subscriptList2 = this.to.getFirst().getIndexes();
        boolean bl = true;
        stringBuffer.append("{" + eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("   ");
        stringBuffer.append(this.to.getFirst().getCode());
        stringBuffer.append(".initialize(null, null, false);");
        stringBuffer.append(eol);
        for (int i2 = 0; i2 < this.posVars.size(); ++i2) {
            int n2;
            int n3;
            int n4;
            VariableDeclaration[] variableDeclarationArray = (VariableDeclaration[])this.posVars.elementAt(i2);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            VariableDeclaration variableDeclaration = variableDeclarationArray[0];
            VariableDeclaration variableDeclaration2 = variableDeclarationArray[1];
            boolean bl2 = variableDeclaration.getDyDimension() > 0;
            int n5 = n4 = bl2 ? variableDeclaration.getDyDimension() : variableDeclaration.getDimension();
            if (subscriptList != null) {
                n4 -= subscriptList.getItemNum();
            }
            boolean bl3 = variableDeclaration2.getDyDimension() > 0;
            int n6 = n3 = bl3 ? variableDeclaration2.getDyDimension() : variableDeclaration2.getDimension();
            if (subscriptList2 != null) {
                n3 -= subscriptList2.getItemNum();
            }
            VariableName variableName = new VariableName(variableDeclaration);
            VariableName variableName2 = new VariableName(variableDeclaration2);
            if (n4 == 0) {
                SubscriptList subscriptList3 = new SubscriptList();
                if (subscriptList2 != null) {
                    subscriptList3.addListObject(subscriptList2);
                }
                for (int i3 = 0; i3 < n3; ++i3) {
                    subscriptList3.addItem(Subscript.get("1"));
                }
                this.getCodePositional(stringBuffer, variableName, variableName2, variableDeclaration, variableDeclaration2, subscriptList, subscriptList3);
                continue;
            }
            if (n3 == 0) {
                SubscriptList subscriptList4 = new SubscriptList();
                if (subscriptList != null) {
                    subscriptList4.addListObject(subscriptList);
                }
                for (int i4 = 0; i4 < n4; ++i4) {
                    subscriptList4.addItem(Subscript.get("1"));
                }
                this.getCodePositional(stringBuffer, variableName, variableName2, variableDeclaration, variableDeclaration2, subscriptList4, subscriptList2);
                continue;
            }
            int n7 = Math.min(n4, n3);
            SubscriptList subscriptList5 = new SubscriptList();
            if (subscriptList2 != null) {
                subscriptList5.addListObject(subscriptList2);
            }
            for (int i5 = n7; i5 < n3; ++i5) {
                subscriptList5.addItem(Subscript.get("1"));
            }
            SubscriptList subscriptList6 = new SubscriptList();
            if (subscriptList != null) {
                subscriptList6.addListObject(subscriptList);
            }
            for (int i6 = n7; i6 < n4; ++i6) {
                subscriptList6.addItem(Subscript.get("1"));
            }
            StringBuffer stringBuffer2 = null;
            int[] nArray = bl3 ? null : Move.getDimSizes(variableDeclaration2, n7);
            int[] nArray2 = bl2 ? null : Move.getDimSizes(variableDeclaration, n7);
            for (n2 = 0; n2 < n7; ++n2) {
                String string = "$idx_" + Move.getUniqueId();
                String string2 = null;
                if (!bl3) {
                    string2 = "$toN_" + Move.getUniqueId();
                }
                String string3 = "$fromN_" + Move.getUniqueId();
                stringBuffer2 = new StringBuffer("   ");
                if (n2 > 0) {
                    int n8 = n2 * 3;
                    for (int i7 = 0; i7 < n8; ++i7) {
                        stringBuffer2.append(' ');
                    }
                }
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("int ");
                Subscript subscript = Subscript.get(string);
                stringBuffer.append(string);
                stringBuffer.append(" = 1;");
                stringBuffer.append(eol);
                if (!bl3) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append("int ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" = ");
                    if (n2 == n7 - 1) {
                        stringBuffer.append(variableName2.getCode());
                        stringBuffer.append(".getLastDimension()");
                    } else {
                        stringBuffer.append(nArray[n2]);
                    }
                    stringBuffer.append(";");
                    stringBuffer.append(eol);
                }
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("int ");
                stringBuffer.append(string3);
                stringBuffer.append(" = ");
                if (bl2) {
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".getDynamicCapacity");
                    if (subscriptList6.getItemNum() == 0) {
                        stringBuffer.append("(new int[0])");
                    } else {
                        subscriptList6.getCodeNum(stringBuffer, true);
                    }
                } else if (n2 == n7 - 1) {
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".getLastDimension()");
                } else {
                    stringBuffer.append(nArray2[n2]);
                }
                stringBuffer.append(";");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                subscriptList5.addItem(subscript);
                subscriptList6.addItem(subscript);
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("for( ; ");
                stringBuffer.append(string);
                stringBuffer.append(" <= ");
                stringBuffer.append(string3);
                if (!bl3) {
                    stringBuffer.append(" && ");
                    stringBuffer.append(string);
                    stringBuffer.append(" <= ");
                    stringBuffer.append(string2);
                }
                stringBuffer.append("; ");
                stringBuffer.append(string);
                stringBuffer.append("++) {");
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append(stringBuffer2 + "   ");
            this.getCodePositional(stringBuffer, variableName, variableName2, variableDeclaration, variableDeclaration2, subscriptList6, subscriptList5);
            for (n2 = n7 - 1; n2 >= 0; --n2) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                int n9 = (n2 + 1) * 3;
                for (int i8 = 0; i8 < n9; ++i8) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("}");
            }
        }
        stringBuffer.append(eol + this.parent.getIndent() + "}" + eol + this.parent.getIndent());
    }

    private static int[] getDimSizes(VariableDeclaration variableDeclaration, int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 0;
            while (n3 == 0 && variableDeclaration != null) {
                n3 = variableDeclaration.getOccurs();
                variableDeclaration = variableDeclaration.parent;
            }
            nArray[n2 - 1 - i2] = n3;
        }
        return nArray;
    }

    private void getCodePositional(StringBuffer stringBuffer, VariableName variableName, VariableName variableName2, VariableDeclaration variableDeclaration, VariableDeclaration variableDeclaration2, SubscriptList subscriptList, SubscriptList subscriptList2) {
        if (subscriptList != null && subscriptList.getItemNum() > 0) {
            variableName.setIndexes(subscriptList);
        }
        if (subscriptList2 != null && subscriptList2.getItemNum() > 0) {
            variableName2.setIndexes(subscriptList2);
        }
        if (this.xOptimizable(variableDeclaration, false, variableDeclaration2, 1)) {
            int n2 = variableDeclaration.getPhisicLen();
            this.moveX2X(stringBuffer, variableName, variableName2, n2);
        } else {
            VariableNameList variableNameList = new VariableNameList();
            variableNameList.addItem(variableName2);
            this.getCodeTo(null, variableName, variableNameList, stringBuffer);
        }
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.corresponding) {
            this.getCodeCorresponding(stringBuffer, this.fromVar, this.to.getFirst(), false);
        } else if (this.positional) {
            if (this.delimitedDefault) {
                this.getCodePositionalDelimited(stringBuffer);
            } else {
                this.getCodePositional(stringBuffer);
            }
        } else if (this.conversion) {
            this.getCodeToWithConv(stringBuffer, this.to.getFirst());
        } else if (this.moveJava) {
            Set.getCodeJava(stringBuffer, this, null, this.getParent().getIndent(), this.to, this.fromToken, this.fromVar, this.moveNull, null);
        } else if (this.moveJavaToVar) {
            Set.getCodeJavaToVar(stringBuffer, this.parent.getIndent(), this.to, this.fromVar);
        } else if (this.toConv.getItemNum() > 0) {
            boolean bl = true;
            VariableName variableName = this.toConv.getFirst();
            while (variableName != null) {
                if (!bl) {
                    stringBuffer.append(this.parent.getIndent());
                } else {
                    bl = false;
                }
                this.getCodeToWithConv(stringBuffer, variableName);
                variableName = this.toConv.getNext();
            }
            if (this.to.getItemNum() > 0) {
                stringBuffer.append(this.parent.getIndent());
                this.getCodeTo(stringBuffer);
            }
        } else {
            this.getCodeTo(stringBuffer);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private void getCodeToWithConv(StringBuffer stringBuffer, VariableName variableName) {
        if (this.exceptionBlock != null) {
            stringBuffer.append("if(");
        } else if (this.notExceptionBlock != null) {
            stringBuffer.append("if(!");
        } else if (this._cmc) {
            stringBuffer.append("if(");
        }
        if (this.fromToken != null) {
            stringBuffer.append(this.getCodeLiteral(this.fromToken));
        } else if (this.fromVar != null) {
            stringBuffer.append(this.fromVar.getCode());
        }
        stringBuffer.append(".moveConv(");
        stringBuffer.append(variableName.getCode());
        stringBuffer.append(")");
        if (this.exceptionBlock != null || this.notExceptionBlock != null) {
            stringBuffer.append(")");
            if (this.exceptionBlock != null) {
                stringBuffer.append(this.exceptionBlock.getCode());
                if (this.notExceptionBlock != null) {
                    stringBuffer.append(" else ");
                    stringBuffer.append(this.notExceptionBlock.getCode());
                }
            } else if (this.notExceptionBlock != null) {
                stringBuffer.append(this.notExceptionBlock.getCode());
            }
        } else {
            if (this._cmc) {
                stringBuffer.append(") ");
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".setZero()");
            }
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
    }

    private void getCodeTo(Token token, VariableName variableName, VariableNameList variableNameList, StringBuffer stringBuffer) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        VariableDeclaration variableDeclaration = null;
        if (token != null) {
            stringBuffer.append(this.getCodeLiteral(token));
            if (this.cudcOpt && token.getToknum() == 10001 && !token.isAll()) {
                bl = true;
            }
        } else if (variableName != null) {
            variableDeclaration = variableName.getVarDecl();
            bl4 = Move.notElementary(variableName);
            if (this.cudcOpt && !bl4) {
                if (variableName.hasSubValue() || !variableDeclaration.isNumeric() && !variableDeclaration.isEdited()) {
                    bl = true;
                } else if (variableDeclaration.is9Display() && !variableDeclaration.isSigned() && !variableDeclaration.isP()) {
                    bl2 = true;
                }
            }
            stringBuffer.append(variableName.getCode(true));
        }
        stringBuffer.append(".moveTo");
        VariableName variableName2 = variableNameList.getFirst();
        while (variableName2 != null) {
            boolean bl5;
            VariableDeclaration variableDeclaration2 = variableName2.getVarDecl();
            boolean bl6 = bl5 = variableDeclaration2 != variableDeclaration;
            if (Move.isDepOnGroupItem(variableDeclaration2)) {
                stringBuffer.append("DepOnGroupItem");
            } else if (bl && !variableName2.hasSubValue() && (variableDeclaration2.is9Display() || variableDeclaration2.isNumericEdited()) && !variableDeclaration2.isSigned()) {
                stringBuffer.append("X2UD");
                bl3 = true;
            }
            if (bl4 || Move.notElementary(variableName2) || bl2 && (!variableDeclaration2.isNumeric() && !variableDeclaration2.isEdited() || variableDeclaration2.isNumericEdited()) && !variableDeclaration2.isJustified() && !variableDeclaration2.isAnyLength()) {
                if (bl2 && variableDeclaration2.isNumericEdited() && !variableName2.hasSubValue()) {
                    stringBuffer.append("92UD(");
                    bl3 = true;
                } else {
                    stringBuffer.append("((CobolVar)");
                }
            } else {
                stringBuffer.append("(");
            }
            if (bl3 && variableDeclaration2.hasVariableOffset() && variableDeclaration2.isNumericEdited() && !variableName2.hasSubValue()) {
                stringBuffer.append("(PicNumEdit)");
            }
            stringBuffer.append(variableName2.getCode(bl5));
            stringBuffer.append(")");
            variableName2 = variableNameList.getNext();
            if (variableName2 == null) break;
            stringBuffer.append(eol + this.parent.getIndent() + ".moveTo");
        }
        stringBuffer.append(";" + eol);
    }

    private void getCodeTo(StringBuffer stringBuffer) {
        block85: {
            int n2;
            Object object;
            String string = "";
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            boolean bl = false;
            if (this.fromToken != null) {
                bl = this.fromToken.isAll() || this.fromToken.isFigurative();
                object = this.fromToken.getCode();
                for (n2 = 0; n2 < ((String)object).length(); ++n2) {
                    string = string + " ";
                    stringBuffer2.append('\u0000');
                    stringBuffer3.append('\u00ff');
                }
            }
            if (this.fromToken != null && string.equals(this.fromToken.getCode())) {
                object = this.to.getFirst();
                while (true) {
                    if (((VariableName)object).hasSubValue() && !((VariableName)object).getVarDecl().isNational() && !((VariableName)object).getVarDecl().isPicG()) {
                        stringBuffer.append("Factory.subMv (Factory.SPACE,");
                        stringBuffer.append(((VariableName)object).getCode(true, true, false));
                        stringBuffer.append(",");
                        ((VariableName)object).getSubstringOffs(stringBuffer, 0);
                        stringBuffer.append(",");
                        if (!((VariableName)object).getSubstringLen(stringBuffer, 0)) {
                            stringBuffer.append("0,true);");
                        } else {
                            stringBuffer.append(",false);");
                        }
                    } else if (bl || !((VariableName)object).getVarDecl().isAnyLength()) {
                        stringBuffer.append(((VariableName)object).getCode(true));
                        if (((VariableName)object).isNumeric() && !this.cudcOpt) {
                            stringBuffer.append(".set(0);");
                        } else {
                            stringBuffer.append(".setSpace();");
                        }
                    } else {
                        stringBuffer.append(this.getCodeLiteral(this.fromToken));
                        stringBuffer.append(".moveTo(");
                        stringBuffer.append(((VariableName)object).getCode(true));
                        stringBuffer.append(");");
                    }
                    stringBuffer.append(eol);
                    object = this.to.getNext();
                    if (object != null) {
                        stringBuffer.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (this.fromToken != null && "0".equals(this.fromToken.getCode()) && this.fromToken.getToknum() == 10002) {
                object = this.to.getFirst();
                while (true) {
                    if (((VariableName)object).hasSubValue() && !((VariableName)object).getVarDecl().isNational() && !((VariableName)object).getVarDecl().isPicG()) {
                        stringBuffer.append("Factory.subMv (Factory.ZERO,");
                        stringBuffer.append(((VariableName)object).getCode(true, true, false));
                        stringBuffer.append(",");
                        ((VariableName)object).getSubstringOffs(stringBuffer, 0);
                        stringBuffer.append(",");
                        if (!((VariableName)object).getSubstringLen(stringBuffer, 0)) {
                            stringBuffer.append("0,true);");
                        } else {
                            stringBuffer.append(",false);");
                        }
                    } else {
                        stringBuffer.append(((VariableName)object).getCode(true));
                        if (this.fromToken.isAll()) {
                            stringBuffer.append(".setAllZero();");
                        } else {
                            stringBuffer.append(".setZero();");
                        }
                    }
                    stringBuffer.append(eol);
                    object = this.to.getNext();
                    if (object != null) {
                        stringBuffer.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (bl && stringBuffer2.toString().equals(this.fromToken.getCode())) {
                if (this.xOptimizable()) {
                    VariableName variableName = this.to.getFirst();
                    while (true) {
                        object = variableName.getVarDecl();
                        n2 = Move.getVarLen(variableName);
                        if (variableName.hasSubValue()) {
                            stringBuffer.append("Factory.subMv ((byte) 0x00,");
                            stringBuffer.append(variableName.getCode(true, true, false));
                            stringBuffer.append(",");
                            variableName.getSubstringOffs(stringBuffer, 0);
                            stringBuffer.append(",");
                            if (!variableName.getSubstringLen(stringBuffer, 0)) {
                                stringBuffer.append("0,true");
                            } else {
                                stringBuffer.append(",false");
                            }
                        } else {
                            if (n2 <= 8) {
                                stringBuffer.append("Factory.lvs (");
                            } else {
                                stringBuffer.append("Factory.lvl (");
                            }
                            if (((VariableDeclaration)object).getDimension() > 0) {
                                stringBuffer.append(variableName.getCode(true));
                                stringBuffer.append(",");
                            } else {
                                stringBuffer.append(variableName.getCode());
                                stringBuffer.append(".getMemory(),");
                                stringBuffer.append(variableName.getCode());
                                stringBuffer.append(".getOffset(),");
                            }
                            stringBuffer.append(n2);
                        }
                        stringBuffer.append(");");
                        stringBuffer.append(eol);
                        variableName = this.to.getNext();
                        if (variableName != null) {
                            stringBuffer.append(this.parent.getIndent());
                            continue;
                        }
                        break block85;
                        break;
                    }
                }
                object = this.to.getFirst();
                while (true) {
                    stringBuffer.append(((VariableName)object).getCode(true));
                    stringBuffer.append(".setLowValues();");
                    stringBuffer.append(eol);
                    object = this.to.getNext();
                    if (object != null) {
                        stringBuffer.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (bl && stringBuffer3.toString().equals(this.fromToken.getCode())) {
                if (this.xOptimizable()) {
                    VariableName variableName = this.to.getFirst();
                    while (true) {
                        object = variableName.getVarDecl();
                        n2 = Move.getVarLen(variableName);
                        if (variableName.hasSubValue()) {
                            stringBuffer.append("Factory.subMv ((byte) 0xFF,");
                            stringBuffer.append(variableName.getCode(true, true, false));
                            stringBuffer.append(",");
                            variableName.getSubstringOffs(stringBuffer, 0);
                            stringBuffer.append(",");
                            if (!variableName.getSubstringLen(stringBuffer, 0)) {
                                stringBuffer.append("0,true");
                            } else {
                                stringBuffer.append(",false");
                            }
                        } else {
                            if (n2 <= 8) {
                                stringBuffer.append("Factory.hvs (");
                            } else {
                                stringBuffer.append("Factory.hvl (");
                            }
                            if (((VariableDeclaration)object).getDimension() > 0) {
                                stringBuffer.append(variableName.getCode(true));
                                stringBuffer.append(",");
                            } else {
                                stringBuffer.append(variableName.getCode());
                                stringBuffer.append(".getMemory(),");
                                stringBuffer.append(variableName.getCode());
                                stringBuffer.append(".getOffset(),");
                            }
                            stringBuffer.append(n2);
                        }
                        stringBuffer.append(");");
                        stringBuffer.append(eol);
                        variableName = this.to.getNext();
                        if (variableName != null) {
                            stringBuffer.append(this.parent.getIndent());
                            continue;
                        }
                        break block85;
                        break;
                    }
                }
                object = this.to.getFirst();
                while (true) {
                    stringBuffer.append(((VariableName)object).getCode(true));
                    stringBuffer.append(".setHighValues();");
                    stringBuffer.append(eol);
                    object = this.to.getNext();
                    if (object != null) {
                        stringBuffer.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (this.xOptimizable()) {
                if (this.fromToken != null) {
                    if (this.fromToken.isAll()) {
                        String string2 = this.fromToken.getCode();
                        char c2 = string2.charAt(0);
                        if (string2.length() > 1 || c2 >= '\u0080') {
                            c2 = '\u0000';
                        }
                        VariableName variableName = this.to.getFirst();
                        while (true) {
                            object = variableName.getVarDecl();
                            int n3 = Move.getVarLen(variableName);
                            if (n3 < 0 || variableName.hasSubValue()) {
                                stringBuffer.append("Factory.subMv (");
                                if (c2 != '\u0000') {
                                    stringBuffer.append("(byte)");
                                    stringBuffer.append(Token.getEncByte(c2));
                                } else {
                                    stringBuffer.append(this.fromToken.getLitArg());
                                }
                                stringBuffer.append(",");
                                stringBuffer.append(variableName.getCode(true, true, false));
                                stringBuffer.append(",");
                                variableName.getSubstringOffs(stringBuffer, 0);
                                stringBuffer.append(",");
                                if (!variableName.getSubstringLen(stringBuffer, 0)) {
                                    stringBuffer.append("0,true");
                                } else {
                                    stringBuffer.append(",false");
                                }
                            } else {
                                stringBuffer.append("Factory.fl (");
                                if (((VariableDeclaration)object).getDimension() > 0) {
                                    stringBuffer.append(variableName.getCode(true));
                                    stringBuffer.append(",");
                                } else {
                                    stringBuffer.append(variableName.getCode(false, false, false));
                                    stringBuffer.append(".getMemory(),");
                                    variableName.getCodeOffset(stringBuffer, 0);
                                    stringBuffer.append(",");
                                }
                                if (c2 == '\u0000') {
                                    stringBuffer.append(this.getCodeLiteral(this.fromToken));
                                    stringBuffer.append(".getMemory()");
                                } else {
                                    stringBuffer.append("(byte)");
                                    stringBuffer.append(Token.getEncByte(c2));
                                }
                                if (n3 != 1) {
                                    stringBuffer.append(",");
                                    stringBuffer.append(Move.getVarLen(variableName));
                                }
                            }
                            stringBuffer.append(");");
                            stringBuffer.append(eol);
                            variableName = this.to.getNext();
                            if (variableName != null) {
                                stringBuffer.append(this.parent.getIndent());
                                continue;
                            }
                            break;
                        }
                    } else {
                        VariableName variableName = this.to.getFirst();
                        while (true) {
                            object = variableName.getVarDecl();
                            int n4 = Move.getVarLen(variableName);
                            if (n4 < 0 || variableName.hasSubValue()) {
                                stringBuffer.append("Factory.subMv (");
                                stringBuffer.append(this.getCodeLiteral(this.fromToken));
                                stringBuffer.append(",1,0,true,");
                                stringBuffer.append(variableName.getCode(true, true, false));
                                stringBuffer.append(",");
                                variableName.getSubstringOffs(stringBuffer, 0);
                                stringBuffer.append(",");
                                if (!variableName.getSubstringLen(stringBuffer, 0)) {
                                    stringBuffer.append("0,true");
                                } else {
                                    stringBuffer.append(",false");
                                }
                            } else {
                                if (n4 != 1 && ((VariableDeclaration)object).isJustified() && !variableName.hasSubValue()) {
                                    stringBuffer.append("Factory.cpj (");
                                } else {
                                    stringBuffer.append("Factory.cp (");
                                }
                                stringBuffer.append(this.getCodeLiteral(this.fromToken));
                                stringBuffer.append(".getMemory(),");
                                if (((VariableDeclaration)object).getDimension() > 0) {
                                    stringBuffer.append(variableName.getCode(true));
                                } else {
                                    stringBuffer.append(variableName.getCode(false, false, false));
                                    stringBuffer.append(".getMemory(),");
                                    variableName.getCodeOffset(stringBuffer, 0);
                                }
                                if (n4 != 1) {
                                    stringBuffer.append(",");
                                    stringBuffer.append(n4);
                                }
                            }
                            stringBuffer.append(");");
                            variableName = this.to.getNext();
                            if (variableName == null) break;
                            stringBuffer.append(eol);
                            stringBuffer.append(this.parent.getIndent());
                        }
                        stringBuffer.append(eol);
                    }
                } else {
                    n2 = Move.getVarLen(this.fromVar);
                    VariableName variableName = this.to.getFirst();
                    while (true) {
                        this.moveX2X(stringBuffer, this.fromVar, variableName, n2);
                        variableName = this.to.getNext();
                        if (variableName == null) break;
                        stringBuffer.append(eol);
                        stringBuffer.append(this.parent.getIndent());
                    }
                    stringBuffer.append(eol);
                }
            } else if (this.literalOptimizable()) {
                object = this.to.getFirst();
                while (true) {
                    stringBuffer.append(((VariableName)object).getCode(true));
                    stringBuffer.append(".set(");
                    if (this.fromToken.getToknum() == 10002) {
                        stringBuffer.append(this.fromToken.getAsLong());
                    }
                    stringBuffer.append(");");
                    object = this.to.getNext();
                    if (object == null) break;
                    stringBuffer.append(eol);
                    stringBuffer.append(this.parent.getIndent());
                }
                stringBuffer.append(eol);
            } else {
                this.getCodeTo(this.fromToken, this.fromVar, this.to, stringBuffer);
            }
        }
    }

    private static boolean notElementary(VariableName variableName) {
        return !variableName.hasSubValue() && variableName.getVarDecl().notElementary();
    }

    static boolean isDepOnGroupItem(VariableDeclaration variableDeclaration) {
        VariableName variableName = variableDeclaration.hasADepending();
        if (variableName != null) {
            for (VariableDeclaration variableDeclaration2 = variableName.getVarDecl().getParent(); variableDeclaration2 != null; variableDeclaration2 = variableDeclaration2.getParent()) {
                if (variableDeclaration != variableDeclaration2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer stringBuffer, String string, VariableDeclaration variableDeclaration, String string2, VariableDeclaration variableDeclaration2) {
        boolean bl = variableDeclaration.notElementary();
        boolean bl2 = false;
        boolean bl3 = false;
        stringBuffer.append("      ");
        if (this.cudcOpt && !bl) {
            if (!variableDeclaration.isNumeric() && !variableDeclaration.isEdited()) {
                bl2 = true;
            } else if (variableDeclaration.is9Display() && !variableDeclaration.isSigned() && !variableDeclaration.isP()) {
                bl3 = true;
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(".moveTo");
        if (this.xOptimizable(variableDeclaration, false, variableDeclaration2, 0) && variableDeclaration2.is9Display()) {
            stringBuffer.append("ZeroFill");
        } else if (Move.isDepOnGroupItem(variableDeclaration2)) {
            stringBuffer.append("DepOnGroupItem");
        } else if (bl2 && (variableDeclaration2.is9Display() || variableDeclaration2.isNumericEdited()) && !variableDeclaration2.isSigned()) {
            stringBuffer.append("X2UD");
        }
        stringBuffer.append("(");
        if (bl || variableDeclaration2.notElementary() || bl3 && !variableDeclaration2.isNumeric() && !variableDeclaration2.isEdited() && !variableDeclaration2.isJustified() && !variableDeclaration2.isAnyLength()) {
            stringBuffer.append("(CobolVar)");
        }
        stringBuffer.append(string2);
        stringBuffer.append(");");
        stringBuffer.append(eol);
    }

    @Override
    public void check() throws GeneralErrorException {
        CobolToken cobolToken;
        if (!this.corresponding && this.fromToken != null && this.fromToken.isDouble() || this.fromVar != null && this.fromVar.getVarDecl().isFloatingPoint()) {
            VariableName variableName = this.to.getFirst();
            while (variableName != null) {
                cobolToken = variableName.getVarDecl();
                if (!((VariableDeclaration)cobolToken).isNumeric()) {
                    this.error.print(59, 4, variableName.getNameToken(), variableName.getName());
                }
                variableName = this.to.getNext();
            }
        }
        if (!this.positional && !this.corresponding) {
            if (this.fromVar != null && this.fromVar.isVariableLengthGroup()) {
                cobolToken = this.to.getFirst();
                while (cobolToken != null) {
                    if (!(((VariableName)cobolToken).isVariableLengthGroup() || ((VariableName)cobolToken).getVarDecl() instanceof InlineInvoke && ((VariableName)cobolToken).isCobolVar())) {
                        this.error.print(257, 2, this.fromVar.getNameToken(), this.fromVar.getName());
                        break;
                    }
                    cobolToken = this.to.getNext();
                }
            } else if (this.fromVar == null || !(this.fromVar.getVarDecl() instanceof InlineInvoke) || !this.fromVar.getVarDecl().isCobolVar()) {
                cobolToken = this.to.getFirst();
                while (cobolToken != null) {
                    if (((VariableName)cobolToken).isVariableLengthGroup()) {
                        this.error.print(257, 2, ((VariableName)cobolToken).getNameToken(), ((VariableName)cobolToken).getName());
                    }
                    cobolToken = this.to.getNext();
                }
            }
        }
        if (this.moveJava) {
            Set.checkJava(this, this.to, this.fromToken, this.fromVar, null, this.moveNull);
        }
    }

    private String illegalMoveCorr(VariableName variableName, VariableName variableName2) {
        StringBuffer stringBuffer = new StringBuffer();
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        VariableDeclarationList variableDeclarationList2 = new VariableDeclarationList();
        Move.getCorrespondingVars(variableDeclarationList, this.fromVar.getVarDecl().children);
        Move.getCorrespondingVars(variableDeclarationList2, variableName2.getVarDecl().children);
        VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            VariableDeclaration variableDeclaration2 = variableDeclarationList2.getFirst();
            while (variableDeclaration2 != null) {
                if (variableDeclaration.name.getWord().equals(variableDeclaration2.name.getWord()) && variableDeclaration.dimension == 0 && variableDeclaration2.dimension == 0 && variableDeclaration.rename1 == null && variableDeclaration2.rename1 == null && this.illegalMoveCorrDet(variableDeclaration, variableDeclaration2)) {
                    stringBuffer.append(variableDeclaration2.getName()).append(",");
                }
                variableDeclaration2 = variableDeclarationList2.getNext();
            }
            variableDeclaration = variableDeclarationList.getNext();
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private void checkAcuBug(VariableDeclaration variableDeclaration, VariableDeclaration variableDeclaration2) {
        if (variableDeclaration.is9Display() && variableDeclaration2.is9Display() && variableDeclaration.getLogicLen() == variableDeclaration2.getLogicLen() && variableDeclaration.getPhisicLen() == variableDeclaration2.getPhisicLen() && variableDeclaration.getDecimals() == variableDeclaration2.getDecimals() && (variableDeclaration.isRedefines() || variableDeclaration.hasRedefines) && (variableDeclaration2.isRedefines() || variableDeclaration2.hasRedefines)) {
            this.error.print(148, 2, this.keyWord, "MOVE " + variableDeclaration.getName() + " TO " + variableDeclaration2.getName());
        }
    }

    private void checkAcuBug(VariableName variableName, VariableName variableName2) {
        this.checkAcuBug(variableName.getVarDecl(), variableName2.getVarDecl());
    }

    private int illegalMove(VariableName variableName, VariableName variableName2, VariableName[] variableNameArray) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(variableName, variableName2);
        }
        if (variableName.getVarDecl() instanceof VariableDeclarationScreen) {
            variableNameArray[0] = variableName;
            return 165;
        }
        if (variableName2.getVarDecl() instanceof VariableDeclarationScreen) {
            variableNameArray[0] = variableName2;
            return 165;
        }
        if (variableName.getLevel() == 88 || variableName2.getLevel() == 88 || variableName2.getLevel() == 78 || !variableName.isNumeric() && variableName.isEdited() && !variableName.hasSubValue() && variableName2.isNumeric() || variableName.isNumeric() && !variableName.hasSubValue() && variableName2.getVarDecl().isPic1() && variableName.getVarDecl().isPic1() && variableName2.isNumeric() && !variableName2.hasSubValue()) {
            variableNameArray[0] = variableName2;
            return 59;
        }
        return 0;
    }

    private boolean illegalMove(VariableDeclaration variableDeclaration, VariableDeclaration variableDeclaration2) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(variableDeclaration, variableDeclaration2);
        }
        return variableDeclaration instanceof VariableDeclarationScreen || variableDeclaration2 instanceof VariableDeclarationScreen || variableDeclaration.getLevel() == 88 || variableDeclaration2.getLevel() == 88 || variableDeclaration2.getLevel() == 78 || !variableDeclaration.isNumeric() && variableDeclaration.isEdited() && variableDeclaration2.isNumeric() || variableDeclaration.isPic1() && variableDeclaration2.isNumeric() || variableDeclaration.isNumeric() && variableDeclaration2.isPic1();
    }

    private boolean illegalMoveCorrDet(VariableDeclaration variableDeclaration, VariableDeclaration variableDeclaration2) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(variableDeclaration, variableDeclaration2);
        }
        return variableDeclaration.level == 88 || variableDeclaration2.level == 88 || variableDeclaration2.level == 78 || variableDeclaration.isNumeric() && !variableDeclaration.isInteger() && !variableDeclaration.isEdited() && !variableDeclaration2.isNumeric() || !variableDeclaration.isNumeric() && variableDeclaration.isEdited() && variableDeclaration2.isNumeric();
    }

    private int illegalMove(Token token, VariableName variableName) {
        if (variableName.getLevel() == 78 || variableName.getLevel() == 88 || token.getToknum() == 10017 && !variableName.isNumeric()) {
            return 59;
        }
        if (variableName.getVarDecl() instanceof VariableDeclarationScreen) {
            return 165;
        }
        return 0;
    }

    private boolean xOptimizable(VariableDeclaration variableDeclaration, boolean bl, VariableDeclaration variableDeclaration2, int n2) {
        if (this.pc.optionMS) {
            return false;
        }
        if (variableDeclaration.isNumeric() && !bl) {
            if (!variableDeclaration.isNotXOptimizable(false)) {
                int n3;
                if (n2 > 1 && !variableDeclaration.checkDimension(0)) {
                    return false;
                }
                if (variableDeclaration2.isNotXOptimizable(false) || this._xxm28529 && variableDeclaration.isUsageComp3() || !variableDeclaration.sameNumericTypeOf(variableDeclaration2)) {
                    return false;
                }
                int n4 = variableDeclaration.getLogicLen();
                return !(n4 != (n3 = variableDeclaration2.getLogicLen()) ? !variableDeclaration.isUsageDisplay() || variableDeclaration.isSignLeading() : n4 == 0 && variableDeclaration.getPhisicLen() != variableDeclaration2.getPhisicLen());
            }
            return false;
        }
        if (variableDeclaration.isNotXOptimizable(true)) {
            return false;
        }
        return !variableDeclaration2.isNotXOptimizable(true);
    }

    private boolean xOptimizable() {
        if (this.pc.optionMS) {
            return false;
        }
        if (this.fromToken != null) {
            if (this.fromToken.getToknum() != 10001 || this.fromToken.isNational()) {
                return false;
            }
            VariableName variableName = this.to.getFirst();
            while (variableName != null) {
                if (variableName.isNotXOptimizable(true)) {
                    return false;
                }
                variableName = this.to.getNext();
            }
        } else {
            int n2 = this.to.getItemNum();
            VariableDeclaration variableDeclaration = this.fromVar.getVarDecl();
            boolean bl = this.fromVar.hasSubValue();
            VariableName variableName = this.to.getFirst();
            while (variableName != null) {
                if (!this.xOptimizable(variableDeclaration, bl, variableName.getVarDecl(), n2)) {
                    return false;
                }
                variableName = this.to.getNext();
            }
        }
        return true;
    }

    private boolean literalOptimizable() {
        if (this.pc.getOption("-xo0") != null) {
            return false;
        }
        if (this.fromToken == null) {
            return false;
        }
        if (this.fromToken.getToknum() != 10002) {
            return false;
        }
        try {
            Long.parseLong(this.fromToken.getCode());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        VariableName variableName = this.to.getFirst();
        while (variableName != null) {
            if (!variableName.isNumeric()) {
                return false;
            }
            variableName = this.to.getNext();
        }
        return true;
    }

    private void fillCode(boolean bl, StringBuffer stringBuffer, VariableName variableName, String string, int n2, int n3, boolean bl2) {
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (n3 == 1) {
            stringBuffer.append(string);
            if (bl2) {
                stringBuffer.append(".put (");
                variableName.getCodeOffset(stringBuffer, n2);
                if (bl) {
                    stringBuffer.append(", Factory.SPACE);");
                } else {
                    stringBuffer.append(", Factory.ZERO);");
                }
            } else {
                stringBuffer.append("[");
                variableName.getCodeOffset(stringBuffer, n2);
                if (bl) {
                    stringBuffer.append("]=Factory.SPACE;");
                } else {
                    stringBuffer.append("]=Factory.ZERO;");
                }
            }
        } else if (bl2) {
            stringBuffer.append(string);
            stringBuffer.append(".fill(");
            variableName.getCodeOffset(stringBuffer, n2);
            stringBuffer.append(",");
            variableName.getCodeOffset(stringBuffer, n2 + n3);
            if (bl) {
                stringBuffer.append(",Factory.SPACE);");
            } else {
                stringBuffer.append(",Factory.ZERO);");
            }
        } else if (bl && n3 > 1024) {
            stringBuffer.append("Factory.spl (");
            stringBuffer.append(string);
            stringBuffer.append(",");
            variableName.getCodeOffset(stringBuffer, n2);
            stringBuffer.append(",");
            stringBuffer.append(n3);
            stringBuffer.append(");");
        } else {
            if (bl) {
                stringBuffer.append("System.arraycopy (Factory.spaces,0,");
            } else {
                stringBuffer.append("System.arraycopy (Factory.zeroes,0,");
            }
            stringBuffer.append(string);
            stringBuffer.append(",");
            variableName.getCodeOffset(stringBuffer, n2);
            stringBuffer.append(",");
            stringBuffer.append(n3);
            stringBuffer.append(");");
        }
    }

    private void moveX2X(StringBuffer stringBuffer, VariableName variableName, VariableName variableName2, int n2) {
        int n3;
        int n4;
        String string;
        String string2;
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        VariableDeclaration variableDeclaration2 = variableName2.getVarDecl();
        boolean bl = variableDeclaration.getGrandPa() == variableDeclaration2.getGrandPa();
        int n5 = Move.getVarLen(variableName2);
        int n6 = n5 - n2;
        if (n2 < 0 || n5 < 0 || variableName.hasSubValue() || variableName2.hasSubValue()) {
            stringBuffer.append("Factory.subMv (");
            stringBuffer.append(variableName.getCode(true, true, false));
            stringBuffer.append(",");
            if (variableName.hasSubValue()) {
                variableName.getSubstringOffs(stringBuffer, 0);
            } else {
                stringBuffer.append("1");
            }
            stringBuffer.append(",");
            if (variableName.hasSubValue() && variableName.getSubstringLen(stringBuffer, 0)) {
                stringBuffer.append(",false,");
            } else {
                stringBuffer.append("0,true,");
            }
            stringBuffer.append(variableName2.getCode(true, variableDeclaration != variableDeclaration2, false));
            stringBuffer.append(",");
            if (variableName2.hasSubValue()) {
                variableName2.getSubstringOffs(stringBuffer, 0);
            } else {
                stringBuffer.append("1");
            }
            stringBuffer.append(",");
            if (variableName2.hasSubValue() && variableName2.getSubstringLen(stringBuffer, 0)) {
                stringBuffer.append(",false);");
            } else {
                stringBuffer.append("0,true);");
            }
            return;
        }
        if (bl) {
            string2 = "va$mem";
            string = "va$mem";
            stringBuffer.append("{");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            if (this._cp) {
                stringBuffer.append("final Memory ");
            } else {
                stringBuffer.append("final byte[] ");
            }
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(variableName.getCode(false, false, false));
            stringBuffer.append(".getMemory();");
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        } else {
            string2 = variableName.getCode(false, false, false) + ".getMemory()";
            string = variableName2.getCode(false, false, false) + ".getMemory()";
        }
        if (variableDeclaration2.isJustified() || variableDeclaration2.isNumeric()) {
            if (n6 >= 0) {
                n4 = n6;
                n3 = 0;
            } else {
                n4 = 0;
                n3 = -n6;
            }
        } else {
            n4 = 0;
            n3 = 0;
        }
        if (n5 == 1 || n2 == 1) {
            if (this._cp) {
                stringBuffer.append(string);
                stringBuffer.append(".put (");
                variableName2.getCodeOffset(stringBuffer, n4);
                stringBuffer.append(",");
                stringBuffer.append(string2);
                stringBuffer.append(".get(");
                variableName.getCodeOffset(stringBuffer, n3);
                stringBuffer.append("));");
            } else {
                stringBuffer.append(string);
                stringBuffer.append("[");
                variableName2.getCodeOffset(stringBuffer, n4);
                stringBuffer.append("]=");
                stringBuffer.append(string2);
                stringBuffer.append("[");
                variableName.getCodeOffset(stringBuffer, n3);
                stringBuffer.append("];");
            }
        } else {
            if (this._cp) {
                stringBuffer.append(string2);
                stringBuffer.append(".copy(");
                variableName.getCodeOffset(stringBuffer, n3);
                stringBuffer.append(",");
                stringBuffer.append(string);
                stringBuffer.append(",");
                variableName2.getCodeOffset(stringBuffer, n4);
            } else {
                stringBuffer.append("System.arraycopy (");
                stringBuffer.append(string2);
                stringBuffer.append(",");
                variableName.getCodeOffset(stringBuffer, n3);
                stringBuffer.append(",");
                stringBuffer.append(string);
                stringBuffer.append(",");
                variableName2.getCodeOffset(stringBuffer, n4);
            }
            stringBuffer.append(",");
            if (n5 < n2) {
                stringBuffer.append(n5);
            } else {
                stringBuffer.append(n2);
            }
            stringBuffer.append(");");
        }
        if (n6 > 0) {
            if (variableDeclaration2.isNumeric()) {
                if (variableDeclaration2.getLogicLen() > variableDeclaration.getLogicLen()) {
                    this.fillCode(false, stringBuffer, variableName2, string, 0, n6, this._cp);
                }
            } else if (variableDeclaration2.isJustified()) {
                this.fillCode(true, stringBuffer, variableName2, string, 0, n6, this._cp);
            } else {
                this.fillCode(true, stringBuffer, variableName2, string, n2, n6, this._cp);
            }
        }
        if (bl) {
            if (!this._cp && variableName2.isNumeric()) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(variableName2.getCode(false, false, false));
                stringBuffer.append(".getMemory();");
            }
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}");
        }
    }

    private static int getVarLen(VariableName variableName) {
        int n2 = variableName.getVariableLength(true);
        VariableDeclaration variableDeclaration = variableName.getVarDecl();
        if (n2 > 0 && variableDeclaration.isNational()) {
            n2 *= 2;
        }
        return n2;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public VariableNameList getTo() {
        return this.to;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    private static class Item {
        final boolean occurs;
        final boolean dynamic;
        final VariableDeclaration vd;
        final Vector grp;

        Item(VariableDeclaration variableDeclaration, boolean bl, boolean bl2) {
            this.vd = variableDeclaration;
            this.occurs = bl;
            this.dynamic = bl2;
            this.grp = null;
        }

        Item(VariableDeclaration variableDeclaration, Vector vector, boolean bl, boolean bl2) {
            this.grp = vector;
            this.occurs = bl;
            this.dynamic = bl2;
            this.vd = variableDeclaration;
        }

        boolean isGroup() {
            return this.grp != null;
        }
    }
}

