/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Multiply
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private Token num;
    private Token tokenBy;
    private VariableName var;
    private VariableNameList varByList;
    private VariableNameList varGiving;
    private boolean giving;
    private OnSizeError ose;

    public Multiply(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        Token token2;
        VariableName variableName;
        block34: {
            super(token, block, pcc, tokenManager, errors);
            this.varByList = new VariableNameList();
            this.varGiving = new VariableNameList();
            variableName = null;
            token2 = this.tm.getToken();
            switch (token2.getToknum()) {
                case 10001: {
                    if (token2.isNull()) {
                        token2.setZero();
                    } else {
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                }
                case 10002: 
                case 10017: {
                    this.num = token2;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    this.var = VariableName.getAny(this.tm, this.error, this.pc);
                    if (this.var != null && this.var.isNumeric() && !this.var.isEdited()) break;
                    throw new GeneralErrorException(109, 4, token2, token2.getWord(), this.error);
                }
                default: {
                    throw new UnexpectedTokenException(token2, this.error);
                }
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 312) {
                block11: while (true) {
                    token2 = this.tm.getToken();
                    switch (token2.getToknum()) {
                        case 702: {
                            if (variableName != null) {
                                variableName.rounded = true;
                                continue block11;
                            }
                            throw new UnexpectedTokenException(token2, this.error);
                        }
                        case 10001: {
                            if (!token2.isNull()) break block34;
                            token2.setZero();
                        }
                        case 10002: 
                        case 10017: {
                            if (this.tokenBy != null) {
                                throw new UnexpectedTokenException(token2, this.error);
                            }
                            this.tokenBy = token2;
                            variableName = null;
                            continue block11;
                        }
                        case 10009: {
                            this.tm.ungetToken();
                            variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                            if (variableName != null && variableName.isNumeric() && !variableName.isEdited()) {
                                this.varByList.addItem(variableName);
                                continue block11;
                            }
                            throw new GeneralErrorException(109, 4, token2, token2.getWord(), this.error);
                        }
                    }
                    break;
                }
            } else {
                throw new ExpectedFoundException(token2, this.error, "BY");
            }
        }
        if (token2.getToknum() == 505) {
            this.giving = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                while (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    variableName = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (variableName == null || !variableName.isNumeric()) {
                        throw new GeneralErrorException(109, 4, token2, token2.getWord(), this.error);
                    }
                    this.varGiving.addItem(variableName);
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 702) continue;
                    variableName.rounded = true;
                    token2 = this.tm.getToken();
                }
                if (this.varByList.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            if (this.varByList.getItemNum() > 0) {
                this.varByList.getFirst().setPropTypeGet();
            }
        } else {
            if (this.tokenBy != null) {
                throw new GeneralErrorException(17, 4, this.tokenBy, this.tokenBy.getWord(), this.error);
            }
            VariableName variableName2 = this.varByList.getFirst();
            while (variableName2 != null) {
                variableName2.checkPropTypeSetGet();
                variableName2 = this.varByList.getNext();
            }
        }
        if (!this.giving && variableName == null || this.varByList.getItemNum() == 0 && this.tokenBy == null) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(token, block, this, pcc, tokenManager, errors);
        token2 = this.tm.getToken();
        if (token2.getToknum() != 438) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (this.var != null) {
                stringBuffer.append(this.var.getCode());
            } else {
                stringBuffer.append(Expression.toNum(this.num));
            }
            if (this.giving) {
                stringBuffer.append(" * ");
                if (this.tokenBy != null) {
                    stringBuffer.append(Expression.toNum(this.tokenBy));
                } else {
                    stringBuffer.append(this.varByList.getFirst().getCode());
                }
            }
        } else {
            if (this.var != null) {
                stringBuffer.append(Compute.getCobolNumCode(this.var));
            } else {
                stringBuffer.append(this.getCodeLiteral(this.num)).append(".num()");
            }
            if (this.giving) {
                stringBuffer.append(".multiply(");
                if (this.tokenBy != null) {
                    stringBuffer.append(this.getCodeLiteral(this.tokenBy)).append(".num()");
                } else {
                    stringBuffer.append(Compute.getCobolNumCode(this.varByList.getFirst()));
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration variableDeclaration;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.num != null && this.num.getToknum() == 10002 || this.var != null && (variableDeclaration = this.var.getVarDecl()).isInteger() && variableDeclaration.getLogicLen() <= 18)) {
            VariableName variableName = this.varByList.getFirst();
            while (variableName != null) {
                variableDeclaration = variableName.getVarDecl();
                if (variableName.rounded && variableDeclaration.getPNumber() != 0 || !variableDeclaration.isInteger() || variableDeclaration.getLogicLen() > 18) {
                    return false;
                }
                variableName = this.varByList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCode() {
        int n2;
        VariableName variableName;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isOptimizable()) {
            this.getCodeDebug(stringBuffer);
            VariableName variableName2 = this.varByList.getFirst();
            while (variableName2 != null) {
                stringBuffer.append(this.parent.getIndent());
                stringBuffer.append(variableName2.getCode());
                stringBuffer.append(".multiplyByMe(");
                if (this.num != null) {
                    stringBuffer.append(this.num.getAsLong());
                } else {
                    stringBuffer.append(this.var.getCode());
                    stringBuffer.append(".tolong()");
                }
                stringBuffer.append(");");
                stringBuffer.append(eol);
                variableName2 = this.varByList.getNext();
            }
            this.getCodeDebugEnd(stringBuffer);
            return stringBuffer.toString();
        }
        VariableNameList variableNameList = this.giving ? this.varGiving : this.varByList;
        boolean bl = this.var != null ? Expression.couldBeNativeInt(this.var.getVarDecl()) : Expression.couldBeNativeInt(this.num);
        if (bl && this.giving) {
            bl = this.tokenBy != null ? (bl &= Expression.couldBeNativeInt(this.tokenBy)) : (bl &= Expression.couldBeNativeInt(this.varByList.getFirst().getVarDecl()));
        }
        String string = "";
        if (variableNameList.getItemNum() > 1) {
            string = "mul$" + Multiply.getUniqueId();
            stringBuffer.append(this.parent.getIndent());
            if (bl) {
                stringBuffer.append("long ");
            } else {
                stringBuffer.append("CobolNum ");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(this.getInitialEvaluation(bl));
            stringBuffer.append(";");
            stringBuffer.append(eol);
        } else {
            string = this.getInitialEvaluation(bl);
        }
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        VariableNameList variableNameList2 = new VariableNameList();
        int n3 = 0;
        while (n3 < variableNameList.getItemNum()) {
            variableName = variableNameList.getAt(n3);
            if (variableName.isPrimitive()) {
                variableNameList2.addItem(variableName);
                variableNameList.deleteCurrent();
                continue;
            }
            ++n3;
        }
        n3 = variableNameList2.getItemNum();
        for (n2 = 0; n2 < n3; ++n2) {
            String string2;
            variableName = variableNameList2.getAt(n2);
            stringBuffer.append(variableName.getCode());
            String string3 = variableName.getType().getName(true);
            stringBuffer.append(" = ");
            if (this.giving) {
                if (bl) {
                    stringBuffer.append(Compute.addCast(string3, string));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string3, string));
                }
            } else if (Expression.couldBeNativeInt(variableName.getVarDecl())) {
                if (bl) {
                    string2 = string + " * " + variableName.getCode();
                    stringBuffer.append(Compute.addCast(string3, string2));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string3, string + ".multiply(CobolNum.noo((long) " + variableName.getCode() + ", 0))"));
                }
            } else if (bl) {
                string2 = string + " * ";
                string2 = variableName.isNumericVar() ? string2 + variableName.getCode() + ".tolong()" : string2 + variableName.getCode();
                stringBuffer.append(Compute.addCast(string3, string2));
            } else {
                string2 = string + ".multiply(";
                string2 = variableName.isNumericVar() ? string2 + variableName.getCode() + ".num())" : string2 + "CobolNum.noo((double) " + variableName.getCode() + "))";
                stringBuffer.append(Compute.getConversionMethod(string3, string2));
            }
            stringBuffer.append(";");
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(eol);
            stringBuffer.append(this.parent.getIndent());
        }
        n3 = variableNameList.getItemNum();
        if (n3 > 0) {
            if (variableNameList2.getItemNum() > 0) {
                stringBuffer.append(eol);
                stringBuffer.append(this.parent.getIndent());
            }
            stringBuffer.append(this.ose.getCodeBefore());
            for (n2 = 0; n2 < n3; ++n2) {
                variableName = variableNameList.getAt(n2);
                stringBuffer.append(variableName.getCode());
                stringBuffer.append(".set(");
                if (this.giving) {
                    stringBuffer.append(string);
                    if (bl) {
                        stringBuffer.append(",0");
                    }
                } else {
                    if (bl) {
                        stringBuffer.append("CobolNum.noo(");
                        stringBuffer.append(string);
                        stringBuffer.append(",0)");
                    } else {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(".multiply(");
                    stringBuffer.append(variableName.getCode());
                    stringBuffer.append(".num())");
                }
                stringBuffer.append(",");
                stringBuffer.append(variableName.rounded);
                stringBuffer.append(",");
                stringBuffer.append(this.ose.hasBlocks());
                stringBuffer.append(")");
                if (n2 >= n3 - 1) break;
                stringBuffer.append(this.ose.hasBlocks() ? "|" : ";");
            }
            stringBuffer.append(this.ose.getCode());
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarByList() {
        return this.varByList;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public Token getNum() {
        return this.num;
    }

    public Token getTokenBy() {
        return this.tokenBy;
    }

    public VariableName getVar() {
        return this.var;
    }
}

